Ext.define("thinclientuserreports.view.PodResultView",{
	extend:"Ext.panel.Panel",
	alias:"widget.podresultview",
	id:"podresultviewId",
	columnWidth:1.0,
	layout:'column',
	listeners:
	{
		afterrender:function(obj)
		{
			var jsonData = obj.data;
			console.log('jsonData   ',jsonData);
			var summaryObj = jsonData.summaryObj;
			var summaryTableColumns = jsonData.summaryTableColumns;
			var summaryTableDataList = jsonData.SummaryDataList;
			var mainGridCol = jsonData.mainTableColumns;
			var mainGriddata = jsonData.mainTableData;
			var mainColArray = new Array();
			var fields = new Array();
			var align = 'center';
			for(var index in summaryTableColumns)
			{
				var colsType = summaryTableColumns[index];
				if(index=='POOL_ID')
				{
					align = 'left';
				}
				else
				{
					align = 'center';
				}
		
				if(colsType instanceof Array)
				{
					var subColArray = new Array();
					for(var subIndex in colsType)
					{
						var header = colsType[subIndex];
						if(header.indexOf('#')>-1)
						{
							subIndex = header.substring(0,header.indexOf('#'));
							header = header.substring(header.indexOf('#')+1);
						}
						fields.push(subIndex);
						subColArray.push({
							header:header,
							sortable: true,
							align:align,
							width:125,
							dataIndex: subIndex,
							renderer:function(value, meta, record, rowIndex, colIndex, store)
							{
								meta.tdAttr = 'data-qtip="' + value + '"';
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1.indexOf('$$')>-1)
										{
											v1=v1.substring(0,v1.indexOf('$$'));
										}
										if(v2.indexOf('$$')>-1)
										{
											v2=v2.substring(0,v2.indexOf('$$'));
										}
										if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
										{
											var tmp = v1.substring(0, v1.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
										}
										if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
										{
											var tmp = v2.substring(0, v2.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime();
											v1=new Date(v1).getTime();
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							}
						});
					}
					mainColArray.push({
						header:index,
						columns: subColArray
					});
				}
				else
				{
					fields.push(index);
					mainColArray.push({
						header:colsType,
						sortable: true,
						align:align,
						dataIndex: index,
						renderer:function(value, meta, record, rowIndex, colIndex, store)
						{
							meta.tdAttr = 'data-qtip="' + value + '"';
							return value;
						},
						doSort: function(state) 
						{
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2)
								{
									v1 = v1.get(field);
									v2 = v2.get(field);
									if(v1.indexOf('$$')>-1)
									{
										v1=v1.substring(0,v1.indexOf('$$'));
									}
									if(v2.indexOf('$$')>-1)
									{
										v2=v2.substring(0,v2.indexOf('$$'));
									}
									if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
									{
										var tmp = v1.substring(0, v1.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
									}
									if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
									{
										var tmp = v2.substring(0, v2.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
									}
									if(!isNaN(v1) && !isNaN(v2))
									{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										if (state=='ASC')
										{
											v1= isNaN(v1) ? 999999 : v1;
											v2= isNaN(v2) ? 999999 : v2;
										}
										else
										{
											v1= isNaN(v1) ? 0 : v1;
											v2= isNaN(v2) ? 0 : v2;
										}
									}
									else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime();
										v1=new Date(v1).getTime();
									}
									// transform v1 and v2 here
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						}
					});
				}
			}
			var isPagingHidden;
			if (summaryTableDataList.length<5)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : 
				{
					type : 'pagingmemory',
					reader : {
						type: 'json', root : 'data', totalProperty : 'total'
					},
				},
				pageSize:5,
				autoLoad : true,
				remoteSort:true,
				data:summaryTableDataList,
			});
			var activePage=1; 
			this.add({
				xtype: 'customgrid',
				columnWidth:1.0,
				title:'Overview by Desktop Pools',
				store:storeObj,
				margin:'10 10 10 10',
				padding:'5 10 10 10',
				ui:'newGridPanel withHeader withShade',
				border:true,
				id:'overViewGrid',
				columns:mainColArray,
				scroll:false,
				forceFit: true,
				popUpData:'noTooltip',
				listeners:
				{
					sortchange:function(ct, column, e, t, eOpts )
					{
						me.gridColIndexParam=column.getIndex();
						me.gridColStateParam=column.sortState;
						this.getStore().loadPage(activePage);
					},
					render:function(obj)
					{
						Ext.defer(function() {
						//obj.columns[sortIndex].setSortState('DESC', true, false);
						},100);
					}
				},
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: 
					{
						change : function(thisd, params)
						{
							if(!Ext.isEmpty(params) && !isPagingHidden)
							{
								activePage = params.currentPage;
							}
							else
								activePage=1;
						}
					}
				}]
			});

			mainColArray = new Array();
			fields = new Array();
			align = 'left';
			for(var index in mainGridCol)
			{
				var colsType = mainGridCol[index];
				if(index=='POOL_ID' || index=='USERNAME' || index=='TRGT_HOST' || index=='DESKTOP')
				{
					align = 'left';
				}
				else
				{
					align = 'center';
				}
				if(colsType instanceof Array)
				{
					var subColArray = new Array();
					for(var subIndex in colsType)
					{
						var header = colsType[subIndex];
						if(header.indexOf('#')>-1)
						{
							subIndex = header.substring(0,header.indexOf('#'));
							header = header.substring(header.indexOf('#')+1);
						}
						fields.push(subIndex);
						subColArray.push({
							header:header,
							sortable: true,
							align:align,
							//width:135,
							dataIndex: subIndex,
							renderer:function(value, meta, record, rowIndex, colIndex, store)
							{
								meta.tdAttr = 'data-qtip="' + value + '"';
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1.indexOf('$$')>-1)
										{
											v1=v1.substring(0,v1.indexOf('$$'));
										}
										if(v2.indexOf('$$')>-1)
										{
											v2=v2.substring(0,v2.indexOf('$$'));
										}
										if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
										{
											var tmp = v1.substring(0, v1.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
										}
										if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
										{
											var tmp = v2.substring(0, v2.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime();
											v1=new Date(v1).getTime();
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							}
						});
					}
					mainColArray.push({
						header:index,
						columns: subColArray
					});
				}
				else
				{
					fields.push(index);
					mainColArray.push({
						header:mainGridCol[index],
						sortable: true,
						align:align, 
						dataIndex: index,
						renderer:function(value, meta, record, rowIndex, colIndex, store)
						{
							meta.tdAttr = 'data-qtip="' + value + '"';
							return value;
						},
						doSort: function(state) 
						{
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2)
								{
									v1 = v1.get(field);
									v2 = v2.get(field);
									if(v1.indexOf('$$')>-1)
									{
										v1=v1.substring(0,v1.indexOf('$$'));
									}
									if(v2.indexOf('$$')>-1)
									{
										v2=v2.substring(0,v2.indexOf('$$'));
									}
									if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
									{
										var tmp = v1.substring(0, v1.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
									}
									if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
									{
										var tmp = v2.substring(0, v2.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
									}
									if(!isNaN(v1) && !isNaN(v2))
									{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										if (state=='ASC')
										{
											v1= isNaN(v1) ? 999999 : v1;
											v2= isNaN(v2) ? 999999 : v2;
										}
										else
										{
											v1= isNaN(v1) ? 0 : v1;
											v2= isNaN(v2) ? 0 : v2;
										}
									}
									else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime();
										v1=new Date(v1).getTime();
									}
									// transform v1 and v2 here
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						}
					});
				}
			}
			if (mainGriddata.length<15)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var storeObj_main = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : 
				{
					type : 'pagingmemory',
					reader : 
					{
						type: 'json', root : 'data', totalProperty : 'total'
					},
				},
				pageSize:15,
				autoLoad : true,
				remoteSort:true,
				data:mainGriddata,
			});
			var activePage=1; 
			this.add({
				xtype: 'customgrid',
				columnWidth:1.0,
				title:'User Session details',
				store:storeObj_main,
				margin:'0 10 10 10',
				padding:'5 10 10 10',
				ui:'newGridPanel withHeader withShade',
				border:true,
				id:'mainGrid',
				sortableColumns:true,
				needtoFixColumn:true,
				columns:mainColArray,
				popUpData:'noTooltip',
				listeners:
				{
					sortchange:function(ct, column, e, t, eOpts )
					{
						me.gridColIndexParam=column.getIndex();
						me.gridColStateParam=column.sortState;
						this.getStore().loadPage(activePage);
					},
					render:function(obj)
					{
						Ext.defer(function() {
						//obj.columns[sortIndex].setSortState('DESC', true, false);
						},100);
					}
				},
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'pagingtoolbar',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj_main,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: 
					{
						change : function(thisd, params)
						{
							if(!Ext.isEmpty(params) && !isPagingHidden)
							{
								activePage = params.currentPage;
							}
							else
								activePage=1;
						}
					}
				}]
			});
		}
	}
});