// JavaScript Document
Ext.Loader.setConfig({
	enable:true,
	disableCaching:false,
	garbageCollect:true,
	preserveScripts:false
});
Ext.Ajax.timeout=ajaxTimeout;
Ext.Ajax.disableCaching=false;
registerAjaxExceptionEvent();
Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux');

Ext.application({
		name:'thinclientzonereports',
		requires:['thinclientzonereports.view.Main','utilities.TimeLineSave'],
		controllers: ['thinclientzonereports.controller.ThinclientZoneReports'],
		appFolder:['../reporter/scripts/ThinclientZoneApp/'],

		launch:function(){
					appConstants.appObj = this;
					appConstants.appController='thinclientzonereports.controller.ThinclientZoneReports';
 					//Firefox  version > 18 hack
					if (Ext.firefoxVersion >= 18) {
                    var noArgs = [];
                    Ext.override(Ext.Base, {
                        callParent : function(args) {
 
 
                            var method, superMethod = (method = this.callParent.caller) &&
                                    (method.$previous || ((method = method.$owner ?
                                            method :
                                            method.caller) && method.$owner.superclass[method.$name]));
                            try {
                            } catch (e) {
                            }
 
 
                            return superMethod.apply(this, args || noArgs);
                        }
                    });
                };
				var URL = '/final/reporter/ErCtxZoneReportJSON.jsp';
				if ( appConstants.isFormSubmit == 'true' )
				{
					URL = '/final/servlet/com.eg.ErCtxServerReportC';
					appConstants.defaultQStr = 'call=json&'+appConstants.defaultQStr;
//					defaultQStr += '&call=json';
				}
				Ext.Ajax.request({
					url: URL,
					method: 'POST',
					params: appConstants.defaultQStr,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							appConstants.publicJSON = jsonData;
							Ext.create('Ext.container.Viewport',{
								layout:'fit',
								items:[
									{ 
										xtype:'main'
										
									}
								]
							});
							Ext.get('loadmask').remove();
						}
						console.log(" app load func ends   @ "+new Date().getTime());
					}
				});
			}
		
	});