	Ext.define('thinclientzonereports.controller.ThinclientZoneReports', {
	extend: 'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
	gridColIndexParam:-1,//added for updating sort by option
	views: ['Main', 'utilities.TimePeriod'],
	refs: [{
		selector: 'main',
		ref: 'main'
	}, {
		selector: 'newUtilities',
		ref: 'newUtilities'
	},{
		selector: 'thinclientzonereportsform',
		ref: 'thinclientzonereportsform'
	}, {
		selector: 'thinclientzonesettings',
		ref: 'thinclientzonesettings'
	}, {
		selector: 'timeperiod',
		ref: 'timeperiod'
	},
	{selector:'nomeasurepanel', ref:'nomeasurepanel'},
	{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init: function () {
		this.control({

			'newUtilities': {
				'afterrender': this.loadTools
			},
			'main': {
				'boxready': this.afterMainRender
			},
			'thinclientzonereportsform': {
				'afterrender': this.loadMainElements
			},
			'thinclientzonesettings': {
				'afterrender': this.loadSettingsElements
			},
			'thinclientzonereportsform combo[id="er_type"]': {
				'select': this.changeReportType
			},
			'thinclientzonereportsform combo[id="select_farm"]': {
				'select': this.changeZone
			},
			'thinclientzonereportsform combo[id="er_comptype"]': {
				'select': this.changeCompType
			},
			/* 'thinclientzonesettings combo[id="er_excwe"]': {
				'select': this.changeExcludeWeekEnds
			}, */
			'thinclientzonesettings combo[id="reportGeneration"]': {
				'select': this.changeReportGenerationType
			},
			'thinclientzonesettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'thinclientzonesettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'thinclientzonereportsform button[id="submit"]': {
				'click': this.showResult
			},
			'thinclientzonereportsform button[id="save"]': {
				 "click": this.addTo
			},
			'thinclientzonesettings combo[id="er_trenddata"]': {
				'select': this.changeDetailedOrTrend
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'thinclientzonereportsform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities > #saveTool > button': {
				'click': this.saveMe
			},
			'newUtilities > #printTool > button': {
				'click': this.printMe
			},
			'newUtilities > #mailTool > button': {
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button': {
				'click': this.callCSV
			},
			'newUtilities > #scheduleTool > button': {
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button': {
				'click': this.showFavorites
			}
		});
	},
	addTo : function(obj){
	// by karthikeyan
	if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
						title : alert_text,
						msg : 'Chosen timeline not allowed',
						buttons : Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
					});
				return;
		}
		var from_schedule = appConstants.publicJSON["hiddens"]["fromScheduleModify"];
		if (from_schedule != null && from_schedule == "Yes")
		{
			this.showSchedules(obj);
		/*	var qStringForSchedule = this.genQueryString();
			var target= '/final/reporter/ErSaveSchedule.jsp?' + qStringForSchedule ;
			document.location=target+'&showSchWindow=no';
			*/
		} 
		else 
		{
			 this.showFavorites(obj);
			/*var favorite_id = appConstants.publicJSON["hiddens"]["favorite_id"];
			var target = '/final/servlet/com.eg.ErFavoriteC?' + appConstants.queryString +"&FavoriteId="+favorite_id;
			document.location=target+'&showWindow=no';
			*/
		}
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);
			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	showFavorites: function (obj) {
		 var queryString = this.genQueryString();
		var target = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&cmd=client'+"&er_RmDispName="+appConstants.er_RmDispName+'&com.eg.CSRF_NONCE='+csrfToken;
		appConstants.formButtonId = obj.getId();
		var favorite_id = appConstants.publicJSON["hiddens"]["favorite_id"];
		if (appConstants.formButtonId=='save')
		{ 
			//document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			target+='&showSchWindow=no'+"&FavoriteId="+favorite_id;

			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}   
		else
		{ 
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}

	},
	showSchedules: function (obj) {
		var from_schModify = appConstants.publicJSON["hiddens"]["fromScheduleModify"];
		var qStringForSchedule = this.genQueryString();
	//	if (from_schModify != null && from_schModify == "Yes") {
			appConstants.queryString = qStringForSchedule;//+"&isForceSubmit=true";
	//	}
	appConstants.formButtonId = obj.getId();
		var target= '/final/reporter/ErSaveSchedule.jsp?' + appConstants.queryString+'&com.eg.CSRF_NONCE='+csrfToken;
		if (appConstants.formButtonId=='save')
		{
		target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	changeEr_mode: function (combo) {
		var favorite_id = appConstants.publicJSON['hiddens']["favorite_id"];
		var from_schModify = appConstants.publicJSON['hiddens']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if(Ext.get('configMod')!=null && Ext.get('configMod')!='undefined'){
		Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		}
		this.formSubmit(Ext.getCmp('submit'));
	 },
	callCSV: function () {
		var queryString = this.genQueryString();
		document.location = '/final/servlet/egurkha.reporter.SaveInCSVFormat';
	},
	sendMail: function () {
		Ext.widget('sendmail').show();
	},
	printMe: function () {
		//Ext.widget('print').show();
		//var printContentDiv = Ext.select('#printContentDiv');
		var queryString = this.genQueryString();
		queryString += '&printGraph=yes&pdfPrint=yes';
		var reportType = Ext.getCmp('er_type').getValue();
		if (reportType == 'No') {
			queryString += '&er_view=PRINT';
		}
	  var  s_qryString='../servlet/com.eg.ErCtxServerReportC?' + queryString;
	  s_qryString=this.getGridColSortParam(s_qryString);

		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	saveMe: function () {
		var queryString = this.genQueryString();
		var pgLength = appConstants.publicJSON.pageWidthProces;
		queryString += '&pageWidthProces='+pgLength+'&printGraph=yes';
		var reportType = Ext.getCmp('er_type').getValue();
		if (reportType == 'No') {
			queryString += '&er_view=PRINT';
		}
		//document.location = '/final/reporter/ErHtmlToSavePdf.jsp?'+queryString;
		queryString=this.getGridColSortParam(queryString);
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF('/final/reporter/ErHtmlToSavePdf.jsp?' + queryString);
	},
    checkResult: function () {
        var getResultPanel = this.getMain().getComponent('result');
        /*if (getResultPanel.hidden) {
            Ext.getCmp('upbutton').setDisabled(true);
        } else {
            Ext.getCmp('upbutton').setDisabled(false);
        }*/
    },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('thinclientzonereportsform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	loadMask: function () {
		initLdgMask.show();
	},
	loadMainElements: function () {
		var me = this;
		var mainForm = this.getThinclientzonereportsform().getForm();
		var screenLabels = appConstants.publicJSON['screenLabels'];

	var hiddenFields = appConstants.publicJSON["hiddens"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var from_favourite = hiddenFields["fromFavoriteModify"];
		if (from_schedule != null && from_schedule == "Yes" || from_favourite != null && from_favourite == "Yes") {
		Ext.getCmp("submit").hide();
		Ext.getCmp("save").show();
		Ext.getCmp("favoriteTool").setDisabled(true);
		Ext.getCmp("scheduleTool").setDisabled(true);
	}else{
		Ext.getCmp("submit").show();
		Ext.getCmp("save").hide();
	}
		if (appConstants.publicJSON.showDataSelected=='Trend')
		{
			isTrend=true;
		}
		if (!Ext.isEmpty(appConstants.publicJSON['zoneArr'])) {
			var zoneArrData = appConstants.publicJSON['zoneArr'];
			var zoneObj = mainForm.findField('select_farm');
			zoneObj.setFieldLabel(screenLabels['reporter.thin.Zone']);
			zoneObj.suspendEvents(true);
			zoneObj.getStore().clearFilter(true);
			zoneObj.getStore().loadRawData(zoneArrData);
			if (!Ext.isEmpty(appConstants.publicJSON['zoneArrSelected'])) {
				var zoneArrSelected = appConstants.publicJSON['zoneArrSelected'];
				zoneObj.setValue(zoneArrSelected);
			} else {
				zoneObj.setValue(zoneArrData[0].valueField);
			}
			me.changeZone();
			zoneObj.resumeEvents();
		}
		if (!Ext.isEmpty(appConstants.publicJSON['compTypeArr'])) {
			var compTypeArrData = appConstants.publicJSON['compTypeArr'];
			var er_comptypeObj = mainForm.findField('er_comptype');
			er_comptypeObj.setFieldLabel(screenLabels['reporter.thin.ComponentType']);

			er_comptypeObj.suspendEvents(true);
			er_comptypeObj.getStore().clearFilter(true); 
			er_comptypeObj.getStore().loadRawData(compTypeArrData);
			if((appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true') && appConstants.analysisby != null && appConstants.analysisby == 'ComponentType')
				er_comptypeObj.setValue(appConstants.analysis);
			else{
				if (!Ext.isEmpty(appConstants.publicJSON['compTypeSelected'])) {
					er_comptypeObj.setValue(appConstants.publicJSON['compTypeSelected']);
				} else {
					er_comptypeObj.setValue(compTypeArrData[0].valueField);
				}
			}
			me.changeCompType();
			er_comptypeObj.resumeEvents();
		}
		if (!Ext.isEmpty(appConstants.publicJSON['gTypeArr'])) {
			var gTypeArrData = appConstants.publicJSON['gTypeArr'];
			var er_typeObj = mainForm.findField('er_type');
			er_typeObj.setFieldLabel(screenLabels['reporter.thin.ReportType']);
			er_typeObj.suspendEvents(true);
			er_typeObj.getStore().loadRawData(gTypeArrData);
			if (!Ext.isEmpty(appConstants.publicJSON['gTypeSelected'])) {
				er_typeObj.setValue(appConstants.publicJSON['gTypeSelected']);
			} else {
				er_typeObj.setValue(gTypeArrData[0].valueField);
			}
			er_typeObj.resumeEvents();
		}
		if (!Ext.isEmpty(appConstants.publicJSON['testMeasArr'])) {
			var testMeasArrData = appConstants.publicJSON['testMeasArr'];
			var select_testmesObj = mainForm.findField('select_testmes');
			select_testmesObj.setFieldLabel(screenLabels['reporter.common.Criteria']);
			select_testmesObj.suspendEvents(true);
			select_testmesObj.getStore().clearFilter(true);
			select_testmesObj.getStore().loadRawData(testMeasArrData);
			if (!Ext.isEmpty(appConstants.publicJSON['testMeasSelected'])) {
				select_testmesObj.setValue(appConstants.publicJSON['testMeasSelected']);
			} else {
				select_testmesObj.setValue(testMeasArrData[0].valueField);
			}
			select_testmesObj.resumeEvents();
			if (er_typeObj.getValue() == 'Yes') 
			{
				Ext.getCmp('select_testmes').show();
			}
			else
			{
				Ext.getCmp('select_testmes').hide();
			}
		}
		var screenLabels = appConstants.publicJSON['screenLabels'];
		 if (!Ext.isEmpty(appConstants.publicJSON['timelineCombo'])) {
			var timelineComboData = appConstants.publicJSON['timelineCombo'];
			var er_timelineObj = mainForm.findField('er_timeline');

			er_timelineObj.suspendEvents(true);
			er_timelineObj.getStore().loadRawData(timelineComboData);
			if (!Ext.isEmpty(appConstants.publicJSON['selectedTimeline'])) {
				er_timelineObj.setValue(appConstants.publicJSON['selectedTimeline']);
			} else {
				er_timelineObj.setValue(er_timelineObj.getStore().getAt(0).get('valueField'));
			}
			er_timelineObj.resumeEvents();
			me.changeTimeline();
		}
		if (!Ext.isEmpty(appConstants.publicJSON['startDate'])) {
			var er_stdateObj = mainForm.findField('er_stdate');

			er_stdateObj.suspendEvents(true);
			er_stdateObj.setValue(appConstants.publicJSON['startDateForDisplay']);
			er_stdateObj.dataArray = appConstants.publicJSON['startDate'];
			er_stdateObj.resumeEvents();
		}
		if (!Ext.isEmpty(appConstants.publicJSON['endDate'])) {
			var er_enddateObj = mainForm.findField('er_enddate');

			er_enddateObj.suspendEvents(true);
			er_enddateObj.setValue(appConstants.publicJSON['endDateForDisplay']);
			er_enddateObj.dataArray = appConstants.publicJSON['endDate'];
			er_enddateObj.resumeEvents();
		}
		 var er_sthrObj = mainForm.findField('er_sthr');
			  if (!Ext.isEmpty(appConstants.publicJSON['startHour'])) {
				er_sthrObj.setValue(appConstants.publicJSON['startHourForDisplay']);
				er_sthrObj.dataArray = appConstants.publicJSON['startHour'];
			} else {
				er_sthrObj.setValue(er_sthrObj.getStore().getAt(0).get('valueField'));
			}
			 var er_endhrObj = mainForm.findField('er_endhr');
			 if (!Ext.isEmpty(appConstants.publicJSON['endHour'])) {
				er_endhrObj.setValue(appConstants.publicJSON['endHourForDisplay']);
				er_endhrObj.dataArray = appConstants.publicJSON['endHour'];
			} else {
				er_endhrObj.setValue(er_sthrObj.getStore().getAt(0).get('valueField'));
			}
		stmin = appConstants.publicJSON['startMinForDisplay'];
		enmin = appConstants.publicJSON['endMinForDisplay'];
		mgr_stmin = appConstants.publicJSON.startmin;
		mgr_enmin = appConstants.publicJSON.endmin;
		  updatingAppSettings();
		if (!Ext.isEmpty(appConstants.publicJSON['selectedGraphMode'])) {
			var er_modeObj = mainForm.findField('er_mode');

			er_modeObj.suspendEvents(true);
			er_modeObj.setValue(appConstants.publicJSON['selectedGraphMode']);
			er_modeObj.resumeEvents();
		}
	},
		 disableTools: function () {
		  Ext.getCmp("bookletTool").setDisabled(true);
		  Ext.getCmp("saveTool").setDisabled(true);
		  Ext.getCmp("printTool").setDisabled(true);
		  Ext.getCmp("mailTool").setDisabled(true);
		  Ext.getCmp("csvTool").setDisabled(true);
	 },
	loadSettingsElements: function () {
		var favorite_id = appConstants.publicJSON["hiddens"]["favorite_id"];
		 if (!Ext.isEmpty(favorite_id))
		 {
			Ext.getCmp('reportGeneration').setDisabled(true);
		 }
		this.disableTools();
		Ext.getCmp('moreOptionCloseId').show();
		var me = this;
		var settingsForm = this.getThinclientzonesettings().getForm();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		if (!Ext.isEmpty(appConstants.publicJSON['showArr'])) {
			var showArrData = appConstants.publicJSON['showArr'];
			var er_priorityObj = settingsForm.findField('er_priority');
			er_priorityObj.setFieldLabel(screenLabels['reporter.comparison.Show']);
			er_priorityObj.suspendEvents(true);
			er_priorityObj.getStore().loadRawData(showArrData);
			er_priorityObj.setValue(showArrData[0].valueField);
			er_priorityObj.resumeEvents();
		}
		if (appConstants.publicJSON['showDataSelected']=='Trend')
		{
			isTrend=true;
		}
		if (!Ext.isEmpty(appConstants.publicJSON['showDataArr'])) {
			var showDataArrData = appConstants.publicJSON['showDataArr'];
			var er_trenddataObj = settingsForm.findField('er_trenddata');
			er_trenddataObj.setFieldLabel(screenLabels['reporter.common.showData']);

			er_trenddataObj.resumeEvents(true);
			er_trenddataObj.getStore().loadRawData(showDataArrData);
			if (!Ext.isEmpty(appConstants.publicJSON['showDataSelected'])) {
				er_trenddataObj.setValue(appConstants.publicJSON['showDataSelected']);
			} else {
				er_trenddataObj.setValue(showDataArrData[0].valueField);
			}
			er_trenddataObj.suspendEvents();
			me.changeDetailedOrTrend();
			var trendenablee=appConstants.publicJSON.hiddens['trendenable'];
			if(trendenablee == 'false'){
				Ext.getCmp('er_trenddata').hide();
			}
			else
			{
				Ext.getCmp('er_trenddata').show();
			}
		}
		if (!Ext.isEmpty(appConstants.publicJSON['excludeWeekArr'])) {
			var excludeWeekArrData = appConstants.publicJSON['excludeWeekArr'];
			var er_excweObj = settingsForm.findField('er_excwe');
			er_excweObj.setFieldLabel(screenLabels['reporter.common.excludeweekends']);
			er_excweObj.suspendEvents(true);
			er_excweObj.getStore().loadRawData(excludeWeekArrData);
			if (!Ext.isEmpty(appConstants.publicJSON['excludeWeekSelected'])) {
				er_excweObj.setValue(appConstants.publicJSON['excludeWeekSelected']);
			} else {
				er_excweObj.setValue(excludeWeekArrData[0].valueField);
			}
			if (!Ext.isEmpty(appConstants.publicJSON['excludeMessage'])) {
				var excludeMessageData = appConstants.publicJSON['excludeMessage'];
				// var excludeDaysObj =Ext.getCmp('excludeDays');
				//excludeDaysObj.update(excludeMessageData);
			}
			er_excweObj.resumeEvents();
			//me.changeExcludeWeekEnds();
		}
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Timeperiod']);
		Ext.getCmp('fromTimeLbl').setText(screenLabels['reporter.common.From']);
		Ext.getCmp('fromHrsLbl').setText(screenLabels['reporter.common.Hrs']);
		Ext.getCmp('fromMinsLbl').setText(screenLabels['reporter.common.Mins']);
		Ext.getCmp('toTimeLbl').setText(screenLabels['reporter.common.From']);
		Ext.getCmp('toHrsLbl').setText(screenLabels['reporter.common.Hrs']);
		Ext.getCmp('toMinsLbl').setText(screenLabels['reporter.common.Mins']);
		var timefromObj = settingsForm.findField('timefrom');
		timefromObj.suspendEvents(true);
		if (!Ext.isEmpty(appConstants.publicJSON['timePeriodHourFromSelected'])) {
			timefromObj.setValue(appConstants.publicJSON['timePeriodHourFromSelected']);
		} else {
			timefromObj.setValue(timefromObj.getStore().getAt(0).get('valueField'));
		}
		timefromObj.resumeEvents();

		var minfromObj = settingsForm.findField('minfrom');
		minfromObj.suspendEvents(true);
		if (!Ext.isEmpty(appConstants.publicJSON['timePeriodMinFromSelected'])) {
			minfromObj.setValue(appConstants.publicJSON['timePeriodMinFromSelected']);
		} else {
			minfromObj.setValue(minfromObj.getStore().getAt(0).get('valueField'));
		}
		minfromObj.resumeEvents();
		var timetoObj = settingsForm.findField('timeto');
		timetoObj.suspendEvents(true);
		if (!Ext.isEmpty(appConstants.publicJSON['timePeriodHourToSelected'])) {
			timetoObj.setValue(appConstants.publicJSON['timePeriodHourToSelected']);
		} else {
			timetoObj.setValue(timetoObj.getAt(0).get('valueField'));
		}
		timetoObj.resumeEvents();
		var mintoObj = settingsForm.findField('minto');
		mintoObj.suspendEvents(true);
		if (!Ext.isEmpty(appConstants.publicJSON['timePeriodMinToSelected'])) {
			mintoObj.setValue(appConstants.publicJSON['timePeriodMinToSelected']);
		} else {
			mintoObj.setValue(timetoObj.getAt(0).get('valueField'));
		}
		mintoObj.resumeEvents();

		if (!Ext.isEmpty(appConstants.publicJSON['reportGenArr'])) {
			var reportGenArrData = appConstants.publicJSON['reportGenArr'];
			var reportGenerationObj = settingsForm.findField('reportGeneration');
			reportGenerationObj.suspendEvents(true);
			reportGenerationObj.getStore().loadRawData(reportGenArrData);
			reportGenerationObj.setFieldLabel(screenLabels['reporter.consolidated.ReportGeneration']);
			if (!Ext.isEmpty(appConstants.publicJSON['reportGenSelected'])) {
				reportGenerationObj.setValue(appConstants.publicJSON['reportGenSelected']);
			}
			reportGenerationObj.resumeEvents();
			if (!Ext.isEmpty(appConstants.publicJSON['bg_reportnameVal'])) {
				var bgReportNameObj = settingsForm.findField('bgReportName');
				bgReportNameObj.suspendEvents(true);
				bgReportNameObj.setValue(appConstants.publicJSON['bg_reportnameVal']);
				bgReportNameObj.resumeEvents();
			}
			me.changeReportGenerationType();
		}
		var me = this;
		Ext.get('closeSettings').on('click', function () {
			me.validateAndCloseSettings();
		});
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if (isSettingsOk) {
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({
				duration: 500,
				to: {
					y: -530
				}
			});
			return true
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	showConfigDropdown:function(){

			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			//layout:'vbox',
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
							xtype:'container',
							cls:'configMode_popupArrow',
							style:{'top':'-14px','left':'355px'}
						},
						{
							xtype:'container',
							html:tpl.apply(),
							cls:'containerHeader',
							style:{'top':'0px','margin':'0px'}
						},
						{
							xtype : 'thinclientzonesettings',
							parent:this
						}
			],
			renderTo:'thinclientzone-body'
			});
	},
	validateSettings: function () {
		var isSettingsOk = true;
		var settingsForm = this.getThinclientzonesettings().getForm();
		var reportgen =settingsForm.findField('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background'  || reportgen == 'background-csv')) {
			var reportName = settingsForm.findField('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult: function (btn) {
		if (btn == "yes") {
			var getButtonObj = Ext.getCmp('submit');
			this.formSubmit(getButtonObj);
		} else {
		if(!isSettingsEnabled)
			this.showConfigDropdown();
			var settingsForm = this.getThinclientzonesettings().getForm();
			var reportGenType = settingsForm.findField('reportGeneration');
			var bgreportNameObj = settingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	afterMainRender: function () {
	  var me = this;
	if(!hideBackButton){
		Ext.getCmp('thinclientzonereportsform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicJSON['ID']
			}
		);
	}
		me.changeReportType();
		  var resultsData = appConstants.publicJSON['results'];
		if (!Ext.isEmpty(resultsData)) {
			var getTitle = resultsData['TITLE'];
			 if (!Ext.isEmpty(getTitle)) {
				 Ext.getCmp('graphpanel').setTitle(getTitle);
			}
			if (appConstants.publicJSON['gTypeSelected'] == 'Graph' || appConstants.publicJSON["gTypeSelected"] == "Yes") {
				var pieChartURL = resultsData['pieChartURL'];
				 var barChartURL = resultsData['barChartURL'];
				if (!Ext.isEmpty(pieChartURL) && !Ext.isEmpty(barChartURL)) {
				var selectionDetailsData = appConstants.publicJSON['selectionDetails'];
					me.loadCharts(pieChartURL, barChartURL,selectionDetailsData);
				} else {
					this.disableTools();
					Ext.getCmp('graphpanel').hide();
					Ext.getCmp('datacontainer').hide();
					this.getNomeasurepanel().show();
				}
			} else {
					var gridData = appConstants.publicJSON['GRID_DATA'];
					var selectionDetailsData = appConstants.publicJSON['selectionDetails'];
					me.loadGrid(gridData,selectionDetailsData);
			}
			Ext.getCmp('bookletTool').setDisabled(false);
			Ext.getCmp('saveTool').setDisabled(false);
			Ext.getCmp('printTool').setDisabled(false);
			Ext.getCmp('mailTool').setDisabled(false);
			 if (appConstants.publicJSON['gTypeSelected'] == 'Yes') {
				 Ext.getCmp('csvTool').setDisabled(true);
			} else {
				Ext.getCmp('csvTool').setDisabled(false);
			}
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);

		}else{
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
			 if (appConstants.publicJSON["gTypeSelected"] == "Yes") {
				Ext.getCmp("csvTool").setDisabled(true);
			} else {
				Ext.getCmp("csvTool").setDisabled(false);
			}
			this.disableTools();
		}
		if(appConstants.isForceSubmit=='true')
		{
			this.formSubmit(Ext.getCmp('submit'));
			appConstants.isForceSubmit='false';
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);

		if(appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true')
			this.showResult();
	},
	loadCharts: function (pieChartURL, barChartURL,selectionDetailsData) {
		var URL = pieChartURL.substring(0, pieChartURL.indexOf('?'));
		var param = pieChartURL.substring(pieChartURL.indexOf('?') + 1);
		var datacontainer =Ext.getCmp('datacontainer');
		var graphpanel =Ext.getCmp('graphpanel');
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		graphpanel.show();
		datacontainer.hide();
		 var chartAvailable = false;
		 if (!Ext.isEmpty(URL)) {
			graphpanel.show();
			graphpanel.removeAll();
			  Ext.Ajax.request({
				url: URL,
				params: param,
				method: 'POST',
				async: false,
				success: function (response) {
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var pieChartResults = jsonData['pieChartResult'];
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						if (!Ext.isEmpty(pieChartResults)) {
							chartAvailable = true;
							var Title = pieChartResults['TITLE'];
							var swfPath = pieChartResults['SWFPATH'];
							var xmlData = pieChartResults['XMLDATA'];
							if (!Ext.isEmpty(pieChartResults['LEGENDS'])) {
								var legendsData = pieChartResults['LEGENDS'];
								getPieChartHiddens = pieChartResults['HIDDENS'];                               
								graphpanel.add(
									{
										xtype: 'panel',
										//cls:'containerShadow',
										ui:'newGraphPanel',
										id:'leftChartContainer',
										columnWidth:0.35,
										title:Title,
										height:350,
										margin:'0 10 10 10'
									}
								);
							}
							appConstants.erUtils.updatePieChart(appConstants.chartType,legendsData,'LEGEND_COLOR','LEGEND_LINK','LEGEND_LABEL',null,xmlData,swfPath,pieChartResults,Ext.getCmp('leftChartContainer'));
						}
					}
				}
			});
		}
		if (chartAvailable) {
			var barURL = barChartURL.substring(0, barChartURL.indexOf('?'));
			var param = barChartURL.substring(barChartURL.indexOf('?') + 1);
			Ext.Ajax.request({
				url: barURL,
				params: param,
				method: 'POST',
				async: false,
				success: function (response) {
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var barChartResultData = jsonData['barChartResult'];
						var reportData=jsonData['reportData'];
						if (!Ext.isEmpty(barChartResultData)) {
							var getHiddens = barChartResultData['HIDDENS'];
							if (!Ext.isEmpty(getHiddens)) {
								getBarChartHiddens = getHiddens;
							}
							var swfPath = barChartResultData['SWFPATH'];
							var xmlData = barChartResultData['XMLDATA'];
							var title = barChartResultData['TITLE'];
							var chartHeight = barChartResultData['CHART_HEIGHT'];
							graphpanel.add(
							{
								xtype: 'panel',
								columnWidth:0.65,
								ui:'newGraphPanel',
								autoScroll:true,
								margin:'0 10 10 0',
								title:title,
								height:350,
								id:'rightChartContainer',
								//cls:'containerShadow'
							});
							appConstants.erUtils.updateBarChart(appConstants.chartType,null,xmlData,swfPath,reportData,reportData.chartHeight-5,reportData.chartWidth,Ext.getCmp('rightChartContainer'));
						}
					}
				}
			});
			Ext.getCmp('selectionDetails').setSelectionDetailsData(selectionDetailsData);
		} else {
				this.disableTools();
				graphpanel.hide();
				Ext.getCmp('datacontainer').hide();
				this.getNomeasurepanel().show();
		}
	 },
	changeReportGenerationType: function () {
		var reportGenerationVal = Ext.getCmp('reportGeneration').getValue();
		if (reportGenerationVal == 'background') {
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if (reportGenerationVal == 'background-csv') {
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		} 
		else {
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	   Ext.getCmp('datacontainer').hide();
	   Ext.getCmp('graphpanel').hide();
	},

	changeTimeline: function (obj) {
		var mainForm = this.getThinclientzonereportsform().getForm();
		var er_timelineObj = mainForm.findField('er_timeline');
		var er_stdateObj = mainForm.findField('er_stdate');
		var er_sthrObj = mainForm.findField('er_sthr');
		var er_enddateObj = mainForm.findField('er_enddate');
		var er_endhrObj = mainForm.findField('er_endhr');

		if (er_timelineObj.getValue() == 'Any') {
			er_stdateObj.setDisabled(false);
			er_sthrObj.setDisabled(false);
			er_enddateObj.setDisabled(false);
			er_endhrObj.setDisabled(false);
		} else {
			er_stdateObj.setDisabled(true);
			er_sthrObj.setDisabled(true);
			er_enddateObj.setDisabled(true);
			er_endhrObj.setDisabled(true);
			if (!Ext.isEmpty(obj)) {
				this.formSubmit(obj);
			}
		}
		Ext.getCmp('datacontainer').hide();
	   Ext.getCmp('graphpanel').hide();
	},
	/* changeExcludeWeekEnds: function (obj) {
		var er_excweObj = Ext.getCmp('er_excwe');
		if (er_excweObj.getValue() == 'Yes') {
			Ext.getCmp('excludeDays').show();
		} else {
			Ext.getCmp('excludeDays').hide();
		}
		if (!Ext.isEmpty(obj)) {
			this.formSubmit(obj);
		}
		Ext.getCmp('datacontainer').hide();
	   Ext.getCmp('graphpanel').hide();
	},*/
	changeDetailedOrTrend: function (obj) {
		 Ext.getCmp('datacontainer').hide();
	   Ext.getCmp('graphpanel').hide();
	   // if (!Ext.isEmpty(obj)) {
		 //   this.formSubmit(obj);
	   // }
		var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getThinclientzonesettings().getForm();
		var trendVal =this.getSettingsFieldValue(settingsForm,'er_trenddata',isSettingsEnabled,'showDataSelected');

		var er_trenddata;
		if(trendVal=='Detailed')
		{
			er_trenddata='No';
		}
		else
		{
			er_trenddata='Yes';
		}
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = appConstants.publicJSON.hiddens.inidate;
			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}
	},
	changeZone: function (obj,newValue,oldValue) {


		if(oldValue==undefined || oldValue=='undefined')
				{
					return false;
				}

		 Ext.getCmp('datacontainer').hide();
	   Ext.getCmp('graphpanel').hide();
		if (!Ext.isEmpty(obj)) {
			if (obj.getValue() != '-1') {
				Ext.getCmp('select_testmes').show();
				this.formSubmit(obj);
			} else {
				this.insertNotApplicable(Ext.getCmp('er_comptype'));
				Ext.getCmp('select_testmes').hide();
			}
		}
		var er_typeObj = Ext.getCmp('er_type');
		if (er_typeObj.getValue() == 'Yes') 
		{
			Ext.getCmp('select_testmes').show();
		}
		else
		{
			Ext.getCmp('select_testmes').hide();
		}
	},
	insertNotApplicable: function (obj) {
		obj.getStore().removeAll();
		var tmpStore = obj.getStore();
		tmpStore.insert(0, {
			displayField: appConstants.notApplicable,
			valueField: '-1'
		});
		obj.setValue('-1');
	},
	changeCompType: function (obj) {
		Ext.getCmp('datacontainer').hide();
	   Ext.getCmp('graphpanel').hide();
		if (!Ext.isEmpty(obj)) {
			this.formSubmit(obj);
		}
	},
	changeReportType: function (obj,newValue,oldValue){
			if(oldValue==undefined || oldValue=='undefined')
				{
			      console.log('Test________came');
					return false;
				}

		var er_typeObj = Ext.getCmp('er_type').getValue();
					Ext.Ajax.request({
				url: '/final/reporter/ErCtxZoneReportJSON.jsp?&er_type='+er_typeObj,
				params: appConstants.queryString,
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.repotgene=jsonData;
					if(isSettingsEnabled)
					{
						var reportGenArrData = jsonData['reportGenArr'];
						var reportGenerationObj = Ext.getCmp('reportGeneration');
						reportGenerationObj.suspendEvents(true);
						reportGenerationObj.getStore().loadRawData(reportGenArrData);
						var setRepoGen = jsonData['reportGenSelected'];
						if (!Ext.isEmpty(setRepoGen)) {
							reportGenerationObj.setValue(setRepoGen);
						}
						var reportNameObj = Ext.getCmp('bgReportName');
						if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
						{
							reportNameObj.hide();
							Ext.getCmp('moreOptionCloseId').show();
							Ext.getCmp('submitViaSetting').hide();
						}
						else
						{
							reportNameObj.show();
							Ext.getCmp('submitViaSetting').show();
							Ext.getCmp('moreOptionCloseId').hide();
						}

					}
		if (er_typeObj == 'Yes') {
			Ext.getCmp('select_testmes').show();
		if(Ext.getCmp('er_priority')!=undefined)
			   Ext.getCmp('er_priority').show();
		 } else {
			Ext.getCmp('select_testmes').hide();
		if(Ext.getCmp('er_priority')!=undefined)
			 Ext.getCmp('er_priority').hide();
		 }

		 Ext.getCmp('datacontainer').hide();
	   Ext.getCmp('graphpanel').hide();
	}
	});
	},
	genQueryString: function () {
		var mainForm = this.getThinclientzonereportsform().getForm();

		var settingsForm =null;
	if(isSettingsEnabled)
		settingsForm = this.getThinclientzonesettings().getForm();
		var starthr = mainForm.findField('er_sthr').getValue();
		var endhr = mainForm.findField('er_endhr').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();

		var timefrom =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodHourFromSelected');
		var timeto =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodHourToSelected');
		var minFrom =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodMinFromSelected');
		var minto =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodMinToSelected');

		var trendVal =this.getSettingsFieldValue(settingsForm,'er_trenddata',isSettingsEnabled,'showDataSelected');
		var er_excwe =this.getSettingsFieldValue(settingsForm,'er_excwe',isSettingsEnabled,'excludeWeekSelected');
		var er_priority =this.getSettingsFieldValue(settingsForm,'er_priority',isSettingsEnabled,'showSelected');
		var er_reportgenration =this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');

		var er_trenddata = '';
		var trendenable = false;
		if ( trendVal== 'Trend') {
			er_trenddata = 'Yes'
			trendenable = true;
		} else {
			er_trenddata = 'No';
			trendenable = false;
		}
		var select_testmes = mainForm.findField('select_testmes').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_farm = mainForm.findField('select_farm').getValue();

		if((appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true') && appConstants.analysisby != null && appConstants.analysisby == 'ComponentType')
			er_comptype = appConstants.analysis;

		var opt = "chart";
		var er_type = mainForm.findField('er_type').getValue();

		if (er_type == "No") {
			opt = "data";
		}
		var er_timeline = mainForm.findField('er_timeline').getValue();
		var startdate = mainForm.findField('er_stdate').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		var formparams = 'er_type=' + er_type + '&er_comptype=' + encodeURI(er_comptype) + '&select_farm=' + encodeURI(select_farm) + '&er_priority=' + encodeURI(er_priority) + '&select_testmes=' + encodeURI(select_testmes);// + '&opt=' + opt;
		var settingsparams = '&er_reportgenration=' + er_reportgenration + '&er_trenddata=' + encodeURI(er_trenddata) + '&er_excwe=' + encodeURI(er_excwe) + '&er_sortby=-1';
		var timelineparams;
		var timeperiodparams;
			timelineparams = '&er_timeline=' + encodeURI(er_timeline) + '&enddate=' + encodeURI(enddate) + '&startdate=' + encodeURI(startdate) + '&starthr=' + encodeURI(starthr) + '&er_mode=' + encodeURI(er_mode)+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
			timeperiodparams = '&minto=' + minto + '&timefrom=' + encodeURI(timefrom) + '&timeto=' + encodeURI(timeto) + '&minfrom=' + encodeURI(minFrom) + '&endhr=' + encodeURI(endhr);
		var hiddenfieldQString = "";
		if (appConstants.publicJSON.hasOwnProperty('hiddens')) {
			var hiddenFields = appConstants.publicJSON.hiddens;
			for (var hiddenField in hiddenFields) {
				if(hiddenField == "opt")
				{
					hiddenfieldQString += "&" + hiddenField + "=" +opt;
				}
				else
				{
					hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
				}
			}
		}
		var qString = formparams + settingsparams + timeperiodparams + timelineparams + hiddenfieldQString;
		return qString;
	},
	beforeFormSubmit: function () {
		if (Ext.getCmp('select_farm').getValue() == '-1') {
			Ext.MessageBox.show({
				title: alert_text,
				msg: appConstants.chooseZone,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		} else {
			return true;
		}
	},
	validateMainForm : function()
	{
		var isSettingsOk = true;
		var mainForm = this.getThinclientzonereportsform().getForm();
	var settingsForm =null;
	if(isSettingsEnabled)
	 settingsForm = this.getThinclientzonesettings().getForm();

		var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var MaxDaysInMonth = appConstants.publicJSON['hiddens']['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicJSON['hiddens']['er_usertimeline'];
		var er_timeline = mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		if (!checkDateTime(stDate, enDate)) {
			isSettingsOk = false;
		}
		var usertimelineValid=true;
		if (er_usertimeline != null && er_usertimeline != '-1') {
			usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
			if (!usertimelineValid) {
				Ext.MessageBox.show({
					title: settings,
					msg: _invalidUserTime,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if (reportgen != null && reportgen == 'foreground' &&usertimelineValid) {
			var limitforbg = appConstants.publicJSON['hiddens']['limitforbg'];
			if (!Ext.isEmpty(limitforbg)) {
				if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
					isSettingsOk = false;
				}
			}
		} else if(usertimelineValid) {
			var reportName = settingsForm.findField('bgReportName').getValue();
			  if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},
	showResult:function(){
	Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var mainForm = this.getThinclientzonereportsform().getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
		var starthr = mainForm.findField('er_sthr').getValue();
		startdate.setHours(starthr);
		var enddate = mainForm.findField('er_enddate').getValue();
		var endhr = mainForm.findField('er_endhr').getValue();
		enddate.setHours(endhr);
		var result = checkDateTime(startdate, enddate);
		if (!result) {
			return;
		}
		if(this.validateMainForm()){
			var obj =Ext.getCmp('submit');
			this.formSubmit(obj);
		}
	},
	formSubmit: function (obj) {

	var mainForm = this.getThinclientzonereportsform().getForm();
	var settingsForm =null;
	if(isSettingsEnabled)
		settingsForm = this.getThinclientzonesettings().getForm();

		var reportType = mainForm.findField('er_type').getValue();
		var me = this;
		var getId = '';
		var URL = '';
		var qstr = this.genQueryString();
		this.getNomeasurepanel().hide();
		qstr += '&call=json';
		var isSubmit = false;
		var isReportType = false;
		var isExcludeWeekEnds = false;
		var isDetailedTrend = false;
		var changeTimeline = false;
		var isFromZone = false;
		var isFromCompType = false;
		var URL = '/final/servlet/com.eg.ErCtxServerReportC';
		var reportGeneration =this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');

		var isBackgroundReport = false;

		if (reportGeneration == 'background') {
			isBackgroundReport = true;
			URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
			var reportName = settingsForm.findField('bgReportName').getValue();
			reportName=checkFileName(reportName);
			qstr += '&bg_reportname=' + encodeURI(reportName);
		}
		else if (reportGeneration == 'background-csv') {
			isBackgroundReport = true;
			URL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			var reportName = settingsForm.findField('bgReportName').getValue();
			reportName=checkFileName(reportName);
			qstr += '&bg_reportname=' + encodeURI(reportName);
		}
		if (!Ext.isEmpty(obj)) {
			getId = obj.getId();
			if (getId == 'submit') {
				qstr += '&isSubmit=true';
				var valid = this.beforeFormSubmit();
				isSubmit = true;
				if (!valid) {
					return;
				}
				initLdgMask.show();
			} else if (getId == 'er_type') {
				isReportType = true;
			} else if (getId == 'er_excwe') {
				isExcludeWeekEnds = true;
			} else if (getId == 'er_trenddata' || getId == 'er_timeline') {
				changeTimeline = true;
			} else if (getId == 'select_farm') {
				isFromZone = true;
			} else if (getId == 'er_comptype') {
				isFromCompType = true;
			}
		}
				//by karthikeyan
		qstr += '&er_RmDispName='+appConstants.er_RmDispName;
		appConstants.queryString = qstr;
		Ext.Ajax.request({
			url: URL,
			params: qstr,
			method: 'POST',
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.publicJSON=jsonData;
					if (!Ext.isEmpty(jsonData)) {
						if (isSubmit && !isBackgroundReport) {
							 Ext.getCmp("bookletTool").setDisabled(false);
							 Ext.getCmp("saveTool").setDisabled(false);
							 Ext.getCmp("printTool").setDisabled(false);
							 Ext.getCmp("mailTool").setDisabled(false);
							// Ext.getCmp("upbutton").setDisabled(false);
							  if (reportType== "Yes")
							{
								Ext.getCmp("csvTool").setDisabled(true);
							}
							else
							{
								Ext.getCmp("csvTool").setDisabled(false);
							}
							var resultsData = jsonData['results'];
							var showSelectionSetails = false;
							if (!Ext.isEmpty(resultsData)) {
								var getTitle = resultsData['TITLE'];
								if (!Ext.isEmpty(getTitle)) {
									Ext.getCmp('graphpanel').setTitle(getTitle);
								}
								if (reportType == 'Yes') {

									 var barChartURL = resultsData['barChartURL'];
									var pieChartURL = resultsData['pieChartURL'];
									if (!Ext.isEmpty(barChartURL) && !Ext.isEmpty(pieChartURL)) {
										var selectionDetailsData = jsonData['selectionDetails'];
										me.loadCharts(pieChartURL, barChartURL,selectionDetailsData);
										if (!Ext.isEmpty(pieChartURL))
										{
											showSelectionSetails = true;
										}
									} else {
										Ext.getCmp('graphpanel').hide();
										Ext.getCmp('datacontainer').hide();
										this.getNomeasurepanel().show();
									}
								} else {
									 var gridData = jsonData['GRID_DATA'];
									if (!Ext.isEmpty(gridData))
									{
										showSelectionSetails = true;
									}
									var selectionDetailsData = jsonData['selectionDetails'];
									me.loadGrid(gridData,selectionDetailsData);
								}
								initLdgMask.hide();
							}else{
							 Ext.getCmp("bookletTool").setDisabled(true);
							 Ext.getCmp("saveTool").setDisabled(true);
							 Ext.getCmp("printTool").setDisabled(true);
							 Ext.getCmp("mailTool").setDisabled(true);
							}
						} else if (isSubmit && isBackgroundReport) {
							me.disableTools();
							var backgroundResultsData = jsonData['backgroundResults'];
							var bgGroundMsg = backgroundResultsData['bgGroundMsg'];
							var backgroundResultStatus = backgroundResultsData['status'];
							var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
							var backgroundResultURL = backgroundResultsData['backgroundResultURL'];
							var backgroundResultURLLinkText = backgroundResultsData['backgroundResultURLLinkText'];
							var graphpanel =Ext.getCmp('graphpanel');
							graphpanel.hide();

							if (backgroundResultStatus == 'success') {
								//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:100px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>' + backgroundResponseText + '</b><br /><a class="backgroundMsgLink" href="' + backgroundResultURL + '">' + backgroundResultURLLinkText + '</a></div></div></center>';
							
								htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
							} 
							else if (backgroundResultStatus == 'duplicate'|| (bgGroundMsg!=null ))
							{
								//htmlStr = '<center><div class="block1"  style="font-size:13px;padding:8px;margin-top:100px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px 0px"><b>' + bgGroundMsg + '</b><br /><a class="backgroundMsgLink" href="' + backgroundResultURL + '">' + backgroundResultURLLinkText + '</a></div></div></center>';
							
								htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
							}
							 me.getBackGroundPanel().update(htmlStr);
							 me.getBackGroundPanel().show();
							initLdgMask.hide();
						} else if (isFromZone) {
							me.disableTools();
							var compTypeObj = mainForm.findField('er_comptype');
							var compTypeArrData = jsonData['compTypeArr'];
							if (!Ext.isEmpty(compTypeArrData)) {
								compTypeObj.suspendEvents(true);
								compTypeObj.getStore().clearFilter(true);
								compTypeObj.getStore().loadRawData(compTypeArrData);
								if (!Ext.isEmpty(jsonData['compTypeSelected'])) {
									compTypeObj.setValue(jsonData['compTypeSelected']);
								}
								compTypeObj.resumeEvents();
							}
							var testMeasObj = mainForm.findField('select_testmes');
							var testMeasArrData = jsonData['testMeasArr'];
							if (!Ext.isEmpty(testMeasArrData)) {
								testMeasObj.suspendEvents(true);
								testMeasObj.getStore().clearFilter(true);
								testMeasObj.getStore().loadRawData(testMeasArrData);
								testMeasObj.setValue(testMeasArrData[0].valueField);
								testMeasObj.resumeEvents();
							}
						} else if (isFromCompType) {
							
							var testMeasObj = mainForm.findField('select_testmes');
							var testMeasArrData = jsonData['testMeasArr'];
							if (!Ext.isEmpty(testMeasArrData)) {
								testMeasObj.suspendEvents(true);
								testMeasObj.getStore().clearFilter(true);
								testMeasObj.getStore().loadRawData(testMeasArrData);
								testMeasObj.setValue(testMeasArrData[0].valueField);
								testMeasObj.resumeEvents();
							}
						} else if (isReportType) {
							var sortByArrData = jsonData['sortByArr'];
							if (!Ext.isEmpty(jsonData['testMeasArr'])) {
								var testMeasArrData = jsonData['testMeasArr'];
								var select_testmesObj = mainForm.findField('select_testmes');
								select_testmesObj.suspendEvents(true);
								select_testmesObj.getStore().clearFilter(true);
								select_testmesObj.getStore().loadRawData(testMeasArrData);
								if (!Ext.isEmpty(jsonData['testMeasSelected'])) {
									select_testmesObj.setValue(jsonData['testMeasSelected']);
								} else {
									select_testmesObj.setValue(select_testmesObj.getStore().getAt(0).get('valueField'));
								}
								select_testmesObj.resumeEvents();
							}
						} else if (isExcludeWeekEnds) {
							var excludeMessageData = jsonData['excludeMessage'];
							if (!Ext.isEmpty(excludeMessageData)) {

								Ext.getCmp('excludeDays').update(excludeMessageData);
							}
						} else if (changeTimeline) {
							var timelineComboData = jsonData['timelineCombo'];
							var er_timelineObj = mainForm.findField('er_timeline');
							er_timelineObj.getStore().loadRawData(timelineComboData);
							if (!Ext.isEmpty(jsonData['selectedTimeline'])) {
								er_timelineObj.setValue(jsonData['selectedTimeline']);
							} else {
								er_timelineObj.setValue(er_timelineObj.getStore().getAt(0).get('valueField'));
							}
							var startDateObj = mainForm.findField('er_stdate');
							var endDateObj = mainForm.findField('er_enddate');
							var startHrObj = mainForm.findField('er_sthr');
							var endHrObj = mainForm.findField('er_endhr');
							if (!Ext.isEmpty(jsonData['startDate'])) {
								startDateObj.suspendEvents(true);
								var startDateVal = jsonData['startDate'];
								startDateObj.setValue(startDateVal);
								startDateObj.resumeEvents();
							}
							if (!Ext.isEmpty(jsonData['endDate'])) {
								endDateObj.suspendEvents(true);
								var endDateVal = jsonData['endDate'];
								endDateObj.setValue(endDateVal);
								endDateObj.resumeEvents();
							}
							if (!Ext.isEmpty(jsonData['startHour'])) {
								var startHourVal = jsonData['startHour'];
								startHrObj.suspendEvents(true);
								startHrObj.setValue(startHourVal);
								startHrObj.resumeEvents();

							}
							if (!Ext.isEmpty(jsonData['endHour'])) {
								var endHourVal = jsonData['endHour'];
								endHrObj.suspendEvents(true);
								endHrObj.setValue(endHourVal);
								endHrObj.resumeEvents();
								}
						}
					}
				}
			}
		});
				var reportGen= this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
				var tis= this.getThinclientzonereportsform().getForm();
				var erType = tis.findField("er_type").getValue();
				if(reportGen=="foreground")
				{
				}
				else
				{
					this.disableTools();
				}
	 },
	bookletQuery: function(obj)
	{
		var qStringForBooklet = this.genQueryString();
		var pgLength = appConstants.publicJSON.pageWidthProces;
		qStringForBooklet += '&pageWidthProces='+pgLength+'&printGraph=yes';
		var reportType = Ext.getCmp('er_type').getValue();
		if (reportType == 'No') {
			qStringForBooklet += '&er_view=PRINT';
		}
		qStringForBooklet=this.getGridColSortParam(qStringForBooklet);
		return qStringForBooklet;
	},
	bookletScheduleQuery: function(obj)
	{
		appConstants.queryString = this.genQueryString();  //..prakash
		var bookletquery=appConstants.queryString;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	}, 
	loadGrid: function (gridData,selectionDetailsData) {
		var me = this;
		var datacontainer =Ext.getCmp('datacontainer');
		var graphpanel =Ext.getCmp('graphpanel');
		graphpanel.hide();
		datacontainer.removeAll();
		this.getBackGroundPanel().hide(); //by prakash
		datacontainer.show();
		if (!Ext.isEmpty(gridData)) {
		this.getNomeasurepanel().hide();
			genGridData = gridData;
			for (var key in gridData) {
				var indGridData = gridData[key];
				var title = indGridData['GRID_TITLE'];
				var columns = indGridData['COLUMNS'];
				var genColumns = new Array();
				var measurements = indGridData['MEASUREMENTS'];
				var subColumns = indGridData['SUB_COLUMNS'];
				var gridIndexVals = indGridData['GRID_VALUES'];
				var getFirstColumn = indGridData['GRID_VALUES'][0];
				var noOfColumns = columns.length;
				var colCount = 0;
				var gridWidth = datacontainer.getWidth();
				var calcWidth = (gridWidth / subColumns.length);
				calcWidth = Math.round(calcWidth);
				for (var key1 in getFirstColumn) {
					colCount++;
				}
				var gridStore = gridIndexVals;
				var gridFields = new Array();
				var index = 0;
				for (var i = 0; i < columns.length; i++) {
					var column = columns[i]['COLUMN_NAME'];
					var colName = column;
					 var measureColumnName = measurements[i]['MEASUREMENT'];
					var subColumnsCount = measurements[i]['SUB_COLUMNS'];
					if (measureColumnName == 'NONE') {
						measureColumnName = '&nbsp;';
					}
					var subCols = new Array();
					for (var j = 0; j < subColumnsCount; j++) {
						var subColumnName = subColumns[index]['SUB_COLUMN_NAME_' + (index)];
						var indexVal = gridIndexVals['COLUMN_' + (index)];
						gridFields[gridFields.length] = 'COLUMN_' + (index);
						if (subColumnName == 'NONE') {
							subColumnName = '&nbsp;';
						}
						var colWidth = 0;
						if (subColumnsCount == 1) {
							if (columns.length < 6) {
								colWidth = 180;
							} else {
								colWidth = 90;
							}
						} else {
							if (columns.length < 6) {
								colWidth = 110;
							} else {
								colWidth = 55;
							}
						}
						var needModify = 'yes';
						var alignText = 'center';
						if(index==0)
						{
							alignText = 'left';
							needModify = 'no';
						}
						subCols.push({
							header: subColumnName+" "+measureColumnName,
							sortable: true,
							//width: calcWidth,
							needModify:needModify,
							align: alignText,
							width:150,
							dataIndex: 'COLUMN_' + (index),
							doSort: function(state) {
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
													if (v1.data['COLUMN_0']=='Summary')
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													if(!isNaN(v1) && !isNaN(v2))
													{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;

													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													}
													else
													{
														v1=v1.HEALTH_LINK_TEXT;
														v2=v2.HEALTH_LINK_TEXT;
														if(!isNaN(v1) && !isNaN(v2))
														{
															v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
															v1= isNaN(v1) ? 0 : v1;
															v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
															v2= isNaN(v2) ? 0 : v2;
														}
													}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
							renderer: function (value, metaData, record, row, col, store, gridView) {
								
								var displayText = value;
								if (value['SERVER_LINK_TEXT'] != undefined) {
									displayText = value['SERVER_LINK_TEXT'];
									var URL = value['SERVER_LINK_URL'];
									value = '<a href="javascript:void(0);" onClick="window.location.href=\'' + URL + '\'" class="anchorLinkDefault">' +Ext.getCmp('dataGridId'+key).getDecimalAlignFormat(displayText,true) + '</a>';
								}
								if (value['HEALTH_LINK_TEXT'] != undefined) {
									displayText = value['HEALTH_LINK_TEXT'];
									var URL = value['HEALTH_LINK_URL'];
									value = '<a href="javascript:void(0);" onClick="window.location.href=\'' + URL + '\'" class="anchorLinkDefault">' +Ext.getCmp('dataGridId'+key).getDecimalAlignFormat(displayText,true) + '</a>';
								}
								value = Ext.getCmp('dataGridId'+key).getDecimalAlignFormat(value);
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+displayText+'"';
								return value;
							}
						});
						index++;
					}
				   /* var measureColumns = new Array();
					measureColumns.push({
						header: measureColumnName,
						sortable: true,
						width: 160,
						align: 'center',
						columns: subCols
					});*/
					if (i == 0) {
						if (columns.length < 6) 
						{
							genColumns.push({
								header: colName,
								sortable: false,
								width:150,
								locked:true,
								//minWidth: 150,
								align: 'left',
								dataIndex: 'COLUMN_0',
								columns: subCols,
								doSort: function(state) {
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											if (v1.index==0)
												return;
											v1 = v1.get(field);
											v2 = v2.get(field);
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v1= isNaN(v1) ? 0 : v1;

											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											v2= isNaN(v2) ? 0 : v2;
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
								renderer: function (value, metaData, record, row, col, store, gridView) {
									var displayText = value;
									if (value['SERVER_LINK_TEXT'] != undefined) {
										displayText = value['SERVER_LINK_TEXT'];
										var URL = value['SERVER_LINK_URL'];
										value = '<a href="javascript:void(0);" onClick="window.location.href=\'' + URL + '\'" class="anchorLinkDefault">' + displayText + '</a>';
									}
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+displayText+'"';
									value = Ext.getCmp('dataGridId'+key).getDecimalAlignFormat(value);
									return value;
								}
							});
						}
						else {
							genColumns.push({
								header: colName,
								sortable: false,
								width:150,
								needModify:'no',
								locked:true,
								align: 'left',
								dataIndex: 'COLUMN_0',
								columns: subCols,
								doSort: function(state) 
								{
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											if (v1.index==0)
												return;
											v1 = v1.get(field);
											v2 = v2.get(field);
											v1=v1.SERVER_LINK_TEXT;
											v2=v2.SERVER_LINK_TEXT;

											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
								renderer: function (value, metaData, record, row, col, store, gridView) {
									var displayText = value;
									if (value['SERVER_LINK_TEXT'] != undefined) {
										displayText = value['SERVER_LINK_TEXT'];
										var URL = value['SERVER_LINK_URL'];
										value = '<a href="javascript:void(0);" onClick="window.location.href=\'' + URL + '\'" class="anchorLinkDefault">' + displayText + '</a>';
									}
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+displayText+'"';
									value =Ext.getCmp('dataGridId'+key).getDecimalAlignFormat(value);
									return value;
								}
							});
						}
					} else {
						var tmpColName = column;
						if (columns.length > 6) {
							tmpColName = columns[i]['COLUMN_NAME_WRAPPED'];
						}

						genColumns.push({
							header: tmpColName,
							sortable: false,
							locked:false,
							align: 'center',
							columns: subCols,
						});
					}
					/*genColumns.push(
						{
							header: colName,
							sortable: true,
							align: 'center',
							columns: measureColumns
						});*/
				}
				var isPagingHidden;
				
				if (gridIndexVals.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				var activePage=1;
				var store=Ext.create('Ext.data.Store', {
						fields:gridFields,
						proxy : {
							type : 'pagingmemory',
							reader : {
								type : 'json'
							}
						},
						pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
						autoLoad : true,
						data : gridIndexVals,
						remoteSort : true,
						sorters: { property: gridFields[0], direction : 'ASC' }// vengat
					});
				//datacontainer.setTitle(title);
				var mainDivHeight=document.getElementById("thinclientzone").offsetHeight;
				mainDivHeight = mainDivHeight-50;  // 50 for utilities tool
				if((gridIndexVals.length+2)*27 < mainDivHeight) // here 2 for header and sub header, 27 is each row height
					mainDivHeight=null;
				datacontainer.add({
					xtype: 'customgrid',
					store: store,
					border: true,
					title:title,
					scroll: true,
					frame: false,
					height:mainDivHeight,
					needtoFixColumn:true,
					margin:'0 10 10 10',
					ui:'newGridPanel withHeader',
					id:'dataGridId'+key,
					autoScroll: true,
					stripeRows: false,
					sortableColumns: true,                 
					columns: genColumns,
					viewConfig: {
					//forceFit: true,
						getRowClass: function(record, rowIndex, rowParams, store){
						if (rowIndex==0)
							return 'firstRowClass'; //configured in ext-custom-com.css
						}
					},
					listeners:{
						sortchange:function( ct, column, direction, eOpts ){
								me.gridColIndexParam=column.getIndex();
								me.gridColStateParam=column.sortState;
								 this.getStore().loadPage(activePage);
						},
						render:function(obj){
								//Ext.defer(function() {
								//obj.columns[0].items.items[0].setSortState("ASC",true,true);
							//},100);
						}
					},
					dockedItems:[{
						xtype:'pagingtoolbar',
						cls:'newPagination',
						dock: 'bottom',
						displayInfo: true,
						store: store,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{   
								pages = params.pageCount;
								total = params.total;
								activePage = params.currentPage;
							}
						}
					}]
				});
				datacontainer.show();
			}

			if (!Ext.isEmpty(selectionDetailsData) ) {
				var selectionDetailsObj = Ext.getCmp('selectionDetails');
			   // selectionDetailsObj.removeAll();
				var tpl = new Ext.XTemplate(
					'<tpl exec="this.objectToArray(values)"></tpl>',
					'<tpl for="this.array">',
					'<span style="margin-right:40px;margin-bottom:20px;float:left;"><span class="font_normal12">{key}</span> - <span class="selcetiondetail-bold">{value}</span></span> ',
					'</tpl>',
					{
						objectToArray: function(values){
							this.array = [];
							for(var key in values){
								if(values.hasOwnProperty(key)){
									this.array.push({key: key, value: values[key]});
								}
							}
						}
					}
				);
				Ext.getCmp('selcetioninnerpanel').tpl=tpl;
				Ext.getCmp('selcetioninnerpanel').update(selectionDetailsData);
				//tpl.overwrite(selectionDetailsObj.body, selectionDetailsData);
				var me = this;
				if (isNeedtoTrigerUpbutton)
				{
					var task = new Ext.util.DelayedTask(function(){
						me.toggleForm(Ext.getCmp('panelinsidetoggle'));
						//Ext.getCmp("upbutton").pressed=true;
						//Ext.getCmp("upbutton").fireHandler();
					});
					task.delay(delayTime);
				}
			}
		} else {
			datacontainer.hide();
			graphpanel.hide();
			this.getNomeasurepanel().show();
		 }
	},
	loadTools: function () {
		this.getNewUtilities().loadIcon(true ,true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else
			value = appConstants.publicJSON[jsonParam];
		return value;
	},
	/*getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			value = value.toString();
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}*/
	});