
Ext.define('TopNByMultipleTests.controller.CommonController',{
	extend:'Ext.app.Controller',
	refs:[
 		{selector:'newUtilities',ref:'newUtilities'}
 	],
	init:function(){
		this.control({			
			'newUtilities':{
				'afterrender':this.loadTools
			},			
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},						
			'egcomponent button[id="expandSelector"]':{
				'click': this.expandMe
			},
			'demo_1 button[id="expandSelector2"]':{
				'click': this.expandDesc
			},
			'mainform button[name="save"]': {
				'click': this.goTo
			},			 
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'main button[id="excelToolBtn"]':{
					'click':this.saveExcel
			},
			'demo_1 trigger[id="descSearch"]':{
				'change': this.filterDesc
			},
		});
	},		
	goTo: function (obj) {

		appConstants.formButtonId = obj.getId();
 		//var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
		if ((appConstants.fromScheduleModify != null && appConstants.fromScheduleModify == "Yes")) 
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj); 		
	},     
	saveReportAsPDF:function(){
	
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+appConstants.publicjsonData.urlFields.saveQString;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
			console.log(s_qryString);
        appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		
		return appConstants.publicjsonData.urlFields.saveQString;
	},
	bookletScheduleQuery: function(obj)
	{
		this.getController('TopNReports').updateQueryString(); 	
		var bookletquery=appConstants.queryString+'&option=data&t1='+appConstants.t1+'&t2='+appConstants.t2+'&t3='+appConstants.t3;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){
		
 		var s_qryString = "../servlet/com.eg.ErRepoLiteC?"+appConstants.publicjsonData.urlFields.saveQString+"&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		//appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicjsonData.combo.componentsCombo);
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);
		
    },
	filterDesc: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_info_list'),appConstants.publicjsonData.combo.infoCombo);
		
    },
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveCsv:function(){
		window.location='../servlet/com.eg.ErTopNXlsController';
	},
	saveExcel:function(){
		console.log('<< saveExcel >>>>>>');
		window.location='../servlet/com.eg.ErTopNXlsController';
	},
	saveSchedule:function(){
		var isValid = this.getController('TopNReports').validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
			title: 'Operation Reports',
			msg: 'Chosen timeline not allowed',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			isValid=false;
		} 	
	//
       var compVal = Ext.getCmp('er_component');
	   if(compVal!=undefined){
		  compVal= compVal.getValue().toString();
       if(compVal== null || (compVal!= null && compVal!= 'undefined' && (compVal.trim() == '' ||compVal.indexOf('Not App')>-1))){
	      Ext.MessageBox.show({
								title: 'Alert',
								msg: 'Not Applicable !!!',
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
		isValid=false;
		return;
	   }
	   }

	   if(Ext.isEmpty(appConstants.erUtils))
	   {
			appConstants.erUtils = Ext.widget("erutils");
	   }
		//
		if(isValid)
		{
			var gridObj = Ext.getCmp('configdatas');
			var gridStore = gridObj.getStore();
			this.getController('TopNReports').updateQueryString(); 	
			var target="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryString+"&option=data&com.eg.CSRF_NONCE="+csrfToken;
			if(gridStore !=undefined && gridStore.getCount()!= 1){
				target+='&CSVFileAsExcel=yes';
			}
			console.log('<<< target::>>>>>>>'+target);

			if(appConstants.formButtonId=='save')
			{
				//target+="&resultFilterBy="+appConstants.resultFilterBy;
				target+='&showSchWindow=no'+"&resultFilterBy="+appConstants.resultFilterBy+"&schedule_id="+appConstants.schedule_id;
				target+='&t1='+appConstants.t1+'&t2='+appConstants.t2+'&t3='+appConstants.t3
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
			{
				target+='&t1='+appConstants.t1+'&t2='+appConstants.t2+'&t3='+appConstants.erUtils.specialCharEncode(appConstants.t3)
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
  		}
	},
	saveFavorite:function(){
		var isValid = this.getController('TopNReports').validateMainForm(false);
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
			title: 'Operation Reports',
			msg: 'Chosen timeline not allowed',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			isValid=false;
		} */
		//
	   if(Ext.isEmpty(appConstants.erUtils))
	   {
			appConstants.erUtils = Ext.widget("erutils");
	   }
       var compVal = Ext.getCmp('er_component');
	   if(compVal!=undefined){
		  compVal= compVal.getValue().toString();
       if(compVal== null || (compVal!= null && compVal!= 'undefined' && (compVal.trim() == '' ||compVal.indexOf('Not App')>-1))){
	      Ext.MessageBox.show({
								title: 'Alert',
								msg: 'Not Applicable !!!',
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
		isValid=false;
		return;
	   }
	   }
		//
		if(isValid){
		this.getController('TopNReports').updateQueryString(); 		
		 var target="../servlet/com.eg.ErFavoriteC?"+appConstants.queryString+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
			
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+"&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
			target+='&showWindow=no'+"&FavoriteId="+appConstants.favorite_id;
			target+='&t1='+appConstants.t1+'&t2='+appConstants.t2+'&t3='+appConstants.t3
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			{
			target+='&t1='+appConstants.t1+'&t2='+appConstants.t2+'&t3='+appConstants.erUtils.specialCharEncode(appConstants.t3)
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
			} 
		}
	},	 	
	loadTools : function(){
 		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
	//	Ext.getCmp("favoriteTool").setDisabled(false);
	//	Ext.getCmp("scheduleTool").setDisabled(false);
	
 	},	
			
	expandDesc:function(btn){
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_info_list'),Ext.getCmp('descLabel').text,btn);
 	},
	expandMe:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),Ext.getCmp('componentLabel').text,btn);
 	}
});