
Ext.define('topnreports.controller.CommonController',{
	extend:'Ext.app.Controller',
	refs:[
 		{selector:'utilitiestool',ref:'utilitiestool'}
 	],
	init:function(){
		this.control({			
			'utilitiestool':{
				'afterrender':this.loadTools
			},			
			'utilitiestool > #printTool > button':
			{
				'click':this.printFile
			},
			'utilitiestool > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'utilitiestool > #mailTool > button':{
					'click':this.sendMail
			},
			'utilitiestool > #csvTool > button':{
					'click':this.saveCsv
			},
			'utilitiestool > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'utilitiestool > #scheduleTool > button':{
					'click':this.saveSchedule
			},						
			'egcomponent button[id="expandSelector"]':{
				'click': this.expandMe
			},
			'mainform button[name="save"]': {
				'click': this.goTo
			},			 
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			}
		});
	},		
	goTo: function (obj) {

		appConstants.formButtonId = obj.getId();
 		//var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
		if ((appConstants.fromScheduleModify != null && appConstants.fromScheduleModify == "Yes")) 
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj); 		
	},     
	saveReportAsPDF:function(){
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+appConstants.publicjsonData.urlFields.saveQString;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
	},
	printFile:function(){
		
 		var s_qryString = "../servlet/com.eg.ErRepoLiteC?"+appConstants.publicjsonData.urlFields.saveQString+"&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicjsonData.combo.componentsCombo);
		
    },
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var isValid = this.getController('TopNReports').validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
			title: 'Operation Reports',
			msg: 'Chosen timeline not allowed',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			isValid=false;
		} 		
		if(isValid)
		{
			this.getController('TopNReports').updateQueryString(); 	
			var target="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryString+"&option=data";

			if(appConstants.formButtonId=='save')
			{
				//target+="&resultFilterBy="+appConstants.resultFilterBy;
				target+='&showSchWindow=no'+"&resultFilterBy="+appConstants.resultFilterBy+"&schedule_id="+appConstants.schedule_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
			{
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
  		}
	},
	saveFavorite:function(){
		var isValid = this.getController('TopNReports').validateMainForm(false);
		if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
			title: 'Operation Reports',
			msg: 'Chosen timeline not allowed',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			isValid=false;
		}
		if(isValid){
		this.getController('TopNReports').updateQueryString(); 		
		 var target="../servlet/com.eg.ErFavoriteC?"+appConstants.queryString+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName;//&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
			
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+"&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
			target+='&showWindow=no'+"&FavoriteId="+appConstants.favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
		} 		
	},	 	
	loadTools : function(){
 		this.getUtilitiestool().loadIcon(true, true, true, false, true, true, true, false, false, false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	
 	},		
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),Ext.getCmp('componentLabel').text,btn);
 	}
});