
Ext.define('topnreports.controller.TopNReports',{
	extend:'Ext.app.Controller',
 	refs:[
		{selector:'main',ref:'main'},
 		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
 		{selector:'ReporterSettings', ref:'ReporterSettings'}
	],
	init:function(){
		this.control({		
			'main':{
				'boxready':this.afterMainRender
			},
			'topnreportsform':{
 				'afterrender':this.loadForm
			}, 			
			'topnreportssettings':{
 				'afterrender':this.loadSettings
			}, 
			'timeline combo[name="er_mode"]': {   //topntimeline
			  //'select': this.changeEr_mode
			}, 			
			'topnreportsform combo[name="er_dataFrom"]':{
				'select': this.compareOnChange
			},		
			'topnreportsform combo[name="er_service"]':{
				'select': this.groupOnChange
			},
			'topnreportsform combo[name="er_templateEnable"]':{
				'select': this.criteriaChange
			},
			'topnreportsform combo[name="er_test"]':{
				'select': this.testOnChange
			},
			'topnreportsform combo[name="er_template"]':{
				'select': this.metricOnChange
			},
			'mainform multiselect[name="er_component"]':{
				'change': this.compOnChange
			},
			'mainform combo[name="er_measure"]':{
				'select': this.compOnChange
			},
			'topnreportsform combo[name="er_reportType"]':{
				'select': this.reportTypeOnChange
			},
			'topnreportssettings combo[name="er_showinfo"]':{
				'select': this.showDescriptorsOnChange
			},
			'topnreportssettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},
			'topnreportssettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'topnreportssettings combo[name="er_trenddata"]':{
				'select': this.trendOnChange
			},
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			 'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}

		});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},	
	getUrl:function(isFormSubmitted,istrendChange)
	{
		var url;
		if (isFormSubmitted)
		{
			var reportGeneration = appConstants.publicjsonData.selectedFields['reportGeneration'];
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				reportGeneration = Ext.getCmp('reportGeneration').getValue();
			}
			if (reportGeneration == 'foreground') {
				 url='../servlet/com.eg.ErRepoLiteC';
				 appConstants.queryString+= '&option=data&isSubmit=true&responseType=json';
 			} else{
				url='../servlet/com.eg.ErStartBackGroundReportC';
				var bg_reportname=Ext.getCmp('bgReportName').getValue();
					bg_reportname=checkFileName(bg_reportname);
				appConstants.queryString+= '&bg_reportname='+bg_reportname+'&isSubmit=true&responseType=json';
  			}
		}		
		else
		{
		
			if (istrendChange)
			{
				var er_timelineVal=Ext.getCmp('er_timeline').getValue();
				var er_trenddata=Ext.getCmp('er_trenddata').getValue();
				var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
				Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param1,
					scope : this,
					async : false,
					success : function(response) { 
						var jsonData = Ext.decode(response.responseText);
						var comboVal=jsonData.combo;
						var timelineCombo = Ext.getCmp('er_timeline');
						timelineCombo.getStore().loadRawData(jsonData.combo);
						var flag=false;
						for(var i = 0; i < comboVal.length; i++)
						{
						  if(comboVal[i].valueField == er_timelineVal)
						  {
							flag=true;
						  }
						}
						if(flag)
							timelineCombo.setValue(er_timelineVal);
						else
							timelineCombo.setValue("1 day");
					}
				});

				var inidate=appConstants.publicjsonData.hiddenFields.inidate;
				url= '/final/servlet/com.eg.ErRemoteScriptingServlet';
				er_timelineVal=Ext.getCmp('er_timeline').getValue();
				var er_stdateVal= Ext.getCmp('er_stdate').dataArray;
				var er_enddateVal= Ext.getCmp('er_enddate').dataArray;
				var er_sthr= Ext.getCmp('er_sthr').dataArray;
				var er_endhr= Ext.getCmp('er_endhr').dataArray;
				if (er_trenddata == "No") 
				{
					isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js
					appConstants.queryString = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidate + "]";
				} 
				else 
				{
					isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
					if(er_timelineVal=='Any')
					{
						appConstants.queryString = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["+ er_sthr + "]&P4=[" + er_endhr + "]&P5=[" + inidate+ "]";
					}
					else
					{
						appConstants.queryString = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["+ er_sthr + "]&P4=[" + er_endhr + "]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidate+ "]";
					}
				}
			}
			else
			{
				url= '/final/reporter/ErTopNReportsJson.jsp';
			}
		}
			return url;
	},	
	updateAjaxFormData:function(isFormSubmitted,istrendChange)
    {		
 		var url= this.getUrl(isFormSubmitted,istrendChange);
  		Ext.Ajax.request(
				{
					url : url,
					params:appConstants.queryString,
   					scope:this,
					async: true,
					success: function(response, opts){
 						
 						if(isFormSubmitted) 
						{
							appConstants.publicjsonData=Ext.decode(response.responseText);
							this.loadReportData(appConstants.publicjsonData); 
						}
						else 
						{
							if(istrendChange)
							{
								 //this.timelineUpdate(); 
								var jsonObject = Ext.decode(response.responseText);
								var values = jsonObject.timeline;
								Ext.getCmp('er_stdate').dataArray=values[0];
								Ext.getCmp('er_enddate').dataArray=values[1];
								Ext.getCmp('er_sthr').dataArray=values[2];
								Ext.getCmp('er_endhr').dataArray=values[3]; 
								mgr_stmin = values[4];
								mgr_enmin = values[5];

								Ext.getCmp('er_stdate').setValue(values[6]);
								Ext.getCmp('er_enddate').setValue(values[7]); 
								Ext.getCmp('er_sthr').setValue(values[8]);
								Ext.getCmp('er_endhr').setValue(values[9]); 
								stmin =values[10];
								enmin = values[11];
							}
							else
							{
							   appConstants.publicjsonData=Ext.decode(response.responseText);
								//this.showConfigDropdown();
							   this.loadFormFields(); 
							   if (isSettingsEnabled)
							   {
									this.showDescriptorsOnChange(Ext.getCmp('er_showinfo'));
									this.reportTypeOnChange(Ext.getCmp('er_reportType')); 
							   }
							}
						}						
					},
					failure: function(response, opts) {
						  console.log('server-side failure with status code ' + response.status);
					}
				});
   },
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		Ext.widget('configform');
		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
			var isSettingsOk = thisController.validateSettings();
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(true);
			if(isSettingsOk)
			{
				getButtonObj.setDisabled(false);
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
		});
 	}, 	
    changeEr_mode: function (combo) {
  	var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
	var favorite_id = appConstants.publicjsonData.hiddenFields["favorite_id"];
	if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schedule == null || from_schedule == 'null'))
	{
		return;
	}
		this.showResult();
	},	
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
			
		return false;
	},
	validateMainForm:function(flag){
 		var MaxDaysInMonth = appConstants.publicjsonData.hiddenFields['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicjsonData.hiddenFields['userTimeline'];
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicjsonData.selectedFields['reportGeneration'];
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var dataFrom=Ext.getCmp('er_dataFrom').getValue();
		var metricCombo = Ext.getCmp('er_templateEnable').getValue();	
		var component = Ext.getCmp('er_component');
		if ( dataFrom != 'Component'){
			var group=Ext.getCmp("er_service");			
			if(group.getValue() == '-1'){
				this.getMessageBox('Operation Reports',group.getStore().getAt(0).get('displayField'));
				return false ;
			}
		}
		if(metricCombo == 'no'){
			var test = Ext.getCmp('er_test');
			var measure = Ext.getCmp('er_measure');
			
			if(test.getValue() == '-1'){
				this.getMessageBox('Operation Reports',test.getStore().getAt(0).get('displayField'));
				return false;		
			}
			if(measure.getValue() == '-1'){
				this.getMessageBox('Operation Reports',measure.getStore().getAt(0).get('displayField'));
				return false;		
			}
		}
		else{
			var metric =  Ext.getCmp('er_template');
			
			if(metric.getValue() == '-1'){
				this.getMessageBox('Operation Reports',metric.getStore().getAt(0).get('displayField'));
				return false;
			}
		} 		
		if( component.getValue() == '-1'){
				this.getMessageBox('Operation Reports',component.getStore().getAt(0).get('displayField'));
				return false;
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = appConstants.publicjsonData.hiddenFields['limitforbg'];
				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						return false;
					}
				}
			}
		}
		else{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			return false;
		}
		return true;
	},
	hidePanels:function()
	{
		Ext.getCmp('resultContainer').hide();
		this.getNomeasurepanel().hide();	
		Ext.getCmp('backGroundPanel').hide();
	},
	reportTypeOnChange:function(obj){ 	
 		if(obj.getValue() == 'data'){
			if(isSettingsEnabled)
				Ext.getCmp('er_sortby').show();
			//Ext.getCmp('er_mode').hide();
		}
		else{
			if(isSettingsEnabled)
				Ext.getCmp('er_sortby').hide();
			//Ext.getCmp('er_mode').show();
		} 				
	},	
	compOnChange:function(obj, newValue, oldValue, eOpts){
 		this.hidePanels();
		var me=this;
    	if(!Ext.isEmpty(newValue))
		{
			this.updateQueryString();
			Ext.Ajax.request({
				url : '/final/reporter/ErTopNReportsJson.jsp',
				params :appConstants.queryString ,
				success: function(response){
 					appConstants.publicjsonData=Ext.decode(response.responseText);
					var er_showinfo = appConstants.publicjsonData.selectedFields['selectedDescriptor'];
					if(er_showinfo == 'Yes' && isSettingsEnabled){
						 me.loadComboField('er_info_list','infoCombo','reporter.common.Descriptor','selectedInfo',appConstants.publicjsonData,true,null,null,false);
					}
					else if (isSettingsEnabled){
						Ext.getCmp('er_info_list').hide();
					}
				}
			});		
		}
	},
	showResult:function(){
	Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var stDateTime = Ext.getCmp('er_stdate').getValue();
        var tmpStartHour = Ext.getCmp('er_sthr').getValue();
        stDateTime.setHours(tmpStartHour);
        var enDateTime = Ext.getCmp('er_enddate').getValue();
        var tmpEndHour = Ext.getCmp('er_endhr').getValue();
        enDateTime.setHours(tmpEndHour);
        var result = checkDateTime(stDateTime, enDateTime);
        if (!result) {
            return;
        }
		var isValid = this.validateMainForm(true);
		if(isValid)
			this.doUpdate(true,false);
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();

		
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		
		if ( reportgen!=null && reportgen == 'background' ){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			this.doUpdate(true,false);
		}			
		else{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},	
	reportGenChange:function(){
		Ext.getCmp('resultContainer').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},	
	trendOnChange:function(obj) {
			this.doUpdate(false,true);
	},
	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonData.displayFields['MappedExcludeDays']);
		}
		else
			excludeDaysObj.hide();
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	}, 	
	updateQueryString:function(){
		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var datafrom =Ext.getCmp('er_dataFrom').getValue();
		var isMetricCombo = Ext.getCmp('er_templateEnable').getValue();
		var compArray=new Array();
		var comp_combination='';
		var er_combination ='';
		compArray=Ext.getCmp("er_component").getValue();
		if(appConstants.publicjsonData.hasOwnProperty('combination')){
			comp_combination=appConstants.publicjsonData.combination;
		}
		var showInfo = appConstants.publicjsonData.selectedFields['selectedDescriptor'];
		var er_sortby = appConstants.publicjsonData.selectedFields['selectedSortBy'];
		var er_trenddata = appConstants.publicjsonData.selectedFields['selectedShowData'];
		var er_priority = appConstants.publicjsonData.selectedFields['selectedPriority'];
		var er_excwe = appConstants.publicjsonData.selectedFields['excludeWeek'];
		var reportGeneration = appConstants.publicjsonData.selectedFields['reportGeneration'];
		var timefrom = appConstants.publicjsonData.selectedFields['selectedTimeFrom'];
		var minfrom = appConstants.publicjsonData.selectedFields['selectedMinsFrom'];
		var timeto = appConstants.publicjsonData.selectedFields['selectedTimeTo'];
		var minto = appConstants.publicjsonData.selectedFields['selectedMinsTo'];
		if (isSettingsEnabled)
		{
			showInfo = Ext.getCmp('er_showinfo').getValue();
			er_sortby = Ext.getCmp('er_sortby').getValue();
			er_trenddata = Ext.getCmp('er_trenddata').getValue();
			er_priority = Ext.getCmp('er_priority').getValue();
			er_excwe = Ext.getCmp('er_excwe').getValue();
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
			timefrom = Ext.getCmp('timefrom').getValue();
			minfrom = Ext.getCmp('minfrom').getValue();
			timeto = Ext.getCmp('timeto').getValue();
			minto = Ext.getCmp('minto').getValue();
		}
		mainFormParams="er_dataFrom="+datafrom
						+"&er_templateEnable="+isMetricCombo
						+"&er_reportType="+Ext.getCmp('er_reportType').getValue()
						+"&er_sortby="+er_sortby;
		
		if(datafrom!= '' && datafrom !='Component')
		{
			if(datafrom == 'Zone'){
				mainFormParams+="&er_dataZone="+Ext.getCmp('er_dataZone').getValue();
			}
			mainFormParams+="&er_service="+Ext.getCmp('er_service').getValue();
		}
		if(isMetricCombo == 'no')
		{
			mainFormParams+="&er_test="+Ext.getCmp('er_test').getValue()
							+"&er_measure="+Ext.getCmp('er_measure').getValue();
		}
		else
		{
			var s_template = Ext.getCmp('er_template').getValue();
			if(s_template!=null && s_template != 'null'){
				mainFormParams+="&er_template="+s_template;
				if(s_template != '-1'){
					if(s_template.indexOf(":")>-1)
					var testmeas=s_template.split(":");
					mainFormParams+="&er_test="+testmeas[0];
					mainFormParams+="&er_measure="+testmeas[1];
				}
			}
		}
		var isForceSub =appConstants.publicjsonData.hiddenFields['isForceSubmit'];
		if (isForceSub!=null && isForceSub=="true" && (appConstants.callFromReport ==null || appConstants.callFromReport==false || appConstants.callFromReport=='false')){
	
			var rm_compArr = new Array();
			 var rm_comp =appConstants.publicjsonData.hiddenFields['rmComponent'];
			 if(rm_comp!=null && rm_comp!='undefined')
				rm_compArr = rm_comp.split(',');
			 if(rm_compArr!=null && rm_compArr!='undefined'){
				for(var k=0;rm_compArr.length>k;k++){
					mainFormParams+="&er_component="+rm_compArr[k];
					er_combination+=comp_combination[rm_compArr[k]]+"##";
				}
			}
		}else {
	
			for(var k=0;compArray.length>k;k++)
			{
				mainFormParams+="&er_component="+compArray[k];
				er_combination+=comp_combination[compArray[k]]+"##";
			}
		}
		er_combination=encodeURIComponent(er_combination);
		mainFormParams+="&er_combination="+er_combination+'&callFromReport='+appConstants.callFromReport;
		settingsFormParams="&er_showinfo="+showInfo
							+"&er_excwe="+er_excwe
							+"&er_priority="+er_priority
							+"&er_trenddata="+er_trenddata
							+"&er_mode="+Ext.getCmp('er_mode').getValue()
							+"&er_reportgenration="+reportGeneration;
		if(showInfo!=null && showInfo == 'Yes')
		{
			var infoArray = new Array();
			infoArray = appConstants.publicjsonData.selectedFields['selectedInfo'];
			if (isSettingsEnabled)
			{
				infoArray = Ext.getCmp('er_info_list').getValue();
			}
			for(var k=0;infoArray.length>k;k++)
			{
				settingsFormParams+="&er_info_list="+infoArray[k];
			}
			var sh_timeinuse = appConstants.publicjsonData.selectedFields['weightedAvg'];
			if (isSettingsEnabled)
			{
				sh_timeinuse = Ext.getCmp('sh_timeinuse').getValue();
			}
			settingsFormParams+="&sh_timeinuse="+sh_timeinuse;
		}
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
		var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue()+"&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
		
		if(appConstants.publicjsonData.hasOwnProperty('hiddenFields')){
			var hiddenFields = appConstants.publicjsonData.hiddenFields;
			for (var hiddenField in hiddenFields){
  				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		appConstants.queryString=mainFormParams+settingsFormParams+timelineParams+appConstants.defaultParams+hiddenfieldQString+timperiodParams;
		appConstants.queryString+="&er_RmDispName="+appConstants.er_RmDispName;

	},
	doUpdate:function(isSubmitted,istrendChange)
	{
		this.hidePanels();
 		this.disableTools();
		this.updateQueryString();
			if (appConstants.isForceSubmit=='true'){
				appConstants.queryString += '&isForceSubmit=true&er_RmDispName='+appConstants.er_RmDispName;
			}
		this.updateAjaxFormData(isSubmitted,istrendChange);	
	},
	compareOnChange:function(){
		this.doUpdate(false,false);		
	},
	groupOnChange:function(){
		this.doUpdate(false,false);	
	},
	testOnChange:function(){
		if (!isSettingsEnabled)
		{
			this.showConfigDropdown();
		}
		this.doUpdate(false,false);
	},
	metricOnChange:function(){
		this.doUpdate(false,false);
	},
	criteriaChange:function(){
		this.doUpdate(false,false);
	},
	afterMainRender:function(){
		registerAjaxEvents();	//this method is included in ErTracker.jsp
  		var thisController = this;
		if(!hideBackButton){
			Ext.getCmp('topnreportsform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonData['ID']
				}
			);
		}
		this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
 		if (appConstants.isForceSubmit!=null && appConstants.isForceSubmit=="true") {
			this.showResult();
			appConstants.callFromReport = true;
		}else {
			var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
			if (from_schedule == null || from_schedule == "No")
				this.refreshReportData();
		}
 	},
	setVal:function(id,displayProperty,valueProperty,parentJsonProperty,isCombo)
	{
		var component = Ext.ComponentManager.get(id); 
		if (!isCombo) //for datefield
		{
			component.setValue(parentJsonProperty.selectedFields[displayProperty]);
			component.dataArray =  parentJsonProperty.selectedFields[valueProperty];
		}
		else //for combofield
		  component.setValue(parentJsonProperty.selectedFields[valueProperty]);
	},
	loadSettings:function(){
	var favorite_id = appConstants.publicjsonData.hiddenFields["favorite_id"];
	if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
	 //						  1			 2				3				  4						  5				   6			   7		   		   8				 9
	//this.loadComboField(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectLabelId,multiSelectContainerId,isSetLabel)
		this.loadComboField('er_showinfo','showDescriptorCombo','reporter.comparison.Show Descriptors','selectedDescriptor',appConstants.publicjsonData,false,null,null,false);
 		this.loadComboField('sh_timeinuse','weightedAvgCombo','reporter.comparison.Weighted Average','weightedAvg',appConstants.publicjsonData,false,null,null,false);
 		this.loadComboField('er_info_list','infoCombo','reporter.common.Descriptor','selectedInfo',appConstants.publicjsonData,true,null,null,false);
 		this.loadComboField('er_sortby','sortByCombo','reporter.comparison.Sort by','selectedSortBy',appConstants.publicjsonData,false,null,null,false);
 		this.loadComboField('er_trenddata','showDataCombo','reporter.comparison.Show Data','selectedShowData',appConstants.publicjsonData,false,null,null,false);
 		this.loadComboField('er_priority','priorityCombo','reporter.comparison.Show','selectedPriority',appConstants.publicjsonData,true,null,null,false);
 	 	this.loadComboField('er_excwe','excludeWeekCombo','reporter.common.Exclude weekends','excludeWeek',appConstants.publicjsonData,false,null,null,false);
 		this.loadComboField('reportGeneration','reportGenerationCombo','reporter.consolidated.Report Generation','reportGeneration',appConstants.publicjsonData,false,null,null,false);
		this.setVal('timefrom',null,'selectedTimeFrom',appConstants.publicjsonData,true);
		this.setVal('minfrom',null,'selectedMinsFrom',appConstants.publicjsonData,true);
		this.setVal('timeto',null,'selectedTimeTo',appConstants.publicjsonData,true);
		this.setVal('minto',null,'selectedMinsTo',appConstants.publicjsonData,true); 		
		this.showDescriptorsOnChange(Ext.getCmp('er_showinfo'));	
		this.reportTypeOnChange(Ext.getCmp('er_reportType')); 
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectLabelId,multiSelectContainerId,isSetLabel)
	{ 		 
 		 var component = Ext.ComponentManager.get(comboId);  
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 { 
 				 var rawData = parentJsonProperty.combo[comboProperty]; 
				 component.getStore().clearFilter(true); 
 				 component.getStore().loadRawData(rawData);

				if(comboId!=null && comboId=='er_component'){
					var isForceSub =parentJsonProperty.hiddenFields['isForceSubmit'];
					if (isForceSub!=null && isForceSub=="true" && (appConstants.callFromReport ==null || appConstants.callFromReport==false || appConstants.callFromReport=='false')){
						var rm_compArr = new Array();
						 var rm_comp =appConstants.publicjsonData.hiddenFields['rmComponent'];
						if(rm_comp!=null && rm_comp!='undefined'){
							rm_compArr = rm_comp.split(',');
							
							for(var k=0;rm_compArr.length>k;k++){
								component.setValue(rm_compArr);
							}
						}
					}else{
						 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
							 component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]); 						
						 else 				 
							component.setValue(rawData[0].valueField); 		
					}
				}else{
					if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
  						component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]); 						
 					else 				 
						component.setValue(rawData[0].valueField); 		
				}
				 if (isSetLabel)
				 {
					 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect) 					
							component.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
 						else
							Ext.ComponentManager.get(multiSelectLabelId).setText(comboLabelProperty);
					 }
				 }
				 if(component.isHidden())
				 component.show();
 		 }
		 else
		 {
		 		if(!isMultiSelect)
				{  
					if(!component.isHidden())
					component.hide();
				}
				else
			    {
					var m=Ext.ComponentManager.get(multiSelectContainerId);
					if(!m.isHidden())
					m.hide();
				}
		 }
 	},
	timelineUpdate:function()
	{
		var er_trenddata = appConstants.publicjsonData.selectedFields['selectedShowData'];
	   	this.setVal('er_stdate','startDateForDisplay','startDate',appConstants.publicjsonData,false);
		this.setVal('er_sthr','startHourForDisplay','startHour',appConstants.publicjsonData,false);
		this.setVal('er_enddate','endDateForDisplay','endDate',appConstants.publicjsonData,false);
		this.setVal('er_endhr','endHourForDisplay','endHour',appConstants.publicjsonData,false);
		
		this.loadComboField('er_timeline','timelineCombo','reporter.common.Timeline','selectedTimeline',appConstants.publicjsonData,false,null,null,false);
	},
	showDescriptorsOnChange:function(obj)
	{
		if(obj.getValue() == 'No'){
			Ext.getCmp('sh_timeinuse').hide();
			Ext.getCmp('info_multiselect').hide();
		}
		else{
			Ext.getCmp('sh_timeinuse').show();
			Ext.getCmp('info_multiselect').show();
		}			
	},
	loadFormFields:function()
	{
	//						  1			 2				3				  4						  5				   6			   7		   		   8				 9
	//this.loadComboField(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectLabelId,multiSelectContainerId,isSetLabel)
		this.loadComboField('er_dataFrom','reportForCombo','reporter.operation.Report for','selectedreportFor',appConstants.publicjsonData,false,null,null,false);
 		this.loadComboField('er_service','seg-ser-zoneCombo','reporter.common.seg-ser-zone','selectedSeg-Ser-Zone',appConstants.publicjsonData,false,null,null,true);
  		this.loadComboField('er_dataZone','subZoneCombo','reporter.comparison.Include SubZones','selectedsubZone',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_component','componentsCombo','reporter.comparison.Component','selectedComps',appConstants.publicjsonData,true,'componentLabel','componentcont',false);
		this.loadComboField('er_templateEnable','criteriaCombo','reporter.comparison.Select by Criteria','selectedCriteria',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_reportType','reportTypeCombo','reporter.comparison.Report Type','selectedreportType',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_test','testCombo','reporter.comparison.Test','selectedTest',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_measure','measureCombo','reporter.comparison.Measure','selectedMeasure',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_template','metricsCombo','reporter.comparison.Metric','selectedMetrics',appConstants.publicjsonData,false,null,null,false);
	},
	loadForm:function(){
		this.timelineUpdate();

			stmin = appConstants.publicjsonData.selectedFields.startMinForDisplay;
			enmin = appConstants.publicjsonData.selectedFields.endMinForDisplay;
			mgr_stmin = appConstants.publicjsonData.selectedFields.startmin;
			mgr_enmin = appConstants.publicjsonData.selectedFields.endmin;
			
		this.loadComboField('er_timeline','timelineCombo','reporter.common.Timeline','selectedTimeline',appConstants.publicjsonData,false,null,null,false);
		this.loadFormFields();
        var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = appConstants.publicjsonData.hiddenFields["fromFavoriteModify"];
		var fromScheduleModify = appConstants.publicjsonData.hiddenFields["fromScheduleModify"]
		var fromFavoriteModify =appConstants.publicjsonData.hiddenFields["fromFavoriteModify"];
		var schedule_id =appConstants.publicjsonData.hiddenFields["schedule_id"]; 
		var favorite_id =appConstants.publicjsonData.hiddenFields["favorite_id"];
		if ((fromScheduleModify != null && fromScheduleModify == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			appConstants.fromScheduleModify=fromScheduleModify;
			appConstants.fromFavoriteModify=fromFavoriteModify;
			appConstants.schedule_id=schedule_id;
			appConstants.favorite_id=favorite_id;
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		
		
 	},	
	refreshReportData:function(){
		if (appConstants.isForceSubmit!=null && appConstants.isForceSubmit=="true"){
			this.loadReportData(appConstants.publicjsonData);
		}else {
			if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
			{
				this.loadReportData(appConstants.publicjsonData);
			}
		}
	},
	loadReportData:function(){
		var resultContainerObj=Ext.getCmp('resultContainer');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		var backgroundresultsObj=Ext.getCmp('backGroundPanel');
		var reportGeneration=appConstants.publicjsonData.selectedFields.reportGeneration; 		
		this.hidePanels();	
 		if(reportGeneration == 'foreground'){
			resultContainerObj.removeAll();
			if(appConstants.publicjsonData.hasOwnProperty('reportData')){
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("upbutton").setDisabled(false);
				Ext.getCmp('panelinsidetoggle').setDisabled(false);
				var reportData=appConstants.publicjsonData.reportData;
 				if(appConstants.publicjsonData.selectedFields.selectedreportType=='graph'){
					Ext.getCmp("csvTool").setDisabled(true);

					resultContainerObj.add({xtype:'resultpanel'});
 					var resultPanelObj=resultContainerObj.down('panel');
 					resultPanelObj.setTitle("<span class='font_bold'>"+reportData.chartTitle+"</span>");
 					resultPanelObj.update('<div style="padding:10;"><div id="topNBar"></div></div>');
					//resultPanelObj.update('<table style="text-align:center;width:100%;height:'+(reportData.chartHeight-20)+'px;z-index:1000;"><tr><td valign="middle"> <div id="topNBar" style="border:0px solid red;margin:20px 0px 20px 0px;"></div> </td</tr></table>');
					resultContainerObj.show();
					if(appConstants.chartType=='fusionchart')
					{
						if (FusionCharts("topNBarId" )) 
							FusionCharts("topNBarId").dispose(); 
						var myChart = new FusionCharts(reportData.swfpath,"topNBarId","98%","100%","0","1"); 
						myChart.setXMLData(reportData.XMLData);
						myChart.setTransparent(true);
						myChart.render("topNBar"); 
					}
 					else if(appConstants.chartType=='highchart')
					{
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('topNBar',reportData.chartHeight-20,reportData.chartWidth+100), lineChart);
							lineChart.setData(reportData,'<%=currentDateFormat%>','');
							lineChart.drawChart();
					}
					
					this.getNomeasurepanel().hide();
 				}
				else{
					Ext.getCmp("csvTool").setDisabled(false);
					var columnNames=reportData.columnNames;
					var columnCount=columnNames.length;
					var dataArray=reportData.dataArray;
					var tableHtml = '<div class="x-table" style="margin-top:-1px">'
									+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table">'
									+'<thead>'
									+'<tr class="x-grid-row">';
					for ( var key in columnNames ){
						if(key == 0)
							width="35%";
						else
							width="75px";
						tableHtml+= '<th style="text-align:center" class=" x-grid-cell" width="'+width+'">'
									+'<div class="x-grid-cell-inner">'+columnNames[key]+'</div>'
									+'</th>';
					}
					tableHtml += '</tr>'
								 +'</thead>'
								 +'<tbody align="center">';
					for(var i in dataArray){
						var dataSet=dataArray[i];
						tableHtml += '<tr class="x-grid-row">';
						for(var k in dataSet){
							tableHtml += '<td class=" x-grid-cell"><div class="x-grid-cell-inner">'+dataSet[k]+'</div></td>';
						}
						tableHtml += '</tr>';
					}
								tableHtml +='</tbody>'
								tableHtml +='</table>'
								 tableHtml +='</div>';

					resultContainerObj.add({xtype:'resultpanel'});
					var resultPanelObj=resultContainerObj.down('panel');
 					resultPanelObj.setTitle("<span class='font_bold'>"+reportData.title+"</span>");
 					resultPanelObj.update(tableHtml);
 					resultContainerObj.show();
					this.getNomeasurepanel().hide();
				}
				if (isFormSubmitted)
				{
					Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicjsonData.selectionDetails);
				}
			}
			else{
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
 				this.disableTools();
 				this.getNomeasurepanel().show();
			}
		}
		else if(reportGeneration == 'background')
		{
			
			var backgroundReportStatus=appConstants.publicjsonData.displayFields.backgroundReportStatus;
			if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicjsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicjsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicjsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.slice(0, -3);
				backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
 			}
			else if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicjsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicjsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicjsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.slice(0, -3);
				backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
				
			}
			else
			{
				backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>');
			}
			backgroundresultsObj.show();
		}
		else
		{
			console.log('No data found for report generation in json');
		}		 
 	}
});