	Ext.define('userapplication.view.UserInfo', {
		extend: 'Ext.form.FieldContainer',
		alias: 'widget.userinfo',
		fieldLabel:userTxt,
		layout: 'column',
		id:'userInfo',
		width:200,
		//hidden:true,
		items:[
			{
				xtype: 'textfield',
				cls: 'textbox',
				columnWidth:.80,
				value:'',
				margin:'0 5 0 0',
				//maskRe: /[A-Za-z0-9 .,\]/,
				//readOnly:true,
				id: 'er_user',
				name:'er_user'
			},
			{
				xtype: 'button',
				iconCls: 'iconMultiselectExpand',
				tooltip: '<b>'+userTxt+'</b>',
				columnWidth:.20,
				style:
				{
					 background: 'none',
					 border: '0px'
				},
				handler:function(obj)
				{
					var ddTxtValue=Ext.getCmp('er_user').getValue();
					
					Ext.create('Ext.window.Window',{
						title:userListTxt,
						//width:265,
						autoScroll:false,
						scroll:false,
						id:'userSubWindow',
						border:false,
						frame:false,
						modal: true,
						ghost: false,
						//height:290,
						header:false,
						style:{
							'background':'transparent !important'
						},
						bodyStyle:{
							'background':'transparent !important'
						},
						ui:'newPopupWindow',
						padding:'0 10 5 10',
						buttonAlign:'center',
						listeners: {
							show: function (win) {
								if (this.modal) {
									var dom = Ext.dom.Query.select('.x-mask');
									for (var y = 0; y < dom.length; y++) {
										var el = Ext.fly(dom[y]);
									}
								el.addCls('windowModalNoBg');
								}
							},
							hide: function (win) {
								var dom = Ext.dom.Query.select('.x-mask');
								if (this.modal) {

									var el = Ext.fly(dom[0]);
									el.removeCls('windowModalNoBg');
								}
							},
							afterrender: function () {
								Ext.EventManager.onWindowResize(function () {
									var me = this;
									me.center();
								}, this);
							}
						},


						doClose: function() {
							var me = this;
							// Being called as callback after going through the hide call below
							if (me.hidden) {
								me.fireEvent('close', me);
								if (me.closeAction == 'destroy') {
									this.destroy();
								}
							} else {
								// close after hiding
								me.hide(me.animateTarget, me.doClose, me);
							}
						},
						buttonAlign:'center',
						items:[
						{
							xtype:'panel',
							title:userListTxt,
							margin:5,
							layout:{
								type:'vbox',
								pack:'center',
								align:'stretch'
							},
							buttonAlign:'center',
							ui:'newFormFieldsInPopup',
							items:[
								{
									xtype: 'container',
									width: 233,
									margin: '0 10 0 10',
									items: [
									{
										xype: 'container',
										cls:'multisearchlist',
										items: [
										{
											xtype: 'customtrigger', 
											emptyText: searchTxt+' '+userTxt,
											id: 'userSearch',
											listeners:
											{
												change:function(obj)
												{
													obj.toggleTriggger();
													if (Ext.isEmpty(appConstants.erUtils))
														appConstants.erUtils = Ext.widget("erutils");
													appConstants.erUtils.filterComboStore(obj,Ext.getCmp('componentsClone'),appConstants.publicJsonData.combo.userCombo);
												}
											}
										}],
									}]
								},
								{
									xtype: 'multiselect',
									width: 233,
									height:200,
									//layout: 'fit',
									border : 0,
									margin: '0 10 0 10',
									autoScroll:true,
									//maxSelections:1,
									scroll:false,
									selModel:
									{
										mode:'SIMPLE'
									},
									labelAlign:'left',
									baseCls: 'egmultiselect',
									multiSelect: false,
									id: 'componentsClone',
									name: 'componentsClone',
									store: new Ext.data.Store({
										fields: ['displayField', 'valueField'],
										data: []
									}),
									value: [],
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									listeners:
									{
										afterrender: function ()
										{
											this.getStore().loadRawData(listOfUser);
											this.setValue(ddTxtValue);
										}
									}
								}
							],
							buttons:[
								{
									text:selectTxt,
									id: 'expand',
									margin:'0 10 10 10',
									ui:'newButtonSmall',
									name: 'expand',
									handler: function()
									{
										if ( Ext.getCmp('componentsClone').getValue() != '' && (Ext.getCmp('componentsClone').getValue()).length==1 )
										{

											var comboVal= Ext.getCmp('componentsClone').getValue();

											Ext.getCmp('er_user').setValue(comboVal);
											this.up('window').destroy();
										}
										else
										{
											 Ext.MessageBox.show({
												title: 'Alert',
												msg: 'Please Choose Single User',
												buttons: Ext.MessageBox.OK,
												icon: Ext.MessageBox.WARNING
											});
											return;
										}
									}
								}
							],
							tools:[
							{
								xtype:'button',
								iconCls: 'iconCloseNew',
								listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: close
										});
									},
									click:function(){
										Ext.getCmp('userSubWindow').doClose();
									}
								},
								style: {
									background: 'none',
									border: '0px'
								}
							}]
								
					}]
				}).show();
				}
			}
		]
	});

