// JavaScript Document
Ext.Loader.setConfig({
	enable:true,
	garbageCollect:true,
	preserveScripts:false,
	disableCaching:false	
});

Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux');

Ext.Ajax.timeout=ajaxTimeout;
Ext.Ajax.disableCaching=false;
Ext.Ajax.on('beforerequest', function(conn, response, opts) { 
	Ext.get(document.body).mask('Loading...');	
});
Ext.Ajax.on('requestcomplete', function(conn, response, opts) { 
	Ext.get(document.body).unmask();	
});
Ext.Ajax.on('requestexception', function(conn, response, opts) { 
	Ext.get(document.body).unmask(); 
	if (response.timedout) {				  
			alert('ajax timeout exception occured...');  			 
	}
	else if(response.status=401)
	{
		alert('You browser session expired' + response.status); 				 
	}
	else
	{
		alert('server-side failure with status code ' + response.status); 				 
	}
});


Ext.application({
	name:'userbilling',
	requires:['userbilling.view.Main'],
	controllers:['userbilling.controller.UserBillingController'],
	appFolder:'../reporter/scripts/UserBillingApp',
	launch:function(){
					//Firefox  version > 18 hack   
 					if (Ext.firefoxVersion >= 18) {
                    var noArgs = [];
                    Ext.override(Ext.Base, {
                        callParent : function(args) {
 
 
                            var method, superMethod = (method = this.callParent.caller) &&
                                    (method.$previous || ((method = method.$owner ?
                                            method :
                                            method.caller) && method.$owner.superclass[method.$name]));
                            try {
                            } catch (e) {
                            }
 
 
                            return superMethod.apply(this, args || noArgs);
                        }
                    });
                };
				var s_url='/final/reporter/ErCtxUserBillingJSON.jsp';
				if((isSubmit!=null && isSubmit=="true") || executeFavorite == 'true')
				{
					s_url = '../servlet/com.eg.ErCtxUserBillingC?responseType=json';
				}  			 
				Ext.Ajax.request(
				{
					url : s_url,
 					params : QueryStringFromURL,
					scope:this,
					success: function(response){
						
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						publicJsonData=jsonData;
 						Ext.create('Ext.container.Viewport',{
								layout:'fit',
								items:[
									{ 
										xtype:'main'										
									}
								]
							});	 			 
					}
				});
	}
});