
Ext.define('userbilling.controller.UserBillingController',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'utilitiestool',ref:'utilitiestool'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({

			'utilitiestool':{
				'afterrender':this.loadTools
			},
			'main':{
				'boxready':this.afterMainRender
			},
			'mainform':{
				'afterrender':this.fillMainFormFields
			},
			'userbillingsettings':{
				//'afterrender':this.fillSettingsFields
			},
			'utilitiestool > #printTool > button':
			{
				'click':this.printFile
			},
			'utilitiestool > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'utilitiestool > #mailTool > button':{
					'click':this.sendMail
			},
			'utilitiestool > #csvTool > button':{
					'click':this.saveCsv
			},
			'utilitiestool > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'utilitiestool > #scheduleTool > button':{
					'click':this.saveSchedule
			},
				'userbillingform combo[name="select_by"]':{
				'select': this.selectionByOnChange
			},
			'userbillingform combo[name="select_farm"]':{
				'select': this.zoneOnChange
			},
			'userbillingform combo[name="er_compType"]':{
				'select': this.componentTypeOnChange
			},
			'egcomponent button[id="expandSelector"]':{
				'click': this.expandMe
			},
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			'mainform button[name="save"]':{
				'click': this.goTo
			},
			'userbillingform combo[name="reportGeneration"]':{
				'select': this.reportGenerationChange
			},
			'mainform trigger[id="compSearch"]' : {
				'keyup' : this.filterMultiselect
			},
			 'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'userbillingform combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			}
		});
	},
	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(publicJsonData.displayFields['excludedDays']);
		}
		else
			excludeDaysObj.hide();
	},
	filterMultiselect: function (obj) {
        var findVal = obj.getValue();
        var compId = obj.getId();
		if(compId=='compSearch')
		 {
			compName='select_server';
			compStore=rawDataForComponents;
		}
		var compObj = Ext.getCmp(compName);
           if (Ext.isEmpty(obj.getValue())) {
            compObj.getStore().loadRawData(compStore);
            compObj.setValue(compStore[0]['valueField']);
        } else {
            var isRecordFound = false;
            var genStore = new Ext.data.Store({
                fields: ['displayField', 'valueField'],
                data: []
            });
            for (var i = 0; i < compStore.length; i++) {
                var getRecord = compStore[i]['displayField'];
                if (getRecord.indexOf(findVal) > -1) {
                    isRecordFound = true;
                    genStore.add({
                        'displayField': compStore[i]['displayField'],
                        'valueField': compStore[i]['valueField']
                    });
                }
            }
            if (isRecordFound) {
                compObj.getStore().removeAll();
                for (var i = 0; i < genStore.getCount(); i++) {
                    var getRecord = genStore.getAt(i);
                    compObj.getStore().add(getRecord);
                }
                compObj.setValue(genStore.getAt(0).get('valueField'));
            } else {
                compObj.getStore().removeAll();
                compObj.getStore().add({
                    'displayField': 'Not Applicable',
                    'valueField': '-1'
                });
                compObj.setValue('-1');
            }
            obj.focus();
        }
    },
	goTo: function (btn) {
		formButtonId = btn.getId();
		var hiddenFields =  publicJsonData["hiddenFields"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.saveFavorite();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveSchedule();
		}
    },
	hideToolPanel:function()
	{
	    Ext.getCmp('resultPanel').hide();
 		this.disableTools();
	},
	reportGenerationChange:function(){
 		this.hideToolPanel();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},
	saveReportAsPDF:function(){
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
		var timeLineMonth=Ext.getCmp('er_month');
		var timeLineYear=Ext.getCmp('er_year');
		if (timeLineMonth.getValue() == 'Any') {
			 timelineParams = "er_month="+timeLineMonth.getValue()+"&startdate=" + startDateConverted + "&enddate=" + endDateConverted;
  		} else {
			  timelineParams =  "er_month="+timeLineMonth.getValue()+"&er_year=" + timeLineYear.getValue();
		}
		timelineParams+="&er_rtype="+publicJsonData.hiddenFields.er_rtype+"&er_trgttype="+publicJsonData.hiddenFields.er_trgttype+"&er_excwe=No&er_view=PRINT";

		// alert(timelineParams);
		var query=publicJsonData.urlFields.saveUrl+'?'+timelineParams;

 		var erUtils =  Ext.widget('erutils');
		erUtils.savePDF(query);
	},
	printFile:function(){
 		if(Ext.getCmp('select_by').getValue().toLowerCase()=='yes')
		this.updateQueryString(false,true,true,false);
		else
 		this.updateQueryString(true,true,true,false);
		var query=publicJsonData.urlFields.printUrl+'?'+queryString+'&ispdf=yes';
		//console.log(query);
parent.printWindowFn(query); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var isValid = this.validateBillingForm();
		if( isValid && Ext.getCmp('er_month').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: publicJsonData.displayFields.reportTitle,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
		if(Ext.getCmp('select_by').getValue().toLowerCase()=='yes')
		this.updateQueryString(false,true,true,false);
		else
 		this.updateQueryString(true,true,true,false);
		var qryStr="/final/reporter/ErSaveSchedule.jsp?"+queryString+"&er_timeline=1 month&option=data";
		if (formButtonId=='save')
			document.location=qryStr+'&showSchWindow=no';
		else
			parent.scheduleWindowFn(qryStr);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return;
	},
	saveFavorite:function(){
		var isValid = this.validateBillingForm();
		if(isValid && Ext.getCmp('er_month').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: publicJsonData.displayFields.reportTitle,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		}
		if(isValid){
		if(Ext.getCmp('select_by').getValue().toLowerCase()=='yes')
		this.updateQueryString(false,true,true,false);
		else
 		this.updateQueryString(true,true,true,false);
		var hiddenFields =  publicJsonData["hiddenFields"];
		var favorite_id = hiddenFields["favorite_id"];
		var target="../servlet/com.eg.ErFavoriteC?"+queryString+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName;//&FavoriteId="+favorite_id;
		if (formButtonId=='save')
			document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	selectionByOnChange:function(obj, newValue, oldValue, eOpts){
		this.hideToolPanel();
		var url='/final/reporter/ErCtxUserBillingJSON.jsp';
 		this.updateQueryString(false,false,false,false);
		this.updateAjaxFormData(url,false);
 	},
	zoneOnChange:function(obj, newValue, oldValue, eOpts){
		this.hideToolPanel();
		var url='/final/reporter/ErCtxUserBillingJSON.jsp';
 		this.updateQueryString(true,false,false,false);
		this.updateAjaxFormData(url,false);
	},
	componentTypeOnChange:function(obj, newValue, oldValue, eOpts){
		this.hideToolPanel();
		var url='/final/reporter/ErCtxUserBillingJSON.jsp';
		if(Ext.getCmp('select_by').getValue().toLowerCase()=='yes')
		this.updateQueryString(false,true,false,false);
		else
 		this.updateQueryString(true,true,false,false);
		this.updateAjaxFormData(url,false);
 	},
	updateAjaxFormData:function(url,isFormSubmitted)
    {
		var me=this;
 		Ext.Ajax.request(
				{
					url : url,
 					params : queryString,
					scope:this,
					async: true,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						publicJsonData=jsonData;
 						if(isFormSubmitted)
						{
							 this.loadReportData();
						}
						else
						{
							me.fillMainFormFields();
							me.fillSettingsFields();
						}
					}
				});
   },
	showResult:function(){
 		if(this.validateBillingForm())
			this.submitReport();
	},
	validateBillingForm: function () {
		var selectionByObj=Ext.getCmp('select_by');
		var zoneObj=Ext.getCmp('select_farm');
		var componentTypeObj=Ext.getCmp('er_compType');
		var componentObj=Ext.getCmp('select_server');
		var userTypeObj=Ext.getCmp('user_type');

		var selectionByCombo_jsonProperty='selectionBy';
		var zonetCombo_jsonProperty='zone';
		var componentTypeCombo_jsonProperty='componentType';
		var componentCombo_jsonProperty='component';
		var userTypeCombo_jsonProperty='userType';

		 if(this.validateBillingField(selectionByObj.getValue(),selectionByObj,selectionByCombo_jsonProperty))
		  {
			if(this.validateBillingField(zoneObj.getValue(),zoneObj,zonetCombo_jsonProperty))
			  {
			  	   if (this.validateBillingField(componentTypeObj.getValue(),componentTypeObj,componentTypeCombo_jsonProperty))
				   {
					   if (this.validateBillingField(componentObj.getValue(),componentObj,componentCombo_jsonProperty))
					   {
						   if (this.validateBillingField(userTypeObj.getValue(),userTypeObj,userTypeCombo_jsonProperty))
						   {
								return true;
						   }
					   }
				   }
			  }
		  }
	},
	validateBillingField:function(objValue,obj,jsonProperty)
	{

		if(publicJsonData.combo.hasOwnProperty(jsonProperty))
		{
		   if(objValue=='-1'||objValue=='Not Applicable'||objValue=='')
			{
				Ext.MessageBox.show({
							title: publicJsonData.displayFields.reportTitle,
							msg: obj.getStore().getAt(0).get('displayField'),
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
			}else
			{

				return true;
			}
		}
		else
		{
			 return true;
		}
	},
	submitReport:function(){
		var flag;
		if(Ext.getCmp('select_by').getValue().toLowerCase()=='yes')
		  flag=false;
		else
 		  flag=true;

		var url;
		if(Ext.getCmp('reportGeneration').getValue()=='foreground')
		{
			url='../servlet/com.eg.ErCtxUserBillingC';
			if(flag)
			{
				this.updateQueryString(true,true,true,true);
			}
			else
			{
				this.updateQueryString(false,true,true,true);
			}
		}
		else
		{
			url='../servlet/com.eg.ErStartBackGroundReportC';
		 	if(flag)
			{
				this.updateQueryString(true,true,true,false);
			}
			else
			{
				this.updateQueryString(false,true,true,false);
			}
			var extraParams = "&er_timeline=Any&starthr=00&endhr=00&startmin=00&endmin=00";
			extraParams+="&timefrom=00&minfrom=00&timeto=24&minto=00";
			queryString+=extraParams;
		}
		queryString +="&er_RmDispName="+er_RmDispName;

		//alert(queryString);
		this.updateAjaxFormData(url,true);
	},
	validateSettings :function(){
		var isSettingsOk = true;
 		var MaxDaysInMonth = publicJsonData['hiddenFields']['getMaxDaysInMonth'];
		//var er_usertimeline = publicJsonData['hiddenfields']['userTimeline'];

		var reportgen=Ext.getCmp('reportGeneration').getValue();


		var er_timeline=Ext.getCmp('er_month').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();

		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		/*if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			var limitforbg = publicJsonData['hiddenFields']['limitforbg'];
			if(!Ext.isEmpty(limitforbg)){
				if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
					Ext.MessageBox.confirm('Confirm', forGrdReportConfirmMsg,this.showConfirmResult,this);
					isSettingsOk = false;
				}
			}
		}
		else{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBox(reportName))
			isSettingsOk = false;
		} */
		if ( reportgen!=null && reportgen == 'background' ){
		var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}

		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		}
		else{
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			return false;
		}
	},

	reportGenChange:function(){
		this.hideToolPanel();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},
	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(publicJsonData.displayFields.excludedDays);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},

	loadTools : function(){
		this.getUtilitiestool().loadIcon(true, true, true, false, true, true, true, false, false, false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
 		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQueryString:function(zone,componentType,component,foregroundReportGeneration){
		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString='';
		var timelineParams;

		mainFormParams='select_by='+Ext.getCmp("select_by").getValue();
		var property=publicJsonData.combo;

		if(zone)
		mainFormParams+='&select_farm='+Ext.getCmp("select_farm").getValue();

		if(componentType)
		mainFormParams+='&er_compType='+Ext.getCmp("er_compType").getValue();

		if(component)
 		{
			var compArray=new Array();
 			compArray=Ext.getCmp("select_server").getValue();
			for(var k=0;compArray.length>k;k++)
			{
				mainFormParams+="&select_server="+compArray[k];
			}
		}

		if(property.hasOwnProperty('userType'))
		mainFormParams+='&user_type='+Ext.getCmp("user_type").getValue();

		mainFormParams+="&er_sortBy=User Name&er_orderBy=ASC";

		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);


		var timeLineMonth=Ext.getCmp('er_month');
		var timeLineYear=Ext.getCmp('er_year');
		if (timeLineMonth.getValue() == 'Any') {
			 timelineParams = "&startdate=" + startDateConverted + "&enddate=" + endDateConverted;
			 timelineParams+= "&er_stdate=" + startDateConverted + "&er_enddate=" + endDateConverted;
 		} else {
			  timelineParams = "&er_year=" + timeLineYear.getValue();
		}

		settingsFormParams='&er_excwe='+Ext.getCmp('er_excwe').getValue()+"&er_reportgenration="+Ext.getCmp('reportGeneration').getValue()+'&er_month='+timeLineMonth.getValue();

  		settingsFormParams+=timelineParams;

		var reportGenerationParams;
		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		if (foregroundReportGeneration) {
			reportGenerationParams="&isSubmit=true&responseType=json";//&option=data
		}
		else{
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
            reportGenerationParams="&bg_reportname="+bg_reportname+"&isSubmit=true&responseType=json";
		}

		if(publicJsonData.hasOwnProperty('hiddenFields')){
			var hiddenFields = publicJsonData.hiddenFields;
			for (var hiddenField in hiddenFields){
 				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		queryString=mainFormParams+settingsFormParams+reportGenerationParams+hiddenfieldQString;
		//alert(queryString);
	},


	afterMainRender:function(){
		var thisController = this;
		/*Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});

		Ext.get('closeSettings').on('click',function(){
			var isSettingsOk = thisController.validateSettings();
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(true);
			if(isSettingsOk)
			{
				getButtonObj.setDisabled(false);
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
		});*/
		if (er_RmDispName!= null && er_RmDispName!= 'null' && er_RmDispName!= 'undefined')
			this.getMain().setTitle(er_RmDispName);
		else
			this.getMain().setTitle(publicJsonData.displayFields.reportTitle);
		var hiddenFields =  publicJsonData["hiddenFields"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if (from_favorite == null )
			this.refreshReportData();
	},
	loadComboField:function(comboProperty,comoboObject,comboLabelProperty,comboSelectedProperty,parentJsonProperty){
		 var obj = Ext.getCmp(comoboObject);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
				var rawData = parentJsonProperty.combo[comboProperty];
				obj.getStore().loadRawData(rawData);
				 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
				 {
						var selection=parentJsonProperty.selectedFields[comboSelectedProperty];
						obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }

				 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
				 {
					if(comoboObject=='select_server')
					{
						var componentLabelObj=Ext.getCmp('componentLabel');
						var multiSelectComboObj=Ext.getCmp('multiSelectCombo');
						componentLabelObj.setText(parentJsonProperty.displayFields[comboLabelProperty]);
						multiSelectComboObj.show();
						rawDataForComponents=rawData;
					}
					else
					{
						obj.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
						obj.show();
					}
				 }
		 }
		 else
		 {
		 	obj.hide();
		 }
	},
	fillMainFormFields:function(){
	//comboProperty,comoboObject,comboLabelProperty,comboSelectedProperty,globalJsonData
	var hiddenFields = publicJsonData.hiddenFields;
	var from_schedule = hiddenFields["fromScheduleModify"];
	var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
	if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
		Ext.getCmp("submit").hide();
		Ext.getCmp("save").show();
		Ext.getCmp("favoriteTool").setDisabled(true);
		Ext.getCmp("scheduleTool").setDisabled(true);
	}else{
		Ext.getCmp("submit").show();
		Ext.getCmp("save").hide();
	}
	this.loadComboField('selectionBy','select_by','selectionByLabel','selectionBy',publicJsonData);
	this.loadComboField('componentType','er_compType','componentTypeLabel','componentType',publicJsonData);
	this.loadComboField('component','select_server','componentLabel','component',publicJsonData);
	this.loadComboField('userType','user_type','userTypeLabel','userType',publicJsonData);
	this.loadComboField('zone','select_farm','zoneLabel','zone',publicJsonData);

	this.fillSettingsFields();
	},
	refreshReportData:function(){
		if(isSubmit!=null && isSubmit=="true")
		{
			initLdgMask.show();
			this.loadReportData();
		}
		else
		{
			if(isForceSubmit=='true')
			{
				isForceSubmit='false';
				this.showResult();
			}
		}
	},
	loadReportData:function(){
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var resultPanelObj = Ext.getCmp('resultPanel');

         var selectionDetailsObj = Ext.getCmp('selectionDetails');
 		var reportGeneration=publicJsonData.selectedFields.reportGeneration;
		var htmlStr = '';
		if(reportGeneration == 'background'){
			var backgroundReportStatus = publicJsonData.displayFields.backgroundReportStatus;
   			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
				var bgroundResponseTxt = publicJsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL = publicJsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor = publicJsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);
				htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:420px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a href="' + bgroundReportsURL + '">' + sub + '</a></div></div></center>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
				var bgroundResponseTxt = publicJsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL = publicJsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor = publicJsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);
				htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:420px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a href="' + bgroundReportsURL + '">' + sub + '</a></div></div></center>';
			}
			else
			{
				//alert('none');
			}
 			this.getBackGroundPanel().update('<div>'+htmlStr+'</div>');
 			this.getBackGroundPanel().show();
		}
		else{
			this.showBillingGrid();
		}
		initLdgMask.hide();
		if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
	},
	showBillingGrid:function()
	{
		var resultpanelobj = Ext.getCmp("resultPanel");
		resultpanelobj.removeAll();

		if(publicJsonData.grid.hasOwnProperty('gridData'))
		{
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);

			resultpanelobj.add({
				xtype: 'userbillinggrid',
				dataArray :publicJsonData.grid.gridData,
				pageLimit : 5,
				title :  '<span class="font_bold">'+publicJsonData.grid.gridTitle+'</span>'
 			});
			Ext.getCmp('selectionDetails').setSelectionDetailsData(publicJsonData.selectionDetails);
 			resultpanelobj.show();
		}
		else
		{
			resultpanelobj.hide();
 			this.getNomeasurepanel().show();
		}
	},
	fillSettingsFields:function()
	{
		this.loadComboField('excludeWeekends','er_excwe','excludeWeekendsLabel','excludeWeekends',publicJsonData);
 		this.loadComboField('timeLineMonth','er_month','timeLineLabel','timeLineMonth',publicJsonData.timeZone);
 		this.loadComboField('timeLineYear','er_year','','timeLineYear',publicJsonData.timeZone);
		this.loadComboField('reportGeneration','reportGeneration','reportGenerationLabel','reportGeneration',publicJsonData);

		var startDate=Ext.getCmp('er_stdate');
		var endDate=Ext.getCmp('er_enddate');
		var timeLineMonth=Ext.getCmp('er_month');
		var timeLineYear=Ext.getCmp('er_year');
		if (timeLineMonth.getValue() == 'Any') {
			timeLineYear.hide();
			endDate.show();
			startDate.show();
			startDate.setDisabled(false);
			endDate.setDisabled(false);
			if(publicJsonData.timeZone.selectedFields.hasOwnProperty('startDate'))
			startDate.setValue(publicJsonData.timeZone.selectedFields.startDate);
			else
			startDate.setValue(publicJsonData.selectedFields.startDate);
			 //set end date
			if(publicJsonData.timeZone.selectedFields.hasOwnProperty('endDate'))
				endDate.setValue(publicJsonData.timeZone.selectedFields.endDate);
			else
			endDate.setValue(publicJsonData.selectedFields.endDate);
			} else {
			timeLineYear.show();
			endDate.hide();
			startDate.hide();
		}
	},
	expandMe:function(btn){
		var CmpClone = Ext.getCmp('select_server');
		var cloneStore = CmpClone.getStore();
		btn.setDisabled(true);
		var expandWindow = Ext.create('Ext.window.Window',{
				title:Ext.getCmp('componentLabel').text,
				width:600,
				height:300,
				doClose: function() {
					var me = this;
					btn.setDisabled(false);
					// Being called as callback after going through the hide call below
					if (me.hidden) {
						me.fireEvent('close', me);
						if (me.closeAction == 'destroy') {
							this.destroy();
						}
					} else {
						// close after hiding
						me.hide(me.animateTarget, me.doClose, me);
					}
				},
				buttonAlign:'center',
				items:[
					{

							height:220,
							width: 576,
							xtype: 'multiselectfield',
							//msgTarget: 'side',
							autoScroll:false,
							scroll:false,
							name: 'multiselect',
							labelAlign:'left',
							//height:50,
							allowBlank: false,
							id: 'componentsClone',
							name: 'componentsClone',
							value: '',
							store:cloneStore,
							value: CmpClone.getValue(),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local'

						}
				],buttons:[
							{
								text:'Select',
								id: 'expand',
								ui:'newButtonSmall',
								name: 'expand',
								handler: function()
								{
									if ( Ext.getCmp('componentsClone').getValue() != '' )
									{
										CmpClone.setValue(Ext.getCmp('componentsClone').getValue());
										btn.setDisabled(false);
										expandWindow.destroy();
									}
									else
									{
												Ext.MessageBox.show({
												title: 'Alert',
												msg: 'Please Choose a Component',
												buttons: Ext.MessageBox.OK,
												icon: Ext.MessageBox.WARNING
											});
											return;

									}
								}

							}
							]
		}).show();
		this.getMain().doLayout();
	}
});

