
Ext.define('UserLogonReports.controller.UserLogonReports',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main','ErApplication'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'thinclientuserform',ref: 'thinclientuserform'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'thinclientusersettings',ref: 'thinclientusersettings'},
		{selector: 'reporterdata',ref:'reporterdata'},
		{selector:'emptypanel', ref:'emptypanel'},
		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({

			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
           	'thinclientusersettings':{
				'afterrender':this.loadSettingsElements
            		},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'mainform combo[name="select_farm"]':{
				'select': this.zoneOnChange
			},
			'mainform combo[name="report_category"]':{
				'select': this.reportCatChange
			},
			'mainform combo[name="er_type"]':{
				'select': this.reportTypeOnChange
			},
			'egcomponent multiselectfield[name="er_server"]':{
				'change': this.serverOnChange
			},
			'mainform button[id="expandSelector"]': {
				'click': this.expandMe
			},
			'mainform button[id="er_poolType_expand"]': {
				'click': this.expandMe
			},
			'mainform button[id="expandSelectorUser"]': {
				'click': this.expandMe2
		        },
			'geofilter button[id="expandSelectorActivity_geo"]': 
			{
				"click": this.expandMeGeo
			},
 			'mainform combo[name="er_compType"]':{
				'select': this.compTypeOnChange
			},
			'mainform combo[name="brokeringFrom"]':{
				'select': this.brokeringFromChange
			},
			/* 'thinclientusersettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},*/
			'thinclientusersettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'thinclientusersettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'thinclientusersettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			'mainform button[name="save"]': {
				"click": this.goTo
		    	},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.compMultiselect
			},
			'erapplication trigger[id="userSearch"]':
			{
				'change': this.filterMultiselect
			},
			'egdesktoppools trigger[id="er_poolType_Search"]':
			{
				'change': this.filterMultiselect
			},
			'geofilter trigger[id="compSearch_geo"]':
			{
				'change': this.filterMultiselect
			},
			'erapplication multiselectfield[name="er_application"]':{
				'change': this.UserOnChange
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
	            	},
			'main button[id="bckButton_1"]': {
	                	'click': this.backFun
	            	},
			'thinclientuserform combo[id="er_option"]':
			{
				'select': this.onSelectAnalysisBy
			},
			'thinclientuserform radiogroup[id=er_showDeliveryGroup]' : {
				'change' : this.showDeliveryGroup
			},
		});
	},
	showDeliveryGroup:function(btn)
	{
		var val=btn.getValue().deliveryGroupValue;
		var er_testTypeVal = '';
		if(val=='Yes')
		{
			Ext.getCmp('optionmultipane').hide();
			Ext.getCmp('er_poolType_container').show();
			
		}
		else
		{
			Ext.getCmp('optionmultipane').show();
			Ext.getCmp('er_poolType_container').hide();

		}
	},
	onSelectAnalysisBy: function (obj) {
		var params="";
		var reportCat=Ext.getCmp('report_category').getValue();
		var urlStr="";
		initLdgMask.show();
		this.updateQStringActivity();
		params=appConstants.queryStringActivity;
		urlStr="/final/reporter/ErUserLogonDetailsReportJson.jsp";
		params+="&onAnalysisChange=true";
		var me=this;
		Ext.Ajax.request({
            url: urlStr,
            params: params,
            method: "POST",
            success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				if(!Ext.isEmpty(jsonData))
				{
					me.fillFormFieldsForActivity(jsonData);
				}
				if (Ext.getCmp('er_option').getValue()=='Component')
					Ext.getCmp('select_farm').hide();
				else
					Ext.getCmp('select_farm').show();
				Ext.getCmp('resultPanel').hide();
				if(jsonData.isVm != undefined && jsonData.isVm == 'true'){
					if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
						if(Ext.getCmp('brokeringFrom') != undefined){
							Ext.getCmp('brokeringFrom').show();
							var brokerngFrm=jsonData.enableBrokeringFor;
							Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
						}
					}
					else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
						if(Ext.getCmp('brokeringFrom') != undefined)
						{
							Ext.getCmp('brokeringFrom').hide();
							var brokerngFrm=jsonData.enableBrokeringFor;
							Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
						}
					}
					else
					{
						var brokerngFrm=jsonData.enableBrokeringFor;
						if(Ext.getCmp('brokeringFrom') != undefined)
							Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
					}
				}
				else{
					if(Ext.getCmp('brokeringFrom') != undefined)
						Ext.getCmp('brokeringFrom').hide();
				}
				if(jsonData.selectedCompType=='Horizon_Pod')
				{
					Ext.getCmp('brokeringFrom').hide();
					Ext.getCmp('er_priority').hide();
					Ext.getCmp('optionmultipane').hide();
					Ext.getCmp('er_poolType_container').show();
				}
				else
				{
					Ext.getCmp('er_poolType_container').hide();
				}
				if(Ext.getCmp('inclReconnect') != undefined){
					if(Ext.getCmp('er_compType').getValue() == 'Citrix_XcXenApp_server')
						Ext.getCmp('inclReconnect').show();
					else
						Ext.getCmp('inclReconnect').hide();
				}
				initLdgMask.hide();
			
			}
		});
	},
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var reportCat=Ext.getCmp('report_category').getValue();
		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
		if(reportCat == 'user_usage')
			hiddenFields =  appConstants.publicjsonDataUsage.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			this.saveFavorite();
		}
	},
	changeEr_mode: function (combo) {
		var favorite_id='';
		var from_schModify='';
		var reportCat=Ext.getCmp('report_category').getValue();
		favorite_id = appConstants.publicjsonDataActivity['hiddenfields']["favorite_id"];
		from_schModify = appConstants.publicjsonDataActivity['hiddenfields']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
			duration: 250,
			to: {
				y: -530
			}
		});
		this.submitReport();
	},
	filterMultiselect: function (obj) {	
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger(); 
		if(obj.id=='er_poolType_Search')
		{
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_poolType'),appConstants.rawDataForPoolType);
		}
		else if(obj.id=='compSearch_geo')
		{
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_geoFilter'),appConstants.geoFilterCombo);
		}
		else
		{
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_application'),appConstants.rawDataForUsers);
		}
	},
	compMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_server'),appConstants.rawDataForComponents);
	},
	organizeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
	},
	brokeringFromChange:function(){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var brokeringFrom =Ext.getCmp('brokeringFrom').getValue();
		var urlForAjax="/final/reporter/ErUserLogonDetailsReportJson.jsp?select_farm="+mainForm.findField("select_farm").getValue()+"&er_comptype="+mainForm.findField("er_compType").getValue()+"&er_brokeringFrom="+brokeringFrom;
		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'GET',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);

				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData
				if(mainForm.findField('er_type').getValue() == 'No'){
					comboRawData=jsonData.serverCombo;
					selectedComboOption=jsonData.selectedServer;
					comboObject=Ext.getCmp('er_server');
					appConstants.rawDataForComponents = comboRawData;
					rawDataForUsers=jsonData.userCombo;
					appConstants.rawDataForUsers=jsonData.userCombo;
					comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
						if(comboRawData[0].valueField!=-1)
							comboObject.setValue(comboRawData[0].valueField);
						else
							comboObject.setValue(comboRawData[1].valueField);
					}
					comboRawData=jsonData.userCombo;
					appConstants.rawDataForUsers=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					//appConstants.isExceedUserLimit = false;
					var disableUserCombo = jsonData.disableUserCombo;
					var userTextFieldValue = jsonData.userTextFieldValue;
					if (disableUserCombo != undefined && disableUserCombo=='yes')
						appConstants.isExceedUserLimit = true;
					else
						appConstants.isExceedUserLimit = false;

					if (appConstants.isExceedUserLimit){
						if (mainForm.findField('er_type').getValue() == 'No'){
							Ext.getCmp('er_user').show();
							Ext.getCmp('optionmultipane').hide();
							Ext.getCmp('er_user').setValue(userTextFieldValue);
						}
					} 
					else {
						if (mainForm.findField('er_type').getValue() == 'No'){
							appConstants.reportType = false;
							Ext.getCmp('optionmultipane').show();
							Ext.getCmp('er_user').hide();
						} 
						else{
							appConstants.reportType = true;
							Ext.getCmp('optionmultipane').hide();
						}
						comboObject=mainForm.findField('er_application');
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					Ext.getCmp('serverMultiSelectLbl').show();
				}else{
					if(!isSettingsEnabled)
					{
						this.showConfigDropdown();
						this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
					}
					var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
					var graphval=jsonData.selectedGraphType;
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					if (graphval == "timeline")
					{
						comboRawData = jsonData.aggbasedOn;
						selectedComboOption = jsonData.selectedAgg;
						comboObject = thinclientuserSettingsForm.findField("er_perserver");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
						comboRawData = jsonData.userCombo;
						appConstants.rawDataForUsers=jsonData.userCombo;
						selectedComboOption = jsonData.selectedUser;
					}
					else{
						if(Ext.getCmp("er_perserver")!=undefined)
							Ext.getCmp('er_perserver').hide();
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.selectedMeasure;
					}
				}
				initLdgMask.hide();
			},
			failure: function() {
				initLdgMask.hide();
			}
		});
	},
	compTypeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax="/final/reporter/ErUserLogonDetailsReportJson.jsp?select_farm="+mainForm.findField("select_farm").getValue()+"&er_comptype="+mainForm.findField("er_compType").getValue();
			var compnt=mainForm.findField("er_compType").getValue();
			if(Ext.getCmp('inclReconnect') != undefined){
				if(compnt == 'Citrix_XcXenApp_server')
					Ext.getCmp('inclReconnect').show();
				else
					Ext.getCmp('inclReconnect').hide();
			}
			if(Ext.getCmp('enableDetailedData') != undefined && mainForm.findField('er_type').getValue() == 'No'){
				if(compnt!=undefined && compnt == 'Citrix_XcXenApp_server')
					Ext.getCmp('enableDetailedData').hide();
				else
					Ext.getCmp('enableDetailedData').show();
			}
			this.updateQStringActivity();
			Ext.Ajax.request(
			{
				url : urlForAjax,
				params : appConstants.queryStringActivity,
				scope:this,
				method : 'GET',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var screenLabels=jsonData.screenLabels;
					appConstants.publicjsonDataActivity=jsonData
					if(mainForm.findField('er_type').getValue() == 'No'){
						comboRawData=jsonData.serverCombo;
						selectedComboOption=jsonData.selectedServer;
						comboObject=Ext.getCmp('er_server');
						appConstants.rawDataForComponents = comboRawData;
						rawDataForUsers=jsonData.userCombo;
						appConstants.rawDataForUsers=jsonData.userCombo;
						comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
							if(comboRawData[0].valueField!=-1)
								comboObject.setValue(comboRawData[0].valueField);
							else
								comboObject.setValue(comboRawData[1].valueField);
						}
						comboRawData=jsonData.userCombo;
						appConstants.rawDataForUsers=jsonData.userCombo;
						selectedComboOption=jsonData.selectedUser;
						var disableUserCombo = jsonData.disableUserCombo;
						var userTextFieldValue = jsonData.userTextFieldValue;
						if (disableUserCombo != undefined && disableUserCombo=='yes')
						{
							appConstants.isExceedUserLimit = true;
						} else
							appConstants.isExceedUserLimit = false;
										
							//appConstants.isExceedUserLimit = false;
						
						comboObject=Ext.getCmp('er_showDeliveryGroup');
						selectedComboOption=jsonData.selectedShowDeliveryGroup;
						comboObject.hide();
						if(selectedComboOption!=undefined)
						{
							comboObject.show();
							comboObject.setFieldLabel(screenLabels['reporter.common.Show Delivery Groups']);
							comboObject=Ext.getCmp('deliveryGroupNo');
							if(selectedComboOption=="Yes")
							{
								comboObject=Ext.getCmp('deliveryGroupYes');
							}
							comboObject.setValue(true);
						}
						if (appConstants.isExceedUserLimit)
						{
							if (mainForm.findField('er_type').getValue() == 'No'){
								Ext.getCmp('er_user').show();
								Ext.getCmp('optionmultipane').hide();
								Ext.getCmp('er_user').setValue(userTextFieldValue);
								if(jsonData.selectedCompType=='Horizon_Pod')
								{
									Ext.getCmp('er_user').hide();
									Ext.getCmp('er_poolType_container').show();
								}
								else
								{
									Ext.getCmp('er_poolType_container').hide();
								}
							}
						} else {
							if (mainForm.findField('er_type').getValue() == 'No')
							{
								appConstants.reportType = false;
								Ext.getCmp('optionmultipane').show();
								Ext.getCmp('er_user').hide();
								if(jsonData.selectedCompType=='Horizon_Pod')
								{
									Ext.getCmp('optionmultipane').hide();
									Ext.getCmp('er_poolType_container').show();
								}
								else
								{
									Ext.getCmp('er_poolType_container').hide();
								}
							} 
							else
							{
								appConstants.reportType = true;
								Ext.getCmp('optionmultipane').hide();
							}
							if(jsonData.selectedCompType=='Citrix_XcXenDesktop_Site')
							{
								if(jsonData.selectedShowDeliveryGroup!=undefined && jsonData.selectedShowDeliveryGroup=='Yes')
								{
									Ext.getCmp('optionmultipane').hide();
									Ext.getCmp('er_user').hide();
									Ext.getCmp('er_poolType_container').show();
								}
							}
							comboObject=mainForm.findField('er_application');
							comboObject.getStore().loadRawData(comboRawData);
							if ( !Ext.isEmpty(selectedComboOption) ){
								comboObject.setValue(selectedComboOption);
							}
							else{
								comboObject.setValue(comboRawData[0].valueField);
							}
							comboObject.show();
						}
						Ext.getCmp('serverMultiSelectLbl').show();
					}else{

						if(!isSettingsEnabled)
						{
							this.showConfigDropdown();
							this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
						}
					var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
					var graphval=jsonData.selectedGraphType;
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
							if (graphval == "timeline")
							{
								comboRawData = jsonData.aggbasedOn;
								selectedComboOption = jsonData.selectedAgg;
								comboObject = thinclientuserSettingsForm.findField("er_perserver");
								comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
								comboObject.getStore().loadRawData(comboRawData);
								if (!Ext.isEmpty(selectedComboOption)) {
									comboObject.setValue(selectedComboOption);
								} else {
									comboObject.setValue(comboRawData[0].valueField);
								}
								comboObject.show();
								comboRawData = jsonData.userCombo;
								appConstants.rawDataForUsers=jsonData.userCombo;
								selectedComboOption = jsonData.selectedUser;
					}else{
						if(Ext.getCmp("er_perserver")!=undefined)
							Ext.getCmp('er_perserver').hide();
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.selectedMeasure;
					}
					}
					if(jsonData.isVm != undefined && jsonData.isVm == 'true'){
						if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
							if(Ext.getCmp('brokeringFrom') != undefined){
								Ext.getCmp('brokeringFrom').show();
								var brokerngFrm=jsonData.enableBrokeringFor;
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
							}
						}
						else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
							if(Ext.getCmp('brokeringFrom') != undefined)
							{
								Ext.getCmp('brokeringFrom').hide();
								var brokerngFrm=jsonData.enableBrokeringFor;
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
							}
						}
						else{
							var brokerngFrm=jsonData.enableBrokeringFor;
							if(Ext.getCmp('brokeringFrom') != undefined)
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
						}
					}
					else{
						if(Ext.getCmp('brokeringFrom') != undefined)
							Ext.getCmp('brokeringFrom').hide();
					}
					if(jsonData.selectedCompType=='Horizon_Pod')
					{
						Ext.getCmp('brokeringFrom').hide();
						Ext.getCmp('er_priority').hide();
						Ext.getCmp('optionmultipane').hide();
						Ext.getCmp('er_poolType_container').show();
					}
					else
					{
						Ext.getCmp('er_poolType_container').hide();
					}
				}
			});
	},
	zoneOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
		var QString="";
		if(reportCat == 'user_usage'){
			urlForAjax="/final/reporter/ErCtxUserReportJson.jsp";
			this.updateQStringUsage();
			QString=appConstants.queryStringUsage;
		}
		else{
			if(mainForm.findField('er_type').getValue() == 'No'){
				urlForAjax="/final/reporter/ErUserLogonDetailsReportJson.jsp?select_farm="+mainForm.findField("select_farm").getValue()+"&er_type="+mainForm.findField("er_type").getValue();
			}
			else{
				urlForAjax="/final/reporter/ErUserLogonDetailsReportJson.jsp";
				this.updateQStringActivity();
			}
			QString=appConstants.queryStringActivity;
		}
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'GET',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				if(reportCat == 'user_usage'){
					appConstants.publicjsonDataUsage=jsonData;

					comboRawData=jsonData.compTypeCombo;
					selectedComboOption=jsonData.selectedCompType;
					comboObject=mainForm.findField('er_compType');
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					if(jsonData.isVm != undefined && jsonData.isVm == 'true'){
						if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
							if(Ext.getCmp('brokeringFrom') != undefined){
								Ext.getCmp('brokeringFrom').show();
								var brokerngFrm=jsonData.enableBrokeringFor;
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
							}
						}
						else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
							if(Ext.getCmp('brokeringFrom') != undefined)
							{
								Ext.getCmp('brokeringFrom').hide();
								var brokerngFrm=jsonData.enableBrokeringFor;
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
							}
						}
						else{
							var brokerngFrm=jsonData.enableBrokeringFor;
							if(Ext.getCmp('brokeringFrom') != undefined)
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
						}
					}
					else{
						if(Ext.getCmp('brokeringFrom') != undefined)
							Ext.getCmp('brokeringFrom').hide();
					}
					if(jsonData.selectedCompType=='Horizon_Pod')
					{
						Ext.getCmp('brokeringFrom').hide();
						Ext.getCmp('er_priority').hide();
						Ext.getCmp('optionmultipane').hide();
						Ext.getCmp('er_poolType_container').show();
					}
					else
					{
						Ext.getCmp('er_poolType_container').hide();
					}
					if(Ext.getCmp('inclReconnect') != undefined){
						if(comboObject.getValue() == 'Citrix_XcXenApp_server')
							Ext.getCmp('inclReconnect').show();
						else
							Ext.getCmp('inclReconnect').hide();
					}
					comboRawData=jsonData.ComponentServerArray;
					selectedComboOption=jsonData.selectedComps;
					comboObject=Ext.getCmp('er_server');
					appConstants.rawDataForComponents = comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				else{
					appConstants.publicjsonDataActivity=jsonData;
					comboRawData=jsonData.compTypeCombo;
					selectedComboOption=jsonData.selectedCompType;
					comboObject=mainForm.findField('er_compType');
					comboObject.getStore().clearFilter(true);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					if(jsonData.isVm != undefined && jsonData.isVm == 'true'){
						if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
							if(Ext.getCmp('brokeringFrom') != undefined){
								Ext.getCmp('brokeringFrom').show();
								var brokerngFrm=jsonData.enableBrokeringFor;
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
							}
						}
						else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
							if(Ext.getCmp('brokeringFrom') != undefined)
							{
								Ext.getCmp('brokeringFrom').hide();
								var brokerngFrm=jsonData.enableBrokeringFor;
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
							}
						}

						else{
							var brokerngFrm=jsonData.enableBrokeringFor;
							if(Ext.getCmp('brokeringFrom') != undefined)
								Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
						}
					}
					else{
						if(Ext.getCmp('brokeringFrom') != undefined)
							Ext.getCmp('brokeringFrom').hide();
					}
					if(jsonData.selectedCompType=='Horizon_Pod')
					{
						Ext.getCmp('brokeringFrom').hide();
						Ext.getCmp('er_priority').hide();
						Ext.getCmp('optionmultipane').hide();
						Ext.getCmp('er_poolType_container').show();
					}
					else
					{
						Ext.getCmp('er_poolType_container').hide();
					}
					if(Ext.getCmp('inclReconnect') != undefined){
						if(comboObject.getValue() == 'Citrix_XcXenApp_server')
							Ext.getCmp('inclReconnect').show();
						else
							Ext.getCmp('inclReconnect').hide();
					}
					if(mainForm.findField('er_type').getValue() == 'No'){
						comboRawData=jsonData.serverCombo;
						selectedComboOption=jsonData.selectedServer;
						comboObject=Ext.getCmp('er_server');
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						Ext.getCmp('serverMultiSelectLbl').show();
					}
				}
			}
		});
	},
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		if(btn.id=='er_poolType_expand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_poolType'),Ext.getCmp('er_poolType_container').getFieldLabel(),btn);
		}
		else
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('compLbl').text,btn);
		}
	},
	expandMeGeo:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_geoFilter'),Ext.getCmp('multiSelectLabel_geo').text,btn);
	},
	UserOnChange:function( obj){
		var componentVal = obj.getValue();
		var all_individual_alert = 'All Users and Individual selection cannot be selected simultaneously';
		if((Ext.Array.contains(componentVal,'--All--')|| Ext.Array.contains(componentVal,'--all--')) && componentVal.length>1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg:  all_individual_alert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
	},
	serverOnChange:function( obj, newValue, oldValue, eOpts ){
		if (Ext.isEmpty(newValue))
		{
			return false;
		}
		var componentVal = obj.getValue();
		var all_individual_alert = 'All Components and Individual selection cannot be selected simultaneously';
		if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg:  all_individual_alert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		myMask = new Ext.LoadMask(Ext.getBody(), {msg : "Loading..."});
		myMask.show();

		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		if(!isSettingsEnabled)
		{
			this.showConfigDropdown();
			this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		}
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var s_server=Ext.getCmp('er_server').getValue();
		var s_repType=mainForm.findField('er_type').getValue();
		if(s_repType!=null && s_repType!=undefined && s_repType=='No'){
			this.updateQStringActivity();
			var brokeringFrom =Ext.getCmp('brokeringFrom').getValue();
			Ext.Ajax.request(
			{
				url : '/final/reporter/ErUserLogonDetailsReportJson.jsp',
				params : appConstants.queryStringActivity+"&er_brokeringFrom="+brokeringFrom,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);

					comboRawData=jsonData.userCombo;
					appConstants.rawDataForUsers=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					} else {
						if(comboRawData[0].valueField!=-1)
							comboObject.setValue(comboRawData[0].valueField);
						else
							comboObject.setValue(comboRawData[1].valueField); //added for components not auto select
					}

					comboRawData=jsonData.poolTypeCombo;
					if(comboRawData!=undefined)
					{
						appConstants.rawDataForPoolType=jsonData.poolTypeCombo;
						selectedComboOption=jsonData.poolTypeSelected;
						comboObject=mainForm.findField('er_poolType');
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						} else {
							if(comboRawData[0].valueField!=-1)
								comboObject.setValue(comboRawData[0].valueField);
							else
								comboObject.setValue(comboRawData[1].valueField); //added for pool type not auto select
						}
						Ext.getCmp('er_poolType_container').setFieldLabel(jsonData.screenLabels['reporter.thin.poolTypeLabel']);
					}
					if(s_server!=null && s_server!=undefined && s_server.length>1) {
						comboRawData=jsonData.aggAcrossServer;
						if(!Ext.isEmpty(comboRawData))
						{
							selectedComboOption=jsonData.selectedAggServer;
							comboObject=thinclientuserSettingsForm.findField('er_perserver');
							comboObject.setFieldLabel(jsonData.screenLabels['reporter.thin.Aggregate across servers on']);
							comboObject.getStore().loadRawData(comboRawData);
							if ( !Ext.isEmpty(selectedComboOption) ){
								comboObject.setValue(selectedComboOption);
							}
							else{
								comboObject.setValue(comboRawData[0].valueField);
							}
							comboObject.show();
						}
					}
					var disableUserCombo = jsonData.disableUserCombo;
					var userTextFieldValue = jsonData.userTextFieldValue;
					if (disableUserCombo != undefined && disableUserCombo=='yes')
						appConstants.isExceedUserLimit = true;
					else
						appConstants.isExceedUserLimit = false;
					if (appConstants.isExceedUserLimit)
					{
						if (mainForm.findField('er_type').getValue() == 'No')
						{
							appConstants.reportType = false;
							Ext.getCmp('er_user').show();
							Ext.getCmp('optionmultipane').hide();
							Ext.getCmp('er_user').setValue(userTextFieldValue);
							if(jsonData.selectedCompType=='Horizon_Pod')
							{
								Ext.getCmp('er_user').hide();
								Ext.getCmp('er_poolType_container').show();
							}
							else
							{
								Ext.getCmp('er_poolType_container').hide();
							}
						}
						else
						{
							appConstants.reportType = true;
						}
					}
					else
					{
						if (mainForm.findField('er_type').getValue() == 'No')
						{
							appConstants.reportType = false;
							Ext.getCmp('optionmultipane').show();
							Ext.getCmp('er_user').hide();
							if(jsonData.selectedCompType=='Horizon_Pod')
							{
								Ext.getCmp('optionmultipane').hide();
								Ext.getCmp('er_poolType_container').show();
							}
							else
							{
								Ext.getCmp('er_poolType_container').hide();
							}
						}
						else
						{
							appConstants.reportType = true;
							Ext.getCmp('optionmultipane').hide();
						}
					}
					if(jsonData.selectedCompType=='Citrix_XcXenDesktop_Site' && jsonData.selectedShowDeliveryGroup!=undefined && jsonData.selectedShowDeliveryGroup=='Yes')
					{
						Ext.getCmp('optionmultipane').hide();
						Ext.getCmp('er_user').hide();
						Ext.getCmp('er_poolType_container').show();			
					}
				}
			});
		}else{
			if(Ext.getCmp("er_perserver")!=undefined)
				Ext.getCmp('er_perserver').hide();
		}
		myMask.hide();
	},
	expandMe2: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'),Ext.getCmp('compLbl').text,btn);
	},
	graphTypeOnChange:function(obj){
		var val=obj.getValue();
		Ext.getCmp('resultPanel').hide();
		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErUserLogonDetailsReportJson.jsp',
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				if(!isSettingsEnabled)
				{
					this.showConfigDropdown();
					this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
				}
				var mainForm =Ext.getCmp('mainform').getForm();
				var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
				if(val == 'timeline'){
					appConstants.publicjsonDataActivity=jsonData;
					comboRawData=jsonData.aggbasedOn;
					selectedComboOption=jsonData.selectedAgg;
					comboObject=thinclientuserSettingsForm.findField('er_perserver');
					comboObject.setFieldLabel(screenLabels['reporter.thin.Aggregate across servers']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
				}else{
					Ext.getCmp('er_checkbox').hide();
					if(Ext.getCmp("er_perserver")!=undefined)
						Ext.getCmp('er_perserver').hide();
				}
			}
		});
	},
	reportTypeOnChange:function(obj){
		var mainForm =Ext.getCmp('mainform').getForm();
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('er_checkbox').hide();
		var val=obj.getValue();
		if(!isSettingsEnabled)
		{
			this.showConfigDropdown();
			this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		}

		if (mainForm.findField('er_type').getValue() == 'Yes')
		{
			appConstants.reportType = true;
			Ext.getCmp('er_user').hide();
			Ext.getCmp('optionmultipane').hide();
		} else
			appConstants.reportType = false;
 		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
        this.updateQStringActivity();
		var url = "/final/reporter/ErUserLogonDetailsReportJson.jsp?";
		var param = "er_type="+mainForm.findField("er_type").getValue()+"&er_gtype=Citrix&er_rtype=UserLogon&option=Citrix&er_trgttype=UserLogon Report&er_RmDispName=User Logon Performance&isLegendEnabled=true";
		var me = this;
		Ext.Ajax.request(
		{
			url : url,
            params: param,
			scope:this,
			method : 'POST',
			async : false,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData;
				me.loadFormDataInfo(jsonData)
				if(val == 'No')
				{
 					comboRawData=jsonData.serverCombo;
					appConstants.rawDataForUsers=jsonData.userCombo;
					appConstants.rawDataForUsers=jsonData.userCombo;
					selectedComboOption=jsonData.selectedServer;
					
					/*comboObject=Ext.getCmp('er_server');
					multiServerObject=Ext.getCmp('expandSelector');
					appConstants.rawDataForComponents = comboRawData;
 					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					multiServerObject.show();
					comboObject.show();*/

					if(selectedComboOption !=null  && selectedComboOption.indexOf("All ")>-1)
						thinclientuserSettingsForm.findField('er_perserver').show();
					comboRawData=jsonData.userCombo;
					appConstants.rawDataForUsers=jsonData.userCombo;
  					selectedComboOption=jsonData.selectedUser;
					var disableUserCombo = jsonData.disableUserCombo;
					var userTextFieldValue = jsonData.userTextFieldValue;
					if (disableUserCombo != undefined && disableUserCombo=='yes'){
						appConstants.isExceedUserLimit = true;
					} else
						appConstants.isExceedUserLimit = false;

					//appConstants.isExceedUserLimit = false;
					if (appConstants.isExceedUserLimit){
						if (mainForm.findField('er_type').getValue() == 'No')
						{
							appConstants.reportType = false;
							Ext.getCmp('er_user').show();
							Ext.getCmp('optionmultipane').hide();
							Ext.getCmp('er_user').setValue(userTextFieldValue);
							if(jsonData.selectedCompType=='Horizon_Pod')
							{
								Ext.getCmp('er_user').hide();
								Ext.getCmp('er_poolType_container').show();
							}
							else
							{
								Ext.getCmp('er_poolType_container').hide();
							}
						} 
						else
						{
							appConstants.reportType = true;
						}
					} else {
						if (mainForm.findField('er_type').getValue() == 'No')
						{
							appConstants.reportType = false;
							Ext.getCmp('optionmultipane').show();
							Ext.getCmp('er_user').hide();
							if(jsonData.selectedCompType=='Horizon_Pod')
							{
								Ext.getCmp('optionmultipane').hide();
								Ext.getCmp('er_poolType_container').show();
							}
							else
							{
								Ext.getCmp('er_poolType_container').hide();
							}
						} else
						{
							appConstants.reportType = true;
							Ext.getCmp('optionmultipane').hide();
						}
						comboObject=mainForm.findField('er_application');
  						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							if (comboRawData != undefined )
								comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					Ext.getCmp("aggregateValue").show();
					Ext.getCmp('serverMultiSelectLbl').show();
					comboRawData=jsonData.priorityCombo;
					selectedComboOption=jsonData.selectedPriority;
					comboObject=mainForm.findField('er_priority');
					comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[2].valueField);
					}
					comboObject.show();
					var eDdTmp = appConstants.publicjsonDataActivity;
					var eDd = eDdTmp['enableDetailedData'];
					Ext.getCmp('duraSelect').show();
					Ext.getCmp('glduration').show();
					Ext.getCmp('duration').show();
					Ext.getCmp('enableAggregation').show();
					var comptype = mainForm.findField('er_compType').getValue();
					if(eDd!='No' && comptype!=undefined && comptype != 'Citrix_XcXenApp_server')
						Ext.getCmp('enableDetailedData').show();
					
					Ext.getCmp('aggressionSplitter').show();
					var chkBxvalue=Ext.getCmp('enableAggregation').checked;
					if(chkBxvalue)
						Ext.getCmp('lowLimitLbl').show();
					else
						Ext.getCmp('lowLimitLbl').hide();
				}
				else
				{
					Ext.getCmp('duraSelect').hide();
					Ext.getCmp('glduration').hide();
					Ext.getCmp('duration').hide();
					Ext.getCmp('aggressionSplitter').hide();
					Ext.getCmp('enableAggregation').hide();
					Ext.getCmp('enableDetailedData').hide();
					Ext.getCmp('lowLimitLbl').hide();
					Ext.getCmp("aggregateValue").hide();
					Ext.getCmp("er_priority").hide();
					Ext.getCmp('serverMultiSelectLbl').hide();
					Ext.getCmp('er_poolType_container').hide();
					thinclientuserSettingsForm.findField('er_perserver').hide();
					var graphval=jsonData.selectedGraphType;
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					if (graphval == "timeline") {
						comboRawData = jsonData.aggbasedOn;
						selectedComboOption = jsonData.selectedAgg;
						comboObject = thinclientuserSettingsForm.findField("er_perserver");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
						Ext.getCmp('serverMultiSelectLbl').show();
					}else{
						thinclientuserSettingsForm.findField('er_perserver').hide();
					}
				}
				var reportGenCombo=jsonData.reportGenerationCombo;
				var selreportGeneration=jsonData.reportGeneration;
				var reportGen=Ext.getCmp('reportGeneration');
				var setRepoGen= reportGenCombo[0].valueField;
				var reportNameObj = Ext.getCmp('bgReportName');
				reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
				reportGen.getStore().loadRawData(reportGenCombo);
				reportGen.setValue(setRepoGen);
				if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
				{
					reportNameObj.hide();
				}
				else
				{
					reportNameObj.show();
				}
				initLdgMask.hide();
			}
		});
	},
	reportCatChange:function(obj){
		initLdgMask.show();
		var value =obj.getValue();
		if(value == 'user_usage'){
			this.LoadFieldsForUsage();
		}
		else{
			this.LoadFieldsForActivity();
		}
		Ext.getCmp('resultPanel').hide();
	},
	LoadFieldsForActivity:function(){
		var url = "/final/reporter/ErUserLogonDetailsReportJson.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForActivity(jsonData);
				var mainForm =Ext.getCmp('mainform').getForm();
				mainForm.findField("er_type").show();
				mainForm.findField("er_compType").show();
				mainForm.findField("er_mode").show();
				initLdgMask.hide();
			}
		});
	},
	LoadFieldsForUsage:function(){
		var url = "/final/reporter/ErCtxUserReportJson.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				appConstants.isAdDiscoverEnabled=appConstants.publicjsonDataUsage.isAdDiscoverEnabled;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForUsage(jsonData);
			}
		});
	},
	fillFormFieldsForUsage:function(jsonData){
		var mainForm =Ext.getCmp('mainform').getForm();
		mainForm.findField("er_type").hide();
		mainForm.findField("er_mode").hide();
		mainForm.findField("er_compType").show();
		var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
        	var from_schedule = hiddenFields["fromScheduleModify"];
        	if (from_schedule != null && from_schedule == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var screenLabels=jsonData.screenLabels;

		var comboRawData;
		var selectedComboOption;
		var comboObject;

		comboRawData=jsonData.reportForCombo;
		selectedComboOption=jsonData.reportFor;
		comboObject=mainForm.findField('report_category');
		comboObject.setFieldLabel(screenLabels['reporter.common.Report For']);
		comboObject.getStore().loadRawData(comboRawData);

		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}

		comboRawData=jsonData.zoneCombo;
		selectedComboOption=jsonData.selectedZone;
		comboObject=mainForm.findField('select_farm');
		comboObject.getStore().clearFilter(true);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.compTypeCombo;
		selectedComboOption=jsonData.selectedCompType;
		comboObject=mainForm.findField('er_compType');
		comboObject.setFieldLabel(screenLabels['reporter.common.Component Type']);
		comboObject.getStore().clearFilter(true);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.ComponentServerArray;
		selectedComboOption=jsonData.selectedComps;

		comboObject=Ext.getCmp('er_server');
		appConstants.rawDataForComponents = comboRawData;
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}
		if(appConstants.isAdDiscoverEnabled == "true"){
			comboRawData=jsonData.organizeCombo;
			selectedComboOption=jsonData.selectedOrganizeby;
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
					comboObject.show();
		}
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = mainForm.findField('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = mainForm.findField('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = mainForm.findField('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = mainForm.findField('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		updatingAppSettings();
		initLdgMask.hide();
	},
	fillSettingFieldsForUsage:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var screenLabels=jsonData.screenLabels;
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		thinclientuserSettingsForm.findField("er_perserver").hide();
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
	},
	saveReportAsPDF:function()
	{
		var hiddenFieldsTemp   =  appConstants.publicjsonDataActivity;
		var enableDetailedData =  hiddenFieldsTemp['enableDetailedData'];
		if(isSettingsEnabled && enableDetailedData=='Yes'){
			if(Ext.getCmp('enableDetailedData') != undefined)
				enableDetailedData = Ext.getCmp('enableDetailedData').getValue().enableDetailedData1;
		}
		var saveQString;
		var reportFor = Ext.getCmp('report_category').getValue();
		if(reportFor == 'user_activity')
		{
            this.updateQStringActivity();
			saveQString=appConstants.queryStringActivity;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&er_view=PRINT";
		}
		else if(appConstants.report_for == 'user_usage')
		{
			saveQString=appConstants.publicjsonDataUsage.saveQString;
			saveQString+="&pageWidthProces=700&er_view=PRINT";
		}
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString+'&eDd='+enableDetailedData;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined')
		{
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1)
			{
				if(s_qryString.indexOf("&showLegend=")>-1)
				{
					if(islegendEnabled =='true')
					{
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}
					else
					{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}
				else
					s_qryString+=setLegendVal;
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
 		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString;
		var reportFor = Ext.getCmp('report_category').getValue();
		if(reportFor == 'user_activity')
		{
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&er_view=PRINT";
		}
		else if(appConstants.report_for == 'user_usage')
		{
			saveQString=appConstants.publicjsonDataUsage.saveQString;
			saveQString+="&pageWidthProces=700&er_view=PRINT";
		}
		var s_qryString = saveQString;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined')
		{
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1)
			{
				if(s_qryString.indexOf("&showLegend=")>-1)
				{
					if(islegendEnabled =='true')
					{
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}
					else
					{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}
				else
					s_qryString+=setLegendVal;
			}
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		this.updateQStringActivity();
		var rtype=Ext.getCmp('er_type').getValue();
		if(rtype == 'Yes'){
			bookletquery=appConstants.queryStringActivity;
			bookletquery+="&er_server=-1&er_application=-1&er_sortby=-1&er_perserver=Yes&eDd="+enableDetailedData;
		}
		else{
			bookletquery=appConstants.queryStringActivity+"&eDd="+enableDetailedData;
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);
			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	printReport:function()
	{
		var hiddenFieldsTemp   =  appConstants.publicjsonDataActivity;
		var enableDetailedData =  hiddenFieldsTemp['enableDetailedData'];
		if(isSettingsEnabled && enableDetailedData=='Yes'){
			if(Ext.getCmp('enableDetailedData') != undefined)
				enableDetailedData = Ext.getCmp('enableDetailedData').getValue().enableDetailedData1;
		}
		var s_qryString;
		this.updateQStringActivity();
		s_qryString = "/final/reporter/ErUserLogonDetailsReportPrint.jsp?"+appConstants.queryStringActivity+'&pdfPrint=yes&pdfprint=yes&eDd='+enableDetailedData;
 		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		var hiddenFieldsTemp   =  appConstants.publicjsonDataActivity;
		var enableDetailedData =  hiddenFieldsTemp['enableDetailedData'];
		
		if(isSettingsEnabled && enableDetailedData=='Yes'){
			if(Ext.getCmp('enableDetailedData') != undefined)
				enableDetailedData = Ext.getCmp('enableDetailedData').getValue().enableDetailedData1;
		}
		drillDownParams ='&eDd='+enableDetailedData;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams += "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var hiddenFieldsTemp   =  appConstants.publicjsonDataActivity;
		var enableDetailedData =  hiddenFieldsTemp['enableDetailedData'];
		if(isSettingsEnabled && enableDetailedData=='Yes'){
			if(Ext.getCmp('enableDetailedData') != undefined)
				enableDetailedData = Ext.getCmp('enableDetailedData').getValue().enableDetailedData1;
	  
		}
		var report_cat = Ext.getCmp('report_category').getValue();
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Thin Client Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
			var s_qryString;			
			this.updateQStringActivity();
			var rtype=Ext.getCmp('er_type').getValue();
			if(rtype == 'Yes'){
				s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
				s_qryString+="&er_server=-1&er_application=-1&er_sortby=-1&er_perserver=Yes&eDd="+enableDetailedData;
			}
			else{
				s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity+"&eDd="+enableDetailedData;
			}
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
		if (appConstants.formButtonId=='save')
		{
			target+='&showSchWindow=no&eDd='+enableDetailedData;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return
	},
	saveFavorite:function(){

		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Thin Client Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
			var report_cat = Ext.getCmp('report_category').getValue();

			if(report_cat == 'user_activity'){
				var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
				favorite_id = hiddenFields["favorite_id"];
				this.updateQStringActivity();
				var rtype=Ext.getCmp('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&er_perserver=yes&er_sortby=-1&er_server=-1&er_application=-1&cmd=client";
				}
				else{
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
				}
			}
			else if(report_cat == 'user_usage'){
				var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
				favorite_id = hiddenFields["favorite_id"];
				this.updateQStringUsage();
				s_qryString="../servlet/com.eg.ErFavoriteC?"+appConstants.queryStringUsage+"&er_view=GRAPH&cmd=client";
			}
			var target=s_qryString+"&FavoriteId="+favorite_id+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return;
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm =null;
		if(isSettingsEnabled)
			thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var zone=mainForm.findField('select_farm')
		var reporFor=mainForm.findField('report_category').getValue();
		var reportType=mainForm.findField('er_type').getValue();
		var er_option=mainForm.findField('er_option').getValue();
		var userNameTxt = '';
		if(Ext.getCmp('optionmultipane').isHidden())
		{
			var userNameStr = mainForm.findField('er_user').getValue();
			userNameTxt = userNameStr.split(',');
		}
		if((er_option!=null || er_option!=undefined) && er_option!="Component" )
		{
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}
		
		var compType=mainForm.findField('er_compType');
		if( compType.getValue() == '-1'){
			Ext.MessageBox.show({
			title: 'User Logon Report',
			msg: compType.getStore().getAt(0).get('displayField'),
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
			if(reportType == 'No')
			{
			var server=Ext.getCmp('er_server');
				if( server.getValue() == '-1')
				{
				Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: server.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			var componentVal = server.getValue();
			var all_individual_alert = 'All Components and Individual selection cannot be selected simultaneously';
			if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report',
					msg:  all_individual_alert,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			var enableAggregationVal=Ext.getCmp("enableAggregation").checked;
			if(enableAggregationVal)
			{
				var upperCriticalVal;
				var upperMinorVal;
				var upperMajorVal;
				upperCriticalVal=Ext.getCmp('upperCritical').getValue();
				if(Ext.isEmpty(upperCriticalVal) || upperCriticalVal.length==0)
				{
					Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Invalid Critical Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				upperMajorVal=Ext.getCmp('uppermajor').getValue();
				if(Ext.isEmpty(upperMajorVal) || upperMajorVal.length==0)
				{
					Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Invalid Major Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				upperMinorVal=Ext.getCmp('upperminor').getValue();
				if(Ext.isEmpty(upperMinorVal) || upperMinorVal.length==0)
				{
					Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Invalid Minor Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperCriticalVal<=upperMajorVal || upperCriticalVal<=upperMinorVal)
				{
					Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Critical Value Should be greater than other values',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperMajorVal<=upperMinorVal)
				{
					Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Major Value Should be greater than Minor value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				
			}
			var userflag=false;
			var userArray=Ext.getCmp('er_application').getValue();
			if(userArray!=null && userArray!='undefined' && userArray.length>0){
				for(var k=0;userArray.length>k;k++)
				{
					var userVal=userArray[k];
					if(userVal=="-1" || userVal=="Not Applicable")
						userflag=true;
				}
			}
			if((userNameTxt.length>1 && userNameTxt.indexOf('*')>-1))
			{
				Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Individual and aggregate Users cannot be selected simultaneously',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(Ext.getCmp('optionmultipane').isVisible() && userflag)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report',
					msg: 'User not applicable',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
			}
			if(Ext.getCmp('er_poolType_container').isVisible())
			{
				var er_poolTypeObj = Ext.getCmp('er_poolType');
				var gpArray = er_poolTypeObj.getValue();
				if (gpArray==undefined || gpArray.length == 0 || gpArray[0] =='-1') 
				{
					Ext.MessageBox.show({
						title: 'User Logon Report',
						msg: 'Please choose valid Desktop pools',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				else if (gpArray.length>1 && gpArray.indexOf('all')>-1)
				{
					Ext.MessageBox.show({
						title: 'User Logon Report',
						msg: 'All Desktop pools and Individual selection cannot be selected simultaneously',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			var all_individual_alert = 'All Users and Individual selection cannot be selected simultaneously';
			if((Ext.Array.contains(userArray,'--All--')|| Ext.Array.contains(userArray,'--all--')) && userArray.length>1)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report',
					msg:  all_individual_alert,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		var isSettingsOk = true;
		var hiddenFields;
		hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen = this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		if(isSettingsEnabled)
		{
			var glduration = this.getSettingsFieldValue(thinclientuserSettingsForm,'glduration',isSettingsEnabled,'glduration').toString();
			var durationVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'duration',isSettingsEnabled,'duration').toString();
			var upperCriticalVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperCritical',isSettingsEnabled,'upperCritical').toString();
			var upperMajorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'uppermajor',isSettingsEnabled,'uppermajor').toString();
			var upperMinorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperminor',isSettingsEnabled,'upperminor').toString();
			
			if(!Ext.isEmpty(durationVal) && durationVal.indexOf("-")>-1)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report',
					msg: 'Duration Value cannot be negative',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(!Ext.isEmpty(glduration) && glduration=="l" && !Ext.isEmpty(durationVal) && durationVal==0)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report',
					msg: 'Duration Value cannot be equal to Zero When Duration is lesser than',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(!Ext.isEmpty(upperCriticalVal) && upperCriticalVal.indexOf("-")>-1)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report Report',
					msg: 'Critacal Value cannot be negative',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(!Ext.isEmpty(upperMajorVal) && upperMajorVal.indexOf("-")>-1)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report',
					msg: 'Major Value cannot be negative',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(!Ext.isEmpty(upperMinorVal) && upperMinorVal.indexOf("-")>-1)
			{
				Ext.MessageBox.show({
					title: 'User Logon Report',
					msg: 'Minor Value cannot be negative',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'User Logon settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields["limitforbg"];
				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else{
			var reportName = this.getSettingsFieldValue(thinclientuserSettingsForm,'bgReportName',isSettingsEnabled,'selectedMinsTo');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var server=Ext.getCmp('er_server');
		var isValid = this.validateMainForm(true);
		if(isValid)
			this.submitReport();
		else
			return;
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv') ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			return false;
		}
		var enableAggregationVal=Ext.getCmp("enableAggregation").checked;
		if(enableAggregationVal)
		{
			var upperCriticalVal;
			var upperMinorVal;
			var upperMajorVal;
			upperCriticalVal=Ext.getCmp('upperCritical').getValue();
			if(Ext.isEmpty(upperCriticalVal) || upperCriticalVal.length==0)
			{
				Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Invalid Critical Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			upperMajorVal=Ext.getCmp('uppermajor').getValue();
			if(Ext.isEmpty(upperMajorVal) || upperMajorVal.length==0)
			{
					Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Invalid Major Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			upperMinorVal=Ext.getCmp('upperminor').getValue();
			if(Ext.isEmpty(upperMinorVal) || upperMinorVal.length==0)
			{
				Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Invalid Minor Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(upperCriticalVal<=upperMajorVal || upperCriticalVal<=upperMinorVal)
			{
				Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Critical Value Should be greater than other values',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(upperMajorVal<=upperMinorVal)
			{
				Ext.MessageBox.show({
					title: 'User Logon settings',
					msg: 'Major Value Should be greater than Minor value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}

		}
		var mainForm =Ext.getCmp('mainform').getForm()
		var reportTypeTmp = mainForm.findField('er_type').getValue();
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var glduration = this.getSettingsFieldValue(thinclientuserSettingsForm,'glduration',isSettingsEnabled,'glduration').toString();
		var durationVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'duration',isSettingsEnabled,'duration');
		var upperCriticalVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperCritical',isSettingsEnabled,'upperCritical').toString();
		var upperMajorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'uppermajor',isSettingsEnabled,'uppermajor').toString();
		var upperMinorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperminor',isSettingsEnabled,'upperminor').toString();
		 
		if(durationVal==null && reportTypeTmp=='No'){
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: 'Duration Value cannot be empty',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}else{
			durationVal =durationVal.toString();
		}
		if(!Ext.isEmpty(durationVal) && durationVal.indexOf("-")>-1 && reportTypeTmp=='No')
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: 'Duration Value cannot be negative',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(!Ext.isEmpty(glduration) && glduration=="l" && !Ext.isEmpty(durationVal) && durationVal==0)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: 'Duration Value cannot be equal to Zero When Duration is lesser than',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(!Ext.isEmpty(upperCriticalVal) && upperCriticalVal.indexOf("-")>-1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report Report',
				msg: 'Critacal Value cannot be negative',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(!Ext.isEmpty(upperMajorVal) && upperMajorVal.indexOf("-")>-1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: 'Major Value cannot be negative',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(!Ext.isEmpty(upperMinorVal) && upperMinorVal.indexOf("-")>-1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: 'Minor Value cannot be negative',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		
		var obj = Ext.getCmp('geofilter');
		if (obj!=undefined && !obj.isHidden())
		{
			var compArray = Ext.getCmp("er_geoFilter").getValue();
			if(compArray==undefined || compArray.length==0)
			{
				Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: 'Please choose '+Ext.getCmp('multiSelectLabel_geo').text,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
			else if(compArray.length>1 && compArray.indexOf('all')>-1)
			{
				Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: 'All and Individual selection should not be allowed',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
			
			if(Ext.getCmp('er_poolType_container').isVisible())
			{
				var er_poolTypeObj = Ext.getCmp('er_poolType');
				var gpArray = er_poolTypeObj.getValue();
				if (gpArray==undefined || gpArray.length == 0 || gpArray[0] =='-1') 
				{
					Ext.MessageBox.show({
						title: 'User Logon Report',
						msg: 'Please choose valid Desktop pools',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				else if (gpArray.length>1 && gpArray.indexOf('all')>-1)
				{
					Ext.MessageBox.show({
						title: 'User Logon Report',
						msg: 'All Desktop pools and Individual selection cannot be selected simultaneously',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			this.submitReport();
		}
		else
		{
			if(!isSettingsEnabled)
			{
				this.showConfigDropdown();
				this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
			}
			var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
			var reportGenType=thinclientuserSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientuserSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			var urlNw=URL.substr(0,URL.indexOf('?')+1);
			var qryString=URL.substr(URL.indexOf('?')+1,URL.length-1);
			Ext.Ajax.request({
				url: urlNw,
				params: qryString,
				method: 'POST',
				async: false,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	loadGrid:function(GridData)
	{
		var c=0;
		var me=this;
		var dataArray=new Array();
		var dirDataArray=new Array();
		var itemsArray=new Array();
		var ertype = Ext.getCmp("er_type").getValue();
		var comptype = Ext.getCmp("er_compType").getValue();
		var resultPanelObj=Ext.getCmp('resultPanel');
		var reportBy = Ext.getCmp('aggregateValue').getValue();
		var userLogonInnerTableDivWidth = Ext.getCmp('thinclientuser').getWidth()-100;
		if(resultPanelObj.getHeader() != undefined && resultPanelObj.getHeader().show())
		{
			resultPanelObj.getHeader().hide();
		}
		var isTimeperiodQuery=GridData.isTimeperiodQuery;
		var isBreakDownQuery=GridData.isBreakDownQuery;
		resultPanelObj.removeAll();
		var hasItemId=new Array();
		if(!Ext.isEmpty(isBreakDownQuery) && !Ext.isEmpty(isTimeperiodQuery))
		{
			var margin;
			var flex;
			var hasData=false;
			var itemHbVal=new Array();
			var chartProperties=this.getXmlForUrl(isTimeperiodQuery);
			if (!Ext.isEmpty( chartProperties ) )
			{
				hasData=true;
				hasItemId.push("fusion0");
				var chartbox={
					xtype:'panel',
					data: chartProperties,
					ui:'newGraphPanel',
					columnWidth:0.5,
					height:300,
					margin:'0 5 0 0',
					title:chartProperties.chartTitle,
					autoScroll:false,
					scroll:false,
					id: 'fusion0'
				};
				itemHbVal.push(chartbox);
			}
			chartProperties=isBreakDownQuery;
			if (!Ext.isEmpty( chartProperties ) )
			{
				hasData=true;
				var chartbox={
					xtype:'panel',
					ui:'newGraphPanel',
					title:chartProperties.chartTitle,
					columnWidth:.5,
					height:300,
					margin:'0 0 0 5',
					items:[
					{
						xtype: 'container',
						id : 'fusion_1',
						layout:'column',
						columnWidth : 1.0,
						height:270,
						items:[
						{
							xtype:'container',
							id:'fusion1',
							columnWidth:.6,
							height:270,
							listeners:
							{
								'boxready':function(c)
								{
									if(chartProperties != undefined){
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('fusion1',250,400), lineChart_1);
										lineChart_1.setData(chartProperties,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}else
									{
										Ext.get('fusion_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
									}
								}
							}
						},{
							xtype:'container',
							columnWidth:.4,
							id:'fus_legendId_1',
							height:250,
							listeners:
							{
								'boxready':function(c)
								{
									if(chartProperties != undefined){
										if(chartProperties.pieColors != undefined && chartProperties.pieLabels != undefined && chartProperties.pieLabels.length == chartProperties.pieColors.length){
											var labl=chartProperties.pieLabels;
											var colr=chartProperties.pieColors;
											var legHtml='<div style="height:270px;display:table-cell;vertical-align:middle;"><table>';
											for(var ky in labl){
												legHtml+='<tr><td valign="middle" style="padding-right: 5px;"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:#'+colr[ky]+'"></div></td><td>'+labl[ky]+'&nbsp;</td></tr>';
											}
											legHtml+='</table>';
											Ext.get('fus_legendId_1').update(legHtml);
										}
										var legData=chartProperties.legendArray;
										if(legData != undefined){
											var legObj="";
											var legHtml='<div style="height:270px;display:table-cell;vertical-align:middle;padding-right:  15px;"><table width="100%">';
											for (var key in legData)
											{
												legObj = legData[key];
												legHtml+='<tr><td valign="top" style="padding-right: 5px;padding-top:5px;"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td>'+legObj.name+'</td><td style="padding-left: 15px;" valign="top">'+legObj.val+'</td></tr>';
												if(legObj != undefined && legObj.innerArray != undefined){
													var innerMeasr=legObj.innerArray;
													for(var indx in innerMeasr){
														var legArr=innerMeasr[indx];
														if(legArr != undefined){
															legObj = legData[key];
															legHtml+='<tr><td>&nbsp;</td><td>&nbsp;&nbsp;'+legArr.name+'</td><td valign="top" style="padding-left:15px;">'+legArr.val+'</td></tr>';
														}
													}
												}
											}
											legHtml+='</table>';
											Ext.get('fus_legendId_1').update(legHtml);
										}
									}
								}
							}
						}],
					}],
				};
				itemHbVal.push(chartbox);
			}
			if(hasData)
			{
				dataArray.push({
					xtype:'panel',
					margin:'0 10 10 10',
					border:true,
					layout:{type:'column',align:'stretch'},
					columnWidth:1.0,
					items:itemHbVal
				});
			}
		}
		var gridtitle='<span>User Logon Analysis (Secs)</span>';
		var toolbr='';
		if(Ext.getCmp('enableAggregation') != undefined){
			var chkBxvalue=Ext.getCmp('enableAggregation').checked;
			if(chkBxvalue){
				toolbr+='<div style="margin:2px;float:right;"> <div style="background-color:#1fc1b7;float:left;width:10px;height:10px;margin-top:7px;"></div><div style="float:left;padding: 0px 10px 0px 5px;" class="newFont_normal10">Normal</div><div style="background-color:#d9af54;float:left;width:10px;height:10px;margin-top:7px;"></div><div style="float:left;padding: 0px 10px 0px 5px;" class="newFont_normal10">Low</div><div style="background-color:#fd9f53;float:left;width:10px;height:10px;margin-top:7px;"></div><div style="float:left;padding: 0px 10px 0px 5px;" class="newFont_normal10">Medium</div><div style="background-color:#f57e7e;float:left;width:10px;height:10px;margin-top:7px;"></div><div style="float:left;padding: 0px 10px 0px 5px;" class="newFont_normal10">High</div></div>';
			}
		}
		gridtitle+=toolbr;
		if (ertype!=undefined && ertype=="No" && comptype!=undefined && (comptype=="Citrix_XcXenDesktop_Director"||comptype=="Citrix_XcXenDesktop_Site") && reportBy.groupByValue!=null && reportBy.groupByValue!=undefined )
		{
			var activePage=1;
			if(GridData.NewGridObj != undefined){
				var gridColumn=GridData.NewGridObj.columns;
				var gridData=GridData.NewGridObj.dataArray;
				var mainColArray=new Array();
				var logonval=0;
				var slowLogonInnerTableDivWidth = Ext.getCmp('thinclientuser').getWidth()-100;
				for (var key in gridColumn)
				{
					mainColumn = gridColumn[key];
					var colWidth=80;
					var colAlgn='center';
					if(mainColumn != undefined && (mainColumn == 'session startup Time' || mainColumn == 'Client ip address' || mainColumn == 'Client name' || mainColumn == 'Client version' || mainColumn == 'Launched via ip address' || mainColumn == 'Controller name' || mainColumn == 'Server'  || mainColumn == 'user Name' )){
						colWidth=120;
						colAlgn='left';
					}
					else if(mainColumn != undefined && mainColumn == logonDurationLabel) {
						colWidth=100;
						logonval=key;
					}
					mainColArray.push({
						header:mainColumn,
						align:colAlgn,
						sortable: true,
						width:colWidth,
						dataIndex: mainColumn,
						doSort: function(state) {
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2){
									v1 = v1.get(field);
									v2 = v2.get(field);
									if(v1.indexOf('$$')>-1 && v2.indexOf('$$')>-1){
										v1 = v1.substring(0,v1.indexOf('$$'));
										v2 = v2.substring(0,v2.indexOf('$$'));
									}
									if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
									{
										var tmp = v1.substring(0, v1.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
									}
									if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
									{
										var tmp = v2.substring(0, v2.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
									}
									if(!isNaN(v1) && !isNaN(v2))
									{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										if (state=='ASC')
										{
											v1= isNaN(v1) ? 999999 : v1;
											v2= isNaN(v2) ? 999999 : v2;
										}
										else
										{
											v1= isNaN(v1) ? 0 : v1;
											v2= isNaN(v2) ? 0 : v2;
										}
									}
									else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime();
										v1=new Date(v1).getTime();
									}
									// transform v1 and v2 here
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							if(value.indexOf('$$')>-1)
							{
								var divClassName='';
								var valueType = value.substring(value.indexOf('$$')+2,value.length);
								value = value.substring(0,value.indexOf('$$'));
								if(valueType == 'critical')
									divClassName = 'reporterUserLogonHigh';
								else if(valueType == 'major')
									divClassName = 'reporterUserLogonMedium';
								else if(valueType == 'minor')
									divClassName =  'reporterUserLogonLow';
								else if(valueType == 'normal')
									divClassName = 'reporterUserLogonNormal';
								else
									divClassName='reporterUserLogonDefault';
								metaData.tdAttr = 'data-qtip="' + value + '"';
								metaData.tdCls = "reportLogonGridColumnHighlight";
								value = Ext.getCmp('mainGrid3').getDecimalAlignFormat(value);
								value='<div class='+divClassName+' align="center">'+value+'</div>';
							}
							else{
								metaData.tdAttr = 'data-qtip="' + value + '"';
								value = Ext.getCmp('mainGrid3').getDecimalAlignFormat(value);
							}
							return value;
						}
					});
				}
				var hasChld=false;
				for(var index in gridData)
				{
					var dataInfo = gridData[index];
					var subTableData = dataInfo.dirtData;
					if(subTableData != undefined){
						if(!hasChld){
							hasChld=true;
						}
						var clinetServerData=subTableData.clinetServerData;
						var subTable = '<div style="margin:15px;width:'+slowLogonInnerTableDivWidth+'px;" class="userLogonInnerTableOuter">';
							subTable +='<table width="100%" cellpadding="0" cellspacing="0" border="0px"><tbody><tr><td width="100%" style="padding:10px 0px 10px 0px;"><div class="reporterHtmlFieldsetBody"><div class="reporterLogonFieldsetHeader" nowrap="">'+clinetServerData.title+'</div>';
						var mainHeading=clinetServerData.mainHeader;
						var serverHeader=clinetServerData.serverHeader;
						var clientHeader=clinetServerData.clientHeader;
						var commnData=clinetServerData.commnData;
						var serverData=clinetServerData.serverData;
						var clientData=clinetServerData.clientData;
						subTable +=    '<table width="100%" cellpadding="0" cellspacing="0">';
						if(mainHeading != undefined){
							subTable +=    '<tr><td colspan="3" style="padding:6px;height:30px" align="center"><div class="reporterLogonSessionStartupBox" style="width:350px;height:24px;margin:20px auto 10px  auto;"><table border="0" style="margin:3px auto;"><tbody><tr><td class="reporterLogonSessionStartup">'+mainHeading.key+'(secs) :</td><td class="reporterLogonSessionStartupValue">'+mainHeading.value+'</td></tr></tbody></table></div></td></tr>';
						}
						subTable+='<tr>';
						subTable+='<td style="padding:0px 5px 20px 20px"><table border="0px" style="width:100%" class="reporterLogonServerStartUpTable"><tbody>';
						if(serverHeader != undefined){
							subTable+='<tr>';

							if(commnData != undefined){
								subTable+='<td valign="middle" rowspan="2"><table border="0px" style="width:150px;float:left;margin-top:7px"><tbody>';
									for(var indx in commnData)
									{
										var cmnDt=commnData[indx];
										subTable+='<tr><td><div class="reporterLoginSessionLabel" style="text-align:center;">'+cmnDt.key+'</div><div class="reporterLoginPopupVal" style="text-align:center;">'+cmnDt.value+'</div></td></tr>';
									}
								subTable+='</tbody></table></td>';
							}
							 
							subTable+='<td  valign="top" class="newLineLeft2" style="padding-left:10px;padding-right:20px"><table border="0px" style="width:100%;float:left" ><tbody><tr><td class="reporterLogonPanelHead" style="text-align:left;width:90%">'+serverHeader.key+' (secs) </td><td style="align:right;" class="reporterLogonPanelHead"><div style="float:right;width:80px;text-align:right;">'+serverHeader.value+'</div></td></tr></tbody></table></td></tr>';
						}
						subTable+='<tr>';

						if(serverData != undefined){
							subTable+='<td valign="top" style="padding-left:10px;padding-right:0px"><div style="height:150px;overflow:auto;width:100%;padding:right:10px"><table border="0px" style="float:left;" class="reporterLogonPanelBody"><tbody>';
							for(var sindx in serverData)
							{
								var servDt=serverData[sindx];
									subTable+='<tr><td style="width:90%">'+servDt.key+'</td><td style="align:right;"><div class="valueDiv">'+servDt.value+'</div></td></tr>';
							}
							subTable+='</tbody></table></div></td>';
						}
						subTable+='</tr></tbody></table></td>';

						subTable+='<td style="padding:0px 20px 20px 5px"><table border="0" style="width:100%;float:left" class="reporterLogonServerStartUpTable"><tbody>';
						if(clientHeader != undefined)
						{
							subTable+='<tr><td style="padding-left:10px;padding-right:20px"><table width="100%"><tbody><tr><td class="reporterLogonPanelHead" style="text-align:left;width:90%">'+clientHeader.key+' (secs)</td><td style="align:right;" class="reporterLogonPanelHead"><div style="float:right;width:80px;text-align:right;">'+clientHeader.value+'</div></td></tr></tbody></table></td></tr>';
						}
						subTable+='<tr><td style="padding-left:10px;"><div style="height:150px;overflow:auto;width:100%"><table class="reporterLogonPanelBody" width="100%"><tbody>';
						if(clientData != undefined){
							for(var cindx in clientData)
							{
								var clntDt=clientData[cindx];
								subTable+='<tr><td style="width:80%">'+clntDt.key+'</td><td style="align:right;"><div class="valueDiv">'+clntDt.value+'</div></td></tr>';
							}
						}
						subTable+='</tbody></table></div></td></tr>';
						subTable+='</tbody></table></td>';
						subTable+='</tr></tbody>';
						subTable+='</table>';
						subTable+='</div></td></tr></tbody></table>'

	//for GP Details
						var gpData=subTableData.gpDatas;
						if(gpData != undefined){
							subTable +=' <div class="userLogonInnerTableOuter bg2" style="position:relative;margin:10px 0px 5px 0px;"><div class="reportLog  onGridColumnHighlightArrow" style="left:100px;top:-10px"></div><p class="font_bold12">Details of client side extensions</p><div style="margin-top:10px;" class="newTable"><table width="100%"><thead><tr>';
							var gpHeading=gpData.gpHeader;
							var gpDataArray=gpData.gpDataArr;
							if(gpHeading != undefined){
								for(var gpindex in gpHeading){
									subTable +='<th>'+gpHeading[gpindex]+'</th>';
								}
							}
							subTable +='</tr></thead><tbody>';
							if(gpDataArray != undefined)
							{
								for(var dataindex in gpDataArray)
								{
									subTable +='<tr>';
									var val=gpDataArray[dataindex];
									for(var hdr in gpHeading)
									{
										var strVal=gpHeading[hdr];
										subTable +='<td>'+val[strVal]+'</td>';
									}
									subTable +='</tr>';
								}
							}
							subTable +='</tbody></table></div></div>';
						}
						subTable +='</div>';
						gridData[index]['app']=subTable;
					}
				}
				var fields=[];
				for(var key in gridData[0])
				{
					fields.push(key);
				}
				if(hasChld){
					fields.push('app');
				}
				var storeObj = Ext.create('Ext.data.Store', {
					fields: fields,
					proxy : {
							type : 'pagingmemory',
							reader : {
								type: 'json', root : 'data', totalProperty : 'total'
							},
						},
					pageSize:GridData.NewGridObj.gridRowSize,	//gridPageSize is added in ErTracker.jsp
			//		sorters: { property: fields[logonval], direction : 'DESC' },
					autoLoad : true,
					data:gridData,
				});
				var pluginsVal=[];
				var viewCnfgVal={};
				if(hasChld){
					pluginsVal =[{
								ptype: 'rowexpander',
								selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
								expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
								expandOnEnter : false,
								collapsible: true,
								animCollapse: false,
								rowBodyTpl: [
									 '<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',
								]
							}];
						viewCnfgVal={
										stripeRows: true,
										getRowClass: function (record, rowIndex, rowParams, store)
										{
											if (record.data.app.length>0)
											{
												return ;
											}
											else
											{
												return 'hidePlus';
											}
										}
									};
					 }

				var enableforcefit=true;
				if(reportBy.groupByValue!=null && reportBy.groupByValue!=undefined && reportBy.groupByValue=='Details')
					enableforcefit=false;
				var isPagingHidden;
				if (gridData.length<GridData.NewGridObj.gridRowSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				dataArray.push({
					xtype:'panel',
					ui:'newGraphPanel',
					columnWidth : 1.0,
					margin:'0 10 10 10',
					needtoFixColumn:true,
					title:"User Logon Analysis (Secs)",
					items:[{
						xtype:'customgrid',
						store:storeObj,
						sortableColumns:false,
						ui:'newGridPanel noHoverColor headerTextWrap',
						id:'mainGrid3',
						margin:'0 10 10 10',
						activePage:1,
						border:true,
						scroll:true,
						autoScroll:true,
						columns:mainColArray,
						bodyPadding:'0 0 0 0',
						plugins:pluginsVal ,
						forceFit: enableforcefit,
						viewConfig:viewCnfgVal,
						listeners:{
							sortchange:function(ct, column, e, t, eOpts ){
								me.gridColIndexParam=column.getIndex();
								me.gridColStateParam=column.sortState;
								this.getStore().loadPage(activePage);
							},
							render:function(obj)
							{
								obj.columns[logonval].doSort('ASC');
							}
						},
						dockedItems:[{
							xtype:'pagingtoolbar',
							dock: 'bottom',
							cls:'newPagination',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{
									if(!Ext.isEmpty(params) && !isPagingHidden)
									{
										Ext.getCmp('mainGrid3').activePage = params.currentPage;
									}
									else
										Ext.getCmp('mainGrid3').activePage=1;
								}
							}
						}]

					}]
				});
			}
		}else{
			if (!Ext.isEmpty(GridData))
			{
				if(GridData.NewGridObj != undefined){
					var gridColumn=GridData.NewGridObj.columns;
					var sortIndex;
					if (reportBy.groupByValue!=undefined && reportBy.groupByValue=='Summary')
					{
						sortIndex=4;
					}
					else
					{
						sortIndex=GridData.NewGridObj.sortIndex;
					}
					if(sortIndex == undefined || sortIndex == 'undefined')
					{
						sortIndex = GridData.sortIndex;
					} 
					var gridData=GridData.NewGridObj.dataArray;
					var mainColArray=new Array();
					var fitToWidth=false;
					var needToFixCol = true;
					var usrlogonVal=0;
					if(gridColumn.length<=9)
					{
						fitToWidth=true;
						needToFixCol = false;
					}
//					var align='left';
					var cnt=0;
					var users='';
					for (var key in gridColumn)
					{
						var columnWidth=170;
						mainColumn = gridColumn[key];
						var colIndex=mainColumn;
//						if(mainColumn.indexOf('(')>-1)
//							align='center';
//						else
//							align='left';
						if(cnt==0)
							columnWidth=150;
						else
							columnWidth=120;
						mainColumn=mainColumn.trim();
						var algn='center';
						if(mainColumn == 'User Name' || mainColumn == 'Server' || mainColumn == 'session startup Time' || mainColumn == 'Client ip address' || mainColumn == 'Client name')
							algn='left';
						if(mainColumn != undefined && mainColumn == 'Session start-up duration')
							usrlogonVal=key;
						var mainColumnVal =	mainColumn;
						mainColArray.push({
							header:mainColumnVal,
							sortable: true,
							//width:columnWidth,
							align:algn,
							dataIndex: colIndex,
							renderer:function(value, meta, record, rowIndex, colIndex, store){
								if(value.indexOf('$$')>-1)
								{
									var divClassName='';
									var valueType = value.substring(value.indexOf('$$')+2,value.length);
									value = value.substring(0,value.indexOf('$$'));
									if(valueType == 'critical')
										divClassName = 'reporterUserLogonHigh';
									else if(valueType == 'major')
										divClassName = 'reporterUserLogonMedium';
									else if(valueType == 'minor')
										divClassName =  'reporterUserLogonLow';
									else if(valueType == 'normal')
										divClassName = 'reporterUserLogonNormal';
									else
										divClassName='reporterUserLogonDefault';
									meta.tdAttr = 'data-qtip="' + value + '"';
									meta.tdCls = "reportLogonGridColumnHighlight";
									value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
									value='<div class='+divClassName+' align="center" style="width:60%;">'+value+'</div>';
								}
								else{
									meta.tdAttr = 'data-qtip="' + value + '"';
									value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
								}
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1.indexOf('$$')>-1)
										{
											v1=v1.substring(0,v1.indexOf('$$'));
										}
										if(v2.indexOf('$$')>-1)
										{
											v2=v2.substring(0,v2.indexOf('$$'));
										}
										if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
										{
											var tmp = v1.substring(0, v1.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
										}
										if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
										{
											var tmp = v2.substring(0, v2.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime();
											v1=new Date(v1).getTime();
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							}
						});
						cnt++;
					}

					for(var index in gridData)
					{
						var dataInfo = gridData[index];
						var subTableData = dataInfo.additionalDatas;
						var subTableDataforVDI = dataInfo.additionalDatasforVDI;
						var gpTableData = dataInfo.GPDetails;
						if(subTableData != undefined){
							var serverData=subTableData.Server;
							var clientData=subTableData.Client;
							var subTable = '<div style="margin:5px;"><table width="100%" border="0px" >';
							subTable +='<tr>';
							if(serverData != undefined){
								subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">Server Start up (secs)</div><div ><table>';
								for(var ind in serverData)
								{
									var sevrData=serverData[ind];
									subTable+='<tr><td>'+sevrData.key+'</td><td>'+sevrData.value+'</td></tr>';
								}
								subTable +='</table></div></div></td>';
							}
							if(clientData != undefined){
								subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">Client Start up (secs)</div><div><table>';
								for(var ind in clientData)
								{
									var clntData=clientData[ind];
									subTable+='<tr><td>'+clntData.key+'</td><td>'+clntData.value+'</td></tr>';
								}
								subTable +='</table></div></div></td>';
							}
							subTable +='</tr>';
							subTable +='</table></div>';
						}
						if(subTableDataforVDI != undefined){
							var logonbreakup=subTableDataforVDI.logonBreakup;
							var gpBreakup=subTableDataforVDI.gpBreakup;
							var subTable = '<div style="margin:5px;"><table width="100%" border="0px" >';
							subTable +='<tr>';
							if(logonbreakup != undefined){
								subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">logon Time Break-up (secs)</div><div style="height:140px;"><table>';
								for(var ind in logonbreakup)
								{
									var sevrData=logonbreakup[ind];
									subTable+='<tr><td>'+sevrData.key+'</td><td>'+sevrData.value+'</td></tr>';
								}
								subTable +='</table></div></div></td>';
							}
							if(gpBreakup != undefined){
								subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">Group policy Time Break-up (secs)</div><div style="height:140px;"><table>';
								for(var ind in gpBreakup)
								{
									var clntData=gpBreakup[ind];
									subTable+='<tr><td>'+clntData.key+'</td><td>'+clntData.value+'</td></tr>';
								}
								subTable +='</table></div></div></td>';
							}
							subTable +='</tr>';
							subTable +='</table></div>';
						}

						if(gpTableData != undefined){
							var gpHeader=gpTableData.Header;
							var gpData=gpTableData.Datas;
							subTable += '<div style="margin:5px;" class="newTable"><div class="font_bold12">Details of client side extensions</div><table width="100%" border="0px" >';
							subTable +='<thead><tr>';
							for(var hdr in gpHeader)
							{
								subTable +='<th>'+gpHeader[hdr]+'</th>';
							}
							subTable +='</tr></thead><tbody>';
							for(var dt in gpData)
							{
								var val=gpData[dt];
								subTable +='<tr>';
								for(var hdr in gpHeader)
								{
									var strVal=gpHeader[hdr];
									subTable +='<td>'+val[strVal]+'</td>';
								}
								subTable +='</tr>';
							}
							subTable +='</tbody></table></div>';
						}
						gridData[index]['app']=subTable;
					}
					var fetchedData = function()
					{
						this.data = null;
						this.total = 0;
					}
					var isPagingHidden;
					if (gridData.length<GridData.NewGridObj.gridRowSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					var fields=[];
					var colLen=Object.keys(gridData[0]).length;
					for(var key in gridData[0])
					{
						fields.push(key);
					}
					fields.push('app');
					var storeObj = Ext.create('Ext.data.Store', {
						fields: fields,
						proxy : {
								type : 'pagingmemory',
								reader : {
									type: 'json', root : 'data', totalProperty : 'total'
								},
							},
						pageSize:GridData.NewGridObj.gridRowSize,	//gridPageSize is added in ErTracker.jsp
					//	sorters: { property: fields[usrlogonVal], direction : 'DESC' },
						autoLoad : true,
						data:gridData,
					});
					var activePage=1;
					var title = 'User Logon Analysis (Secs)';
					if (comptype!=undefined && comptype=='Citrix_XcXenApp_server')
					{
						title = 'Session Startup Analysis (Secs)';
					}
					gridtitle='<span>'+title+'</span>'+toolbr
					dataArray.push({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth : 1.0,
						margin:'0 10 10 10',
						title:gridtitle,
						items:[{
							xtype:'customgrid',
							store:storeObj,
							ui:'newGridPanel headerTextWrap noHoverColor',
							sortableColumns:true,
							margin:'10 10 10 10',
							id:'mainGrid',
							columns:mainColArray,
							bodyPadding:'0 0 0 0',
							scroll:true,
							border:true,
							forceFit: true,
						//	needtoFixColumn:needToFixCol,
						//	needtoFixColumn:true,
							popUpData:'noTooltip',
							plugins: [{
								ptype: 'rowexpander',
								selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
								expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
								expandOnEnter : false,
								collapsible: true,
								animCollapse: false,
								rowBodyTpl: [
									'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',	
								]
							}],
							viewConfig:
							{
								stripeRows: true,
								getRowClass: function (record, rowIndex, rowParams, store)
								{
									if (record.data.app.length>0)
									{
										return ;
									}
									else
									{
										return 'hidePlus';
									}
								}
							},
							listeners:{
								sortchange:function(ct, column, e, t, eOpts ){
									me.gridColIndexParam=column.getIndex();
									me.gridColStateParam=column.sortState;
									this.getStore().loadPage(activePage);
								},
								render:function(obj){
									Ext.defer(function() {
										obj.columns[sortIndex].setSortState('ASC', true, false);
									},100);
								}
							},
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params) && !isPagingHidden)
										{
											activePage = params.currentPage;
										}
										else
											activePage=1;
									}
								}
							}]
						}]
					});
				}
			}
			if(reportBy.groupByValue=='Summary')
			{
				Ext.getCmp("bckButton_1").hide();
				if (appConstants.enableBack!=undefined && appConstants.enableBack=='yes')
				{
					Ext.getCmp("bckButton").show();
				}
			}
		}
		Ext.getCmp("csvTool").setDisabled(false);

		var LogonDetail=GridData.LogonDetails;
		var content='<div style="margin:10px;"><table width="100%" border="0px"><tr width="100%">';
		var colWidth="25%";
		var reconnectsGraph=GridData.sessionReconnectGraph;
		if(reconnectsGraph != undefined){
			colWidth="20%";
		}
		for (var key in LogonDetail)
		{
			var logonSummary = LogonDetail[key];
			var vl='';
			if(logonSummary.name != undefined && logonSummary.name == 'Users' && logonSummary.value != undefined && logonSummary.value > 0){
				vl=' style="cursor:pointer" onclick="javascript:openDrillDownWin(\'/final/reporter/ErSlowLogonDetailsReportDrillDown.jsp?frm=userlogon&reqFrom=userLogon\');"'
			}
			content+='<td align="center" width="'+colWidth+'"><table '+vl+'><tr><td align="right" style="padding-right:5px"><div class="'+logonSummary.iconclass+'"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28">'+logonSummary.value+'</td></tr><tr><td style="text-align:center;padding: 5px;" colspan="2"><span class="newFont_normal13" >'+logonSummary.name+'</span></td></tr></table></td>';
		}
		if(reconnectsGraph != undefined)
		{
			var dataSet = reconnectsGraph.DataSet;
			var data = dataSet[0].data;
			var ReConnectVal = data[0].y;
			var connectVal = data[1].y;
			content+='<td  width="'+colWidth+'"><table width="100%"><tr><td width="60%"><div id="reconn_1"></div></td><td width="40%"><table align="center"><tr><td><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:#ffc76b"></div></td><td>&nbsp;Connect&nbsp;</td><td>&nbsp;('+connectVal+')</td></tr><tr><td><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:#00aaa0"></div></td><td>&nbsp;Reconnect</td><td>&nbsp;('+ReConnectVal+')</td></tr></table></td></tr></table></td>';
		}
		content+='</tr></table></div>';
		var LogonDetailTitle=GridData.LogonDetailsTitle;
		if(LogonDetailTitle == undefined)
			LogonDetailTitle='Overview';

		resultPanelObj.add({
			xtype: 'panel',
			ui:'newGraphPanel',
			title:LogonDetailTitle,
			margin:'10 10 10 10',
			columnWidth : 1.0,
			html:content
		},
		{
			xtype: 'panel',
			columnWidth : 1.0,
			layout:'column',
			margin:'0 10 0 10',
			items:[
			{
				xtype:'panel',
				ui:'newGraphPanel',
				title:'Logon Performance Distribution',
				margin:'0 5 10 0',
				height:300,
				columnWidth:.5,
				items:[
					{
						xtype: 'container',
						id : 'Logon_Id',
						layout:'column',
						columnWidth : 1.0,
						height:270,
						items:[
						{
							xtype:'container',
							id:'graph_1',
							columnWidth:.60,
							height:270,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=GridData.logOnDistributionGraph;
									if(activeSessionGraph != undefined){
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('graph_1',250,400), lineChart_1);
										lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}else
									{
										Ext.get('Logon_Id').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
									}
								}
							}
						},{
							xtype:'container',
							columnWidth:.40,
							id:'legendId_1',
							height:250,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=GridData.logOnDistributionGraph;
									if(activeSessionGraph != undefined){
										var legData=activeSessionGraph['legendArray'];
										var legObj="";
										var legHtml='<div style="height:270px;display:table-cell;vertical-align:middle;"><table>';
										for (var key in legData)
										{
											legObj = legData[key];
											//legHtml+='<tr><td valign="middle" style="padding-right: 5px;"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td>'+legObj.name+'&nbsp;('+legObj.percent+' %)</td></tr>';
											legHtml+='<tr><td valign="middle" style="padding-right: 5px;"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td>'+legObj.name+'</td><td style="padding-left: 10px;">'+legObj.percent+'%</td></tr>';
										}
										legHtml+='</table>';
										Ext.get('legendId_1').update(legHtml);
									}
								}
							}
						}],
					}
				]
			},
			{
				xtype:'panel',
				margin:'0 0 0 5',
				columnWidth:.5,
				title:'Total Logons vs Avg Logon Duration',
				ui:'newGraphPanel',
				height:300,
				items:[{
					xtype:'container',
					id:'logon_2',
					margin:'0 5 0 0 ',
					listeners:
					{
						'boxready':function(c)
						{
							var activeSessionGraph=GridData.DistributionGraph;
							if(activeSessionGraph != undefined){
								var lineChart_1 = {};
								lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance_combine('logon_2',270,380), lineChart_1);
								lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
								lineChart_1.drawChart();
							}else
							{
								Ext.get('logon_2').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
							}
						}
					}
				}]
			}]
		});
		resultPanelObj.add(dataArray);

		resultPanelObj.show();
		resultPanelObj.doLayout();

		if(reconnectsGraph != undefined){
			var lineChart = {};
			lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('reconn_1',100,100), lineChart);
			lineChart.setData(reconnectsGraph,'<%=currentDateFormat%>','');
			lineChart.drawChart();
		}
		else{
			var logon=Ext.get('reconn_1');
			if(logon != undefined)
				Ext.get('reconn_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
		}
		if(!Ext.isEmpty(hasItemId))
		{
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			for ( var i = 0; i < hasItemId.length; i++ )
			{
				var id=hasItemId[i];
				var containerObj=Ext.getCmp(id);
				
				if(!Ext.isEmpty(containerObj))
				{
					var data = containerObj.data;
					var chartType = data.chartType;
					var DataSet =data.DataSet;
					if ( !Ext.isEmpty( data ) && !Ext.isEmpty(DataSet))
					{
						var barwidth=data.chartWidth;
						if(chartType!="pie")
						{
							if(!Ext.isEmpty(resultPanelObj))
							{
								var panelBox=resultPanelObj.getBox();
								var width=panelBox.width;
								width=width*50/100;
								if(barwidth>width)
									barwidth=width;
							}
							this.updateBarCharts('highchart','',data.XML,data.swfpath,data,data.chartHeight-30,barwidth,containerObj);
						}
						else
						{
							var objPanel=Ext.get(id);
							this.updatePieChart(data,'pieColors','urlLinks','pieLabels',objPanel);
						}
					}
					else
					{
						Ext.get(id).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img   src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');
					}
				}
			}
		}
	},
	updateBarCharts:function(chartType,barChartTitle,fusionChartBarXML,fusionChartBarSWFPath,highChartBarData,barHighChartHeight,barHighChartWidth,containerObj)
	{
		var content;
		content='<div style="align:center"><div style="margin:10px 0px 0px 0px;"><div class="font_normal12" style="text-align:center;">'+barChartTitle+'</div><div id="topgraphdiv"></div></div></div>';
		containerObj.update(content);
		var lineChart = {};
		lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('topgraphdiv',barHighChartHeight,barHighChartWidth), lineChart);
		lineChart.setData(highChartBarData,'<%=currentDateFormat%>','');
		lineChart.drawChart();
	},
	updatePieChart:function(legendObj,bgColorName,urlLinkName,legendLabelName,containerObj)
	{
		var pieChartHeight=legendObj.chartHeight;
		var nxtRw=0;
		var genHTML = '<table cellpadding="0" cellspacing="0" border="0" style="margin:5px;valign:top" valign="top">';
		genHTML += '<tr>';
		var idd='piegraphdiv';
		if(!Ext.isEmpty(idd))
			idd+='_'+containerObj.id;
		if (!$.isArray(legendObj))
		{
			var pieLabels = legendObj[legendLabelName];
			var pieColors = legendObj[bgColorName];
			var pieLinks =  legendObj[urlLinkName];
			for (var key in pieLabels)
			{
				var legendLabel = pieLabels[key];
				var legendColors = pieColors[key];
				var legendLinks = pieLinks[key];
				if (!Ext.isEmpty(legendLinks) && legendLinks.indexOf('openInNewWin')>-1)
				{
					 legendLinks = legendLinks.substring(legendLinks.indexOf("(")+1,legendLinks.length-1);
				}

				genHTML += '<td style="valign:top;padding:4px 0px 4px 0px" valign="top"><div style="background-color:#'+legendColors+';width:6px;height:6px;border-radius:3px;">&nbsp;</div></td>';

				genHTML	+='<td valign="top" style="padding:0px 5px 5px 5px;white-space:nowrap;word-wrap:break-word;valign:top" WRAP class="font_normal10">'+stringDivider(legendLabel, 35, "</br>")+'</td>';

				if(nxtRw==1)
				{
					genHTML += '</tr><tr>';
					nxtRw=0;
					}
					else
				nxtRw++;
			}
		}
		else
		{
			 for (var i=0; i <legendObj.length;i++)
			 {
				var bgcolor=legendObj[i][bgColorName];
				if (bgcolor.indexOf('#')<0)
				{
					bgcolor='#'+bgcolor;
				}
				var labelName=legendObj[i][legendLabelName];

				genHTML += '<td style="valign:top;padding:4px 0px 4px 0px" valign="top"><div style="background-color:'+bgcolor+';width:6px;height:6px;border-radius:3px;">&nbsp;</div></td>';

				genHTML	+='<td valign="top" style="padding:0px 5px 5px 5px;white-space:nowrap;word-wrap:break-word;valign:top" WRAP class="font_normal10">'+stringDivider(labelName, 35, "</br>")+'</td>';
				if(nxtRw==1)
				{
					genHTML += '</tr><tr>';
					nxtRw=0;
					}
					else
				nxtRw++;
			 }
		}
		genHTML += '</tr>';
		genHTML += '</table>';
		var content;
		content='<div style="margin:20px 0px 0px 0px;" align="center"><div align="center" id="'+idd+'" ></div><div>'+genHTML+'</div></div>';
		containerObj.update(content);
		var pieChart = {};
		pieChart = jQuery.extend(true, {}, getHighChartsBarInstance(idd,pieChartHeight,highChartPieWidth), pieChart);
		pieChart.setData(legendObj,'<%=currentDateFormat%>','');
		pieChart.drawChart();
	},
	loadReportData:function(jsonData){
		var compType=Ext.getCmp('er_compType').getValue();
		var title ='User Logon Analysis (Secs)';
		if (compType!=undefined && compType=='Citrix_XcXenApp_server')
		{
			title='Session Startup Analysis (Secs)';
		}
 		var itemsArray=new Array();
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		var dataAvailable=false;
		var resultObj=Ext.getCmp('resultPanel');
		var reportData=jsonData;
		resultObj.removeAll();
		appConstants.publicjsonDataActivity=jsonData;
		var chartType=jsonData['chartType'];
		reportType=jsonData.selectedreportType;
		if(appConstants.reportType == true)
		{
			try
			{
				Ext.getCmp("csvTool").setDisabled(true);
				this.getNomeasurepanel().hide();
				resultObj.show();
				if(resultObj.getHeader() != undefined && resultObj.getHeader().hide())
				{
					resultObj.getHeader().show();
				}
				
				var noMeasureDisplayed = false;
				var resultData = jsonData;
				var distChartData = resultData['DISTRIBUTION_CHART_RESULTS'];
				var topChartData = resultData['TOP_CHART_RESULTS'];
				if (!Ext.isEmpty( distChartData ) && !Ext.isEmpty(topChartData))
				{
					resultObj.add(
					{
						xtype: 'panel',
						ui:'multiGraphPanel',
						columnWidth : 1.0,
						title:title,
						layout:{
							type:'hbox',
							align:'stretch'
						},
						margin:'10 10 10 10',
						items:[
							{
								xtype: 'panel',
								ui:'newGraphPanel',
								title:distChartData.TITLE,
								flex:0.65,
								id:'leftChartContainer',
								margin:'5 10 10 10'
							},
							{
								xtype: 'panel',
								ui:'newGraphPanel',
								flex:1, 
								title:topChartData.TITLE,
								id:'rightChartContainer',
								margin:'5 10 10 0',
							}
						]
					});
					resultObj.show();
				}
				if (Ext.isEmpty(appConstants.erUtils))
				{
					appConstants.erUtils = Ext.widget("erutils");
				}
				if(!Ext.isEmpty(distChartData))
				{
					var chartTitle = distChartData['TITLE'];
					var swfPath = distChartData['SWF_PATH'];
					var xmlData = distChartData['XMLDATA'];
					if(xmlData != undefined && !Ext.isEmpty(xmlData))
					{
						appConstants.erUtils.updatePieChart(appConstants.chartType,distChartData.LEGENDS.LEGEND_LINKS,'COLOR','LINK','LABEL','',xmlData,swfPath,distChartData,Ext.getCmp('leftChartContainer'));
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					}
					else
					{
						resultObj.hide();
						noMeasureDisplayed = true;
						this.getNomeasurepanel().show();
					}
				}
				if(!Ext.isEmpty(resultData['TOP_CHART_RESULTS']))
				{
					var topChartData = resultData['TOP_CHART_RESULTS'];
					var topChartTitle = topChartData['TITLE'];
					var topChartHeight = topChartData['HEIGHT'];
					var topChartSWFPath = topChartData['SWF_PATH'];
					var topChartXMLData = topChartData['XMLDATA'];
					var tophighChartXMLData = topChartData['topGraph'];
					var xAxisLabel = tophighChartXMLData['xAxisLabel'];
					
					if(!Ext.isEmpty(xAxisLabel) && xAxisLabel.length>0)
					{
						appConstants.erUtils.updateBarChart(appConstants.chartType,'',topChartXMLData,topChartSWFPath,tophighChartXMLData,tophighChartXMLData.chartHeight,tophighChartXMLData.chartWidth,Ext.getCmp('rightChartContainer'));
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						noMeasureDisplayed=false;
					}
					else
						noMeasureDisplayed=true;
				}
				if(noMeasureDisplayed)
				{
					resultObj.hide();
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
					Ext.getCmp("bookletTool").setDisabled(true);
					Ext.getCmp("saveTool").setDisabled(true);
					Ext.getCmp("printTool").setDisabled(true);
					Ext.getCmp("mailTool").setDisabled(true);
				}
			}
			catch (e)
			{
				Ext.getCmp("bookletTool").setDisabled(true);
				Ext.getCmp("saveTool").setDisabled(true);
				Ext.getCmp("printTool").setDisabled(true);
				Ext.getCmp("mailTool").setDisabled(true);
			}
		}
		else
		{
			resultObj.removeCls('containerShadow');
		   	Ext.getCmp("csvTool").setDisabled(false);
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);

			var compType = reportData.compType;
			if(compType!=undefined && compType=='Horizon_Pod')
			{
				if (reportData.NO_DATA != undefined && !reportData.NO_DATA)
				{
					this.getNomeasurepanel().hide();
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					var resultPanelObj=Ext.getCmp('resultPanel');
					resultPanelObj.removeAll();
					resultPanelObj.add({
						xtype:'podresultview',
						data:reportData
					});
					resultPanelObj.show();
				}
				else 
				{
					this.disableTools();
					resultObj.hide();
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
					Ext.getCmp("bookletTool").setDisabled(true);
					Ext.getCmp("saveTool").setDisabled(true);
					Ext.getCmp("printTool").setDisabled(true);
					Ext.getCmp("mailTool").setDisabled(true);
				}
			}
			else
			{
				var publicGridData=reportData.GridObj;
				if (publicGridData != undefined)
				{
					this.getNomeasurepanel().hide();
					this.loadGrid(publicGridData);
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
				else 
				{
					this.disableTools();
					resultObj.hide();
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
					Ext.getCmp("bookletTool").setDisabled(true);
					Ext.getCmp("saveTool").setDisabled(true);
					Ext.getCmp("printTool").setDisabled(true);
					Ext.getCmp("mailTool").setDisabled(true);
					initLdgMask.hide();
				}
			}
		}
		initLdgMask.hide();
	},
	submitReport:function()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);

		initLdgMask.show();
		var userNameTxtEmpty = true;
		if (Ext.getCmp('optionmultipane').isHidden() && !Ext.getCmp('er_user').isHidden())
		{
			var userArray=Ext.getCmp('er_user').getValue();
			userArray = userArray.split(',');
			if(userArray!=null && userArray!='undefined' && userArray.length>0)
			{
				for(var k=0;userArray.length>k;k++)
				{
					if(userArray[k].trim() != "" && userArray[k].trim().length > 0)
					{
						userNameTxtEmpty = false;
					}
				}
			}
		}
		if(Ext.getCmp('optionmultipane').isHidden() && !Ext.getCmp('er_user').isHidden() && userNameTxtEmpty){
			initLdgMask.hide();
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'User value cannot be empty',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var url;
		var backgroundUrl;
		var Qstring;
		var dataAvailable=false;
		var csvbackgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
		var mainForm =Ext.getCmp('mainform').getForm();
			if(!isSettingsEnabled)
		{
			this.showConfigDropdown();
			this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
			}
			var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var reportFor = mainForm.findField('report_category').getValue();
		appConstants.report_for=reportFor;

		this.updateQStringActivity();
		Qstring='er_type='+mainForm.findField('er_type').getValue();
		url="../servlet/com.eg.ErUserLogonDetailsReportC?isSubmit=true&responseType=json";
		backgroundUrl='/final/servlet/com.eg.ErStartBackGroundReportC';

		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		var backgroundresultsObj=Ext.getCmp('backGroundPanel');
		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		var reportType='';
		this.getEmptypanel().hide();
		if(reportGeneration == 'foreground')
		{
			backgroundresultsObj.hide();
			Ext.Ajax.request(
			{
				url : url,
				params : Qstring +'&'+ appConstants.queryStringActivity,
				scope:this,
				timout:320000,
				success: function(response){
					var jsonData=Ext.decode(response.responseText);
					this.loadReportData(jsonData);
				}
			});
		}
		else if(reportGeneration == 'background' )
		{
			resultPanelObj.hide();
			this.getNomeasurepanel().hide();
			Ext.getCmp("csvTool").setDisabled(true);
			myMask = new Ext.LoadMask(Ext.getBody(), {msg : "Loading..."});
			myMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			Ext.Ajax.request({
				url : backgroundUrl,
				params : Qstring+"&bg_reportname="+bg_reportname+'&'+ appConstants.queryStringActivity,
				scope : this,
				method : 'POST',
					success: function(response)
					{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
							if(backgroundReportStatus== 'success')
							{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							var htmlStr = "";
							//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>');
						
							backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
						}
							else if(backgroundReportStatus== 'duplicate')
							{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>');
						
							backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
						}
					}
					else
					{
						//backgroundresultsObj.update('<span>ErroR In BackGround Generation</span>');
					
						backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">ErroR In BackGround Generation</div></td></tr></table></td></tr></table>');
					}
					//backgroundresultsObj.update(htmlStr);
					backgroundresultsObj.show();
					myMask.hide();
				}
			});
		}
		else if(reportGeneration == 'background-csv')
		{
			resultPanelObj.hide();
			myMask = new Ext.LoadMask(Ext.getBody(), {msg : "Loading..."});
			myMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			Ext.Ajax.request({
				url : csvbackgroundUrl,
				params : Qstring+"&bg_reportname="+bg_reportname+'&'+ appConstants.queryStringActivity,
				scope : this,
				method : 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success')
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>');
						
							backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
						}
						else if(backgroundReportStatus== 'duplicate')
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>');
						
							backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
						}
					}
					else
					{
						//backgroundresultsObj.update('<span>ErroR In BackGround Generation</span>');
						
						backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">ErroR In BackGround Generation</div></td></tr></table></td></tr></table>');
					}
					backgroundresultsObj.show();
					myMask.hide();
				}
			});
		}
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if(reportGenType== 'background')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			
		}
		else if(reportGenType== 'background-csv')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	/*weekendOnChange:function()
	{
		var reportCat=Ext.getCmp('report_category').getValue();
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');


			if(weekendvalue == 'Yes')
			{
			excludeDaysObj.show();
			if(reportCat == 'user_usage')
				excludeDaysObj.update(appConstants.publicjsonDataUsage.screenLabels['MappedExcludeDays']);
			else
				excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},*/
	loadTools : function()
	{
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function()
	{
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringActivity:function()
	{
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm=null;
		if(isSettingsEnabled)
			thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var reportType = mainForm.findField('er_type').getValue();
		var componentType = mainForm.findField('er_compType').getValue();
		FormParams="select_farm="+mainForm.findField('select_farm').getValue()
					+"&er_comptype="+mainForm.findField('er_compType').getValue()
					+"&er_type="+reportType
					+"&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_brokeringFrom="+mainForm.findField('brokeringFrom').getValue()
					+"&er_inclReconnect="+this.getSettingsFieldValue(thinclientuserSettingsForm,'inclReconnect',isSettingsEnabled,'includeReconnects')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		FormParams += "&er_componentType="+componentType+"&select_groupName="+mainForm.findField('select_farm').getValue()+'&ervm_type=UserLogon';
		if(Ext.get('showLegend')!=null)
			FormParams=FormParams+"&showLegend="+mainForm.findField('showLegend').getValue();
		
		var obj = Ext.getCmp('geofilter');
		if (obj!=undefined && !obj.isHidden())
		{
			var compArray = Ext.getCmp("er_geoFilter").getValue();
			if(!isSettingsEnabled)
			{
				compArray = appConstants.publicjsonDataActivity.selectedgeoFilter;
			}
			if(compArray!=null && compArray!='undefined' && compArray.length>0)
			{
				for(var k=0;compArray.length>k;k++)
				{
					FormParams+="&filterValue="+compArray[k];
				}
			}
			else
			{
				FormParams+="&filterValue=All";
			}
			FormParams+="&searchBasedOn="+Ext.getCmp('geofilter').geoFilterScreachStr;
		}
		if(reportType == 'Yes')
		{
			FormParams+="&er_mode="+mainForm.findField('er_mode').getValue();
				var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
				if(er_perserver!=null)
					FormParams+="&er_perserver="+er_perserver;
			FormParams += "&eruserid="+appConstants.userId;
		}
		else
		{
			var serverArray=Ext.getCmp('er_server').getValue();
			if(serverArray!=null && serverArray!='undefined' && serverArray.length>0)
			{
				for(var k=0;serverArray.length>k;k++)
				{
					FormParams+="&er_component="+encodeURIComponent(serverArray[k]);
				}
			}
			if(Ext.getCmp('er_poolType_container').isVisible())
			{
				var gpArray = Ext.getCmp('er_poolType').getValue();
				if(gpArray!=undefined)
				{
					for (var k = 0; gpArray.length > k; k++) 
					{
						FormParams += "&er_poolType=" + gpArray[k];
					}
				}
			}
			/*var userArray=Ext.getCmp('er_user').getValue();
			if(userArray!=null && userArray!='undefined' && userArray.length>0)
			{
				for(var k=0;userArray.length>k;k++)
				{
					FormParams+="&er_user="+encodeURIComponent(userArray[k]);
				}
			}*/

			if(serverArray ==undefined || serverArray=="-1" ||(serverArray!=null && serverArray!=undefined && serverArray.length>1))
			{
				var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
				if(er_perserver!=null)
					FormParams+="&er_perserver="+er_perserver;
			}
			if (appConstants.isExceedUserLimit)
			{
				FormParams += "&er_user="+encodeURIComponent(Ext.getCmp('er_user').getValue());
			}
			else
			{
				var er_application = Ext.getCmp('er_application').getValue();
				if(er_application!=null && er_application!='undefined' && er_application.length>0)
				{
					for(var k=0;er_application.length>k;k++)
					{
						var tempStr = er_application[k];
						if (tempStr.indexOf("+")> -1)
						{
							tempStr = tempStr.substring(tempStr.indexOf("+")+1);
						}
						FormParams+="&er_user="+encodeURIComponent(tempStr);
					}
				}
			}
			FormParams += "&eruserid="+appConstants.userId;
			if (isSettingsEnabled)
			{
				FormParams += "&glduration="+encodeURIComponent(Ext.getCmp('glduration').getValue());
				FormParams += "&duration="+Ext.getCmp('duration').getValue();
				FormParams += "&duraSelect="+Ext.getCmp('duraSelect').getValue();
			}
			else
			{
				FormParams += "&glduration="+encodeURIComponent(appConstants.publicjsonDataActivity.selectedDuration);
				FormParams += "&duration="+appConstants.publicjsonDataActivity.durationValue;
				FormParams += "&duraSelect="+appConstants.publicjsonDataActivity.selectedUnit;
			}
		}
		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;
 		var value=Ext.getCmp("er_option").getValue();	
		if(!Ext.isEmpty(value))
			FormParams+='&er_option='+value;
		if(!Ext.isEmpty(Ext.getCmp('uppermajor')))
		{
			value=Ext.getCmp('uppermajor').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&uppermajor='+value;
			value=Ext.getCmp('upperminor').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&upperminor='+value;
			value=Ext.getCmp('upperCritical').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&upperCritical='+value;
			var chkBxvalue=Ext.getCmp('enableAggregation').checked;		
			FormParams+='&enableAggregation='+chkBxvalue;
		}
		if(reportType!="Yes")
		{
			value=Ext.getCmp('aggregateValue').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&er_aggregateValue='+value.groupByValue;
			FormParams+="&er_priority="+mainForm.findField('er_priority').getValue();
		}
		else
		{
			FormParams+='&er_aggregateValue=Details';
		}
		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields)
			{
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
	},
	afterMainRender:function(){
		var thisController = this;
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
		this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
		if(!hideBackButton)
		{
			Ext.getCmp('thinclientuserform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonDataActivity['ID']
			});	
			
		}
	},
	loadSettingsElements:function(){
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id) && !((appConstants.executeFavorite!="null" && appConstants.executeFavorite=="true") || (appConstants.fromScheduleView!="null" && appConstants.fromScheduleView=="true")))
		{
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
		var thisController  =this;
		this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings()
		});
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	refreshReportData:function(){
		var jsonData;
		jsonData=appConstants.publicjsonDataActivity;
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
            initLdgMask.show();
			this.submitReport();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity:function(jsonData)
	{
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		if(jsonData.hasOwnProperty('isSubmit'))
			var isSubmitted=jsonData.isSubmit;

		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) 
		{
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		//select_farm,
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = mainForm.findField('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = mainForm.findField('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = mainForm.findField('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = mainForm.findField('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		this.loadFormDataInfo(jsonData);
	},
	loadFormDataInfo:function(jsonData)
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		comboRawData=jsonData.analysisByCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedAnalysisByCombo;
			comboObject=mainForm.findField('er_option');
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption) )
			{
				comboObject.setValue(selectedComboOption);
			}
			else
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboObject=Ext.getCmp('aggregateValue');
		comboObject.setFieldLabel(screenLabels['reporter.common.AggregateValue']);
		selectedComboOption=jsonData.selectedAggregateSessionValue;
		comboObject=Ext.getCmp('groupByDetails');
		if(!Ext.isEmpty(selectedComboOption))
		{
			if(selectedComboOption=="Summary")
			comboObject=Ext.getCmp('groupBySummary');
		}
		comboObject.setValue(true);
		comboRawData=jsonData.priorityCombo;
		selectedComboOption=jsonData.selectedPriority;
		comboObject=mainForm.findField('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption))
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[2].valueField);
		}
		comboRawData=jsonData.zoneCombo;
		selectedComboOption=jsonData.selectedZone;
		comboObject=mainForm.findField('select_farm');
		comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);
 		comboObject.getStore().clearFilter(true);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption))
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.compTypeCombo;
		selectedComboOption=jsonData.selectedCompType;
		comboObject=mainForm.findField('er_compType');
		comboObject.setFieldLabel(screenLabels['reporter.thin.Component Type']);
		comboObject.getStore().clearFilter(true);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption))
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		var reconnects=Ext.getCmp('inclReconnect');
		if(reconnects != undefined){
			if(comboObject.getValue() == 'Citrix_XcXenApp_server')
				Ext.getCmp('inclReconnect').show();
			else
				Ext.getCmp('inclReconnect').hide();
		}
		if(jsonData.isVm != undefined &&  jsonData.isVm == 'true'){
			if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
				if(Ext.getCmp('brokeringFrom') != undefined){
					Ext.getCmp('brokeringFrom').show();
					var brokerngFrm=jsonData.enableBrokeringFor;
					Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
				}
			}
			else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
				if(Ext.getCmp('brokeringFrom') != undefined)
				{
					Ext.getCmp('brokeringFrom').hide();
					var brokerngFrm=jsonData.enableBrokeringFor;
					Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
				}
			}
			else{
				var brokerngFrm=jsonData.enableBrokeringFor;
				if(Ext.getCmp('brokeringFrom') != undefined)
					Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
			}
		}
		combObj=Ext.getCmp('er_showDeliveryGroup');
		selectedComboOption=jsonData.selectedShowDeliveryGroup;
		combObj.hide();
		if(selectedComboOption!=undefined)
		{
			combObj.setFieldLabel(screenLabels['reporter.common.Show Delivery Groups']);
			combObj=Ext.getCmp('deliveryGroupNo');
			if(selectedComboOption=="Yes")
			{
				combObj=Ext.getCmp('deliveryGroupYes');
			}
			combObj.setValue(true);
			combObj.show();
		}
		if(jsonData.selectedCompType=='Horizon_Pod')
		{
			Ext.getCmp('brokeringFrom').hide();
			Ext.getCmp('er_priority').hide();
			Ext.getCmp('optionmultipane').hide();
			Ext.getCmp('er_poolType_container').show();
		}
		else if(jsonData.selectedCompType=='Citrix_XcXenDesktop_Site' && jsonData.selectedShowDeliveryGroup!=undefined && jsonData.selectedShowDeliveryGroup=='Yes')
		{
			Ext.getCmp('optionmultipane').hide();
			Ext.getCmp('er_poolType_container').show();			
		}
		else
		{
			Ext.getCmp('er_poolType_container').hide();
		}
		comboRawData=jsonData.reportForCombo;
		selectedComboOption=jsonData.reportFor;
		comboObject=mainForm.findField('report_category');
		comboObject.setFieldLabel(screenLabels['reporter.common.Report For']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption))
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.reportTypeCombo;
		selectedComboOption=jsonData.selectedreportType;
		comboObject=mainForm.findField('er_type');
		comboObject.setFieldLabel(screenLabels['reporter.thin.Report Type']);
		comboObject.getStore().loadRawData(comboRawData);
		var reportVal="";
		if (!Ext.isEmpty(selectedComboOption))
		{
			reportVal=selectedComboOption;
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			reportVal=comboRawData[0].valueField;
			comboObject.setValue(comboRawData[0].valueField);
		}

		//mainForm.findField('er_type').getValue() == 'No'
		if(Ext.getCmp('enableDetailedData') != undefined && reportVal == 'No'){// er_type
			if(comboObject.getValue() == 'Citrix_XcXenApp_server')
				Ext.getCmp('enableDetailedData').hide();
			else
				Ext.getCmp('enableDetailedData').show();
		}

		if(reportVal=="Yes")
		{
			mainForm.findField('er_priority').hide();
			Ext.getCmp("aggregateValue").hide();
		}
		if (jsonData.selectedreportType == 'no' || jsonData.selectedreportType == 'No')
		{
			appConstants.reportType = false;
			comboRawData=jsonData.userCombo;
			appConstants.rawDataForUsers=jsonData.userCombo;
			selectedComboOption=jsonData.selectedUser;
			var disableUserCombo = jsonData.disableUserCombo;
			var userTextFieldValue = jsonData.userTextFieldValue;
			if (disableUserCombo != undefined && disableUserCombo=='yes')
			{
				appConstants.isExceedUserLimit = true;
			}
			else
				appConstants.isExceedUserLimit = false;
//need to checkk for more Users
			//appConstants.isExceedUserLimit = false;
			if (appConstants.isExceedUserLimit)
			{
				if (mainForm.findField('er_type').getValue() == 'No')
				{
					appConstants.reportType = false;
					Ext.getCmp('er_user').show();
					Ext.getCmp('optionmultipane').hide();
					Ext.getCmp('er_user').setValue(userTextFieldValue);
					if(jsonData.selectedCompType=='Horizon_Pod')
					{
						Ext.getCmp('er_user').hide();
						Ext.getCmp('er_poolType_container').show();
					}
					else
					{
						Ext.getCmp('er_poolType_container').hide();
					}
				}
				else
				{
					appConstants.reportType = true;
				}
			}
			else
			{
				if (mainForm.findField('er_type').getValue() == 'No')
				{
					appConstants.reportType = false;
					Ext.getCmp('optionmultipane').show();
					Ext.getCmp('er_user').hide();
					if(jsonData.selectedCompType=='Horizon_Pod')
					{
						Ext.getCmp('optionmultipane').hide();
						Ext.getCmp('er_poolType_container').show();
					}
					else
					{
						Ext.getCmp('er_poolType_container').hide();
					}
				}
				else
				{
					appConstants.reportType = true;
					Ext.getCmp('optionmultipane').hide();
				}
				comboObject=mainForm.findField('er_application');
				comboObject.getStore().loadRawData(comboRawData);
				if(!Ext.isEmpty(selectedComboOption))
				{
					comboObject.setValue(selectedComboOption);
				}
				else
				{
					if(comboRawData != undefined)
						comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject.show();
			}
		}
		if(!appConstants.reportType)
		{
			mainForm.findField('er_mode').hide();
			comboRawData=jsonData.serverCombo;
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp('er_server');
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
			comboObject.getStore().loadRawData(comboRawData);
			if(!Ext.isEmpty(selectedComboOption))
			{
				comboObject.setValue(selectedComboOption);
			}
			else
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();

			if(selectedComboOption!=null && selectedComboOption.indexOf("All ")>-1)
			{
				if(Ext.getCmp('er_perserver')!=undefined)
					Ext.getCmp('er_perserver').show();
			}
		}
		else
		{
			comboRawData=jsonData.graphTypeArray;
			selectedComboOption=jsonData.selectedGraphType;
			if(selectedComboOption=='distribution')
			{
				comboRawData=jsonData.measureCombo;
				selectedComboOption=jsonData.selectedMeasure;
				comboObject.show();
			}
			else
			{
				comboRawData=jsonData.userCombo;
				appConstants.rawDataForUsers=jsonData.userCombo;
				selectedComboOption=jsonData.selectedUser;
				comboObject=mainForm.findField('er_application');
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) )
				{
					comboObject.setValue(selectedComboOption);
				}
				else
				{
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject.show();
			}
			Ext.getCmp("serverMultiSelectLbl").hide();
		}
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if (!Ext.isEmpty(timelineRawData))
		{
			if (!Ext.isEmpty(selectedTimeline))
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		if (appConstants.reportType != true)
		{
			comboRawData=jsonData.userCombo;
			appConstants.rawDataForUsers=jsonData.userCombo;
			selectedComboOption=jsonData.selectedUser;
			comboObject=mainForm.findField('er_application');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
			{
				comboObject.setValue(selectedComboOption);
			}
			else
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		if (Ext.getCmp('er_option').getValue()=='Component')
			Ext.getCmp('select_farm').hide();
		else
			Ext.getCmp('select_farm').show();
 	},
	fillSettingFieldsForActivity:function(jsonData)
	{
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		selectedComboOption=jsonData.includeReconnects;
		comboObject=thinclientuserSettingsForm.findField('inclReconnect');
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue("Yes");
		}
		comboRawData=jsonData.durationCombo;
		selectedComboOption=jsonData.selectedDuration;
		comboObject=thinclientuserSettingsForm.findField('glduration');
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.unitCombo;
		selectedComboOption=jsonData.selectedUnit;
		comboObject=thinclientuserSettingsForm.findField('duraSelect');
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption))
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		var durationVal=jsonData.durationValue;
		comboObject=thinclientuserSettingsForm.findField('duration');
		if(!Ext.isEmpty(durationVal))
		{
			comboObject.setValue(durationVal);
		}
		
		var er_typeVal=Ext.getCmp("er_type").getValue();
		if(er_typeVal=="No")
		{
			Ext.getCmp('enableAggregation').show();
			Ext.getCmp('aggressionSplitter').show();
			var enableAggrVal=jsonData.enableAggregationValue
			if(!Ext.isEmpty(enableAggrVal))
			{
				if(enableAggrVal=="true")
				{
					Ext.getCmp('enableAggregation').setValue(true);
					Ext.getCmp('lowLimitLbl').show();
				}
				else
				{
					Ext.getCmp('enableAggregation').setValue(false);
					Ext.getCmp('lowLimitLbl').hide();
				}
			}
			else
			{
				var chkBxvalue=Ext.getCmp('enableAggregation').checked();
				if(chkBxvalue)
					Ext.getCmp('lowLimitLbl').show();
				else
					Ext.getCmp('lowLimitLbl').hide();
			}
			Ext.getCmp('duraSelect').show();
			Ext.getCmp('glduration').show();
			Ext.getCmp('duration').show();
		}
		else
		{
			Ext.getCmp('enableAggregation').hide();
			Ext.getCmp('aggressionSplitter').hide();
			Ext.getCmp('lowLimitLbl').hide();
			Ext.getCmp('duraSelect').hide();
			Ext.getCmp('glduration').hide();
			Ext.getCmp('duration').hide();
		}
		if(!Ext.isEmpty(jsonData.majorValue))
			Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
        Ext.getCmp('uppermajor').setFieldLabel(screenLabels['reporter.common.Major']);
		
		if(!Ext.isEmpty(jsonData.minorValue))
			Ext.getCmp('upperminor').setValue(jsonData.minorValue);
        Ext.getCmp('upperminor').setFieldLabel(screenLabels['reporter.common.Minor']);
		
		if(!Ext.isEmpty(jsonData.criticalValue))
			Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
			 Ext.getCmp('upperCritical').setFieldLabel(screenLabels['reporter.common.Critical']);
			 

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
		var reconnects=Ext.getCmp('inclReconnect');
		if(reconnects != undefined){
			if(Ext.getCmp('er_compType').getValue() == 'Citrix_XcXenApp_server')
				Ext.getCmp('inclReconnect').show();
			else
				Ext.getCmp('inclReconnect').hide();
		}//if(er_typeVal=="No")
		if(Ext.getCmp('enableDetailedData') != undefined && er_typeVal != undefined && er_typeVal=='No'){
			if(Ext.getCmp('er_compType').getValue() == 'Citrix_XcXenApp_server')
				Ext.getCmp('enableDetailedData').hide();
			else
				Ext.getCmp('enableDetailedData').show();
		}

		comboRawData = jsonData.geoFilterCombo;
		if(comboRawData!=undefined)
		{
			appConstants.geoFilterCombo = comboRawData;
			var component = Ext.getCmp("er_geoFilter");
			component.getStore().loadRawData(comboRawData);
			selectedComboOption = jsonData.selectedgeoFilter;
			Ext.getCmp("multiSelectLabel_geo").setText(screenLabels["geoFilterLabel"]);
			if (!Ext.isEmpty(selectedComboOption)) 
			{
				component.setValue(selectedComboOption);
			}
			else 
			{
				component.setValue(comboRawData[0].valueField);
			}
			Ext.getCmp('geofilter').show();
			Ext.getCmp('geofilter').geoFilterScreachStr = jsonData.geoFilterScreachStr;
		}
	},
	showConfigDropdown:function(){
			isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'thinclientusersettings',
					parent:this
				}
			],
			renderTo:'thinclientuser'
			});


			
		var eDdTmp =  appConstants.publicjsonDataActivity;
		var eDd    =  eDdTmp['enableDetailedData'];
		var mainForm =Ext.getCmp('mainform').getForm();
		if(eDd=='No' || mainForm.findField('er_type').getValue() == 'Yes'){
			Ext.getCmp('enableDetailedData').hide();
		}
					

	},
	LoadDrillDownData:function( url){
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var resultPanelObj = Ext.getCmp('resultPanel');
		Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				if(jsonData.hasOwnProperty('drillDownData')){
					resultPanelObj.removeAll();
					var DrillDownData = jsonData['drillDownData'];
					for(var k in DrillDownData){
						var tableObj =DrillDownData[k];
						var columnDetails = tableObj['columns'];
						var dataArray = tableObj['data'];

						if(!Ext.isEmpty(dataArray))
						{

							var tabledata = '<div class="x-table" >'
							+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
								+'<thead>'
									+'<tr class="x-grid-row">';
								for( var k in columnDetails)
								{
										tabledata+='<th class=" x-grid-cell">'
											+'<div class="x-grid-cell-inner">'+columnDetails[k]+'</div>'
										+'</th>';
							}
							tabledata+='</tr>'
								+'</thead>'
							+'<tbody>'
							+'<tpl for=".">';
							for(var j in dataArray)
							{
								var realdata=dataArray[j];
								tabledata+='<tr class="x-grid-row">';
									for(var l in realdata)
									{
									tabledata+='<td class=" x-grid-cell x-grid-cell-first">'
										+'<div class="x-grid-cell-inner" >'+realdata[l]+'</div>'
									+'</td>'
								}
								tabledata+='</tr>';
							}
							tabledata+='</tpl>'+'</tbody>'+'</table>' +'</div>';
							if (k == 1)
								resultPanelObj.add({
									xtype: 'panel',
									margin: '0 0 10 0',
									ui:'newGraphPanel',
									layout: {
										columns: 2,
										align: 'center'
									},
									cls: 'datapanel',
									tools: [{
										xtype: 'button',
										text:backText,
										cls: 'backbutton',
										iconCls: 'iconBack',
										id: 'thiClientbckButton',
										name: 'thiClientbckButton',
										listeners: {
											'click': function () {
												meController.submitReport();
											}
										}
									}],
									bodyPadding: '0 0 0 0',
									padding:0,
									title:'<span class="font_bold">'+ tableObj.tableTitle+'</span>',
									width: '100%',
									html: tabledata
								});
							else
								resultPanelObj.add({
									xtype: 'panel',
									margin: '0 0 10 0',
									layout: {
										columns: 2,
										align: 'center'
									},
									cls: 'datapanel',
									bodyPadding: '0 0 0 0',
									title:'<span class="font_bold">'+ tableObj.tableTitle+'</span>',
									width: '100%',
									padding:0,
									html: tabledata
								});
						}
					}
				}
				else
				{
 					this.disableTools();
					resultPanelObj.show();
					resultPanelObj.removeAll();
					resultPanelObj.add({
						xtype: 'container',
						height: 250,
						cls:'block1',
						margin:10,
						width: '100%',
						html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
					});
				}
				initLdgMask.hide();
			}
		});
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataActivity;
		var value='';
		if(isEnabled)
		{
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}
		else
		{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}
		return value;
	},
	fromGridDetailData:function(data,usr)
	{		  
		Ext.getCmp("bckButton").hide();
		Ext.getCmp("bckButton_1").show();
		initLdgMask.show();
		var me = this;
		var urlStr="/final/reporter/ErUserLogonDetailsReportJson.jsp";
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		Ext.Ajax.request(
		{ 
			url : urlStr,
			params : data+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				var combObj="";
				if(!Ext.isEmpty(jsonData))
				{
					combObj=Ext.getCmp('aggregateValue');
					var selectedComboOption=jsonData.selectedAggregateSessionValue;
					combObj=Ext.getCmp('groupByDetails');
					if(!Ext.isEmpty(selectedComboOption))
					{
						if(selectedComboOption=="Details")
							combObj=Ext.getCmp('groupByDetails');
					}
					combObj.setValue(true);
					comboRawData=jsonData.priorityCombo;
					comboObject=Ext.getCmp('er_priority');
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(comboRawData))
					{
						comboObject.setValue(comboRawData[3].valueField);
					}
					else
					{
						comboObject.setValue(comboRawData[2].valueField);
					}
					var comboRawData=jsonData.userCombo;
					combObj=Ext.getCmp('er_application');
					combObj.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(usr))
					{
						combObj.setValue(decodeURIComponent(usr));
					}
					else
					{
						combObj.setValue(comboRawData[0].valueField);
					}
				}
				me.submitReport();
			}
		});
		initLdgMask.hide();
	},
	backFun:function()
	{
		initLdgMask.show();
		var me = this;
		var Qstring='';
		this.updateQStringActivity();
		var urlStr="/final/reporter/ErUserLogonDetailsReportJson.jsp";
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		Qstring+='&'+ appConstants.queryStringActivity,
		Qstring+='er_type=No';
		Ext.Ajax.request(
		{ 
			url : urlStr,
			params : Qstring+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				var combObj="";
				if(!Ext.isEmpty(jsonData))
				{
					combObj=Ext.getCmp('aggregateValue');
					var selectedComboOption=jsonData.selectedAggregateSessionValue;
					combObj=Ext.getCmp('groupBySummary');
					if(!Ext.isEmpty(selectedComboOption))
					{
						if(selectedComboOption=="Summary")
							combObj=Ext.getCmp('groupBySummary');
					}
					combObj.setValue(true);
					comboRawData=jsonData.priorityCombo;
					selectedComboOption=jsonData.selectedPriority;
					comboObject=Ext.getCmp('er_priority');
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(appConstants.DummyPriority))
					{
						comboObject.setValue(appConstants.DummyPriority);
					}
					else
					{
						comboObject.setValue(comboRawData[2].valueField);
					}
					var comboRawData=jsonData.userCombo;
					combObj=Ext.getCmp('er_application');
					combObj.getStore().loadRawData(comboRawData);
					selectedComboOption=jsonData.selectedUser;
					if (!Ext.isEmpty(appConstants.DummyUsr))
					{
						combObj.setValue(appConstants.DummyUsr);
					}
					else
					{
						combObj.setValue(comboRawData[0].valueField);
					}
				}
				me.submitReport();
			}
		});
		initLdgMask.hide();
	}
});
