Ext.define("UserLogonReports.view.PodResultView",{
	extend:"Ext.panel.Panel",
	alias:"widget.podresultview",
	id:"podresultviewId",
	columnWidth:1.0,
	layout:'column',
	listeners:
	{
		afterrender:function(obj)
		{
			var jsonData = obj.data;
			var summaryObj = jsonData.summaryObj;
			var summaryTableColumns = jsonData.summaryTableColumns;
			var summaryTableDataList = jsonData.summaryTableDataList;
			var mainGridCol = jsonData.mainGridCol;
			var mainGriddata = jsonData.mainGriddata;
			var summaryHtml = '<div style="margin: 10px 10px 20px 10px;"><table width="100%" border="0px"><tr width="100%">';
			for(var key in summaryObj)
			{
				//summaryHtml+='<td><table width="100%"><tr><td><div class="newFont_bold28" style="text-align:center;margin:0px 0px 5px 0px">'+summaryObj[key]+'</div></td></tr><tr><td><div class="newFont_normal13" style="text-align:center">'+key+'</div></td></tr></table></td>';
				var values = summaryObj[key];
				var iconclass = '';
				if(values.indexOf('#')>-1)
				{
					iconclass = values.substring(values.indexOf('#')+1);
					values = values.substring(0,values.indexOf('#'));
				}
				summaryHtml+='<td align="center" width="20%"><table><tr><td align="right" style="padding-right:5px"><div class="'+iconclass+'"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28">'+values+'</td></tr><tr><td style="text-align:center;padding: 5px;" colspan="2"><span class="newFont_normal13" >'+key+'</span></td></tr></table></td>';
			}
			summaryHtml+='</tr></table></div>'
			this.add({
				xtype: 'panel',
				ui:'newGraphPanel',
				title:'<span class="font_bold14">Overview</span>',
				margin:'10 10 10 10',
				columnWidth : 1.0,
				html:summaryHtml
			});
			var mainColArray = new Array();
			var fields = new Array();
			var align = '';
			for(var index in summaryTableColumns)
			{
				if(index>0)
				{
					align = 'center';
				}
				else
				{
					align = 'left';
				}
				fields.push(index);
				mainColArray.push({
					header:summaryTableColumns[index],
					sortable: true,
					align:align,
					flex:1,
					dataIndex: index,
					renderer:function(value, meta, record, rowIndex, colIndex, store)
					{
						meta.tdAttr = 'data-qtip="' + value + '"';
						return value;
					},
					doSort: function(state) 
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('$$')>-1)
								{
									v1=v1.substring(0,v1.indexOf('$$'));
								}
								if(v2.indexOf('$$')>-1)
								{
									v2=v2.substring(0,v2.indexOf('$$'));
								}
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime();
									v1=new Date(v1).getTime();
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				});
			}
			var isPagingHidden;
			if (summaryTableDataList.length<5)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : 
				{
					type : 'pagingmemory',
					reader : {
						type: 'array', root : 'data', totalProperty : 'total'
					},
				},
				pageSize:5,
				autoLoad : true,
				remoteSort:true,
				data:summaryTableDataList,
			});
			var activePage=1;
			this.add({
				xtype: 'customgrid',
				columnWidth:1.0,
				title:'Overview by Desktop Pools',
				store:storeObj,
				ui:'newGridPanel withHeader',
				margin:'0 10 10 10',
				id:'overViewGrid',
				columns:mainColArray,
				sortableColumns:true,
				scroll:false,
				padding:'0 10 10 10',
				bodyStyle:
				{
					'border-width':'1px !important',
					'border-bottom':'0px'
				},
				header:
				{
					style:'padding:3px 5px 5px 0px'
				},
				forceFit: true,
				popUpData:'noTooltip',
				listeners:
				{
					sortchange:function(ct, column, e, t, eOpts )
					{
						me.gridColIndexParam=column.getIndex();
						me.gridColStateParam=column.sortState;
						this.getStore().loadPage(activePage);
					},
					render:function(obj)
					{
						Ext.defer(function() {
						//obj.columns[sortIndex].setSortState('DESC', true, false);
						},100);
					}
				},
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: 
					{
						change : function(thisd, params)
						{
							if(!Ext.isEmpty(params) && !isPagingHidden)
							{
								activePage = params.currentPage;
							}
							else
								activePage=1;
						}
					}
				}]
			});
			this.add({
				xtype:'panel',
				ui:'newGraphPanel',
				title:'Logon Performance Distribution',
				margin:'0 5 10 10',
				height:300,
				columnWidth:.5,
				items:[
					{
						xtype: 'container',
						id : 'Logon_Id',
						layout:'column',
						columnWidth : 1.0,
						height:270,
						items:[
						{
							xtype:'container',
							id:'graph_1',
							columnWidth:.60,
							height:270,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=jsonData.logonDistributionGrpah;
									if(activeSessionGraph != undefined)
									{
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('graph_1',250,250), lineChart_1);
										lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}
									else
									{
										Ext.get('Logon_Id').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
									}
								}
							}
						},{
							xtype:'container',
							columnWidth:.40,
							id:'legendId_1',
							height:250,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=jsonData.logonDistributionGrpah;
									if(activeSessionGraph != undefined){
										var legData=activeSessionGraph['legendArray'];
										var legObj="";
										var legHtml='<div style="height:270px;display:table-cell;vertical-align:middle;"><table>';
										for (var key in legData)
										{
											legObj = legData[key];
											legHtml+='<tr><td valign="middle" style="padding-right: 5px;"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td>'+legObj.name+'</td><td style="padding-left: 10px;">'+legObj.percent+'%</td></tr>';
										}
										legHtml+='</table>';
										Ext.get('legendId_1').update(legHtml);
									}
								}
							}
						}],
					}
				]
			});
			this.add({
				xtype:'panel',
				margin:'0 10 0 5',
				columnWidth:.5,
				title:'Total Logons vs Avg Logon Duration',
				ui:'newGraphPanel',
				height:300,
				items:[{
					xtype:'container',
					id:'logon_2',
					margin:'0 5 0 0 ',
					listeners:
					{
						'boxready':function(c)
						{
							var activeSessionGraph=jsonData.DistributionGraph;
							if(activeSessionGraph != undefined)
							{
								var lineChart_1 = {};
								lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance_combine('logon_2',270,380), lineChart_1);
								lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
								lineChart_1.drawChart();
							}
							else
							{
								Ext.get('logon_2').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
							}
						}
					}
				}]
			});

			mainColArray = new Array();
			fields = new Array();
			align = '';
			for(var index in mainGridCol)
			{
				if(index=='LOGON_DURATION' || index=='GP_TIME')
				{
					align = 'center';
				}
				else
				{
					align = 'left';
				}
				fields.push(index);
				mainColArray.push({
					header:mainGridCol[index],
					sortable: true,
					align:align, 
					flex:1,
					dataIndex: index,
					renderer:function(value, meta, record, rowIndex, colIndex, store)
					{
						if(value.indexOf('$$')>-1)
						{
							var divClassName='';
							var valueType = value.substring(value.indexOf('$$')+2,value.length);
							value = value.substring(0,value.indexOf('$$'));
							if(valueType == 'critical')
								divClassName = 'reporterUserLogonHigh';
							else if(valueType == 'major')
								divClassName = 'reporterUserLogonMedium';
							else if(valueType == 'minor')
								divClassName =  'reporterUserLogonLow';
							else if(valueType == 'normal')
								divClassName = 'reporterUserLogonNormal';
							else
								divClassName='reporterUserLogonDefault';
							meta.tdAttr = 'data-qtip="' + value + '"';
							meta.tdCls = "reportLogonGridColumnHighlight";
							value='<div class='+divClassName+' align="center" style="width:60%;">'+value+'</div>';
						}
						else
						{
							meta.tdAttr = 'data-qtip="' + value + '"';
						}
						return value;
					},
					doSort: function(state) 
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('$$')>-1)
								{
									v1=v1.substring(0,v1.indexOf('$$'));
								}
								if(v2.indexOf('$$')>-1)
								{
									v2=v2.substring(0,v2.indexOf('$$'));
								}
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime();
									v1=new Date(v1).getTime();
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				});
				if(index=='LOGON_DURATION')
				{
					mainColArray[mainColArray.length-1].maxWidth=150;
				}
				if(index=='GP_TIME')
				{
					mainColArray[mainColArray.length-1].minWidth=230;
				}
			}
			for(var index in mainGriddata)
			{
				var dataInfo = mainGriddata[index];
				var gpTableData = dataInfo.GPDetails;
				var subTable='';

				if(dataInfo != undefined)
				{
					var logonBreakup=dataInfo.logonBreakup;
					var gpBreakup=dataInfo.gpBreakup;
					subTable = '<div style="margin:5px;"><table width="100%" border="0px" >';
					subTable +='<tr>';
					if(logonBreakup != undefined)
					{
						subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">logon Time Break-up (secs)</div><div style="height:140px;"><table>';
						for(var ind in logonBreakup)
						{
							var sevrData=logonBreakup[ind];
							subTable+='<tr><td>'+ind+'</td><td>'+sevrData+'</td></tr>';
						}
						subTable +='</table></div></div></td>';
					}
					if(gpBreakup != undefined)
					{
						subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">Group policy Time Break-up (secs)</div><div style="height:140px;"><table>';
						for(var ind in gpBreakup)
						{
							var clntData=gpBreakup[ind];
							subTable+='<tr><td>'+ind+'</td><td>'+clntData+'</td></tr>';
						}
						subTable +='</table></div></div></td>';
					}
					subTable +='</tr>';
					subTable +='</table></div>';
				}

				if(gpTableData != undefined)
				{
					var gpHeader=gpTableData.Header;
					var gpData=gpTableData.Datas;
					subTable += '<div style="margin:0px 15px 5px 5px;" class="newTable"><div style="margin-bottom:5px;" class="font_bold12">Details of client side extensions</div><table width="100%" border="0px" >';
					subTable +='<thead><tr>';
					for(var hdr in gpHeader)
					{
						subTable +='<th>'+gpHeader[hdr]+'</th>';
					}
					subTable +='</tr></thead><tbody>';
					for(var dt in gpData)
					{
						var val=gpData[dt];
						subTable +='<tr>';
						for(var hdr in gpHeader)
						{
							var strVal=gpHeader[hdr];
							subTable +='<td>'+val[strVal]+'</td>';
						}
						subTable +='</tr>';
					}
					subTable +='</tbody></table></div>';
				}
				mainGriddata[index]['app']=subTable;
			}
			var isPagingHidden;
			if (mainGriddata.length<15)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			fields.push('app');
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : 
				{
					type : 'pagingmemory',
					reader : 
					{
						type: 'json', root : 'data', totalProperty : 'total'
					},
				},
				pageSize:15,
				autoLoad : true,
				remoteSort:true,
				data:mainGriddata,
			});
			var activePage=1; 
			this.add({
				xtype: 'customgrid',
				columnWidth:1.0,
				title:'Session Startup Analysis',
				store:storeObj,
				ui:'newGridPanel withHeader',
				margin:'0 10 10 10',
				id:'mainGrid',
				columns:mainColArray,
				scroll:false,
				padding:'5 10 10 10',
				bodyStyle:
				{
					'border-width':'1px !important',
					'border-bottom':'0px'
				},
				header:
				{
					style:'padding:3px 5px 5px 0px'
				},
				popUpData:'noTooltip',
				plugins: [{
					ptype: 'rowexpander',
					selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
					expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
					expandOnEnter : false,
					collapsible: true,
					animCollapse: false,
					rowBodyTpl: [
						'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',	
					]
				}],
				viewConfig:
				{
					stripeRows: true,
					getRowClass: function (record, rowIndex, rowParams, store)
					{
						if (record.data.app.length>0)
						{
							return ;
						}
						else
						{
							return 'hidePlus';
						}
					}
				},
				listeners:
				{
					sortchange:function(ct, column, e, t, eOpts )
					{
						me.gridColIndexParam=column.getIndex();
						me.gridColStateParam=column.sortState;
						this.getStore().loadPage(activePage);
					},
					render:function(obj)
					{
						Ext.defer(function() {
						//obj.columns[sortIndex].setSortState('DESC', true, false);
						},100);
					}
				},
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: 
					{
						change : function(thisd, params)
						{
							if(!Ext.isEmpty(params) && !isPagingHidden)
							{
								activePage = params.currentPage;
							}
							else
								activePage=1;
						}
					}
				}]
			});
		}
	}
});