Ext.define('UserLogonSummary.controller.UserLogonSummary', {
    extend: 'Ext.app.Controller',
    views: ['Main', 'EgComponent', 'ErApplication'],
    id: 'controllerID',
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'utilitiestool',
            ref: 'utilitiestool'
        }, {
            selector: 'egcomponent',
            ref: 'egcomponent'
        }, {
            selector: 'erapplication',
            ref: 'erapplication'
        }, {
            selector: 'userLogonSummaryForm',
            ref: 'userLogonSummaryForm'
        },

        {
            selector: 'mainform',
            ref: 'mainform'
        }, {
            selector: 'resultpanel',
            ref: 'resultpanel'
        }, {
            selector: 'nomeasurepanel',
            ref: 'nomeasurepanel'
        },{
            selector: 'userLogonSummarySettings',
            ref: 'userLogonSummarySettings'
        },	{selector:'ReporterSettings',
			ref:'ReporterSettings'}

    ],
    init: function() {
        this.control({
            'utilitiestool': {
                'afterrender': this.loadTools
            },
            'main': {
                'afterrender': this.afterMainRender,
            },
            'mainform button[name="submit"]': {
                'click': this.submitReport
            },
            'mainform button[name="save"]': {
                'click': this.modifyScheduleFavorite
            },
			'mainform button[id="panelinsidetoggle"]': {
               'click': this.toggleForm
            },
            'utilitiestool > #saveTool > button': {
                'click': this.saveReportAsPDF
            },
            'utilitiestool > #printTool > button': {
                'click': this.printReport
            },
            'utilitiestool > #mailTool > button': {
                'click': this.sendMail
            },
            'utilitiestool > #csvTool > button': {
                'click': this.saveCsv
            },
            'utilitiestool > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'utilitiestool > #scheduleTool > button': {
                'click': this.saveSchedule
            },

            'mainform button[id="expandSelector"]': {
                'click': this.expandMe
            },
            'mainform button[id="expandSelectorUser"]': {
                'click': this.expandMeUser
            },
            'userLogonSummaryForm combo[id="er_option"]': {
                'select': this.onSelectReportBy
            },
            'userLogonSummaryForm combo[id="select_farm"]': {
                'select': this.onSelectReportSubType
            },
            'userLogonSummaryForm combo[id="er_compType"]': {
                'select': this.onSelectCompType
            },
            'egcomponent multiselectfield[name="er_server"]': {
                'change': this.ComponentOnChange
            },

            'mainform trigger[id="compSearch"]': {
                'change': this.compMultiselect
            },
            'erapplication trigger[id="userSearch"]': {
                'change': this.filterMultiselect
            },
            'erapplication multiselectfield[id="er_application"]': {
                'change': this.userOnChange
            },
            'userLogonSummarySettings': {
                'afterrender': this.closeSetting
            },
			'userLogonSummarySettings combo[name="reportGeneration"]':{
					'select': this.reportGenChange
				},
           });
    },
    loadTools: function() {
        this.getUtilitiestool().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
        Ext.getCmp("favoriteTool").setDisabled(false);
        Ext.getCmp("scheduleTool").setDisabled(false);
    },
    afterMainRender: function() {

        var jData = appConstants.defaultLoadData


        this.setErOptionData(jData);
        this.setSelectFarmData(jData);
        this.setErCompTypeData(jData);
        this.setServerData(jData);
        this.setErApplicationData(jData);

        var erTimeline = Ext.getCmp('er_timeline');
        erTimeline.getStore().loadRawData(jData['timelineCombo']);
        erTimeline.setValue(jData['selectedTimeline']);

        var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(jData.startDateForDisplay);
        startDateObj.dataArray = jData.startDate;


        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(jData.startHourForDisplay);
        startHrObj.dataArray = jData.startHour;

        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(jData.endDateForDisplay);
        endDateObj.dataArray = jData.endDate;

        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(jData.endHourForDisplay);
        endHrObj.dataArray = jData.endHour;
//Value Setting For Report Setting 
//For backbutton
        Ext.getCmp('userLogonSummaryForm').add({
				    xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: jData['ID']
				});


    },
    expandMe: function(btn) {
        if (Ext.isEmpty(appConstants.erUtils)) {
            appConstants.erUtils = Ext.widget("erutils");
        }
        appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'), Ext.getCmp('compLbl').text, btn);
    },
    expandMeUser: function(btn) {
        if (Ext.isEmpty(appConstants.erUtils)) {
            appConstants.erUtils = Ext.widget("erutils");
        }
        appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'), Ext.getCmp('appLbl').text, btn);
    },
    setErOptionData: function(jData) { //Report By

        var reportBy = Ext.getCmp('er_option');
        reportBy.getStore().loadRawData(jData['reportBy']);
        reportBy.setValue(jData['selectedreportBy']);
    },
    setSelectFarmData: function(jData) { // Values of Zone  or segments or service ..

        var screenLable = jData.screenLabelJson;
        var reportSubType = Ext.getCmp('select_farm');

        reportSubType.setFieldLabel(screenLable['reportByLabel']);
        reportSubType.getStore().clearFilter(true);

        reportSubType.getStore().loadRawData(jData['zoneCombo']);
        reportSubType.setValue(jData['selectedreportBySubType']);
		if(jData['selectedreportBy']=='Component'){
                  reportSubType.hide();
		}

    },
    setErCompTypeData: function(jData) {

        var comType = Ext.getCmp('er_compType');
        comType.getStore().clearFilter(true);
        comType.getStore().loadRawData(jData['compTypeCombo']);
        comType.setValue(jData['selectedCompType']);
    },
    setServerData: function(jData) { //components
        var components = Ext.getCmp('er_server');
        components.getStore().clearFilter(true);
        components.getStore().loadRawData(jData['serverCombo']);
        components.setValue(jData['selectedServer']);
    },
    setErApplicationData: function(jData) { //User Details
        var user = Ext.getCmp('er_application');
        user.getStore().clearFilter(true);
        user.getStore().loadRawData(jData['userCombo']);
        user.setValue(jData['selectedUser']);
    },
    setTimelineData: function(jData) { //User Details

    }, //Onchange drop down value setting starts from here 
    onSelectReportBy: function(obj) {
        console.log('onSelectReportBy');
        var thisVal = Ext.getCmp('er_option').getValue();
        var reportBy = 'reportBy=' + thisVal;
        var formObj = this;
        appConstants.LoadingMask.show();
        Ext.Ajax.request({

            url: '/final/reporter/ErUserLogonSummaryJson.jsp',
            scope: this,
            method: 'POST',
            params: reportBy,
            success: function(response) {

                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.defaultLoadData = jsonData;
                if (thisVal == 'Component') {
                    Ext.getCmp('select_farm').hide();
                } else {
                    Ext.getCmp('select_farm').show();
                    formObj.setSelectFarmData(jsonData);
                }
                formObj.setErCompTypeData(jsonData);
                formObj.setServerData(jsonData);
                formObj.setErApplicationData(jsonData);
                appConstants.LoadingMask.hide();
            }


        });



    },
    onSelectReportSubType: function(obj) {
        console.log('onSelectReportSubType');
        var reportBy = Ext.getCmp('er_option').getValue();
        var repSubType = Ext.getCmp('select_farm').getValue();
        var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType;
        var formObj = this;

        appConstants.LoadingMask.show();
        Ext.Ajax.request({

            url: '/final/reporter/ErUserLogonSummaryJson.jsp',
            scope: this,
            method: 'POST',
            params: params,
            success: function(response) {

                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.defaultLoadData = jsonData;
                formObj.setErCompTypeData(jsonData);
                formObj.setServerData(jsonData);
                formObj.setErApplicationData(jsonData);
                appConstants.LoadingMask.hide();
            }


        });
    },
    onSelectCompType: function(obj) {
        console.log('onSelectCompType');
        var reportBy = Ext.getCmp('er_option').getValue();
        var repSubType = Ext.getCmp('select_farm').getValue();
        var comptype = Ext.getCmp('er_compType').getValue();

        var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType + '&comptype=' + comptype;
        var formObj = this;

        appConstants.LoadingMask.show();
        Ext.Ajax.request({

            url: '/final/reporter/ErUserLogonSummaryJson.jsp',
            scope: this,
            method: 'POST',
            params: params,
            success: function(response) {

                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.defaultLoadData = jsonData;
                formObj.setServerData(jsonData);
                formObj.setErApplicationData(jsonData);
                appConstants.LoadingMask.hide();
            }


        });

    },


    ComponentOnChange: function(obj, newValue, oldValue, eOpts) {

       if (newValue.length > 1 && newValue.indexOf('All') > -1) {
            this.showMessage('Chosen component group not allowed');
              return;
        }
         
       if (Ext.isEmpty(oldValue) || oldValue == undefined || Ext.isEmpty(newValue) || newValue == undefined || oldValue.length == 0 ||newValue.length == 0  ) {
            return false;
        }

        var reportBy = Ext.getCmp('er_option').getValue();
        var repSubType = Ext.getCmp('select_farm').getValue();
        var comptype = Ext.getCmp('er_compType').getValue();

        var selectedcompArray = Ext.getCmp('er_server').getValue();
        var component = '';
        var temCom = '&component='
        for (var ci = 0; ci < selectedcompArray.length; ci++) {
            component += temCom + selectedcompArray[ci];
        }

        var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType + '&comptype=' + comptype + component;
        var formObj = this;

        appConstants.LoadingMask.show();
        Ext.Ajax.request({

            url: '/final/reporter/ErUserLogonSummaryJson.jsp',
            scope: this,
            method: 'POST',
            params: params,
            success: function(response) {

                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.defaultLoadData = jsonData;
                formObj.setErApplicationData(jsonData);
                appConstants.LoadingMask.hide();
            }


        });
    },
    userOnChange: function(obj, newValue, oldValue, eOpts) {
       if (newValue.length > 1 && newValue.indexOf('All') > -1) {
              this.showMessage('Chosen user group not allowed');
			  return;
        }
    },
    saveReportAsPDF: function() {
        var qryString = "../reporter/ErHtmlToSavePdf.jsp?";

        if (Ext.isEmpty(appConstants.erUtils)) {
            appConstants.erUtils = Ext.widget("erutils");
        }
        appConstants.erUtils.savePDF(qryString);
    },
	bookletQuery: function(obj)
	{
		var qryString = "";
		return qryString;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
    printReport: function() {
        var s_qryString = "/final/reporter/ErUserLogonSummaryPrint.jsp?&pdfPrint=yes";
        parent.printWindowFn(s_qryString);
    },
    sendMail: function() {
        Ext.widget('sendmail').show();
    },
    saveCsv: function() {
        window.location='../servlet/com.eg.ErUserLogonSummaryReportC?er_view=CSV';
    },
    saveSchedule: function(obj) {
				var timelineVal = Ext.getCmp('er_timeline').getValue();
		 
		 if ( timelineVal == 'Any' || timelineVal.indexOf('hour')>=0) { 
              this.showMessage('Chosen timeline not allowed');
			  return false;
         }else{
			  var params = this.getQueryString();
			 if(params == false)
			     return false;
			 else{
                var params     = this.getQueryString();
		        if(params == false)
			       return false;
				else{
					var qryString  = "/final/reporter/ErSaveSchedule.jsp?er_rtype=userLogonSummary&er_trgttype=User_Logon_Summary&er_ViewName=ErUserLogonSummary.jsp&er_RmDispName=User_Logon_Summary&er_reportType=data&"+params;
                    parent.scheduleWindowFn(qryString);
				}
			 }
    }
	},
    saveFavorite: function() {
		var timelineVal = Ext.getCmp('er_timeline').getValue();
		 
		 if ( timelineVal == 'Any' || timelineVal.indexOf('hour')>=0) { 
              this.showMessage('Chosen timeline not allowed');
			  return false;
         }else{
			  var params = this.getQueryString();
			 if(params == false)
			     return false;
			 else{
		         var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype=User_Logon_Summary&er_rtype=userLogonSummary&er_ViewName=ErUserLogonSummary.jsp&er_RmDispName=User_Logon_Summary&"+params;
                 parent.favouriteWindowFn(target);
			 }
		 }

    },
    modifyScheduleFavorite: function() {

        var qryStr        = this.getQueryString();
		if(qryStr == false)
		  return false;
		var commonQStr    = '&er_trgttype=User_Logon_Summary&er_rtype=userLogonSummary&er_ViewName=ErUserLogonSummary.jsp&er_RmDispName=User_Logon_Summary&fromFavoriteModify=Yes&cmd=client'
		var forSchedule   = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
		var forFavorite   = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite+'&er_rtype=userLogonSummary';
        var urlNw         = "";
		if(appConstants.isModifyFavorite == 'Yes'){
			urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no" ;
			qryStr += commonQStr+forFavorite;
		}else{
			urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
			qryStr += commonQStr+forSchedule;
		}
        var formSave = Ext.create('Ext.form.Panel');
        formSave.submit({
            url: urlNw,
            params: qryStr,
            standardSubmit: true,
            method: 'POST'
        });

    },
    compMultiselect: function(obj) {
        if (Ext.isEmpty(appConstants.erUtils))
            appConstants.erUtils = Ext.widget("erutils");
        obj.toggleTriggger();

        appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_server'), appConstants.defaultLoadData['serverCombo']);
    },
    filterMultiselect: function(obj) {
        if (Ext.isEmpty(appConstants.erUtils))
            appConstants.erUtils = Ext.widget("erutils");
        obj.toggleTriggger();

        appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_application'), appConstants.defaultLoadData['userCombo']);
    },
    submitReport: function(qryStr) {
		
		
		 var bgUrl ='';
		 var params =  this.getQueryString(qryStr);
		 if(params==false) return;
		
        var formObj = this;

		var rGenType ='foreground';
       if(isSettingsEnabled){
		   rGenType      = Ext.getCmp("reportGeneration").getValue();
        }
        
        if(rGenType =='foreground'){
                var me1 = this;
				 var limitforbg = appConstants.defaultLoadData.limitforbg;
				 var maxDays    = appConstants.defaultLoadData.maxDays;
				 
				 var stDate    = Ext.getCmp("er_stdate").getValue();
		         var startHr   = Ext.getCmp("er_sthr").getValue();
		         var enDate    = Ext.getCmp("er_enddate").getValue();
		         var endHr     = Ext.getCmp("er_endhr").getValue();
                 
				 stDate.setHours(startHr);
		         enDate.setHours(endHr);          
                 if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate)){
                      Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){
							if(btnText === "no"){
								 this.getReporterSettings().down('button').fireHandler();
								 Ext.getCmp("reportGeneration").setValue('background');
			                     var reportNameObj =  Ext.getCmp('bgReportName');
           			                 reportNameObj.show();
			                         reportNameObj.focus();
			                     return false;
                             }
							else if(btnText === "yes"){
							    me1.submitReportAjax(params);
							}
					}, this);
                 }else{
					    me1.submitReportAjax(params);
				 }
        }else{

         params += '&servletName=ErUserLogonSummaryReportC&er_rtype=userLogonSummary&er_ViewName=ErUserLogonSummary.jsp&er_RmDispName=User_Logon_Summary'
         params += '&er_trgttype=User_Logon_Summary&forwardto=UserLogonSummary&er_bgreportfrom=UserSumnmary&bgenabled=Yes&savereport=save';
		  if(rGenType == 'background'){
				bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
			}else if (rGenType == 'background-csv'){
				bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				
			}

          appConstants.LoadingMask.show();
        Ext.Ajax.request({

            url: bgUrl,
            scope: this,
            method: 'POST',
            params: params,
            success: function(response) {
				var resultObj = Ext.getCmp('backgroundresults');
                appConstants.LoadingMask.hide(); 
				var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                 var reportValString = jsonData.reportVal;
					var status = reportValString.status;
					var htmlStr='';
				   if ( status == 'success' )
					{
						htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>'+reportValString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
					}
					else if ( status == 'duplicate' )
					{
						htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>'+reportValString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
					}
					resultObj.update('<div>'+htmlStr+'</div>' );
					resultObj.show();



			}
     

	  });

    }
	},showConfigDropdown:function(){
		
		try{
				isSettingsEnabled = true;
				var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px" class="settingsfont">More Options</div><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettings"></div></div>');
				//config dropdown mode
				Ext.create('Ext.container.Container',{
				width:580,
				padding:5,
				id:'configMod',
				cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'321px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						style:{'top':'0px','margin':'2px'}
					},
					{
						xtype : 'userLogonSummarySettings',
						parent:this
					}
				],
				renderTo:'viewMain'
				});
				  Ext.getCmp("glduration").hide();
			      Ext.getCmp("duration").hide();
			      Ext.getCmp("duraSelect").hide();
				
				 var timefromObj = Ext.getCmp('timefrom');
				 timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
				 
				 var minfromObj = Ext.getCmp('minfrom');
				 minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
				 
				 var timetoObj  = Ext.getCmp('timeto');
				 timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
				 
				 var mintoObj   = Ext.getCmp('minto');
				 mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);
				 
				 var erExcweObj = Ext.getCmp('er_excwe');
				 erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
				 erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
					 
				 /*var durationObj = Ext.getCmp('glduration');
                 durationObj.getStore().loadRawData(appConstants.defaultLoadData.durationCombo);
				 durationObj.setValue(appConstants.defaultLoadData.sDurationTypeUI);
				  
				 var unitsObj = Ext.getCmp('duraSelect');//Units 
				 unitsObj.getStore().loadRawData(appConstants.defaultLoadData.unitCombo);
				 unitsObj.setValue(appConstants.defaultLoadData.sUnitsUI);*/

				 var reportGen = Ext.getCmp('reportGeneration');
				  reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
				 reportGen.setValue(appConstants.defaultLoadData.sRepGenType);

		}catch(e){
			console.log(e);
		}
          },
		closeSetting:function(){
			 Ext.get('closeSettings').on('click', function() {
				Ext.get('configMod').animate({
                    duration: 500,
                    to: {
                        y: -500
                    }
			 });
		});
		},
	getQueryString:function(val){
        var isSettingsOk = true;
        var reportBy			= Ext.getCmp('er_option').getValue();
        var repSubType			= Ext.getCmp('select_farm').getValue();
        var comptype			= Ext.getCmp('er_compType').getValue();
        var selectedcompArray	= Ext.getCmp('er_server').getValue();
        var selectedUserArray	= Ext.getCmp('er_application').getValue();
       console.log(selectedUserArray);
	   if( reportBy== '-1'){
		   this.showMessage('Report By is Not Applicable');
		   return false;
	   }else if( !(reportBy == 'Component') && repSubType=='-1'){
		   this.showMessage(reportBy+'is Not Applicable');
		   return false;
	   }else if(comptype=='-1'){
           this.showMessage('Component Type is Not Applicable');
		   return false;
	   }else if(selectedcompArray[0] == '-1'){
           this.showMessage('Components is Not Applicable');
		   return false;
	   }else if(selectedUserArray[0]== '-1' || selectedUserArray[0] == 'Not Applicable'){
		   this.showMessage('User is Not Applicable');
		   return false;
	   }
	   if (selectedcompArray.length > 1 && selectedcompArray.indexOf('All') > -1) {
            this.showMessage('Chosen component group not allowed');
              return false;
        }
        
		 if (selectedUserArray.length > 1 && selectedUserArray.indexOf('All') > -1) {
            this.showMessage('Chosen user group not allowed');
			return false;
        }
        
		

        
		var component = '';
		var usr       = '';
        var temCom    = '&component='
        var tmpUsr    = '&usr='
        
		for (var ci = 0; ci < selectedcompArray.length; ci++) {
            component += temCom + encodeURIComponent(selectedcompArray[ci]) ;
        }
         
		 for (var ui = 0; ui < selectedUserArray.length; ui++) {
            usr += tmpUsr + encodeURIComponent(selectedUserArray[ui]);
           
        }
		 
		 var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType + '&comptype=' + comptype + component+usr;
        
		//Timeline Variables 
		 var timeline  = Ext.getCmp("er_timeline").getValue();
		 var startDate = Ext.getCmp("er_stdate").getValue();
		 var startHr   = Ext.getCmp("er_sthr").getValue();
		 var endDate   = Ext.getCmp("er_enddate").getValue();
		 var endHr     = Ext.getCmp("er_endhr").getValue();

         startDate.setHours(startHr);
		 endDate.setHours(endHr);          
           if(!checkDateTime(startDate,endDate)){
			  return false;
			}
		//  var userStEnddate = "&usrStDate="+Ext.Date.format(startDate,mgrDateFormat)+"&usrEndDate="+endDate;
		  startDate = Ext.getCmp("er_stdate").dataArray;
		  startHr   = Ext.getCmp("er_sthr").dataArray;
		  endDate   = Ext.getCmp("er_enddate").dataArray;
		  endHr     = Ext.getCmp("er_endhr").dataArray;
   

          var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+appConstants.defaultLoadData.startmin+'&endmin='+appConstants.defaultLoadData.endmin+'&inidate='+appConstants.defaultLoadData.inidate;
 
          var params2 = '';
        if(isSettingsEnabled){
            var timeFrom      = Ext.getCmp("timefrom").getValue();
			var minFrom       = Ext.getCmp("minfrom").getValue();
			var timeTo        = Ext.getCmp("timeto").getValue();
			var minTo         = Ext.getCmp("minto").getValue();
			var exculdeWeek   = Ext.getCmp("er_excwe").getValue();
			/*var durationType  = Ext.getCmp("glduration").getValue();
			var duration      = Ext.getCmp("duration").getValue().toString();
			var unit          = Ext.getCmp("duraSelect").getValue();*/
			var rGenType      = Ext.getCmp("reportGeneration").getValue();
			var reportName    = '';

			if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo)){
				return false;
			}
			
          /*  if(Ext.isEmpty(duration) || (duration.indexOf("-")>-1))	{
			        var msg = 'Invalid Value';
					this.showMessage(msg);
					return false;
				}
			if(durationType=="l" && duration==0){
			
					var msg = 'Duration Value cannot be equal to Zero When Duration is lesser than';
					this.showMessage(msg);
					return false;
				}*/
             if(rGenType != 'foreground'){
				 
				 reportName = Ext.getCmp("bgReportName").getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true)){
					return false;
				 }
			 }
           var er_view ='PDF';
		   if(rGenType=='background-csv'){
			   er_view='CSV';
		   }

           params2 = '&hourFromSetting='+timeFrom+'&minFromSetting='+minFrom+'&hourToSetting='+timeTo+'&minToSetting='+minTo+
			   //'&exclweek='+exculdeWeek+'&durationType='+durationType+'&duration='+duration+'&unit='+unit+
			   '&exclweek='+exculdeWeek+'&er_reportgenration='+rGenType+'&bg_reportname='+reportName+'&er_view='+er_view;
         }
        
		 var userID = '&userID='+appConstants.defaultLoadData.loginid;
		 params += params1;
		 params += params2;
		 params += userID;
         return params;


		},reportGenChange:function(){

			Ext.getCmp('resultPanel').hide();
			var reportGenType=Ext.getCmp('reportGeneration').getValue();
			if(reportGenType != 'foreground'){
				Ext.getCmp('bgReportName').setValue("");
				Ext.getCmp('bgReportName').show();
			}else{
				Ext.getCmp('bgReportName').hide();
			}
		},
		showMessage:function(msg){
			 Ext.MessageBox.show({
                title: 'User logon summary',
                msg: msg,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
		},
			toggleForm:function(obj){
				Ext.getCmp('panelinsidetoggle').show();
				var ornt = Ext.getCmp('mainform');
					if (ornt.isHidden()){
						ornt.show();
						Ext.getCmp('selectionDetails').hide();
		            }else{
						ornt.hide();
						Ext.getCmp('selectionDetails').show();
		            }
	},
		submitReportAjax:function(params){
        Ext.getCmp('panelinsidetoggle').setDisabled(false);
		Ext.getCmp('panelinsidetoggle').show();
	    appConstants.LoadingMask.show();
        Ext.Ajax.request({

            url: '/final/servlet/com.eg.ErUserLogonSummaryReportC?isReptSubmit=true',
            scope: this,
            method: 'POST',
            params: params,
			success: function(response) {
             
				var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
				var resultPanelObj = Ext.getCmp('resultPanel');
				    resultPanelObj.removeAll();
					resultPanelObj.hide();
               	this.getNomeasurepanel().hide();
				Ext.getCmp('backgroundresults').hide();
                console.log(jsonData.selectionDetails);
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				
                if(jsonData.noMeasure =='measure'){
					Ext.getCmp("csvTool").setDisabled(false);
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
		
		var isPagingHidden=false;
		var gridPageSize=15;
 		if (jsonData.dataArr.length<gridPageSize)
			isPagingHidden=true;
		else
			isPagingHidden=false;
                
				
				var store = Ext.create('Ext.data.Store', {
                    storeId: 'storeID',
                   fields: ['usr', 'avg', 'min', 'minDate', 'max','maxDate','userVal'],
                 //   data: [],
					pageSize:gridPageSize,
					autoLoad : true,
					data : jsonData.dataArr,
					proxy : {
						type : 'pagingmemory'
							
					}
                });
                
				//store.loadRawData(jsonData.dataArr);
                var activePage=1;
				 var grid = Ext.widget('customgrid', {
                    title: "<span class='font_bold'>User Logon Summary (Secs)</span>",
                    sortableColumns: true,
                    //needtoFixColumn:true,
                    margin: '0 2 0 2',
                  //  cls: 'gridSkin horizontal-scroll textHeader',
					ui:'newGridPanel',
					border:true,
                    bodyPadding: '0 0 0 0',
                    scroll: true,
                    forceFit: true,
                    store: store,
				    header: 'Schedule',
                    columns: [
						{text: 'User',dataIndex: 'usr'},
                        {text: 'Average',dataIndex: 'avg',align:'center',
						renderer :this.addCSSForFloat
					
					    },
                        {text: 'Minimum',
						columns: [{
						 text     : 'Value',
						 dataIndex: 'min',
					     sortable : true,
						 align:'center',
						 renderer :this.addCSSForFloat
						
					     },
						{
						 text     : 'Date',
						 dataIndex: 'minDate',
						 sortable : true,
						 width    :'250',
						 align:'center'
					  
						 
						}],
					
					    },
						  {
							text: 'Maximum',
						    columns: [{
						    text     : 'Value',
						    dataIndex: 'max',
					        sortable : true,
							align:'center',
							renderer :this.addCSSForFloat
							
						    
					     },
						{
						 text     : 'Date',
						 dataIndex: 'maxDate',
						 sortable : true,
					     width    :'250',
						 align:'center'
						}],
					
					    }],
                   listeners: {
							'cellclick': function(grid, rowIndex, cellIndex, e) {
					             if(cellIndex==0){
							    var erUser=e.data['userVal'];
							    var params = jsonData.userURL+'&er_user='+erUser;
								console.log(params);
								var formSave = Ext.create('Ext.form.Panel');
								    formSave.submit({
									url:'ErUserLogonDetailsReport.jsp',
									params:params,
									standardSubmit: true,
										method: 'POST'
			                        });
							}
							},
							sortchange:function(ct, column, e, t, eOpts ){
							  me.gridColIndexParam=column.getIndex();
							  me.gridColStateParam=column.sortState;
							  this.getStore().loadPage(activePage);
					       }
						},
							
						dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: store,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{   
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}

 									}
								
				}]



                });

                resultPanelObj.add(grid);
                resultPanelObj.show();
                resultPanelObj.doLayout();
				appConstants.LoadingMask.hide(); 
				}else{
					this.getNomeasurepanel().show();
					Ext.getCmp('backgroundresults').hide();
					appConstants.LoadingMask.hide(); 
				}
            }


        });
		},
		addCSSForFloat:function(value, metaData, record, row, col, store, gridView){

							
						if(value.indexOf("%")>-1)
						{
							//valueAry.push('<div style="background:#00ff00 ;width:'+precentage+'%!important">'+dataInfo+'</div>');
							//value='<div style="height:18px; background:#8399b0 ;width:'+value+'!important"> </div>'
							metaData.tdAttr = '';
						}
						else
						{
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
						}
						var strDecimal='';
						var str='';
						if(!isNaN(parseFloat(value)))
						{
							if(value!=null && value.indexOf(".")>-1)
							{
								strDecimal = value.substring(value.indexOf("."));
								str = value.substring(0,value.indexOf("."));
								value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
							}
							else
							{
								value='<span class="decimal-align">'+value+'</span>';
							}
						}
						return value;
					}
});