 Ext.Loader.setConfig({
	enable:true,
	garbageCollect:true,
	preserveScripts:false,
	disableCaching:false
});

Ext.Ajax.timeout=ajaxTimeout;
Ext.Ajax.disableCaching=false;
registerAjaxExceptionEvent();
Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux');

Ext.application({
	name:'UserSessionAppView',
	requires:['UserSessionAppView.view.Main'],
	controllers: ['UserSessionAppView.controller.Main'],
	appFolder:['../reporter/scripts/UserSessionAppView'],

	launch:function()
	{
		//Firefox  version > 18 hack
		if (Ext.firefoxVersion >= 18) 
		{
			var noArgs = [];
			Ext.override(Ext.Base, {
				callParent : function(args) {
					var method, superMethod = (method = this.callParent.caller) &&
						(method.$previous || ((method = method.$owner ? method : method.caller) && method.$owner.superclass[method.$name]));
					return superMethod.apply(this, args || noArgs);
				}
			});
		};
		var trgtUrl='/final/reporter/ErSessionAppViewJson.jsp?index='+appConstants.index+'&showFrom='+appConstants.ShowFromCombo;
		if(appConstants.hideUtilityButtns == 'true'){
			trgtUrl+='&er_Duration='+appConstants.er_Duration;
		}
		Ext.Ajax.request({
			url : trgtUrl,
			//params: appConstants.url+'&isFromDrillDown=y',//Url is setting in Coookies at ErTopNReports.jsp
			scope: this,
			method: 'POST',
			async: false,
			success: function(response, opts) 
			{
				Ext.create('Ext.container.Viewport',{
					layout:'fit',
					items:[
						{
							xtype:'main'

						}
					]
				});

				rootJson = Ext.decode(response.responseText);
				appConstants.jsonData=rootJson;
				if(rootJson.noDataFound != undefined && rootJson.noDataFound == 'false'){
					if(appConstants.hideUtilityButtns =='false')
						Ext.getCmp('measurepop').setTitle('Summary of '+appConstants.jsonData.PanelTitle+"'s session");
					this.loadSessionDetails();
					this.loadLogonChartAndStartUpDetails();
					if(appConstants.jsonData.showActiveIdleGraph != undefined && appConstants.jsonData.showActiveIdleGraph == true)
						this.loadActiveIdleTimeGraph();
					this.loadResourceUtilTemplate();
					this.loadGridAndGraph(appConstants.jsonData);
				}else{
					Ext.getCmp('measurepop').setTitle('Summary of users session');
					Ext.getCmp('drillDownResultPanel').add({
						xtype:'panel',
						ui:'newGraphPanel',
						flex:1,
						height:Ext.getBody().getHeight() - 50,
						margin:'0 2 10 0',
						html: '<table width ="100%" height="100%" cellpadding="0px" cellspacing="0px"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>',
					});
				}
				Ext.get('loadmask').hide();
			}
		});
	},
		
	loadSessionDetails:function()
	{

		var sessionInfo=appConstants.jsonData.sessionInfo;
		var hasMultipleLogins=appConstants.jsonData.fromMultipleLogins;
		var IsVm=appConstants.jsonData.IsVm;
		var donutLegend = '<table align="center" cellpadding="0" cellspacing="0" border="0px" width="100%">';
		donutLegend += '<tr><td><div style="background-color:#69c7b3;" class="legendCircle">&nbsp;</div></td>';
		donutLegend += '<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal13">Active Time</td style="padding:5px;"class="font_normal14"><td class="newFont_bold16" align="left">'+sessionInfo.activeTime+'</td></tr>';
		donutLegend += '<tr><td><div style="background-color:#fdb042;" class="legendCircle">&nbsp;</div></td>';
		donutLegend += '<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal13">Idle Time</td><td class="newFont_bold16" align="left">'+sessionInfo.idleTime+'</td></tr>';
		donutLegend += '<tr><td><div style="background-color:#fff;" class="legendCircle">&nbsp;</div></td>';
		donutLegend += '<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal13">Duration</td><td class="newFont_bold16" align="left">'+sessionInfo.totalDuraion+'</td></tr>';
		donutLegend += '</table>';
		var pnltitle='Summary';
		if(appConstants.hideUtilityButtns =='true')
			pnltitle='Summary of '+appConstants.jsonData.PanelTitle+"'s session";
		var resultPanelObj=Ext.getCmp('drillDownResultPanel');

		resultPanelObj.add({
			xtype:'panel',
			ui:'newGraphPanel',
			title:pnltitle,
			padding:'0 10 10 0',
			margin:'0 2 0 0',
			border:0,
			frame:0,
			id:'summary_Panel',
			flex:1,
			layout:
			{
				type:'hbox',
				align:'center'
			},
			defaults:
			{
				flex:.25,
				layout:
				{
					type:'column',
					align:'center',
				},
			},
		});
		if(hasMultipleLogins != undefined && hasMultipleLogins == 'true'){
			Ext.getCmp('summary_Panel').add({
				xtype:'container',
				align:'center',
				autoSize: true,
				flex:.75,
				columnWidth:.75,
				layout: 
				{
					type: 'table',
					rows:2,
					columns:1,
					align:'center',
					tableAttrs: 
					{
						style: 
						{
							align:'center',
							margin:'auto auto',
							width:'100%',
						}
					},
					tdAttrs:
					{
						style:
						{
							textAlign:'center',
						}
					}
				},
				items: [
				{
					xtype:'panel',
					margin:'0 5 0 0',
					id:'reconnected_Session',
				},
				{
					xtype:'container',
					align:'center',
					autoSize: true,
					flex:1,
					id:'applnCol',
					layout: 
					{
						type: 'table',
						rows:1,
						columns:2,
						align:'center',
						tableAttrs: 
						{
							style: 
							{
								align:'center',
								margin:'auto auto',
								width:'100%',
							}
						},
						tdAttrs:
						{
							style:
							{
								textAlign:'center',
							}
						}
					},
					defaults: 
					{
						flex:.5,
						bodyStyle: 'padding:5px',
					},
					items: [
					{
						type: 'table',
						rows:2,
						columns:1,
						align:'center',
						id:'applnId',
					}],
					listeners:{
						afterrender:function(){
							if(IsVm){
								Ext.getCmp("applnId").add(
								{
									html: '<span class="newFont_bold16"><img src="/final/images/spacer.gif" class="iconClientName" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.DesktopName+'</span>',
								},
								{
									html:'<span class=newFont_normal13>'+'Desktop Name'+'</span>',
										padding:'5 0 20 0',
								});
							}else{
								Ext.getCmp("applnId").add(
									{
										padding:'10 0 0 0',
										html: '<span class="newFont_bold16" style="vertical-align:text-bottom"><img src="/final/images/spacer.gif" class="iconUniqueApp"  style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.uniqueApplicationsCnt+'</span>',
									},
									{
										html:'<span class=newFont_normal13>'+'Applications Accessed'+'</span>',
										padding:'5 0 0 0',
									}
								);
								if (sessionInfo.uniqueApplicationsCnt > 0)
								{
									Ext.getCmp("applnCol").add(
									{
										html: '<div style="display:inline-block;padding:10px 10px 0px 10px"><div class="arrow_box" ><div class="arrow_box_div">'+sessionInfo.uniqueApplications+'</div></div></div>',
										margin:'0 5 5 5'
									});
								}
							}
						}
					},
				}]
			});
		}
		else{
			Ext.getCmp('summary_Panel').add(
				{
					xtype:'container',
					align:'center',
					autoSize: true,
					layout: 
					{
						type: 'table',
						rows:5,
						columns:1,
						align:'center',
						tableAttrs: 
						{
							style: 
							{
								align:'center',
								margin:'auto auto',
								width:'100%',
							}
						},
						tdAttrs:
						{
							style:
							{
								textAlign:'center',
							}
						}
					},
					defaults: 
					{
						bodyStyle: 'padding:5px',
					},
					items: [
					{
						html: '<span class="newFont_bold16"><img src="/final/images/spacer.gif" class="iconWebLogIn" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.sessionStartTime+'</span>',
					},
					{
						html:'<span class=newFont_normal13>'+'Login Time'+'</span>',
						padding:'5 0 0 0',
					},
					{
						html:'&nbsp;',
						padding:'10 10 5 10',
					},
					{
						html: '<span class="newFont_bold16"><img src="/final/images/spacer.gif" class="iconClientIP" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.clientIp+'</span>',

					},
					{
						html:'<span class="newFont_normal13">'+'Client IP'+'</span>',
						padding:'5 0 0 0',
					}]
				},
				{
					xtype:'container',
					align:'center',
					autoSize: true,
					layout:
					{
						type: 'table',
						rows:5,
						columns:1,
						align:'center',
						tableAttrs: 
						{
							style: 
							{
								align:'center',
								margin:'auto auto',
								width:'100%',
							}
						},
						tdAttrs:
						{
							style:
							{
								textAlign:'center',
							}
						}
					},
					defaults: 
					{
						bodyStyle: 'padding:5px',
					},
					items: [{
						html: '<span class="newFont_bold16"><img src="/final/images/spacer.gif" class="iconClientName" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.clientName+'</span>',
					},
					{
						html:'<span class=newFont_normal13>'+'Client Name'+'</span>',
						padding:'5 0 0 0',
					},
					{
						html:'&nbsp;',
						padding:'10 10 5 10',
					},
					{
						html: '<span class="newFont_bold16"><img src="/final/images/spacer.gif" class="iconXenAppServer" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.trgtHost+'</span>',

					},
					{
						html:'<span class=newFont_normal13>'+'Server'+'</span>',
						padding:'5 0 0 0',
					}]
				},
				{
					xtype:'container',
					align:'center',
					id:'applnId',
					autoSize: true,
					layout: 
					{
						type: 'table',
						rows:5,
						columns:1,
						align:'center',
						tableAttrs: 
						{
							style: 
							{
								align:'center',
								margin:'auto auto',
								width:'100%',
							}
						},
						tdAttrs:
						{
							style:
							{
								textAlign:'center',
							}
						}
					},
					defaults: 
					{
						bodyStyle: 'padding:5px',
					},
					items: [
					{
						html: '<span class="newFont_bold16"><img src="/final/images/spacer.gif" class="iconTimeGray" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.logonDuraion+'</span>',

					},
					{
						html:'<span class=newFont_normal13>'+sessionInfo.logonTitle+'</span>',
						padding:'5 0 0 0',
					}],
					listeners:{
						afterrender:function(){
							if(IsVm){
								Ext.getCmp("applnId").add(
								{
									html:'&nbsp;',
									padding:'10 10 5 10',
								},
								{
									html: '<span class="newFont_bold16"><img src="/final/images/spacer.gif" class="iconClientName" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.DesktopName+'</span>',

								},
								{
									html:'<span class=newFont_normal13>'+'Desktop Name'+'</span>',
										padding:'5 0 20 0',
								});
							}
							else{
								if (sessionInfo.uniqueApplicationsCnt > 0)
								{
									Ext.getCmp("applnId").add(
									{
										padding:'10 0 0 0',
										html: '<span class="newFont_bold16" style="vertical-align:text-bottom"><img src="/final/images/spacer.gif" class="iconUniqueApp" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.uniqueApplicationsCnt+'</span>',
									},
									{
										html:'<span class=newFont_normal13>'+'Applications Accessed'+'</span>',
										padding:'5 0 0 0',
									},
									{
										html: '<div style="display:inline-block;padding:10px 10px 0px 10px"><div class="arrow_box" ><div class="arrow_box_div">'+sessionInfo.uniqueApplications+'</div></div></div>',
										margin:'0 5 5 5'
									});
								}
								else{
									Ext.getCmp("applnId").add(
									{
										html:'&nbsp;',
										padding:'10 10 5 10',
										height: 20,
									},
									{
										html: '<span class="newFont_bold16" style="vertical-align:text-bottom"><img src="/final/images/spacer.gif" class="iconUniqueApp" style="vertical-align:bottom;margin-right:10px"/>'+sessionInfo.uniqueApplicationsCnt+'</span>',
									},
									{
										html:'<span class=newFont_normal13>'+'Applications Accessed'+'</span>',
										padding:'5 0 0 0',
									});
								}
							}
						}
					}
				});
			}
			Ext.getCmp('summary_Panel').add(
				{
					xtype:'container',
					align:'center',
					autoSize: true,
					border:true,
					cls:'ReporterUserViewBox',
					layout: 
					{
						type: 'table',
						rows:3,
						columns:2,
						align:'center',
						tableAttrs: 
						{
							style: 
							{
								align:'center',
								margin:'auto auto',
							}
						},
						tdAttrs:
						{
							style:
							{
								textAlign:'center',
								'vertical-align':'top'
							}
						}
					},
					defaults: 
					{
						bodyStyle: 'padding:0px 5px 5px 5px',
					},
					items:[{
						xtype:'container',
						align:'center',
						autoSize: true,
						width:180,
						layout: {
							type: 'table',
							rows:3,
							columns:1,
							align:'center',
							tableAttrs: {
								style: {
									align:'center',
									margin:'auto auto',
									width:'100%',
								}
							},
							tdAttrs:{
								style:{
									textAlign:'center',
									'vertical-align':'top'
								}
							}
						},
						defaults: {
							bodyStyle: 'padding:0px',
						},
						items: [{
							html:'<div id="id_3" class="htmlTableBody"></div>',
							
						},
						{
							html:'&nbsp;',
						},
						{
							html:donutLegend
						}]
					}]
				}
			);

		var sessionTimeGraph=appConstants.jsonData.sessionTimeGraph;
		var donutChart = {};
		donutChart = jQuery.extend(true, {}, getHighChartsBarInstance('id_3',140,200), donutChart);
		donutChart.setData(sessionTimeGraph,'','','donut');
		donutChart.drawChart();

		var hasMultipleLogins=appConstants.jsonData.fromMultipleLogins;
		if(hasMultipleLogins != undefined && hasMultipleLogins == 'true'){
			if(Ext.getCmp('reconnected_Session') != undefined){
				var gridColumn=appConstants.jsonData.multipleLoginsData.header;
				var gridData=appConstants.jsonData.multipleLoginsData.dataArray;
				var mainColArray=new Array();
				var mainColumn='';
				for (var key in gridColumn)
				{
					mainColumn = gridColumn[key];
					var colWidth=90;
					var colAlgn='center';
					if(mainColumn != undefined && (mainColumn == 'connected Time' || mainColumn == 'disconnected Time' )){
						colWidth=160;
						colAlgn='left';
					}
					else if(mainColumn != undefined && mainColumn == 'server') {
						colWidth=120;
					}
					else if(mainColumn != undefined && (mainColumn == 'Client IP' || mainColumn == 'Client Name')) {
						colWidth=110;
					}
					mainColArray.push({
						header:mainColumn,
						sortable: true,
						width:colWidth,
						align:colAlgn,
						dataIndex: mainColumn,
						doSort: function(state) 
						{
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2)
								{
									v1 = v1.get(field);
									v2 = v2.get(field);
									if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
									{
										var tmp = v1.substring(0, v1.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
									}
									if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
									{
										var tmp = v2.substring(0, v2.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
									}
									if(!isNaN(v1) && !isNaN(v2))
									{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										if (state=='ASC')
										{
											v1= isNaN(v1) ? 999999 : v1;
											v2= isNaN(v2) ? 999999 : v2;
										}
										else
										{
											v1= isNaN(v1) ? 0 : v1;
											v2= isNaN(v2) ? 0 : v2;
										}
									}
									else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime();
										v1=new Date(v1).getTime();
									}
									// transform v1 and v2 here
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = 'data-qtip="' + value + '"';
							value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
							return value;
						}
					});
				}
				var fields=[];
				for(var key in gridData[0])
				{
					fields.push(key);
				}
				var storeObj = Ext.create('Ext.data.Store', {
					fields: fields,
					proxy : {
							type : 'pagingmemory',
							reader : {
								type: 'json', root : 'data', totalProperty : 'total'
							},
						},
					pageSize :3,	//gridPageSize is added in ErTracker.jsp
					autoLoad : true,
					data:gridData,
				});
				var isPagingHidden;
				if (gridData.length <= 3)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				Ext.getCmp('reconnected_Session').add({
					xtype:'customgrid',
					store:storeObj,
					sortableColumns:false,
					ui:'newGridPanel noHoverColor headerTextWrap',
					id:'mainGrid',
					margin:'10 10 10 10',
					activePage:1,
					border:true,
					scroll:true,
					autoScroll:true,
					forceFit:true,
					columns:mainColArray,
					bodyPadding:'0 0 0 0',
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							this.getStore().loadPage(activePage);
						},
						render:function(obj){
							Ext.defer(function() {
							},100);
						}
					},
					dockedItems:[{
						xtype:'pagingtoolbar',
						dock: 'bottom',
						cls:'newPagination',
						displayInfo: true,
						store: storeObj,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{
								if(!Ext.isEmpty(params) && !isPagingHidden)
								{
									Ext.getCmp('mainGrid').activePage = params.currentPage;
								}
								else
									Ext.getCmp('mainGrid').activePage=1;
							}
						}
					}]
				});
			}
		}
	},
	loadLogonChartAndStartUpDetails:function()
	{
		var chartStartUpArray = new Array();
		var isSummaryDataFound=appConstants.jsonData.isSummaryDataFound;
		var isLogonDataFound=appConstants.jsonData.logonDetailInfo;
		var isSessionDataFound=appConstants.jsonData.isSessionDataFound;
		var resultPanelObj=Ext.getCmp('drillDownResultPanel');
		var isStartupDetailsFound=false;
		if(isSummaryDataFound=="true")
		{
			isStartupDetailsFound=true;
			var userLogonGraphObj=appConstants.jsonData.userLogonGraphObj;
			var genHTML = '<table cellpadding="0" cellspacing="0" border="0" style="margin:10px;">';
			var pieLabels = userLogonGraphObj.pieLabels;
			var pieColors = userLogonGraphObj.pieColors;
			var dataSet = userLogonGraphObj.DataSet;
			if(dataSet != null)
			{
				var data=dataSet[0].data;
				if(data != undefined){
					for(var ind in data){
						genHTML += '<tr>';
						var brkDownData=data[ind];
						if(brkDownData != undefined){
							genHTML += '<td><div style="background-color:'+brkDownData.color+';" class="legendCircle">&nbsp;</div></td>';
							genHTML	+='<td style="padding:2px 10px;" class="font_normal11">'+brkDownData.name+'</td><td class="font_normal11">'+brkDownData.y+'</td>';
						}
						genHTML += '</tr>';
						if(brkDownData != undefined && brkDownData.innerArray != undefined){
							var innerMeasr=brkDownData.innerArray;
							for(var indx in innerMeasr){
								genHTML += '<tr>';
								var brkDownData=innerMeasr[indx];
								if(brkDownData != undefined){
									genHTML += '<td>&nbsp;</td>';
									genHTML	+='<td style="padding:2px 10px;" class="font_normal11">&nbsp;&nbsp;'+brkDownData.name+'</td><td class="font_normal11">'+brkDownData.y+'</td>';
								}
								genHTML += '</tr>';
							}
						}
					}
				}
			}
			genHTML += '</table>';

			var content='<div style="padding:10px 10px 10px 10px" class="newFont_bold14">Logon Time Breakdown</div><table cellspacing="0" cellpadding="0" border="0" width="70%" align="center" height="100%" style="border-collapse:collapse;"><tr><td id="sid_2" width="60%"></td><td width="40%">'+genHTML+'</td></tr></table>';
			chartStartUpArray.push({
				xtype:'container',
				columnWidth:1,
				flex:1,
				margin:'0 2 10 0',
				html:content,
				listeners:{
					'boxready':function(c)
					{
						if(userLogonGraphObj != undefined){
							var lineChart_1 = {};
							lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('sid_2',300,250), lineChart_1);
							lineChart_1.setData(userLogonGraphObj,appConstants.currentDateFormat,'');
							lineChart_1.drawChart();
						}
					}
				}
			});
				
		}
		var lastRowFOund=false;
		var isFirstRow=true;
		var b=0;
		var t1='';
		var t2='';
		var htmlChild = '<div class="userLogonInnerTableOuter" style="width:'+'1180'+'px;"><table width ="100%" cellpadding="0px" cellspacing="0px" ><tbody>';
		var isVmComp=appConstants.jsonData.IsVm;
		var comptype=appConstants.jsonData.sessionInfo.ComponentType;
		var child=appConstants.jsonData.logonDetailInfo;
		var GPDetails=appConstants.jsonData.GPDetails;
		var gpDurationQuery=appConstants.jsonData.gpDurationQuery;
		if(child != undefined){
			isStartupDetailsFound=true;
			var logonbreakup=child.logonBreakup;
			var gpBreakup=child.gpBreakup;
			var headr=child.Header;
			var leftHeader=child.logonHeader;
			var rightHeader=child.GpHeader;
			var leftTitle='logon Time Break up (secs)';
			var rightTitle='Group policy Time Break up (secs)';
			var tdHeight='style="height:140px;"';
			var leftHeaderVal='';
			var rightHeaderVal='';
			if(logonbreakup == undefined && gpBreakup == undefined){
				logonbreakup=child.Server;
				gpBreakup=child.Client;
				leftTitle='Server start-up (secs)';
				rightTitle='Client start-up (secs)';
				tdHeight='';
				rightHeader=child.ClinetHeader;
				leftHeader=child.ServerHeader;
			}
			if(leftHeader != undefined && leftHeader[0] != undefined){
				leftHeaderVal='<span style="float:right;padding-right:15%;">'+leftHeader[0].value+'</span>';
			}
			if(rightHeader != undefined && rightHeader[0] != undefined){
				rightHeaderVal='<span style="float:right;padding-right:15%;">'+rightHeader[0].value+'</span>';
			}
			var subTable = '<div style="padding:0px 10px 10px 10px" class="newFont_bold14">Session start-up Details</div>';
			if(headr != undefined){
				subTable+='<div align="center"><div class="reporterLogonSessionStartupBox" style="height: 24px;"><table style="margin:4px 0px 0px 10px;"><tr><td>Session start-up duration(Secs) :</td><td>'+headr[0].value+'</td></tr></table></div></div>';
			}
			subTable +='<div style="margin:5px;"><table width="100%" border="0px" >';
			subTable +='<tr>';
			if(logonbreakup != undefined){
				subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">'+leftTitle+''+leftHeaderVal+'</div><div '+tdHeight+'><table>';
				for(var ind in logonbreakup)
				{
					var sevrData=logonbreakup[ind];
					subTable+='<tr><td>'+sevrData.key+'</td><td>'+sevrData.value+'</td></tr>';
				}
				subTable +='</table></div></div></td>';
			}
			if(gpBreakup != undefined){
				subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">'+rightTitle+''+rightHeaderVal+'</div><div '+tdHeight+'><table>';
				for(var ind in gpBreakup)
				{
					var clntData=gpBreakup[ind];
					subTable+='<tr><td>'+clntData.key+'</td><td>'+clntData.value+'</td></tr>';
				}
				subTable +='</table></div></div></td>';
			}
			subTable +='</tr>';
			subTable +='</table></div>';
			chartStartUpArray.push({
				xtype:'container',
				columnWidth:1,
				margin:'10 2 10 0',
				html:subTable
			});
		}
		if(GPDetails != null){
			var headr=GPDetails.header;
			var dataArray=GPDetails.dataArray;
			var gpContent='';
			if(headr != undefined && dataArray != undefined){
				gpContent='<div class="newTable"><div class="font_bold12">Details of client side extension</div><table width="100%"><thead><tr>';
				for (var n in headr){
					gpContent+='<th>'+headr[n]+'</th>';
				}
				gpContent+='</tr></thead><tbody>'
				for (var n in dataArray){
					var tmpArr=dataArray[n];
					gpContent+='<tr>';
					for (var k in headr){
						var tmpcol=headr[k]
							gpContent+='<td>'+tmpArr[tmpcol]+'</td>';
					}
					gpContent+='</tr>';
				}
				gpContent+='</tbody></table></div>';
				chartStartUpArray.push({
					xtype:'container',
					columnWidth:1,
					flex:1,
					margin:'0 10 10 10',
					html:gpContent,
				});
			}
		}
		if(isStartupDetailsFound)
		{
			resultPanelObj.add(
			{
				xtype:'panel',
				columnWidth:1,
				id:'chrtdata',
				margin:'10 2 0 0',
				ui:'newGraphPanel',
				layout:{
					type:'column',
					align:'stretch',
				},
				items:chartStartUpArray
			});		
		}
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
	},
	loadActiveIdleTimeGraph:function(){
		var xrangeGraph=appConstants.jsonData.XRange_Graph;
		if(xrangeGraph != undefined){
			var resultPanelObj=Ext.getCmp('drillDownResultPanel');
			resultPanelObj.add(
			{
				xtype:'panel',
				columnWidth:1,
				ui:'newGraphPanel',
				title:'Session Activity',
				margin:'10 2 0 0',
				items:[
				{
					xtype:'container',
					id:'activeGraph',
					height:300,
					margin:'0 10 10 10',
					listeners:{
						'boxready':function(){
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, getHighChartsInstance('activeGraph',800,250), lineChart);
							lineChart.setData(xrangeGraph,appConstants.currentDateFormat,'');
							lineChart.drawChart();
						}
					}
				}],

			});
		}
	},
	loadResourceUtilTemplate:function(){
		var resurceGraphArr=appConstants.jsonData.resourceGraphArrayNEW;
		var resultPanelObj=Ext.getCmp('drillDownResultPanel');
		if(resurceGraphArr != undefined){
			var grpahLen=resurceGraphArr.length;
			var panlWdth=resultPanelObj.getWidth();
			if(panlWdth != undefined)
				panlWdth=(panlWdth-100)/2;
			else
				panlWdth=500;
			resultPanelObj.add(
			{
				xtype:'panel',
				columnWidth:1,
				ui:'newGraphPanel',
				id:'resourceGraphNew',
				margin:'10 2 10 0',
				layout:{
					type:'table',
					columns:'2',
					tableAttrs: 
					{
						style: 
						{
							margin:'0 0',
						}
					},
					tdAttrs: {
						style:{
					    'vertical-align': 'top',
						}
					}
				},
			});
			for(var ind in resurceGraphArr){
				var resrceky=resurceGraphArr[ind];
				if(resrceky != undefined){
					Ext.getCmp('resourceGraphNew').add({
						xtype:'container',
						id:'graph_'+ind,
						items:[{
							xtype:'container',
							html:'<div style="padding:20px 10px 10px 10px;" class="newFont_bold14">'+resrceky.TemplateName+'</div>'
						},{
							xtype:'container',
							height:300,
							width:panlWdth,
							margin:'5 5 10 5',
							id:'r_id_'+ind,
							listeners:{
								'boxready':function(){
									if(resrceky != undefined){
										if(resrceky.combineChartType != undefined){
											var lineChart = {};
											lineChart = jQuery.extend(true,{},getHighChartsInstance_combined('r_id_'+ind,300,400),lineChart);
											lineChart.setData(resrceky,appConstants.currentDateFormat,'');
											lineChart.drawChart();
										}
										else{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighChartsInstance('r_id_'+ind,300,400), lineChart);
											lineChart.setData(resrceky,appConstants.currentDateFormat,'');
											lineChart.drawChart();
										}
									}
								}
							}
						},{
							xtype:'container',
							margin:'5 10 10 5',
							id:'legend_'+'r_id_'+ind,
						}],
						listeners:{
							'boxready':function(){
								var grphCont=Ext.getCmp('graph_'+ind);
								if(grphCont != undefined){
									if(ind % 2 == 0){
										if(ind == grpahLen -1 || ind == grpahLen -2)
											grphCont.cellCls='newDottedRight';//newLineRight
										else
											grphCont.cellCls='newLineBottomRight';
									}
									else if(!(ind == grpahLen -1) )
										grphCont.cellCls='newLineBottom';
								}
							}
						}
					});
				}
			}
		}
	},
	loadGridAndGraph:function(GridData)
	{
		var isVmComp=GridData.IsVm;
		var me=this;
		var resultPanelObj=Ext.getCmp('drillDownResultPanel');
		var gridChartAry = new Array();
		if (!Ext.isEmpty(GridData.columns) && !Ext.isEmpty(GridData.dataArray))
		{
			var hasChld=false;
			var gridColumn=GridData.columns;
 			var gridData=GridData.dataArray;
			var mainColArray=new Array();
			var fieldsToStore=new Array();
			var align='left';
			for(var index in gridData)
			{
				var dataInfo = gridData[index];
				var subTableData = dataInfo[dataInfo.length-1];
				if(isVmComp){
					if(dataInfo.length > gridColumn.length && subTableData != undefined){
						var subTable = '<div class="newTable" style="margin-right: 5px;"><table width="100%"><thead><tr>';
						var headerArray=subTableData.header;
						for(var idx in headerArray)
						{
							var tmp=headerArray[idx];
							subTable+='<th>'+tmp+'</th>';
						}
						subTable+='</tr></thead>';
						for(var idx in subTableData)
						{
							if(idx == 'header')
								continue;
							var tmp=subTableData[idx];
							subTable+='<tr>';
							for(var indd in headerArray)
							{
								var titleStr=headerArray[indd];
								subTable+='<td style="padding:4px 10px 4px 10px">'+tmp[titleStr]+'</td>';
							}
							subTable+='</tr>';
						}
						subTable+='</table></div>';
						gridData[index][dataInfo.length-1]=subTable;
						hasChld=true;
					}
				}
				else if(subTableData.length>0)
				{
					var subTable = '<table width="100%">';
					var subTableBody = '';
					var rowArray = subTableData.split('#');
			//		var colWidth = 100/(dataInfo.length-1);
					var colWidth = 67/(dataInfo.length-3);
					var colwidthInfo='';
					for(var i=0;i<rowArray.length;i++)
					{
						subTableBody+='<tr >';
						var colDataAry = rowArray[i].split('$');
						colwidthInfo='';
						for(var j=0;j<colDataAry.length;j++)
						{
							var colAlign='center';
							var hdrCol=gridColumn[j];
							if(hdrCol != undefined && ((hdrCol.indexOf('Start Time')>-1)||(hdrCol.indexOf('End Time')>-1))){
								colAlign='left';
								colwidthInfo+='<col width="16.5%">';
							}
							else{
								if(hdrCol != undefined && hdrCol.indexOf("Name") >-1)
									colAlign='left';
								colwidthInfo+='<col width="'+colWidth+'%">';
							}
							subTableBody+='<td style="padding:4px 10px 4px 10px" align="'+colAlign+'">'+colDataAry[j]+'</td>';
						}
						subTableBody+='</tr>';
					}
					subTable+=colwidthInfo+subTableBody+'</table>';
					gridData[index][dataInfo.length-1]=subTable;
					hasChld=true;
				}
			}
			for (var key in gridColumn)
			{
				mainColumn = gridColumn[key];
				fieldsToStore.push(mainColumn);
				align='center';
			
				var setWidth=110;
				if(mainColumn!=undefined && (mainColumn.indexOf('Start Time')>-1)||(mainColumn.indexOf('End Time')>-1))
				{
					setWidth=160;
					align='left';
				}
				else if(mainColumn!=undefined && mainColumn=='Name')
				{
					align='left';
				}
				
				mainColArray.push({
					header: mainColumn,
					sortable: true,
					width:setWidth,
					align:align,
					dataIndex: mainColumn,
 					doSort: function(state) 
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1=='-')
									return -1;
								else if(v2=='-')
									return 1;
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime();
									v1=new Date(v1).getTime();
								}
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				});
			}

			var isPagingHidden;
			var gridPageSize=5;
			if (gridData!=undefined && gridData.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			
			fieldsToStore.push('app');

 			var storeObj=Ext.create('Ext.data.Store', {
				fields:fieldsToStore,
				proxy : 
				{
					type : 'pagingmemory',
					reader : 
					{
						type: 'array', root : 'data', totalProperty : 'total'
					}
				},
				pageSize:gridPageSize,
				data : gridData,
				autoLoad : true,
			});

			var pluginsVal=[];
			var viewCnfgVal={};
			if(hasChld){
				pluginsVal =[{
					ptype: 'rowexpander',
					selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
					expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
					expandOnEnter : false,
					collapsible: true,
					animCollapse: false,
					rowBodyTpl: [
						 '<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',
					]
				}];
				viewCnfgVal={
					stripeRows: true,
					getRowClass: function (record, rowIndex, rowParams, store)
					{
						if (record.data.app.length>0)
						{
							return ;
						}
						else
						{
							return 'hidePlus';
						}
					}
				};
			}


			var activePage=1;
 			gridChartAry.push({
				xtype:'customgrid',
				store:storeObj,
				sortableColumns:true,
				ui:'newGridPanel noHoverColor headerTextWrap',
				border:true,
				margin:'10 10 10 10',
				columns:mainColArray,
				columnWidth:1,
				scroll:true,
 				autoScroll:true,
				forceFit:true,
				plugins:pluginsVal ,
				viewConfig:viewCnfgVal,
				listeners:
				{
					sortchange:function(ct, column, e, t, eOpts )
					{
						me.gridColIndexParam=column.getIndex();
						me.gridColStateParam=column.sortState;
						this.getStore().loadPage(activePage);
					}
				},
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: {
						change : function(thisd, params)
						{
							if(!Ext.isEmpty(params) && isPagingHidden)
								activePage = params.currentPage;
							else
								activePage=1;
						}
					}
				}]
			});
//			gridChartAry.push(gridpanel);
			var iographFound=appConstants.jsonData.ioGraphenabled;
			gridChartAry.push({
				xtype:'container',
				columnWidth:.5,
				id:'cpu_util',
				flex:.5,
			//	margin:'0 10 2 0',
				style: {
					'border-right': '1px solid #dedede'
				},
				items:[
					{
						xtype:'container',
						html:'<div style="padding:20px 10px 10px 10px" class="newFont_bold14">CPU Utilization</div>'
					},
					{
						xtype:'container',
						height:300,
						id:'id_1'
					},
					{
						xtype:'container',
						margin:'5 10 5 10',
						id:'legend_id_1'
					},
				],
				listeners:{
					afterrender:function(){
						if(iographFound != undefined && iographFound !="false")
							Ext.getCmp('cpu_util').el.setStyle({'border-bottom': '1px solid #dedede'})
					}
				}
			},
			{
				xtype:'container',
				columnWidth:.5,
				flex:.5,
				id:'mem_util',
			//	margin:'0 10 2 0',
				items:[
					{
						xtype:'container',
						html:'<div style="padding:20px 10px 10px 10px" class="newFont_bold14">Memory Utilization</div>'
					},
					{
						xtype:'container',
						height:300,
						id:'id_2'
					},
					{
						xtype:'container',
						margin:'5 10 5 10',
						id:'legend_id_2'
					},
				],
				listeners:{
					afterrender:function(){
						if(iographFound != undefined && iographFound !="false")
							Ext.getCmp('mem_util').el.setStyle({'border-bottom': '1px solid #dedede'})
					}
				}
			});
		
			
			if(iographFound != undefined && iographFound !="false")
			{
				gridChartAry.push({
					xtype:'container',
					columnWidth:.5,
					flex:.5,
				//	margin:'0 10 2 0',
					style: {
						'border-right': '1px solid #dedede'
					},
					items:[
						{
							xtype:'container',
							html:'<div style="padding:20px 10px 10px 10px" class="newFont_bold14">IO Operations</div>'
						},
						{
							xtype:'container',
							height:300,
							id:'id_4'
						},
						{
							xtype:'container',
							margin:'5 10 5 10',
							id:'legend_id_4'
						},
					]
				});
			}
			resultPanelObj.add({
				xtype:'panel',
				margin:'0 2 10 0',
				ui:'newGraphPanel',
				layout:{
					type:'column',
					align:'stretch',
				},
				title:"<span class='newFont_bold14'>Browser Start Time</span>",
				items:gridChartAry
			});

			var memoryDataFound=appConstants.jsonData.memoryGraphDataFound;
			var cpuDataFound=appConstants.jsonData.cpuGraphDataFound;
			var ioDataFound=appConstants.jsonData.ioGraphDataFound;

			var cpuApplicationGraph=appConstants.jsonData.cpuApplicationGraph;
			if(cpuDataFound=="true")
			{
				var lineChart = {};
				lineChart = jQuery.extend(true, {}, getHighChartsInstance('id_1',300,400), lineChart);
				lineChart.setData(cpuApplicationGraph,appConstants.currentDateFormat,'');
				lineChart.drawChart();
			}
			else
			{
				Ext.get('id_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
			}

			if(memoryDataFound=="true")
			{
				var memoryApplicationGraph=appConstants.jsonData.memoryApplicationGraph;
				var lineChart_1 = {};
				lineChart_1 = jQuery.extend(true, {}, getHighChartsInstance('id_2',300,400), lineChart_1);
				lineChart_1.setData(memoryApplicationGraph,appConstants.currentDateFormat,'');
				lineChart_1.drawChart();
			}
			else
			{
				Ext.get('id_2').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
			}
		
			if(iographFound != undefined && iographFound !="false")
			{
				if(ioDataFound=="true")
				{
					var ioApplicationGraph=appConstants.jsonData.ioApplicationGraph;
					var lineChart_2 = {};
					lineChart_2 = jQuery.extend(true, {}, getHighChartsInstance('id_4',300,400), lineChart_2);
					lineChart_2.setData(ioApplicationGraph,appConstants.currentDateFormat,'');
					lineChart_2.drawChart();
				}
				else
				{
					Ext.get('id_4').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
				}
			}
			
		}
		else
		{
			resultPanelObj.add({
				xtype:'panel',
				margin:'0 2 10 0',
				ui:'newGraphPanel',
				columnWidth:1,
				title:"<span class='newFont_bold14'>Application Used</span>",
				height:200,
				html: '<table width ="100%" cellpadding="0px" cellspacing="0px"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>',
			});
		}
		resultPanelObj.doLayout();
		resultPanelObj.show();
	}
});