Ext.define('vdiappactivity.controller.Main', {
	extend: 'Ext.app.Controller',
	views: ['Main'],
	refs: [{
		selector: 'main',
		ref: 'main'
	}, {
		selector: 'newUtilities',
		ref: 'newUtilities'
	},
	{selector:'nomeasurepanel', ref:'nomeasurepanel'},
	{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init: function () {
		this.control({
			 'mainform button[id="panelinsidetoggle"]': {
                'click': this.goTopanelinsidetoggle
            },
			'main': {
				'afterrender': this.defaultLoading
			},
			'newUtilities': {
				'afterrender': this.loadTools
			},
			'vdiappactivityConfig': {
				'afterrender': this.afterSettingsrender
			},
			'newUtilities #saveTool button': {
				'click': this.saveReportAsPDF
			},
			'newUtilities > #printTool > button': {
				'click': this.printFile
			},
			'newUtilities > #mailTool > button': {
				'click': this.sendMail
			},
			'newUtilities > #favoriteTool > button': {
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button': {
				'click': this.sendToschedule
			},
			'vdiappactivityForm combo[name="er_group"]': {
				'select': this.groupOnChange
			},
			'vdiappactivityForm combo[name="group_name"]': {
				'select': this.groupNameOnChange
			},
			'vdiappactivityForm combo[name="includeSubZone"]': {
				'select': this.includeSubZoneOnChange
			},
			'vdiappactivityForm combo[name="er_componentType"]': {
				'select': this.componentTypeOnChange
			},
			'egcomponent combo[name="er_component"]': {
				'select': this.componentOnChange
			},
			'mainform button[name="submit"]': {
				'click': this.showResult
			},
			'mainform button[name="save"]': {
				'click': this.goTo
			},
			'vdiappactivityConfig combo[name="excludeWeek"]': {
				'select': this.weekendOnChange
			},
			'vdiappactivityConfig combo[name="er_timeline"]': {
				//'select': this.timeLineOnChange  ,
			},
			'vdiappactivityConfig combo[name="reportGeneration"]': {
				'select': this.reportGenChange
			},
			'vdiappactivityConfig button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'vdiappactivityConfig button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'egcomponent button[id="expandSelector"]': {
				'click': this.expandMe
			},
			'timeline combo[name="er_mode"]':
			 {
				'change': this.changeEr_mode
			 },
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},

	showConfigDropdown:function(){
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		Ext.create('Ext.container.Container',{
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			width:565,
			//padding:5,
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'380px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'vdiappactivityConfig',
					parent:this
				}
			],
			renderTo:'main-body'
		});
		var thisController = this;
		Ext.get('closeSettings').on('click', function () {
			   thisController.validateAndCloseSettings();
		});
	},
		filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);
    },
       changeEr_mode: function (combo) {
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
     },
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(true);
			if (isSettingsOk) {
				getButtonObj.setDisabled(false);
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			}
		return isSettingsOk;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	afterSettingsrender : function() {
		 Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields =  appConstants.publicjsonData.hiddenFields;
		var favorite_id = hiddenFields["favorite_id"];
		var schedule_id = hiddenFields["schedule_id"];

		if((!Ext.isEmpty(favorite_id) && favorite_id!="undefined" && favorite_id!=undefined && favorite_id!="null") || (!Ext.isEmpty(schedule_id) && schedule_id!="undefined" && schedule_id!=undefined && schedule_id!="null")){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var jsonData = appConstants.publicjsonData;
		var rawData = jsonData.showTopArray;
		var screenLabels = jsonData.screenLabels;
		var selectedTopVal = jsonData.selectedShowTop;
		var obj = Ext.getCmp('selectedShowTop');
		obj.setFieldLabel(screenLabels['reporter.common.Show Top N']);
		obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(rawData)) {
			if (!Ext.isEmpty(selectedTopVal)) {
				obj.setValue(selectedTopVal);
			} else {
				obj.setValue(rawData[0].valueField);
			}
		}

		var excludeWeekrawData = jsonData.excludeArray;
		var excludeWeek = jsonData.excludeWeek;
		obj = Ext.getCmp('excludeWeek');
		obj.setFieldLabel(screenLabels['reporter.common.Exclude Weekends']);
		obj.getStore().loadRawData(excludeWeekrawData);
		if (!Ext.isEmpty(excludeWeek)) {
			obj.setValue(excludeWeek);
		} else {
			obj.setValue(excludeWeekrawData[0].valueField);
		}

		var timeFrom = jsonData.timefrom;
		var minsFrom = jsonData.minfrom;
		var timeTo = jsonData.timeto;
		var minsTo = jsonData.minto;
		obj = Ext.getCmp('timefrom');
		obj.setValue(timeFrom);
		obj = Ext.getCmp('minfrom');
		obj.setValue(minsFrom);
		obj = Ext.getCmp('timeto');
		obj.setValue(timeTo);
		obj = Ext.getCmp('minto');
		obj.setValue(minsTo);

		rawData = jsonData.reportGenerationArray;
		var er_reportgenration = jsonData.er_reportgenration;
		obj = Ext.getCmp('reportGeneration');
		obj.setFieldLabel(screenLabels['reporter.consolidated.Report Generation']);
		obj.getStore().loadRawData(rawData);
		obj.setValue(er_reportgenration);
		//var excludeDaysObj = Ext.getCmp('excludeDays');
		//excludeDaysObj.show();
		//excludeDaysObj.update('<b>'+appConstants.globalScreenLabels['MappedExcludeDays']+'</b>');

	 },
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicjsonData.hiddenFields;
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.saveFavorite();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.sendToschedule();
		}
    },
	loadTools: function () {
		this.getNewUtilities().loadIcon(true, true, true, false, false, true,
			true, false, false, false,true);

		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	showResult: function () {
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var startdate = Ext.getCmp('er_stdate').getValue();
        var starthr = Ext.getCmp('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = Ext.getCmp('er_enddate').getValue();
        var endhr = Ext.getCmp('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var MaxDaysInMonth = appConstants.publicjsonData['hiddenFields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicjsonData['hiddenFields']['userTimeline'];
		if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, startdate, enddate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: 'Resource Usage Settings',
                    msg: _invalidUserTime,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
               return false;
            }
        }
        var isSettingsOk = this.validateMainForm(true);

		if (isSettingsOk) {
			this.formSubmit();
		} else {
			return;
		}
	},
	validateMainForm: function (flag) {
		var startdate = Ext.getCmp('er_stdate').getValue();
        var starthr = Ext.getCmp('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = Ext.getCmp('er_enddate').getValue();
        var endhr = Ext.getCmp('er_endhr').getValue();
        enddate.setHours(endhr);
		var er_group = Ext.getCmp('er_group').getValue();
		var group_name = Ext.getCmp('group_name').getValue();
		var timelineChoosen = Ext.getCmp('er_timeline').getValue();
		var reportgen = appConstants.publicjsonData.er_reportgenration;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
        var MaxDaysInMonth = appConstants.publicjsonData['hiddenFields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicjsonData['hiddenFields']['userTimeline'];
		if (er_group != null && er_group != 'Zone') {
			var groupcombo = Ext.getCmp('er_componentType').getValue();
			if (groupcombo == '-1' || groupcombo == 'NotApplicable' || groupcombo=='notapplicable') {
					Ext.MessageBox.show({
					title: 'VDI Assessment',
					msg: Ext.getCmp('er_componentType').getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		if (er_group != null && er_group == 'Zone') {
			var groupcombo = Ext.getCmp('er_componentType').getValue();
			if (groupcombo == '-1' || groupcombo == 'NotApplicable' || groupcombo=='notapplicable') {
				Ext.MessageBox.show({
					title: 'VDI Assessment',
					msg: Ext.getCmp('er_componentType').getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}


		if (group_name != null) {
			var groupcombo = Ext.getCmp('group_name').getValue();
			if (groupcombo == '-1' || groupcombo == 'NotApplicable' || groupcombo=='notapplicable') {
				Ext.MessageBox.show({
					title: 'VDI Assessment',
					msg: Ext.getCmp('group_name').getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		if(flag)
		{
			if (reportgen != null && reportgen == 'foreground') {
				var limitforbg = appConstants.publicjsonData['hiddenFields']['limitforbg'];
				if (!Ext.isEmpty(limitforbg)) {
					if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, startdate, enddate)) {
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
						return false;
					} 
				} 
			} 
		}
		return true
	},
	formSubmit: function () {
		this.updateQueryString();
		var urlforAjax;
		var start_date = appConstants.publicjsonData.startDate;
		var end_date = appConstants.publicjsonData.endDate;
		var reportGeneration = appConstants.publicjsonData.er_reportgenration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
		var hiddenfieldQString = "";
		var finalParams = "";
		var comQuery = "";
		var gpArray = new Array();
		gpArray = Ext.getCmp('er_component').getValue();
		var startdate = Ext.getCmp('er_stdate').dataArray;
        var enddate = Ext.getCmp('er_enddate').dataArray;
		if (appConstants.publicjsonData.hasOwnProperty('hiddenFields')) {
			var hiddenFields = appConstants.publicjsonData.hiddenFields;
			for (var hiddenField in hiddenFields) {
				if (hiddenField == 'reporttype' || hiddenField == 'subtype') {
					continue;
				}
				if (hiddenField == 'beanstartdate' ) {
					var beanval = formatDate(new Date(getDateFromFormat(startdate,currentdateFormat_temp)),"dd-MM-yyyy");
					hiddenfieldQString += "&" + hiddenField + "=" + beanval;
				}else if(hiddenField == 'beanenddate'){
					var beanval = formatDate(new Date(getDateFromFormat(enddate,currentdateFormat_temp)),"dd-MM-yyyy");
					hiddenfieldQString += "&" + hiddenField + "=" + beanval;

				}else
					hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		for (var k = 0; gpArray.length > k; k++) {
			comQuery += "&er_component=" + gpArray[k];
		}

		finalParams = appConstants.queryString + comQuery + hiddenfieldQString; // + "&isSubmit=true";
		if (reportGeneration == 'foreground') {
			{
				finalParams += "&isSubmit=true";
				urlforAjax = '../servlet/com.eg.ErVDIAssessmentController?beta=json';
			}
		} else if (reportGeneration == 'background') {
			finalParams += "&throughSchedule=true";
			urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
			var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			finalParams += "&bg_reportname=" + bg_reportname;
		}
		appConstants.initLdgMask.show();
 		Ext.Ajax.request({
			url: urlforAjax,
			params: finalParams,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadReportData(jsonData);
			}
		});
	},
	saveReportAsPDF: function () {
		var saveQString = appConstants.publicjsonData.saveQstring;
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString + "&pdfSave=yes";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicjsonData.saveQstring;
		var s_qryString = saveQString + "&pdfSave=yes";
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		this.updateQueryString();
		bookletquery+=appConstants.queryString;
		var er_comp_Array = new Array();
		if (appConstants.publicjsonData.hasOwnProperty('hiddenFields')) {
			var hiddenFields = appConstants.publicjsonData.hiddenFields;
			for (var hiddenField in hiddenFields) {
				if (hiddenField == 'reporttype' || hiddenField == 'subtype' || hiddenField == 'isSubmit') {
					continue;
				}
				bookletquery+= "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		er_comp_Array = Ext.getCmp('er_component').getValue();
		for (var k = 0; er_comp_Array.length > k; k++) {
			bookletquery+= "&er_component=" + er_comp_Array[k];
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile: function () {
		var saveQString = appConstants.publicjsonData.saveQstring;
		var s_qryString = "../reporter/ErVDIAssessmentPrint.jsp?" + saveQString + "&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail: function () {
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	reportGenChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType = Ext.getCmp('reportGeneration').getValue();
		if (reportGenType == 'background') {
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		} else {
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	/* weekendOnChange: function () {
		var weekendvalue = Ext.getCmp('excludeWeek').getValue();;
		var excludeDaysObj = Ext.getCmp('excludeDays');
		if (weekendvalue == 'yes') {
			excludeDaysObj.show();
			excludeDaysObj.update('<b>'+appConstants.globalScreenLabels['MappedExcludeDays']+'</b>');
		} else {
			excludeDaysObj.hide();
		}
	},*/
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),Ext.getCmp('componentLabel').text,btn);
	},
	saveFavorite: function () {
		var isValid = this.validateMainForm(false);
		/* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'VDI Assessment-Application Activity',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		} */
		if (!isValid)
			return;
		this.updateQueryString();
		var finalParams;
		var hiddenfieldQString = "";
		var er_comp_Array = new Array();
		var comQuery = "";
		var start_date = appConstants.publicjsonData.startDate;
		var end_date = appConstants.publicjsonData.endDate;

		if (appConstants.publicjsonData.hasOwnProperty('hiddenFields')) {
			var hiddenFields = appConstants.publicjsonData.hiddenFields;
			for (var hiddenField in hiddenFields) {
				if (hiddenField == 'reporttype' || hiddenField == 'subtype') {
					continue;
				}
				hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		er_comp_Array = Ext.getCmp('er_component').getValue();
		for (var k = 0; er_comp_Array.length > k; k++) {
			comQuery += "&er_component=" + er_comp_Array[k];
		}
		finalParams = appConstants.queryString + comQuery + hiddenfieldQString; // +"&isSubmit=true&beta=json";
		var hiddenFields =  appConstants.publicjsonData.hiddenFields;
		var favorite_id = hiddenFields["favorite_id"];
		var target = "../servlet/com.eg.ErFavoriteC?" + finalParams + "&isSubmit=true&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+favorite_id;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendToschedule: function () {
		var isValid = this.validateMainForm(false);
		if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'VDI Assessment-Application Activity',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		}
		if (!isValid)
			return;
		this.updateQueryString();
		var finalParams;
		var hiddenfieldQString = "";
		var er_comp_Array = new Array();
		var comQuery = "";
		var start_date = appConstants.publicjsonData.startDate;
		var end_date = appConstants.publicjsonData.endDate;

		if (appConstants.publicjsonData.hasOwnProperty('hiddenFields')) {
			var hiddenFields = appConstants.publicjsonData.hiddenFields;
			for (var hiddenField in hiddenFields) {
				if (hiddenField == 'reporttype' || hiddenField == 'subtype' || hiddenField == 'isSubmit') {
					continue;
				}
				hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		er_comp_Array = Ext.getCmp('er_component').getValue();
		for (var k = 0; er_comp_Array.length > k; k++) {
			comQuery += "&er_component=" + er_comp_Array[k];
		}
		finalParams = appConstants.queryString + comQuery + hiddenfieldQString;
		var target = "/final/reporter/ErSaveSchedule.jsp?" + finalParams+"&com.eg.CSRF_NONCE="+csrfToken;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	updateQueryString: function () {
		var jsonData = appConstants.publicjsonData;
		var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var configParams = "";
		var detailedParams = "";

		var selectedShowTop = jsonData.selectedShowTop;
		var weekendvalue = jsonData.excludeWeek;
		var reportGeneration = jsonData.er_reportgenration;
		var timperiodParams = "&timefrom=" + jsonData.timefrom + "&minfrom=" + jsonData.minfrom + "&timeto=" + jsonData.timeto + "&minto=" + jsonData.minto;
		if (isSettingsEnabled)
		{
			selectedShowTop = Ext.getCmp('selectedShowTop').getValue();
			weekendvalue = Ext.getCmp('excludeWeek').getValue();
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
			timperiodParams = "&timefrom=" + Ext.getCmp('timefrom').getValue() + "&minfrom=" + Ext.getCmp('minfrom').getValue() + "&timeto=" + Ext.getCmp('timeto').getValue() + "&minto=" + Ext.getCmp('minto').getValue();
		}

		var reportType = appConstants.publicjsonData['hiddenFields']['reporttype'];
		var subType = appConstants.publicjsonData['hiddenFields']['subtype'];
		var reportParams = "&reporttype=" + reportType + "&subtype=" + subType;

		configParams = "&er_reportType=" + reportType;

		configParams += "&er_excwe=" + weekendvalue;

		configParams += "&er_mode=" + Ext.getCmp('er_mode').getValue();

		var er_group = Ext.getCmp('er_group').getValue();
		var er_componentType = Ext.getCmp('er_componentType').getValue();

		detailedParams = "er_group=" + er_group + "&er_reportgenration=" + reportGeneration + "&sh_timeinuse=" + Ext.getCmp('showTimeArray').getValue() + "&er_showTop=" + selectedShowTop;
		detailedParams += "&er_componentType=" + er_componentType;
		detailedParams += "&er_component=" + Ext.getCmp('er_component').getValue();

		if (er_group == 'Zone') {
			var includeSubzone = Ext.getCmp('includeSubZone').getValue();
			detailedParams += "&includeSubZone=" + includeSubzone;
			var group_name = Ext.getCmp("group_name").getValue();
			detailedParams += "&group_name=" + group_name;
		}
		if (er_group == 'Segment' || er_group == 'Service' ) {
			var group_name = Ext.getCmp('group_name').getValue();
			detailedParams += "&group_name=" + group_name;
		}
		appConstants.queryString = detailedParams + configParams + timperiodParams + timelineParams + reportParams;
		var hiddenFields = appConstants.publicjsonData['hiddenFields'];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		appConstants.queryString += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
	    	appConstants.queryString +="&er_RmDispName="+appConstants.er_RmDispName;

	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	disableTools: function () {
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	groupOnChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		this.updateQueryString();
		Ext.Ajax.request({
			url: '/final/reporter/ErVDIApplicationActivityJson.jsp',
			params: appConstants.queryString,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadGroupNames(jsonData);
			}
		});
	},
	loadGroupNames: function (jsonData) {
		var er_group = Ext.getCmp('er_group').getValue();
		var groupObj = Ext.getCmp('group_name');
		var er_groupObj = Ext.getCmp('er_group');
		var er_groupRawData = jsonData.analysisByArray;
		var er_compObj = Ext.getCmp('er_component');
		var er_compTypeObj = Ext.getCmp('er_componentType');
		var er_compTypeRawData = jsonData.componentTypeArray;
		var er_componentType = jsonData.er_componentType;
		var er_componentRawData = jsonData.componentArray;
		appConstants.rawDataForComponents = er_componentRawData;
		var er_component = jsonData.er_component;
		var screenLabels = jsonData.screenLabels;
		if (er_group == 'Zone') {
			var subzoneObj = Ext.getCmp('includeSubZone');
			var elementsRawData = jsonData.GroupArray;
			var group_name = jsonData.group_name;
			groupObj.setFieldLabel(screenLabels['reporter.common.Zone']);
			groupObj.getStore().clearFilter(true); 
			groupObj.getStore().loadRawData(elementsRawData);
			groupObj.setValue(elementsRawData[0].valueField);
			var subzoneRawData = jsonData.includeSubZoneArray;
			subzoneObj.setFieldLabel(screenLabels['reporter.thin.Include subzones']);
			subzoneObj.getStore().loadRawData(subzoneRawData);
			subzoneObj.setValue(subzoneRawData[0].valueField);
			var subzoneRawData = jsonData.includeSubZoneArray;
			subzoneObj.show();
			groupObj.show();
			er_compObj.getStore().loadRawData(er_componentRawData);
			er_compObj.setValue(er_componentRawData[0].valueField);
			er_compObj.getStore().clearFilter(true);
			er_compTypeObj.getStore().loadRawData(er_compTypeRawData);
			er_compTypeObj.setValue(er_compTypeRawData[0].valueField);
		} else if (er_group == 'Segment') {
			var elementsRawData = jsonData.GroupArray;
			groupObj.setFieldLabel(screenLabels['reporter.common.Segment']);
			groupObj.getStore().clearFilter(true);
			groupObj.getStore().loadRawData(elementsRawData);
			groupObj.setValue(elementsRawData[0].valueField);
			er_groupObj.getStore().loadRawData(er_groupRawData);
			er_groupObj.setValue(er_group);
			er_compTypeObj.getStore().loadRawData(er_compTypeRawData);
			er_compTypeObj.setValue(er_compTypeRawData[0].valueField);
			er_compObj.getStore().loadRawData(er_componentRawData);
			er_compObj.setValue(er_componentRawData[0].valueField);
			Ext.getCmp('includeSubZone').hide();
			groupObj.show();
		} else if (er_group == 'Service') {
			var elementsRawData = jsonData.GroupArray;
			groupObj.setFieldLabel(screenLabels['reporter.common.Service']);
			groupObj.getStore().clearFilter(true);
			groupObj.getStore().loadRawData(elementsRawData);
			groupObj.setValue(elementsRawData[0].valueField);
			er_groupObj.getStore().loadRawData(er_groupRawData);
			er_groupObj.setValue(er_group);
			er_compTypeObj.getStore().loadRawData(er_compTypeRawData);
			er_compTypeObj.setValue(er_compTypeRawData[0].valueField);
			er_compObj.getStore().loadRawData(er_componentRawData);
			er_compObj.setValue(er_componentRawData[0].valueField);
			Ext.getCmp('includeSubZone').hide();
			groupObj.show();
		} else {
			Ext.getCmp('includeSubZone').hide();
			groupObj.hide();
			er_compTypeObj.getStore().clearFilter(true);
			er_compTypeObj.getStore().loadRawData(er_compTypeRawData);
			er_compTypeObj.setValue(er_compTypeRawData[0].valueField);
			er_compObj.getStore().loadRawData(er_componentRawData);
			er_compObj.setValue(er_componentRawData[0].valueField);
		}
	},
	groupNameOnChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		this.updateQueryString();
		Ext.Ajax.request({
			url: '/final/reporter/ErVDIApplicationActivityJson.jsp',
			params: appConstants.queryString,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadComponentTypeCombo(jsonData);
			}
		});
	},
	componentTypeOnChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		this.updateQueryString();
		Ext.Ajax.request({
			url: '/final/reporter/ErVDIApplicationActivityJson.jsp',
			params: appConstants.queryString,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadComponentCombo(jsonData);
			}
		});
	},
	componentOnChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		this.updateQueryString();
		Ext.Ajax.request({
			url: '/final/reporter/ErVDIApplicationActivityJson.jsp',
			params: appConstants.queryString,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadComponentCombo(jsonData);
			}
		});
	},
	showOnChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
	},
	showLoadingIcon: function () {
		appConstants.initLdgMask.show();
	},

	defaultLoading: function () {
		//this.getMain().showConfigDropdown();
		this.disableTools();
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
		this.loadField(appConstants.publicjsonData);
		if(!hideBackButton){
			Ext.getCmp('vdiappactivityForm').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonData['ID']
				}
			);
		}

		this.refreshReportData();
	},
	refreshReportData: function () {
		if (appConstants.isSubmit != null && appConstants.isSubmit == "true") {
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	loadReportData: function (jsonData) {
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var resultPanelObj = Ext.getCmp('resultPanel');
  		var reportGeneration = appConstants.publicjsonData.er_reportgenration;

		if (reportGeneration == 'background') {
 			var htmlStr = '';
			var backgroundReportStatus = jsonData.backgroundReportStatus;
			resultPanelObj.hide();
 			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:420px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a class="backgroundMsgLink" href=' + bgroundReportsURL + '>' + sub + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:420px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a class="backgroundMsgLink" href=' + bgroundReportsURL + '>' + sub + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>';
			}
				this.getBackGroundPanel().update(htmlStr);
 				this.getBackGroundPanel().show();
				appConstants.initLdgMask.hide();
		} else {
 			resultPanelObj.show();
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
 			if (appConstants.publicjsonData.hasOwnProperty('chartData')) {
				var chartArray = appConstants.publicjsonData.chartData;
				var noOfCharts = chartArray.length;
				itemsArray = new Array();
				if (noOfCharts == 0) {
					Ext.getCmp("bookletTool").setDisabled(true);
					Ext.getCmp("saveTool").setDisabled(true);
					Ext.getCmp("printTool").setDisabled(true);
					Ext.getCmp("mailTool").setDisabled(true);
				}
				if(noOfCharts!=null)
				{
					for (var i = 0; noOfCharts > i; i++) {
					var DefaultHeight = 300;
					var containerId = "chartContainer" + i;
					var panelId = "fusionPanel" + i;
					var chartHeight = parseInt(chartArray[i].chartHeight);
					var drillDownQstring = chartArray[i].drillDownQstring;
					var chartTitle = chartArray[i].chartTitle;
					drillDownQstring += "&reportName=ErVDIAssessmentDrillDown&drillDown=yes";
					if (DefaultHeight < chartHeight)
						DefaultHeight = chartHeight;
					var chartObj = chartArray[i];
					var htmlstr = '<table align="center" width="100%" cellspacing="0" cellpadding="0px" border="0px"><tr>'
					htmlstr += '<td align="center">';
					htmlstr += '<table  cellpadding="0" cellspacing="0" class="border eg_whitebg" style="table-layout:fixed" width="90%">'
					htmlstr += '<tr>';
					htmlstr += '<td>';
					htmlstr += '<div style="text-align:center;margin-left:2px;margin-right:4px;cursor:pointer;cursor:hand;z-index:1000;height:' + DefaultHeight + '" id="' + containerId + '"  ></div>';
					htmlstr += '</td>';
					htmlstr = htmlstr + '</tr>';
					htmlstr = htmlstr + '</table>';
					htmlstr = htmlstr + '</td>';
					htmlstr = htmlstr + '</tr>';
					htmlstr = htmlstr + '</table>';
					drillDownQstring += "&calculatedHeight=" + DefaultHeight;
					reportLayout = 'column';
					var panelAdd = {
						xtype: 'panel',
						title: chartTitle,
						html: htmlstr,
						//cls:'containerShadow',
						ui:'newGraphPanel',
						margin : '0 10 10 0',
						frame:false,
						border:true,
						id: panelId,
						//width: 500,
						//height:350,
						scroll:true,
						autoScroll:true,
						padding:0,
						bodyPadding:'0 0 0 0',
						dataArray: drillDownQstring
					}
					itemsArray.push(panelAdd);
				}
				resultPanelObj.removeAll();
				resultPanelObj.add(itemsArray);
				if (noOfCharts == 1) {
					reportLayout = 'vbox';
				}
				resultPanelObj.doLayout();

				for (var i = 0; chartArray.length > i; i++) {
					var chartObj = chartArray[i];
					var charid = "myChartId" + i;
					var containerId = "chartContainer" + i;
					var containerObj = Ext.getCmp(containerId);
					var panelId = "fusionPanel" + i;
					var panelObj = Ext.getCmp(panelId);
					var xmlcode = chartObj.XMLData;
					if (xmlcode != '-') {
						if(appConstants.chartType=='fusionchart')
					{
						if (FusionCharts(charid))
							FusionCharts(charid).dispose();
						var myChart = new FusionCharts(chartObj.swfpath, charid, "98%", "300", "0", "1");
						myChart.setXMLData(xmlcode);
						myChart.setTransparent(true);
						myChart.render(containerId);
					}
						//
					else if(appConstants.chartType=='highchart')
					{
						var xAxisLabel=chartObj.xAxisLabel;
						var estimatedHeight=xAxisLabel.length*25;
						if(estimatedHeight<320)
							estimatedHeight=320;
					var lineChart = {
							};
						
					lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(containerId,estimatedHeight,400), lineChart);

							lineChart.setData(chartObj,'<%=currentDateFormat%>','');
							lineChart.drawChart();
					}
					} else {
  						//Ext.get(containerId).update('<center><img src="/final/reporter/images/nographformeasure.png" height="100%" width="100%" /></center>');
					Ext.get(containerId).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');

					}


				}
 				if(noOfCharts==null || noOfCharts==1 || noOfCharts==0)
				{
 					resultPanelObj.hide();
					this.getNomeasurepanel().doLayout();
 					this.getNomeasurepanel().show();

  				} else {
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
			}
		}
		appConstants.initLdgMask.hide();
		}
	},
	validateSettings: function () {
		var isSettingsOk = true;
		var MaxDaysInMonth = appConstants.publicjsonData['hiddenFields']['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicjsonData['hiddenFields']['userTimeline'];
		var reportgen = Ext.getCmp('reportGeneration').getValue();
		var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
		var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
		var timePeriodToHrs = Ext.getCmp('timeto').getValue();
		var timePeriodToMins = Ext.getCmp('minto').getValue();
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		if (!checkTimePeriod(timePeriodFromHrs, timePeriodFromMins, timePeriodToHrs, timePeriodToMins)) {
			isSettingsOk = false;
		}
		if (reportgen != null && reportgen == 'background') {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		return isSettingsOk;
	},
	loadAnalysisByCombo: function (jsonData) {
		var obj = Ext.getCmp('er_group');
		var rawData = jsonData.anaylsisByArray;
		var selection = jsonData.er_group;
		obj.getStore().loadRawData(rawData);
		obj.setValue(selection);
	},
	loadIncludeSubZonesCombo: function (jsonData) {
		var obj = Ext.getCmp('includeSubZone');
		var rawData = jsonData.includeSubZoneArray;
		var selection = jsonData.includeSubZone;
		obj.getStore().loadRawData(rawData);
		obj.setValue(selection);
	},
	loadGroupCombo: function (jsonData) {
		var obj = Ext.getCmp('group_name');
		var rawData = jsonData.GroupArray;
		var selection = jsonData.group_name;
		obj.getStore().clearFilter(true);
		obj.getStore().loadRawData(rawData);
		obj.setValue(selection);
	},
	loadComponentTypeCombo: function (jsonData) {
		var obj = Ext.getCmp('er_componentType');
		var rawData = jsonData.componentTypeArray;
		var selection = jsonData.er_componentType;
		obj.getStore().clearFilter(true);
		obj.getStore().loadRawData(rawData);
		obj.setValue(rawData[0].valueField);
		obj = Ext.getCmp('group_name');
		rawData = jsonData.GroupArray;
		selection = jsonData.group_name;
		obj.getStore().clearFilter(true);
		obj.getStore().loadRawData(rawData);
		obj.setValue(selection);
	},
	loadComponentCombo: function (jsonData) {
		var obj = Ext.getCmp('er_component');
		var rawData = jsonData.componentArray;
		var selection = jsonData.er_component;
		appConstants.rawDataForComponents = rawData;
		obj.getStore().loadRawData(rawData);
		obj.setValue(rawData[0].valueField);
		obj = Ext.getCmp('er_componentType');
		rawData = jsonData.componentTypeArray;
		selection = jsonData.er_componentType;
		obj.getStore().clearFilter(true);
		obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(selection)) {
			obj.setValue(selection);
		} else {
			obj.setValue(rawData[0].valueField);
		}
	},
	showConfirmResult: function (btn) {
		if (btn == "yes") {
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			this.formSubmit();
		} else {
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
			var reportGenType = Ext.getCmp('reportGeneration');
			var bgreportNameObj = Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			bgreportNameObj.focus(false, 1000);
			return false;
		}
	},
	loadField: function (jsonData) {
		var isSubmitted = "false";
		if (jsonData.hasOwnProperty('isSubmit'))
			var isSubmitted = jsonData.isSubmit;

		var hiddenFields = appConstants.publicjsonData['hiddenFields'];
        	var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}

		var screenLabels = jsonData.screenLabels;
		appConstants.globalScreenLabels = jsonData.screenLabels;
		var rawData = jsonData.analysisByArray;
		var er_group = jsonData.er_group;
		var obj = Ext.getCmp('er_group');
		obj.setFieldLabel(screenLabels['reporter.common.Analysis By']);
		obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(rawData)) {
			if (!Ext.isEmpty(er_group)) {
				obj.setValue(er_group);
			} else {
				obj.setValue(rawData[0].valueField);
			}
		}
		var groupObj = Ext.getCmp('group_name');
		var er_groupObj = Ext.getCmp('er_group');
		var er_groupRawData = jsonData.analysisByArray;
		if (er_group == 'Zone') {
			var rawData = jsonData.GroupArray;
			groupObj.setFieldLabel(screenLabels['reporter.common.Zone']);
			groupObj.getStore().clearFilter(true);
			groupObj.getStore().loadRawData(rawData);
			groupObj.setValue(jsonData.group_name);
			obj = Ext.getCmp('includeSubZone');
			subrawData = jsonData.includeSubZoneArray;
			obj.setFieldLabel(screenLabels['reporter.thin.Include subzones']);
			obj.getStore().loadRawData(subrawData);
			obj.setValue(jsonData.includeSubZone);
			Ext.getCmp('includeSubZone').show();
			Ext.getCmp('group_name').show();
		}else if (er_group == 'Segment') {
			var elementsRawData = jsonData.GroupArray;
			groupObj.setFieldLabel(screenLabels['reporter.common.Segment']);
			groupObj.getStore().clearFilter(true);
			groupObj.getStore().loadRawData(elementsRawData);
			if(jsonData.group_name!=null)
				groupObj.setValue(jsonData.group_name);
			else
				groupObj.setValue(elementsRawData[0].valueField);
			er_groupObj.getStore().loadRawData(er_groupRawData);
			er_groupObj.setValue(er_group);
			Ext.getCmp('includeSubZone').hide();
			groupObj.show();
		} else if (er_group == 'Service') {
			var elementsRawData = jsonData.GroupArray;
			groupObj.setFieldLabel(screenLabels['reporter.common.Service']);
			groupObj.getStore().clearFilter(true);
			groupObj.getStore().loadRawData(elementsRawData);
			if(jsonData.group_name!=null)
				groupObj.setValue(jsonData.group_name);
			else
				groupObj.setValue(elementsRawData[0].valueField);
			er_groupObj.getStore().loadRawData(er_groupRawData);
			er_groupObj.setValue(er_group);
			Ext.getCmp('includeSubZone').hide();
			groupObj.show();
		}

		rawData = jsonData.componentTypeArray;
		var er_componentType = jsonData.er_componentType;
		obj = Ext.getCmp('er_componentType');
		obj.setFieldLabel(screenLabels['reporter.common.Component Type']);
		obj.getStore().clearFilter(true);
		obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(rawData)) {
			if (!Ext.isEmpty(er_componentType)) {
				obj.setValue(er_componentType);
			} else {
				obj.setValue(rawData[0].valueField);
			}
		}

		rawData = jsonData.componentArray;
		var er_component = jsonData.er_component;
		obj = Ext.getCmp('er_component');
		Ext.getCmp('componentLabel').setText(screenLabels['reporter.common.Component']);
		appConstants.rawDataForComponents = rawData;
		obj.getStore().loadRawData(rawData);
		 if (!Ext.isEmpty(rawData)) {
			if (!Ext.isEmpty(er_component)) {
				obj.setValue(er_component);
			} else {
				obj.setValue(rawData[0].valueField);
			}
		}

		rawData = jsonData.showTimeArray;
		var sh_timeinuse = jsonData.sh_timeinuse;
		obj = Ext.getCmp('showTimeArray');
		obj.setFieldLabel(screenLabels['reporter.common.Weighted Average']);
		obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(rawData)) {
			if (!Ext.isEmpty(sh_timeinuse)) {
				obj.setValue(sh_timeinuse);
			} else {
				obj.setValue(rawData[0].valueField);
			}
		}

		rawData = jsonData.timelineCombo;
		var selectedTimeline = jsonData.selectedTimeline;
		obj = Ext.getCmp('er_timeline');
		obj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(rawData)) {
			if (!Ext.isEmpty(selectedTimeline)) {
				obj.setValue(selectedTimeline);
			} else {
				obj.setValue(rawData[0].valueField);
			}
		}
		var timeFrom = jsonData.timefrom;
		var minsFrom = jsonData.minfrom;
		var timeTo = jsonData.timeto;
		var minsTo = jsonData.minto;
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;

		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;

		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		updatingAppSettings();
	}
});