Ext.define('appvolume.controller.Main',{
	extend:'Ext.app.Controller',
 	refs:[
 		{selector:'newUtilities',ref:'newUtilities'},
 		{selector:'main',ref:'main'},
 		{selector:'nomeasurepanel',ref:'nomeasurepanel'},
 		{selector:'ReporterSettings',ref:'ReporterSettings'}
 	],
	foregroundJspUrl:'/final/reporter/ErVMAppVolumeDetailsJson.jsp',
	foregroundControllerUrl:'../servlet/com.eg.ErVMAppVolumeDetailsReportC',
	isNewFav:false,
	init:function(){
		this.control({
			'main':{
				'afterrender':this.boxready
			},
			'mainform':{
 				'afterrender':this.loadForm
			},
			'newUtilities':{
				'render':this.loadTools
			},
			'vmappvolumeform combo[name="select_farm"]': {
			  'select': this.onZoneChange
			},
			'vmappvolumeform combo[name="er_compType"]':{
				'select': this.onComponentTypeChange
			},
			'main button[name="submit"]':{
				'click': this.showResult
			},
			'egcomponent button[id="compExpand"]':{
				'click': this.expandMe
			},
			'egcomponent multiselect[id="er_component"]':{
				'change': this.onChangeComponent
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #csvTool > button':{
					'click': this.saveCsv
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},			
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'vmappvolumeform button[name="save"]': {
				'click': this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
		});
	},
	onChangeComponent: function (obj,newValue,oldValue) 
	{
		var componentVal = obj.getValue();
		var all_individual_alert = 'All Components and Individual selection cannot be selected simultaneously';
		if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
		{
			Ext.MessageBox.show({
				title: alert_text,
				msg:  all_individual_alert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});				
			return;
		}
//		if(componentVal != undefined && componentVal == '-1'){
//			Ext.getCmp("favoriteTool").setDisabled(true);
//			Ext.getCmp("scheduleTool").setDisabled(true);
//		}else{
//			Ext.getCmp("favoriteTool").setDisabled(false);
//			Ext.getCmp("scheduleTool").setDisabled(false);
//		}
	},
	onSelectAnalysisBy: function (obj) {
		this.hideResults();
		var er_option=obj.getValue();
		var params='er_option='+er_option+"&reportFor="+appConstants.reportFor; 
		this.getAjaxData(this.foregroundJspUrl,params);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		 
		if (er_option=='Component') 
		{
			Ext.getCmp('select_farm').hide();
			Ext.getCmp('er_site').hide();
		}
		else if(er_option=='Zone')
		{
			Ext.getCmp('select_farm').show();
			Ext.getCmp('er_site').hide();
			this.loadComboField('select_farm','zoneCombo','zoneLabel','zoneSelected',appConstants.publicJsonData,false,null,true);
		}
		else 
		{
			Ext.getCmp('select_farm').hide();
			this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		}

		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);			
		this.loadDataForReportChange();
	},
	er_siteOnChange:function(obj) {
		var er_site=obj.getValue(); 
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+Ext.getCmp('er_site').getValue();
		this.getAjaxData(this.foregroundJspUrl,params);	
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadDataForReportChange();
	},
		//
	goTo: function (obj) {
 		if (appConstants.frmSchModify == "Yes")
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj);
	},
	saveSchedule:function(obj){
		if(!this.validateMainForm(true))
			return;
		var target="/final/reporter/ErSaveSchedule.jsp?"+this.getQueryString(true,true,true)+"&com.eg.CSRF_NONCE="+csrfToken;
 		if (obj.getId()=='save')
		{
			if(target!=undefined && target.indexOf("schedule_id")==-1)
				target+='&schedule_id='+appConstants.schedule_id;
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
 	},
	saveFavorite:function(obj){
		var target="";
		//&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
		if(!this.validateMainForm(true))
			return;
		if (obj.getId()=='save')
		{
			this.isNewFav=false;
			target="/final/reporter/ErSaveFavorite.jsp?"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if(target!=undefined && target.indexOf("FavoriteId")==-1)
				target+='&FavoriteId='+appConstants.favorite_id;
			//document.location=target+'&showWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewFav=true;
			target="../servlet/com.eg.ErFavoriteC?"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
 	},
	saveReportAsPDF:function(){
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.publicJsonData.urlFields.saveQueryString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString(true,true,true)+'&er_timeline=1%20day';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){
 		var s_qryString = "/final/reporter/ErVMAppVolumeDetailsPrint.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString+"&er_view=PRINT&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	filterMultiselect: function (obj) {
		obj.toggleTriggger();
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (obj.getId()=='compSearch')	
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicJsonData.combo.componentCombo);
	
		
    },
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (btn.getId()=='compExpand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
		}
 	},

	loadDataforUserDetails:function(){
		var resultObj=Ext.getCmp('resultContainer');
		this.hideResults();
		resultObj.removeAll();
		if(appConstants.publicJsonData != undefined && appConstants.publicJsonData.Results != undefined ){
			this.enableTools();
			var resultData=appConstants.publicJsonData.Results;
			for (var tmpidx in resultData)
			{
				var me=this;
				var activePage=1;
				var sortCol=0;
				var griddatas=resultData[tmpidx];
				if(griddatas != undefined){
					var gridColumn=griddatas.header;
					var headerCombo=griddatas.headerCombo;
					var gridData=griddatas.dataArray;
					if(gridColumn != undefined && gridData != undefined){
						var mainColArray=new Array();
						for (var key in gridColumn)
						{
							mainColumn = gridColumn[key];
							var tmpCol=mainColumn;
							if(headerCombo != undefined){
								tmpCol=tmpCol+'_backendName';
								tmpCol=headerCombo[tmpCol];
							}
							var colWidth=80;
							var colAlgn='center';
							if(tmpCol != undefined && (tmpCol == 'TRGT_HOST' || tmpCol == 'USER_NAME' || tmpCol == 'HOST_DETAIL' || tmpCol == 'LAST_LOGIN' || tmpCol == 'IS_ATTACHABLE'  || tmpCol == 'APP_STACKS')){
								colAlgn='left';
							}
							if(tmpCol != undefined && tmpCol == 'HOST_DETAIL'){
								sortCol=key;
							}
							mainColArray.push({
								header:mainColumn,
								sortable: true,
								extraCol:tmpCol,
								align:colAlgn,
								dataIndex: mainColumn,
								doSort: function(state) 
								{
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2)
										{
											v1 = v1.get(field);
											v2 = v2.get(field);
											if(v1 != undefined && v1.indexOf(":") > -1 && (v1.indexOf('AM') > -1 || v1.indexOf('PM') > -1 ) )
											{
												if( v1.indexOf(' ')>-1 && v1 != '-')
												{
													var tmp = v1;
													try{
														var dateobj=new Date(Ext.Date.parse(tmp, 'M d Y h:iA'));
														v1 = dateobj;
													}catch(e){}
												}else{
													v1=0;
												}
												if(v2.indexOf(' ')>-1 && v2 != '-')
												{
													var tmp = v2;
													try{
														var dateobj=new Date(Ext.Date.parse(tmp, 'M d Y h:iA'));
														v2 = dateobj;
													}catch(e){}
												}else{
													v2=0;
												}
											}
											else if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
													v1= isNaN(v1) ? 0 : v1;
													v2= isNaN(v2) ? 0 : v2;
												}
											}
											else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
											{
												v2=new Date(v2).getTime();
												v1=new Date(v1).getTime();
											}else if((typeof v1 == 'string') && (typeof v1 == 'string')) {
												v1=v1.toLowerCase();
												v2=v2.toLowerCase();
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									if(value != undefined && value.indexOf("~!~") > -1){
										var text = value.substring( 0, value.indexOf('~!~') );
										var url = value.substring( value.indexOf('~!~') + 3 );
										value = url.substring(0, url.indexOf('#') );
										url = url.substring(url.indexOf('#')+1);
										metaData.tdAttr = 'data-qtip="' + value + '"';
										if(text != undefined && text == 'DD'){
											value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:openDDWin(\''+url+'\')">'+value+'</a></div>';
										}
									}else
										metaData.tdAttr = 'data-qtip="' + value + '"';
		//							value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
									return value;
								}
							});
							if(tmpCol != undefined && tmpCol == 'STATE')
							{
								mainColArray[mainColArray.length-1].minWidth=70;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
							else if(tmpCol != undefined && tmpCol == 'MOUNT_COUNT')
							{
								mainColArray[mainColArray.length-1].minWidth=100;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
							else if(tmpCol != undefined && (tmpCol == 'TRGT_HOST' || tmpCol == ''|| tmpCol == 'MOUNTED_TIME'|| tmpCol == 'HOST_DETAIL'|| tmpCol == 'CREATED_TIME')){
								mainColArray[mainColArray.length-1].minWidth=120;
							}
							else if(tmpCol != undefined && tmpCol == 'HOST_DETAIL'){//55
								mainColArray[mainColArray.length-1].minWidth=60;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
							else if(tmpCol != undefined && tmpCol == 'IS_ATTACHABLE'){//55
								mainColArray[mainColArray.length-1].minWidth=120;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
							else if(tmpCol != undefined && tmpCol == 'APP_ASSIGN'){//55
								mainColArray[mainColArray.length-1].minWidth=120;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
							else if(tmpCol != undefined && tmpCol == 'MOUNT_CNT'){//55
								mainColArray[mainColArray.length-1].minWidth=115;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
							else if(tmpCol != undefined && tmpCol == 'TOT_DISK_SIZE'){//55
								mainColArray[mainColArray.length-1].minWidth=135;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
							else if(tmpCol != undefined && (tmpCol == 'USER_NAME' || tmpCol == 'LAST_LOGIN')){//55
								mainColArray[mainColArray.length-1].minWidth=150;
								mainColArray[mainColArray.length-1].flex=0.5;
							}
						}
						var fields=[];
						for(var key in gridData[0])
						{
							fields.push(key);
						}
						var storeObj = Ext.create('Ext.data.Store', {
							fields: fields,
							proxy : {
									type : 'pagingmemory',
									reader : {
										type: 'json', root : 'data', totalProperty : 'total'
									},
								},
							pageSize : 10,	//gridPageSize is added in ErTracker.jsp
							sorters: { property: fields[sortCol], direction : 'ASC' },
							autoLoad : true,
							data:gridData,
						});
						var isPagingHidden;
						if (gridData.length<10)
							isPagingHidden=true;
						else
							isPagingHidden=false;
						var dataArray=new Array();
						dataArray.push({
							xtype:'panel',
							columnWidth : 1.0,
							ui:'newGraphPanel',
							margin:'0 0 10 0',
							needtoFixColumn:true,
							title:tmpidx+" User Details",
							items:[{
								xtype:'customgrid',
								store:storeObj,
								sortableColumns:false,
								ui:'newGridPanel noHoverColor headerTextWrap',
								id:'mainGrid_'+tmpidx,
								margin:'0 10 10 10',
								activePage:1,
								border:true,
								scroll:true,
								autoScroll:true,
								columns:mainColArray,
							//	forceFit:true,
								bodyPadding:'0 0 0 0',
								listeners:{
									sortchange:function(ct, column, e, t, eOpts ){
										me.gridColIndexParam=column.getIndex();
										me.gridColStateParam=column.sortState;
										this.getStore().loadPage(activePage);
									},
									render:function(obj){
										Ext.defer(function() {
											if(!Ext.isEmpty(obj.columns[sortCol]))
											{
												obj.columns[sortCol].doSort('ASC');
											}
										},100);
									}
								},
								dockedItems:[{
									xtype:'pagingtoolbar',
									dock: 'bottom',
									cls:'newPagination',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying topics {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{
											if(!Ext.isEmpty(params) && !isPagingHidden)
											{
												Ext.getCmp('mainGrid_'+tmpidx).activePage = params.currentPage;
											}
											else
												Ext.getCmp('mainGrid_'+tmpidx).activePage=1;
										}
									}
								}]
							}]
						});
						resultObj.add(dataArray);
						resultObj.show();
					}
				}
			}
		}
		else
		{
			Ext.getCmp("panelinsidetoggle").hide();
			this.disableTools();
			this.getNomeasurepanel().show();
		}
	},
	loadData:function(){
		var me=this;
		var resultObj=Ext.getCmp('resultContainer');
		this.hideResults();
		resultObj.removeAll();
		if(appConstants.publicJsonData != undefined && appConstants.publicJsonData.Results != undefined)
		{
			var me=this;
			var activePage=1;
			var sortCol=0;
			this.enableTools();
			var gridColumn=appConstants.publicJsonData.Results.header;
			var gridData=appConstants.publicJsonData.Results.dataArray;
			var headerCombo=appConstants.publicJsonData.Results.headerCombo;
			if(gridColumn != undefined && gridData != undefined){
				var mainColArray=new Array();
				for (var key in gridColumn)
				{
					mainColumn = gridColumn[key];
					var tmpCol=mainColumn;
					if(headerCombo != undefined){
						tmpCol=tmpCol+'_backendName';
						tmpCol=headerCombo[tmpCol];
					}
					var colAlgn='center';
					if(tmpCol != undefined && (tmpCol == 'TRGT_HOST' || tmpCol == 'USER_NAME' || tmpCol == 'STATE' || tmpCol == 'LAST_LOGIN' || tmpCol == 'MOUNTED_TIME' || tmpCol == 'CREATED_TIME')){
						colAlgn='left';
					}
					if(tmpCol != undefined && tmpCol == 'USER_NAME'){
						sortCol=key;
					}
					mainColArray.push({
						header:mainColumn,
						sortable: true,
						align:colAlgn,
						dataIndex: mainColumn,
						doSort: function(state) 
						{
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2)
								{
									v1 = v1.get(field);
									v2 = v2.get(field);
									var tmpCol1=field;
									if(headerCombo != undefined){
										tmpCol1=tmpCol1+'_backendName';
										tmpCol1=headerCombo[tmpCol1];
									}
									if(tmpCol1 != undefined && (tmpCol1 == 'MOUNTED_TIME'|| tmpCol1 == 'CREATED_TIME'))
									{
										if( v1.indexOf(' ')>-1 && v1 != '-')
										{
											try{
												var tmp = v1;
												var dateobj=new Date(Ext.Date.parse(tmp, 'M d Y'));
												v1 = dateobj ;
											}catch(e){}
										}
										else{
											v1=0;
										}
										if(v2.indexOf(' ')>-1 && v2 != '-')
										{
											try{
												var tmp = v2;
												var dateobj=new Date(Ext.Date.parse(tmp, 'M d Y'));
												v2 = dateobj;
											}catch(e){}
										}
										else{
											v2=0;
										}
									}
									else if(!isNaN(v1) && !isNaN(v2))
									{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										if (state=='ASC')
										{
											v1= isNaN(v1) ? 999999 : v1;
											v2= isNaN(v2) ? 999999 : v2;
										}
										else
										{
											v1= isNaN(v1) ? 0 : v1;
											v2= isNaN(v2) ? 0 : v2;
										}
									}
									else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime();
										v1=new Date(v1).getTime();
									}else if((typeof v1 == 'string') && (typeof v1 == 'string')) {
										v1=v1.toLowerCase();
										v2=v2.toLowerCase();
									}
									// transform v1 and v2 here
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							if(value != undefined && value.indexOf("~!~") > -1){
								var text = value.substring( 0, value.indexOf('~!~') );
								var url = value.substring( value.indexOf('~!~') + 3 );
								value = url.substring(0, url.indexOf('#') );
								url = url.substring(url.indexOf('#')+1);
								metaData.tdAttr = 'data-qtip="' + value + '"';
								if(text != undefined && text == 'DD'){
									value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:openDDWin(\''+url+'\')">'+value+'</a></div>';
								}
							}else
								metaData.tdAttr = 'data-qtip="' + value + '"';
							return value;
						}
					});
					if(tmpCol != undefined && tmpCol == 'MOUNT_COUNT')
					{
						mainColArray[mainColArray.length-1].minWidth=70;
						mainColArray[mainColArray.length-1].flex=0.5;
					}
					if(tmpCol != undefined && tmpCol == 'STATE')
					{
						mainColArray[mainColArray.length-1].minWidth=100;
						mainColArray[mainColArray.length-1].flex=0.5;
					}
					else if(tmpCol != undefined && (tmpCol == 'TRGT_HOST' || tmpCol == 'USER_NAME' || tmpCol == 'LAST_LOGIN'|| tmpCol == 'MOUNTED_TIME'|| tmpCol == 'CREATED_TIME')){
						mainColArray[mainColArray.length-1].minWidth=120;
					}
					else if(tmpCol != undefined && tmpCol == 'HOST_DETAIL'){
						mainColArray[mainColArray.length-1].minWidth=60;
						mainColArray[mainColArray.length-1].flex=0.5;
					}
					else if(tmpCol != undefined && tmpCol == 'APP_ASSIGN'){
						mainColArray[mainColArray.length-1].minWidth=120;
						mainColArray[mainColArray.length-1].flex=0.5;
					}
					else if(tmpCol != undefined && tmpCol == 'APP_ATTACH'){
						mainColArray[mainColArray.length-1].minWidth=100;
						mainColArray[mainColArray.length-1].flex=0.5;
					}
				}
				var hasChld=false;
				var split = appConstants.publicJsonData.userSplit;
				for(var index in gridData)
				{
					var dataInfo = gridData[index];
					var subTableData = dataInfo.additioanlDatas;
					if(subTableData != undefined){
						if(!hasChld){
							hasChld=true;
						}
						var subTable='<div class="newTable" style=" padding: 10px;"><table width="100%"><thead><tr>';
						var hdrArr=subTableData.header;
						var colArr=subTableData.dataArray;
						for(var hdr in hdrArr){
							var hdrVal=hdrArr[hdr];
							subTable+='<th>'+hdrVal+'</th>';
						}
						subTable+='</tr></thead><tbody>';
						for(var ind in colArr)
						{
							subTable+='<tr>';
							var tablData=colArr[ind];
							for(var hdCol in hdrArr){
								var hdrVal=hdrArr[hdCol];
								subTable+='<td>'+tablData[hdrVal]+'</td>';
							}
							subTable+='</tr>';
						}
						subTable+='</tbody></table></div>';

						var appstackUserData = dataInfo.appstackUSer;
						if(appstackUserData != undefined)
						{
							var len = appstackUserData.length;
							/*for(var s=0;s<100;s++)
							{
								appstackUserData[len+s] = 'testuser-'+(s+1);
							}
							len = appstackUserData.length;*/
							subTable += '<div class="newTable" style="padding: 10px;"><table width="100%"><thead><tr ><th colspan="'+split+'">User</th></tr></thead><tbody style="overflow:auto;height:200px;width:100%;"><tr>';
							var rowCount = 0;
							for(var i in appstackUserData)
							{		
								rowCount = parseInt(i)+1;
								subTable += '<td>' + appstackUserData[i] + '</td>';								
								if(rowCount%split==0 && i>0)
								{
									subTable += '</tr><tr>';
								}
							}
							var remin = len%split;
							remin = split - remin;
							for(var ss=0;ss<remin;ss++)
							{
								subTable+='<td></td>';
							}
							
							subTable+='</tr></tbody></table></div>';
						}
						gridData[index]['app']=subTable;
					}
				}
				var fields=[];
				for(var key in gridData[0])
				{
					fields.push(key);
				}
				if(hasChld){
					fields.push('app');
				}
				var pluginsVal=[];
				var viewCnfgVal={};
				if(hasChld){
				pluginsVal =[{
						ptype: 'rowexpander',
						selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
						expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
						expandOnEnter : false,
						collapsible: true,
						animCollapse: false,
						rowBodyTpl: [
							 '<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',
						]
					}];
					viewCnfgVal={
						stripeRows: true,
						getRowClass: function (record, rowIndex, rowParams, store)
						{
							if (record.data.app.length>0)
							{
								return ;
							}
							else
							{
								return 'hidePlus';
							}
						}
					};
				 }
				var storeObj = Ext.create('Ext.data.Store', {
					fields: fields,
					proxy : {
							type : 'pagingmemory',
							reader : {
								type: 'json', root : 'data', totalProperty : 'total'
							},
						},
					pageSize : 10,	//gridPageSize is added in ErTracker.jsp
					sorters: { property: fields[sortCol], direction : 'ASC' },
					autoLoad : true,
					data:gridData,
				});
				var isPagingHidden;
				if (gridData.length<10)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				var activePage=1;
				var dataArray=new Array();
				dataArray.push({
					xtype:'panel',
					columnWidth : 1.0,
					ui:'newGraphPanel',
					margin:'0 0 10 0',
					needtoFixColumn:true,
					title:"AppStacks Details",
					items:[{
						xtype:'customgrid',
						store:storeObj,
						sortableColumns:false,
						ui:'newGridPanel noHoverColor headerTextWrap',
						id:'mainGrid',
						margin:'0 10 10 10',
						activePage:1,
						border:true,
						scroll:true,
						autoScroll:true,
						columns:mainColArray,
						bodyPadding:'0 0 0 0',
						plugins:pluginsVal ,
						viewConfig:viewCnfgVal,
						listeners:{
							sortchange:function(ct, column, e, t, eOpts ){
								me.gridColIndexParam=column.getIndex();
								me.gridColStateParam=column.sortState;
								this.getStore().loadPage(activePage);
							},
							render:function(obj){
								Ext.defer(function() {
									if(!Ext.isEmpty(obj.columns[sortCol]))
									{
										obj.columns[sortCol].doSort('ASC');
									}
								},100);
							}
						},
						dockedItems:[{
							xtype:'pagingtoolbar',
							dock: 'bottom',
							cls:'newPagination',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{
									if(!Ext.isEmpty(params) && !isPagingHidden)
									{
										Ext.getCmp('mainGrid').activePage = params.currentPage;
									}
									else
										Ext.getCmp('mainGrid').activePage=1;
								}
							}
						}]
					}]
				});
				resultObj.add(dataArray);
				resultObj.show();
			}
		}
		else
		{
			Ext.getCmp("panelinsidetoggle").hide();
			this.disableTools();
			this.getNomeasurepanel().show();
		}
	},
	showResult:function(obj){
		if (this.validateMainForm(true)) {
			this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true)+'&isSubmit=true');
		}
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
	},
	enableTools: function(){
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("csvTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
	},
	hideResults:function(){
		Ext.getCmp('resultContainer').hide();
		this.getNomeasurepanel().hide();
		this.disableTools();
	},
	onComponentTypeChange:function(obj){
		this.hideResults();
		this.getAjaxData(this.foregroundJspUrl,this.getQueryString(true,false,false));
		var compType=Ext.getCmp('er_compType').getValue();
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);	
		Ext.getCmp('componentpane').show();
	},
	onZoneChange:function(obj){
		this.hideResults();
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&select_farm='+Ext.getCmp('select_farm').getValue()+"&reportFor="+appConstants.reportFor;
		var compType=Ext.getCmp('er_compType').getValue();
		this.getAjaxData(this.foregroundJspUrl,params);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
		Ext.getCmp('componentpane').show();					
	},
	loadDataForReportChange:function(){
		var compType=Ext.getCmp('er_compType').getValue();
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
		Ext.getCmp('componentpane').show();
		var cmpCombo=Ext.getCmp('er_component');
		if(cmpCombo != undefined){
			var cmpVal=cmpCombo.getValue();
			if(cmpVal != undefined && cmpVal == '-1'){
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);
			}
			else{
				Ext.getCmp("favoriteTool").setDisabled(false);
				Ext.getCmp("scheduleTool").setDisabled(false);
			}
		}
	},
	getAjaxData:function(url,query){
		Ext.Ajax.request(
			{
				url : url,
				params : query,
				async:false,
				scope:this,
				success: function(response){
				appConstants.publicJsonData=Ext.decode(response.responseText);
				}
			});
	},
	getAjaxDataForSubmit:function(url,query){
		var me=this;
		Ext.Ajax.request(
		{
			url : url,
			params : query,
			scope:this,
			success: function(response){
				appConstants.publicJsonData=Ext.decode(response.responseText);
				if(appConstants.reportFor == 'userDetails'){
					me.loadDataforUserDetails();
				}
				else{
					me.loadData();
				}
				Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
			}
		});
	},
	getQueryString:function(isCompType,isOthers,isSettings){
		var queryString='';

		var er_option=Ext.getCmp('er_option').getValue();
		if (er_option=='Zone')
		{
			queryString+='&select_farm='+Ext.getCmp('select_farm').getValue();
		}
		else if (er_option=='Segment'|| er_option=='Service')
		{
			queryString+='&er_site='+Ext.getCmp('er_site').getValue();
		}
		if (isCompType)
			queryString+='&er_compType='+Ext.getCmp('er_compType').getValue()+'&er_option='+Ext.getCmp('er_option').getValue();

		if (isOthers)
		{
			if(appConstants.publicJsonData.hasOwnProperty('hiddenFields'))
			{
				var hiddenFields = appConstants.publicJsonData.hiddenFields;
				for (var hiddenField in hiddenFields)
				{
					if(this.isNewFav!=undefined && this.isNewFav)
						{
							if(hiddenField!=undefined && hiddenField=='ID')
							{
								continue;
							}
							if(hiddenField!=undefined && hiddenField=='FavoriteId')
							{
								continue;
							}
						}
					queryString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		queryString+="&er_RmDispName="+appConstants.er_RmDispName;
		queryString+="&reportFor="+appConstants.reportFor;
		if (isOthers)
		{
			var queryArray=new Array();
			queryArray=Ext.getCmp('er_component').getValue();
			for (var key in queryArray)
			{
				queryString+="&er_component="+queryArray[key];
			}
			var compType=Ext.getCmp('er_compType').getValue();
		}
		var compType=Ext.getCmp('er_compType').getValue();
		return queryString;
	},

	boxready:function(){
		registerAjaxEvents();	//this method is included in ErTracker.jsp
  		var thisController = this;
		if(!appConstants.hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		this.getMain().setTitle(appConstants.er_RmDispName);
		if(appConstants.frmFavModify!=undefined && appConstants.frmFavModify=='Yes')
		{
			return;
		}
		if(appConstants.frmSchModify!=undefined && appConstants.frmSchModify=='Yes')
		{
			return;
		}
		if (appConstants.isForceSubmit=="true"){
			if(appConstants.reportFor == 'userDetails')
				this.loadDataforUserDetails();
			else
				this.loadData();
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
		}
		else
		{
			if(appConstants.isSubmit=="true")
			{
				if(appConstants.reportFor == 'userDetails')
					this.loadDataforUserDetails();
				else
					this.loadData();
				Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
			}
		}
 	},
	loadForm:function(){
		this.loadFormFields();
        var from_schedule = appConstants.frmSchModify;
		var fromFavoriteModify = appConstants.frmFavModify;
		if (from_schedule == "Yes" || fromFavoriteModify == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var cmpCombo=Ext.getCmp('er_component');
		if(cmpCombo != undefined){
			var cmpVal=cmpCombo.getValue();
			if(cmpVal != undefined && cmpVal == '-1'){
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);
			}else{
				Ext.getCmp("favoriteTool").setDisabled(false);
				Ext.getCmp("scheduleTool").setDisabled(false);		
			}
		}
 	},
	loadFormFields:function()
	{
		this.loadComboField('er_option','analysisByCombo','','selectedAnalysisByCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('select_farm','zoneCombo','zoneLabel','zoneSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
		Ext.getCmp('componentpane').show();
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPaneId,isSetLabel)
	{
		 var component = Ext.ComponentManager.get(comboId);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
 				var rawData = parentJsonProperty.combo[comboProperty];
				component.getStore().clearFilter(true); 
 				component.getStore().loadRawData(rawData);
			 
				if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
  						component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
 				else
					component.setValue(rawData[0].valueField);
				if (isSetLabel)
				{
					 if(parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect)
							component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
 						else
							Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
					 }
				}
				if(!isMultiSelect)
				{
					if(component.isHidden())
					component.show();
				}
				else
				{
					var m=Ext.ComponentManager.get(multiSelectPaneId);
					if(m.isHidden())
					m.show();
				}
 		 }
		 else
		 {
			if(!isMultiSelect)
			{
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(!m.isHidden())
				m.hide();
			}
		 }
 	},
	loadTools : function(){
 		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
 	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		//Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	validateMainForm:function(flag){
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var report = 'VM App Volume';
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
			this.getMessageBox(report,obj.getStore().getAt(0).get('displayField'));
			return false;
		}
		obj=Ext.getCmp('er_component');
		var componentVal = obj.getValue();
		if(componentVal == '-1'){
				this.getMessageBox(report,obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		else if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1){
			var all_individual_alert = 'All Components and Individual selection cannot be selected simultaneously';
			this.getMessageBox(report,all_individual_alert);
			return false;
		}
		if(obj.getValue().length == 0){
				this.getMessageBox(report,'Please choose Components');
				return false;
		}
		

		return true;
	},	
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true));
			//this.doUpdate(true,false);
		}			
		else{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var bgreportNameObj=Ext.getCmp('bgReportName');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},
});