Ext.define('VmMeasurePopupApp.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
	erUtils:null,
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'measurepopupmainform',
            ref: 'measurepopupmainform'
        }, {
            selector: 'timeline',
            ref: 'timeline'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        }
    ],
    init: function () {
        this.control({
            'main': {
                'afterrender': this.defaultLoad
            },
            'vmtimeline combo[name="timeLineCombo"]': {
                //'select': this.changeTimelineCombo
            },
            'measurepopupmainform button[id="submit"]': {
                'click': this.formSubmit
            },
            'main newUtilities': {
                'afterrender': this.hideTools
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveFile
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #printTool > button': {
                'click': this.print
            },
            'popupprint': {
                'afterrender': this.printPageRender
            },
            'newUtilities > #diagnosisTool > button': {
                'click': this.showDD
            },
            'newUtilities > #dataTool > button': {
                'click': this.showData
            },
			'vmtimeline combo[name="graphMode"]': //graphMode
            {
                 'select': this.changeEr_mode 
            },
            'measurepopupmainform combo[name="filterSelectBox"]': {
                'select': this.changeFilterOption
            }
        });
    },
    showData: function () {
        var windowPrintFile = Ext.widget('popupprint',{
		//title:'reporter data'
		frame:false,
		//border:false,
		header:false
		});
        
        windowPrintFile.show();
		//windowPrintFile.getHeader().hide();
        var measurePopupForm = this.getMeasurepopupmainform().getForm();
        var s_qryString = dataDrillDownPageUrl;
	s_qryString+= '&er_RmDispName='+appConstants.er_RmDispName;

		var printContentDiv = Ext.get('popupPrintContentDiv');
		printContentDiv.set({
			src: s_qryString
		});
},
    changeEr_mode: function (combo) {

           this.formSubmit();
      },
    showDD: function () {
    var windowPrintFile = Ext.widget('popupprint');
  
    windowPrintFile.show();
    var measurePopupForm = this.getMeasurepopupmainform().getForm();
    var s_qryString = ddPageDrillDownPageUrl;
    var printContentDiv = Ext.get('popupPrintContentDiv');
    printContentDiv.set({
        src: s_qryString
    });
},
    sendMail: function () {
    drillDownParams = '&keyPrefix=enlarged&DrillDown=yes';
	if ( appConstants.fromGuest == 'yes')
	{
		drillDownParams+='&vmGuestStatus=Yes&';
	}
    var windowMail = Ext.widget('sendmail');
    windowMail.show();
},
    saveFile: function () {
    var measurePopupForm = this.getMeasurepopupmainform().getForm();
    var s_qryString = pdfDrillDownPageUrl; 
	s_qryString=s_qryString+'&charttype=easychart';
	var islegendEnabled = false;
	if(Ext.getCmp('showLegend')!=undefined){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
	if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
		var setLegendVal = "&showLegend="+islegendEnabled;
		if(s_qryString.indexOf(setLegendVal)==-1){
			if(s_qryString.indexOf("&showLegend=")>-1){
				if(islegendEnabled.toString() =='true'){
					s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
				}else{
				s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
			}
		  }else
			s_qryString+=setLegendVal;
		}
	  }
	}
     this.erUtils.savePDF(s_qryString);
},
    hideTools: function () {
    this.getNewUtilities().loadIcon(
        true, //save
    true, //print
    true, //mail
    true, //data
    false, //cvs
    false, // fav
    false, // schedule
    true, //daignosis
    false, //togglebutton
    false //close
    );
	var disableMail = true;
	if ( appConstants.fromGuest == 'yes' )
	{
		disableMail = false;
	}

    Ext.getCmp("saveTool").setDisabled(false);
    Ext.getCmp("printTool").setDisabled(false);
    Ext.getCmp("mailTool").setDisabled(false);
    Ext.getCmp("dataTool").setDisabled(false);
    Ext.getCmp("diagnosisTool").setDisabled(false);

},
    printPageRender: function () {
    var measurePopupForm = this.getMeasurepopupmainform().getForm();
    var s_qryString =  printPageUrl;
	var islegendEnabled = false;
	if(Ext.getCmp('showLegend')!=undefined){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
	if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
		var setLegendVal = "&showLegend="+islegendEnabled;
		if(s_qryString.indexOf(setLegendVal)==-1){
			if(s_qryString.indexOf("&showLegend=")>-1){
				if(islegendEnabled.toString() =='true'){
					s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
				}else{
				s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
			}
		  }else
			s_qryString+=setLegendVal;
		}
	  }
	}
		var printContentDiv = Ext.get('popupPrintContentDiv');
		printContentDiv.set({
			src: s_qryString
		});
	},
    print: function () {
		var windowPrintFile =  Ext.widget('popupprint',{
		title:'PRINT PREVIEW',
		frame:false,
		//border:false,
		//header:false
		});
		windowPrintFile.show();
	},
	validateForm: function () {
    
	var measurePopupForm = this.getMeasurepopupmainform().getForm();

    var filterSelectBox = measurePopupForm.findField('filterSelectBox');

    if (!Ext.isEmpty(filterSelectBox)) {
        var selectedFilterOption = filterSelectBox.getValue();

        if (!Ext.isEmpty(selectedFilterOption) && selectedFilterOption == "Range") {
            var fromRange = measurePopupForm.findField('fromRange').getValue();
            var toRange = measurePopupForm.findField('toRange').getValue();

            if (!checknumber("", fromRange) || !checknumber("", toRange)) {
                alert(inValidMinOrMaxRangeMsg);
                return;
            }
            var min = parseFloat(fromRange);
            var max = parseFloat(toRange);
            if (min > max) {
                alert(inValidMaxRangeMsg);
                return;
            } else if ((min < d_min && max < d_min) || (min > d_max && max > d_max)) {
                alert(inValidRangeMsg);
                return;
            }

        }
    }

    var stDate = measurePopupForm.findField('startdate').getValue();
    var enDate = measurePopupForm.findField('enddate').getValue();
    stDate.setHours(measurePopupForm.findField('startHour').getValue());
    enDate.setHours(measurePopupForm.findField('endHour').getValue());

    var er_timeline = measurePopupForm.findField('timeLineCombo').getValue();
    if (Ext.isEmpty(er_timeline)) {
        er_timeline = '1 day';
    }

    if (er_timeline != null && er_timeline == "Any") {
        if (!checkDateTime(stDate, enDate)) {
            return;
        }
    }

    var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
    var maxDaysInMonth = "";
    if (!Ext.isEmpty(getMaxDaysInMonth)) {
        maxDaysInMonth = getMaxDaysInMonth;
    }
    var er_usertimeline = "";
    var er_usertimelineObj = appConstants.publicJsonData['hiddenParams']['er_usertimeline'];
    if (!Ext.isEmpty(er_usertimelineObj)) {
        er_usertimeline = er_usertimelineObj;
    }

    if (er_usertimeline != null && er_usertimeline != "-1") {
        if (!isUserTimelineLimitExceeded(er_usertimeline, maxDaysInMonth, stDate, enDate)) {
            return false;
        }
    }

    return true;
},
formSubmit: function () {

    if (!this.validateForm())
        return;
	var meController = this;
    var measurePopupForm = this.getMeasurepopupmainform().getForm();
    var startdateObj = measurePopupForm.findField('startdate');
    var enddateObj = measurePopupForm.findField('enddate');
    var startHourObj = measurePopupForm.findField('startHour');
    var endHourObj = measurePopupForm.findField('endHour');
    var timeLineComboObj = measurePopupForm.findField('timeLineCombo');
    var graphModeObj = measurePopupForm.findField('graphMode');

    var er_timeline = timeLineComboObj.getValue();
    var graphMode = graphModeObj.getValue();

    var paramsForSubmit = 'er_timeline=' + er_timeline + '&startdate='+startdateObj.dataArray+'&enddate='+enddateObj.dataArray+'&starthr='+startHourObj.dataArray+'&endhr='+endHourObj.dataArray+'&er_stdate=' + startdateObj.dataArray + '&er_enddate=' + enddateObj.dataArray + '&er_sthr=' + startHourObj.dataArray + '&er_endhr=' + endHourObj.dataArray + '&er_mode=' + graphMode+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;

	var hiddenQstr = '';
	for( var hid in hiddenFieldQStr)
	{
		hiddenQstr +='&'+hid+'='+encodeURIComponent(hiddenFieldQStr[hid]);
	}
	if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
	{
		paramsForSubmit = paramsForSubmit+hiddenQstr;
	}
   

    var filterSelectBox = measurePopupForm.findField('filterSelectBox');

    if (!Ext.isEmpty(filterSelectBox)) {
        var selectedFilterOption = filterSelectBox.getValue();

		if(selectedFilterOption!=null && selectedFilterOption!="null")
		{		
	        paramsForSubmit = paramsForSubmit + '&er_filter=' + selectedFilterOption;
		}

        if (!Ext.isEmpty(selectedFilterOption) && selectedFilterOption == "Range") {
            var fromRange = measurePopupForm.findField('fromRange').getValue();
            var toRange = measurePopupForm.findField('toRange').getValue();

            if (!Ext.isEmpty(fromRange)) {
                paramsForSubmit = paramsForSubmit + '&er_priority=&d_min=' + fromRange;
            }

            if (!Ext.isEmpty(toRange)) {
                paramsForSubmit = paramsForSubmit + '&er_priority=&d_max=' + toRange;
            }

        } else if (!Ext.isEmpty(selectedFilterOption) && selectedFilterOption == "DescriptorPriority") {
            var descriptorFilterSelectBox = measurePopupForm.findField('descriptorPrioritySelectBox');

            if (!Ext.isEmpty(descriptorFilterSelectBox)) {
                var descriptorFilterValue = descriptorFilterSelectBox.getValue();
                paramsForSubmit = paramsForSubmit + '&er_priority=' + descriptorFilterValue;
            }
        }
    }
 	paramsForSubmit+= '&er_RmDispName='+appConstants.er_RmDispName;
	if(Ext.getCmp('showLegend')!=null)
		paramsForSubmit=paramsForSubmit+'&showLegend='+Ext.getCmp('showLegend').getValue(); 
    initLoadMask.show();
	var defaultUrl = '/final/reporter/ErVmMeasureGraphJson.jsp';
	if ( appConstants.fromGuest == 'yes' )
	{
		defaultUrl = '/final/reporter/ErVmGuestStatusMeasureJSON.jsp';
	}else if (appConstants.fromGuest == 'dataStore' )
	{
		defaultUrl = '/final/reporter/ErVMDatastoredrilldownJSON.jsp?fromGuest=dataStore';
	}
    Ext.Ajax.request({
        url: defaultUrl,
		method: 'POST',
        params: paramsForSubmit + '&screenWidth=' + Ext.getBody().getViewSize().width+"&screenHeight="+(Ext.getBody().getViewSize().height),
        scope: this,
        success: function (response) {
            var jsonText = response.responseText;
			if(!Ext.isEmpty(jsonText))
			{
	            var jsonData = Ext.decode(jsonText);
	
				meController.loadPopupContent(jsonData);
	
				jsonData = null;
				delete jsonData;  
			}
			initLoadMask.hide();
        }
    });
},
    changeFilterOption: function (combo) {
    var measurePopupForm = this.getMeasurepopupmainform().getForm();
    var selectedFilterOption = combo.getValue();

    if (selectedFilterOption == "Range") {
        var fromRangeObj = measurePopupForm.findField('fromRange');
        var toRangeObj = measurePopupForm.findField('toRange');

        fromRangeObj.setDisabled(false);
        toRangeObj.setDisabled(false);

        var descriptorFilterSelectBox = measurePopupForm.findField('descriptorPrioritySelectBox');
        descriptorFilterSelectBox.setDisabled(true);

    } else {
        var fromRangeObj = measurePopupForm.findField('fromRange');
        var toRangeObj = measurePopupForm.findField('toRange');

        fromRangeObj.setDisabled(true);
        toRangeObj.setDisabled(true);

        var descriptorFilterSelectBox = measurePopupForm.findField('descriptorPrioritySelectBox');
        descriptorFilterSelectBox.setDisabled(false);

    }
},
defaultLoad: function () {
	if (appConstants.fromGuest == 'dataStore' ){
		Ext.getCmp("diagnosisTool").hide();
		Ext.getCmp("mailTool").hide();
		Ext.getCmp("graphMode").hide();
	} 
	if(appConstants.publicJsonData.hiddenParams.er_trenddata=='Yes')
	{
		isTrend=true;
	}
	else
	{
		isTrend=false;
	}
	if(Ext.getCmp('showLegend') != undefined){
		if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			Ext.getCmp('showLegend').setValue(true);
	}
	this.loadPopupContent(appConstants.publicJsonData);
},
loadPopupContent : function(jsonData)
{
 	  if (!Ext.isEmpty(jsonData)) {
        var mainForm = this.getMeasurepopupmainform();
        var measurePopupForm = mainForm.getForm();
        if (!Ext.isEmpty(measurePopupForm)) {

			var mainPageTitle = jsonData['pageParams']['mainPageTitle'];
			var mainGraphTitle = jsonData['pageParams']['mainGraphTitle'];
			this.getMain().setTitle(mainPageTitle);
			appConstants.chartType=jsonData['hiddenParams']['chartType'];
            var displayType = jsonData.pageParams['displayType'];
			if (Ext.isEmpty(appConstants.chartType))
				appConstants.chartType=jsonData['chartType']
			if(displayType!=null && displayType=='Graph')
			{

				var showFilterOption = jsonData.pageParams['showFilter'];
				//alert(showFilterOption);

				if (showFilterOption != null && showFilterOption == "Yes") {
					var filterSelectBox = measurePopupForm.findField('filterSelectBox');
					filterSelectBox.show();
					var filterOptionsArr = jsonData['filterOptionsArr'];
					filterSelectBox.getStore().loadRawData(filterOptionsArr);
					var filterByLbl = jsonData.screenLabels['admin.filter.Filter by'];
					filterSelectBox.setFieldLabel(filterByLbl);
					var selectedFilterOption = jsonData.pageParams['selectedFilterOption'];
					if (!Ext.isEmpty(selectedFilterOption)) {
						filterSelectBox.setValue(selectedDescriptorPriorityOption);
					}

					var fromRangeObj = measurePopupForm.findField('fromRange');
					var toRangeObj = measurePopupForm.findField('toRange');
					fromRangeObj.show();
					toRangeObj.show()

					var minRange = jsonData.pageParams['minRange'];
					var maxRange = jsonData.pageParams['maxRange'];

					d_min = jsonData.pageParams['minRange'];
					d_max = jsonData.pageParams['maxRange'];

					if (!Ext.isEmpty(d_min) && Ext.isEmpty(minRange))
						minRange = d_min;

					if (!Ext.isEmpty(d_max) && Ext.isEmpty(maxRange))
						maxRange = d_max;

					fromRangeObj.setValue(minRange);
					toRangeObj.setValue(maxRange);


					if (!Ext.isEmpty(selectedFilterOption)) {
						var rangeLbl = jsonData.screenLabels['reporter.common.Range'];
						var rangeLblObj = Ext.getCmp('rangeLbl');

						if (!Ext.isEmpty(rangeLblObj)) {
							rangeLblObj.show();
							rangeLblObj.setText(rangeLbl);
						}


						filterSelectBox.setValue(selectedFilterOption);
						if (selectedFilterOption == "Range") {
							fromRangeObj.setDisabled(false);
							toRangeObj.setDisabled(false);

						} else {
							fromRangeObj.setDisabled(true);
							toRangeObj.setDisabled(true);

							var descriptorFilterSelectBox = measurePopupForm.findField('descriptorPrioritySelectBox');
							descriptorFilterSelectBox.setDisabled(false);
							descriptorFilterSelectBox.show();
							var descLbl = jsonData.screenLabels['reporter.common.Descriptor'];
							descriptorFilterSelectBox.setFieldLabel(descLbl);
							var descriptorPriorityFilterOptions = jsonData['priorityOptsJson'];
							descriptorFilterSelectBox.getStore().loadRawData(descriptorPriorityFilterOptions);

							var selectedDescriptorPriorityOption = jsonData.pageParams['selectedPriority'];
							if (!Ext.isEmpty(selectedDescriptorPriorityOption)) {
								if (selectedDescriptorPriorityOption != "-") {
									descriptorFilterSelectBox.setValue(selectedDescriptorPriorityOption);
								}
							}
						}
					}
				}
			 if (appConstants.fromGuest == 'dataStore' ){
				var er_compTypeValue = measurePopupForm.findField('er_compType');
				er_compTypeValue.setDisabled(false);
				er_compTypeValue.setValue(appConstants.publicJsonData['pageParams']['er_comptype']);
				er_compTypeValue.show();
				var er_compNameValue = measurePopupForm.findField('er_compName');
				er_compNameValue.setDisabled(false);
				er_compNameValue.setValue(appConstants.publicJsonData['hiddenParams']['er_host']);
				er_compNameValue.show();
				var er_clusterValue = measurePopupForm.findField('er_cluster');
				er_clusterValue.setDisabled(false);
				er_clusterValue.setValue(appConstants.publicJsonData['hiddenParams']['er_cluster']);
				er_clusterValue.show();
				var er_vMachinesValue = measurePopupForm.findField('er_vMachines');
				er_vMachinesValue.setDisabled(false);
				er_vMachinesValue.setValue(appConstants.publicJsonData['pageParams']['sel_Vm']);
				er_vMachinesValue.show();
				 }
				var selectionDetailsjson = jsonData['selectionDetails'];
				if(!Ext.isEmpty(selectionDetailsjson))
				{
					var selectionDetailsObj = Ext.getCmp('selectionContainer');
					selectionDetailsObj.removeAll();

					var fieldContainerArray=new Array();

					for (var labelName in selectionDetailsjson){
						var htmlstr=selectionDetailsjson[labelName];
							//var fieldAdd = {xtype:'container', margin:'0 20 5 0',layout:'column',frame: false,border:false,items:[{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:labelName},{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:'-'},{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:'<b>'+htmlstr+'</b>'}]};
							var fieldAdd = {
								xtype:'container', 
								margin:'0 20 0 0',
								layout:'column',
								frame: false,
								border:false,
								items:[
								{
									xtype:'container',
									margin:'0 5 5 0',
									frame:false,
									border:false,
									html:'<span class="formSelectionName">'+labelName+'</span> - <span class="formSelectionValue">'+htmlstr+'</span>'
								}]
							};

						fieldContainerArray.push(fieldAdd);
					}
					selectionDetailsObj.removeAll();
					selectionDetailsObj.add(fieldContainerArray);
					selectionDetailsObj.show();
				}
				
				var timelineJSONArray = jsonData['timelineComboArray'];
				var timelineSelectBox = measurePopupForm.findField('timeLineCombo');
				timelineSelectBox.getStore().loadRawData(timelineJSONArray);
				timelineSelectBox.setFieldLabel(timelineMapping);

				var er_timeline = jsonData.pageParams['selectedTimeline'];

				if (!Ext.isEmpty(er_timeline)) {
					timelineSelectBox.setValue(er_timeline);
				}

				var startdateObj = measurePopupForm.findField('startdate');
				startdateObj.setFieldLabel(fromLabelMapping);
				var selectedStDate = jsonData.pageParams['startDateJSON'];
				if (!Ext.isEmpty(selectedStDate)) {
					startdateObj.setValue(selectedStDate);
					startdateObj.dataArray=jsonData.pageParams.startDateJSON;
				}

				var enddateObj = measurePopupForm.findField('enddate');
				enddateObj.setFieldLabel(toLblMapping);
				var selectedEndDate = jsonData.pageParams['endDateForDisplay'];
				if (!Ext.isEmpty(selectedEndDate)) {
					enddateObj.setValue(selectedEndDate);
					enddateObj.dataArray=jsonData.pageParams.endDateJSON;
				}

				var selectedStarthour = jsonData.pageParams['startHourForDisplay'];
				var selectedEndhour = jsonData.pageParams['endHourForDisplay'];
				

				var startHourObj = measurePopupForm.findField('startHour');
				startHourObj.setValue(selectedStarthour);
				startHourObj.dataArray=jsonData.pageParams.startHourJSON;
				startHourObj.setFieldLabel(hrLblMapping);
				var endHourObj = measurePopupForm.findField('endHour');
				endHourObj.setValue(selectedEndhour);
				endHourObj.dataArray=jsonData.pageParams.endHourJSON;
				endHourObj.setFieldLabel(hrLblMapping);
 				mgr_stmin = jsonData.pageParams.startmin;
				mgr_enmin = jsonData.pageParams.endmin;
				if (Ext.isEmpty(this.erUtils))
				{
					this.erUtils = Ext.widget("erutils");
				}


				//this.erUtils.toggleGraphCombo(timelineSelectBox.getValue(),startdateObj.getValue(),enddateObj.getValue(),startHourObj.getValue(),endHourObj.getValue(),Ext.getCmp('graphMode'));

				//var submitButtonObj = Ext.getCmp("submit");
				//submitButtonObj.setText(jsonData['screenLabels']['reporter.common.SUBMIT']);

				hiddenFieldQStr = jsonData['hiddenParams'];
				printPageUrl = jsonData.pageParams['printPageUrl'];
				dataDrillDownPageUrl = jsonData.pageParams['dataPageUrl'];
				ddPageDrillDownPageUrl = jsonData.pageParams['ddPageUrl'];
				pdfDrillDownPageUrl = jsonData.pageParams['pdfUrl'];


				if ( ( ddPageDrillDownPageUrl != null && ddPageDrillDownPageUrl == "-" ) || appConstants.fromGuest == 'yes' ) {
					Ext.getCmp("diagnosisTool").setDisabled(true);
				} else {
					Ext.getCmp("diagnosisTool").setDisabled(false);
				}

				
				if (dataDrillDownPageUrl != null && dataDrillDownPageUrl == "-") {
					Ext.getCmp("dataTool").setDisabled(true);
				} else {
					Ext.getCmp("dataTool").setDisabled(false);
				}

				var imgrurl = jsonData.pageParams['graphDrillDown'];
				//var chartType = jsonData['chartType'];
				var htmlStr="";
				//	alert(jsonData.pageParams['imgUrl']);
				var submittedData = Ext.getCmp("submittedData");
				submittedData.removeAll();
				submittedData.show();

				var graphWidth = jsonData['pageParams']['graphWidth']
				var graphHeight = jsonData['pageParams']['graphHeight']
				if(appConstants.chartType == 'highchart'){
					htmlStr='<div id="highChart" style="width:95%;height:'+graphHeight+';cursor:pointer"></div>';
				}
				else
				{
					htmlStr = '<div align="center"><img src="' + imgrurl + '" width="'+graphWidth+'"  height="'+graphHeight+'" border="0" /><br><br>'
					var showLegendsAtBottom = jsonData.pageParams['showLegends'];
					if (showLegendsAtBottom != null && showLegendsAtBottom == "true") {
						var legendTableData = jsonData['legendObj'];

						htmlStr += '<table width="100%" border="0" cellspacing="0" cellpadding="0">';
						for (var valu in legendTableData) {
							//									alert(key);
							var imgUrl = legendTableData[valu];
							if (measCnt % 2 == 0) {
								htmlStr += '<tr>';
								htmlStr += '<td width="5%"align="right" id="cellbgwhite">&nbsp;<img src="' + imgUrl + '"/></td>';
								htmlStr += '<td width="45%" align="left" nowrap id="cellbgwhite"><span>&nbsp;&nbsp;' + valu + '</span></td>';
							} else if (measCnt % 2 != 0) {
								htmlStr += '<td width="5%"align="right" id="cellbgwhite">&nbsp;<img src="' + imgUrl + '"/></td>'
								htmlStr += '<td width="45%" align="left" nowrap id="cellbgwhite"><span>&nbsp;&nbsp;' + valu + '</span></td>';
								htmlStr += '</tr>';
							} else {
								htmlStr += '<td width="5%"align="right" id="cellbgwhite">&nbsp;<img src="' + imgUrl + '"/></td>';
								htmlStr += '<td width="95%" align="left" nowrap id="cellbgwhite"><span>&nbsp;&nbsp;' + valu + '</span></td>';
							}
						}
						htmlStr += '</table>';
					}

					htmlStr += '</div>';
				}
				if(appConstants.chartType == 'highchart'){
//					submittedData.add({xtype:'container',id:'chkVal',height:300});
					submittedData.add({
								xtype:'container',
								id:'chkVal_GraphPanel',
								height:350,
								html:'<div id="chkVal" style="width:98%;height:98%;"></div>'
							},
							{
								xtype:'container',
								id:'chkVal_legendPanel',
								margin:'0 0 5 0',
								height:53,
								style: {
									'overflow': 'hidden',
									'padding-right':'10px',
									'padding-bottom':'5px',
								}
							});
				}
				else{
					var addSubmittedReports = submittedData.add({
						xtype: 'panel',
						ui:'newGraphPanel',
						id: 'noMeasMsgPanel',
						title: mainGraphTitle,
						layout: 'vbox',
						width: '100%',
						//										height : '200',
						items: [{
								xtype: 'panel',
								width: '100%',
								html: htmlStr
							}
						]

					});
					submittedData.add(addSubmittedReports);
				}
				submittedData.show();
				if(appConstants.chartType == "highchart"){
//						reportHighStockChart(imgrurl+"&chartType="+appConstants.chartType,'highChart',300,900);
						reportHighStockChart(imgrurl+"&chartType="+appConstants.chartType,'chkVal',300,300);
				}
				submittedData.doLayout();
			}
			else if(displayType!=null && (displayType=='rebootData' || displayType=='vmDetails'))
			{
				var gridObj = jsonData['gridObj'];
				var gridCols = jsonData['gridCols'];
				var gridData = jsonData['gridData'];

				var gridFields = new Array();
				var mainColArray = new Array();
				for(var col in gridCols)
				{
					gridFields.push(col);
					var colName = gridCols[cols];
					mainColArray.push({
										header: colName,
										sortable:true,
										flex : 1,
										minWidth : 100,
										dataIndex: col,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											metaData.tdAttr = 'data-qtip="' + value+ '"';
											return value;
										}
										});
					
				}
				var gridpanel = Ext.widget('grid',{
										store: Ext.data.Store(
										{
											fields: gridFields,
											data:gridData
										}),
										border:false,
										layout: 'auto',
									//	title: gridTitle,
										scroll:true,
										frame: false,
										margin: '0 0 10 0',
										autoScroll:true,
										stripeRows: false,
										cls:'gridSkin',
										columns:mainColArray,
										viewConfig: {
									  forceFit: true
								 }
							});
				submittedData.add(gridpanel);
				submittedData.show();
				submittedData.doLayout();
			}
			initLoadMask.hide();
		}
    }
}
});