var stmin = '';
var enmin = '';
var mgr_stmin = '';
var mgr_enmin = '';
var isTrend = false;
Ext.define('VmMeasurePopupApp.view.TimeLine',{
	alias:'widget.vmtimeline',
	extend:'Ext.form.FieldContainer',
	requires:['utilities.DatePicker'],
	layout:'column',
	defaults:{
		labelAlign: 'top',
		margin:'0 10 0 0',
		labelSeparator:''
	},
	initComponent: function()
    { 
		this.items = this.getReporterTimelineItems();         
        this.callParent();
    },
    getReporterTimelineItems: function()
    {
        return [
        {
            xtype: 'scrollcombo',
            fieldLabel: 'TimeLine',
            id: 'timeLineCombo',
            name: 'timeLineCombo',
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            store: Ext.data.Store(
            {
                fields: ['displayField', 'valueField'],
                data: []
            }),
            width: 90,
            cls: 'dropdown',
            defaultListConfig:
            {
                loadingHeight: 70,
                minWidth: 90,
                maxHeight: 300,
                shadow: 'sides'
            },
            listeners:
            {
                'boxready': function(obj)
                {
                    var stDateObj = Ext.getCmp('startdate');
                    var enDateObj = Ext.getCmp('enddate');
                    var stHourObj = Ext.getCmp('startHour');
                    var enHourObj = Ext.getCmp('endHour');
                    var erModeObj = Ext.getCmp('graphMode');

                    if (obj.getValue() == 'Any')
                    {
                        stDateObj.setDisabled(false);
                        enDateObj.setDisabled(false);
                        stHourObj.setDisabled(false);
                        enHourObj.setDisabled(false);
                    }
                    else
                    {
                        stDateObj.setDisabled(true);
                        enDateObj.setDisabled(true);
                        stHourObj.setDisabled(true);
                        enHourObj.setDisabled(true);

                    }
                    erModeObj.hide();
                },
                'select': function(obj)
                {

                    var stDateObj = Ext.getCmp('startdate');
                    var enDateObj = Ext.getCmp('enddate');
                    var stHourObj = Ext.getCmp('startHour');
                    var enHourObj = Ext.getCmp('endHour');
                    var erModeObj = Ext.getCmp('graphMode');
                    if (obj.getValue() == 'Any')
                    {
                        stDateObj.setDisabled(false);
                        enDateObj.setDisabled(false);
                        stHourObj.setDisabled(false);
                        enHourObj.setDisabled(false);
                    }
                    else
                    {
                        stDateObj.setDisabled(true);
                        enDateObj.setDisabled(true);
                        stHourObj.setDisabled(true);
                        enHourObj.setDisabled(true);
					}
					{
                        var timeline = obj.getValue();
                        var strtdt = stDateObj.getValue();
                        var enddt = enDateObj.getValue();
                        var strthour = stHourObj.getValue();
                        var endhr = enHourObj.getValue();

                        strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
                        enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
                        var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]";
                        if (isTrend == true)
                        {
                            param += "&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTrendTime";
                        }
                        else
                        {
                            param += "&P5=[" + dateFormatForTimeline + "]&F=getTime";
                        }
                        Ext.Ajax.request(
                        {
                            url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
                            params: param,
                            scope: this,
                            method: 'POST',
                            success: function(response)
                            {
                                var jsontext = response.responseText;
                                var jsonData = Ext.decode(jsontext);
                                if (!Ext.isEmpty(jsonData))
                                {
                                    var timedata = jsonData.timeline;
                                    stDateObj.dataArray = timedata[0];
                                    enDateObj.dataArray = timedata[1];
                                    stHourObj.dataArray = timedata[2];
                                    enHourObj.dataArray = timedata[3];
                                    mgr_stmin = timedata[4];
                                    mgr_enmin = timedata[5];
                                    stDateObj.setValue(timedata[6]);
                                    enDateObj.setValue(timedata[7]);
                                    stHourObj.setValue(timedata[8]);
                                    enHourObj.setValue(timedata[9]);
                                    stmin = timedata[10];
                                    enmin = timedata[11];
                                    /*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
										{					
											this.up('fieldcontainer').erUtils.toggleGraphCombo(obj.getValue(),stDateObj.getValue(),enDateObj.getValue(),stHourObj.getValue(),enHourObj.getValue(),erModeObj);
										}*/
                                }
                            }
                        });
                    }
                }
            }
        },
        {
            xtype: 'datepicker',
            id: 'startdate',
            name: 'startdate',
            format: mgrDateFormat,
            fieldLabel: fromLbl,
            cls: 'datepicker',
            disabled: true,
            dataArray: null,
            listeners:
            {
                'select': function(obj)
                {

                    var timeline = Ext.getCmp("timeLineCombo").getValue();
                    var strtdt = Ext.getCmp("startdate").getValue();
                    var enddt = Ext.getCmp("enddate").getValue();
                    var strthour = Ext.getCmp("startHour").getValue();
                    var endhr = Ext.getCmp("endHour").getValue();
                    var erModeObj = Ext.getCmp('graphMode');

                    /*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
						{					
							this.up('fieldcontainer').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
						}*/

                    if (timeline == "Any")
                    {
                        strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
                        enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
                    }
                    else
                    {
                        strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
                        enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
                    }

                    var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTime";

                    Ext.Ajax.request(
                    {
                        url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
                        params: param,
                        scope: this,
                        method: 'POST',
                        success: function(response)
                        {
                            var jsontext = response.responseText;
                            var jsonData = Ext.decode(jsontext);
                            if (!Ext.isEmpty(jsonData))
                            {

                                var timedata = jsonData.timeline;

                                Ext.getCmp("startdate").dataArray = timedata[0];
                                Ext.getCmp("enddate").setValue(timedata[7]);
                                Ext.getCmp("startdate").setValue(timedata[6]);
                                Ext.getCmp("enddate").dataArray = timedata[1];
                                if (!isTrend)
                                {
                                    Ext.getCmp("startHour").setValue(timedata[8]);
                                    Ext.getCmp("startHour").dataArray = timedata[2];
                                    Ext.getCmp("endHour").setValue(timedata[9]);
                                    Ext.getCmp("endHour").dataArray = timedata[3];
                                    stmin = timedata[10];
                                    enmin = timedata[11];
                                    mgr_stmin = timedata[4];
                                    mgr_enmin = timedata[5];
                                }
                            }
                        }
                    });
                }
            }
        },
        {
            xtype: 'scrollcombo',
            width: 50,
            id: 'startHour',
            name: 'startHour',
            defaultListConfig:
            {
                loadingHeight: 70,
                minWidth: 50,
                maxHeight: 300,
                shadow: 'sides'
            },
            store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            fieldLabel: hrLbl,
            cls: 'dropdown',
            disabled: true,
            dataArray: null,
            listeners:
            {
                'select': function(combo)
                {
                    formated_sdate = Ext.Date.dateFormat(Ext.getCmp("startdate").getValue(), mgrDateFormat);
                    if (mgr_stmin == null || mgr_stmin == "undefined" || mgr_stmin == '')
                        mgr_stmin = "00"
                    var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";

                    var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                    Ext.Ajax.request(
                    {
                        url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                        params: param,
                        scope: this,
                        method: 'POST',
                        success: function(response)
                        {
                            var responseText = response.responseText;
                            responseText = Ext.String.trim(responseText);
                            var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                            var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);

                            Ext.getCmp("startdate").dataArray = dt;
                            Ext.getCmp("startHour").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_stmin = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
                        }
                    });
                }
            }
        },
        {
            xtype: 'datepicker',
            id: 'enddate',
            name: 'enddate',
            format: mgrDateFormat,
            fieldLabel: Tolbl,
            cls: 'datepicker',
            //width: 115,
            disabled: true,
            dataArray: null,
            listeners:
            {
                'select': function(obj)
                {
                    var timeline = Ext.getCmp("timeLineCombo").getValue();
                    var strtdt = Ext.getCmp("startdate").getValue();
                    var enddt = Ext.getCmp("enddate").getValue();
                    var strthour = Ext.getCmp("startHour").getValue();
                    var endhr = Ext.getCmp("endHour").getValue();
                    var erModeObj = Ext.getCmp('graphMode');

                    /*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
						{					
							this.up('fieldcontainer').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
						}*/
                    if (timeline == "Any")
                    {
                        strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
                        enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
                    }
                    else
                    {
                        strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
                        enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
                    }
                    var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTime";

                    Ext.Ajax.request(
                    {
                        url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
                        params: param,
                        scope: this,
                        method: 'POST',
                        success: function(response)
                        {
                            var jsontext = response.responseText;
                            var jsonData = Ext.decode(jsontext);
                            if (!Ext.isEmpty(jsonData))
                            {
                                var timedata = jsonData.timeline;
                                Ext.getCmp("startdate").setValue(timedata[6]);
                                Ext.getCmp("startdate").dataArray = timedata[0];
                                Ext.getCmp("enddate").setValue(timedata[7]);
                                Ext.getCmp("enddate").dataArray = timedata[1];
                                if (!isTrend)
                                {
                                    Ext.getCmp("startHour").setValue(timedata[8]);
                                    Ext.getCmp("startHour").dataArray = timedata[2];
                                    Ext.getCmp("endHour").setValue(timedata[9]);
                                    Ext.getCmp("endHour").dataArray = timedata[3];
                                    stmin = timedata[10];
                                    enmin = timedata[11];
                                    mgr_stmin = timedata[4];
                                    mgr_enmin = timedata[5];
                                }
                            }
                        }
                    });
                }
            }
        },
        {
            xtype: 'scrollcombo',
            width: 50,
            defaultListConfig:
            {
                loadingHeight: 70,
                minWidth: 50,
                maxHeight: 300,
                shadow: 'sides'
            },
            fieldLabel: hrLbl,
            cls: 'dropdown',
            id: 'endHour',
            name: 'endHour',
            store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            disabled: true,
            dataArray: null,
            listeners:
            {
                'select': function(combo)
                {
                    formated_sdate = Ext.Date.dateFormat(Ext.getCmp("enddate").getValue(), mgrDateFormat);
                    if (mgr_enmin == null || mgr_enmin == "undefined" || mgr_enmin == '')
                        mgr_enmin = "00"
                    var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
                    var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                    Ext.Ajax.request(
                    {
                        url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                        params: param,
                        scope: this,
                        method: 'POST',
                        success: function(response)
                        {
                            var responseText = response.responseText;
                            responseText = Ext.String.trim(responseText);
                            var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                            var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
                            Ext.getCmp("enddate").dataArray = dt;
                            Ext.getCmp("endHour").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_enmin = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
                        }
                    });
                }
            }
        },
        {
            xtype: 'combo',
            width: 50,
            defaultListConfig:
            {
                loadingHeight: 70,
                minWidth: 50,
                maxHeight: 300,
                shadow: 'sides'
            },
            id: 'graphMode',
            name: 'graphMode',
			hidden:true,
            fieldLabel: graphLbl,
            margin: "0 20 10 10",
            value: '2D',
            cls: 'dropdown',
            store: ['2D', '3D']
        },
		{
			xtype:'checkboxgroup',
			cls: 'checkbt',
			margin: '20 0 0 15',
			id: 'er_checkbox',
			items: [{
				boxLabel: 'Show Legends',
				inputValue: 'true',
				id: 'showLegend'
		 }]
		},
		{
			xtype: 'button',
			text: submitValue,
			//cls: 'button20',
			ui:'newButtonSmall',
			margin: '20 0 0 15',
			id: 'submit',
			name: 'submit'
		}
		]
    }
	
});

