Ext.define('vmsessionusgaeutil.controller.Main',{
	extend:'Ext.app.Controller',
 	refs:[
 		{selector:'newUtilities',ref:'newUtilities'},
 		{selector:'main',ref:'main'},
 		{selector:'nomeasurepanel',ref:'nomeasurepanel'},
 		{selector:'ReporterSettings',ref:'ReporterSettings'}
 	],
	foregroundJspUrl:'/final/reporter/ErVMSessionUsageUtilizationJson.jsp',
	foregroundControllerUrl:'../servlet/com.eg.ErVMSessionUsageUtilizationReportC',
	backgroundControllerUrl:'../servlet/com.eg.ErStartBackGroundReportC',
	isNewFav:false,
	init:function(){
		this.control({
			'main':{
				'afterrender':this.boxready
			},
			'mainform':{
 				'afterrender':this.loadForm
			},
			'newUtilities':{
				'render':this.loadTools
			},
			'vmsessionusgaeutilsettings':{
 				'afterrender':this.loadSettings
			},
			'vmsessionusageutilform combo[name="er_type"]': {
			  'select': this.onReportChange
			},
			'vmsessionusageutilform combo[name="select_farm"]': {
			  'select': this.onZoneChange
			},
			'vmsessionusgaeutilsettings combo[name="reportGeneration"]':{
				'select': this.onChangeReportGeneration
			},
			'vmsessionusgaeutilsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'vmsessionusgaeutilsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			/*'vmsessionusgaeutilsettings combo[name="er_excwe"]':{
				'select': this.onWeekendChange
			},*/
			'vmsessionusageutilform combo[name="er_compType"]':{
				'select': this.onComponentTypeChange
			},			
			'vmsessionusageutilform button[name="submit"]':{
				'click': this.showResult
			},
			'egcomponent button[id="compExpand"]':{
				'click': this.expandMe
			},
			'egcomponent multiselect[id="er_component"]':{
				'change': this.onChangeComponent
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'application button[id="appExpand"]':{
				'click': this.expandMe
			},
			'application trigger[id="appSearch"]':
			{
				'change': this.filterMultiselect
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #csvTool > button':{
					'click': this.saveCsv
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},			
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'vmsessionusageutilform button[name="save"]': {					
				'click': this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
		});
	},
	onChangeComponent: function (obj,newValue,oldValue) {
				if(oldValue==undefined || oldValue=='undefined')
				{
					return;
				}
				if(appConstants.publicJsonData.isHidenDeliveryGroups)
				{
					return;
				}
				var er_option=Ext.getCmp('er_option').getValue();
				var params='er_option='+er_option+'&er_type=No'+'&er_compType='+Ext.getCmp('er_compType').getValue(); 

				if (er_option=='Zone')
				{
					params+='&select_farm='+Ext.getCmp('select_farm').getValue();
				}
				else if (er_option=='Segment' || er_option=='Segment')
				{
					params+='&er_site='+Ext.getCmp('er_site').getValue();
				}
				var compArray=obj.getValue();
				for (var key in compArray)
				{
					params+='&er_component='+compArray[key];
				}
				params+="&er_RmDispName="+appConstants.er_RmDispName;
				var me=this;
				Ext.Ajax.request(
				{
					url : this.foregroundJspUrl,
					params : params,
					scope:this,
					success: function(response){
					appConstants.publicJsonData=Ext.decode(response.responseText);
					me.loadApplications();
					}
				});
		},
		/*onChangeComponent: function (obj,newValue,oldValue) 
		{
			var componentVal = obj.getValue();
			var all_individual_alert = 'All Components and Individual selection cannot be selected simultaneously';
			if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg:  all_individual_alert,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});				
				return;
			}
		},*/
		onSelectAnalysisBy: function (obj) {
			var er_option=obj.getValue();
			var params='er_option='+er_option+'&er_type=No'; 
			this.getAjaxData(this.foregroundJspUrl,params);
			this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
			 
			if (er_option=='Component') 
			{
				Ext.getCmp('select_farm').hide();
				Ext.getCmp('er_site').hide();
			}
			else if(er_option=='Zone')
			{
				Ext.getCmp('select_farm').show();
				Ext.getCmp('er_site').hide();
				this.loadComboField('select_farm','zoneCombo','zoneLabel','zoneSelected',appConstants.publicJsonData,false,null,true);
			}
			else 
			{
				Ext.getCmp('select_farm').hide();
				this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
			}
			this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);
				
			var appPanel = Ext.getCmp('applicationpane');
			if(appConstants.publicJsonData.isHidenDeliveryGroups)
			{
				appPanel.hide();
			}
			else
			{		
				this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);		
				appPanel.show();			
			}
			this.loadDataForReportChange();
	},
	er_siteOnChange:function(obj) {
		var er_site=obj.getValue(); 
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+Ext.getCmp('er_site').getValue()+'&er_type=No';
		this.getAjaxData(this.foregroundJspUrl,params);	
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadDataForReportChange();
	},
		//
	goTo: function (obj) {
 		if (appConstants.frmSchModify == "Yes")
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj);
	},
	saveSchedule:function(obj){
 		if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
					title: 'Session Usage',
					msg: 'Chosen timeline not allowed',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		else if(!this.validateMainForm(false))
		{
			return false;
		}
		var target="/final/reporter/ErSaveSchedule.jsp?"+this.getQueryString(true,true,true);
 		if (obj.getId()=='save')
		{
			if(target!=undefined && target.indexOf("schedule_id")==-1)
				target+='&schedule_id='+appConstants.schedule_id;
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
 	},
	saveFavorite:function(obj){
		/* if(Ext.getCmp('er_timeline').getValue() == 'Any'){
			Ext.MessageBox.show({
				title: 'Application Launch',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
 		} */
		 if(!this.validateMainForm(false))
		{
			return false;
		}
		var target="";
		
		//&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
		if (obj.getId()=='save')
		{
			this.isNewFav=false;
			target="/final/reporter/ErSaveFavorite.jsp?"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			
		if(target!=undefined && target.indexOf("FavoriteId")==-1)
			target+='&FavoriteId='+appConstants.favorite_id;
			//document.location=target+'&showWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewFav=true;
			target="../servlet/com.eg.ErFavoriteC?"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
 	},
	saveReportAsPDF:function(){
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.publicJsonData.urlFields.saveQueryString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString(true,true,true);
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){
	
 		var s_qryString = "/final/reporter/ErVMSessionUsageUtilizationPrint.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString+"&er_view=PRINT&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveCsv:function(){
		window.location=this.foregroundControllerUrl+"?optionType=CSV";		
	},
	filterMultiselect: function (obj) {
	obj.toggleTriggger();
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (obj.getId()=='compSearch')	
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicJsonData.combo.componentCombo);
		
		else if (obj.getId()=='appSearch')
		{
			
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_application'),appConstants.publicJsonData.combo.applicationCombo);
		}

		
    },
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (btn.getId()=='compExpand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
		}
		else if(btn.getId()=='appExpand')
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'),'Application',btn);



 	},
	loadReportData:function(){
		var resultContainerObj=Ext.getCmp('resultContainer');
 		var reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		this.hideResults();

			var tmpStartDate = Ext.getCmp('er_stdate').getValue();
			tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
			var tmpEndDate = Ext.getCmp('er_enddate').getValue();
			tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
			var result = checkDateTime(tmpStartDate, tmpEndDate);
			if (!result) {
				return;
			}
 		if(reportGeneration == 'foreground')
		{
			
			Ext.getCmp('panelinsidetoggle').setDisabled(false);
			resultContainerObj.removeAll();
			var isdata = appConstants.publicJsonData.isDataAvailable;
			if(isdata)
			{
				this.enableTools();
				var currentDateFormat = appConstants.publicJsonData.hiddenFields['inidate'];
				Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);

				var peakAs = appConstants.publicJsonData.peakAs;
				var chartMargin = '10 10 10 10';
				if(peakAs == 'long')
				{
					var overviewDataObj = appConstants.publicJsonData.overviewDataObj;
					
						
					
					var sessionHtml = '<table width="100%" align="center" style="padding:10px;">'
										+'<tr><td ><table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconTotalSessions"></div></td><td class="newFont_bold28">'+overviewDataObj['totalSession']+'</td></tr></table></td></tr>'
										+'<tr><td colspan="1" class="newFont_normal12" style="text-align:center;">Total Session</td></tr>'
										+'</table>';

					var peekSessionHtml = '<table width="100%" height="100%" align="center">'
										+'<tr><td colspan="1" rowspan="1" class="newFont_normal12">Peak<br>Sessions</td></tr>'				
										+'</table>';

					var avgPeakSessionHtml = '<table width="100%" align="center" style="padding:10px;">'
										+'<tr><td ><table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconTotalSessions"></div></td><td class="newFont_bold28">'+overviewDataObj['avgPeakSession']+'</td></tr></table></td></tr>'
										+'<tr><td colspan="1" class="newFont_normal12" style="text-align:center;">Avg Peak Session</td></tr>'
										+'</table>';
					
					var avgconcurrentSessionHtml =  '<table width="100%" align="center" style="padding:10px;">'
										+'<tr><td ><table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconTotalSessions"></div></td><td class="newFont_bold28">'+overviewDataObj['avgconcurrentSession']+'</td></tr></table></td></tr>'
										+'<tr><td colspan="1" class="newFont_normal12" style="text-align:center;">Avg Concurrent Session</td></tr>'
										+'</table>';


					resultContainerObj.add({
						xtype: 'panel',
						ui:'newGraphPanel',
						height:150,
						//margin:'5 10 10 10',
						margin:chartMargin,						
						layout:'column',
						title:'Overview',
						items:[
							{
								xtype:'container',																				
								columnWidth:0.5,
								height:100,	
								layout:'column',
								cls:'divBoxBg',
								margin:'0 10 10 20',							
								items:[{
									xtype:'container',
									//height:90,
									margin:'20 10 10 20',	
									columnWidth:0.5,
									html:sessionHtml
								},
								{
									xtype:'container',									
									height:90,
									columnWidth:0.5,
									layout:'column',					
									items:[{
										xtype:'container',
										columnWidth:0.55,
										margin:'0 0 0 20',
										id:'gpgraph_1',
										style:{
											border:'0px solid red',
										}
									},
									{
										xtype:'container',
										columnWidth:0.45,
										margin:'0 0 0 5',
										html:peekSessionHtml
									}]
								}],
								listeners:
								{
									'boxready':function(c)
									{
										var peekSessionChartObj=appConstants.publicJsonData['peekSessionChartObj'];
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('gpgraph_1',90,90), lineChart_1);
										lineChart_1.setData(peekSessionChartObj,'<%=currentDateFormat%>','');
										lineChart_1.drawChart();
									}
								}
							},
							{
								xtype:'panel',
								columnWidth:0.25,
								height:90,
								margin:'20 0 10 0',
								html:avgPeakSessionHtml,
							},
							{
								xtype:'panel',
								columnWidth:0.25,
								height:90,
								margin:'20 0 10 0',
								html:avgconcurrentSessionHtml,
							}
						]					
					});
					chartMargin = '5 10 10 10';
				}
				var chartData = appConstants.publicJsonData.chartDataObj;
				var legendDataObj = appConstants.publicJsonData.legendDataObj;
				var sessionLegendHtml = '<div style="display:flex;justify-content:center;"><table style="height:45px;vertical-align:middle;" ><tr><td><div style="background-color:'+legendDataObj['peakColor']+';width:6px;height:6px;border-radius:50%;"></div></td><td style="text-align:left;padding-left:5px;padding-right:10px;" class="newFont_normal11_Legend">'+legendDataObj['peakKey']+'</td><td><div style="background-color:'+legendDataObj['concurrentColor']+';width:6px;height:6px;border-radius:50%;"></div></td><td style="text-align:left;padding-left:5px;" class="newFont_normal11_Legend" >'+legendDataObj['concurrentKey']+'</td></tr></table></div>';
				resultContainerObj.add({
					xtype: 'panel',	
					ui:'newGraphPanel',					
					title:'Peak Connected Sessions vs Concurrent Connected Sessions',
					margin: chartMargin,										
					height:330,
					items:[
						{
							xtype:'container',
							height:250,
							id:'sessionChart1',		
						},
						{
							xtype:'container',							
							height:30,
							html:sessionLegendHtml,
						}
					],
				});								
				var sessionChartHtml ='<div id="sessionChart" style="height:100%;width:100%;overflowY:hidden;padding-right:20px;padding-left:20px;"></div>';
				Ext.getCmp('sessionChart1').add({
					xtype: 'panel',
					height:275,					
					html:sessionChartHtml,
					listeners:{
						'boxready':function(){
							var sessionChartObj = {};
							sessionChartObj = jQuery.extend(true, {}, getHighChartsInstance('sessionChart',100, 100), sessionChartObj);
							sessionChartObj.setData(chartData, currentDateFormat,'');
							sessionChartObj.drawChart();
						}
					}
				});

				resultContainerObj.show();
			}
			else
			{
				Ext.getCmp("panelinsidetoggle").hide();
				this.disableTools();
 				this.getNomeasurepanel().show();
			}
		}
		else if(reportGeneration == 'background')
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor;//.slice(0, -3);
 			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');

			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor//.slice(0, -3);
			
				
				backGroundPanel.update('<table border="0px" width="100%" height="100%" align="center"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');				
			}
			else
			{
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</div></td></tr></table></td></tr></table>');
				
			}
			backGroundPanel.show();
		}
				else if(reportGeneration=="background-csv")
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
				var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success')
						{
							var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
							var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
							var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
							var sub = backgroundAnchor;//.slice(0, -3);
						
							backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
						}
						else if(backgroundReportStatus== 'duplicate')
						{
							var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
							var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
							var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
							var sub = backgroundAnchor;//.slice(0, -3);
						
							backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
						}
					}
					else
					{
					
						backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</div></td></tr></table></td></tr></table>');
					}
 					backGroundPanel.show();
		}
		else
		{
			console.log('No data found for report generation in json');
		}
 	},
	loadGrid:function(JsonData){
		var me = this;
		var resultPanelObj = Ext.getCmp('resultContainer');  
		var gridColumn = JsonData.gridCol;
		var gridData = JsonData.appStackArr;
		var userViewColunmArray = new Array();
		var userDetailsFields = new Array();
		var subGridCol = JsonData.subGridCol;
		var title = JsonData.gridTitle;	
		var userDomainSelected = appConstants.publicJsonData.selectedFields.userDomainSelected;
		var userColSize = 100;
		if(userDomainSelected != undefined &&( userDomainSelected == 'Yes'))
		{
			userColSize = 230;
		}
		for(var key in gridColumn)
		{
			var align = 'left';
			var mainColumn = gridColumn[key];
			if(mainColumn != undefined && mainColumn == 'Number of appstacks assigned')
			{
				align = 'center';
			}
			userDetailsFields.push(mainColumn);
			userViewColunmArray.push({
				header: mainColumn,
				sortable: true,
				resizable :true,
				flex:1,
				//width:colWidth,
				align:align,
				dataIndex: mainColumn,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					metaData.tdAttr = 'data-qtip="' + value + '"';
					return value;
				},
				doSort: function(state) 
				{
					var ds = this.up('grid').store;
					var field = this.getSortParam();
					ds.sort({
						property: field,
						direction: state,
						sorterFn: function(v1, v2)
						{
							v1 = v1.get(field);
							v2 = v2.get(field);
							/*if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
							{
								var tmp = v1.substring(0, v1.lastIndexOf(' '));
								var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
								var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
								v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
							}
							if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
							{
								var tmp = v2.substring(0, v2.lastIndexOf(' '));
								var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
								var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
								v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
							}*/
							if(!isNaN(v1) && !isNaN(v2))
							{
								v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
								v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								if (state=='ASC')
								{
									v1= isNaN(v1) ? 999999 : v1;
									v2= isNaN(v2) ? 999999 : v2;
								}
								else
								{
									v1= isNaN(v1) ? 0 : v1;
									v2= isNaN(v2) ? 0 : v2;
								}
							}
							else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
							{
								v2=new Date(v2).getTime(); 
								v1=new Date(v1).getTime(); 
							}
							else if((typeof v1 == 'string') && (typeof v1 == 'string'))
							{
								v1=v1.toLowerCase();
								v2=v2.toLowerCase();
							}
							// transform v1 and v2 here
							return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
						}
					});
				},
			});	
		}
			
		for(var index in gridData)
		{
			var dataInfo = gridData[index];			
			var subTableHtml = '';
			if(dataInfo.subGridArray != undefined)
			{				
				var subGridData = dataInfo.subGridArray;
				subTableHtml +='<div class="newTable" style=" padding: 10px;"><table width="100%"><thead><tr>';
				for(var colIndex in subGridCol)
				{
					var column=subGridCol[colIndex];
					subTableHtml+='<th>'+column+'</th>';
				}
				subTableHtml+='</tr></thead><tbody>';
				for(var i in subGridData)
				{
					subTableHtml += '<tr>';
					for(var colIndex in subGridCol)
					{
						var column=subGridCol[colIndex];
						var data = subGridData[i][column];
						subTableHtml += '<td>'+data+'</td>';
					}
					subTableHtml += '</tr>';
					var dd = subGridData[i];					
				}
				subTableHtml += '</tbody></table></div>';
				gridData[index]['app']=subTableHtml;
			}

		}
		var gridPageSize = 15;
		var isPagingHidden=false;
		if (gridData!=undefined && gridData.length<gridPageSize)
			isPagingHidden=true;
		userDetailsFields.push('app');
		var gridDataObj=Ext.create('Ext.data.Store', {
			fields:userDetailsFields,
			proxy: {
				type: 'pagingmemory',
				reader: {
					type: 'json', root : 'data', totalProperty : 'total'
				}
			},
			data : gridData,
			pageSize:gridPageSize,
			autoLoad : true,
			sorters: { property: userDetailsFields[1], direction : 'DESC' }
		});
		var activePage=1;
		
		var dataArray=new Array();
			dataArray.push({
				xtype:'panel',
				columnWidth : 1.0,
				ui:'newGraphPanel',
				margin:'10 10 10 10',
				title:title,
				items:[{
					xtype:'customgrid',
					store:gridDataObj,
					sortableColumns:false,
					ui:'newGridPanel noHoverColor headerTextWrap',
					id:'mainGrid',
					margin:'0 10 10 10',
					activePage:1,
					border:true,
					scroll:true,
					//forceFit:true,
					autoScroll:true,
					columns:userViewColunmArray,
					bodyPadding:'0 0 0 0',
					plugins: [{
						ptype: 'rowexpander',
						selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
						expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
						expandOnEnter : false,
						collapsible: true,
						animCollapse: false,
						rowBodyTpl: [
							'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',	
						]
					}],
					viewConfig:
					{
						stripeRows: true,
						getRowClass: function (record, rowIndex, rowParams, store)
						{
							if (record.data.app.length>0)
							{
								return ;
							}
							else
							{
								return 'hidePlus';
							}
						}
					},
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							this.getStore().loadPage(activePage);
						},
						render:function(obj){
							Ext.defer(function() {
							},100);
						}
					},
					dockedItems:[{
						xtype:'pagingtoolbar',
						dock: 'bottom',
						cls:'newPagination',
						displayInfo: true,
						store: gridDataObj,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{
								if(!Ext.isEmpty(params) && !isPagingHidden)
								{
									Ext.getCmp('mainGrid').activePage = params.currentPage;
								}
								else
									Ext.getCmp('mainGrid').activePage=1;
							}
						}
					}]
				}]
			});
		resultPanelObj.add(dataArray);
		resultPanelObj.doLayout();
		resultPanelObj.show(); 
	},
	showResult:function(obj){
		var reportGeneration;
		if (isSettingsEnabled)
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
		else
			reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;

		if (reportGeneration == 'foreground' && this.validateMainForm(true)) {
			this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background-csv'&& this.validateMainForm(true)){
			this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV",this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background' && this.validateMainForm(true)){
			this.getAjaxDataForSubmit(this.backgroundControllerUrl,this.getQueryString(true,true,true));
		}
	},
	/*onWeekendChange:function(obj){
 		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(obj.getValue() == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData.labelFields.excludeDaysLabel);
		}
		else
			excludeDaysObj.hide();
	},*/
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("csvTool").setDisabled(true);
	},
	enableTools: function(){
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		//Ext.getCmp("csvTool").setDisabled(false);
	},
	hideResults:function(){
		Ext.getCmp('resultContainer').hide();
		Ext.getCmp('backGroundPanel').hide();
		this.getNomeasurepanel().hide();
	},
	onChangeReportGeneration:function(obj){
		this.hideResults();
		this.disableTools();
		//Ext.getCmp('submitViaSetting').show();
		//Ext.getCmp('moreOptionCloseId').hide();
 		if(obj.getValue()== 'background')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-csv')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			//Ext.getCmp('submitViaSetting').hide();
			//Ext.getCmp('moreOptionCloseId').show();
		}
	},
	onComponentTypeChange:function(obj){
		this.hideResults();
		this.getAjaxData(this.foregroundJspUrl,this.getQueryString(true,false,false));
		var compType=Ext.getCmp('er_compType').getValue();
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);	
		var appPanel = Ext.getCmp('applicationpane');
		if(appConstants.publicJsonData.isHidenDeliveryGroups)
		{
			appPanel.hide();
		}
		else
		{		
			this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);		
			appPanel.show();			
		}
	},
	onComponentChange:function(obj){
		var appPanel = Ext.getCmp('applicationpane');
		if(appConstants.publicJsonData.isHidenDeliveryGroups)
		{
			appPanel.hide();
		}
		else
		{		
			this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);		
			appPanel.show();			
		}
		this.disableTools();
		this.hideResults();
	},
	onZoneChange:function(obj){
		this.hideResults();
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&select_farm='+Ext.getCmp('select_farm').getValue()+'&er_type=No';

		var compType=Ext.getCmp('er_compType').getValue();
			
		this.getAjaxData(this.foregroundJspUrl,params);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		//
		var compType=Ext.getCmp('er_compType').getValue();
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);

		var appPanel = Ext.getCmp('applicationpane');
		if(appConstants.publicJsonData.isHidenDeliveryGroups)
		{
			appPanel.hide();
		}
		else
		{		
			this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);		
			appPanel.show();			
		}

					
		//
	},
	loadDataForReportChange:function(){
		var compType=Ext.getCmp('er_compType').getValue();
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
	},
	onReportChange:function(obj){
		this.hideResults();
		var er_option=Ext.getCmp('er_option').getValue();
		var params='er_option='+er_option+'&er_type=No';
		if(er_option=='Zone')
		{
			params+='&select_farm='+Ext.getCmp('select_farm').getValue();
		}
		else if (er_option =='Segment'|| er_option=='Service')
		{
			params+='&er_site='+Ext.getCmp('er_site').getValue();
		}

		var compType=Ext.getCmp('er_compType').getValue();
		//this.getAjaxData(this.foregroundJspUrl,this.getQueryString(false,false,false));
		this.getAjaxData(this.foregroundJspUrl,params);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadDataForReportChange();
	},
	getAjaxData:function(url,query){
		Ext.Ajax.request(
				{
					url : url,
					params : query,
					async:false,
					scope:this,
					success: function(response){
					appConstants.publicJsonData=Ext.decode(response.responseText);
					}
				});
	},
	getAjaxDataForSubmit:function(url,query){
		var me=this;
		Ext.Ajax.request(
				{
					url : url,
					params : query,
 					scope:this,
					success: function(response){
  						appConstants.publicJsonData=Ext.decode(response.responseText);
						me.loadReportData();
 					}
				});
	},
	getQueryString:function(isCompType,isOthers,isSettings){
		var queryString;
		var timefrom,minfrom,timeto,minto,er_excwe,reportGeneration,bg_reportname,er_top,er_groupBy;
		if (isSettingsEnabled)
		{
			timefrom=Ext.getCmp('timefrom').getValue();
			minfrom=Ext.getCmp('minfrom').getValue();
			timeto=Ext.getCmp('timeto').getValue();
			minto=Ext.getCmp('minto').getValue();
			er_excwe=Ext.getCmp('er_excwe').getValue();
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
			bg_reportname = Ext.getCmp('bgReportName').getValue();
			//er_top=Ext.getCmp('er_top').getValue();
			er_groupBy=Ext.getCmp('er_groupBy').getValue();
 		}
		else
		{
			var selectedFields=appConstants.publicJsonData.selectedFields;
			timefrom=selectedFields.selectedTimeFrom;
			minfrom=selectedFields.selectedMinsFrom;
			timeto=selectedFields.selectedTimeTo;
			minto=selectedFields.selectedMinsTo;
			er_excwe=selectedFields.excludeWeekendsSelected;			
			reportGeneration=selectedFields.reportGenerationSelected;
			bg_reportname=selectedFields.reportNameSelected;
			//er_top=selectedFields.showSelected;
			er_groupBy=selectedFields.groupBySelected;
 		}
		var er_option=Ext.getCmp('er_option').getValue();
		queryString='er_type=No';
		if (er_option=='Zone')
		{
			queryString+='&select_farm='+Ext.getCmp('select_farm').getValue();
		}
		else if (er_option=='Segment'|| er_option=='Service')
		{
			queryString+='&er_site='+Ext.getCmp('er_site').getValue();
		}
		if (isCompType)
			queryString+='&er_compType='+Ext.getCmp('er_compType').getValue()+'&er_option='+Ext.getCmp('er_option').getValue();

		if (isSettings)
		{
 			//var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
			//var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
			var startDateConverted = Ext.getCmp('er_stdate').dataArray;
			var endDateConverted = Ext.getCmp('er_enddate').dataArray;
			var stHr=Ext.getCmp('er_sthr').dataArray;
		
			queryString+= "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
			
			queryString+="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;

			queryString+="&er_excwe="+er_excwe;
			
 			if (reportGeneration == 'foreground') 
			{
 				queryString+="&er_reportgenration="+reportGeneration+"&isSubmit=true&responseType=json";
			} else
			{
				bg_reportname=checkFileName(bg_reportname);
				queryString+="&er_reportgenration="+reportGeneration+"&bg_reportname="+bg_reportname+"&isSubmit=true";
			}
		}
		if (isOthers)
		{
			var queryArray=new Array();
				queryArray=Ext.getCmp('er_application').getValue();
				for (var key in queryArray)
				{
					queryString+="&er_application="+encodeURIComponent(queryArray[key]);
				}


			if(appConstants.publicJsonData.hasOwnProperty('hiddenFields'))
			{
				var hiddenFields = appConstants.publicJsonData.hiddenFields;
				for (var hiddenField in hiddenFields)
				{
					if(this.isNewFav!=undefined && this.isNewFav)
						{
							if(hiddenField!=undefined && hiddenField=='ID')
							{
								continue;
							}
							if(hiddenField!=undefined && hiddenField=='FavoriteId')
							{
								continue;
							}
						}
					queryString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		queryString+="&er_RmDispName="+appConstants.er_RmDispName;
		queryString+="&chartType="+appConstants.chartType;

		if (isOthers)
		{
			var queryArray=new Array();
			queryArray=Ext.getCmp('er_component').getValue();
			for (var key in queryArray)
			{
				queryString+="&er_component="+queryArray[key];
			}
			var compType=Ext.getCmp('er_compType').getValue();
			
		}

		var compType=Ext.getCmp('er_compType').getValue();
		queryString+='&er_groupBy=User&er_detailsBasedOn=user';
		var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
		if(indexofVmComp>=0)
		{
			queryString+="&isVmComp=true";
		}
		queryString+="&peakAs="+appConstants.publicJsonData.peakAs;
		return queryString;
	},

	boxready:function(){
		registerAjaxEvents();	//this method is included in ErTracker.jsp
  		var thisController = this;
		if(!appConstants.hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		this.getMain().setTitle(appConstants.er_RmDispName);
		if(appConstants.frmFavModify!=undefined && appConstants.frmFavModify=='Yes')
		{
			return;
		}
		if(appConstants.frmSchModify!=undefined && appConstants.frmSchModify=='Yes')
		{
			return;
		}
		if (appConstants.isForceSubmit=="true"){
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
			if(appConstants.isSubmit=="true")
			{
				this.loadReportData(appConstants.publicjsonData);
			}
		}
 	},
	loadForm:function(){
		this.loadFormFields();
        var from_schedule = appConstants.frmSchModify;
		var fromFavoriteModify = appConstants.frmFavModify;
		if (from_schedule == "Yes" || fromFavoriteModify == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var date=appConstants.publicJsonData.selectedFields.startDateForDisplay;
		var component=Ext.getCmp('er_stdate');
		component.setValue(date);
		component.dataArray=date;
		date=appConstants.publicJsonData.selectedFields.endDateForDisplay;
		component=Ext.getCmp('er_enddate');
		component.setValue(date);
		component.dataArray=date;
		
		Ext.getCmp('er_sthr').setValue(appConstants.publicJsonData.selectedFields.startHourForDisplay);
		Ext.getCmp('er_endhr').setValue(appConstants.publicJsonData.selectedFields.endHourForDisplay);
		Ext.getCmp('er_sthr').dataArray=appConstants.publicJsonData.selectedFields.startHour;
		Ext.getCmp('er_endhr').dataArray=appConstants.publicJsonData.selectedFields.endHour;
	stmin = appConstants.publicJsonData.selectedFields.startMinForDisplay;
	enmin = appConstants.publicJsonData.selectedFields.endMinForDisplay;
	mgr_stmin=appConstants.publicJsonData.selectedFields.startmin;
	mgr_enmin=appConstants.publicJsonData.selectedFields.endmin;
		//
 	},
	loadFormFields:function()
	{ 		
		this.loadComboField('er_option','analysisByCombo','','selectedAnalysisByCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('select_farm','zoneCombo','zoneLabel','zoneSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		
		this.loadComboField('er_timeline','timelineCombo','','selectedTimeline',appConstants.publicJsonData,false,null,false);
		this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		var compType=Ext.getCmp('er_compType').getValue();
		
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);	
		var appPanel = Ext.getCmp('applicationpane');
		if(appConstants.publicJsonData.isHidenDeliveryGroups)
		{
			appPanel.hide();
		}
		else
		{		
			this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);		
			appPanel.show();			
		}
	},
	loadApplications:function(){
  		this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);			
	},
	loadSettings:function(){
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
		var FavoriteId =hiddenFields["FavoriteId"];
		if(!Ext.isEmpty(FavoriteId)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		//this.loadComboField('er_excwe','excludeWeekendsCombo','excludeWeekendsLabel','excludeWeekendsSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.publicJsonData,false,null,true);		
		
		var selectedFields=appConstants.publicJsonData.selectedFields;
		Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
 		Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
 		Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
 		Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
		if(selectedFields.hasOwnProperty('reportNameSelected'))
 			Ext.getCmp('bgReportName').setValue(selectedFields.reportNameSelected);
		selectedFields =null;delete selectedFields;
	},
	showConfigDropdown:function(){
		Ext.widget('configform');
		isSettingsEnabled = true;
 		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
  			thisController.validateAndCloseSettings();
 		});
 	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
  		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPaneId,isSetLabel)
	{
		 //this.hideResults();
		 //this.disableTools();
		 var component = Ext.ComponentManager.get(comboId);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
 				var rawData = parentJsonProperty.combo[comboProperty];
				component.getStore().clearFilter(true); 
 				component.getStore().loadRawData(rawData);
			 
				if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
				{
					selectedVal = parentJsonProperty.selectedFields[comboSelectedProperty]					
  					component.setValue(selectedVal);
				}  						
 				else
					component.setValue(rawData[0].valueField);
				if (isSetLabel)
				{
					 if(parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect)
							component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
 						else
							Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
					 }
				}
				if(!isMultiSelect)
				{
					if(component.isHidden())
					component.show();
				}
				else
				{
					var m=Ext.ComponentManager.get(multiSelectPaneId);
					if(m.isHidden())
					m.show();
				}
 		 }
		 else
		 {
			if(!isMultiSelect)
			{
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(!m.isHidden())
				m.hide();
			}
		 }
 	},
	loadTools : function(){
 		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
 	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		//Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	validateMainForm:function(flag){
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var report = hiddenFields.er_bgreportfrom;
		
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
				this.getMessageBox(report,obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		
		obj=Ext.getCmp('er_component');		
		if(obj.getValue()== '-1'){
				this.getMessageBox(report,obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		if(obj.getValue().length == 0){
				this.getMessageBox(report,'Please choose Components');
				return false;
		}
		//
		obj=Ext.getCmp('er_application');
		if(obj.getValue()!=undefined)
		{
			if(obj.getValue()== '-1')
			{
					this.getMessageBox(report ,obj.getStore().getAt(0).get('displayField'));
					return false;
			}
			if(obj.getValue().length == 0){
					this.getMessageBox(report,'Please choose Desktop/Application Pools');
					return false;
			}
			var componentVal = obj.getValue();
			var all_individual_alert = 'All Desktop/Application Pools and Individual selection cannot be selected simultaneously';
			if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg:  all_individual_alert,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
					return false;
			}
		}
		//
		if (reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields.limitforbg;
				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						return false;
					}
				}
			}
		}
		else{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}
		var stackUser = Ext.getCmp('stackUser').getValue();
		var stackUserArr = stackUser.split(',');
		if((stackUserArr.length>1 && stackUserArr.indexOf('*')>-1))
		{
			Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Individual and aggregate Descriptors cannot be selected simultaneously',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
				return false;
		}
		return true;
	},	
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true));
			//this.doUpdate(true,false);
		}			
		else{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if ( reportgen!=null && reportgen == 'background' ){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	}
});