Ext.define('VirtualMachinesCapacity.controller.Main', {
    extend: 'Ext.app.Controller',
    requires: ['VirtualMachinesCapacity.view.Main','Ext.ux.data.PagingMemoryProxy'],
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        },
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
    ],
    init: function () {
        this.control({
            'main newUtilities': {
                'afterrender': this.loadTools
            },
            'main': {
                'afterrender': this.loadDefaults
            },
            'virtualmachinescapacitysettings': {
                'afterrender': this.afterSettingsrender
            },
            'virtualmachinescapacitymainform combo[name="er_option"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinescapacitymainform combo[name="er_site"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinescapacitymainform combo[name="er_comptype"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinescapacitymainform combo[name="er_includezones"]': {
                'select': this.reloadWithAjax
            },
            'mainform button[name="submit"]': {
                'click': this.showResult
            },
            'mainform button[name="save"]':{
                'click': this.goTo
            },
            'virtualmachinescapacitysettings combo[name="er_timeline"]': {
                //'select': this.timeLineOnChange
            },
            'virtualmachinescapacitysettings combo[name="reportGeneration"]': {
                'select': this.reportGenChange
            },
			'virtualmachinescapacitysettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualmachinescapacitysettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
            'newUtilities > #printTool > button': {
                'click': this.printReport
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveReportAsPDF
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #csvTool > button': {
                'click': this.saveCsv
            },
            'newUtilities > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.saveSchedule
            },
            'egcomponent button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
        });
    },
		showConfigDropdown: function () {
		isSettingsEnabled = true;
        var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
        //config dropdown mode
        Ext.create('Ext.container.Container', {
            width: 573,
            //padding: 5,
            //layout:'vbox',
            id: 'configMod',
			ui:'settingsWindowContainer',
           // html: tpl.apply(),
            items: [
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'363px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'virtualmachinescapacitysettings',
					itemId: 'settingsForm',
					parent:this
				}
            ],
            renderTo: 'virtualmachinescapacity-body'
        });
		var thisController = this;
        Ext.get('closeSettings').on('click', function () {
           thisController.validateAndCloseSettings();
        });
    },
	validateAndCloseSettings : function()
	{
	    var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
        getButtonObj.setDisabled(true);
		if (isSettingsOk) 
		{
                getButtonObj.setDisabled(false);
                Ext.get('configMod').animate({
                    duration: 500,
                    to: {
                        y: -500
                    }
                });
				return true;
        }
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		//var hiddenFields =  appConstants.publicjsonData["hiddenFields"];
		var from_favorite = appConstants.publicjsonData['hiddenfields']['fromFavoriteModify'];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.saveFavorite();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveSchedule();
		}
    },filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);
    },
    expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
    },
    printReport: function () {
        var s_qryString = "/final/reporter/ErVMCapacityReportPrint.jsp?" + appConstants.publicjsonData.saveQstring + "&pdfprint=yes&er_width=450&er_height=250";
	s_qryString+="&er_RmDispName="+appConstants.er_RmDispName;

		 parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    },
    saveReportAsPDF: function () {
        var saveQString = appConstants.publicjsonData.saveQstring;
        saveQString += "&er_width=450&er_height=250";
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
       if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
    },
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicjsonData.saveQstring;
        saveQString += "&er_width=450&er_height=250";
        var s_qryString =  saveQString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var finalParams = appConstants.queryString;
		if(finalParams != null)
			bookletquery=encodeURI(finalParams);
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
    },
    sendMail: function () {
        var windowMail = Ext.widget('sendmail');
        windowMail.show();
    },
    saveCsv: function () {
        window.location = '../servlet/egurkha.reporter.SaveInCSVFormat';
    },
    saveFavorite: function () {
        var isValid = this.validateMainForm();
        /* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Capactity Correlation',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        } */
        this.updateQueryString(true);
        var finalParams = appConstants.queryString;
        if (isValid) {
		var hiddenFields =  appConstants.publicjsonData["hiddenfields"];
		var favorite_id = hiddenFields["favorite_id"];
            var s_qryString;
            s_qryString = "../servlet/com.eg.ErFavoriteC?" + encodeURI(finalParams) + "&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName;//&FavoriteId="+favorite_id;
            var target = s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showSchWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

        } else return;
    },
    saveSchedule: function () {
        var isValid = this.validateMainForm();
        if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        }
        this.updateQueryString(true);
        var finalParams = appConstants.queryString;
        if (isValid) {
            var s_qryString;
            s_qryString = "/final/reporter/ErSaveSchedule.jsp?" + encodeURI(finalParams);
            var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
 				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp




        } else return;
    },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
    showResult: function () {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);
        var isValid = this.validateMainForm();
         var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);
        if (!checkDateTime(stDate, enDate)) {
            return false;
        }
		var reportgen = appConstants.publicjsonData.reportGeneration;
		if (isSettingsEnabled)
			reportgen = Ext.getCmp('reportGeneration').getValue();
        var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
		if (reportgen != null && reportgen == 'foreground') {
            var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg'];
            if (!Ext.isEmpty(limitforbg)) {
                if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                    Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
					isValid = false;
                }
            }
        }
        if (isValid) this.submitReport();
        else return;
    },
    checkNumerical: function (value) {
        var numbers = "0123456789";
        var hasNonNumericalCharacter = "false";
        for (var i = 0; i < value.length; i++) {
            var strChar = value.charAt(i);
            if (numbers.indexOf(strChar) == -1) {
                hasNonNumericalCharacter = "true";
                break;
            }
        }
        if (hasNonNumericalCharacter == "true") {
            return false;
        } else {
            return true;
        }
    },
    validateMainForm: function () {
        var datafrom = Ext.getCmp('er_option').getValue();
        if (datafrom != 'Component') {
            var site = Ext.getCmp('er_site');
            if (site.getValue() == '-1') {
                Ext.MessageBox.show({
                    title: 'Virtualization',
                    msg: site.getRawValue(),
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        }
        var comptype = Ext.getCmp("er_comptype");
        if (comptype.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: comptype.getRawValue(),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        var component = Ext.getCmp("er_component");
        if (component.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: component.getRawValue(),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
       return true;
    },
    validateSettings: function () {
        var isSettingsOk = true;
        var reportgen = Ext.getCmp('reportGeneration').getValue();
        var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
        var underMinimum = Ext.getCmp("underMinimum").getValue();
        var underMajor = Ext.getCmp("underMajor").getValue()
        var underCritical = Ext.getCmp("underCritical").getValue()
        var upperminimum = Ext.getCmp("upperminimum").getValue()
        var uppermajor = Ext.getCmp("uppermajor").getValue()
        var upperCritical = Ext.getCmp("upperCritical").getValue();
        var validSortingData = true;
        if (!this.checkNumerical(underMinimum) && validSortingData) validSortingData = false;
        if (!this.checkNumerical(underMajor) && validSortingData) validSortingData = false;
        if (!this.checkNumerical(underCritical) && validSortingData) validSortingData = false;
        if (!this.checkNumerical(upperminimum) && validSortingData) validSortingData = false;
        if (!this.checkNumerical(uppermajor) && validSortingData) validSortingData = false;
        if (!this.checkNumerical(upperCritical) && validSortingData) validSortingData = false;
        if (!validSortingData) {
            Ext.MessageBox.show({
                title: 'Virtualization settings',
                msg: 'Please enter a valid number for Utilization limit',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isSettingsOk = false;
        }
        if (parseInt(underMinimum) < parseInt(underMajor)) {
            Ext.MessageBox.show({
                title: 'Virtualization settings',
                msg: 'Low utilization minor value must be greater than its major value',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isSettingsOk = false;
        } else if (parseInt(underMajor) < parseInt(underCritical)) {
            Ext.MessageBox.show({
                title: 'Virtualization settings',
                msg: 'Low utilization major value must be greater than its critical value',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isSettingsOk = false;
        } else if (parseInt(upperminimum) > parseInt(uppermajor)) {
            Ext.MessageBox.show({
                title: 'Virtualization settings',
                msg: 'High utilization minor value must be lesser than its major value',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isSettingsOk = false;
        } else if (parseInt(uppermajor) > parseInt(upperCritical)) {
            Ext.MessageBox.show({
                title: 'Virtualization settings',
                msg: 'High utilization major value must be lesser than its critical value',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isSettingsOk = false;
        }
        var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);
        var timefrom = Ext.getCmp('timefrom').getValue();
        var minfrom = Ext.getCmp('minfrom').getValue();
        var timeto = Ext.getCmp('timeto').getValue();
        var minto = Ext.getCmp('minto').getValue();
        if (!checkTimePeriod(timefrom, minfrom, timeto, minto)) {
            isSettingsOk = false;
        }
       // if (!checkDateTime(stDate, enDate)) {
           // isSettingsOk = false;
       // }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: 'Virtualization settings',
                    msg: userTimelineErrorMsg,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                isSettingsOk = false;
            }
        }
        if (reportgen != null && (reportgen == 'background' || reportgen == 'background-csv')) {
            var reportName = Ext.getCmp('bgReportName').getValue();
            if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)) isSettingsOk = false;
        }
        return isSettingsOk;
    },
    showConfirmResult: function (btn) {
        if (btn == "yes") {
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
        } else {
            var reportGenType = Ext.getCmp('reportGeneration');
            var bgreportNameObj = Ext.getCmp('bgReportName');
            reportGenType.setValue('background');
            bgreportNameObj.setValue("");
            bgreportNameObj.show();
            bgreportNameObj.focus(false, 1000);
        }
		this.submitReport()
    },
    submitReport: function () {
        appConstants.initLdgMask.show();
		var reportGeneration = appConstants.publicjsonData.reportGeneration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
         this.updateQueryString(true);
		var urlforAjax = ''
        var finalParams = appConstants.queryString;
        if (reportGeneration == 'foreground') {
            urlforAjax = '../servlet/com.eg.ErVMCapacityReportC';
            finalParams += "&isSubmit=true&responseType=json";
        } else if (reportGeneration == 'background') {
            urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true))
			{
				 appConstants.initLdgMask.hide();
				return;
			}
			bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
        }
		else if (reportGeneration == 'background-csv')
		{
			urlforAjax = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true))
			{
				 appConstants.initLdgMask.hide();
				return;
			}
			bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
		}
        finalParams += "&isFavorite=false&isSchedule=false";


		finalParams+="&er_RmDispName="+appConstants.er_RmDispName;

        //console.log('finalParams ------->'+finalParams);
        Ext.Ajax.request({
            url: urlforAjax,
            params: finalParams,
            method: 'POST',
            scope: this,
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
                this.loadReportData(appConstants.publicjsonData);
            }
        });
    },
    getVMGridObj: function (reportData,needPadding,index) {
		var me=this;
		var vmGridObj='';
		var l2col = reportData['SUB_COLUMN_L2'];
        var level2Present = false;
        for (var m in l2col) {
            var temp_arr = l2col[m];
            if (temp_arr.length > 0) {
                level2Present = true;
                break;
            }
        }
        if (level2Present) {
            var mainColumn = reportData.MAIN_COLUMN;
            var columnLevel1 = reportData.SUB_COLUMN_L1;
            var columnLevel2 = reportData.SUB_COLUMN_L2;
            var columnCountArr = reportData.COLUMN_COUNTS;
            var subcolumns = reportData.SUB_COLUMN
            var dataArraytoStore = reportData.DATA_ARRAY;
            var fieldstoStore = new Array();
            var columnObjToGrid = new Array();
            var columnCount = 0;
            var L1Count = 0;
            var L2Count = 0;
            for (var j in mainColumn) {
                var headerText = mainColumn[j];
                var lever1Arr = columnLevel1[j]
                if (!Ext.isEmpty(lever1Arr)) {
                    var L1ArrayForGrid = new Array();
                    for (var k in lever1Arr) {
                        var lever2Arr = columnLevel2[L1Count];
                        var l1_header_text = lever1Arr[k];
                        var L2ArrayForGrid = new Array();
                        if (!Ext.isEmpty(lever2Arr)) {
                            L2columnObj = new Array();
                            for (var n in lever2Arr) {
                                var colname = lever2Arr[n];
                                var subColumnArray = new Array();
                                var noOfColumn = columnCountArr[L2Count];
                                for (var i = 0; i < noOfColumn; i++) {
                                    fieldstoStore.push('COLUMN_' + columnCount);
                                    subColumnArray.push({
                                        header: subcolumns[columnCount],
                                        sortable: true,
                                        dataIndex: 'COLUMN_' + columnCount,
                                         //flex: 0.9,
                                       // minWidth: 100,
                                        align: 'center',
                                        renderer: function (value, metaData, record, row, col, store, gridView) {
											if (!Ext.isEmpty(value['color'])) {
                                                var color = value['color'];
												var val = value['value'];
												metaData.tdCls = appConstants.clsForColors[color];
												metaData.style="line-height:6px;padding-top:3px;padding-bottom:2px";
												value = val;
												value = '<div style="background-color:'+color+';color:#000000;height:16px;display:inline-block;padding:4px 6px 1px 6px;line-height:1em" >'+Ext.getCmp('gridId_'+index).getDecimalAlignFormat(val)+'</div>';
                                            }
											value = Ext.getCmp('gridId_'+index).getDecimalAlignFormat(value);
                                            return value;
                                        }
					
                                    });
                                    columnCount++;
                                }
                                L2ArrayForGrid.push({
                                    header: colname,
                                    sortable: true,
                                    columns: subColumnArray,
                                    //flex: 0.9
                                });
                                L2Count++;
                            }
                        } else {
                            var noOfColumn = columnCountArr[L2Count];
                            var subColumnArray = new Array();
                            for (var jk = 0; jk < noOfColumn; jk++) {
                                fieldstoStore.push('COLUMN_' + columnCount);
                                subColumnArray.push({
                                    header: subcolumns[columnCount],
                                    sortable: true,
                                    dataIndex: 'COLUMN_' + columnCount,
                                    //flex: 0.9,
                                    //minWidth: 100,
                                    align: 'center',
                                    renderer: function (value, metaData, record, row, col, store, gridView) {
 
                                        if (!Ext.isEmpty(value['color'])) {

                                            var color = value['color'];
                                            var val = value['value'];
                                            metaData.tdCls = appConstants.clsForColors[color];
											metaData.style="line-height:6px;padding-top:3px;padding-bottom:2px";
                                            value = val;
                                            value = '<div style="background-color:'+color+';color:#000000;height:16px;display:inline-block;padding:4px 6px 1px 6px;line-height:1em">'+Ext.getCmp('gridId_'+index).getDecimalAlignFormat(val)+'</div>';
                                        }
										value = Ext.getCmp('gridId_'+index).getDecimalAlignFormat(value);
                                        return value;
                                    }
                                });
                                columnCount++;
                            }
                            L2ArrayForGrid.push({
                                header: '&nbsp',
                                sortable: true,
                                columns: subColumnArray,
                               // flex: 0.9
                            });
                            L2Count++;
                        }
                        L1ArrayForGrid.push({
                            header: l1_header_text,
                            sortable: true,
                            columns: L2ArrayForGrid,
                             //flex: 0.9,
                            align: 'center'
                        });
                        L1Count++;
                    }
                    columnObjToGrid.push({
                        header: headerText,
                        sortable: true,
                        columns: L1ArrayForGrid,
                       // flex: 0.9
                    });
                } else {
                    fieldstoStore.push('COLUMN_' + columnCount);
                    columnObjToGrid.push({
                        header: headerText,
                        align: 'left',
                        dataIndex: 'COLUMN_' + columnCount,
                         //flex: 0.9,
                       // minWidth: 150
                    });
                    columnCount++;
                    L1Count++;
                    L2Count++;
                }
            }
			
			var isPagingHidden;
			if (dataArraytoStore.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var storeObj = Ext.create('Ext.data.ArrayStore', {
				fields: fieldstoStore,
				proxy : 
				{
					type : 'pagingmemory',
					reader : 
					{
						type : 'array'
					}
				},
				remoteSort:true,
				pageSize:gridPageSize,
                data: dataArraytoStore
            });
            /*var vmGridObj = Ext.widget('datagrid', {
                store: storeObj,
                sortableColumns: true,
                columns: columnObjToGrid,
                //title: gridObj.gridTitle,
                viewConfig: {
                    forceFit: true,
                },
                bodyPadding: '0 0 0 0'
            });*/
 			if(needPadding)
			{
				vmGridObj = Ext.widget('customgrid', {
					store: storeObj,
					sortableColumns: true,
					needtoFixColumn:true,
					ui:'newGridPanel',
					id:'gridId_'+index,
					margin:'0 10 10 10',
					columns: columnObjToGrid,
					viewConfig: {
						forceFit: true
					},
					border:true,
					listeners:{
						render:function(obj){
							Ext.defer(function() {
								//obj.columns[2].items.items[0].items.items[0].items.items[0].setSortState("DESC",true,true);
							},100);
						}
					},
					bodyPadding: '0 0 0 0',
					margin:'0 5 5 5',
					dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						},{
							xtype:'container',
							dock:'bottom',
							cls:'bgWithBorder',
							padding:4,
							items:me.getGridBBarContent(),
						}]
					//bbar:me.getGridBBarContent()

				});
			}
			else
			{
				vmGridObj = Ext.widget('customgrid', {
					store: storeObj,
					sortableColumns: true,
					needtoFixColumn:true,
					columns: columnObjToGrid,
					id:'gridId_'+index,
					ui:'newGridPanel',
					margin:'0 10 10 10',
					bodyPadding: '0 0 0 0',
					viewConfig: {
						forceFit: true
					},
					border:true,
					listeners:{
						render:function(obj){
							Ext.defer(function() {
								//obj.columns[2].items.items[0].items.items[0].items.items[0].setSortState("DESC",true,true);
							},100);
						}
					},
					dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						},{
							xtype:'container',
							dock:'bottom',
							cls:'bgWithBorder',
							padding:4,
							items:me.getGridBBarContent(),
						}]
					//bbar:me.getGridBBarContent()
				});
			}
            return vmGridObj;
        }
		else 
		{
            var mainColumn = reportData.MAIN_COLUMN;
            var columnLevel1 = reportData.SUB_COLUMN_L1;
            var columnCountArr = reportData.COLUMN_COUNTS;
            var subcolumns = reportData.SUB_COLUMN
            var dataArraytoStore = reportData.DATA_ARRAY;
            var fieldstoStore = new Array();
            var columnObjToGrid = new Array();
            var columnCount = 0;
            var L1Count = 0;
			var isVmCapacity=false;
            for (var j in mainColumn) {
                var headerText = mainColumn[j];
		          if (headerText.indexOf('VM') > -1) {
						isVmCapacity=true;
				  }
				var isLocked = false;
				if(j==0)
					isLocked = true;

                var lever1Arr = columnLevel1[j]
                if (!Ext.isEmpty(lever1Arr)) {
                    var L1ArrayForGrid = new Array();
                    for (var k in lever1Arr) {
						
                        var l1_header_text = lever1Arr[k];
                        var noOfColumn = columnCountArr[L1Count];
                        var subColumnArray = new Array();
                        for (var jk = 0; jk < noOfColumn; jk++) {
                            fieldstoStore.push('COLUMN_' + columnCount);
                            subColumnArray.push({
                                header: subcolumns[columnCount],
                                sortable: true,
                                dataIndex: 'COLUMN_' + columnCount,
                                flex: 0.9,
                                minWidth: 100,
                                align: 'center',
                                renderer: function (value, metaData, record, row, col, store, gridView) {
                                    if (!Ext.isEmpty(value['color'])) {
                                        var color = value['color'];
                                        var val = value['value'];
										metaData.tdCls = appConstants.clsForColors[color];
										metaData.style="line-height:6px;padding-top:3px;padding-bottom:2px";
										value = val;
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
										value = '<div style="background-color:'+color+';color:#000000;height:16px;display:inline-block;padding:4px 6px 1px 6px;line-height:1em" >'+Ext.getCmp('gridId1_'+index).getDecimalAlignFormat(val)+'</div>';
                                    }
									else
									{
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';	
										value = Ext.getCmp('gridId1_'+index).getDecimalAlignFormat(value);
									}
                                    return value;
                                }
                            });
                            columnCount++;
                        }
                        L1ArrayForGrid.push({
                            header: l1_header_text,
                            sortable: true,
                            columns: subColumnArray,
                            flex: 0.9,
                            align: 'center'
                        });
                        L1Count++;
                    }
                    columnObjToGrid.push({
                        header: headerText,
                        sortable: true,
                        columns: L1ArrayForGrid,
                        flex: 0.9,
						locked:false
                    });
                } 
				else 
				{
                    fieldstoStore.push('COLUMN_' + columnCount);
                    columnObjToGrid.push({
                        header: headerText,
                        align: 'left',
                        dataIndex: 'COLUMN_' + columnCount,
                        flex: 0.9,
                        minWidth: 150,
						locked:isLocked,// vengat
						sortable: true,
						 renderer: function (val, metaData, record, row, col, store, gridView) {
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
							val = Ext.getCmp('gridId1_'+index).getDecimalAlignFormat(val);
							return val;
						}

                    });
                    columnCount++;
                    L1Count++;
                }
            }
			var isPagingHidden;
			if (dataArraytoStore.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var activePage = 1;
            var storeObj = Ext.create('Ext.data.ArrayStore', {
				fields: fieldstoStore,
				proxy : 
				{
					type : 'pagingmemory',
					reader : 
					{
						type : 'array'
					}
				},
                data: dataArraytoStore,
				remoteSort : true,
				autoLoad : true,
				pageSize:gridPageSize,
				sorters: { property: fieldstoStore[0], direction : 'DESC' },// vengat
            });
 			if(needPadding)
			{
				if(!isVmCapacity)
				{
					vmGridObj = Ext.widget('customgrid', {
						store: storeObj,
						sortableColumns: true,
						needtoFixColumn:true,
						id:'gridId1_'+index,
						ui:'newGridPanel',
						margin:'0 10 10 10',
						columns: columnObjToGrid,
						viewConfig: {
							forceFit: true
						},
						border:true,
						listeners:{
							render:function(obj){
								Ext.defer(function() {
									//obj.columns[0].setSortState("DESC",true,true);
								},100);
							}
						},
						bodyPadding: '0 0 0 0',
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						},{
							xtype:'container',
							dock:'bottom',
							cls:'bgWithBorder',
							padding:4,
							items:me.getGridBBarContent()
						}]
						//bbar:me.getGridBBarContent()
					});
				}
				else
				{
					vmGridObj = Ext.widget('customgrid', {
						store: storeObj,
						sortableColumns: true,
						needtoFixColumn:true,
						ui:'newGridPanel',
						id:'gridId1_'+index,
						margin:'0 10 10 10',
						columns: columnObjToGrid,
						viewConfig: {
							forceFit: true
						},
						border:true,
						listeners:{
							render:function(obj){
								Ext.defer(function() {
									//obj.columns[2].items.items[0].items.items[0].setSortState("DESC",true,true);
								},100);
							}
						},
						bodyPadding: '0 0 0 0',
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						},{
							xtype:'container',
							dock:'bottom',
							cls:'bgWithBorder',
							padding:4,
							items:me.getGridBBarContent()
						}]
						//bbar:me.getGridBBarContent()
					});
				}
			}
			else
			{
				if(!isVmCapacity)
				{
					vmGridObj = Ext.widget('customgrid', {
						store: storeObj,
						sortableColumns: true,
						needtoFixColumn:true,
						id:'gridId1_'+index,
						ui:'newGridPanel',
						margin:'0 10 10 10',
						columns: columnObjToGrid,
						viewConfig: {
							forceFit: true
						},
						border:true,
						listeners:{
							render:function(obj){
								Ext.defer(function() {
									//obj.columns[0].setSortState("DESC",true,true);
								},100);
							}
						},
						bodyPadding: '0 0 0 0',
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						},{
							xtype:'container',
							dock:'bottom',
							cls:'bgWithBorder',
							padding:4,
							items:me.getGridBBarContent()
						}]
						//bbar:me.getGridBBarContent()
					});
				}
				else
				{
					vmGridObj = Ext.widget('customgrid', {
						store: storeObj,
						sortableColumns: true,
						needtoFixColumn:true,
						id:'gridId1_'+index,
						ui:'newGridPanel',
						margin:'0 10 10 10',
						columns: columnObjToGrid,
						viewConfig: {
							forceFit: true
						},
						border:true,
						listeners:{
							render:function(obj){
								Ext.defer(function() {
									//obj.columns[2].items.items[0].items.items[0].setSortState("DESC",true,true);
								},100);
							}
						},
						bodyPadding: '0 0 0 0',
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						},{
							xtype:'container',
							dock:'bottom',
							cls:'bgWithBorder',
							padding:4,
							items:me.getGridBBarContent()
						}]
						//bbar:me.getGridBBarContent()
					});
				}
			}
			
            return vmGridObj;
        }
		
    },
    getGridBBarContent: function () {
 		return [{
					xtype: 'container',
 					layout: 'hbox',
					items: [
								{
									xtype: 'fieldcontainer',
									layout: 'hbox',
									labelStyle: 'white-space: nowrap;',
									fieldLabel: 'Low Utilization Limit',
									labelAlign: 'left',
									labelSeparator:'',
									//labelSeparator: '',
									labelWidth: 120,
									width:300,
									items: [
												{
													text: 'Minor',
													xtype: 'label',
   													margin: '0 10 0 0',
  													//width: 38,
  													height: 20,
													padding:'3 4 1 4',
 													style: {'background-color': appConstants.minimumCriticalColor,'color':'#000000'}
												},
												{
													text: 'Major',
													xtype: 'label',
													margin: '0 10 0 0',
  													//width: 38,
  													height: 20,
													padding:'3 4 1 4',
													style: {'background-color': appConstants.minimumMajorColor,'color':'#000000'}
												},
												{
													text: 'Critical',
													xtype: 'label',
													margin: '0 10 0 0',
													padding:'3 4 1 4',
													//width: 45,
  													height: 20,
													style: {'background-color': appConstants.minimumMinorColor,'color':'#000000'}
												}
											]
								}, 
								{
									xtype: 'fieldcontainer',
									layout: 'hbox',
										width:300,
									fieldLabel: 'High Utilization Limit',
									labelStyle: 'white-space: nowrap;',
									labelSeparator:'',
									labelWidth: 123,
									labelAlign: 'left',
									items: [
												{
													text: 'Minor',
													xtype: 'label',
													margin: '0 10 0 0',
													//width: 38,
													padding:'3 4 1 4',
  													height: 20,
													style: {'background-color': appConstants.minorColor,'color':'#000000'}
												},
												{
													text: 'Major',
													xtype: 'label',
													margin: '0 10 0 0',
													//width: 38,
													padding:'3 4 1 4',
  													height: 20,
													style: {'background-color': appConstants.majorColor,'color':'#000000'}
												},
												{
													text: 'Critical',
													xtype: 'label',
													margin: '0 10 0 0',
													//width: 45,
													padding:'3 4 1 4',
  													height: 20,
													style: {'background-color': appConstants.criticalColor,'color':'#000000'}
												}
											]
								}
							]
					}]
	},
    loadReportData: function (jsonData) {
        var resultPanelObj = Ext.getCmp('resultPanel');
          var reportGeneration = appConstants.publicjsonData.reportGeneration;
        if (reportGeneration == 'foreground') {
			this.getNomeasurepanel().hide();
            Ext.getCmp("saveTool").setDisabled(false);
            Ext.getCmp("bookletTool").setDisabled(false);
            Ext.getCmp("printTool").setDisabled(false);
            Ext.getCmp("mailTool").setDisabled(false);
            //Ext.getCmp("upbutton").setDisabled(false);
            Ext.getCmp("csvTool").setDisabled(false);
            var noDataFound = true;
             this.getBackGroundPanel().hide();
            resultPanelObj.removeAll();
            var reportData = jsonData.REPORT_DATA;
             if (!Ext.isEmpty(reportData)) {
                noDataFound = false;
                var itemArray = new Array();
                if (jsonData.er_showVms == 'All') {
                    resultPanelObj.setTitle(jsonData.resultTitle);
                    for (var x in reportData) {
                        var gridObj_tmp = reportData[x];
                        var hostdata = gridObj_tmp['HOST_GRID'];
                        var vmdata = gridObj_tmp['VM_GRID'];
                        if (!Ext.isEmpty(hostdata)) {
                            var hostgrid = this.getVMGridObj(hostdata,false,x);
                            itemArray.push(hostgrid);
                        }
                        if (!Ext.isEmpty(vmdata)) {
                            var vmGrid = this.getVMGridObj(vmdata,true,x);
                            itemArray.push(vmGrid);
                        }
                        //itemArray.push({xtype: 'splitter',height:2,margin:6,draggable:false,style:{'cursor':'default'}});
                    }
                } else {
                    var vmGrid = this.getVMGridObj(reportData,false,0);
                    resultPanelObj.setTitle(jsonData.resultTitle);
                    itemArray.push(vmGrid);
                }
                resultPanelObj.show();
                resultPanelObj.add(itemArray);
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
            }
            if (noDataFound) {
                this.disableTools();
				resultPanelObj.hide();
				this.getNomeasurepanel().show();
             } 
        } else if (reportGeneration == 'background' || reportGeneration == 'background-csv') {
            resultPanelObj.removeAll();
            resultPanelObj.hide();
			this.getNomeasurepanel().hide();
			var htmlStr = ''
             var backgroundReportStatus = jsonData.backgroundReportStatus;
            if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;
                //var sub = backgroundAnchor.slice(0, -3);
               //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + ' </b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;
                var sub = backgroundAnchor.slice(0, -3);
                //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else {
               htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</b></div></div></center>';
            }
 			 this.getBackGroundPanel().update(htmlStr);
             this.getBackGroundPanel().show();
        }
        appConstants.initLdgMask.hide();
    },
    reloadWithAjax: function (obj) {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        if (obj.getId() == 'er_comptype') {
            this.updateQueryString(true);
        } else {
            this.updateQueryString(false);
        }
		var fromFavoriteModify = appConstants.publicjsonData['hiddenfields']['fromFavoriteModify'];
		var favorite_id = appConstants.publicjsonData['hiddenfields']['favorite_id'];
		var er_favorite = appConstants.publicjsonData['hiddenfields']['er_favorite'];
		var fromScheduleModify = appConstants.publicjsonData['hiddenfields']['fromScheduleModify'];
		appConstants.queryString += "&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id+"&er_favorite="+er_favorite;
        Ext.Ajax.request({
            url: '/final/reporter/ErVMCapacityReportJson.jsp',
            params: appConstants.queryString,
            method: 'POST',
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
                var s_option = appConstants.publicjsonData.er_option;
                if (obj.getId() == 'er_option') {
                    if (s_option != 'Component') {
                        comboRawData = appConstants.publicjsonData.siteCombo;
                        selectedComboOption = appConstants.publicjsonData.er_site;
                        comboObject = Ext.getCmp('er_site');
                        comboObject.setFieldLabel(appConstants.publicjsonData.screenLabels['reporter.common.' + s_option]);
						comboObject.getStore().clearFilter(true);
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboObject.show();
                        if (s_option == 'Zone') {
                            Ext.getCmp('er_includezones').show();
                        } else {
                            Ext.getCmp('er_includezones').hide();
                        }
                    } else {
                        Ext.getCmp('er_site').hide();
                        Ext.getCmp('er_includezones').hide();
                    }
                }
                if (obj.getId() == 'er_option' || obj.getId() == 'er_site' || obj.getId() == 'er_includezones') {
                    comboRawData = appConstants.publicjsonData.compTypeCombo;
                    selectedComboOption = appConstants.publicjsonData.er_comptype;
                    comboObject = Ext.getCmp('er_comptype');
					comboObject.getStore().clearFilter(true); 
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
                }
                comboRawData = appConstants.publicjsonData.componentCombo;
                selectedComboOption = appConstants.publicjsonData.er_component;
                comboObject = Ext.getCmp('er_component');
				appConstants.rawDataForComponents = comboRawData;
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
            }
        });
    },
    updateQueryString: function (needCompnent) {
        var FormParams;
        var hiddenfieldQString = '';
        var timelineParams;
        var timePeriodParams;
        var datafrom = Ext.getCmp('er_option').getValue();
        var compArray = Ext.getCmp('er_component').getValue();
        FormParams = "er_option=" + datafrom;
        if (datafrom != 'Component') {
            FormParams += "&er_site=" + Ext.getCmp("er_site").getValue();
            if (datafrom == 'Zone') {
                FormParams += "&er_includezones=" + Ext.getCmp("er_includezones").getValue();
            }
        }
        var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
        if (needCompnent) {
            FormParams += "&er_comptype=" + Ext.getCmp("er_comptype").getValue();
            for (var k = 0; compArray.length > k; k++) {
                FormParams += "&er_component=" + compArray[k];
            }
        }
		var er_showVms = appConstants.publicjsonData.er_showVms;
		var underMinimum = appConstants.publicjsonData.underMinimum;
		var underMajor = appConstants.publicjsonData.underMajor;
		var underCritical = appConstants.publicjsonData.underCritical;
		var upperminimum = appConstants.publicjsonData.upperminimum;
		var uppermajor = appConstants.publicjsonData.uppermajor;
		var upperCritical = appConstants.publicjsonData.upperCritical;
		var limitsarr = appConstants.publicjsonData.er_utilizationFor;
		var timefrom = appConstants.publicjsonData.selectedTimeFrom;
		var minfrom = appConstants.publicjsonData.selectedMinsFrom;
		var timeto = appConstants.publicjsonData.selectedTimeTo;
		var minto = appConstants.publicjsonData.selectedMinsTo;
		var reportGeneration = appConstants.publicjsonData.reportGeneration;
		if (isSettingsEnabled)
		{
			er_showVms = Ext.getCmp("er_showVms").getValue();
			underMinimum = Ext.getCmp("underMinimum").getValue();
			underMajor = Ext.getCmp("underMajor").getValue();
			underCritical = Ext.getCmp("underCritical").getValue();
			upperminimum = Ext.getCmp("upperminimum").getValue();
			uppermajor = Ext.getCmp("uppermajor").getValue();
			upperCritical = Ext.getCmp("upperCritical").getValue();
			limitsarr = Ext.getCmp("er_utilizationFor").getValue();
			timefrom = Ext.getCmp("timefrom").getValue();
			minfrom = Ext.getCmp("minfrom").getValue();
			timeto = Ext.getCmp("timeto").getValue();
			minto = Ext.getCmp("minto").getValue();
			reportGeneration = Ext.getCmp("reportGeneration").getValue();
		}
        FormParams += "&er_showVms=" + er_showVms + "&underMinimum=" + underMinimum + "&underMajor=" + underMajor + "&underCritical=" + underCritical + "&upperminimum=" + upperminimum + "&uppermajor=" + uppermajor + "&upperCritical=" + upperCritical;
		var timperiodParams = "&timefrom=" + timefrom + "&minfrom=" + minfrom + "&timeto=" + timeto + "&minto=" + minto;
        for (var k = 0; limitsarr.length > k; k++) {
            FormParams += "&er_utilizationFor=" + limitsarr[k];
        }
        FormParams += "&er_reportgenration=" + reportGeneration;
        if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
            var hiddenFields = appConstants.publicjsonData.hiddenfields;
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        appConstants.queryString = FormParams + timelineParams + hiddenfieldQString + timperiodParams;
    },
    loadDefaults: function () {
        Ext.getCmp('er_mode').hide();
		if(!hideBackButton){
			Ext.getCmp('virtualmachinescapacitymainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonData['ID']
				}
			);
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
        appConstants.clsForColors = appConstants.publicjsonData.clsForColors;
        this.fillFormFields(appConstants.publicjsonData);
        this.refreshReportData();
    },
    refreshReportData: function () {
        if (appConstants.isSubmit != null && appConstants.isSubmit == "true") {
            appConstants.initLdgMask.show();
            this.loadReportData(appConstants.publicjsonData);
        }
		else if(appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true'){
			this.showResult();
		}
		else
		{
			 if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
    },
	afterSettingsrender:function(){
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields =  appConstants.publicjsonData["hiddenfields"];
		var favorite_id = hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var jsonData = appConstants.publicjsonData;
        var screenLabels = jsonData.screenLabels;
		var comboRawData = jsonData.showVmCombo;
        var selectedComboOption = jsonData.er_showVms;
        var comboObject = Ext.getCmp('er_showVms');
        comboObject.setFieldLabel(screenLabels['reporter.common.Show VMs']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        Ext.getCmp('lowLimitLbl').setFieldLabel(screenLabels['reporter.common.Low Utilization Limit']);
        Ext.getCmp('underMinimum').setValue(jsonData.underMinimum);
        Ext.getCmp('underMinimum').setFieldLabel(screenLabels['reporter.common.Minor']);
        Ext.getCmp('underMajor').setValue(jsonData.underMajor);
        Ext.getCmp('underMajor').setFieldLabel(screenLabels['reporter.common.Major']);
        Ext.getCmp('underCritical').setValue(jsonData.underCritical);
        Ext.getCmp('underCritical').setFieldLabel(screenLabels['reporter.common.Critical']);
        Ext.getCmp('highLimitLbl').setFieldLabel(screenLabels['reporter.common.High Utilization Limit']);
        Ext.getCmp('upperminimum').setValue(jsonData.upperminimum);
        Ext.getCmp('upperminimum').setFieldLabel(screenLabels['reporter.common.Minor']);
        Ext.getCmp('uppermajor').setValue(jsonData.uppermajor);
        Ext.getCmp('uppermajor').setFieldLabel(screenLabels['reporter.common.Major']);
        Ext.getCmp('upperCritical').setValue(jsonData.upperCritical);
        Ext.getCmp('upperCritical').setFieldLabel(screenLabels['reporter.common.Critical']);
        comboRawData = jsonData.applylimitCombo;
        selectedComboOption = jsonData.er_utilizationFor;
        comboObject = Ext.getCmp('er_utilizationFor');
        Ext.getCmp('applylimitlbl').setText(screenLabels['reporter.common.Apply Limits']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
        Ext.getCmp('timefrom').setValue(jsonData.selectedTimeFrom);
        Ext.getCmp('minfrom').setValue(jsonData.selectedMinsFrom);
        Ext.getCmp('timeto').setValue(jsonData.selectedTimeTo);
        Ext.getCmp('minto').setValue(jsonData.selectedMinsTo);
        var reportGenCombo = jsonData.reportGenerationCombo;
        var selreportGeneration = jsonData.reportGeneration;
        var reportGen = Ext.getCmp('reportGeneration');
        reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
        reportGen.getStore().loadRawData(reportGenCombo);
        reportGen.setValue(selreportGeneration);
	},
    fillFormFields: function (jsonData) {
        var screenLabels = jsonData.screenLabels;
		var hiddenFields = appConstants.publicjsonData['hiddenfields'];
        var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
        var comboRawData;
        var selectedComboOption;
        var comboObject;
		var s_option =  jsonData.er_option;
        comboRawData = jsonData.anlyzeCombo;
        selectedComboOption = jsonData.er_option;
        comboObject = Ext.getCmp('er_option');
        comboObject.setFieldLabel(screenLabels['reporter.common.Analyze by']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		if(s_option != 'Component'){
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.er_site;
			comboObject = Ext.getCmp('er_site');
			comboObject.setFieldLabel(screenLabels['reporter.common.' + s_option]);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
			if(s_option == 'Zone'){
               Ext.getCmp('er_includezones').show();
			}
		}
        comboRawData = jsonData.subzoneCombo;
        selectedComboOption = jsonData.er_includezones;
        comboObject = Ext.getCmp('er_includezones');
        comboObject.setFieldLabel(screenLabels['reporter.common.Include Subzone']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.compTypeCombo;
        selectedComboOption = jsonData.er_comptype;
        comboObject = Ext.getCmp('er_comptype');
        comboObject.setFieldLabel(screenLabels['reporter.common.Component Type']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.componentCombo;
        selectedComboOption = jsonData.er_component;
        comboObject = Ext.getCmp('er_component');
				appConstants.rawDataForComponents = comboRawData;
        Ext.getCmp('componentsLbl').setText(screenLabels['reporter.common.Component']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }

        var timelineRawData = jsonData.timelineCombo;
        var selectedTimeline = jsonData.selectedTimeline;
        var timelineObj = Ext.getCmp('er_timeline');
        timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
        timelineObj.getStore().loadRawData(timelineRawData);
        if (!Ext.isEmpty(timelineRawData)) {
            if (!Ext.isEmpty(selectedTimeline)) {
                timelineObj.setValue(selectedTimeline);
            } else {
                timelineObj.setValue(timelineRawData[0].valueField);
            }
        }
		var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = jsonData.startDate;
        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = jsonData.startHour;
        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = jsonData.endDate;
        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = jsonData.endHour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;
		updatingAppSettings();
    },
    reportGenChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var reportGenType = Ext.getCmp('reportGeneration').getValue();
        if (reportGenType == 'background' ||reportGenType == 'background-csv') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
        } else {
            Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
        }
    },
    timeLineOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var startDateObj = Ext.getCmp('er_stdate');
        var startHrObj = Ext.getCmp('er_sthr');
        var endDateObj = Ext.getCmp('er_enddate');
        var endHrObj = Ext.getCmp('er_endhr');
        var timelineObj = Ext.getCmp('er_timeline');
        if (timelineObj.getValue() == 'Any') {
            startDateObj.setDisabled(false);
            startHrObj.setDisabled(false);
            endDateObj.setDisabled(false);
            endHrObj.setDisabled(false);
        } else {
            timelineObj.suspendEvents(true);
            this.updateQueryString(false);
            Ext.Ajax.request({
                url: '/final/reporter/ErVMCapacityReportJson.jsp',
                params: appConstants.queryString,
                scope: this,
                success: function (response) {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
                    appConstants.publicjsonData = jsonData;
                    var start_hour = jsonData.startHour;
                    var end_hour = jsonData.endHour;
                    var start_date = jsonData.startDate;
                    var end_date = jsonData.endDate;
                    startDateObj.setDisabled(true);
                    startHrObj.setDisabled(true);
                    endDateObj.setDisabled(true);
                    endHrObj.setDisabled(true);
                    startDateObj.setValue(start_date);
                    startHrObj.setValue(start_hour);
                    endDateObj.setValue(end_date);
                    endHrObj.setValue(end_hour);
                }
            });
            timelineObj.resumeEvents();
        }
    },
    loadTools: function () {
        this.getNewUtilities().loadIcon(true, //save
        true, //print
        true, //mail
        false, //data
        true, //csv
        true, // fav
        true, // schedule
        false, //daignosis
        false, //togglebutton
        false, //close
        true //booklet
        );
		 //Ext.getCmp("upbutton").hide();
        Ext.getCmp("scheduleTool").setDisabled(false);
        Ext.getCmp("favoriteTool").setDisabled(false);
    },
    disableTools: function () {
        Ext.getCmp("saveTool").setDisabled(true);
        Ext.getCmp("bookletTool").setDisabled(true);
        Ext.getCmp("printTool").setDisabled(true);
        Ext.getCmp("mailTool").setDisabled(true);
        //Ext.getCmp("upbutton").setDisabled(true);
        Ext.getCmp("csvTool").setDisabled(true);
    }
});
