

Ext.define('VirtualMachinesChangesApp.controller.Main',{
	extend:'Ext.app.Controller',
	refs:[
		{selector:'main', ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'virtualmachineschangesmainform',ref:'virtualmachineschangesmainform'},
		{selector:'virtualmachineschangessettings',ref:'virtualmachineschangessettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'},
		{selector: 'ReporterSettings',ref: 'ReporterSettings'},//ezhil
	],
	init:function()
	{
		this.control(
		{
			'main newUtilities':
			{
				'afterrender': this.hideTools
			},
			'main':
			{
				'afterrender': this.loadDefaults
			},
			'virtualmachineschangessettings':
			{
				'afterrender': this.afterSettingsrender
			},
			'egcomponent button[id="expandSelector"]':{
				  'click':this.expandSelectorComponent
			},
			'virtualmachineschangesmainform combo[id="select_group"]':{
				'select':this.AnalysisByComboOnChange
			},
			'virtualmachineschangessettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'virtualmachineschangessettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualmachineschangessettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'mainform button[itemId="submit"]':{
				'click': this.showGraph
			},
			'mainform button[itemId="save"]':{
				'click': this.add
			},
			'newUtilities > #favoriteTool > button' : {
				 'click' : this.add
			},
			'newUtilities > #scheduleTool > button' : {
				'click' : this.add
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}

		});
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		//layout:'vbox',
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		//html:tpl.apply(),
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'virtualmachineschangessettings',
				itemId: 'settingsForm',
				parent:this
			}
		],
		renderTo:'virtualmachineschanges-body'
		});
		Ext.EventManager.onWindowResize(function(){
		Ext.get('configMod').setStyle('left', '');
		});
		var me = this;

		Ext.get('closeSettings').on('click',function()
		{
			me.validateAndCloseSettings();
		});

	},
	validateAndCloseSettings:function()
	{
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		if ( reportgenVal == 'background' || reportgenVal == 'background-csv')
		{
			var reportName = Ext.getCmp('bgReportName'); //ezhil
			
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);

			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				return ;
			}
		}
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return ret;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showGraph();
		}
	},
	afterSettingsrender : function() 
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.defaultJSON.hiddenFields;
		// var favorite_id = appConstants.defaultJSON['hiddenFields']["favorite_id"];
		 var favorite_id = hiddenFields.favorite_id;
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		this.getVirtualmachineschangessettings().loadDefaultData(appConstants.defaultJSON['timeline']);
		this.getVirtualmachineschangessettings().loadScreenLabels(appConstants.defaultJSON.screenlabels);
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	loadDefaults: function () {
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')

		this.getMain().setTitle(appConstants.er_RmDispName);
		 var from_schedule = appConstants.defaultJSON['hiddenFields']['fromScheduleModify'];
		var fromFavoriteModify = appConstants.defaultJSON['hiddenFields']["fromFavoriteModify"];
		if(!hideBackButton){
		Ext.getCmp('virtualmachineschangesmainform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.defaultJSON['ID']
			}
		);
	}

		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			//Ext.getCmp("submit").hide();
			//Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			//Ext.getCmp("submit").show();
			//Ext.getCmp("save").hide();
		}
		this.getVirtualmachineschangesmainform().loadDefaultData(appConstants.defaultJSON);
		
				
		if(appConstants.fromSchView!=null && appConstants.fromSchView=='Yes'){
			
		}
		else if(appConstants.fromFavSch!=null && appConstants.fromFavSch=='true')
		{
			this.showGraph();
		}
		if(appConstants.isForceSubmit=='true')
		{
			appConstants.isForceSubmit='false';
			this.showGraph(Ext.getCmp('submit'));
		}
	},
	hideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //csv
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //booklet
			);

		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	   // Ext.getCmp("upbutton").setDisabled(true);
	},
	 expandSelectorComponent:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Component',btn);
	},
	AnalysisByComboOnChange : function(combo){
		var val = combo.getValue();
		var param = 'reqFrom=filterCombo&select_group='+val+'&sessionID='+appConstants.sessionID+'&er_comptype='+Ext.getCmp('er_comptype').getValue();
		Ext.Ajax.request({
		   url:'/final/servlet/com.eg.ErVMMovementC',
		   params:param,
		   success:function(response)
		   {
			   var jsontext = response.responseText;
			   var jsonData = Ext.decode(jsontext);
			   if(!Ext.isEmpty(jsonData))
			   {
					if(val!=null && val=="Zone")
					{
						var sg = Ext.getCmp('zones');
						sg.getStore().clearFilter(true); 
						sg.getStore().loadRawData(jsonData.select_groupComboArray);
						Ext.getCmp('includezones').getStore().loadRawData(jsonData.subzone);
						Ext.getCmp('includezones').setValue(Ext.getCmp('includezones').getStore().getAt(1));
						Ext.getCmp('includezones').show();
						sg.setValue(sg.getStore().getAt(0));
						Ext.getCmp('services').hide();
						Ext.getCmp('segments').hide();
						Ext.getCmp('compContainer').hide();
						sg.show();
					}
					else if(val!=null && val=="Service")
					{
						var sg = Ext.getCmp('services');

						Ext.getCmp('segments').hide();
						Ext.getCmp('zones').hide();
						Ext.getCmp('includezones').hide();
						Ext.getCmp('compContainer').hide();
						sg.getStore().clearFilter(true); 
						sg.getStore().loadRawData(jsonData.select_groupComboArray);
						sg.setValue(sg.getStore().getAt(0));
						sg.show();
					}
					else if(val!=null && val=="Segment")
					{
						var sg = Ext.getCmp('segments');
						Ext.getCmp('services').hide();
						Ext.getCmp('zones').hide();
						 Ext.getCmp('includezones').hide();
						Ext.getCmp('compContainer').hide();
						sg.getStore().clearFilter(true); 
						sg.getStore().loadRawData(jsonData.select_groupComboArray);
						sg.setValue(sg.getStore().getAt(0));
						sg.show();
					}
					else
					{
						var sg = Ext.getCmp('er_component');
						Ext.getCmp('services').hide();
						Ext.getCmp('zones').hide();
						 Ext.getCmp('includezones').hide();
						Ext.getCmp('segments').hide();
						sg.getStore().loadRawData(jsonData.select_groupComboArray);
						appConstants.rawDataForComponents = jsonData.select_groupComboArray;
						var values = [];

						sg.getStore().each( function( re ) {
							values.push ( re.get('valueField') );
						}, this);
						sg.setValue(values);
						Ext.getCmp('compContainer').show();
					}
			   }
		   }
		});
	},
	 reportGenChange : function(){
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else if(reportGenType== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	 },
	 timeLineOnChange:function(combo) {

		var form = combo.up('form').getForm();
		if (combo.getValue() == 'Any') {
			form.findField('er_enddate').setDisabled(false);
			form.findField('er_endhr').setDisabled(false);
			form.findField('er_sthr').setDisabled(false);
			form.findField('er_stdate').setDisabled(false);
		} else {
			form.findField('er_enddate').setDisabled(true);
			form.findField('er_endhr').setDisabled(true);
			form.findField('er_sthr').setDisabled(true);
			form.findField('er_stdate').setDisabled(true);

			var timeline = form.findField("er_timeline").getValue();
			var strtdt = form.findField("er_stdate").getValue();
			var enddt = form.findField("er_enddate").getValue();

			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);

			var hiddenFields = appConstants.defaultJSON.hiddenFields;
			var msxdays = hiddenFields['getMaxDaysInMonth'];
			var inidate = hiddenFields['inidate'];
			var usertimeline = hiddenFields['er_usertimeline'];
			var er_reportgenration = form.findField('reportGeneration').getValue();
			var bgenabled = hiddenFields['bgenabled'];

			 if (bgenabled == 'Yes' || bgenabled == 'yes') {

					var limitforbg = hiddenFields['limitforbg'];

					var bgtime = getTimeValues(limitforbg, msxdays,strtdt, enddt,inidate);
					var getimeline = getTimeValues(timeline, msxdays,strtdt, enddt,inidate);
					var selectbackground = er_reportgenration;
					var bgprocess = false;

					if (getimeline >bgtime && selectbackground == 'foreground') {

						 form.findField("bgReportName").show();
						 form.findField('reportGeneration').setValue('background');
					}
					else
					{
						form.findField("bgReportName").hide();
						 form.findField('reportGeneration').setValue('foreground');
					}
				}
		}

	},
	showGraph : function(thisObj){

		Ext.getCmp('panelinsidetoggle').setDisabled(false);

		var mainForm;
		if(thisObj!=undefined)
		{
			mainForm = thisObj.up('.form').getForm();
		}
		else
		{
			mainForm = Ext.getCmp('virtualmachineschangesmainform').getForm();
		}


		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		var zones = mainForm.findField('zones').getValue();
		var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('er_component').getValue();
		var er_measure = mainForm.findField('er_measure').getValue();

		var select_groupName = ''

		if(zones!=null && zones!='-1' && zones!='')
			select_groupName = zones;

		if(services!=null && services!='-1' && services!='')
			select_groupName = services;


		if(er_measure!=null && er_measure=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'please choose the measure',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}



		if(components!=null && components=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a required parameters',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}
		if(select_group=='Zone')
		{
			if(zones=="-1")
			{
				Ext.Msg.show({
					title : 'Alert',
					msg : 'Please choose a Zone',
					buttons : Ext.Msg.OK,
					icon : Ext.Msg.WARNING
				});
				return;
			}
		}


		 var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_timeline=mainForm.findField('er_timeline').getValue();

		var timeline =appConstants.defaultJSON['timeline'];
		var er_include = timeline.migrationfilerCombo_value;
		var timefrom = timeline.timePeriod.timefrom;
		var timeto = timeline.timePeriod.timeto;
		var minfrom = timeline.timePeriod.minfrom;
		var minto = timeline.timePeriod.minto;
		var er_reportgenration = timeline.reportgenCombo_value;
		if (isSettingsEnabled)
		{
			var otherFiltersForm = Ext.getCmp('settings').getForm();
			er_include = otherFiltersForm.findField('er_include').getValue();
			timefrom = otherFiltersForm.findField('timefrom').getValue();
			timeto = otherFiltersForm.findField('timeto').getValue();
			minfrom = otherFiltersForm.findField('minfrom').getValue();
			minto = otherFiltersForm.findField('minto').getValue();
			er_reportgenration = otherFiltersForm.findField('reportGeneration')
					.getValue();
		}



		//startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
	   // enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);


		//var starttime = formatDate(new Date(getDateFromFormat(startdate,currdtFormat)),"MM/dd/yyyy");
		//var endtime = formatDate(new Date(getDateFromFormat(enddate,currdtFormat)),"MM/dd/yyyy");


		var stdateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, getExtjsDateFormat("MM/dd/yyyy")));
		var endateobj=new Date(Ext.Date.parse(Ext.getCmp('er_enddate').dataArray, getExtjsDateFormat("MM/dd/yyyy")));
		var beanst_date = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var beanen_date = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));



		var hiddenFields = appConstants.defaultJSON.hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";

		}
		 param+='select_group='+select_group+'&includeSubZone='+includezones+'&er_include='+er_include;



		param+='&er_measure='+er_measure+'&er_comptype='+er_comptype;

		if(select_group=='Component')
		{
			for (var j = 0; j < components.length; j++) {
				param += "&select_groupName=" + components[j];
			}
		}
		else
		{
			param +='&select_groupName='+select_groupName;
		}

		param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="
				+ endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin;


		param+='&beanstartdate='+beanst_date+'&beanenddate='+beanen_date+'&timelineval='+er_timeline+'&inszone='+includezones+'&select_farm='+select_groupName;
		param +='&schedule_id=';




		param += '&timefrom=' + timefrom
				+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='
				+ minto;


		param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID+'&reqFrom=VMMovement&er_component=null';
				

   
		//


			var stDateTime = Ext.getCmp('er_stdate').getValue();
		var tmpStartHour = Ext.getCmp('er_sthr').getValue();
		stDateTime.setHours(tmpStartHour);
		var enDateTime = Ext.getCmp('er_enddate').getValue();
		var tmpEndHour = Ext.getCmp('er_endhr').getValue();
		enDateTime.setHours(tmpEndHour);
		var bool = checkDateTime(stDateTime, enDateTime);

		//
 
		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var bgenabled = hiddenFields['bgenabled'];
		var limitforbg = hiddenFields['limitforbg'];
		if (bool) {
			if (bgenabled == 'Yes' || bgenabled == 'yes') {

				var bgtime = getTimeValues(limitforbg, msxdays,startdate, enddate,inidate);
				var getimeline = getTimeValues(er_timeline, msxdays,startdate, enddate,inidate);
				var selectbackground = er_reportgenration;
				var bgprocess = false;

				if (getimeline >= bgtime && selectbackground == 'foreground') {

					 var confrimation = hiddenFields['confrimation'];

					 if (confrimation != null && (confrimation =="TRUE" || confrimation.toLowerCase()=="yes" )) {

							bgprocess = true;
							var e_obj = Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn){

								if(btn=="no")
								{
									if (!isSettingsEnabled)
									{
										this.getReporterSettings().down('button').fireHandler();//ezhil
										//this.showConfigDropdown();
									}
									var otherFiltersForm = Ext.getCmp('settings').getForm();
									otherFiltersForm.findField('reportGeneration').setValue('background');
									otherFiltersForm.findField('bgReportName').setValue("");
									otherFiltersForm.findField('bgReportName').show();
									otherFiltersForm.findField('bgReportName').focus(false, 1000);//ezhil
									validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName'),'Attachment',true);

								}
								else
								{
									if (bool) {
												var old_width = 0;
												var val = false;
												var timeVal = true;


												timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
												if (timeVal) {
													param += '&er_reportgenration='+selectbackground;
													var url= '/final/servlet/com.eg.ErVMMovementC?isSubmit=true';
													this.submitReport(url,param,er_reportgenration);

												} else
													return;

											} else {
												Ext.Msg.show({
															title : 'Alert',
															msg : appConstants.datealert,
															buttons : Ext.Msg.OK,
															icon : Ext.Msg.WARNING
														});

											}
								}

							},this);

					}
				}
				else
				{

				}
				selectbackground = timeline.reportgenCombo_value
				if (isSettingsEnabled)
				{
					selectbackground = otherFiltersForm.findField('reportGeneration').getValue();
				}

				if (selectbackground == 'background' && bgprocess==false) 
				{

					var bg_reportname = otherFiltersForm.findField('bgReportName').getValue();

					if (validateTextBoxes(bg_reportname)) {
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
								bg_reportname=checkFileName(bg_reportname);
								param += '&bg_reportname=' + bg_reportname+'&er_reportgenration='+selectbackground+'&client=true';
								var url= '/final/servlet/com.eg.ErStartBackGroundReportC';
								this.submitReport(url,param,er_reportgenration);
						} else
							return;
					}
				}
				else if (selectbackground == 'background-csv' && bgprocess==false) 
				{

					var bg_reportname = otherFiltersForm.findField('bgReportName').getValue();

					if (validateTextBoxes(bg_reportname)) {
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
								bg_reportname=checkFileName(bg_reportname);
								param += '&bg_reportname=' + bg_reportname+'&er_reportgenration='+selectbackground+'&client=true';
								var url= "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
								this.submitReport(url,param,er_reportgenration);
						} else
							return;
					}
				} 
				else if(!bgprocess){

						var old_width = 0;
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
							param += '&er_reportgenration='+selectbackground;
							var url= '/final/servlet/com.eg.ErVMMovementC?isSubmit=true';
							this.submitReport(url,param,er_reportgenration);

						} else
							return;


				}
			} else {

					var val = false;
					var timeVal = true;
					timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
					if (timeVal) {
						param += '&er_reportgenration='+selectbackground;
							var url=  '/final/servlet/com.eg.ErVMMovementC?isSubmit=true';
							this.submitReport(url,param,er_reportgenration);
					} else
						return;


			}

		}
		else {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});

			return;
		}

	},
	submitReport : function(url,param,er_reportgenration)
	{
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
		param +="&er_RmDispName="+appConstants.er_RmDispName;

		var myMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		 myMask.show();
		 var me =  this;
		me.getNomeasurepanel().hide();
		me.getBackGroundPanel().hide();

		  Ext.Ajax.request({
			  url:url,
			  params:param,
			  scope:this,
			  async:false,
			  success : function(response){
				   var jsontext = response.responseText;

				   var jsonData = Ext.decode(jsontext);
				   if(er_reportgenration=='background' || er_reportgenration=='background-csv')
				   {
						 var grpahQueryString = jsonData.grpahQueryString;
						 var backgroundReportStatus=grpahQueryString.status;
							var htm = '';

							if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'success')
							{
								//htm ='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+grpahQueryString.bgstr1+'</b></br><a class="backgroundMsgLink" href="'+grpahQueryString.queryString+'">'+grpahQueryString.bgstr2+'</a></div></div></center>'
								htm ='<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
							}
							else if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'duplicate')
							{
								//htm = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+grpahQueryString.bgstr1+'</b></br><a class="backgroundMsgLink" href="'+grpahQueryString.queryString+'">'+grpahQueryString.bgstr2+'</a></div></div></center>'
								htm ='<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
							}

							me.getBackGroundPanel().update(htm);
							me.getBackGroundPanel().show();
							Ext.getCmp('resultPanel').hide();
							myMask.hide();
							return;
				   }
				   else
				   {                        
						Ext.getCmp('resultPanel').loadGrid(jsonData['gridData']);
						me.getMain().printQuery = jsonData['printQuery'];
					}

				   myMask.hide();
			  }
		  });

	},
	saveReportAsPDF:function(){


		var s_qryString = '../reporter/ErHtmlToSavePdf.jsp?'+this.getMain().printQuery;

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		return this.getMain().printQuery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){


		var s_qryString = '/final/reporter/ErVMMovementDataPrint.jsp?pdfPrint=yes&'+this.getMain().printQuery;

	parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	add : function(button) {
				// by karthikeyan
/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
						title : 'VirtualMachines Reports',
						msg : 'Chosen timeline not allowed',
						buttons : Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
					});
				return;
		} */
//
		var mainForm = this.getVirtualmachineschangesmainform().getForm();

		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		var zones = mainForm.findField('zones').getValue();
		var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('er_component').getValue();
		var er_measure = mainForm.findField('er_measure').getValue();

		var select_groupName = ''

		if(zones!=null && zones!='-1' && zones!='')
			select_groupName = zones;

		if(services!=null && services!='-1' && services!='')
			select_groupName = services;


		if(er_measure!=null && er_measure=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'please choose the measure',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}



		if(components!=null && components=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a required parameters',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}
		
		if(select_group=='Zone')
		{
			if(zones=="-1")
			{
				Ext.Msg.show({
					title : 'Alert',
					msg : 'Please choose a Zone',
					buttons : Ext.Msg.OK,
					icon : Ext.Msg.WARNING
				});
				return;
			}
		}


		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_timeline=mainForm.findField('er_timeline').getValue();

	   var timeline =appConstants.defaultJSON['timeline'];
		var er_include = timeline.migrationfilerCombo_value;
		var timefrom = timeline.timePeriod.timefrom;
		var timeto = timeline.timePeriod.timeto;
		var minfrom = timeline.timePeriod.minfrom;
		var minto = timeline.timePeriod.minto;
		var er_reportgenration = timeline.reportgenCombo_value;
		if (isSettingsEnabled)
		{
			var otherFiltersForm = Ext.getCmp('settings').getForm();
			er_include = otherFiltersForm.findField('er_include').getValue();
			timefrom = otherFiltersForm.findField('timefrom').getValue();
			timeto = otherFiltersForm.findField('timeto').getValue();
			minfrom = otherFiltersForm.findField('minfrom').getValue();
			minto = otherFiltersForm.findField('minto').getValue();
			er_reportgenration = otherFiltersForm.findField('reportGeneration')
					.getValue();
		}

		var stdateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, getExtjsDateFormat("MM/dd/yyyy")));
		var endateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, getExtjsDateFormat("MM/dd/yyyy")));
		var beanst_date = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var beanen_date = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));

		//startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
		//enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);


		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");


		var hiddenFields = appConstants.defaultJSON.hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";

		}
		 param+='select_group='+select_group+'&includeSubZone='+includezones+'&er_include='+er_include;



		param+='&er_measure='+er_measure+'&er_comptype='+er_comptype;

		if(select_group=='Component')
		{
			for (var j = 0; j < components.length; j++) {
				param += "&select_groupName=" + components[j];
			}
		}
		else
		{
			param +='&select_groupName='+select_groupName;
		}

		param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr=" + endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin;

		var stdateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, getExtjsDateFormat("MM/dd/yyyy")));
		var endateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, getExtjsDateFormat("MM/dd/yyyy")));
		var beanst_date = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var beanen_date = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));


		param +='&beanstartdate='+beanst_date+'&beanenddate='+beanen_date+'&timelineval='+er_timeline+'&inszone='+includezones+'&select_farm='+select_groupName;



		param += '&timefrom=' + timefrom
				+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='
				+ minto;


		param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID+'&reqFrom=VMMovement&er_component=null';

		param+='&er_reportgenration='+er_reportgenration;

		var target = "";
		var from_schedule = appConstants.defaultJSON['hiddenFields']['fromScheduleModify'];
		var fromFavoriteModify = appConstants.defaultJSON['hiddenFields']["fromFavoriteModify"];
		var favorite_id = appConstants.defaultJSON['hiddenFields']["favorite_id"];
		if ((button.getId() == "scheduleImg" || appConstants.fromSchModify=='Yes') || (from_schedule != null && from_schedule == "Yes"))
		{
			target = "/final/reporter/ErSaveSchedule.jsp?" + param;
			if (button.getItemId() =='save')
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
		{
			target = "../servlet/com.eg.ErFavoriteC?cmd=client&" + param +"&er_RmDispName="+appConstants.er_RmDispName;//+"&&FavoriteId="+favorite_id;
			if (button.getItemId() =='save')
			{
				//document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

		}		
	}
});
