Ext.define('VirtualMachinesChangesApp.view.VirtualMachinesChangesMainForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.virtualmachineschangesmainform',
    id: 'virtualmachineschangesmainform',
    screenLabels:null,
	layout: 'column',
	defaults: {
		labelAlign: 'top',
	   margin:'0 20 0 0',
		labelSeparator: ''
	},
    items: [
		{
			xtype: 'scrollcombo',
			cls: 'dropdown',
			width: 130,
			editable: false,
			name: 'er_comptype',
			id: 'er_comptype',
			fieldLabel: 'Report For',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			xtype: 'scrollcombo',
			cls: 'dropdown',
			width: 130,
			editable: false,
			name: 'select_group',
			id: 'select_group',
			value:'-1',
			fieldLabel: 'Analyze by',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			xtype: 'scrollcombo',
			width: 110,
 			cls: 'dropdown',
			labelStyle: 'white-space: nowrap',
			editable: false,
			name: 'includezones',
			id: 'includezones',
			hiddenn:true,
			fieldLabel: 'Include Subzone',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 220,
			editable : true,
			id: 'zones',
			name: 'zones',
			fieldLabel:'Zone',
			listConfig:{
							emptyText:noMatch
						},
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: true
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 220,
			editable : true,
			id: 'services',
			name: 'services',
			fieldLabel:'Service',
			listConfig:{
							emptyText:noMatch
						},
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: true
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 220,
			editable : true,
			id: 'segments',
			name: 'segments',
			fieldLabel:'Segment',
			listConfig:{
							emptyText:noMatch
						},
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: true
		},
		{
			xtype: 'scrollcombo',
			width: 130,
			cls: 'dropdown',
			fieldLabel: 'Measures',
			editable: true,
			id: 'er_measure',
			name: 'er_measure',
			listConfig:{
							emptyText:noMeasureMatch
						},
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: false
		},
		{xtype:'timeline',margin:0},
		{
			xtype:'button',
			text: submitValue,
			margin:'21 0 0 0',
			formBind: true,			
			//cls: 'button20',
			ui:'newButtonSmall',
			itemId: 'submit',
			name: 'submit'
		},
		{
			xtype:'button',
			text: "Save",
			//cls: "button20",
			ui:'newButtonSmall',
			itemId: "save",
			name: "save",
			margin:'21 0 0 0'
		}
	],
    loadDefaultData : function(jsonObject){
    var thisForm = this.getForm();
    this.screenLabels = jsonObject['screenlabels'];


    this.setComboOptionsInList(thisForm, 'er_comptype', jsonObject.reportforCombo, jsonObject.reportforCombo_value);
    this.setComboOptionsInList(thisForm, 'select_group', jsonObject.analysisby, jsonObject.analysisby_value);


    this.setComboOptionsInList(thisForm, 'er_measure', jsonObject.measuresCombo, jsonObject.measure_value);


    if(jsonObject.analysisby_value=="Component")
    {
        var components = Ext.getCmp('er_component');
		appConstants.rawDataForComponents = jsonObject.components;
        components.getStore().loadRawData(jsonObject.components);
        var values = [];

        components.getStore().each( function( re ) {
            values.push ( re.get('valueField') );
        }, this);
        components.setValue(values);
        Ext.getCmp('compMultiselect').show();
        thisForm.findField('includezones').hide();
        thisForm.findField('zones').hide();
        thisForm.findField('services').hide();
    }
    else if (jsonObject.analysisby_value=="Zone")
    {
        var subz = thisForm.findField('includezones');
        subz.show();
        subz.getStore().loadRawData(jsonObject['subzone']);
        subz.setValue(subz.getStore().getAt(1));

        var fieldObj = thisForm.findField('zones');
        fieldObj.getStore().loadRawData(jsonObject['zone']);
        if(jsonObject.select_groupName!=undefined)
        {
            fieldObj.setValue(jsonObject.select_groupName);
        }
        else
        {
         fieldObj.setValue(fieldObj.getStore().getAt(0));
        }
        thisForm.findField('services').hide();
        Ext.getCmp('compMultiselect').hide();
    }
    else if(jsonObject.analysisby_value=="Service")
    {
        var fieldObj = thisForm.findField('services');
        fieldObj.show();
        fieldObj.getStore().loadRawData(jsonObject['services']);
        if(jsonObject.select_groupName!=undefined)
        {
            fieldObj.setValue(jsonObject.select_groupName);
        }
        else
        {
            fieldObj.setValue(fieldObj.getStore().getAt(0));
        }

        thisForm.findField('includezones').hide();
        thisForm.findField('zones').hide();
        Ext.getCmp('compMultiselect').hide();
    }




    /* me.setComboValue(thisForm,'er_sthr',jsonData.timeline.starthour_value);
    me.setComboValue(thisForm,'er_endhr',jsonData.timeline.endhour_value);
    me.setComboValue(thisForm, 'timefrom', jsonData.timePeriod.Hourfrom);
    me.setComboValue(thisForm, 'minfrom', jsonData.timePeriod.Minfrom);
    me.setComboValue(thisForm, 'timeto', jsonData.timePeriod.Hourto);
    me.setComboValue(thisForm, 'minto', jsonData.timePeriod.Minto);
    Ext.getCmp("er_stdate").setValue(jsonData.timeline.startDateValue);
    Ext.getCmp("er_enddate").setValue(jsonData.timeline.endDateValue);*/

		this.loadScreenLabels(thisForm);
		var me=this;
		var timeline=jsonObject.timeline;
		me.setComboOptionsInList(thisForm, 'er_timeline', timeline.timelineCombo, timeline.timeline_value);
		me.setComboValue(thisForm,'er_sthr',timeline.startHourForDisplay);
		me.setComboValue(thisForm,'er_endhr',timeline.endHourForDisplay);
		Ext.getCmp("er_stdate").setValue(timeline.startDateForDisplay);
		Ext.getCmp("er_stdate").dataArray=timeline.startDateValue;
		Ext.getCmp("er_enddate").setValue(timeline.endDateForDisplay);
		Ext.getCmp("er_enddate").dataArray=timeline.endDateValue;

		Ext.getCmp("er_sthr").dataArray=timeline.starthour_value;
		Ext.getCmp("er_endhr").dataArray=timeline.endhour_value;
		stmin = timeline.startMinForDisplay;
		enmin = timeline.endMinForDisplay;
		mgr_stmin = timeline.startmin_value;
		mgr_enmin = timeline.endmin_value;
		Ext.getCmp('er_mode').hide();


		updatingAppSettings();


        var from_schedule = jsonObject['hiddenFields']['fromScheduleModify'];
		//console.log("fromSchedule  ---->"+from_schedule);
        if (from_schedule != null && from_schedule == "Yes") {
			//Ext.getCmp("submit").hide();
			//Ext.getCmp("save").show();
		}else{
			//Ext.getCmp("submit").show();
			//Ext.getCmp("save").hide();
		}

},
loadScreenLabels : function(thisForm) {
    var screenLabels = this.screenLabels;

    thisForm.findField('er_comptype').setFieldLabel(screenLabels['reporter.common.Report for']);
    thisForm.findField('select_group').setFieldLabel(screenLabels['reporter.common.Analysis By']);
    thisForm.findField('er_measure').setFieldLabel(screenLabels['reporter.common.Measures']);
    thisForm.findField('zones').setFieldLabel(screenLabels['reporter.common.Zone']);
    thisForm.findField('includezones').setFieldLabel(screenLabels['reporter.thin.Include subzone']);

},
setComboOptionsInList : function(form, fieldName, list, value){
    form.findField(fieldName).getStore().loadRawData(list);
    form.findField(fieldName).suspendEvents(false);
    var valueAssigned = false;
    for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
        if(list[listCounter].valueField == value && value != "" && value != null){
            form.findField(fieldName).setValue(value);
            valueAssigned = true;
        }
    }

    form.findField(fieldName).resumeEvents();
},
 setComboValue : function(form,fieldName,value){
     form.findField(fieldName).suspendEvents(false);
     form.findField(fieldName).setValue(value);
     form.findField(fieldName).resumeEvents();
},
setNotApplicable : function(form, fieldname, value) {
    form.findField(fieldname).getStore().removeAll();
    form.findField(fieldname).getStore().loadRawData([{
        "displayField" : this.screenLabel['reporter.common.Not Applicable'],
        "valueField" : "-1"
    }]);
    form.findField(fieldname).setValue("-1");
}
})