Ext.define('VirtualMachinesChangesApp.view.VirtualMachinesChangesSettings',{
	extend:'Ext.form.Panel',
	alias:'widget.virtualmachineschangessettings',
	id:'settings',
	//cls:'configMode_popup_inner',	
	layout:'column',
	defaults: {
		labelAlign: 'top',
	   margin:'0 20 0 0',
		labelSeparator: ''
	},
	items:[
				{xtype:'reporttypes', margin: '0 0 0 0'},
				{xtype: 'splitter',height: 2, margin: '10 0 10 0',draggable:false,style: {'cursor': 'default'}},
				{xtype:'timeperiod',  margin: 0},
				{xtype: 'splitter',height: 2,  margin: '10 0 10 0',draggable:false,style: {'cursor': 'default'}},
				{xtype:'reportgeneration',margin: '0 0 0 0'},
				{xtype: 'splitter',height: 2,  margin: '10 0 10 0',id:'RTMSplitter',draggable:false,style: {'cursor': 'default'}},
				{xtype:'timelinesave', margin: '0 20 0 0'}
	   ],
	   loadScreenLabels : function(screenLabels){
        var thisForm = this.getForm();

        thisForm.findField('reportGeneration').labelEl.dom.innerHTML = screenLabels['reporter.consolidated.Report Generation'];

        Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
        Ext.getCmp('fromTimeLbl').setText(screenLabels['reporter.common.From']);
        Ext.getCmp('toTimeLbl').setText(screenLabels['reporter.common.To']);
        Ext.getCmp('fromHrsLbl').setText(screenLabels['reporter.common.Hrs']);
        Ext.getCmp('fromMinsLbl').setText(screenLabels['reporter.common.Mins']);
        Ext.getCmp('toHrsLbl').setText(screenLabels['reporter.common.Hrs']);
        Ext.getCmp('toMinsLbl').setText(screenLabels['reporter.common.Mins']);
    },
    loadDefaultData : function(timeline){
        var me = this;
        var thisForm = me.getForm();
        me.setComboOptionsInList(thisForm, 'reportGeneration', timeline.reportgenCombo, timeline.reportgenCombo_value);


        me.setComboOptionsInList(thisForm,'er_include',timeline.migrationfilterCombo,timeline.migrationfilerCombo_value);

        me.setComboValue(thisForm, 'timefrom',timeline.timePeriod.timefrom);
        me.setComboValue(thisForm, 'minfrom', timeline.timePeriod.minfrom);
        me.setComboValue(thisForm, 'timeto', timeline.timePeriod.timeto);
        me.setComboValue(thisForm, 'minto', timeline.timePeriod.minto);



        this.isLoaded = true;

    },
    setComboOptionsInList : function(form, fieldName, list, value){
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);

        form.findField(fieldName).setValue(value);
        form.findField(fieldName).resumeEvents();
    },
     setComboValue : function(form,fieldName,value){
         form.findField(fieldName).suspendEvents(false);
         form.findField(fieldName).setValue(value);
         form.findField(fieldName).resumeEvents();
    }
});