Ext.define('VirtualMachinesDetailsApp.controller.Main',{
	extend:'Ext.app.Controller',
		gridColStateParam:'ASC',//deafult 1 for ascending
	gridColIndexParam:-1,//added for updating sort by option
	refs:[
		{selector:'main', ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'virtualmachinesdetailsmainform',ref:'virtualmachinesdetailsmainform'},
		{selector:'virtualmachinesdetailssettings',ref:'virtualmachinesdetailssettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'main newUtilities':
			{
				'afterrender': this.hideTools
			},
			'main':
			{
				'boxready': this.boxready
			},
			'virtualmachinesdetailsmainform':
			{
				'afterrender': this.loadDefaults
			},
			'virtualmachinesdetailssettings':
			{
				'afterrender': this.loadSettingsData
			},
			'virtualmachinesdetailsmainform combo[name="selectionCombo"]':
			{
				'select' : this.changeSelection
			},
			'virtualmachinesdetailsmainform combo[name="compTypeCombo"]':
			{
				'select' : this.groupComboChange
			},
			'virtualmachinesdetailsmainform combo[name="virtualMachineCombo"]':
			{
				'select' : this.groupComboChange
			},
			'virtualmachinesdetailsmainform combo[name="virtualCenterCombo"]':
			{
				'select' : this.groupComboChange
			},
			'virtualmachinesdetailsmainform combo[name="reportTypeCombo"]':
			{
				'select' : this.groupComboChange
			},
			'egcomponent button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'virtualmachinesdetailssettings combo[id="showDataCombo"]':
			{
				'select': this.getTrendTimeLineOnChange
			},
			/* 'virtualmachinesdetailssettings combo[name="er_excwe"]':
			{
				'select': this.excludeWeekEnd
			},*/
			'virtualmachinesdetailssettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualmachinesdetailssettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'reportgeneration combo[name="reportGeneration"]':
			{
				'select': this.showBackgroundReport
			},
			'mainform button[name="submit"]' :
			{
				'click' : this.beforeReportSubmit
			},
			'mainform button[name="save"]' :
			{
				'click' : this.addTo
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':
			{
				'click':this.savePdf
			},
			'newUtilities > #favoriteTool > button' : {
				'click' : this.addTo
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.addTo
			},
			'newUtilities > #csvTool > button':{
				'click': this.saveAsCSV
			},
			'newUtilities > #mailTool > button':
			{
				'click':this.sendMail
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	showConfigDropdown:function(){
			isSettingsEnabled = true;
			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					cls:'containerHeader',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'virtualmachinesdetailssettings',
					itemId: 'settingsForm',
					parent:this
				}
			],
			renderTo:'virtualmachinesdetails-body'
			});
			var meController = this;
		  Ext.get('closeSettings')
				  .on('click', function () {
						meController.validateAndCloseSettings();
			   });
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.beforeReportSubmit();
		}
	},
	loadSettingsData : function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields =  appConstants.publicJsonData["hiddenParams"];
		var favorite_id = appConstants.publicJsonData['hiddenParams']["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var meSettingsForm = this.getVirtualmachinesdetailssettings().getForm();

		//var excludeDays = Ext.getCmp('excludeDays');
		//excludeDays.setText(appConstants.publicJsonData['screenLabels']['reporter.common.Excludes']);

		var hrsLbl=appConstants.publicJsonData.screenLabels['reporter.common.Hrs'];
		var fromLbl=appConstants.publicJsonData.screenLabels['reporter.common.From'];
		var toLbl=appConstants.publicJsonData.screenLabels['reporter.common.To'];

		var timePeriodLbl=appConstants.publicJsonData.screenLabels['reporter.common.Time period'];
		var reportGenerationLbl=appConstants.publicJsonData.screenLabels['reporter.common.Report Generation'];
		var reportNameLbl=appConstants.publicJsonData.screenLabels['reporter.common.Report Name'];
		var graphLbl=appConstants.publicJsonData.screenLabels['reporter.common.Graph'];

		var timeperiodLblObj = Ext.getCmp('timeperiodLbl');
		timeperiodLblObj.setText(timePeriodLbl);

		var fromTimeLblObj = Ext.getCmp('fromTimeLbl');
		fromTimeLblObj.setText(fromLbl);

		var fromHrsLblObj =  Ext.getCmp('fromHrsLbl');
		fromHrsLblObj.setText(hrsLbl);

		var toTimeLblObj = Ext.getCmp('toTimeLbl');
		toTimeLblObj.setText(toLbl);

		var toHrsLblObj =  Ext.getCmp('toHrsLbl');
		toHrsLblObj.setText(hrsLbl);

		var reportGenerationRawData = appConstants.publicJsonData['repGenOpts'];
		var reportGenObj = meSettingsForm.findField('reportGeneration');
		reportGenObj.getStore().loadRawData(reportGenerationRawData);
		reportGenObj.setValue(appConstants.publicJsonData.pageParams['er_reportgenration']);
		reportGenObj.setFieldLabel(reportGenerationLbl);
		if(appConstants.publicJsonData.pageParams['er_reportgenration']=='foreground')
		{
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
		else
		{
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}

		var reportNameObj = meSettingsForm.findField('bgReportName');
		reportNameObj.setFieldLabel(reportNameLbl);

		var timePeriodFromHrsObj = meSettingsForm.findField('timefrom');
		timePeriodFromHrsObj.setValue(appConstants.publicJsonData.pageParams.Hourfrom);

		var timePeriodFromMinsObj = meSettingsForm.findField('minfrom');
		timePeriodFromMinsObj.setValue(appConstants.publicJsonData.pageParams.Minfrom);

		var timePeriodToHrsObj = meSettingsForm.findField('timeto');
		timePeriodToHrsObj.setValue(appConstants.publicJsonData.pageParams.Hourto);

		var timePeriodToMinsObj = meSettingsForm.findField('minto');
		timePeriodToMinsObj.setValue(appConstants.publicJsonData.pageParams.Minto);

		var isShowDataCombo = appConstants.publicJsonData['pageParams']['showDataCombo'];

		if(isShowDataCombo!=null && isShowDataCombo=="true")
		{
			var showDataCombo = meSettingsForm.findField('showDataCombo');
			showDataCombo.getStore().loadRawData(appConstants.publicJsonData['dataOpts']);
			showDataCombo.setValue(appConstants.publicJsonData['pageParams']['selectedShowDataOption']);
			showDataCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Show Data']);
			showDataCombo.show();
		}
		var er_excwe = meSettingsForm.findField('er_excwe');
		er_excwe.getStore().loadRawData(appConstants.publicJsonData['yesNoOpts']);
		er_excwe.setValue("No");
		er_excwe.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Exclude weekends']);
		updatingAppSettings();
},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);
	},
	  changeEr_mode: function (combo) {
		var favorite_id = appConstants.publicJsonData['hiddenParams']["favorite_id"];
		var from_schModify = appConstants.publicJsonData['hiddenParams']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null')) {		return;
		}
		if(Ext.get('configMod')!=null){
		Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		}
		this.beforeReportSubmit();
	 },
	saveAsCSV : function()
	{
		var s_qryString = '../servlet/egurkha.reporter.SaveInCSVFormat?';
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	addTo : function(btn)
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var validateForm = this.validateForm();
		if(validateForm)
		{
			var er_timeline = mainForm.findField('er_timeline').getValue();
			/* if(er_timeline != null && er_timeline == "Any")
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidTimelineMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				 return;
			} */
			var target= '';
			var windowClass;
			var frameId;
			var btnID = btn.getId();
			this.updateQueryString('FavOrSchedule');
			var hiddenFields =  appConstants.publicJsonData["hiddenParams"];
			var from_favorite = hiddenFields["fromFavoriteModify"];
			if ((btnID != null && btnID == 'scheduleImg') || (appConstants.fromSchModify!=null && appConstants.fromSchModify == "Yes")) {
					target = "/final/reporter/ErSaveSchedule.jsp?isSchedule=true&"+appConstants.queryString+"&com.eg.CSRF_NONCE="+csrfToken;
				if (appConstants.menuForVM=='true')
				{
					target+='&menuForVM=true';
				}
				if (btnID=='save')
				{
					//document.location=s_qryString+'&showSchWindow=no';
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
				{
					if (appConstants.menuForVM=='true')
					{
						scheduleWindowFn(target);
					}
					else
					{
						parent.scheduleWindowFn(target);
					}
				}
			}
			else {
				var hiddenFields =  appConstants.publicJsonData["hiddenParams"];
				var favorite_id = hiddenFields["favorite_id"];
				target = "../servlet/com.eg.ErFavoriteC?er_view=GRAPH&cmd=client&"+appConstants.queryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;// + "&FavoriteId="+favorite_id;
				if (appConstants.menuForVM=='true')
				{
					target+='&menuForVM=true';
				}
				if (btnID=='save')
				{
					//document.location=s_qryString+'&showWindow=no'+'&FavoriteId='+favorite_id;
					target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
				{
					if (appConstants.menuForVM=='true')
					{ 
						favouriteWindowFn(target);
					}
					else
					{
						 parent.favouriteWindowFn(target); 
					} 
				} 
			}
		}
	},
	printReport : function()
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var selection = mainForm.findField('selectionCombo').getValue();
		var reportType = mainForm.findField('reportTypeCombo').getValue();
		var compType = mainForm.findField('compTypeCombo').getValue();
		var vmName = mainForm.findField('virtualMachineCombo').getValue();
		var vcName = mainForm.findField('virtualCenterCombo').getValue();

		var qryStr = "er_type="+reportType+'&ervm_disp='+selection+'&select_vm='+encodeURIComponent(vmName)+'&er_virtualcenter='+vcName;
		if (appConstants.isUserVmReport == 'yes')
		{
			qryStr +='&er_comptype='+appConstants.publicJsonData.selectedComptype+'&selectedCompType='+appConstants.publicJsonData.selectedComptype;
		} else
			qryStr +='&er_comptype='+compType;

		if(reportType!=null && reportType=="Yes")
		{
			var measureGrp = mainForm.findField('measure_group').getValue();

			qryStr = qryStr+'&er_measure='+measureGrp;
		}

		var er_component = new Array();
		er_component = Ext.getCmp('er_component').getValue();
		if (appConstants.isUserVmReport == 'yes')
		{
			er_component = appConstants.publicJsonData.selectedComponents;
		}
		
		for(var i=0; i<er_component.length;i++)
		{
			qryStr = qryStr+'&er_component='+encodeURIComponent(er_component[i]);
		}

		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
		var reportgen = appConstants.publicJsonData.pageParams['er_reportgenration'];
		var showData = appConstants.publicJsonData['pageParams']['selectedShowDataOption'];
		var excludeWeekEnd = "No";
		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdetailssettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			showData = settingsForm.findField('showDataCombo').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		var startdate = mainForm.findField('er_stdate').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;

		var stdateobj=new Date(Ext.Date.parse(startdate, mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(enddate, mgrDateFormat));
		var stDate = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var enDate = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var startHour = mainForm.findField('er_sthr').dataArray;
		var endHour = mainForm.findField('er_endhr').dataArray;
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var hiddenFields =  appConstants.publicJsonData["hiddenParams"];

		qryStr = qryStr+"&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&starthr="+encodeURIComponent(startHour)+"&endhr="+encodeURIComponent(endHour)+"&Hourto="+timePeriodToHrs+"&Minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd+"&Hourfrom="+timePeriodFromHrs+"&Minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&er_timeline="+encodeURIComponent(er_timeline);
		qryStr = qryStr+'&er_trenddata='+showData+'&pdfPrint=yes&'+'&sortduration='+encodeURIComponent(appConstants.publicJsonData['sortduration'])+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		if(Ext.getCmp('showLegend') != undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			qryStr=qryStr+'&showLegend='+islegendEnabled;
		}
		var s_qryString='/final/reporter/ErVMDetailsPrint.jsp?'+qryStr+'&isOnlyVMAssigned='+appConstants.publicJsonData.hiddenParams.isOnlyVMAssigned;
		if (appConstants.menuForVM=='true')
		{
			printWindowFn(s_qryString);
		}
		else
		{
			 parent.printWindowFn(s_qryString); 
		} 
	},
	savePdf : function()
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var selection = mainForm.findField('selectionCombo').getValue();
		var reportType = mainForm.findField('reportTypeCombo').getValue();
		var compType = mainForm.findField('compTypeCombo').getValue();
		var vmName = mainForm.findField('virtualMachineCombo').getValue();
		var vcName = mainForm.findField('virtualCenterCombo').getValue();

		var qryStr = "er_type="+reportType+'&ervm_disp='+selection+'&select_vm='+encodeURIComponent(vmName)+'&er_virtualcenter='+vcName;
		if (appConstants.isUserVmReport == 'yes')
		{
			qryStr +='&er_comptype='+appConstants.publicJsonData.selectedComptype+'&selectedCompType='+appConstants.publicJsonData.selectedComptype;
		} else
			qryStr +='&er_comptype='+compType;

		if(reportType!=null && reportType=="Yes")
		{
			var measureGrp = mainForm.findField('measure_group').getValue();
			qryStr = qryStr+'&er_measure='+measureGrp;
		}
		/* var er_component = Ext.getCmp('er_component').getValue();
		if (appConstants.isUserVmReport == 'yes')
		{
			qryStr = qryStr+'&er_component='+appConstants.publicJsonData.selectedComponents;
		} else
			qryStr = qryStr+'&er_component='+encodeURIComponent(er_component); */
		var er_component = new Array();
		er_component = Ext.getCmp('er_component').getValue();
		if (appConstants.isUserVmReport == 'yes')
		{
			er_component = appConstants.publicJsonData.selectedComponents;
		}
		
		for(var i=0; i<er_component.length;i++)
		{
			qryStr = qryStr+'&er_component='+encodeURIComponent(er_component[i]);
		}

		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
		var reportgen = appConstants.publicJsonData.pageParams['er_reportgenration'];
		var showData = appConstants.publicJsonData['pageParams']['selectedShowDataOption'];
		var excludeWeekEnd = "No";
		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdetailssettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			showData = settingsForm.findField('showDataCombo').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		var startdate = mainForm.findField('er_stdate').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;

		var stdateobj=new Date(Ext.Date.parse(startdate, mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(enddate, mgrDateFormat));
		var stDate = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var enDate = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));

		var startHour = mainForm.findField('er_sthr').dataArray;
		var endHour = mainForm.findField('er_endhr').dataArray;
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		qryStr = qryStr+"&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&starthr="+encodeURIComponent(startHour)+"&endhr="+encodeURIComponent(endHour)+"&Hourto="+timePeriodToHrs+"&Minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd+"&Hourfrom="+timePeriodFromHrs+"&Minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&er_timeline="+encodeURIComponent(er_timeline);
		qryStr = qryStr+'&er_trenddata='+showData+'&sortduration='+encodeURIComponent(appConstants.publicJsonData['sortduration'])+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		if(Ext.getCmp('showLegend') != undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			qryStr=qryStr+'&showLegend='+islegendEnabled;
		}
		var s_qryString='../reporter/ErHtmlToSavePdf.jsp?'+qryStr+'&inidate='+iniDateFormat+'&isOnlyVMAssigned='+appConstants.publicJsonData.hiddenParams.isOnlyVMAssigned;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var selection = mainForm.findField('selectionCombo').getValue();
		var reportType = mainForm.findField('reportTypeCombo').getValue();
		var compType = mainForm.findField('compTypeCombo').getValue();
		var vmName = mainForm.findField('virtualMachineCombo').getValue();
		var vcName = mainForm.findField('virtualCenterCombo').getValue();
		var qryStr = "er_type="+reportType+'&ervm_disp='+selection+'&select_vm='+encodeURIComponent(vmName)+'&er_virtualcenter='+vcName;
		if (appConstants.isUserVmReport == 'yes')
		{
			qryStr +='&er_comptype='+appConstants.publicJsonData.selectedComptype+'&selectedCompType='+appConstants.publicJsonData.selectedComptype;
		} else
			qryStr +='&er_comptype='+compType;
		if(reportType!=null && reportType=="Yes")
		{
			var measureGrp = mainForm.findField('measure_group').getValue();
			qryStr = qryStr+'&er_measure='+measureGrp;
		}
		/* var er_component = Ext.getCmp('er_component').getValue();
		if (appConstants.isUserVmReport == 'yes')
		{
			qryStr = qryStr+'&er_component='+appConstants.publicJsonData.selectedComponents;
		} else
			qryStr = qryStr+'&er_component='+encodeURIComponent(er_component); */
		var er_component = new Array();
		er_component = Ext.getCmp('er_component').getValue();
		if (appConstants.isUserVmReport == 'yes')
		{
			er_component = appConstants.publicJsonData.selectedComponents;
		}
		
		for(var i=0; i<er_component.length;i++)
		{
			qryStr = qryStr+'&er_component='+encodeURIComponent(er_component[i]);
		}
		if(Ext.getCmp('showLegend') != undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			qryStr=qryStr+'&showLegend='+islegendEnabled;
		}
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
		var reportgen = appConstants.publicJsonData.pageParams['er_reportgenration'];
		var showData = appConstants.publicJsonData['pageParams']['selectedShowDataOption'];
		var excludeWeekEnd = "No";
		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdetailssettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			showData = settingsForm.findField('showDataCombo').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		var startdate = mainForm.findField('er_stdate').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var stdateobj=new Date(Ext.Date.parse(startdate, mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(enddate, mgrDateFormat));
		var stDate = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var enDate = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var startHour = mainForm.findField('er_sthr').dataArray;
		var endHour = mainForm.findField('er_endhr').dataArray;
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		qryStr = qryStr+"&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&starthr="+encodeURIComponent(startHour)+"&endhr="+encodeURIComponent(endHour)+"&Hourto="+timePeriodToHrs+"&Minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd+"&Hourfrom="+timePeriodFromHrs+"&Minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&er_timeline="+encodeURIComponent(er_timeline);
		qryStr = qryStr+'&er_trenddata='+showData+'&sortduration='+encodeURIComponent(appConstants.publicJsonData['sortduration'])+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var s_qryString=qryStr+'&inidate='+iniDateFormat+'&isOnlyVMAssigned='+appConstants.publicJsonData.hiddenParams.isOnlyVMAssigned;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	validateAndCloseSettings :  function()
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var settingsForm = this.getVirtualmachinesdetailssettings().getForm();
		var timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
		var timePeriodFromMins = settingsForm.findField('minfrom').getValue();
		var timePeriodToHrs = settingsForm.findField('timeto').getValue();
		var timePeriodToMins = settingsForm.findField('minto').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		stDate.setHours(mainForm.findField('er_sthr').getValue());
		enDate.setHours(mainForm.findField('er_endhr').getValue());
		if(!checkTimePeriod(timePeriodFromHrs,timePeriodFromMins,timePeriodToHrs,timePeriodToMins))
		{
			return;
		}
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var reportgen = settingsForm.findField('reportGeneration').getValue();
		var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = appConstants.publicJsonData['hiddenParams']['er_usertimeline'];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}
		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				return false;
			}
		}
		var isSettingsOk = true;
		if(reportgen == 'background' || reportgen == 'background-csv')
		{
			var reportNameObj = settingsForm.findField('bgReportName');
			var reportName = reportNameObj.getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				return false;
			}
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			//Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			if (Ext.get('configMod')!=null)
			{
				Ext.get('configMod').animate({
				duration: 250,
					to: {
					y: -530
					}
				});
			}
			this.submitReport();
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
			var settingsForm = this.getVirtualmachinesdetailssettings().getForm();
			settingsForm.findField('reportGeneration').setValue('background');
			var reportNameObj = settingsForm.findField('bgReportName');
			reportNameObj.show();
			reportNameObj.focus();
			reportNameObj.setValue('');
			validateTextBoxWithSpecialChars(reportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	getTrendTimeLineOnChange : function(combo)
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		var op = combo.getValue();
		var me = this;
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + op + "]";
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param1,
				scope : this,
				async : true,
				success : function(response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					var comboVal=jsonData.combo;
					var timelineRawData = jsonData.combo;
					var timelineCombo = Ext.getCmp('er_timeline');
					timelineCombo.getStore().removeAll();
					timelineCombo.getStore().loadRawData(jsonData.combo);
					var flag=false;
					for(var i = 0; i < comboVal.length; i++)
					{
						if(comboVal[i].valueField == er_timeline)
						{
							flag=true;
						}
					}
					if(flag)
						timelineCombo.setValue(er_timeline);
					else
						timelineCombo.setValue("1 day");
				}
			});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = appConstants.publicJsonData['hiddenParams']['inidate'];
			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		if (op == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
			Ext.Ajax.request({
			url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
			params : param_val,
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonObject = Ext.decode(jsonText);
				var values = jsonObject.timeline;
				Ext.getCmp('er_stdate').dataArray=values[0];
				Ext.getCmp('er_enddate').dataArray=values[1];
				Ext.getCmp('er_sthr').dataArray=values[2];
				Ext.getCmp('er_endhr').dataArray=values[3]; 
				mgr_stmin = values[4];
				mgr_enmin = values[5];

				Ext.getCmp('er_stdate').setValue(values[6]);
				Ext.getCmp('er_enddate').setValue(values[7]); 
				Ext.getCmp('er_sthr').setValue(values[8]);
				Ext.getCmp('er_endhr').setValue(values[9]); 
				stmin =values[10];
				enmin = values[11];
				}
				});
		}
	},
	callRemoteScript: function( form, fieldName, remoteURL, no_params, funcName )
	{
		var me = this;
		var param = 'F='+funcName+'&C=jsrs1'+no_params+'&debug=true&U='+new Date().getTime()+'&fromajax=true';
		if(fieldName=='statustCombo')
			param = param+'&statusCombo=true';
			Ext.Ajax.request({
			url: remoteURL,
			method: 'POST',
			async: false,
			params: param,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var comboVal = jsonData['combo'];
					if ( !Ext.isEmpty( comboVal ) )
					{
						var thisStore = form.findField(fieldName).getStore();
						thisStore.loadRawData(comboVal);
						if(thisStore.getCount()>1)
						{
							thisStore.insert(0,{
							'displayField':allOptionMsg,
							'valueField':'-1'
							});
							form.findField(fieldName).setValue("-1");
						}
						else
						{
							form.findField(fieldName).setValue(comboVal[0]['valueField']);
						}
					}
					else
					{
						form.findField(fieldName).setValue(appConstants.notApplicableLbl);
					}
				}
			}
		});
	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Physical Servers',btn);
	},
	validateForm : function()
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var selection = mainForm.findField('selectionCombo').getValue();
		var reportType = mainForm.findField('reportTypeCombo').getValue();
		var compType = mainForm.findField('compTypeCombo').getValue();
		var vmName = mainForm.findField('virtualMachineCombo').getValue();
		var vcName = mainForm.findField('virtualCenterCombo').getValue();

		if(reportType!=null && reportType=="Yes")
		{
			var measureGrp = mainForm.findField('measure_group').getValue();
			if(measureGrp!=null && (measureGrp=="Not Applicable" || measureGrp=="-1"))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidMeasureGrpMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(selection!=null && selection=='Not Applicable')
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidSelectionMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			return false;
		}
		if(reportType!=null && reportType=='Not Applicable')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.invalidReportTypeMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(compType!=null && (compType=="Not Applicable" || compType=="-1") && appConstants.isUserVmReport != 'yes')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.invalidCompTypeMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(vmName!=null && (vmName=="Not Applicable" || vmName=="-1"))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.invalidVmMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(vcName!=null && (vcName=="Not Applicable" || vcName=="-1"))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.invalidVcMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var comps = "";
		var compArr = new Array();
		compArr = Ext.getCmp('er_component').getValue();
		var compQStr = '';
		if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				comps += compArr[i];
			}
		}
		comps = comps.substring(0,comps.length-1);
		if(comps!=null && (comps=="-1" || comps=="") && appConstants.isUserVmReport != 'yes' && compType!='Virtual_Machine')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.invalidComponentMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		return true;
	},
	beforeReportSubmit: function()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var startdate = Ext.getCmp('er_stdate').getValue();
		var starthr = Ext.getCmp('er_sthr').getValue();
		startdate.setHours(starthr);
		var enddate = Ext.getCmp('er_enddate').getValue();
		var endhr = Ext.getCmp('er_endhr').getValue();
		enddate.setHours(endhr);
		var result = checkDateTime(startdate, enddate);
		if (!result) {
			return;
		}
		var isValidForm = this.validateForm();
		if(isValidForm)
		{
			var fromSchedule =  appConstants.publicJsonData['hiddenParams']['fromSchedule'];
			if(fromSchedule!=null && fromSchedule=="Yes")
			{
				this.addTo(Ext.getCmp('scheduleImg'),null,null);
			}
			else
			{
				var reportgen = appConstants.publicJsonData.pageParams['er_reportgenration'];
				if (isSettingsEnabled)
				{
					reportgen = Ext.getCmp('reportGeneration').getValue();
				}
				if ( reportgen!=null && reportgen == 'foreground' )
				{
					var limitforbg = appConstants.publicJsonData['hiddenParams']['limitforbg'];
					if(!Ext.isEmpty(limitforbg))
					{
						var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
						var maxDaysInMonth = "";
						if(!Ext.isEmpty(getMaxDaysInMonth))
						{
							maxDaysInMonth = getMaxDaysInMonth;
						}
						if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,startdate,enddate))
						{
							Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						} else
							this.submitReport();
					} else
						this.submitReport();
				} else
					this.submitReport();
			}
		}
	},
	submitReport : function(combo)
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var reportType = mainForm.findField('reportTypeCombo').getValue();
		if(reportType=='Yes')
			Ext.getCmp('showLegend').show();
		var reportgen = appConstants.publicJsonData.pageParams['er_reportgenration'];
		var settingsForm;
		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdetailssettings().getForm();
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		var meController = this;
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv'))
		{
			var reportNameObj = settingsForm.findField('bgReportName');
			var reportName = reportNameObj.getValue();
			if(!validateTextBox(reportName))
			{
				this.showResult();
			}
		}
		this.updateQueryString('submit');
		if(reportgen!=null && reportgen == "foreground")
		{
			appConstants.queryString = appConstants.queryString+'&responseType=json&screenWidth='+(Ext.getBody().getViewSize().width)+"&screenHeight="+(Ext.getBody().getViewSize().height);
		}
		//by karthikeyan
		appConstants.queryString+= '&er_RmDispName='+appConstants.er_RmDispName
		appConstants.initLdgMask.show();
		Ext.Ajax.request({
			url : appConstants.urlForSubmit,
			params: appConstants.queryString,
			timeout : 180000,
			scope:this,
			success: function(response)
			{
				var jsonText  = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					appConstants.initLdgMask.hide();
					var jsonData=Ext.decode(jsonText);
					appConstants.publicJsonData = jsonData;
					meController.loadVmDetailsReportData(jsonData);
				}
			}
		});
	},
	loadVmDetailsReportData : function(jsonData)
	{
		var thisController=this;
		var reportgen = appConstants.publicJsonData.pageParams['er_reportgenration'];
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		var resultPanel = Ext.getCmp('resultPanel');
		var resultGridCont = Ext.getCmp('resultCont');
		resultPanel.removeAll();
		resultGridCont.removeAll();
		resultPanel.hide();
		resultGridCont.hide();
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();

		if(reportgen!=null && (reportgen == "background" || reportgen == "background-csv"))
		{
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("csvTool").setDisabled(false);

			var bgGroundMsg = jsonData.pageParams['bggroundStr'];
			var status = jsonData.pageParams['status'];
			var langSupportString = jsonData.pageParams['bgLangSupportStr'];
			var bgReportUrl = jsonData.pageParams['bgLinkUrl'];
			var bgreportlinkMsg = jsonData.pageParams['bgLinkMsg'];
			var tableTitle='';
			//var statusCssClass='iconSuccess';
			var statusCssClass='iconSuccess';
			if((status != null && status == "duplicate") || (bgGroundMsg!=null && bgGroundMsg == "User background report generationlimit is finished"))
			{
				//statusCssClass = 'iconExists';
				statusCssClass = 'iconExclamation';
			}
			//var htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:420px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="'+statusCssClass+'"></div><div style="margin-top:20px"><b>' + langSupportString + '</br><a href="' + bgReportUrl + '">' + bgreportlinkMsg + '</a></div></div></center>';
					//+ "</div>";
			var htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ langSupportString +'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bgreportlinkMsg + '</a></div></td></tr></table></td></tr></table>';
			this.getBackGroundPanel().update(htmlStr);
			this.getBackGroundPanel().show();
		}
		else
		{
			var dataAvailable = jsonData['dataAvailable'];
			if(dataAvailable!=null && dataAvailable=='true')
			{
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selDetailsJson);

				var er_type = jsonData['pageParams']['er_type'];
				if(er_type!=null && er_type=='Yes')
				{
					var showUtilities = jsonData['pageParams']['showUtilities'];
					resultGridCont.hide();
					if(showUtilities!=null && showUtilities=="Yes")
					{
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(true);
					}
					else
					{
						Ext.getCmp("saveTool").setDisabled(true);
						Ext.getCmp("bookletTool").setDisabled(true);
						Ext.getCmp("printTool").setDisabled(true);
						Ext.getCmp("mailTool").setDisabled(true);
						Ext.getCmp("csvTool").setDisabled(true);
					}

					var graphJsonObj = jsonData['graphJsonObj'];
					var graphMainTitle = graphJsonObj['graphMainTitle'];
					resultPanel.setTitle(graphMainTitle);
					var graphPanelArr = new Array();
					var graphsObj = graphJsonObj['graphsObj'];
					
					var chartType =jsonData['chartType'];
					var highChartUrls = new Array();
					var highChartdrilldwonUrls = new Array();
					var highChartIds = new Array();
					var chartURLs = new Array();
					var domArray = new Array();
					var content='<div  style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';//<col width="50%"><col width="50%">
					var col=0;
					for(var g in graphsObj)
					{
						var evenLastTd=false;
						var graphObj = graphsObj[g];
						var graphUrl = graphObj['graphUrl'];
						var graphCsvUrl = graphObj['graphCsvUrl'];
						var graphDataUrl = graphObj['graphDataUrl'];
						var graphDrillDownUrl = graphObj['graphDrillDownUrl'];
						var graphHeight = graphObj['graphHeight'];
						var graphWidth = graphObj['graphWidth'];
						var graphTitle = graphObj['graphTitle'];
						var graphTitleToolTip = graphObj['graphTitleToolTip'];
							
						chartURLs.push(graphUrl);
						if (col==2)
						{
							col=0;
							content+='</tr>';
							content+='<tr>';
						}
						if(g == 0){
							if (graphsObj.length>2)
							{
								content+='<td style="padding:0px 5px 5px 10px">';
							}
							else if(graphsObj.length==2)
							{
								content+='<td style="padding:0px 5px 10px 10px">';
							}
							else
							{
								content+='<td style="padding:0px 10px 10px 10px">';
							}
						}
						else if(g == 1){
							if (graphsObj.length>2)
							{
								content+='<td style="padding:0px 10px 5px 5px">';
							}
							else
							{
								content+='<td style="padding:0px 10px 10px 5px">';
							}
						}
						else if((g%2) == 0){
							if (g==graphsObj.length-1)
							{
								evenLastTd=true;
								content+='<td style="padding:5px 5px 10px 10px">';
							}
							else if (g==graphsObj.length-2)
							{
								content+='<td style="padding:5px 5px 10px 10px">';
							}
							else{
								content+='<td style="padding:5px 5px 5px 10px">';
							}
						}
						else if((g%2) != 0){
							if (g==graphsObj.length-1)
							{
								content+='<td style="padding:5px 10px 10px 5px">';
							}
							else{
								content+='<td style="padding:5px 10px 5px 5px">';
							}
						}
						content+='<div width="100%" class="graphMainDiv">';
						content+='<div class="htmlGraphTableHeader"><div style="float:left;width:75%" >';
						content+=graphTitle;
						content+='</div>';

						content+='<div style="float:right;margin:3px 0px 4px 5px">';
						content+='<div style="float:right;cursor:pointer;margin:0px 0px 0px 5px;" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+graphDrillDownUrl+'\');"></div>';
						content+='<div style="float:right;cursor:pointer;margin:0px 5px 0px 5px;" class="iconCsv" onclick="javascript:loadCSVWindow(\''+graphCsvUrl+'\');"></div>';
						content+='<div style="float:right;cursor:pointer;margin:0px 5px 0px 5px;" class="iconData" onclick="javascript:loadDataWindow(\''+graphDataUrl+'\');"></div>';
						content+='</div></div>';
						content+='<div class="headerBottomBorder"></div>';

						var dom='img_'+g;
						domArray.push(dom);

						content+='<div id="'+dom+'" style="height:225px" class="htmlGraphTableBody showDiv" >'; 
						if(chartType != "highchart")
						{
							content+='<img src="'+graphUrl+'"></img>';
						} 
						content+='</div>';
						content+='<div style="height:60px;margin-right: 10px;" id="commonLeg_'+dom+'" class="showDiv commonLeg">';
						content+='<div id="'+dom+'_legend" style="height:55px;width:100%;overflow:hidden;display:inline-block; vertical-align: middle;" class="showDiv">';
						content+='</div></div>';

						content+='</div></td>';
						if (evenLastTd)
						{
							content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
						}
						col++;
					}
					if (col==2)
					{
						content+='</tr>';
					}
					content+='</table></div>';
//					resultPanel.update(content);
					resultPanel.add({
						columnWidth:1,
						cls:'newChk',
						html:content,
						listeners:{
							boxready:function(){
								var islegendEnabled = Ext.getCmp('showLegend').getValue();
								if(islegendEnabled == "false" || islegendEnabled ==false){
									var elms = document.getElementsByClassName("commonLeg");
									for(var i = 0; i < elms.length; i++) {
										var chkkk=elms[i].id;
										var tmp_div=document.getElementById(chkkk);
										if(tmp_div != null && tmp_div != undefined)
											tmp_div.className=tmp_div.className.replace('showDiv', 'hideDiv');
									}
								}
							}
						}
					});

					if(chartType == "highchart"){
						for( var key in chartURLs){
							reportHighStockChart(chartURLs[key]+"&chartType="+chartType,domArray[key],'','','');
						}
					}
					resultPanel.doLayout();
					resultPanel.show();
				}
				else
				{
					resultGridCont.show();
					var showUtilities = jsonData['pageParams']['showUtilities'];
					if(showUtilities!=null && showUtilities=="Yes")
					{
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
					}
					else
					{
						Ext.getCmp("saveTool").setDisabled(true);
						Ext.getCmp("bookletTool").setDisabled(true);
						Ext.getCmp("printTool").setDisabled(true);
						Ext.getCmp("mailTool").setDisabled(true);
						Ext.getCmp("csvTool").setDisabled(true);
					}
					var gridJson = jsonData['gridJson'];
					if(!Ext.isEmpty(gridJson))
					{
						var gridArr = new Array();
						for(var gr in gridJson)
						{
							var gridObj = gridJson[gr];
							var gridTitle = gridObj['gridTitle'];
							var gridColumns = gridObj['gridColumns'];
							var mainColCount = gridObj['columnCount'];
							var gridData = gridObj['gridData'];
							var dispDataCount = 0;
							for(var v in gridData[0])
							{
								if(v.indexOf('_LINK')==-1)
								{
									dispDataCount++;
								}
							}
							var colCnt = 0;
							var mainColumnsObjArray =  new Array();
							var fieldstoStore =  new Array();
							var mainColumnFlex = 0.2;
							var otherColMinWidth = 100;
							var locked='';
							if(mainColCount!=null && mainColCount==2)
							{
								mainColumnFlex = 0.5;
								otherColMinWidth = 600;
							}
							if(mainColCount!=null && mainColCount<=5 )
							{
								for( var key in gridColumns )
								{
								var mainColumn=key;

								if(mainColumn!=null && mainColumn=='COLUMN_0')
								{
									fieldstoStore.push('DATAIND_0');
									if(appConstants.isUserVmReport != 'yes')
										fieldstoStore.push('DATAIND_0_LINK');
									var imgVal = gridColumns[key];
									mainColumnsObjArray.push({
										header: '<div class='+imgVal+'></div>',
										sortable:false,
										//locked:locked,
										dataIndex: 'DATAIND_0',
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var hrefUrl=record.get('DATAIND_'+col+'_LINK');
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
											if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-')
											{
												value = '<a class="anchorLinkDefault" href="'+hrefUrl+'">'+value+'</a>';
											}	
											//value = thisController.getDecimalAlignFormat(value);
											return value;
										},
											doSort: function(state) 
											{
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										}
									});
									colCnt++;
								}
								else
								{
									var subColLevel1Details = gridColumns[mainColumn];
									var mainColumnHeader = subColLevel1Details['Column_Name'];
									var subColLevel1Header = subColLevel1Details['Unit'];
									var subColLevel2Details = subColLevel1Details['subColumnsLevel2'];
									var subColLevel1Arr =  new Array();
									var subColLevel2Arr =  new Array();
									var mainColumnHeader1 = '';
									var i=0;
									var copyHeader = mainColumnHeader;
									var copyHeadrSplit = copyHeader.split(" ");
									var count = 0;
									for (i=0;i<copyHeadrSplit.length ;i++ )
									{
										count = count + copyHeadrSplit[i].length;
										if (count>16)
										{
											mainColumnHeader1 = mainColumnHeader1+ ' <br />';
											count=0;
										}
										mainColumnHeader1 = mainColumnHeader1+ ' ' + copyHeadrSplit[i];
										
										mainColumnHeader = mainColumnHeader1
									}
									if(!Ext.isEmpty(subColLevel2Details) && subColLevel2Details!="-")
									{
										for(var sc in subColLevel2Details)
										{
											var colHeader = subColLevel2Details[sc];
											//subColLevel2Arr.push({
											mainColumnsObjArray.push({
												//header: '<div style="background:#f5f5f5;width:100%;height:100%" width="100%" height="100%">'+mainColumnHeader+'<br/>'+colHeader+'  '+subColLevel1Header+'</div>',
												header: mainColumnHeader+'<br/>'+colHeader+'  '+subColLevel1Header,
												sortable:true,
												dataIndex: 'DATAIND_'+colCnt,
												align:'center',
												renderer: function(value, metaData, record, row, col, store, gridView)
												{
													metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
													var hrefUrl=record.get('DATAIND_'+col+'_LINK');
													if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-' && hrefUrl!="")
													{
														value = '<a href="javascript:void(0);" onclick="javascript:openNew(\''+hrefUrl+'\')">'+Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value,true)+'</a>';
													}
													value = Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value);
													return value;
											},
										doSort: function(state) {
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										}
											});
											fieldstoStore.push('DATAIND_'+colCnt);
											fieldstoStore.push('DATAIND_'+colCnt+'_LINK');
											colCnt++;
										}
									}
									else
									{
										fieldstoStore.push('DATAIND_'+colCnt+'_LINK');
										fieldstoStore.push('DATAIND_'+colCnt);
											//subColLevel2Arr.push({
											mainColumnsObjArray.push({
												header: mainColumnHeader+'<br/>'+'  '+subColLevel1Header,
												//header:subColLevel1Header,
											sortable:true,
											dataIndex: 'DATAIND_'+colCnt,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
												var hrefUrl=record.get('DATAIND_'+col+'_LINK');
												if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-' && hrefUrl!="")
												{
													value = '<a  href="javascript:void(0);" onclick="javascript:openNew(\''+hrefUrl+'\')">'+Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value,true)+'</a>';
												}
												value = Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value);
												return value;
											},
											doSort: function(state) {
												var ds = this.up('grid').store;
												var field = this.getSortParam();
												ds.sort({
													property: field,
													direction: state,
													sorterFn: function(v1, v2){
														if (v1.index==0)
															return;
														v1 = v1.get(field);
														v2 = v2.get(field);
														// transform v1 and v2 here
														return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
													}
												});
												},
										});
										colCnt++;
									}
										/*mainColumnsObjArray.push({
										header: mainColumnHeader,
										//locked:locked,
										sortable:true,
										columns: subColLevel2Arr
									});*/
								}
							}
							}
							else
							{
								for( var key in gridColumns ){
								var mainColumn=key;

								if(mainColumn!=null && mainColumn=='COLUMN_0')
								{
									fieldstoStore.push('DATAIND_0');
									fieldstoStore.push('DATAIND_0_LINK');
									var imgVal = gridColumns[key];
									mainColumnsObjArray.push({
										header: '<div class='+imgVal+'></div>',
										sortable:false,
										locked:true,
										dataIndex: 'DATAIND_0',
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var hrefUrl=record.get('DATAIND_'+col+'_LINK');
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
											if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-')
											{
												value = '<a class="anchorLinkDefault" href="'+hrefUrl+'">'+value+'</a>';
											}	
											//value = Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value);
											return value;
										},
											doSort: function(state) {

											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										}
									});
									colCnt++;
								}
								else
								{
									var subColLevel1Details = gridColumns[mainColumn];
									var mainColumnHeader = subColLevel1Details['Column_Name'];
									var subColLevel1Header = subColLevel1Details['Unit'];
									var subColLevel2Details = subColLevel1Details['subColumnsLevel2'];
									var subColLevel1Arr =  new Array();
									var subColLevel2Arr =  new Array();
									if(!Ext.isEmpty(subColLevel2Details) && subColLevel2Details!="-")
									{
										for(var sc in subColLevel2Details)
										{
											var colHeader = subColLevel2Details[sc];
											subColLevel2Arr.push({
											header: colHeader+'  '+subColLevel1Header,
											sortable:true,
											dataIndex: 'DATAIND_'+colCnt,
											align:'center',
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
												var hrefUrl=record.get('DATAIND_'+col+'_LINK');
												if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-' && hrefUrl!="")
												{
													value = '<a href="javascript:void(0);" onclick="javascript:openNew(\''+hrefUrl+'\')">'+Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value,true)+'</a>';
												}
												value = Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value);
												return value;
											},
								doSort: function(state) {
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										}
											});
											fieldstoStore.push('DATAIND_'+colCnt);
											fieldstoStore.push('DATAIND_'+colCnt+'_LINK');
											colCnt++;
										}
									}
									else
									{
										fieldstoStore.push('DATAIND_'+colCnt+'_LINK');
										fieldstoStore.push('DATAIND_'+colCnt);
										subColLevel2Arr.push({
											//header: '&nbsp;',
											 header:subColLevel1Header,
											sortable:true,
											dataIndex: 'DATAIND_'+colCnt,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
												var hrefUrl=record.get('DATAIND_'+col+'_LINK');
												if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-' && hrefUrl!="")
												{
													value = '<a href="javascript:void(0);" onclick="javascript:openNew(\''+hrefUrl+'\')">'+Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value,true)+'</a>';
												}
												value = Ext.getCmp('gridId'+gr).getDecimalAlignFormat(value);
												return value;
											},
								doSort: function(state) {

											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										},
											});
										colCnt++;
									}
									mainColumnsObjArray.push({
										header: mainColumnHeader,
										locked:false,
										sortable:true,
										columns: subColLevel2Arr
									});
								}
							}
							} 

							var store= new Ext.data.Store(
										{
											fields: fieldstoStore,
											data:gridData
										});
							marginVal = '0 0 10 0';	
							var gridpanel = Ext.widget('customgrid',{
										store:store,
										border:true,
										dispDataCount:dispDataCount,
										title:gridTitle,
										frame: false,
										id:'gridId'+gr,
										forceFit:true,
										padding:'0 10 10 10',
										needtoFixColumn:true,
										margin:marginVal,
										popUpData:'noToolTip',
										ui:'newGridPanel withHeader',
										columns:mainColumnsObjArray,
										forceFitColsCount:9,
										viewConfig: {
											getRowClass: function(record, rowIndex, rowParams, store)
											{
												 if (rowIndex==0)
													return 'firstRowClass'; //configured in ext-custom-com.css
											} 
										},
										listeners:{
											sortchange:function( ct, column, direction, eOpts ){
												thisController.gridColIndexParam=column.getIndex();
												thisController.gridColStateParam=column.sortState;
											}
										},
							});
							gridArr.push(gridpanel);
						}
						resultGridCont.add(gridArr);
						resultGridCont.doLayout();
					}
					var ervm_disp = jsonData['pageParams']['ervm_disp'];
					if((ervm_disp!=null && ervm_disp=='true') || (ervm_disp!=null && ervm_disp=='Yes'))
					{
						var gridObj = jsonData['gridObj'];
						if(gridObj!=undefined)
						{
							var gridTitle = gridObj['gridTitle'];
							var gridCols = gridObj['columns'];
							var gridData = gridObj['gridData'];
						var dispDataCount = 0;
						for(var v in gridData[0])
						{
							if(v.indexOf('_LINK')==-1)
							{
								dispDataCount++;
							}
						}
							var colCount = 0;
							var mainColumnsObjArray = new Array();
							var fieldstoStore = new Array();
							var mainColumnFlex = 0.2;
							var otherColMinWidth = 100;
							var gridColss = gridCols['ColumnName'];
							var gridColssUnits = gridCols['Unit'];
							for( var key in gridColss ){
								var mainColumn=key;
								if(mainColumn!=null && mainColumn=='COLUMN_0')
								{
									var subColLevel1Header = gridColssUnits[mainColumn+'_SUBCOLUMN'];
									var mainColumnHeader = gridColss[mainColumn];
									var subColLevel1Arr =  new Array();
									//fieldstoStore.push('COLUMN_'+colCount+'_URL');
									//fieldstoStore.push('COLUMN_'+colCount);
									fieldstoStore.push('COLUMN_0');
									fieldstoStore.push('COLUMN_0_URL');
									var imgVal = gridCols[key];
									mainColumnsObjArray.push({
										header:'<div class=vmotion></div>',
										//header:'<div class='+mainColumnHeader+'></div>',
										sortable:true,
										dataIndex: 'COLUMN_'+colCount,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var hrefUrl=record.get('COLUMN_'+col+'_URL');
											if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-')
											{
												//value = '<a href="javascript:void(0);" onclick="javascript:openNew(\''+hrefUrl+'\')">'+value+'</a>';
												value = '<a class="anchorLinkDefault" href="'+hrefUrl+'">'+value+'</a>';
											}
											return value;
										},
										doSort: function(state) {

													var ds = this.up('grid').store;
													var field = this.getSortParam();
													ds.sort({
														property: field,
														direction: state,
														sorterFn: function(v1, v2){
															if (v1.index==0)
																return;
															v1 = v1.get(field);
															v2 = v2.get(field);
															v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
															v1= isNaN(v1) ? 0 : v1;
															v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
															v2= isNaN(v2) ? 0 : v2;
															// transform v1 and v2 here
															return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
														}
													});
												}
										});
									  colCount++;
								}
								else
								{
									var subColLevelArray = new Array();
									var subColLevel2Details = gridColss[mainColumn];
									var subColLevel2Units = gridColssUnits[mainColumn+'_SUBCOLUMN'];
									
										//subColLevelArray.push({
											//header:subColLevel2Units,
										mainColumnsObjArray.push({
											header:subColLevel2Details+' <br /> '+subColLevel2Units,
											sortable:true,
											dataIndex: 'COLUMN_'+colCount,
											align:'center',
											doSort: function(state) {
												var ds = this.up('grid').store;
												var field = this.getSortParam();
												ds.sort({
													property: field,
													direction: state,
													sorterFn: function(v1, v2){
														if (v1.index==0)
															return;
														v1 = v1.get(field);
														v2 = v2.get(field);
														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v1= isNaN(v1) ? 0 : v1;
														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														v2= isNaN(v2) ? 0 : v2;
														// transform v1 and v2 here
														return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
													}
												});
											},
											renderer : function(value)	  //have to ask by prakash
											{
												value = Ext.getCmp('gridId_1').getDecimalAlignFormat(value);
												return value;
											}
										});
										fieldstoStore.push('COLUMN_'+colCount);
										fieldstoStore.push('COLUMN_'+colCount+'_URL');
										colCount++;
//									mainColumnsObjArray.push({
//										header: subColLevel2Details,
//										sortable:true,
//										columns: subColLevelArray
//									});
									
								}
									
							}
							var store=new Ext.data.Store({
								fields: fieldstoStore,
								data:gridData
							});
							var gridpanel = Ext.widget('customgrid',{
								store:store,
								title: gridTitle,
								frame: false,
								id:'gridId_1',
								border:true,
								dispDataCount:dispDataCount,
								needtoFixColumn:true,
								//margin:'10 10 10 10',
								ui:'newGridPanel withHeader',
								stripeRows: false,
								columns:mainColumnsObjArray,
								forceFitColsCount:9,
								/* viewConfig: {
								getRowClass: function(record, rowIndex, rowParams, store){
									 if (rowIndex==0)
										return 'firstRowClass'; //configured in ext-custom-com.css
									} 
								}, */
								listeners:{
									sortchange:function( ct, column, direction, eOpts ){
											thisController.gridColIndexParam=column.getIndex();
											thisController.gridColStateParam=column.sortState;
										}
									}
								});
							resultGridCont.add(gridpanel);
						}
					}
					resultGridCont.doLayout();
				}
			}
			else
			{
				resultGridCont.hide();
				resultPanel.hide();
				this.getNomeasurepanel().show();
			}
		}
	},
	showBackgroundReport: function(combo)
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var settingsForm = this.getVirtualmachinesdetailssettings().getForm();
		var val = combo.getValue();
		var reportNameObj = settingsForm.findField('bgReportName');
		if ( val == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else if ( val == 'background-csv' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	/*excludeWeekEnd : function(combo)
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		if(combo!=null && combo.getValue()=='Yes')
		{
			var excludeLbl = Ext.getCmp('excludeDays');
			excludeLbl.show();
		}
		else
		{
			Ext.getCmp('excludeDays').hide();
		}
	},*/
	groupComboChange : function(combo)
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var comboId = combo.getId();
		this.updateQueryString(comboId);
		var virtualMachineCombo = mainForm.findField('virtualMachineCombo');
		var virtualCenterCombo = mainForm.findField('virtualCenterCombo');
		var measure_group = mainForm.findField('measure_group');
		var er_component = Ext.getCmp('er_component');
		var reportType = mainForm.findField('reportTypeCombo').getValue();
		if(reportType=='No')
			Ext.getCmp('showLegend').hide();

		if(comboId!=null && comboId=='reportTypeCombo')
		{
			measure_group.hide();
		}
		var hiddenFields =  appConstants.publicJsonData["hiddenParams"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var er_favorite = hiddenFields["er_favorite"];
		appConstants.queryString += "&fromFavoriteModify="+from_favorite+"&fromScheduleModify="+from_schedule;
		if(er_favorite!=undefined)
			appConstants.queryString += "&er_favorite="+er_favorite;
		if(favorite_id!=undefined)
			appConstants.queryString += "&id="+favorite_id;
		Ext.Ajax.request({
				url : '/final/reporter/ErEsxGuestReportJson.jsp?er_type='+reportType,
				params: appConstants.queryString+"&action=loadControls",
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					
					appConstants.reporGene= jsonData;
					
					appConstants.publicJsonData = jsonData;
					if (isSettingsEnabled)
					{
						var reportGen = Ext.getCmp('reportGeneration');
						
						var reportGenCombo = jsonData.repGenOpts;
						var selreportGeneration = jsonData.repGenOpts[0].valueField;
						reportGen.setFieldLabel(jsonData['screenLabels']['reporter.common.Report Generation']);
						reportGen.getStore().loadRawData(reportGenCombo);
						if(selreportGeneration=='foreground')
						{
							Ext.getCmp('moreOptionCloseId').show();
							Ext.getCmp('submitViaSetting').hide();
						}
						else
						{
							Ext.getCmp('moreOptionCloseId').hide();
							Ext.getCmp('submitViaSetting').show();
						}
						reportGen.setValue(selreportGeneration);
						var reportNameObj = Ext.getCmp('bgReportName');
						if(selreportGeneration!=undefined && selreportGeneration!=null && selreportGeneration=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
					
					if(comboId!=null && comboId=='reportTypeCombo')
					{
						var compTypeCombo = mainForm.findField('compTypeCombo');
						compTypeCombo.getStore().clearFilter(true); 
						compTypeCombo.getStore().loadRawData(jsonData['compTypeJson']);
						compTypeCombo.setValue(jsonData['pageParams']['selectedCompType']);
						virtualMachineCombo.getStore().clearFilter(true);
						virtualMachineCombo.getStore().loadRawData(jsonData['vmOptsJson']);
						virtualMachineCombo.setValue(jsonData['pageParams']['selectedVM']);
						var showVcCombo = jsonData['pageParams']['showVcCombo'];
						if(showVcCombo!=null && showVcCombo=='true')
						{
							virtualCenterCombo.getStore().loadRawData(jsonData['vcOptsJson']);
							virtualCenterCombo.setValue(jsonData['pageParams']['selectedVc']);
							virtualCenterCombo.setFieldLabel(jsonData['screenLabels']['reporter.thin.Virtual Center']);
							virtualCenterCombo.show();
						}
						else
						{
							virtualCenterCombo.hide();
						}
						var er_type = appConstants.publicJsonData['pageParams']['er_type'];
						if(er_type!=null && er_type=='Yes')
						{
							measure_group.getStore().clearFilter(true);
							measure_group.getStore().loadRawData(jsonData['measureGroupOptsJson']);
							measure_group.setValue(jsonData['pageParams']['selectedMeasureGrp']);
							measure_group.setFieldLabel(jsonData['screenLabels']['reporter.vmdetails.Measure group']);
							measure_group.show();
						}
						appConstants.rawDataForComponents = jsonData['physicalServersOptsJson'];
						er_component.getStore().loadRawData(jsonData['physicalServersOptsJson']);
						er_component.setValue(appConstants.publicJsonData['pageParams']['selectedPhyServers']);
					}
					else if(comboId!=null && comboId=='compTypeCombo')
					{
						virtualMachineCombo.getStore().clearFilter(true);
						virtualMachineCombo.getStore().loadRawData(jsonData['vmOptsJson']);
						virtualMachineCombo.setValue(jsonData['pageParams']['selectedVM']);
						var showVcCombo = jsonData['pageParams']['showVcCombo'];
						if(showVcCombo!=null && showVcCombo=='true')
						{
							virtualCenterCombo.getStore().loadRawData(jsonData['vcOptsJson']);
							virtualCenterCombo.setValue(jsonData['pageParams']['selectedVc']);
							virtualCenterCombo.setFieldLabel(jsonData['screenLabels']['reporter.thin.Virtual Center']);
							virtualCenterCombo.show();
						}
						else
						{
							virtualCenterCombo.hide();
						}
						var er_type = appConstants.publicJsonData['pageParams']['er_type'];
						if(er_type!=null && er_type=='Yes')
						{
							measure_group.getStore().clearFilter(true);
							measure_group.getStore().loadRawData(jsonData['measureGroupOptsJson']);
							measure_group.setValue(jsonData['pageParams']['selectedMeasureGrp']);
							measure_group.setFieldLabel(jsonData['screenLabels']['reporter.vmdetails.Measure group']);
							measure_group.show();
						}
						appConstants.rawDataForComponents = jsonData['physicalServersOptsJson'];
						er_component.getStore().loadRawData(jsonData['physicalServersOptsJson']);
						er_component.setValue(appConstants.publicJsonData['pageParams']['selectedPhyServers']);
					}
					else if(comboId!=null && comboId=='virtualMachineCombo')
					{
						var showVcCombo = jsonData['pageParams']['showVcCombo'];
						if(showVcCombo!=null && showVcCombo=='true')
						{
							virtualCenterCombo.getStore().loadRawData(jsonData['vcOptsJson']);
							virtualCenterCombo.setValue(jsonData['pageParams']['selectedVc']);
							virtualCenterCombo.setFieldLabel(jsonData['screenLabels']['reporter.thin.Virtual Center']);
							virtualCenterCombo.show();
						}
						else
						{
							virtualCenterCombo.hide();
						}
						var er_type = appConstants.publicJsonData['pageParams']['er_type'];
						if(er_type!=null && er_type=='Yes')
						{
							measure_group.getStore().clearFilter(true);
							measure_group.getStore().loadRawData(jsonData['measureGroupOptsJson']);
							measure_group.show();
						}
						appConstants.rawDataForComponents = jsonData['physicalServersOptsJson'];
						er_component.getStore().loadRawData(jsonData['physicalServersOptsJson']);
						er_component.setValue(appConstants.publicJsonData['pageParams']['selectedPhyServers']);
					}
					else if(comboId!=null && comboId=='virtualCenterCombo')
					{
						var er_type = appConstants.publicJsonData['pageParams']['er_type'];
						if(er_type!=null && er_type=='Yes')
						{
							measure_group.getStore().clearFilter(true);
							measure_group.getStore().loadRawData(jsonData['measureGroupOptsJson']);
							measure_group.setValue(jsonData['pageParams']['selectedMeasureGrp']);
							measure_group.setFieldLabel(jsonData['screenLabels']['reporter.vmdetails.Measure group']);
							measure_group.show();
						}
						appConstants.rawDataForComponents = jsonData['physicalServersOptsJson'];
						er_component.getStore().loadRawData(jsonData['physicalServersOptsJson']);
						er_component.setValue(appConstants.publicJsonData['pageParams']['selectedPhyServers']);
					}
				}
		});
	},
	updateQueryString : function(from)
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var selection = mainForm.findField('selectionCombo').getValue();
		var reportType = mainForm.findField('reportTypeCombo').getValue();
		var compType = mainForm.findField('compTypeCombo').getValue();
		var vmName = mainForm.findField('virtualMachineCombo').getValue();
		var vcName = mainForm.findField('virtualCenterCombo').getValue();

		if(from!=null && from=='FavOrSchedule')
		{
			if(vmName.indexOf("&")>-1)
				vmName=vmName.replace(/&/g,'|amp|');
			if(vmName.indexOf("%")>-1)
				vmName=vmName.replace(/%/g,'|pct|');
			if(vmName.indexOf("+")>-1)
				vmName=vmName.replace(/\+/g,'|plus|');
			if(vmName.indexOf("#")>-1)
				vmName=vmName.replace(/#/g,'|hash|');
		}
		if (appConstants.isUserVmReport == 'yes')
		{
			compType = appConstants.publicJsonData.selectedComptype;
		}
		var qryStr = "er_type="+reportType+'&ervm_disp='+selection+'&er_comptype='+compType;

		if(from=="reportTypeCombo" || from=="virtualMachineCombo" || from=="submit" || from=='FavOrSchedule')
		{
			qryStr = qryStr+'&select_vm='+vmName;
		}
		if(from=="reportTypeCombo" || from=="virtualCenterCombo" || from=="submit" || from=='FavOrSchedule')
		{
			qryStr = qryStr+'&er_virtualcenter='+vcName;

			/* var er_component = Ext.getCmp('er_component').getValue();
			if (appConstants.isUserVmReport == 'yes')
			{
				qryStr = qryStr+'&er_component='+appConstants.publicJsonData.selectedComponents;
			} else
				qryStr = qryStr+'&er_component='+encodeURIComponent(er_component); */
			var er_component = new Array();
			er_component = Ext.getCmp('er_component').getValue();
			if (appConstants.isUserVmReport == 'yes')
			{
				er_component = appConstants.publicJsonData.selectedComponents;
			}
			
			for(var i=0; i<er_component.length;i++)
			{
				qryStr = qryStr+'&er_component='+encodeURIComponent(er_component[i]);
			}

			if(reportType!=null && reportType=="Yes")
			{
				var measureGrp = mainForm.findField('measure_group').getValue();

				qryStr = qryStr+'&er_measure='+measureGrp;
			}
		}
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
		var reportgen = appConstants.publicJsonData.pageParams['er_reportgenration'];
		var showData = appConstants.publicJsonData['pageParams']['selectedShowDataOption'];
		var excludeWeekEnd = "No";
		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdetailssettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			showData = settingsForm.findField('showDataCombo').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		var startdate = mainForm.findField('er_stdate').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var startHour = mainForm.findField('er_sthr').dataArray;
		var endHour = mainForm.findField('er_endhr').dataArray;
		var er_timeline = mainForm.findField('er_timeline').getValue();
		var stdateobj=new Date(Ext.Date.parse(startdate, mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(enddate, mgrDateFormat));
		var startdate_ddmmyyyy = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var enddate_ddmmyyyy = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		qryStr = qryStr+"&er_stdate="+encodeURIComponent(startdate)+"&er_enddate="+encodeURIComponent(enddate)+"&er_sthr="+encodeURIComponent(startHour)+"&er_endhr="+encodeURIComponent(endHour)+"&st_date="+startdate_ddmmyyyy+"&en_date="+enddate_ddmmyyyy+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&er_timeline="+encodeURIComponent(er_timeline)+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		qryStr = qryStr+'&er_trenddata='+showData;

		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+encodeURIComponent(hiddenData[hid]);
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			qryStr = qryStr+hiddenQstr;
		}
		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			reportName=checkFileName(reportName);
			qryStr = qryStr+'&forwardto=ErEsxGuestReportJson&bg_reportname='+encodeURIComponent(reportName);
			appConstants.urlForSubmit = '../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true';
		}
		else if ( reportgen!=null && reportgen == 'background-csv' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			reportName=checkFileName(reportName);
			qryStr = qryStr+'&forwardto=ErEsxGuestReportJson&bg_reportname='+encodeURIComponent(reportName);
			appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
		}
		else
		{
			qryStr = qryStr+'&forwardto=ErEsxGuestReport';
			appConstants.urlForSubmit = "../servlet/com.eg.ErEsxVMServerReportC?isSubmit=true";
		}
		if(Ext.getCmp('showLegend') != undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			qryStr=qryStr+'&showLegend='+islegendEnabled;
		}
		appConstants.queryString = qryStr;
	},
	changeSelection : function()
	{
		var mainForm = this.getVirtualmachinesdetailsmainform().getForm();
		var selectionCombo = mainForm.findField('selectionCombo');
		var reportTypeCombo = mainForm.findField('reportTypeCombo');
		var compTypeCombo = mainForm.findField('compTypeCombo');
		var virtualMachineCombo = mainForm.findField('virtualMachineCombo');
		var virtualCenterCombo = mainForm.findField('virtualCenterCombo');
		var measure_group = mainForm.findField('measure_group');
		var er_component =Ext.getCmp('er_component');

		var selection = selectionCombo.getValue();
		var report_type = reportTypeCombo.getValue();
		var compType= compTypeCombo.getValue();
		var virtualMachine = virtualMachineCombo.getValue();

		var qStr = 'er_type='+report_type+'&ervm_disp='+selection+'&select_vm='+virtualMachine+'&er_comptype='+compType;

		var s_stdate= mainForm.findField('er_stdate').dataArray;
		var s_enddate= mainForm.findField('er_enddate').dataArray;
		var startdate = mainForm.findField('er_stdate').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var stdateobj=new Date(Ext.Date.parse(startdate, mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(enddate, mgrDateFormat));
		var startdate_ddmmyyyy = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var enddate_ddmmyyyy = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		qStr = qStr+"&er_stdate="+startdate+"&er_enddate="+enddate+"&er_stdate="+startdate+"&er_enddate="+enddate+"&st_date="+startdate_ddmmyyyy+"&en_date="+enddate_ddmmyyyy+"&er_timeline="+er_timeline;

		var hiddenFields =  appConstants.publicJsonData["hiddenParams"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var er_favorite = hiddenFields["er_favorite"];
		qStr += "&fromFavoriteModify="+from_favorite+"&fromScheduleModify="+from_schedule;
		if(er_favorite!=undefined)
				qstr += "&er_favorite="+er_favorite;
		if(favorite_id!=undefined)
				qStr += "&id="+favorite_id;

		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		Ext.Ajax.request({
				url : '/final/reporter/ErEsxGuestReportJson.jsp',
				params: qStr+"&action=loadControls",
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicJsonData = jsonData;

					selectionCombo.getStore().loadRawData(jsonData['selectionOptsJson']);
					selectionCombo.setValue(jsonData['pageParams']['ervm_disp']);

					reportTypeCombo.getStore().loadRawData(jsonData['repTypeOptsJson']);
					reportTypeCombo.setValue(jsonData['pageParams']['er_type']);

					compTypeCombo.getStore().clearFilter(true);
					compTypeCombo.getStore().loadRawData(jsonData['compTypeJson']);
					compTypeCombo.setValue(jsonData['pageParams']['selectedCompType']);

					virtualMachineCombo.getStore().clearFilter(true);
					virtualMachineCombo.getStore().loadRawData(jsonData['vmOptsJson']);
					virtualMachineCombo.setValue(jsonData['pageParams']['selectedVM']);

					var showVcCombo = jsonData['pageParams']['showVcCombo'];
					if(showVcCombo!=null && showVcCombo=='true')
					{
						virtualCenterCombo.getStore().loadRawData(jsonData['vcOptsJson']);
						virtualCenterCombo.setValue(jsonData['pageParams']['selectedVc']);
						virtualCenterCombo.setFieldLabel(jsonData['screenLabels']['reporter.thin.Virtual Center']);
						virtualCenterCombo.show();
					}
					else
					{
						virtualCenterCombo.hide();
					}
					var er_type = appConstants.publicJsonData['pageParams']['er_type'];
					if(er_type!=null && er_type=='Yes')
					{
						measure_group.getStore().clearFilter(true);
						measure_group.getStore().loadRawData(jsonData['measureGroupOptsJson']);
						measure_group.setValue(jsonData['pageParams']['selectedMeasureGrp']);
						measure_group.setFieldLabel(jsonData['screenLabels']['reporter.vmdetails.Measure group']);
						measure_group.show();
					}
					er_component.getStore().loadRawData(jsonData['physicalServersOptsJson']);
					er_component.setValue(appConstants.publicJsonData['pageParams']['selectedPhyServers']);
				}
		});
	},
	boxready: function () {
		var meController = this;
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJsonData['screenLabels']['pageTitle']);
		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true')
		{
			var er_reportgenration1 = appConstants.publicJsonData['pageParams']['er_reportgenration'];
			if(er_reportgenration1!=null && (er_reportgenration1!="background" || er_reportgenration1!="background"))
			{
				meController.loadVmDetailsReportData(appConstants.publicJsonData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.beforeReportSubmit();
			}
		}
	},
	loadDefaults: function () {
		var meController = this;
		Ext.getCmp('er_mode').hide();
		var hiddenFields = appConstants.publicJsonData["hiddenParams"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if (appConstants.isUserVmReport != 'yes')
		{
			Ext.getCmp("selectionCombo").show();
			Ext.getCmp("compTypeCombo").show();
			Ext.getCmp("compContainer").show();
		}
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		this.getVirtualmachinesdetailsmainform().loadData();
		if(appConstants.publicJsonData['pageParams']['selectedShowDataOption']=='Yes')
		{
			isTrend= true;
		}
		stmin = appConstants.publicJsonData['pageParams']['startMinForDisplay'];
		enmin = appConstants.publicJsonData['pageParams']['endMinForDisplay'];
		mgr_enmin = appConstants.publicJsonData['pageParams']['endmin'];
		mgr_stmin = appConstants.publicJsonData['pageParams']['startmin'];

		if(!hideBackButton){
			Ext.getCmp('virtualmachinesdetailsmainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		if(Ext.getCmp('showLegend') != undefined){
		if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			  Ext.getCmp('showLegend').setValue(true);
		}
	},
	refreshReportData: function () {
		if (appConstants.isSubmit != null && appConstants.isSubmit == "true") {
			appConstants.initLdgMask.show();
			this.loadReportData(appConstants.publicjsonData);
		}
	},
	fillFormFields:function(jsonData){
		var screenLabels = jsonData.screenLabels;
		var comboRawData;
		var selectedComboOption;
		var comboObject;

		comboRawData = jsonData.anlyzeCombo;
		selectedComboOption = jsonData.er_type;
		comboObject = Ext.getCmp('er_option');
		comboObject.setFieldLabel(screenLabels['reporter.common.Analyze by']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.compTypeCombo;
		selectedComboOption = jsonData.er_comptype;
		comboObject = Ext.getCmp('er_comptype');
		comboObject.setFieldLabel(screenLabels['reporter.common.Component Type']);
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.componentCombo;
		selectedComboOption = jsonData.er_component;
		comboObject = Ext.getCmp('er_component');
		Ext.getCmp('componentsLbl').setText(screenLabels['reporter.common.Component']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.showVmCombo;
		selectedComboOption = jsonData.er_showVms;
		comboObject = Ext.getCmp('er_showVms');
		comboObject.setFieldLabel(screenLabels['reporter.common.Show VMs']);
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		Ext.getCmp('lowLimitLbl').setFieldLabel(screenLabels['reporter.common.Low Utilization Limit']);
		Ext.getCmp('underMinimum').setValue(jsonData.underMinimum);
		Ext.getCmp('underMinimum').setFieldLabel(screenLabels['reporter.common.Minor']);
		Ext.getCmp('underMajor').setValue(jsonData.underMajor);
		Ext.getCmp('underMajor').setFieldLabel(screenLabels['reporter.common.Major']);
		Ext.getCmp('underCritical').setValue(jsonData.underCritical);
		Ext.getCmp('underCritical').setFieldLabel(screenLabels['reporter.common.Critical']);
		Ext.getCmp('highLimitLbl').setFieldLabel(screenLabels['reporter.common.High Utilization Limit']);
		Ext.getCmp('upperminimum').setValue(jsonData.upperminimum);
		Ext.getCmp('upperminimum').setFieldLabel(screenLabels['reporter.common.Minor']);
		Ext.getCmp('uppermajor').setValue(jsonData.uppermajor);
		Ext.getCmp('uppermajor').setFieldLabel(screenLabels['reporter.common.Major']);
		Ext.getCmp('upperCritical').setValue(jsonData.upperCritical);
		Ext.getCmp('upperCritical').setFieldLabel(screenLabels['reporter.common.Critical']);

		comboRawData = jsonData.applylimitCombo;
		selectedComboOption = jsonData.er_utilizationFor;
		comboObject = Ext.getCmp('er_utilizationFor');
		Ext.getCmp('applylimitlbl').setText(screenLabels['reporter.common.Apply Limits']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		Ext.getCmp('timefrom').setValue(jsonData.selectedTimeFrom);
		Ext.getCmp('minfrom').setValue(jsonData.selectedMinsFrom);
		Ext.getCmp('timeto').setValue(jsonData.selectedTimeTo);
		Ext.getCmp('minto').setValue(jsonData.selectedMinsTo);

		var timelineRawData = jsonData.timelineCombo;
		var selectedTimeline = jsonData.selectedTimeline;
		var timelineObj = Ext.getCmp('er_timeline');
		timelineObj.getStore().loadRawData(timelineRawData);
		if (!Ext.isEmpty(timelineRawData)) {
			if (!Ext.isEmpty(selectedTimeline)) {
				timelineObj.setValue(selectedTimeline);
			} else {
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(start_date);
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(start_hour);
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(end_date);
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(end_hour);
		var reportGenCombo = appConstants.repoGene.reportGenerationCombo;
		var selreportGeneration = appConstants.repoGene.reportGeneration;
		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
		if(selreportGeneration=='foreground')
		{
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
		else
		{
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
	},
	hideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //csv
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //close
			);
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
	}
});