Ext.define('VirtualMachinesDetailsApp.view.VirtualMachinesDetailsMainForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.virtualmachinesdetailsmainform',
    id: 'virtualmachinesdetailsmainform',
	 defaults: {
		labelAlign: 'top',
		margin:'0 20 10 0',
		labelSeparator: ''
	},
	 layout: 'column',
    items: [
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable: false,
				name: 'selectionCombo',
				id: 'selectionCombo',
				fieldLabel: 'Selection',
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				width: 90,
				editable: false,
				name: 'reportTypeCombo',
				id: 'reportTypeCombo',
				fieldLabel: 'Report Type',
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable: true,
				name: 'compTypeCombo',
				id: 'compTypeCombo',
				fieldLabel: 'Component Type',
				listConfig:{
							emptyText:noComponentTypeMatch
						},
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable: true,
				name: 'virtualMachineCombo',
				id: 'virtualMachineCombo',
				fieldLabel: 'Virtual Machine',
				listConfig:{
							emptyText:noVirtualMachinesMatch
						},
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable: false,
				name: 'virtualCenterCombo',
				id: 'virtualCenterCombo',
				fieldLabel: 'Virtual Center',
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden : true
			},
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable: true,
				name: 'measure_group',
				id: 'measure_group',
				listConfig:{
							emptyText:noMeasureMatch
						},
				fieldLabel: 'Measure Group',
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden :  true
			},
			{
				xtype:'checkbox',
				cls: 'checkbt',
				margin: '21 20 10 0',
				boxLabel: showLegends,
				inputValue: 'true',
				id: 'showLegend',
				listeners:{
					change:function(){
						var elms = document.getElementsByClassName("commonLeg");
						var graphCount=elms.length;
						if(graphCount %2 !=0)
							graphCount=((graphCount-1)/2)+1;
						else if(graphCount >= 2)
							graphCount=graphCount/2;
						else
							graphCount=1;
						var panel_div = document.getElementsByClassName("newChk");
						if(panel_div != null && panel_div != undefined && panel_div.length > 0 && panel_div.length <=1){
							var panel_id=panel_div[0].id;
							var grph_Pnl=Ext.getCmp(panel_id);
							if(grph_Pnl != undefined){
								var pnlHeight=grph_Pnl.getHeight();
								var xtraHeight=graphCount*60;
								if(this.checked){
									var heght=pnlHeight+xtraHeight;
									grph_Pnl.setHeight(heght);
								}
								else{
									var heght=pnlHeight-xtraHeight;
									grph_Pnl.setHeight(heght);
								}
							}
						}
					}
				}
			},
			{
				xtype:'timeline',margin:0,width:550
			}

		],
	loadData : function()
	{
		var thisForm = this.getForm();
		var selectionCombo = thisForm.findField('selectionCombo');
		var reportTypeCombo = thisForm.findField('reportTypeCombo');
		var compTypeCombo = thisForm.findField('compTypeCombo');
		var virtualMachineCombo = thisForm.findField('virtualMachineCombo');
		var virtualCenterCombo = thisForm.findField('virtualCenterCombo');
		var measure_group = thisForm.findField('measure_group');
		var er_component = Ext.getCmp('er_component');
 		selectionCombo.getStore().loadRawData(appConstants.publicJsonData['selectionOptsJson']);
		selectionCombo.setValue(appConstants.publicJsonData['pageParams']['ervm_disp']);
		selectionCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Selection']);
		reportTypeCombo.getStore().loadRawData(appConstants.publicJsonData['repTypeOptsJson']);
		reportTypeCombo.setValue(appConstants.publicJsonData['pageParams']['er_type']);
		reportTypeCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Report Type']);

		compTypeCombo.getStore().loadRawData(appConstants.publicJsonData['compTypeJson']);
		compTypeCombo.setValue(appConstants.publicJsonData['pageParams']['selectedCompType']);
		compTypeCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.thin.Component Type']);

		virtualMachineCombo.getStore().loadRawData(appConstants.publicJsonData['vmOptsJson']);
		virtualMachineCombo.setValue(appConstants.publicJsonData['pageParams']['selectedVM']);
		virtualMachineCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.esx.Virtual Machine']);

		var showVcCombo = appConstants.publicJsonData['pageParams']['showVcCombo'];
		if(showVcCombo!=null && showVcCombo=='true')
		{
			virtualCenterCombo.getStore().loadRawData(appConstants.publicJsonData['vcOptsJson']);
			virtualCenterCombo.setValue(appConstants.publicJsonData['pageParams']['selectedVc']);
			virtualCenterCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.thin.Virtual Center']);
			virtualCenterCombo.show();
		}
		else
		{
			virtualCenterCombo.hide();
		}

		var er_type = appConstants.publicJsonData['pageParams']['er_type'];

		if(er_type!=null && er_type=='Yes')
		{
			measure_group.getStore().loadRawData(appConstants.publicJsonData['measureGroupOptsJson']);
			measure_group.setValue(appConstants.publicJsonData['pageParams']['selectedMeasureGrp']);
			measure_group.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.vmdetails.Measure group']);
			measure_group.show();
		}

		er_component.getStore().loadRawData(appConstants.publicJsonData['physicalServersOptsJson']);
		appConstants.rawDataForComponents = appConstants.publicJsonData['physicalServersOptsJson'];
		er_component.setValue(appConstants.publicJsonData['pageParams']['selectedPhyServers']);

		var phyServersLbl = Ext.getCmp('phyServersLbl');
		phyServersLbl.setText(appConstants.publicJsonData['screenLabels']['reporter.common.Physical Servers']);


		var hrsLbl=appConstants.publicJsonData.screenLabels['reporter.common.Hrs'];
		var fromLbl=appConstants.publicJsonData.screenLabels['reporter.common.From'];
		var toLbl=appConstants.publicJsonData.screenLabels['reporter.common.To'];
		var timelineLbl=appConstants.publicJsonData.screenLabels['reporter.common.Timeline'];

		var er_mode = thisForm.findField('er_mode');
		er_mode.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.common.Graph']);

		var timelineJSONArray = appConstants.publicJsonData['timelineComboArray'];
		var timeLineComboObj = thisForm.findField('er_timeline');
		timeLineComboObj.getStore().loadRawData(timelineJSONArray);
		timeLineComboObj.setValue(appConstants.publicJsonData.pageParams.selectedTimeline);


		var startdateObj = thisForm.findField('er_stdate');
		var enddateObj = thisForm.findField('er_enddate');
		var startHourObj = thisForm.findField('er_sthr');
		var endHourObj = thisForm.findField('er_endhr');

		var stDate = appConstants.publicJsonData.pageParams['startDateJSON'];
		var endDate = appConstants.publicJsonData.pageParams['endDateJSON'];
		var startHr = appConstants.publicJsonData.pageParams['startHourJSON'];
		var endHr = appConstants.publicJsonData.pageParams['endHourJSON'];

		startdateObj.setValue(appConstants.publicJsonData.pageParams['startDateForDisplay']);
		startdateObj.dataArray=stDate;
		enddateObj.setValue(appConstants.publicJsonData.pageParams['endDateForDisplay']);
		enddateObj.dataArray=endDate;
		startHourObj.setValue(appConstants.publicJsonData.pageParams['startHourForDisplay']);
		startHourObj.dataArray=startHr;
		endHourObj.setValue(appConstants.publicJsonData.pageParams['endHourForDisplay']);
		endHourObj.dataArray=endHr;

	}

})