
var chartcount = 1;
Ext.define('VirtualMachinesDistApp.controller.Main',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort  by option
    requires: ['VirtualMachinesDistApp.view.Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'virtualmachinesdistmainform', ref: 'virtualmachinesdistmainform'},
		{selector: 'virtualmachinesdistsettings', ref: 'virtualmachinesdistsettings'},
		{selector: 'resultpanel', ref: 'resultpanel'},
		{selector: 'mainform', ref: 'mainform'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'main newUtilities':
			{
				'afterrender': this.hideTools
			},
			'main':
			{
				'boxready': this.loadDefaults
			},
			'virtualmachinesdistmainform':
			{
				'afterrender': this.afterMainRender
			},
			'virtualmachinesdistsettings':
			{
				'afterrender':this.afterSettingsRender
			},
			'virtualmachinesdistmainform combo[id="er_rtype"]':
			{
				'select': this.changeReportType
			},
			'virtualmachinesdistmainform combo[id="er_comptype"]':
			{
				'select': this.changeComponentType
			},
			'virtualmachinesdistmainform combo[id="zone"]':
			{
				'select': this.changeZone
			},
			'virtualmachinesdistmainform combo[id="segment"]':
			{
				'select': this.changeSegment
			},
			'virtualmachinesdistmainform combo[id="service"]':
			{
				'select': this.changeService
			},
			'virtualmachinesdistmainform combo[id="subzone"]':
			{
				'select': this.changeSubZone
			},
			'virtualmachinesdistmainform combo[id="select_group"]':
			{
				'select': this.changeAnalysis
			},
			'virtualmachinesdistsettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekEnd
			},
			
			'virtualmachinesdistsettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'virtualmachinesdistsettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualmachinesdistsettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'mainform button[itemId="submit"]':
			{
				'click': this.formSubmit
			},
			'mainform button[itemId="save"]':
			{
				'click': this.goTo
			},
			'virtualmachinesdistsettings combo[id="er_trenddata"]':
			{
				'select': this.changeTrend
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.callCSV
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
			'egcomponent button[id="expandSelector"]':
			{
				'click': this.expandMe
			},			
			'timeline combo[name="er_mode"]':
			 {
				'select': this.changeEr_mode
			 },
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		//layout:'vbox',
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		//html:tpl.apply(),
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'virtualmachinesdistsettings',
				itemId: 'settingsForm',
				parent:this
			}
		],
		renderTo:'virtualmachinesdist'
		});
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			me.validateAndCloseSettings();
		});
		
	},
	validateAndCloseSettings:function()
	{
		var result = this.validateSettings();
		if(result)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.formSubmit(Ext.getCmp('mainform').getComponent('submit'));
		}
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('component'),appConstants.rawDataForComponents);
    },
      changeEr_mode: function (combo) {
		var favorite_id = appConstants.publicJSON['hiddens']["favorite_id"];
		var from_schModify = appConstants.publicJSON['hiddens']["fromScheduleModify"];
		if ((favorite_id != null) || !(from_schModify == null || from_schModify == 'null')) 
		{
			return;
		}
		this.formSubmit(Ext.getCmp('mainform').getComponent('submit'));
     },
	goTo: function (obj) {
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'VirtualMachines Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
 		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		this.updateQueryString(obj);
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites(obj);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.showSchedules(obj);
		}
    },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('component'),'Components',btn);
	},
	showFavorites: function(obj)
	{
		this.updateQueryString();
		var qString = appConstants.queryString;
		qString += '&isSubmit=true';
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var favorite_id = hiddenFields["favorite_id"];
		var target = '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client'+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId='+favorite_id;
		if (obj.getItemId()=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	showSchedules: function(obj)
	{
		this.updateQueryString();
		var qString = appConstants.queryString;
		var from_schModify = appConstants.publicJSON['hiddens']["fromScheduleModify"];
       		 if (from_schModify != null && from_schModify == "Yes") {
			this.updateQStringForSchedule();
			qString = qstringForSch;
 		}
		var target = '/final/reporter/ErSaveSchedule.jsp?'+qString+'&com.eg.CSRF_NONCE='+csrfToken;
		if (obj.getItemId()=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 		parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	callCSV: function()
	{
		document.location = '/final/servlet/egurkha.reporter.SaveInCSVFormat?reporttype=csvHead';
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	printMe: function()
	{

		parent.printWindowFn( appConstants.publicJSON['PRINT_URL']+'&pdfPrint=yes'); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	saveMe: function()
	{
		var saveQString = appConstants.publicJSON['PDF_URL'];
        saveQString += "&er_width=450&er_height=250";
		
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicJSON['PDF_URL'];
        saveQString += "&er_width=450&er_height=250";
        var s_qryString = saveQString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	changeTrend: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
		var er_trenddata=Ext.getCmp('er_trenddata').getValue();
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = appConstants.publicJSON["hiddens"]['inidate'];
			

			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}

		/////////////////////////////
	},
	getHiddenQstr: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}

			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	beforeSubmit: function()
	{
		var er_comptype = Ext.getCmp('er_comptype').getValue();
		var select_group = Ext.getCmp('select_group').getValue();
		var msg = '';
		var getVal = Ext.getCmp('er_rtype').getValue();
		if ( er_comptype == '-1' )
		{
			msg = appConstants.requiredParameters;
		}
		else if ( select_group == 'Zone' && Ext.getCmp('zone').getValue() == '-1' )
		{
			msg = appConstants.chooseZone;
		}
		else if ( select_group == 'Segment' && Ext.getCmp('segment').getValue() == '-1' )
		{
			msg = appConstants.chooseSegment;
		}
		else if ( select_group == 'Service' && Ext.getCmp('service').getValue() == '-1' )
		{
			msg = appConstants.chooseService;
		}
		else if ( select_group == 'Component' && ( Ext.getCmp('component').getValue() == '-1' || Ext.getCmp('component').getValue().length == 0 ) )
		{
			msg = appConstants.chooseComp;
		}
		else if ( getVal == 'Yes' && Ext.getCmp('select_testMeasure').getValue() == '-1' )
		{
			msg = appConstants.chooseMeasure;
		}

		if ( !Ext.isEmpty( msg ) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		return true;
	},
	updateQueryString : function(obj){
		var qstr = this.getHiddenQstr();
		var fromSubmit = false;
		var actionFrom = '';
		if ( !Ext.isEmpty( obj ) )
		{
			actionFrom = obj.getId();
		}
		if ( actionFrom == 'er_rtype' )
		{
			fromReportType = true;
		}
		else if ( actionFrom == 'select_group' )
		{
			fromAnalysis = true;
		}
		else if ( actionFrom == 'er_comptype' )
		{
			fromCompType = true;
		}
		else if ( actionFrom == 'er_timeline' )
		{
			fromTimeline = true;
		}
		else if ( actionFrom == 'er_trenddata' )
		{
			fromTrend = true;
		}
		else if ( actionFrom == 'submit' )
		{

			if ( !this.beforeSubmit() )
			{
				return;
			}
			appConstants.initLdgMask.show();
			fromSubmit = true;
		}

		var mainForm = this.getVirtualmachinesdistmainform().getForm();
		var er_mode = mainForm.findField('er_mode').getValue();
		var er_rtype = mainForm.findField('er_rtype').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var er_stdate = mainForm.findField('er_stdate').dataArray;
		var er_enddate =mainForm.findField('er_enddate').dataArray;
		var er_sthr = mainForm.findField('er_sthr').dataArray;
		var er_endhr = mainForm.findField('er_endhr').dataArray;

		var selectedData = appConstants.publicJSON['selectedValues'];

		var timefromVal = selectedData['timePeriodHourFrom'];
		var timetoVal = selectedData['timePeriodHourTo'];
		var minfromVal = selectedData['timePeriodMinFrom'];
		var mintoVal = selectedData['timePeriodMinTo'];
		var er_reportgenrationVal = selectedData['reportGenSelected'];
		var bgReportNameVal = '';
		var er_trenddata = selectedData['showDataSelected'];
		var er_excwe = selectedData['excludeWeekSelected'];

		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdistsettings().getForm();
			timefromVal = settingsForm.findField('timefrom').getValue();
			timetoVal = settingsForm.findField('timeto').getValue();
			minfromVal = settingsForm.findField('minfrom').getValue();
			mintoVal = settingsForm.findField('minto').getValue();
			er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
			bgReportNameVal = settingsForm.findField('bgReportName').getValue();
			er_trenddata = settingsForm.findField('er_trenddata').getValue();
			er_excwe = settingsForm.findField('er_excwe').getValue();
			bgReportNameVal=checkFileName(bgReportNameVal);
		}

		var select_group = mainForm.findField('select_group').getValue();
		
	var select_groupName = Ext.getCmp(select_group.toLowerCase()).getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_showby = mainForm.findField('er_showby').getValue();
		var select_testMeasure = mainForm.findField('select_testMeasure').getValue();
		var insubzone = mainForm.findField('subzone').getValue();
		if ( select_group == 'Component' )
		{
			if ( !Ext.isEmpty ( select_groupName ) )
			{
				for ( var i = 0; i < select_groupName.length ; i++ )
				{
					qstr += '&select_groupName='+encodeURIComponent(select_groupName[i]);
				}

			}
		}
		else
		{
			qstr += '&select_groupName='+encodeURIComponent(select_groupName);
		}
		qstr +='&er_mode='+encodeURIComponent(er_mode)+'&er_rtype='+encodeURIComponent(er_rtype)
			  +'&er_timeline='+er_timelineVal+'&startdate='+encodeURIComponent(er_stdate)+'&enddate='+encodeURIComponent(er_enddate)
			  +'&starthr='+er_sthr+'&endhr='+er_endhr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&er_reportgenration='+encodeURIComponent(er_reportgenrationVal)
			  +'&bg_reportname='+encodeURIComponent(bgReportNameVal)+'&minfrom='+minfromVal
			  +'&select_group='+encodeURIComponent(select_group)+'&er_trenddata='+encodeURIComponent(er_trenddata)
			  +'&minto='+encodeURIComponent(mintoVal)+'&timeto='+encodeURIComponent(timetoVal)
			  +'&er_comptype='+encodeURIComponent(er_comptype)
			  +'&er_excwe='+encodeURIComponent(er_excwe)+'&er_showby='+encodeURIComponent(er_showby)
			  +'&select_testMeasure='+encodeURIComponent(select_testMeasure)+'&timefrom='+timefromVal+'&er_sortBy=-1&insubzone='+encodeURIComponent(insubzone);

		var remoteURL = '/final/reporter/ErVmGuestStatusReportJSON.jsp';
		if ( fromSubmit )
		{
			if ( er_reportgenrationVal == 'background' )
			{
				remoteURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				qstr += '&forwardto=ErVmGuestStatusReportJSON';
			}
			else if ( er_reportgenrationVal == 'background-csv' )
			{
				remoteURL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				qstr += '&forwardto=ErVmGuestStatusReportJSON';
			}
			else
			{
				remoteURL = '/final/servlet/com.eg.ErVmGuestStatusServletC';
			}
			qstr += '&isSubmit=true';
		}
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var er_favorite = hiddenFields["er_favorite"];
		qstr += "&fromFavoriteModify="+from_favorite+"&fromScheduleModify="+from_schedule+"&er_favorite="+er_favorite +"&id="+favorite_id;

		appConstants.queryString = qstr;
		
	},
	formSubmit: function( obj )
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var er_usertimeline = appConstants.publicJSON['hiddens']['er_usertimeline'];
		var getMaxDaysInMonth = appConstants.publicJSON['hiddens']['getMaxDaysInMonth'];
		var startdate = Ext.getCmp('er_stdate').getValue();
        var starthr = Ext.getCmp('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = Ext.getCmp('er_enddate').getValue();
        var endhr = Ext.getCmp('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  startdate, enddate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var limitforbg = appConstants.publicJSON['hiddens']['limitforbg'];
		var selectedData = appConstants.publicJSON['selectedValues'];
		var reportgenVal = selectedData['reportGenSelected'];
		if (isSettingsEnabled)
		{
			reportgenVal = Ext.getCmp('reportGeneration').getValue();
		}
		var isSettingsOk = true;
		if ( !Ext.isEmpty( obj ) )
		{
			if (obj.getItemId()=='submit')
			{
				appConstants.actionFrom = obj.getItemId();
			}
			else
			appConstants.actionFrom = obj.getId();
		}
		if ( reportgenVal == 'foreground' )
		{
			if ( !Ext.isEmpty(limitforbg ) )
			{
				if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,startdate,enddate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
				} else
					this.generateresult();
			} else
					this.generateresult();
		} else
					this.generateresult();
	},
	generateresult : function() {
		var selectedData = appConstants.publicJSON['selectedValues'];
		var reportgenVal = selectedData['reportGenSelected'];
		if (isSettingsEnabled)
		{
			reportgenVal = Ext.getCmp('reportGeneration').getValue();
		}
		/*if ( reportgenVal == 'background' )//|| reportgenVal == 'background-csv')
		{
			if (!validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
			{
				return;
			}
		}*/
		var me = this;
		var mainForm = this.getVirtualmachinesdistmainform().getForm();
		var settingsForm;


		var fromReportType = false;
		var fromAnalysis = false;
		var fromCompType = false;
		var fromTimeline = false;
		var fromTrend = false;
		var fromSubmit = false;
		if ( appConstants.actionFrom == 'er_rtype' )
		{
			fromReportType = true;
		}
		else if ( appConstants.actionFrom == 'select_group' )
		{
			fromAnalysis = true;
		}
		else if ( appConstants.actionFrom == 'er_comptype' )
		{
			fromCompType = true;
		}
		else if ( appConstants.actionFrom == 'er_timeline' )
		{
			fromTimeline = true;
		}
		else if ( appConstants.actionFrom == 'er_trenddata' )
		{
			fromTrend = true;

		}
		else if ( appConstants.actionFrom == 'submit' || appConstants.fromDailyMailer ||appConstants.fromDailyMailer == 'true' )
		{

			if ( !this.beforeSubmit() )
			{
				return;
			}
			appConstants.initLdgMask.show();
			fromSubmit = true;
		}
		var qstr = this.getHiddenQstr();

		var timefromVal = selectedData['timePeriodHourFrom'];
		var timetoVal = selectedData['timePeriodHourTo'];
		var minfromVal = selectedData['timePeriodMinFrom'];
		var mintoVal = selectedData['timePeriodMinTo'];
		var er_reportgenrationVal = selectedData['reportGenSelected'];
		var bgReportNameVal = '';
		var er_trenddata = selectedData['showDataSelected'];
		var er_excwe = selectedData['excludeWeekSelected'];
		var er_showLegend = false;

		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdistsettings().getForm();
			timefromVal = settingsForm.findField('timefrom').getValue();
			timetoVal = settingsForm.findField('timeto').getValue();
			minfromVal = settingsForm.findField('minfrom').getValue();
			mintoVal = settingsForm.findField('minto').getValue();
			er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
			bgReportNameVal = settingsForm.findField('bgReportName').getValue();
			er_trenddata = settingsForm.findField('er_trenddata').getValue();
			er_excwe = settingsForm.findField('er_excwe').getValue();
			er_showLegend = mainForm.findField('showLegend').getValue();
			bgReportNameVal=checkFileName(bgReportNameVal);
		}
		var er_mode = mainForm.findField('er_mode').getValue();
		var er_rtype = mainForm.findField('er_rtype').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var er_stdate = mainForm.findField('er_stdate').dataArray;
		var er_enddate =mainForm.findField('er_enddate').dataArray;
		var er_sthr = mainForm.findField('er_sthr').dataArray;
		var er_endhr = mainForm.findField('er_endhr').dataArray;
		//var timefromVal = settingsForm.findField('timefrom').getValue();
		//var timetoVal = settingsForm.findField('timeto').getValue();
		//var minfromVal = settingsForm.findField('minfrom').getValue();
		//var mintoVal = settingsForm.findField('minto').getValue();
		//var er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
		//var bgReportNameVal = settingsForm.findField('bgReportName').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		//var er_trenddata = settingsForm.findField('er_trenddata').getValue();
		var select_groupName = Ext.getCmp(select_group.toLowerCase()).getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		if((appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true') && appConstants.analysisby != null && appConstants.analysisby == 'ComponentType')
			er_comptype = appConstants.analysis;
		//var er_excwe = settingsForm.findField('er_excwe').getValue();
		var er_showby = mainForm.findField('er_showby').getValue();
		var select_testMeasure = mainForm.findField('select_testMeasure').getValue();
		var insubzone = mainForm.findField('subzone').getValue();
		if ( appConstants.actionFrom == 'er_comptype' ){
			select_group = 'Component';
			select_groupName = 'component';
		}
		if ( select_group == 'Component' )
		{
			if ( !Ext.isEmpty ( select_groupName ) )
			{
				for ( var i = 0; i < select_groupName.length ; i++ )
				{
					qstr += '&select_groupName='+encodeURIComponent(select_groupName[i]);
				}
			}
		}
		else
		{
			qstr += '&select_groupName='+encodeURIComponent(select_groupName);
		}
		qstr +='&er_mode='+encodeURIComponent(er_mode)+'&er_rtype='+encodeURIComponent(er_rtype)
			  +'&er_timeline='+er_timelineVal+'&startdate='+encodeURIComponent(er_stdate)+'&enddate='+encodeURIComponent(er_enddate)
			  +'&starthr='+er_sthr+'&endhr='+er_endhr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&er_reportgenration='+encodeURIComponent(er_reportgenrationVal)
			  +'&bg_reportname='+encodeURIComponent(bgReportNameVal)+'&minfrom='+minfromVal
			  +'&select_group='+encodeURIComponent(select_group)+'&er_trenddata='+encodeURIComponent(er_trenddata)
			  +'&minto='+encodeURIComponent(mintoVal)+'&timeto='+encodeURIComponent(timetoVal)
			  +'&er_comptype='+encodeURIComponent(er_comptype)
			  +'&showLegend='+encodeURIComponent(er_showLegend)
			  +'&er_excwe='+encodeURIComponent(er_excwe)+'&er_showby='+encodeURIComponent(er_showby)
			  +'&select_testMeasure='+encodeURIComponent(select_testMeasure)+'&timefrom='+timefromVal+'&er_sortBy=-1&insubzone='+encodeURIComponent(insubzone);

//by karthikeyan
	qstr+= '&er_RmDispName='+appConstants.er_RmDispName
		var remoteURL = '/final/reporter/ErVmGuestStatusReportJSON.jsp';
		if ( fromSubmit )
		{
			if ( er_reportgenrationVal == 'background' )
			{
				remoteURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				qstr += '&forwardto=ErVmGuestStatusReportJSON';
			}
			else if ( er_reportgenrationVal == 'background-csv' )
			{
				remoteURL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				qstr += '&forwardto=ErVmGuestStatusReportJSON';
			}
			else
			{
				remoteURL = '/final/servlet/com.eg.ErVmGuestStatusServletC';
			}
			qstr += '&isSubmit=true';

			
		
		}
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var er_favorite = hiddenFields["er_favorite"];
		qstr += "&fromFavoriteModify="+from_favorite+"&fromScheduleModify="+from_schedule;

		if(er_favorite!=undefined)
				qstr += "&er_favorite="+er_favorite;

		if(favorite_id!=undefined)
				qstr += "&id="+favorite_id;

		appConstants.queryString = qstr;
		qstr +='&call=json';

		if ( appConstants.fromSchedule == 'Yes' && fromSubmit )
		{
			document.location = '/final/reporter/ErSaveSchedule.jsp?'+qstr;
		}
		Ext.Ajax.request({
			url: remoteURL,
			method: 'POST',
			params: qstr,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
				
					appConstants.publicJSON = Ext.decode( jsonText );
					if ( fromReportType )
					{
						var measureCombo = appConstants.publicJSON['measureCombo'];
						var measureSelected = appConstants.publicJSON['selectedValues']['measureSelected']
						if ( !Ext.isEmpty( measureCombo ) )
						{
							me.setValueWithOptionInList(mainForm, 'select_testMeasure', measureCombo, measureSelected);
						}

						var showCombo = appConstants.publicJSON['showCombo'];
						var showSelected = appConstants.publicJSON['selectedValues']['showSelected'];
						if ( !Ext.isEmpty( showCombo ) )
						{
							me.setValueWithOptionInList(mainForm, 'er_showby', showCombo, showSelected);
						}
					}
					else if (fromAnalysis)
					{	
						if ( select_group == 'Zone' )
						{
							var selectedGroupCombo = appConstants.publicJSON['selectedGroupCombo'];
							appConstants.rawDataForComponents = selectedGroupCombo;
							mainForm.findField(select_group.toLowerCase()).getStore().clearFilter(true); 
							mainForm.findField(select_group.toLowerCase()).getStore().loadRawData(selectedGroupCombo);
							mainForm.findField(select_group.toLowerCase()).setValue(selectedGroupCombo[0]['valueField']);
							
							var subzoneData = appConstants.publicJSON['subzoneCombo'];
							mainForm.findField('subzone').getStore().loadRawData(subzoneData);
							mainForm.findField('subzone').setValue(appConstants.publicJSON['selectedValues']['subzoneSelected']);
						}
					}
					else if ( fromCompType )
					{
						var compObj = Ext.getCmp('compContainer');
						var zoneObj = Ext.getCmp('zone');
						var subzoneObj = Ext.getCmp('subzone');
						var segmentObj = Ext.getCmp('segment');
						var serviceObj = Ext.getCmp('service');
						zoneObj.hide();
						subzoneObj.hide();
						segmentObj.hide();
						serviceObj.hide();
						compObj.show();

						var measureCombo = appConstants.publicJSON['measureCombo'];
						if(!mainForm.findField('select_testMeasure').isHidden() && !Ext.isEmpty(measureCombo)){
							mainForm.findField('select_testMeasure').getStore().clearFilter(true); 
							mainForm.findField('select_testMeasure').getStore().loadRawData(measureCombo);
							if(measureCombo.length>0)
							mainForm.findField('select_testMeasure').setValue(measureCombo[0]['valueField']);
						}


						var selectedGroupCombo = appConstants.publicJSON['selectedGroupCombo'];
							appConstants.rawDataForComponents = selectedGroupCombo;

						if ( !Ext.isEmpty( selectedGroupCombo ) )
						{
  							me.setValueForComponent('component', selectedGroupCombo, '');
							var analysisCombo = appConstants.publicJSON['analysisCombo'];
							me.setValueWithOptionInList( mainForm, 'select_group', analysisCombo, 'Component');
						}
					}
					/*else if ( fromTimeline || fromTrend )
					{
						var timelineCombo = appConstants.publicJSON['timelineCombo']
						if ( !Ext.isEmpty( timelineCombo ) )
						{
							var selectedTimeline = appConstants.publicJSON.selectedValues['selectedTimeline'];
							me.setValueWithOptionInList(mainForm, 'er_timeline', timelineCombo, selectedTimeline);
						}
						var er_stdateObj = mainForm.findField('er_stdate');
						var er_sthrObj = mainForm.findField('er_sthr');
						
						

						var er_enddateObj = mainForm.findField('er_enddate');
						var er_endhrObj = mainForm.findField('er_endhr');

						mgr_stmin =selectedData['startmin'];
						mgr_enmin = selectedData['endmin'];
						var start_hour = appConstants.publicJSON['selectedValues']['startHour'];
						var end_hour = appConstants.publicJSON['selectedValues']['endHour'];
                        var start_date = appConstants.publicJSON['selectedValues']['startDate'];
                        var end_date = appConstants.publicJSON['selectedValues']['endDate'];
						
				
						if ( !Ext.isEmpty( appConstants.publicJSON['selectedValues']['startDate'] ) )
						{
							er_stdateObj.suspendEvents(true);
							if(selectedTimeline!='Any')
							er_stdateObj.setValue(appConstants.publicJSON['selectedValues']['startDateForDisplay']);
							er_stdateObj.resumeEvents();
							er_stdateObj.dataArray = start_date;
						}
						if ( !Ext.isEmpty( appConstants.publicJSON['selectedValues']['endDate'] ) )
						{
							er_enddateObj.suspendEvents(true);
							er_enddateObj.setValue(appConstants.publicJSON['selectedValues']['endDateForDisplay']);
							er_enddateObj.resumeEvents();
							er_stdateObj.dataArray = end_date;

						}
						if(er_trenddata=='No')
						{
						if ( !Ext.isEmpty( appConstants.publicJSON['selectedValues']['startHour'] ) )
						{
							er_sthrObj.suspendEvents(true);
							er_sthrObj.setValue(appConstants.publicJSON['selectedValues']['startHourForDisplay']);
							er_sthrObj.resumeEvents();
							er_sthrObj.dataArray=start_hour;
						}
						if ( !Ext.isEmpty( appConstants.publicJSON['selectedValues']['endHour'] ) )
						{
							er_endhrObj.suspendEvents(true);
							er_endhrObj.setValue(appConstants.publicJSON['selectedValues']['endHourForDisplay']);
							er_endhrObj.resumeEvents();
							er_endhrObj.dataArray=end_hour;
							}
						}
						else
						{
							er_sthrObj.setValue("00");
							er_sthrObj.dataArray="00";
							er_endhrObj.setValue("00");
							er_endhrObj.dataArray="00";
						}
					}*/
					else if ( fromSubmit )
					{
						appConstants.timlineChartType = appConstants.publicJSON['chartType'];
						Ext.select('.dataPanel').setStyle('border-width','1px');
						me.getResultpanel().hide();
						Ext.getCmp('multiGraphPanel').hide();
						me.getNomeasurepanel().hide();
						me.getBackGroundPanel().hide();
						if ( er_reportgenrationVal == 'foreground' )
						{
							if ( !Ext.isEmpty( appConstants.publicJSON['RESULTS'] ) )
							{
								var results = appConstants.publicJSON['RESULTS'];
								if ( er_rtype == 'Yes' )
								{
									me.loadChart( results );
								}
								else
								{
									me.loadGridWithChart( results );
								}




								me.enableTools();
							}
							else
							{
								Ext.getCmp('panelinsidetoggle').setDisabled(true);
								var resultObj = me.getResultpanel();
								Ext.getCmp('gridContainer').hide();
								Ext.getCmp('multiGraphPanel').hide();
								resultObj.hide();
								me.getNomeasurepanel().doLayout();
								me.getNomeasurepanel().show();
							}
						}
						else
						{
							Ext.getCmp('gridContainer').hide();
							me.getResultpanel().hide();
							var backgroundResults = appConstants.publicJSON['backgroundResults'];
							me.loadBackground( backgroundResults );
						}
						appConstants.initLdgMask.hide();
					}
				}
			},
			failure: function()
			{
				callWindow(1);
			}
		});

	},
	updateQStringForSchedule:function () {
		var mainForm = this.getVirtualmachinesdistmainform().getForm();
		var settingsForm;

		var qstr = this.getHiddenQstr();

		var er_mode = mainForm.findField('er_mode').getValue();
		var er_rtype = mainForm.findField('er_rtype').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var er_stdate = mainForm.findField('er_stdate').dataArray;
		var er_enddate =mainForm.findField('er_enddate').dataArray;
		var er_sthr = mainForm.findField('er_sthr').dataArray;
		var er_endhr = mainForm.findField('er_endhr').dataArray;
		var select_group = mainForm.findField('select_group').getValue();
		//var select_groupName = mainForm.findField(select_group.toLowerCase()).getValue();
		var select_groupName = mainForm.findField('select_group').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_showby = mainForm.findField('er_showby').getValue();
		var select_testMeasure = mainForm.findField('select_testMeasure').getValue();
		var insubzone = mainForm.findField('subzone').getValue();

		var selectedData = appConstants.publicJSON['selectedValues'];

		var timefromVal = selectedData['timePeriodHourFrom'];
		var timetoVal = selectedData['timePeriodHourTo'];
		var minfromVal = selectedData['timePeriodMinFrom'];
		var mintoVal = selectedData['timePeriodMinTo'];
		var er_reportgenrationVal = selectedData['reportGenSelected'];
		var bgReportNameVal = '';
		var er_trenddata = selectedData['showDataSelected'];
		var er_excwe = selectedData['excludeWeekSelected'];

		if (isSettingsEnabled)
		{
			settingsForm = this.getVirtualmachinesdistsettings().getForm();
			timefromVal = settingsForm.findField('timefrom').getValue();
			timetoVal = settingsForm.findField('timeto').getValue();
			minfromVal = settingsForm.findField('minfrom').getValue();
			mintoVal = settingsForm.findField('minto').getValue();
			er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
			bgReportNameVal = settingsForm.findField('bgReportName').getValue();
			er_trenddata = settingsForm.findField('er_trenddata').getValue();
			er_excwe = settingsForm.findField('er_excwe').getValue();
			bgReportNameVal=checkFileName(bgReportNameVal);
		}
		if ( select_group == 'Component' )
		{
			if ( !Ext.isEmpty ( select_groupName ) )
			{
				for ( var i = 0; i < select_groupName.length ; i++ )
				{
					qstr += '&select_groupName='+encodeURIComponent(select_groupName[i]);
				}
			}
		}
		else
		{
			qstr += '&select_groupName='+encodeURIComponent(select_groupName);
		}
		qstr +='&er_mode='+encodeURIComponent(er_mode)+'&er_rtype='+encodeURIComponent(er_rtype)
			  +'&er_timeline='+er_timelineVal+'&startdate='+encodeURIComponent(er_stdate)+'&enddate='+encodeURIComponent(er_enddate)
			  +'&starthr='+er_sthr+'&endhr='+er_endhr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&er_reportgenration='+encodeURIComponent(er_reportgenrationVal)
			  +'&bg_reportname='+encodeURIComponent(bgReportNameVal)+'&minfrom='+minfromVal
			  +'&select_group='+encodeURIComponent(select_group)+'&er_trenddata='+encodeURIComponent(er_trenddata)
			  +'&minto='+encodeURIComponent(mintoVal)+'&timeto='+encodeURIComponent(timetoVal)
			  +'&er_comptype='+encodeURIComponent(er_comptype)
			  +'&er_excwe='+encodeURIComponent(er_excwe)+'&er_showby='+encodeURIComponent(er_showby)
			  +'&select_testMeasure='+encodeURIComponent(select_testMeasure)+'&timefrom='+timefromVal+'&er_sortBy=-1&insubzone='+encodeURIComponent(insubzone);
		if( er_reportgenrationVal == 'background' || er_reportgenrationVal == 'background-csv')
		{
			qstr += '&forwardto=ErVmGuestStatusReportJSON';
		}
		qstringForSch = qstr;
	},
	loadBackground: function ( results )
	{
 		var backgroundResultsData = results;
		if ( !Ext.isEmpty( backgroundResultsData ) )
		{
			var backgroundResultStatus = backgroundResultsData['status'];
			var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
			var backgroundResultURL = backgroundResultsData['backgroundResponseURLLink'];
			var backgroundResultURLLinkText = backgroundResultsData['backgroundResponseURLText'];
			var htmlStr = '';
			if ( backgroundResultStatus == 'success' )
			{
				//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			else if ( backgroundResultStatus == 'duplicate' )
			{
				//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			this.getBackGroundPanel().update(htmlStr);
 			this.getBackGroundPanel().show();
			this.disableTools();
		}
	},
	loadGridWithChart: function( results )
	{
		var me=this;
		var resultObj = this.getResultpanel();
		var gridContainer=Ext.getCmp('gridContainer');
		var multiGraphPanel=Ext.getCmp('multiGraphPanel');
		multiGraphPanel.removeAll();
		gridContainer.removeAll();
		gridContainer.show();
		multiGraphPanel.show();
		//Ext.select('.dataPanel').setStyle('border-width','0px');
		//resultObj.getHeader().hide();
		resultObj.hide();
		if ( !Ext.isEmpty( results ) )
		{
			var title = results['TITLE'];
			var gridRes = results['GRID_RESULTS'];
			if ( !Ext.isEmpty( gridRes ) )
			{
				var getHeader = gridRes['HEADERS'];
				var measureColumns = gridRes['MEASURE_COLUMNS'];
				var aggColumns = gridRes['AGG_COLUMNS'];
				var gridVals = gridRes['GRID_VALUES'];
				var fieldArr = new Array();
				for ( var key in gridVals[0] )
				{
					fieldArr[fieldArr.length] = key;
				}
				var headerArr = new Array();
				var measureIdx = 1;
				var aggColIdx = 1;
				var dataIdx = 0;
				for ( var i = 0; i < getHeader.length;i++ )
				{
					var headerName = getHeader[i]['HEADER_NAME'];
					if ( i == 0 )
					{
						headerArr.push(
						{
							header: headerName,
							width: 150,
							align: 'left',
							dataIndex: 'COLUMN_'+(dataIdx++)
						});
					}
					else
					{
						var measureArr = new Array();
						var subColumnCount = measureColumns[measureIdx]['SUB_COLUMN_COUNT'];
						var aggArr = new Array();
						if ( subColumnCount > 0 )
						{
							for ( var j = 0; j < subColumnCount; j++ )
							{
								var aggName =  aggColumns[ aggColIdx + j ]['AGG_COLUMN_NAME'];
								var agg_Name =  measureColumns[ measureIdx ]['MEASURE_NAME'];

								aggArr.push(
								{
									header: aggName+'  '+agg_Name,
									align: 'center',
									dataIndex: 'COLUMN_'+(dataIdx++),
									sortable: true,

								doSort: function(state) {

											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													//if (v1.index==0)
														//return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													if(!isNaN(v1) && !isNaN(v2))
													{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													}
													if(v1.TEXT != undefined && v2.TEXT != undefined)
													{
														v1=v1.TEXT;
														v2=v2.TEXT;
													}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										},
									renderer: function( val )
									{
										if ( !Ext.isEmpty( val['LINK'] ) && !Ext.isEmpty( val['TEXT'] ) )
										{
											var link = val['LINK'];
											var text = val['TEXT'];
											return '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:openInNewWin(\''+link+'\')">'+Ext.getCmp('gridId').getDecimalAlignFormat(text,true)+'</a>';
										}
										else
										{
											val = Ext.getCmp('gridId').getDecimalAlignFormat(val);
											return val;
										}
									}
								}
								);
							}
							aggColIdx++;
						}
						/*measureArr.push({
							header: measureColumns[measureIdx]['MEASURE_NAME'],
							align: 'center',
							columns: aggArr
						});*/
						headerArr.push(
						{
							header: headerName,
							align: 'center',
							columns : aggArr
						});
					}
				}
				gridContainer.setTitle(title);
				var forcefit=false;
				if(headerArr.length < 6)
					forcefit=true;
				var isPagingHidden;
				if (gridVals.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				var activePage = 1;
				var store = Ext.create('Ext.data.Store',
							{
								proxy : {
									type : 'pagingmemory',
									reader : {
										type : 'json'
									}
								},
								pageSize:gridPageSize,
								remoteSort:true,
								fields: fieldArr,
								data: gridVals
							});
				gridContainer.add({
					xtype: 'customgrid',
					needtoFixColumn:true,
					//title: title,
					forceFit:forcefit,
					id:'gridId',
					border:true,
					margin:'0 10 10 10',
					frame:false,
					//cls:'gridSkin horizontal-scroll',
					ui:'newGridPanel',
					//width: '100%',
					store: store,
					dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: store,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
							{
									activePage = params.currentPage;
								}
							}
					}],
					columns: headerArr,
				listeners:{
				sortchange:function( ct, column, direction, eOpts ){

				me.gridColIndexParam=column.getIndex();
				me.gridColStateParam=column.sortState;

				},
				render:function(obj){
  						Ext.defer(function() {
							obj.columns[0].setSortState("ASC",true,true);
						},100);
				}
				}
				});

				var timeFormat = appConstants.publicJSON['TIME_FORMAT'];
				multiGraphPanel.setTitle('<div align="right" class="newFont_normal12" style="padding-right:6px;">'+timeFormat+'</div>');
				/*resultObj.add({
					xtype: 'panel',
					cls:'dataPanel strip',
					style:{'border':'1px solid #c3c3c3'},
					margin:10,
					border:true,
					frame:false,
					width: '100%',
					title: timeFormat
				});*/
				var imageArr = new Array();
				var imageRes = appConstants.publicJSON['IMAGE_RESULTS'];
				var imgHeight = 265;
				var imgWidth = 350;
				if ( imageRes.length == 1 )
				{
					imgHeight = 400;
					imgWidth = 670;
				}
				var divHeight = imgHeight - 40;
				var highChartUrls = new Array();
				var highChartdrilldwonUrls = new Array();
				var highChartIds = new Array();
				for ( var i = 0; i < imageRes.length; i++ )
				{
					var imgHeader = imageRes[i]['IMAGE_HEADER'];
					var imgURL = imageRes[i]['IMAGE_URL'];
					var dataURL = imageRes[i]['IMAGE_DATA_URL'];
					var csvURL = imageRes[i]['IMAGE_CSV_URL'];
					var imgeDrillDownURL = imageRes[i]['IMAGE_DRILL_DOWN_URL'];
					var imageTitle = imageRes[i]['IMAGE_TITLE'];
					var getHtml="";
					var drillDownUrl;
					var drillDownChartType;
					if(appConstants.timlineChartType == "highchart"){
						highChartdrilldwonUrls.push(imgeDrillDownURL+'&fromGuest=yes');
						drillDownUrl=imgeDrillDownURL+'&fromGuest=yes';
						drillDownChartType='highchart';
						highChartIds.push('highChart'+i);
						highChartUrls.push(imgURL+"&chartType="+appConstants.timlineChartType);
						getHtml='<div id="highChart'+i+'" style="width:98%;height:98%;"></div>'
					}
					else{
						drillDownUrl=imgeDrillDownURL;
						drillDownChartType='easychart';
						//getHtml='<img src="'+imgURL+'" onclick=javascript:openNew("'+imgeDrillDownURL+'") style="cursor:pointer;" title="'+imageTitle+'"/>';
						getHtml='<img src="'+imgURL+'" title="'+imageTitle+'"/>';
					}
					var marginVal = '0 10 10 0';
					if(i%2==0)
						marginVal = '0 10 10 10';
					var showLegendVal=false;
					var islegendEnabled = Ext.getCmp('showLegend').getValue();
					if(islegendEnabled == "false" || islegendEnabled==false){
						showLegendVal=true;
					}
					imageArr.push(
					{
						xtype: 'panel',
						title: imgHeader,
						//cls:'datapanel',
						ui:'newGraphPanel graphHeaderBottomBorder',
//						html: getHtml,
						margin:marginVal,
						items:[{
							xtype: 'container',
							id:'highChart'+i+'_GraphPanel',
							height: imgHeight,
							html: getHtml,
						},{
							xtype:'container',
							id:'highChart'+i+'_legendPanel',
							margin:'0 0 5 0',
							height:53,
							style: {
								'overflow': 'hidden',
								'padding-right':'10px',
								'padding-bottom':'5px',
							},
							hidden:showLegendVal,
						}],
						tools: [
						{
							xtype : 'container',
							margin : '0 1px 0 1px',
							cls : 'iconBg',
							items: [
							{
								xtype : 'button',
								iconCls : 'iconData',
								data: dataURL,
								name : 'data',
								listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: 'Data'
										});
									}
								},

								style : {
									background : 'none',
									border : '0px'
								},
								handler : function()
								{
								
									parent.maximizeWindowLightBox(this.data,appConstants.reportTitle);//this method is defined in ErReporterMenuDashBoard.jsp for loading drilldown app
								}
							}
							]
						},{
								xtype : 'container',
								margin : '0 1px 0 1px',
								cls : 'iconBg',
								items : [{
											xtype : 'button',
											iconCls : 'iconCsv',
											name : 'csv',
											data: csvURL,
											style : {
												background : 'none',
												border : '0px'
											},
											listeners : {
												'click' : function() {
														window.location = this.data;
													},
												'afterrender': function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'CSV'
																});
															}
											}
										}]
						},{
								xtype : 'container',
								margin : '0 1px 0 1px',
								cls : 'iconBg',
								items : [{
									xtype : 'button',
									iconCls : 'iconMaximize',
									tooltip : '<b>Enlarge Graph</b>',
									drillDownUrl:drillDownUrl,
									drillDownChartType:drillDownChartType,
									style : {
										background : 'none',
										border : '0px'
									},
									handler:function(){
										if (this.drillDownChartType=='highchart')
										 loadUrlInDrillDown(this.drillDownUrl);
										else
											openNew(this.drillDownUrl);
									}
								}]
							}
						]
					}
					);
				}
				multiGraphPanel.add({
					xtype: 'container',
					//width: '100%',
					layout: 'column',
					items: imageArr,
					defaults:{
						columnWidth:'0.5', 
						//margin : '0 12 12 0'
					}
				});
				if(appConstants.timlineChartType == "highchart"){
					for( var l in highChartIds){
						reportHighStockChart(highChartUrls[l],highChartIds[l],300,400,highChartdrilldwonUrls[l]);
					}
				}
			}
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
		}
		else
		{
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
			resultObj.getHeader().hide();
			resultObj.hide();
			this.getNomeasurepanel().doLayout();
			this.getNomeasurepanel().show();
		}
 	},
	loadChart: function( results )
	{
		var resultObj = this.getResultpanel();
		var gridContainer=Ext.getCmp('gridContainer');
		Ext.getCmp('multiGraphPanel').hide();
		gridContainer.hide();
		resultObj.removeAll();
		resultObj.show();
		var xmlAvailable = false;
		if ( !Ext.isEmpty( results ) )
		{
 			var title = results['TITLE'];
			resultObj.setTitle(title);
			var pieChartResults = results['PIE_CHART_RESULTS'];
			if ( !Ext.isEmpty( pieChartResults ) )
			{
				var pieSWFPath = pieChartResults['SWF_PATH'];
				var pieXMLData = pieChartResults['XML_DATA'];
				if ( !Ext.isEmpty( pieXMLData ) )
				{
					xmlAvailable = true;
				}
				var legendResults = pieChartResults['LEGEND_RESULTS'];
				appConstants.pieHiddens = legendResults['LEGEND_ARRAYS'];
				var legendLinks = legendResults['LEGEND_LINKS'];
 				for ( var key in legendLinks )
				{
					var linksObj = legendLinks[key];
					var color = linksObj['COLOR'];
					var link = linksObj['LINK'];
					var text = linksObj['TEXT'];
 				}
				resultObj.add(
					{
						xtype: 'panel',
						ui:'newGraphPanel',
						id:'leftChartContent',
						columnWidth:0.35,
						height:350,
						autoScroll:true,
						margin:'0 10 10 10',
						title:pieChartResults.TITLE,
						html:''
					}
				);

				 if (Ext.isEmpty(appConstants.erUtils))
						{
						appConstants.erUtils = Ext.widget("erutils");
						}
					appConstants.erUtils.updatePieChart(appConstants.chartType,legendResults.LEGEND_LINKS,'COLOR','LINK','TEXT','',pieXMLData,pieSWFPath,pieChartResults,Ext.getCmp('leftChartContent'));

			}
			var barChartResults = results['BAR_CHART_RESULT'];

			if ( !Ext.isEmpty( barChartResults ) )
			{
				var barSWFPath = barChartResults['SWF_PATH'];
				var barXMLData = barChartResults['XML_DATA'];
				resultObj.add(
				{
					xtype: 'panel',
					columnWidth:0.65,
					margin:'0 10 10 0',
					height:350,
					autoScroll:true,
					title:barChartResults.TITLE,
					id:'rightChartContent',
					ui:'newGraphPanel',
					html:''
				});
				if (Ext.isEmpty(appConstants.erUtils))
					{
					appConstants.erUtils = Ext.widget("erutils");
					}
					appConstants.erUtils.updateBarChart(appConstants.chartType,'',barXMLData,barSWFPath,barChartResults,barChartResults.chartHeight,barChartResults.chartWidth,Ext.getCmp('rightChartContent'))

			}
			resultObj.show();
		}
		if ( Ext.isEmpty( results ) || !xmlAvailable )
		{
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
			Ext.getCmp('multiGraphPanel').hide();
 			resultObj.hide();
  			this.getNomeasurepanel().show();
		}
		else
		{
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
		}
 	},
	changeComponentType: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
			this.formSubmit( obj );
		}
	},
	changeReportType: function( obj )
	{
		var getVal = Ext.getCmp('er_rtype').getValue();
		if ( getVal == 'No' )
		{
			Ext.getCmp('er_mode').hide();
			Ext.getCmp('select_testMeasure').hide();
			Ext.getCmp('er_showby').hide();
			Ext.getCmp('showLegend').show();
		}
		else
		{
			//Ext.getCmp('er_mode').show();
			Ext.getCmp('select_testMeasure').show();
			Ext.getCmp('er_showby').show();
			Ext.getCmp('showLegend').hide();
			
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
			this.formSubmit( obj );
		}
		if (isSettingsEnabled)
		{
		Ext.Ajax.request({
			url: '/final/reporter/ErVmGuestStatusReportJSON.jsp?er_rtype='+getVal,
			params: appConstants.queryString,
			method: 'POST',
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					appConstants.repoGene=jsonData;
					var reportGenerationObj = Ext.getCmp("reportGeneration");
					var reportGenerationComboData = jsonData.reportGenCombo;
					var setRepoGen= reportGenerationComboData[0].valueField
					reportGenerationObj.suspendEvents(true);
					reportGenerationObj.getStore().loadRawData(reportGenerationComboData);
					reportGenerationObj.setValue(setRepoGen);
					reportGenerationObj.resumeEvents();
					var reportNameObj = Ext.getCmp('bgReportName');
					if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
					{
						reportNameObj.hide();
					}
					else
					{
						reportNameObj.show();
					}
				}
			}
			});
		}
	},
	changeReportGeneration: function( obj )
	{
		var reportGenTypeVal = Ext.getCmp('reportGeneration').getValue();
		var reportNameObj = Ext.getCmp('bgReportName');
		if ( reportGenTypeVal == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else if (reportGenTypeVal == 'background-csv' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	changeAnalysis: function( obj )
	{
		var getSelectGroupVal = Ext.getCmp('select_group').getValue();
		var compObj = Ext.getCmp('compContainer');
		var zoneObj = Ext.getCmp('zone');
		var subzoneObj = Ext.getCmp('subzone');
		var segmentObj = Ext.getCmp('segment');
		var serviceObj = Ext.getCmp('service');
		if ( getSelectGroupVal == 'Component' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.hide();
			serviceObj.hide();
			compObj.show();
		}
		else if ( getSelectGroupVal == 'Zone' )
		{
			zoneObj.show();
			subzoneObj.show();
			segmentObj.hide();
			serviceObj.hide();
			serviceObj.hide();
			compObj.hide();
		}
		else if ( getSelectGroupVal == 'Segment' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.show();
			serviceObj.hide();
			serviceObj.hide();
			compObj.hide();
		}
		else
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.hide();
			serviceObj.hide();
			serviceObj.show();
			compObj.hide();
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
			this.formSubmit( obj );
		}
	},
	changeSubZone: function()
	{
		this.changeZone( Ext.getCmp('zone') );
	},
	changeZone: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
//			this.formSubmit( obj );
		}
	},
	changeSegment: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
			//this.formSubmit( obj );
		}
	},
	changeService: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
			//this.formSubmit( obj );
		}
	},
	disableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		if ( Ext.getCmp('er_rtype').getValue() == 'No' )
		{
			Ext.getCmp("csvTool").setDisabled(false);
		}
		else
		{
			Ext.getCmp("csvTool").setDisabled(true);
		}
		//Ext.getCmp("upbutton").setDisabled(false);
	},
	insertNotApplicable: function ( form, fieldName )
	{
		var obj = form.findField(fieldName);
		obj.getStore().removeAll();
		obj.getStore().add({
			'displayField': appConstants.notApplicable,
			'valueField': '-1'
		});
		obj.setValue('-1');
	},
	loadScreenLabels: function ( form, ObjectArr )
	{
		var obj = '';
		for ( var key in ObjectArr )
		{
			obj = !Ext.isEmpty(form.findField(key))?form.findField(key):Ext.getCmp(key);
			if ( obj.getXType() != 'label' )
			{
				if(key !='er_timeline' && key != 'er_stdate' && key != 'er_enddate' && key != 'er_sthr' && key != 'er_endhr' && key != 'er_mode')
				Ext.getCmp(key).setFieldLabel(ObjectArr[key]);
			}
			else
			{
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	setValueForComponent : function(fieldName, list, value)
	{
 		if ( !Ext.isEmpty( list) )
		{
			Ext.getCmp(fieldName).getStore().loadRawData(list);
		}
 		if( !Ext.isEmpty(value) )
		{
			Ext.getCmp(fieldName).setValue(value);

		}
		else
		{
			Ext.getCmp(fieldName).setValue(list[0].valueField);
		}
 	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
 		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().clearFilter(true); 
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);
		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	hideResult: function()
	{
		this.getResultpanel().hide();
		Ext.getCmp('gridContainer').hide();
		this.disableTools();
	},
	afterMainRender: function()
	{
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.reportTitle);
		var screenLabels = appConstants.publicJSON['screenLabels'];
		var mainForm = this.getMainform().getForm();
		var ObjectArr = new Array();
		ObjectArr['er_rtype'] = screenLabels['reporter.consolidated.reportType'];
		ObjectArr['er_comptype'] = screenLabels['reporter.common.componentType'];
		ObjectArr['select_group'] = screenLabels['reporter.common.analysisBy'];
		ObjectArr['componentsLbl'] = screenLabels['reporter.common.Component'];
		ObjectArr['zone'] = screenLabels['reporter.common.Zone'];
		ObjectArr['segment'] = screenLabels['reporter.common.Segment'];
		ObjectArr['service'] = screenLabels['reporter.common.Service'];
		ObjectArr['subzone'] = screenLabels['reporter.common.includeSubzones'];
		ObjectArr['select_testMeasure'] = screenLabels['reporter.consolidated.Measure'];
		ObjectArr['er_showby'] = screenLabels['reporter.comparison.Show'];
		ObjectArr['er_timeline'] = screenLabels['reporter.common.Timeline'];
		ObjectArr['er_stdate'] = screenLabels['reporter.common.From'];
		ObjectArr['er_enddate'] = screenLabels['reporter.common.To'];
		ObjectArr['er_sthr'] = screenLabels['reporter.common.Hr'];
		ObjectArr['er_endhr'] = screenLabels['reporter.common.Hr'];
		ObjectArr['er_mode'] = screenLabels['reporter.common.Graph'];
		this.loadScreenLabels( mainForm, ObjectArr );


		var hiddenFields = appConstants.publicJSON['hiddens'];
        var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			//Ext.getCmp("submit").hide();
			//Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}/*else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}*/

		// To load Defaults

		var selectedData = appConstants.publicJSON['selectedValues'];


		var reportTypeCombo = appConstants.publicJSON['reportTypeCombo'];
		if ( !Ext.isEmpty( reportTypeCombo ) )
		{
			var reportTypeSelected = selectedData['reportTypeSelected'];
			this.setValueWithOptionInList( mainForm, 'er_rtype', reportTypeCombo, reportTypeSelected);
			this.changeReportType();
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_rtype');
		}

		var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
		if ( !Ext.isEmpty( compTypeCombo ) )
		{
			var compTypeSelected = selectedData['compTypeSelected'];
			this.setValueWithOptionInList( mainForm, 'er_comptype', compTypeCombo, compTypeSelected);
			this.changeComponentType();
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_comptype');
		}

		var analysisCombo = appConstants.publicJSON['analysisCombo'];
		var analysisSelected = selectedData['analysisSelected'];
		if ( !Ext.isEmpty( analysisCombo ) )
		{
			this.setValueWithOptionInList( mainForm, 'select_group', analysisCombo, analysisSelected);
			this.changeAnalysis();
		}
		else
		{
			this.insertNotApplicable( mainForm, 'select_group');
		}

		var selectedGroupCombo = appConstants.publicJSON['selectedGroupCombo'];
		appConstants.rawDataForComponents = selectedGroupCombo;
 		if ( !Ext.isEmpty( selectedGroupCombo ) )
		{
			var selectedGroupSelected = selectedData['selectedGroupSelected'];
			if (analysisSelected=='Component')
			this.setValueForComponent(analysisSelected.toLowerCase(), selectedGroupCombo, selectedGroupSelected);
			else
			this.setValueWithOptionInList( mainForm, analysisSelected.toLowerCase(), selectedGroupCombo, selectedGroupSelected);
			if ( selectedData['analysisSelected'] == 'Zone' )
			{
 				var subzone = appConstants.publicJSON['subzoneCombo'];

				var subzoneSelected = selectedData['subzoneSelected'];
				this.setValueWithOptionInList( mainForm, 'subzone', subzone, subzoneSelected);
			}
		}
		else
		{
			this.insertNotApplicable( mainForm, 'component');
		}

		var measureCombo = appConstants.publicJSON['measureCombo'];
		if ( !Ext.isEmpty( measureCombo ) )
		{
			var measureSelected = selectedData['measureSelected'];
			this.setValueWithOptionInList( mainForm, 'select_testMeasure', measureCombo, measureSelected);
		}
		else
		{
			this.insertNotApplicable( mainForm, 'select_testMeasure');
		}

		var showCombo = appConstants.publicJSON['showCombo'];
		if ( !Ext.isEmpty( showCombo ) )
		{
			var showSelected = selectedData['showSelected'];
			this.setValueWithOptionInList( mainForm, 'er_showby', showCombo, showSelected);
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_showby');
		}

		var timelineCombo = appConstants.publicJSON['timelineCombo']
		if ( !Ext.isEmpty( timelineCombo ) )
		{
			var selectedTimeline = selectedData['selectedTimeline'];
			this.setValueWithOptionInList( mainForm, 'er_timeline', timelineCombo, selectedTimeline);
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_timeline');
		}
		if(appConstants.publicJSON['selectedValues']['showDataSelected']=='Yes')
		{
			isTrend=true;
		}
	
		mainForm.findField('er_sthr').dataArray=selectedData['startHour'];
		mainForm.findField('er_sthr').setValue(selectedData['startHourForDisplay']);


		mainForm.findField('er_endhr').dataArray=selectedData['endHour'];
  	  	mainForm.findField('er_endhr').setValue(selectedData['endHourForDisplay']);
  
		stmin =selectedData['startMinForDisplay'];
        enmin =selectedData['endMinForDisplay'];
        mgr_stmin =selectedData['startmin'];
        mgr_enmin = selectedData['endmin'];

		mainForm.findField('er_stdate').setValue(selectedData['startDateForDisplay']);
		mainForm.findField('er_stdate').dataArray=selectedData['startDate'];
		mainForm.findField('er_enddate').setValue(selectedData['endDateForDisplay']);
		mainForm.findField('er_enddate').dataArray=selectedData['endDate'];

		mainForm.findField('er_mode').setValue(selectedData['selectedGraphMode']);
		 updatingAppSettings();

		if(appConstants.isForceSubmit=='true')
		{
			this.formSubmit(Ext.getCmp('mainform').getComponent('submit'));
			appConstants.isForceSubmit='false';
		}
		if(appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true')
			this.formSubmit();
	},
	afterSettingsRender: function()
	{
	 		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var favorite_id = hiddenFields["favorite_id"];
				if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var settingsForm = this.getVirtualmachinesdistsettings().getForm();
		var ObjectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		ObjectArr['er_trenddata'] = screenLabels['reporter.common.showData'];
		ObjectArr['er_excwe'] = screenLabels['reporter.common.excludeweekends'];
		ObjectArr['timeperiodLbl'] = screenLabels['reporter.common.timePeriod'];
		ObjectArr['fromTimeLbl'] = screenLabels['reporter.common.timePeriodFrom'];
		ObjectArr['toTimeLbl'] = screenLabels['reporter.common.timePeriodTo'];
		ObjectArr['fromHrsLbl'] = screenLabels['reporter.common.timePeriodHrs'];
		ObjectArr['fromMinsLbl'] = screenLabels['reporter.common.timePeriodMins'];
		ObjectArr['toHrsLbl'] = screenLabels['reporter.common.timePeriodHrs'];
		ObjectArr['toMinsLbl'] = screenLabels['reporter.common.timePeriodMins'];

		ObjectArr['reportGeneration'] = screenLabels['reporter.consolidated.reportGeneration'];
		ObjectArr['bgReportName'] = screenLabels['reporter.consolidated.reportName'];
		///Ext.getCmp('submit').setText(screenLabels['reporter.common.SUBMIT']);
		this.loadScreenLabels( settingsForm, ObjectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];

		var showDataCombo = appConstants.publicJSON['showDataCombo'];
		if ( !Ext.isEmpty( showDataCombo ) )
		{
			var showDataSelected = selectedData['showDataSelected'];
			this.setValueWithOptionInList( settingsForm, 'er_trenddata', showDataCombo, showDataSelected);
		}
		else
		{
			this.insertNotApplicable( settingsForm, 'er_trenddata');
		}
		var trendenablee = appConstants.publicJSON.hiddens['trendenable'];
		if(trendenablee == 'false'){
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}
		var excludeWeekCombo = appConstants.publicJSON['excludeWeekCombo'];
		if ( !Ext.isEmpty( excludeWeekCombo ) )
		{
			var excludeWeekSelected = selectedData['excludeWeekSelected'];
			this.setValueWithOptionInList( settingsForm, 'er_excwe', excludeWeekCombo, excludeWeekSelected);
			this.changeExcludeWeekEnd();
		}
		else
		{
			this.insertNotApplicable( settingsForm, 'er_excwe');
		}
		settingsForm.findField('timefrom').setValue(selectedData['timePeriodHourFrom']);
		settingsForm.findField('minfrom').setValue(selectedData['timePeriodMinFrom']);
		settingsForm.findField('timeto').setValue(selectedData['timePeriodHourTo']);
		settingsForm.findField('minto').setValue(selectedData['timePeriodMinTo']);

		var repomaking="";
		if(appConstants.repoGene!=undefined)
		{
			repomaking=appConstants.repoGene;
		}
		else
		{
			repomaking=appConstants.publicJSON;
		}
		var reportGenCombo = repomaking['reportGenCombo']
		if ( !Ext.isEmpty( reportGenCombo ) )
		{
			var reportGenSelected = selectedData['reportGenSelected'];
			this.setValueWithOptionInList( settingsForm, 'reportGeneration', reportGenCombo, reportGenSelected);
			this.changeReportGeneration();
		}
		else
		{
			this.insertNotApplicable( settingsForm, 'reportGeneration');
		}

	},

	changeExcludeWeekEnd: function( obj )
	{
		var er_excweVal = Ext.getCmp('er_excwe').getValue();
		//var excludeWeekLabelObj = Ext.getCmp('excludeWeekLabel');
		if ( er_excweVal == 'Yes' )
		{
			var no_params = '&P0=[VIRTUAL_GUEST_STATUS]&';
			var param = 'C=jsrs1'+no_params+'U='+new Date().getTime()+'&fromajax=true&F=getExcucludeWeekend';
			//excludeWeekLabelObj.show();
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
				method: 'POST',
				params: param,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						if ( !Ext.isEmpty( jsonData ) )
						{
							Ext.getCmp('excludeWeekLabel').update("Excludes	"+jsonData['values']);
						}
					}
				}
			});
		}
		else
		{
			//excludeWeekLabelObj.hide();
		}
	},
	validateSettings: function()
	{
		var er_usertimeline = appConstants.publicJSON['hiddens']['er_usertimeline'];
		var getMaxDaysInMonth = appConstants.publicJSON['hiddens']['getMaxDaysInMonth'];
		var timeFrom = Ext.getCmp('timefrom').getValue();
		var minFrom = Ext.getCmp('minfrom').getValue();
		var timeTo = Ext.getCmp('timeto').getValue();
		var minTo = Ext.getCmp('minto').getValue();
		if ( !checkTimePeriod(timeFrom, minFrom, timeTo, minTo ) )
		{
			return false;
		}
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		var isSettingsOk = true;

		if (reportgenVal == 'background' || reportgenVal == 'background-csv')
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				return false;
			}
			else
			{
				return true;
			}
		}
		return true;
	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			this.generateresult();
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('bgReportName').setValue('');
			validateTextBox(Ext.getCmp('bgReportName').getValue());
			Ext.getCmp('bgReportName').focus(false, 1000);
			return false;
		}
	},
	locdPage: function()
	{
		var thisController = this;
        Ext.get('closeSettings').on('click', function () {
            //var isSettingsOk = thisController.validateSettings();
            isSettingsOk = true;
            //var getButtonObj = Ext.getCmp('submit');
            //getButtonObj.setDisabled(true);
            if (isSettingsOk) {
                //getButtonObj.setDisabled(false);
                Ext.get('configMod').animate({
                    duration: 500,
                    to: {
                        y: -500
                    }
                });
            }
        });
	},
    loadDefaults: function () {
        //this.loadPage();
		if(!hideBackButton){
			Ext.getCmp('virtualmachinesdistmainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJSON['ID']
				}
			);
		}

        if ( !Ext.isEmpty( appConstants.publicJSON['RESULTS'] ) )
		{
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ( from_favorite == null)
		{
			var results = appConstants.publicJSON['RESULTS'];
			appConstants.timlineChartType = appConstants.publicJSON['chartType'];
			this.getResultpanel().show();
			if ( appConstants.publicJSON['selectedValues']['reportGenSelected'] == 'foreground')
			{
				if ( appConstants.publicJSON['selectedValues']['reportTypeSelected'] == 'Yes' )
				{
					this.loadChart( results );
				}
				else
				{
					this.loadGridWithChart( results );
				}
				this.enableTools();

			}
		} else {
			this.hideResult();
		}
		}
		else
		{
			this.hideResult();
		}
		if(appConstants.publicJSON['selectedValues']['showDataSelected']=='Yes')
		{
			isTrend=true;
		}

    },
	hideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //csv
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //booklet
			);
	}
});