Ext.define('VirtualMachinesIdleApp.controller.Main', {
    extend: 'Ext.app.Controller',
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        },
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
    ],
    init: function () {
        this.control({
            'main newUtilities': {
                'afterrender': this.loadTools
            },
            'main': {
                'afterrender': this.loadDefaults
            },
            'virtualmachinessprawlsettings': {
                'afterrender': this.afterSettingsrender
            },
            'virtualmachinessprawlmainform combo[name="er_option"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinessprawlmainform combo[name="er_type"]': {
                'select': this.reporttypeChange
            },
            'virtualmachinessprawlmainform combo[name="er_site"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinessprawlmainform combo[name="er_comptype"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinessprawlmainform combo[name="er_dataZone"]': {
                'select': this.reloadWithAjax
            },
            'mainform button[name="submit"]': {
                'click': this.showResult
            },
            'mainform button[name="save"]': {
                'click': this.goTo
            },
            'virtualmachinessprawlsettings combo[name="er_timeline"]': {
                'select': this.timeLineOnChange
            },
            'virtualmachinessprawlsettings checkbox': {
                'change': this.vmIdleOnChange
            },
            'virtualmachinessprawlsettings combo[name="reportGeneration"]': {
                'select': this.reportGenChange
            },
			'virtualmachinessprawlsettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualmachinessprawlsettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'timeline combo[name="er_mode"]':
			{
				 'select': this.changeEr_mode
			 },
            'newUtilities > #printTool > button': {
                'click': this.printReport
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveReportAsPDF
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #csvTool > button': {
                'click': this.saveCsv
            },
            'newUtilities > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.saveSchedule
            },
            'egcomponent button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
        });
    },
	vmIdleOnChange:function(obj){
		var name=obj.name;
		var isChecked=obj.checked;
		var obj1=Ext.getCmp("CPUtilCb").checked;
		var obj2=Ext.getCmp("DiskIOPCb").checked;
		var obj3=Ext.getCmp("NetworkIOPCb").checked;
		if(name=="CPUtilCb")
		{
			if(isChecked)
			{
				Ext.getCmp("CPUtilsort").show();
				Ext.getCmp("CPUtilVal").show();
				Ext.getCmp("CPUtilLbl").show();
				Ext.getCmp("CPUtil_AggVal").show();
			}else
			{
				Ext.getCmp("CPUtilsort").hide();
				Ext.getCmp("CPUtilVal").hide();
				Ext.getCmp("CPUtilLbl").hide();
				Ext.getCmp("CPUtil_AggVal").hide();
			}
			if(obj1 && !obj2 && !obj3)
				Ext.getCmp("CPUtil_AggVal").hide();
			else if(obj1)
				Ext.getCmp("CPUtil_AggVal").show();
			
		}else if(name=="DiskIOPCb")
		{
			if(isChecked)
			{
				Ext.getCmp("DiskIOPsort").show();
				Ext.getCmp("DiskIOPVal").show();
				Ext.getCmp("DiskIOPLbl").show();
				Ext.getCmp("DiskIops_AggVal").show();
			}else
			{
				Ext.getCmp("DiskIOPsort").hide();
				Ext.getCmp("DiskIOPVal").hide();
				Ext.getCmp("DiskIOPLbl").hide();
				Ext.getCmp("DiskIops_AggVal").hide();
			}
			if(!obj1 && obj2 && !obj3)
				Ext.getCmp("DiskIops_AggVal").hide();
			else if(!obj3)
				Ext.getCmp("DiskIops_AggVal").hide();
			else if(obj2)
				Ext.getCmp("DiskIops_AggVal").show();
			if(obj1 && !obj2 && !obj3)
				Ext.getCmp("CPUtil_AggVal").hide();
			else if(obj1)
				Ext.getCmp("CPUtil_AggVal").show();
			
		}else if(name=="NetworkIOPCb")
		{			
			if(isChecked)
			{
				Ext.getCmp("NetworkIOPsort").show();
				Ext.getCmp("NetworkIOPVal").show();
				Ext.getCmp("NetworkIOPLbl").show();
			}else
			{
				Ext.getCmp("NetworkIOPsort").hide();
				Ext.getCmp("NetworkIOPVal").hide();
				Ext.getCmp("NetworkIOPLbl").hide();
			}
			if(!obj1 && obj2 && !obj3)
				Ext.getCmp("DiskIops_AggVal").hide();
			else if(obj1 && obj2 && !obj3)
				Ext.getCmp("DiskIops_AggVal").hide();
			else if(obj2)
				Ext.getCmp("DiskIops_AggVal").show();
			if(obj1 && !obj2 && !obj3)
				Ext.getCmp("CPUtil_AggVal").hide();
			else if(obj1)
				Ext.getCmp("CPUtil_AggVal").show();
		}
	},
	showConfigDropdown:function(){
		isSettingsEnabled =true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		//layout:'vbox',
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		//html:tpl.apply(),
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'2px'}
			},
			{
				xtype : 'virtualmachinessprawlsettings',
				itemId: 'settingsForm',
				parent:this
			}

		],
		renderTo:'virtualmachinessprawl-body'
		});
        var thisController = this;
        Ext.get('closeSettings').on('click', function () {
          	  thisController.validateAndCloseSettings();
        });

	},
	validateAndCloseSettings:function()
	{
		  var isSettingsOk = true;
			var reportGen = Ext.getCmp('reportGeneration');
			if (reportGen != null && reportGen == 'foreground') {
				var reportName = Ext.getCmp('bgReportName').getValue();
				if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)) isSettingsOk = false;
			}
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(true);
            if (isSettingsOk) {
                getButtonObj.setDisabled(false);
                Ext.get('configMod').animate({
                    duration: 500,
                    to: {
                        y: -500
                    }
                });
            }
			return true;
	},
	closeAndSubmitSettings:function()
	{	
	  if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	afterSettingsrender : function() {
		
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicjsonData['hiddenfields'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

		var jsonData = appConstants.publicjsonData;
        var screenLabels = jsonData.screenLabels;
		var rtype = jsonData.er_type;
		if( rtype == 'No'){
			Ext.getCmp('er_display').hide();
			Ext.getCmp('er_priority').hide();
		}
		//else{
		var comboRawData = jsonData.metricCombo;
		var selectedComboOption = jsonData.er_display;
		var comboObject = Ext.getCmp('er_display');
		comboObject.setFieldLabel(screenLabels['reporter.common.Metric']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}

		comboRawData = jsonData.priorityCombo;
		selectedComboOption = jsonData.er_priority;
		comboObject = Ext.getCmp('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
        var reportGenCombo = jsonData.reportGenerationCombo;
        var selreportGeneration = jsonData.er_reportgenration;
        var reportGen = Ext.getCmp('reportGeneration');
        reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
        reportGen.getStore().loadRawData(reportGenCombo);
        reportGen.setValue(selreportGeneration);
		
		Ext.getCmp("vmIdle").hide();
		if(appConstants.vmIdle!="null")
		{			
			Ext.getCmp("vmIdle").show();
			comboRawData = jsonData.getSortTypeComboForIdle;
			if(!Ext.isEmpty(comboRawData))
			{
				comboObject = Ext.getCmp('CPUtilsort');
				selectedComboOption = jsonData.selectedCPUtilsort;
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				
				comboObject = Ext.getCmp('DiskIOPsort');
				selectedComboOption = jsonData.selectedDiskIOPSsort;
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject = Ext.getCmp('NetworkIOPsort');
				selectedComboOption = jsonData.selectedNetworkIOPSsort;
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}			
			
				comboObject = Ext.getCmp('DiskIOPsort');
				comboObject.getStore().loadRawData(comboRawData);
				comboObject = Ext.getCmp('NetworkIOPsort');
				comboObject.getStore().loadRawData(comboRawData);
			}
			
			var comboValue=jsonData.CPUUtil_val;					
			comboObject = Ext.getCmp('CPUtilVal');			
			comboObject.setValue(comboValue);
			comboValue=jsonData.DiskIops_val;
			comboObject = Ext.getCmp('DiskIOPVal');
			comboObject.setValue(comboValue);
			comboValue=jsonData.NetworkIops_val;
			comboObject = Ext.getCmp('NetworkIOPVal');
			comboObject.setValue(comboValue);
						
						
			comboValue=jsonData.CPUUtilCB;
			var cb=Ext.getCmp("CPUtilCb");			
			if(comboValue=="true")
			{
				cb.setValue(true);
			}else{
				cb.setValue(false);
			}		
			
			comboValue=jsonData.DiskIopsCB;
			cb=Ext.getCmp("DiskIOPCb");			
			if(comboValue=="true")
			{
				cb.setValue(true);
			}else{
				cb.setValue(false);
			}
			
			comboValue=jsonData.NetworkIopsCB;
			cb=Ext.getCmp("NetworkIOPCb");			
			if(comboValue=="true")
			{
				cb.setValue(true);
			}else{
				cb.setValue(false);
			}
		
			comboValue=jsonData.CPUtil_AggVal;
			
			if(comboValue=='AND')
				Ext.getCmp("CPUtil_AND").setValue(true);
			else
				Ext.getCmp("CPUtil_OR").setValue(true);
			
			comboValue=jsonData.DiskIOP_AggVal;
			
			if(comboValue=='AND')
				Ext.getCmp("DiskIops_AND").setValue(true);
			else
				Ext.getCmp("DiskIops_OR").setValue(true);
			
			comboValue=jsonData.CPUUtil_Unit;
			comboObject = Ext.getCmp('CPUtilLbl');			
			comboObject.setText(comboValue);
			comboValue=jsonData.DiskIops_Unit;
			comboObject = Ext.getCmp('DiskIOPLbl');
			comboObject.setText(comboValue);
			comboValue=jsonData.NetworkIops_Unit;
			comboObject = Ext.getCmp('NetworkIOPLbl');
			comboObject.setText(comboValue);
			
			
			
			
		}

	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);

    },
		 changeEr_mode: function (combo) {
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
	},
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicjsonData.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			this.saveFavorite();
		}
    },
    reporttypeChange: function (obj) {
        Ext.getCmp('resultPanel').hide();
		this.disableTools();
        this.updateQueryString(true);
        Ext.Ajax.request({
            url: '/final/reporter/ErVmIdleReportJson.jsp',
            params: appConstants.queryString,
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
                if (obj.getValue() == 'Yes') {
					if (isSettingsEnabled)
					{
						Ext.getCmp("er_display").show();
						Ext.getCmp("er_priority").show();
					}
                } else {
					if (isSettingsEnabled)
					{
						Ext.getCmp("er_priority").hide();
						Ext.getCmp("er_display").hide();
						Ext.get("removeMargin").setStyle("margin", "0");
					}
                }
            }
        });
    },
    expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
    },
    printReport: function () {
        var s_qryString = "/final/reporter/ErVmIdleReportPrint.jsp?" + appConstants.publicjsonData.saveQstring + "pdfPrint=yes&er_width=450&er_height=250";
        parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    },
    saveReportAsPDF: function () {
        var saveQString = appConstants.publicjsonData.saveQstring;
        saveQString += "&pageWidthProces=700";
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
       if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
    },
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicjsonData.saveQstring;
        saveQString += "&pageWidthProces=700";
        var s_qryString =  saveQString;
		return s_qryString;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
    sendMail: function () {
        var windowMail = Ext.widget('sendmail');
        windowMail.show();
    },
    saveCsv: function () {
        window.location = '../servlet/egurkha.reporter.SaveInCSVFormat';
    },
    saveFavorite: function () {
        var isValid = this.validateMainForm();
        /* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Capactity Correlation',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        } */
        this.updateQueryString(true);
        var finalParams = appConstants.queryString+"&isFavorite=true";
        if (isValid) {
            var s_qryString;
			var hiddenFields = appConstants.publicjsonData['hiddenfields'];
			var favorite_id = hiddenFields["favorite_id"];
            s_qryString = "../servlet/com.eg.ErFavoriteC?" + encodeURI(finalParams) + "&er_view=GRAPH&cmd=client";//&FavoriteId="+favorite_id;
            var target = s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
        }
    },
    saveSchedule: function () {
        var isValid = this.validateMainForm();
        if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        }
        this.updateQueryString(true);
        var finalParams = appConstants.queryString;
        if (isValid) {
            var s_qryString;
            s_qryString = "/final/reporter/ErSaveSchedule.jsp?" + encodeURI(finalParams);
            var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
        }
    },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
    showResult: function () {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);

        var isValid = this.validateMainForm();
		if (isValid)
		{
			isValid = this.validateSettings();
		}
        if (isValid) this.submitReport();
        else return;
    },
    validateMainForm: function () {
        var datafrom = Ext.getCmp('er_option').getValue();
		if(datafrom == 'Zone')
		{
			Ext.getCmp('er_timeline').show();
		}
        if (datafrom != 'Component') {
            var site = Ext.getCmp('er_site');
            if (site.getValue() == '-1') {
                Ext.MessageBox.show({
                    title: 'Virtualization',
                    msg: site.getRawValue(),
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        }
        var comptype = Ext.getCmp("er_comptype");
        if (comptype.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: comptype.getRawValue(),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        var component = Ext.getCmp("er_component");
        if (component.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: component.getStore().getAt(0).get('displayField'),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
		if(isSettingsEnabled)
		{
			var val=Ext.getCmp("CPUtilVal").getValue();
			if(val>100)
			{
				Ext.MessageBox.show({
					title: 'Virtualization',
					msg: 'CPU Util Value should not exceed 100',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			} else if(val<0)
			{
				Ext.MessageBox.show({
					title: 'Virtualization',
					msg: 'CPU Util Value should not be less than Zero',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			val=Ext.getCmp("DiskIOPVal").getValue();
			if(val<0)
			{
				Ext.MessageBox.show({
					title: 'Virtualization',
					msg: 'Disk Iops Value should not be less than Zero',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			val=Ext.getCmp("NetworkIOPVal").getValue();
			if(val<0)
			{
				Ext.MessageBox.show({
					title: 'Virtualization',
					msg: 'Network Iops Value should not be less than Zero',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
        return true;
    },
    validateSettings: function () {
        var isSettingsOk = true;
        var reportgen = appConstants.publicjsonData.er_reportgenration;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
        var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
        var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);

		if (!checkDateTime(stDate, enDate)) {
            isSettingsOk = false;
        }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: 'Virtualization settings',
                    msg: userTimelineErrorMsg,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                isSettingsOk = false;
            }
        }
        if (reportgen != null && reportgen == 'foreground') {
            var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg'];
            if (!Ext.isEmpty(limitforbg)) {
                if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                    Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
                    isSettingsOk = false;
                }
            }
        } else {
            var reportName = Ext.getCmp('bgReportName').getValue();
            if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)) isSettingsOk = false;
        }
        return isSettingsOk;
    },
    showConfirmResult: function (btn) {
        if (btn == "yes") {
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(false);
            this.submitReport();
        } else {
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
            var reportGenType = Ext.getCmp('reportGeneration');
            var bgreportNameObj = Ext.getCmp('bgReportName');
            reportGenType.setValue('background');
            bgreportNameObj.setValue("");
            bgreportNameObj.show();
            bgreportNameObj.focus(false, 1000);
           this.showResult();
        }
    },
    submitReport: function () {
         appConstants.initLdgMask.show();
        var reportGeneration = appConstants.publicjsonData.er_reportgenration;
		if (isSettingsEnabled)
		{
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
         this.updateQueryString(true);
        var finalParams = appConstants.queryString;
        if (reportGeneration == 'foreground') {
            urlforAjax = '../servlet/com.eg.ErVmIdleReportC';
            finalParams += "&isSubmit=true&responseType=json";
        } else if (reportGeneration == 'background') {
            urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
        }
        finalParams += "&isFavorite=false&isSchedule=false";
		finalParams+="&er_RmDispName="+appConstants.er_RmDispName+"&er_mode="+Ext.getCmp("er_mode").getValue();
        Ext.Ajax.request({
            url: urlforAjax,
            params: finalParams,
            method: 'POST',
            scope: this,
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
                this.loadReportData(appConstants.publicjsonData);
            }
        });
    },
    loadReportData: function (jsonData) {
		var thisController=this;
		var me=this;
        var resultPanelObj = Ext.getCmp('resultPanel');
        var reportGeneration = appConstants.publicjsonData.er_reportgenration;
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
        if (reportGeneration == 'foreground') {

            Ext.getCmp("bookletTool").setDisabled(false);
            Ext.getCmp("saveTool").setDisabled(false);
            Ext.getCmp("printTool").setDisabled(false);
            Ext.getCmp("mailTool").setDisabled(false);
            var noDataFound = true;
            var fieldContainerArray = {};            
             resultPanelObj.removeAll();
            var reportData = jsonData.REPORT_DATA;
		
             if (!Ext.isEmpty(reportData)) {
                noDataFound = false;
                var r_type = jsonData.er_type;
                resultPanelObj.setTitle(reportData.title);
				Ext.getCmp("csvTool").setDisabled(false);
				var columnDetails = reportData.COLUMNS;
				var dataArraytoStore = reportData.DATA;				
			
				var cnt=0;
				var mainColumnsObjArray = new Array();
				for (var key in columnDetails) {
					var mainColumn = columnDetails[key];
					
					/*var align='left';
					if (key==1 || key==columnDetails.length-1 || key==columnDetails.length-2)
					{
						align='center';
					}  */
					//prakash
					var align ='center';
					if(key == 0 || key == 1)
					{
						align='left';
					}
					//
					if(cnt==0)
					{
						mainColumnsObjArray.push({
							header:mainColumn,
							sortable: true,
							locked:true,
							dataIndex: mainColumn,
							align: align,
							needModify:'no',
							width:180,
							doSort: function(state) {
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2){
										v1 = v1.get(field);
										v2 = v2.get(field);
										v1=v1.toLowerCase();
										v2=v2.toLowerCase();
										
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
							renderer:function(value,metaData)
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								return value;
							}
							//flex: 1
						});	

					}else if(cnt==1)
					{
						mainColumnsObjArray.push({
							header:mainColumn,
							sortable: true,
							locked:false,
							dataIndex: mainColumn,
							align: align,
							doSort: function(state) {
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2){
										v1 = v1.get(field);
										v2 = v2.get(field);
										v1=v1.toLowerCase();
										v2=v2.toLowerCase();
										
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
							renderer:function(value, metaData)
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								return value;
							}
							//flex: 1
						});	

					}else{
						mainColumnsObjArray.push({
							header:mainColumn,
							sortable: true,
							locked:false,
							dataIndex: mainColumn,
							align: align,
							doSort: function(state) {
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2){
										v1 = v1.get(field);
										v2 = v2.get(field);

										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;

										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}		   
								});
								
							},
							//prakash
							renderer : function(value,metaData)
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								value = Ext.getCmp('gridId').getDecimalAlignFormat(value);
								return value;
							}
							//
							//flex: 1
						});	
					}
					cnt++;					
				}

				var isPagingEnabled;
				if (dataArraytoStore.length<10)
					isPagingHidden=true;
				else
					isPagingHidden=false;

				var fields=[];
				//var colLen=Object.keys(dataArraytoStore[0]).length;
				for(var key in dataArraytoStore[0])
				{
					fields.push(key);
				}
				var storeObj = Ext.create('Ext.data.ArrayStore', {
					fields: fields,
					proxy : {
						type : 'pagingmemory',
						data:dataArraytoStore,
						reader : {
							type : 'json'
						}
					},
					pageSize:15,
					autoLoad : true,
				});
				var activePage=1;
				resultPanelObj.add({
						xtype:'customgrid',
						//title :  reportData.gridTitle,
						sortableColumns: true,
						needtoFixColumn:true,
						id:'gridId',
						ui:'newGridPanel',
						bodyPadding: '0 0 0 0',
						margin:'0 10 10 10',
						border:true,
						frame:false,
						autoScroll: true,
						scroll: true,
						viewConfig: {
							emptyText: 'No records'
						},
						store:storeObj,
						columns : mainColumnsObjArray,
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						}],
						listeners:{
							sortchange:function( ct, column, direction, eOpts)
							{
								thisController.gridColIndexParam=column.getIndex();
								thisController.gridColStateParam=column.sortState;
								 this.getStore().loadPage(activePage);
							},
							render:function(obj){
							Ext.defer(function() {
							//obj.columns[0].setSortState("ASC",true,true);
							},100);
							}
						}
				});
				resultPanelObj.show();
				resultPanelObj.doLayout();
                
				
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
            }
            if (noDataFound) {
                this.disableTools();
				resultPanelObj.removeAll();
                resultPanelObj.hide();
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
				this.getNomeasurepanel().doLayout();
				this.getNomeasurepanel().show();
            } else resultPanelObj.doLayout();
        } else if (reportGeneration == 'background') {
            resultPanelObj.hide();
  			var htmlStr = '';
            var backgroundReportStatus = jsonData.backgroundReportStatus;
            if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;
                //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;
                //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else {
                htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>';
			}
			 this.getBackGroundPanel().update(htmlStr);
 			 this.getBackGroundPanel().show();
        }
        appConstants.initLdgMask.hide();
    },
    reloadWithAjax: function (obj) {
		var hiddenFields = appConstants.publicjsonData.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        if (obj.getId() == 'er_comptype') {
            this.updateQueryString(false);
            appConstants.queryString += "&compTypeChange=true";
        } else {
            this.updateQueryString(false);
        }
		var me  = this;
		appConstants.queryString += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
        Ext.Ajax.request({
            url: '/final/reporter/ErVmIdleReportJson.jsp',
            params: appConstants.queryString,
            method: 'POST',
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
                var s_option = appConstants.publicjsonData.er_option;
                if (obj.getId() == 'er_option') {
                    if (s_option != 'Component') {
                        comboRawData = appConstants.publicjsonData.siteCombo;
                        selectedComboOption = appConstants.publicjsonData.er_site;
                        comboObject = Ext.getCmp('er_site');
                        comboObject.setFieldLabel(appConstants.publicjsonData.screenLabels['reporter.compliance.eventlog.' + s_option]);
						comboObject.getStore().clearFilter(true); 
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboObject.show();
                        if (s_option == 'Zone') {
                            Ext.getCmp('er_dataZone').show();
                        } else {
                            Ext.getCmp('er_dataZone').hide();
                        }
                    } else {
                        Ext.getCmp('er_site').hide();
                        Ext.getCmp('er_dataZone').hide();
                    }
                }
                if (obj.getId() == 'er_option' || obj.getId() == 'er_site' || obj.getId() == 'er_includezones') {
                    comboRawData = appConstants.publicjsonData.comptypeCombo;
                    selectedComboOption = appConstants.publicjsonData.er_comptype;
                    comboObject = Ext.getCmp('er_comptype');
					comboObject.getStore().clearFilter(true);
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
                }
                comboRawData = appConstants.publicjsonData.componentCombo;
                selectedComboOption = appConstants.publicjsonData.er_component;
                comboObject = Ext.getCmp('er_component');
				appConstants.rawDataForComponents = comboRawData;
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
			if (!isSettingsEnabled)
			{
				me.showConfigDropdown();
			}
			comboRawData = appConstants.publicjsonData.metricCombo;
			selectedComboOption = appConstants.publicjsonData.er_display;
			comboObject = Ext.getCmp('er_display');
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
            }
        });
    },
    updateQueryString: function (needCompnent) {
        var FormParams;
        var hiddenfieldQString = '';
        var timelineParams;
        var timePeriodParams;
		var favorite_id;
        var datafrom = Ext.getCmp('er_option').getValue();
        var compArray = Ext.getCmp('er_component').getValue();
        FormParams = "er_option=" + datafrom + "&er_type=" + Ext.getCmp('er_type').getValue() + "&er_datafrom=" + datafrom;
        if (datafrom != 'Component') {
            FormParams += "&er_site=" + Ext.getCmp("er_site").getValue();
            if (datafrom == 'Zone') {
                FormParams += "&er_dataZone=" + Ext.getCmp("er_dataZone").getValue();
            }
        }
        if (Ext.getCmp('er_type').getValue() == 'No') {
            //FormParams += "&er_sortby=" + Ext.getCmp("er_sortby").getValue();
        } else {
			if (isSettingsEnabled)
			{
				FormParams += "&er_priority=" + Ext.getCmp("er_priority").getValue() + "&er_display=" + Ext.getCmp("er_display").getValue();
			} else {
				FormParams += "&er_priority=" + appConstants.publicjsonData.er_priority + "&er_display=" +appConstants.publicjsonData.er_display;
			}
        }
        var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		FormParams += "&er_comptype=" + Ext.getCmp("er_comptype").getValue();

        if (needCompnent) {
            for (var k = 0; compArray.length > k; k++) {
                FormParams += "&er_component=" + compArray[k];
            }
        }

        var reportGeneration = appConstants.publicjsonData.er_reportgenration;	
        var CPUUtilValue = appConstants.publicjsonData.CPUUtil_val;	
        var DiskIopsValue = appConstants.publicjsonData.DiskIops_val;	
        var NetworkIopsValue = appConstants.publicjsonData.NetworkIops_val;	
        var selectedNetworkIops = appConstants.publicjsonData.selectedNetworkIops;	
        var selectedDiskIops = appConstants.publicjsonData.selectedDiskIops;	
        var selectedCPUUtil = appConstants.publicjsonData.selectedCPUUtil;	
        var CPUtil_AggVal = appConstants.publicjsonData.CPUtil_AggVal;	
        var DiskIOP_AggVal = appConstants.publicjsonData.DiskIOP_AggVal;
		var CPUUtil=appConstants.publicjsonData.CPUUtilCB;
		var DiskIops=appConstants.publicjsonData.DiskIopsCB;
		var NetworkIops=appConstants.publicjsonData.NetworkIopsCB;
		if (isSettingsEnabled)
		{
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
			var cb=Ext.getCmp("CPUtilCb");
			if(!cb.checked)			
				CPUUtil="false";
			else
				CPUUtil="true";
			cb=Ext.getCmp("DiskIOPCb");
			if(!cb.checked)			
				DiskIops="false";
			else
				DiskIops="true";
			cb=Ext.getCmp("NetworkIOPCb");
			if(!cb.checked)			
				NetworkIops="false";
			else
				NetworkIops="true";
			CPUUtilValue = Ext.getCmp("CPUtilVal").getValue();
			DiskIopsValue = Ext.getCmp("DiskIOPVal").getValue();
			NetworkIopsValue = Ext.getCmp("NetworkIOPVal").getValue();
			selectedCPUUtil = Ext.getCmp("CPUtilsort").getValue();
			selectedNetworkIops = Ext.getCmp("NetworkIOPsort").getValue();
			selectedDiskIops = Ext.getCmp("DiskIOPsort").getValue();
			
			CPUtil_AggVal=Ext.getCmp("CPUtil_AggVal").getValue().CPUtil_rb;
			DiskIOP_AggVal=Ext.getCmp("DiskIops_AggVal").getValue().DiskIops_rb;
		}
        FormParams += "&er_reportgenration=" + reportGeneration;
        FormParams += "&NetworkIops=" + NetworkIops+"&CPUUtil="+CPUUtil+"&DiskIops="+DiskIops+"&CPUUtil_sort="+selectedCPUUtil+"&DiskIops_sort="+selectedDiskIops+"&NetworkIops_sort="+selectedNetworkIops+"&NetworkIops_val="+NetworkIopsValue+"&DiskIops_val="+DiskIopsValue+"&CPUUtil_val="+CPUUtilValue+"&CPUUtil_AggVal="+CPUtil_AggVal+"&DiskIops_AggVal="+DiskIOP_AggVal;
     
        if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
            var hiddenFields = appConstants.publicjsonData.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
		
		
        appConstants.queryString = FormParams + timelineParams + hiddenfieldQString;
		if(favorite_id!=undefined)
			 appConstants.queryString+="&id="+favorite_id;
    },
    loadDefaults: function () {
	if(!hideBackButton){
		Ext.getCmp('virtualmachinessprawlmainform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonData['ID']
			}
		);
	}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
        this.fillFormFields(appConstants.publicjsonData);
        this.refreshReportData();
    },
    refreshReportData: function () {
		
        if (appConstants.isSubmit != null && appConstants.isSubmit == "true") {
            appConstants.initLdgMask.show();
            this.loadReportData(appConstants.publicjsonData);
        }
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
    },
    fillFormFields: function (jsonData) {
        var screenLabels = jsonData.screenLabels;

	var hiddenFields = appConstants.publicjsonData['hiddenfields'];
        var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}

        var comboRawData;
        var selectedComboOption;
        var comboObject;
		var s_option = jsonData.er_option;
        comboRawData = jsonData.reportTypeCombo;
        selectedComboOption = jsonData.er_type;
        comboObject = Ext.getCmp('er_type');
        comboObject.setFieldLabel(screenLabels['reporter.common.Report Type']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		comboObject.hide();
        comboRawData = jsonData.analyzeCombo;
        selectedComboOption = jsonData.er_option;
        comboObject = Ext.getCmp('er_option');
        comboObject.setFieldLabel(screenLabels['reporter.common.Analyze by']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		if( s_option != 'Component' ) {
			comboRawData = appConstants.publicjsonData.siteCombo;
			selectedComboOption = appConstants.publicjsonData.er_site;
			comboObject = Ext.getCmp('er_site');
			comboObject.setFieldLabel(appConstants.publicjsonData.screenLabels['reporter.compliance.eventlog.' + s_option]);
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
			if( s_option == 'Zone'){
				 Ext.getCmp('er_dataZone').show();
			}
		}
        comboRawData = jsonData.subzoneCombo;
        selectedComboOption = jsonData.er_includezones;
        comboObject = Ext.getCmp('er_dataZone');
        comboObject.setFieldLabel(screenLabels['reporter.common.Include Subzone']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.comptypeCombo;
        selectedComboOption = jsonData.er_comptype;
        comboObject = Ext.getCmp('er_comptype');
        comboObject.setFieldLabel(screenLabels['reporter.common.Component Type']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.componentCombo;
        selectedComboOption = jsonData.er_component;
        comboObject = Ext.getCmp('er_component');
        Ext.getCmp('componentsLbl').setText(screenLabels['reporter.commom.Component']);
        comboObject.getStore().loadRawData(comboRawData);
		appConstants.rawDataForComponents = comboRawData;
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }

		//}
        var timelineRawData = jsonData.timelineCombo;
        var selectedTimeline = jsonData.selectedTimeline;
        var timelineObj = Ext.getCmp('er_timeline');
        timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
        timelineObj.getStore().loadRawData(timelineRawData);
        if (!Ext.isEmpty(timelineRawData)) {
            if (!Ext.isEmpty(selectedTimeline)) {
                timelineObj.setValue(selectedTimeline);
            } else {
                timelineObj.setValue(timelineRawData[0].valueField);
            }
        }

        var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = jsonData.startDate;
        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = jsonData.startHour;
        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = jsonData.endDate;
        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = jsonData.endHour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		updatingAppSettings();
    },
    reportGenChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var reportGenType = Ext.getCmp('reportGeneration').getValue();
        if (reportGenType == 'background') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
        } 
		else {
            Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
        }
    },
    timeLineOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var startDateObj = Ext.getCmp('er_stdate');
        var startHrObj = Ext.getCmp('er_sthr');
        var endDateObj = Ext.getCmp('er_enddate');
        var endHrObj = Ext.getCmp('er_endhr');
        var timelineObj = Ext.getCmp('er_timeline');
        if (timelineObj.getValue() == 'Any') {
            startDateObj.setDisabled(false);
            startHrObj.setDisabled(false);
            endDateObj.setDisabled(false);
            endHrObj.setDisabled(false);
        } else {
            timelineObj.suspendEvents(true);
            this.updateQueryString(false);
            Ext.Ajax.request({
                url: '/final/reporter/ErVmIdleReportJson.jsp',
                params: appConstants.queryString,
                scope: this,
                success: function (response) {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
                    publicjsonData = jsonData;
                    var start_hour = jsonData.startHour;
                    var end_hour = jsonData.endHour;
                    var start_date = jsonData.startDate;
                    var end_date = jsonData.endDate;
                    startDateObj.setDisabled(true);
                    startHrObj.setDisabled(true);
                    endDateObj.setDisabled(true);
                    endHrObj.setDisabled(true);
                    startDateObj.setValue(start_date);
                    startHrObj.setValue(start_hour);
                    endDateObj.setValue(end_date);
                    endHrObj.setValue(end_hour);
                }
            });
            timelineObj.resumeEvents();
        }
    },
    loadTools: function () {
        this.getNewUtilities().loadIcon(true, //save
        true, //print
        true, //mail
        false, //data
        true, //csv
        true, // fav
        true, // schedule
        false, //daignosis
        false, //togglebutton
        false, //close
        true //booklet
        );
		//Ext.getCmp("upbutton").hide();
        Ext.getCmp("scheduleTool").setDisabled(false);
        Ext.getCmp("favoriteTool").setDisabled(false);
    },
    disableTools: function () {
        Ext.getCmp("bookletTool").setDisabled(true);
        Ext.getCmp("saveTool").setDisabled(true);
        Ext.getCmp("printTool").setDisabled(true);
        Ext.getCmp("mailTool").setDisabled(true);
        //Ext.getCmp("upbutton").setDisabled(true);
        Ext.getCmp("csvTool").setDisabled(true);
    }
});