Ext.define('VirtualMachinesOverview.controller.Main',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort  by option
	views:['Main','TablePanel'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'mainform', ref:'mainform'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'virtualmachinessettings', ref: 'virtualmachinessettings'},
		{selector: 'virtualmachinesmainform', ref: 'virtualmachinesmainform'},
		{selector: 'tablepanel', ref: 'tablepanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'ReporterSettings',ref: 'ReporterSettings'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'main newUtilities':
			{
				'afterrender': this.hideTools
			},
			'main':
			{
				'boxready': this.afterMainRender
			},
			'virtualmachinesmainform':
			{
				'afterrender': this.loadMainForm
			},
			'virtualmachinessettings':
			{
				'afterrender': this.afterSettingsRender
			},
			'virtualmachinesmainform combo[id="er_type"]':
			{
				'select': this.changeReportType
			},
			'virtualmachinesmainform combo[id="selection"]':
			{
				'select': this.changeSelection
			},
			'virtualmachinesmainform combo[id="compType"]':
			{
				'select': this.changeComponentType
			},
			'virtualmachinesmainform combo[id="select_group"]':
			{
				'select': this.changeAnalysis
			},
			'egcomponent combo[id="components"]':
			{
				'select': this.selectComponents
			},
			'virtualmachinesmainform combo[id="er_hostdisplay"]':
			{
				'select': this.changePhysicalServers
			},
			'mainform button[itemId="submit"]':
			{
				'click': this.beforeFormSubmit
			},
			'mainform button[itemId="save"]':
			{
				'click': this.goTo
			},
			'virtualmachinesmainform combo[id="zone"]':
			{
				'select': this.changeZone
			},
			'virtualmachinesmainform combo[id="segment"]':
			{
				'select': this.changeSegment
			},
			'virtualmachinesmainform combo[id="service"]':
			{
				'select': this.changeService
			},
			'virtualmachinesmainform combo[id="subzone"]':
			{
				'select': this.changeSubZone
			},
			'virtualmachinessettings combo[id="er_trenddata"]':
			{
				'select': this.changeDetailedTrend
			},
			/* 'virtualmachinessettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekEnd
			}, */
			'virtualmachinesmainform combo[id="ermeasuretest"]':
			{
				'select': this.changeMeasureTest
			},
			'virtualmachinessettings combo[id="er_timeline"]':
			{
				//'select': this.changeTimeline
			},
			'virtualmachinessettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'virtualmachinessettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualmachinessettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.callCSV
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
            'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'egcomponent button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	showConfigDropdown:function()
	{
		var totalIcon = this.getNewUtilities().items.length
		var valueLeft = totalIcon*26;
		// 20 for more icon, remaining 8 for margin
		// 700 is window width
		valueLeft = 700-(valueLeft+20+8);
		valueLeft = valueLeft+'px';
		isSettingsEnabled = true;
		var me = this;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		//layout:'vbox',
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		//html:tpl.apply(),
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				//style:{'top':'-14px','left':valueLeft}
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'virtualmachinessettings',
				itemId: 'settingsForm',
				parent:this
			}

		],
		renderTo:'virtualMachinesPanel'
		});
		Ext.get('closeSettings').on('click',function()
		{	
			me.validateAndCloseSettings();
		});
	},
	validateAndCloseSettings:function()
	{
		var isSettingss = this.validateSettings();
		if(isSettingss)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.beforeFormSubmit();
		}
	},
	goTo: function (btn) {
 		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'VirtualMachines Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
 		var hiddens = appConstants.publicJSON['hiddens'];
		var from_favorite = hiddens["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites(btn);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.showSchedules(btn);
		}
    },
	changeEr_mode: function (combo) {
		var favorite_id = appConstants.publicJSON['hiddens']["favorite_id"];
		var from_schModify = appConstants.publicJSON['hiddens']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.beforeFormSubmit();
    },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('components'),appConstants.rawDataForComponents);

    },
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),'Components',btn);
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	callCSV: function()
	{
		var queryString = this.genQueryString();
		document.location = '/final/servlet/egurkha.reporter.SaveInCSVFormat';
	},
	showFavorites: function(obj)
	{
		this.formSubmit(obj);

		var qString = appConstants.queryString;
		qString += '&isSubmit=true';
		var hiddens = appConstants.publicJSON['hiddens'];
		var er_favorite=appConstants.publicJSON['hiddens']['er_favorite']
		var favorite_id = hiddens["favorite_id"];
		var target= '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client&er_view=GRAPH'+'&er_favorite='+er_favorite+"&er_RmDispName="+appConstants.er_RmDispName+'&com.eg.CSRF_NONCE='+csrfToken;//&FavoriteId='+favorite_id;

		if (obj.getItemId()=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


	},
	showSchedules: function(obj)
	{
		this.formSubmit(obj);
		var qString = appConstants.queryString;
		var from_schModify = appConstants.publicJSON['hiddens']["fromScheduleModify"];
        if (from_schModify != null && from_schModify == "Yes") {
			this.updateQStringForSchedule();
			qString = qstringForSch;
		}

		var target = '/final/reporter/ErSaveSchedule.jsp?'+qString+'&er_rtype=Virtualization&pageWidthProces='+appConstants.publicJSON['hiddens']["pagewidth"]+'&com.eg.CSRF_NONCE='+csrfToken;

		
		if (obj.getItemId()=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	printMe: function()
	{
 		parent.printWindowFn(appConstants.publicJSON['PRINT_URL']); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	saveMe: function()
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		if(appConstants.publicJSON['PDF_URL']!=undefined && appConstants.publicJSON['PDF_URL'].indexOf('reporter/ErHtmlToSavePdf.jsp?')>-1)
			appConstants.erUtils.savePDF(appConstants.publicJSON['PDF_URL']);
		else
		appConstants.erUtils.savePDF('/final/reporter/ErHtmlToSavePdf.jsp?'+appConstants.publicJSON['PDF_URL']);
	},
	bookletQuery: function(obj)
	{
		if(appConstants.publicJSON['PDF_URL']!=undefined && appConstants.publicJSON['PDF_URL'].indexOf('../reporter/ErHtmlToSavePdf.jsp?')>-1)
			return appConstants.publicJSON['PDF_URL'].replace('../reporter/ErHtmlToSavePdf.jsp?','');
		else
		return appConstants.publicJSON['PDF_URL'];
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString+'&er_rtype=Virtualization&pageWidthProces='+appConstants.publicJSON['hiddens']["pagewidth"];;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	changeSubZone: function()
	{
		this.changeZone( Ext.getCmp('zone') );
	},
	changeZone: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.formSubmit( obj );
		}
	},
	changeSegment: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.formSubmit( obj );
		}
	},
	changeService: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.formSubmit( obj );
		}
	},
	beforeFormSubmit: function()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var startdate = Ext.getCmp('er_stdate').getValue();
        var starthr = Ext.getCmp('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = Ext.getCmp('er_enddate').getValue();
        var endhr = Ext.getCmp('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var select_groupVal = Ext.getCmp('select_group').getValue();
		var mainForm = this.getVirtualmachinesmainform().getForm();
		var compTypeVal = mainForm.findField('compType').getValue();
		var componentsVal = Ext.getCmp('components').getValue();
		
		var result = true;
		var msg = '';
		if ( select_groupVal == 'Zone' && Ext.getCmp('zone').getValue() == '-1' )
		{
			result = false;
			msg = appConstants.plsChoose+' Zone';
		}
		else if ( select_groupVal == 'Segment' && Ext.getCmp('segment').getValue() == '-1' )
		{
			result = false;
			msg = appConstants.plsChoose+' Segment';
		}
		else if ( select_groupVal == 'Service' && Ext.getCmp('service').getValue() == '-1' )
		{
			result = false;
			msg = appConstants.plsChoose+' Service';
		}
		else if(compTypeVal == '-1')
		{
			result = false;
			msg = appConstants.plsChoose+' Component Type';
		}else if(componentsVal == '-1'){
			result = false;
			msg = appConstants.plsChoose+' Components';
		}
		if (!result)
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: msg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			return;
		}

		if ( this.validateSettings() )
		{
 			this.formSubmit(Ext.getCmp('mainform').getComponent('submit'));
		}

	},
	formSubmit: function( obj )
	{
		var me = this;
		var mainForm = this.getVirtualmachinesmainform().getForm();
		var jsonData = appConstants.publicJSON;
		appConstants.hidenerfav=appConstants.publicJSON['hiddens']['er_favorite'];
		this.genQueryString();
		var forwardto = '';
		var param = '';
		var reportTypeVal = mainForm.findField('er_type').getValue();
		var selectionVal = mainForm.findField('selection').getValue();
		var compTypeVal = mainForm.findField('compType').getValue();
		var selectGroupVal = mainForm.findField('select_group').getValue();
		var includeSubZoneVal = Ext.getCmp('subzone').getValue();
		var select_groupName = Ext.getCmp('components').getValue();
		this.getNomeasurepanel().hide();
		var er_hostdisplayVal = jsonData['selectedValues']['physicalServerSelected'];//settingsForm.findField('er_hostdisplay').getValue();
		var er_trenddataVal = jsonData['selectedValues']['showDataSelected'];
		var er_excweVal = jsonData['selectedValues']['excludeWeekEndSelected'];
		var ermeasuretestVal = jsonData['selectedValues']['measureSelected'];
		var er_showbyVal = jsonData['selectedValues']['showSelected'];
		var timefromVal = jsonData['selectedValues']['timeFromHrSelected'];
		var timetoVal = jsonData['selectedValues']['timeToHrSelected'];
		var minfromVal = jsonData['selectedValues']['timeFromMinSelected'];
		var mintoVal = jsonData['selectedValues']['timeToMinSelected'];
		var er_reportgenrationVal = jsonData['selectedValues']['reportGenerationSelected'];
		var bgReportNameVal = jsonData['selectedValues']['reportName'];
		if (isSettingsEnabled)
		{
			//Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			var settingsForm = this.getVirtualmachinessettings().getForm();
			er_hostdisplayVal = settingsForm.findField('er_hostdisplay').getValue();
			er_trenddataVal = settingsForm.findField('er_trenddata').getValue();
			er_excweVal = settingsForm.findField('er_excwe').getValue();
			if ( !Ext.isEmpty( mainForm.findField('ermeasuretest').getValue() ) )
			{
				ermeasuretestVal = mainForm.findField('ermeasuretest').getValue();
			}
			if ( !Ext.isEmpty( settingsForm.findField('er_showby').getValue() ) )
			{
				er_showbyVal = settingsForm.findField('er_showby').getValue();
			}
			timefromVal = settingsForm.findField('timefrom').getValue();
			timetoVal = settingsForm.findField('timeto').getValue();
			minfromVal = settingsForm.findField('minfrom').getValue();
			mintoVal = settingsForm.findField('minto').getValue();
			er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
			bgReportNameVal = settingsForm.findField('bgReportName').getValue();
			bgReportNameVal=checkFileName(bgReportNameVal);

		}
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var er_modeVal = mainForm.findField('er_mode').getValue();
		var er_timelineObj = mainForm.findField('er_timeline');

		var er_stdate = mainForm.findField('er_stdate').dataArray;
		var er_enddate = mainForm.findField('er_enddate').dataArray;
		var er_sthr = mainForm.findField('er_sthr').dataArray;
		var er_endhr = mainForm.findField('er_endhr').dataArray;

		var stdateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(Ext.getCmp('er_enddate').dataArray, mgrDateFormat));
		var beanst_date = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
        var beanen_date = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));


		var trendenableVal = false;
		if ( er_trenddataVal == 'Yes' )
		{
			trendenableVal = true;
		}
		var fromReportType = false;
		var fromSubmit = false;
		var fromSelection = false;
		var showLoading = false;
		var fromCompType = false;
		var fromZone = false;
		var fromSegment = false;
		var fromService = false;
		var fromTimeline = false;
		var fromDetailedTrend = false;
		var fromSubmit = false;
		if ( !Ext.isEmpty( obj ) )
		{
			var id = obj.getId();
			
			if ( id == 'er_type' )
			{
				fromReportType = true;
			}
			else if ( obj.getItemId() == 'submit' )
			{
				fromSubmit = true;
				showLoading = true;
			}
			else if ( id == 'selection' )
			{
				fromSelection = true;
				showLoading = true;
			}
			else if ( id == 'compType' )
			{
				fromCompType = true;
			}
			else if ( id == 'zone' )
			{
				fromZone = true;
				//select_groupName = mainForm.findField('zone').getValue();
			}
			else if ( id == 'segment' )
			{
				fromSegment = true;
				//select_groupName = mainForm.findField('segment').getValue();
			}
			else if ( id == 'service' )
			{
				fromService = true;
				//select_groupName = mainForm.findField('service').getValue();
			}
			else if ( id == 'er_timeline' )
			{
				fromTimeline = true;
			}
			else if ( id == 'er_trenddata' )
			{
				fromDetailedTrend = true;
			}
			else if ( obj.getItemId() == 'submit' )
			{
				fromSubmit = true;
			}
		}
		if ( showLoading )
		{
	
			initLdgMask.show();
		}
		var genSelGrpName = '';
		if( select_groupName!='undefined' ||select_groupName!=undefined ||select_groupName!=null ||select_groupName!='null'  )
		{
			
		if ( selectGroupVal == 'Component' )
		{
			for ( var i = 0; i < select_groupName.length; i++ )
			{
				genSelGrpName += '&select_groupName='+encodeURI(select_groupName[i]);
			}
		}
		else
		{
			if ( selectGroupVal != 'Component' && selectGroupVal != '-1' )
			{
				var select_groupName = mainForm.findField(selectGroupVal.toLowerCase()).getValue();
				genSelGrpName = '&select_groupName='+select_groupName+'&select_farm='+select_groupName;
			}
			else
			{
				genSelGrpName = '&select_groupName=&select_farm=';
			}
		}
		}
		param = '&er_rtype=Virtualization&bg_reportname='+encodeURI(bgReportNameVal)+'&endhr='+encodeURI(er_endhr)+'&starthr='+encodeURI(er_sthr)+'&enddate='+encodeURI(er_enddate)+'&startdate='+encodeURI(er_stdate)+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&er_mode='+encodeURI(er_modeVal)+'&beanstartdate='+beanst_date+'&beanenddate='+beanen_date+'&er_trenddata='+encodeURI(er_trenddataVal)+'&minto='+encodeURI(mintoVal)+genSelGrpName+'&er_comptype='+encodeURI(compTypeVal)+'&er_excwe='+encodeURI(er_excweVal)+'&er_timeline='+encodeURI(er_timelineVal)+'&timefrom='+encodeURI(timefromVal)+'&minfrom='+encodeURI(minfromVal)+'&er_reportgenration='+encodeURI(er_reportgenrationVal)+'&ervm_type='+selectionVal+'&select_group='+encodeURI(selectGroupVal)+'&timeto='+encodeURI(timetoVal)+'&forwardto=ErEsxReportJSON&trendenable='+encodeURI(trendenableVal)+'&er_type='+reportTypeVal+'&call=json&includeSubZone='+encodeURI(includeSubZoneVal);
		param += '&ermeasuretest='+encodeURI(ermeasuretestVal)+'&er_showby='+encodeURI(er_showbyVal);

		if ( selectionVal == 'Yes' )
		{
//			param += '&ermeasuretest='+encodeURI(ermeasuretestVal)+'&er_showby='+encodeURI(er_showbyVal);
		}
		if ( selectionVal == 'No' )
		{
			param += '&er_hostdisplay='+encodeURI(er_hostdisplayVal);
		}

		param += '&'+appConstants.hiddenQStr;

		var URL = '/final/reporter/ErEsxReportJSON.jsp';

		if ( fromSubmit )
		{
			param += '&isSubmit=true';
			URL = '/final/servlet/com.eg.ErEsxServerReportC';
		}
 		
 		appConstants.queryString = param;
		if ( !Ext.isEmpty( Ext.getCmp('fromSchedule') ) )
		{
			var fromSchedule = Ext.getCmp('fromSchedule').getValue();
			if ( fromSchedule == 'Yes' && obj.getItemId() == 'submit' )
			{
 				document.location = '/final/reporter/ErSaveSchedule.jsp?'+param;
			}
		}
		if ( er_reportgenrationVal == 'background' )
		{
			URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
		}
		else if ( er_reportgenrationVal == 'background-csv' )
		{
			URL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
		}
		var hiddens = appConstants.publicJSON['hiddens'];
		var from_favorite = hiddens["fromFavoriteModify"];
		var favorite_id = hiddens["favorite_id"];
		var pagewidth = hiddens["pagewidth"];
		param += "&fromFavoriteModify="+from_favorite+"&id="+favorite_id;
		param += '&er_RmDispName='+appConstants.er_RmDispName;
		param += '&pageWidthProces='+pagewidth;
		Ext.Ajax.request(
		{
			url: URL,
			params: param,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					appConstants.publicJSON = jsonData;
					var hiddens = jsonData['hiddens'];
					var screenLabels = jsonData['screenLabels'];
					me.loadHiddens( hiddens );
					me.loadScreenLabels( screenLabels );
					if ( fromReportType )
					{
						var measureComboData = jsonData['measureCombo'];
						var showCombo = jsonData['showCombo'];
						var measureObj = mainForm.findField('ermeasuretest');
						var showObj = settingsForm.findField('er_showby');
						if ( !Ext.isEmpty( measureComboData ) )
						{
							measureObj.suspendEvents(true);
							measureObj.getStore().clearFilter(true); 
							measureObj.getStore().loadRawData(measureComboData);
							measureObj.setValue(measureComboData[0]['valueField']);
							measureObj.resumeEvents();
						}
						if ( !Ext.isEmpty( showCombo ) )
						{
							showObj.suspendEvents(true);
							showObj.getStore().loadRawData(showCombo);
							showObj.setValue(showCombo[0]['valueField']);
							showObj.resumeEvents();
						}
					}
					else if ( fromSubmit )
					{
						var gridContainer = Ext.getCmp('gridContainer');
						gridContainer.removeAll();
						var getResultType = er_reportgenrationVal;
						var resultObj = Ext.getCmp('resultPanel');
						resultObj.show();
						if ( getResultType == 'foreground' )
						{
							me.getBackGroundPanel().hide();
							var resultData = jsonData['RESULTS'];
							var title = '';

							if(!Ext.isEmpty(resultData))
							{
								if ( reportTypeVal == 'Yes' )
								{
									title = resultData['TITLE'];
									if ( Ext.isEmpty( title ) )
									{
										title = mainForm.findField('ermeasuretest').getRawValue();
									}
								}
								else
								{
									title = resultData['GRID_RESULTS']['TITLE']
								}
							}
							if ( !Ext.isEmpty( title) )
							{
								resultObj.removeAll();
								if ( reportTypeVal == 'Yes' )
								{
									resultObj.setTitle("<span class='font_bold'>"+title+"</span>");
									resultObj.getHeader().show();
									me.loadCharts( jsonData );
									Ext.getCmp('csvTool').setDisabled(true);
								}
								else
								{
									/*if(resultObj.getHeader()){
										resultObj.preventHeader = true;
										resultObj.getHeader().hide();
									}*/
									//me.getTablepanel().setTitle('');
	/*								if ( !Ext.isEmpty(me.getTablepanel().getHeader() ) )
									{
										//me.getTablepanel().getHeader().hide();
									}*/
 									me.loadGrid( jsonData );
									Ext.getCmp('csvTool').setDisabled(false);
								}
								me.enableTools();
							}
							else
							{
								Ext.getCmp('gridContainer').hide();
								resultObj.hide();
								me.getNomeasurepanel().doLayout();
								me.getNomeasurepanel().show();
								Ext.getCmp('panelinsidetoggle').setDisabled(true);
							}
						}
						else
						{
							resultObj.hide();
							Ext.getCmp('gridContainer').hide();
 							var backgroundResultsData = jsonData['backgroundResults'];
							if ( !Ext.isEmpty( backgroundResultsData ) )
							{
								var backgroundResultStatus = backgroundResultsData['status'];
								var backgroundResponseText = backgroundResultsData['backgroundResult'];
								var backgroundResultURL = backgroundResultsData['backgroundResultURL'];
								var backgroundResultURLLinkText = backgroundResultsData['backgroundResultURLText'];
								var htmlStr = '';
								if ( backgroundResultStatus == 'success' )
								{
									//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
									htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
								}
								else if ( backgroundResultStatus == 'duplicate' )
								{
									//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
									htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
								}
								me.getBackGroundPanel().update(htmlStr);
 								me.getBackGroundPanel().show();
								me.disableTools();
							}
						}
					}
					else if ( fromSelection )
					{
						if (!isSettingsEnabled)
						{
							this.showConfigDropdown();
						}
						var er_hostdisplayObj = settingsForm.findField('er_hostdisplay');
						var physicalServerComboData = jsonData['physicalServerCombo'];
						if ( !Ext.isEmpty( physicalServerComboData ) )
						{
							er_hostdisplayObj.suspendEvents(true);
							er_hostdisplayObj.getStore().loadRawData( physicalServerComboData );
							if ( !Ext.isEmpty( jsonData['selectedValues']['physicalServerSelected'] ) )
							{
								er_hostdisplayObj.setValue(jsonData['selectedValues']['physicalServerSelected']);
							}
							er_hostdisplayObj.resumeEvents();
						}
						var measureComboData = jsonData['measureCombo'];
						var measureObj = mainForm.findField('ermeasuretest');
						if ( !Ext.isEmpty( measureComboData ) )
						{
							measureObj.suspendEvents(true);
							measureObj.getStore().clearFilter(true); 
							measureObj.getStore().loadRawData(measureComboData);
							measureObj.setValue(measureComboData[0]['valueField']);
							measureObj.resumeEvents();
						}
					}
					else if ( fromCompType )
					{

                                                var groupComboData = jsonData['groupCombo'];
						var loadComboObj = '';
						if ( selectGroupVal == 'Component' )
						{
							loadComboObj = Ext.getCmp('components');
							appConstants.rawDataForComponents = groupComboData;
						}
						else if ( selectGroupVal == 'Zone' )
						{
							loadComboObj = mainForm.findField('zone');
						}
						else if ( selectGroupVal == 'Segment' )
						{
							loadComboObj = mainForm.findField('segment');
						}
						else if ( selectGroupVal == 'Service' )
						{
							loadComboObj = mainForm.findField('service');
						}

						
						if ( !Ext.isEmpty( groupComboData ) )
						{
							loadComboObj.suspendEvents(true);
							loadComboObj.getStore().loadRawData(groupComboData);
							if ( selectGroupVal != 'Component' )
							{
								loadComboObj.setValue(groupComboData[0]['valueField']);
							}
							else
							{
								var selArr = new Array();
								for ( var i = 0; i < groupComboData.length; i++ )
								{
									selArr[selArr.length] = groupComboData[i]['valueField'];
								}
								loadComboObj.setValue(selArr);
							}
							loadComboObj.resumeEvents();
						}
						else
						{
							me.insertNotApplicable(loadComboObj);
						}

						if ( !Ext.isEmpty( jsonData['selectedValues']['subzoneSelected'] ) )
						{
							mainForm.findField('subzone').setValue(jsonData['selectedValues']['subzoneSelected']);
						}
						var measureComboData = jsonData['measureCombo'];
						var measureObj = mainForm.findField('ermeasuretest');
						if ( !Ext.isEmpty( measureComboData ) )
						{
							measureObj.suspendEvents(true);
							measureObj.getStore().clearFilter(true); 
							measureObj.getStore().loadRawData(measureComboData);
							measureObj.setValue(measureComboData[0]['valueField']);
							measureObj.resumeEvents();
						}
					}
					if ( showLoading )
					{
						initLdgMask.hide();
					}
				}
			}
		});
	},
	updateQStringForSchedule: function()
	{
		var me = this;
		var mainForm = this.getVirtualmachinesmainform().getForm();
		var settingsForm = this.getVirtualmachinessettings().getForm();
		var jsonData = appConstants.publicJSON;

		this.genQueryString();
		var param = '';
		var reportTypeVal = mainForm.findField('er_type').getValue();
		var selectionVal = mainForm.findField('selection').getValue();
		var compTypeVal = mainForm.findField('compType').getValue();

		var selectGroupVal = mainForm.findField('select_group').getValue();
		var includeSubZoneVal = Ext.getCmp('subzone').getValue();
		var select_groupName = Ext.getCmp('components').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var er_modeVal = mainForm.findField('er_mode').getValue();
		var ermeasuretestVal = '';
		if ( !Ext.isEmpty( mainForm.findField('ermeasuretest').getValue() ) )
		{
			ermeasuretestVal = mainForm.findField('ermeasuretest').getValue();
		}

		var er_stdate = mainForm.findField('er_stdate').dataArray;
		var er_enddate = mainForm.findField('er_enddate').dataArray;
		var er_sthr = mainForm.findField('er_sthr').dataArray;
		var er_endhr = mainForm.findField('er_endhr').dataArray;

		var stdateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, appConstants.mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(Ext.getCmp('er_enddate').dataArray, appConstants.mgrDateFormat));
		var beanst_date = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
        var beanen_date = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));

		var er_hostdisplayVal = jsonData['selectedValues']['physicalServerSelected'];//settingsForm.findField('er_hostdisplay').getValue();
		var er_trenddataVal = jsonData['selectedValues']['showDataSelected'];
		var er_excweVal = jsonData['selectedValues']['excludeWeekEndSelected'];
		var er_showbyVal = jsonData['selectedValues']['showSelected'];
		var timefromVal = jsonData['selectedValues']['timeFromHrSelected'];
		var timetoVal = jsonData['selectedValues']['timeToHrSelected'];
		var minfromVal = jsonData['selectedValues']['timeFromMinSelected'];
		var mintoVal = jsonData['selectedValues']['timeToMinSelected'];
		var er_reportgenrationVal = jsonData['selectedValues']['reportGenerationSelected'];
		var bgReportNameVal = jsonData['selectedValues']['reportName'];
		if (isSettingsEnabled)
		{
			er_hostdisplayVal = settingsForm.findField('er_hostdisplay').getValue();
			er_trenddataVal = settingsForm.findField('er_trenddata').getValue();
			er_excweVal = settingsForm.findField('er_excwe').getValue();
			if ( !Ext.isEmpty( settingsForm.findField('er_showby').getValue() ) )
			{
				er_showbyVal = settingsForm.findField('er_showby').getValue();
			}
			timefromVal = settingsForm.findField('timefrom').getValue();
			timetoVal = settingsForm.findField('timeto').getValue();
			minfromVal = settingsForm.findField('minfrom').getValue();
			mintoVal = settingsForm.findField('minto').getValue();
			er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
			bgReportNameVal = settingsForm.findField('bgReportName').getValue();
			bgReportNameVal=checkFileName(bgReportNameVal);

		}

		var genSelGrpName = '';
		if ( select_groupName.length > 0 && selectGroupVal == 'Component' )
		{
			for ( var i = 0; i < select_groupName.length; i++ )
			{
				genSelGrpName += '&select_groupName='+encodeURI(select_groupName[i]);
			}
		}
		else
		{
			if ( selectGroupVal != 'Component' && selectGroupVal != '-1' )
			{
				var select_groupName = mainForm.findField(selectGroupVal.toLowerCase()).getValue();
				genSelGrpName = '&select_groupName='+select_groupName+'&select_farm='+select_groupName;
			}
			else
			{
				genSelGrpName = '&select_groupName=&select_farm=';
			}
		}
		var trendenableVal = false;
		if ( er_trenddataVal == 'Yes' )
		{
			trendenableVal = true;
		}
		param = '&er_rtype=Virtualization&bg_reportname='+encodeURI(bgReportNameVal)+'&endhr='+encodeURI(er_endhr)+'&starthr='+encodeURI(er_sthr)+'&enddate='+encodeURI(er_enddate)+'&startdate='+encodeURI(er_stdate)+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&er_mode='+encodeURI(er_modeVal)+'&beanstartdate='+beanst_date+'&beanenddate='+beanen_date+'&er_trenddata='+encodeURI(er_trenddataVal)+'&minto='+encodeURI(mintoVal)+genSelGrpName+'&er_comptype='+encodeURI(compTypeVal)+'&er_excwe='+encodeURI(er_excweVal)+'&er_timeline='+encodeURI(er_timelineVal)+'&timefrom='+encodeURI(timefromVal)+'&minfrom='+encodeURI(minfromVal)+'&er_reportgenration='+encodeURI(er_reportgenrationVal)+'&ervm_type='+selectionVal+'&select_group='+encodeURI(selectGroupVal)+'&timeto='+encodeURI(timetoVal)+'&forwardto=ErEsxReportJSON&trendenable='+encodeURI(trendenableVal)+'&er_type='+reportTypeVal+'&call=json&includeSubZone='+encodeURI(includeSubZoneVal);

		param += '&ermeasuretest='+encodeURI(ermeasuretestVal)+'&er_showby='+encodeURI(er_showbyVal);


		if ( selectionVal == 'No' )
		{
			param += '&er_hostdisplay='+encodeURI(er_hostdisplayVal);
		}

		param += '&'+appConstants.hiddenQStr;
		

		qstringForSch = param;
	},
	loadGrid: function( jsonData )
	{
 
		var resultData = jsonData['RESULTS'];

		var thisController=this;
		var resultObj = this.getTablepanel();
		resultObj.hide();

		var gridContainer = Ext.getCmp('gridContainer');
		gridContainer.removeAll();
 		//Ext.select('.dataPanel').setStyle('border-color','#ffffff');
		var width = gridContainer.getWidth();
		var colWidth = 0;
		var gridData = resultData['GRID_RESULTS'];

		if ( !Ext.isEmpty( gridData ) )
		{
			var getTitle = gridData['TITLE'];
			var getCols = gridData['COLUMNS'];
			var colArr = new Array();
			var getVals = gridData['VALUES'];
			var outerCols = gridData['COLUMN_NAMES'];
			var outerColArr = new Array();
			var colWidth = Math.floor( width / outerCols.length );
			var index =0;
			for ( var i = 0; i < outerCols.length; i++ )
			{
				var headerName = '';
				var subColumnCount = 0;
				for ( var key in outerCols[i] )
				{
					if ( key.indexOf('SUB_COLUMNS') == -1 )
					{
						headerName = outerCols[i][key];
					}
					else
					{
						subColumnCount = outerCols[i]['SUB_COLUMNS'];
					}
				}
				var subColsData = gridData['COLUMNS'];
				var subColArr = new Array();
				if ( subColumnCount > 0 )
				{
					for ( var j = 0; j < subColumnCount; j++ )
					{
						var val = subColsData[index]['COLUMN_'+index];
						var align='center';
						if (i==0)
						{
 							align='left';
						}
						//prakash
						if(headerName == 'Operating Systems')
						{
							align='left'
						}
						//
						subColArr.push({
							header: val,
							sortable: true,
							//width:150,
							align: align,
							dataIndex: 'COLUMN_'+index,
							renderer: function( val,metaData )
							{
								if ( !Ext.isEmpty(val['LINK']) && !Ext.isEmpty(val['TEXT']) )
								{
									var link = val['LINK'];
									var label = val['TEXT'];
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+label+'"';
									return '<a class="anchorLinkDefault" href="'+link+'">'+label+'</a>';
								}
								else
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
									val = Ext.getCmp('gridId').getDecimalAlignFormat(val);
									return val;
								}
							},

								doSort: function(state) {

											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													//if (v1.index==0 || v1.index==undefined)
													//return;
													if (v1.data[Object.keys(v1.data)[0]]=='Summary')
													{
														return;
													}
													
													v1 = v1.get(field);
													v2 = v2.get(field);
													if(v1.TEXT != undefined)
													{
														v1=v1.TEXT;
														v2=v2.TEXT;
														v1 = v1.toLowerCase();
														v2 = v2.toLowerCase();
													}
													else
													{
														v1 = v1.toLowerCase();
														v2 = v2.toLowerCase();
													}
													if(!isNaN(v1) && !isNaN(v2))
													{
														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v1= isNaN(v1) ? 0 : v1;
														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														v2= isNaN(v2) ? 0 : v2;
													}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										}
						});
						index++;
					}
					//index++;
				}


				/*var measureData = gridData['MEASURE_NAMES'];
				var measureCol = new Array();
				measureCol.push({
					header: measureData[i],
					align: 'center',
					columns: subColArr
				});*/
				var isLocked = false;
				if(i==0)
				{
					isLocked = true;
				}
				if ( subColumnCount > 0 )
				{
					if(isLocked && headerName == 'Virtual Machines')
					{
						outerColArr.push({
							header: headerName,
							sortable: true,
							locked:isLocked,// vengat
							columns: subColArr,
							width:125,
							align: 'center'
						});
					}
					else
					{
						outerColArr.push({
							header: headerName,
							sortable: true,
							locked:isLocked,// vengat
							columns: subColArr,
							align: 'center'
						});
					}
				}
				else
				{
					if ( i == 0 || i == ( outerCols.length - 1 ) )
					{
						outerColArr.push({
							header: headerName,
							align: 'center',
							dataIndex: 'COLUMN_'+i,
 							renderer: function( val,metaData )
							{
								if ( !Ext.isEmpty(val['LINK']) && !Ext.isEmpty(val['TEXT']) )
								{
									var link = val['LINK'];
									var label = val['TEXT'];
									return '<a class="anchorLinkDefault" href="'+link+'">'+label+'</a>';
								}
								else
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
									val = Ext.getCmp('gridId').getDecimalAlignFormat(val);
									return val;
								}
							},
							doSort: function(state) {

								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2){
										if (v1.index==0)
											return;
										v1 = v1.get(field);
										v2 = v2.get(field);
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
						});
					}
					else
					{
						outerColArr.push({
							header: headerName,
							align: 'center'
						});
					}
				}

			}
			for ( var i = 0; i < getCols.length; i++ )
			{
				colArr[i] = 'COLUMN_'+i;
			}

			var isPagingHidden;
			if (getVals.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;

			resultObj.removeAll();
			var activePage=1;

			var store=Ext.create('Ext.data.Store', {
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:gridPageSize,
				fields: colArr,
				data : getVals,
				remoteSort : true,
				autoLoad : true,
				sorters: { property: colArr[0], direction : 'ASC' }// vengat
				
			});
			gridContainer.setTitle(getTitle);
			gridContainer.add({
				xtype:'customgrid',
				border:true,
				forceFit:true,
				id:'gridId',
				ui:'newGridPanel',
				padding:0,
				margin:'0 10 10 10',
				needtoFixColumn:true,
				autoScroll: true,
				scroll: true,
				sortableColumns: true,
				viewConfig: {
					emptyText: 'No records',
					getRowClass: function(record, rowIndex, rowParams, store){
							if (rowIndex==0)
							{
								if (record.data[Object.keys(record.data)[0]]=='Summary')
								{
									return 'firstRowClass'; //configured in ext-custom-com.css
								}
								
							}
						}
				},
				store:store,
				columns : outerColArr,
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: store,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: {
						change : function(thisd, params)
						{   
							activePage = params.currentPage;
						}
					}
				}],
				listeners:{
					render:function(obj){
						Ext.defer(function() {
							//obj.columns[0].items.items[0].setSortState("ASC",true,true); // vengat
						},100);
					},
					sortchange:function( ct, column, direction, eOpts ){
						thisController.gridColIndexParam=column.getIndex();
						thisController.gridColStateParam=column.sortState;
						//this.getStore().loadPage(activePage); 
					}
				}
			});
			gridContainer.show();
			Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
		}
		else
		{
			this.getNomeasurepanel().show();
			gridContainer.hide();
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
		}
	},
	loadCharts: function ( jsonData )
	{
		var resultData = jsonData['RESULTS'];
		var resultObj = Ext.getCmp('resultPanel');
		 Ext.getCmp('gridContainer').hide();
  		try
		{
			var noMeasureDisplayed = false;
			var distChartData = resultData['DISTRIBUTION_CHART_RESULTS'];
			if ( !Ext.isEmpty( distChartData ) )
			{
				var chartTitle = distChartData['TITLE'];
				var swfPath = distChartData['SWF_PATH'];
				var xmlData = distChartData['XMLDATA'];
				var hasLegends = false;

				if ( !Ext.isEmpty( distChartData['LEGENDS'] ))
				{
					hasLegends = true;
					var legendsData = distChartData['LEGENDS'];
					var legendLinks = legendsData['LEGEND_LINKS'];
					
					appConstants.pieChartArr = legendsData['LEGEND_KEYS'];
					for ( var key in legendLinks )
					{
						var color = legendLinks[key]['COLOR'];
						var label = legendLinks[key]['LABEL'];
						var link = legendLinks[key]['LINK'];
					}
				}
				if ( !Ext.isEmpty( xmlData ) )
				{

					if ( hasLegends )
					{
						
						resultObj.add(
							{
								xtype: 'panel',
								ui:'newGraphPanel',
								id:'leftChartContent',
 								columnWidth:0.35,
								height:350,
								title:chartTitle,
								margin:'0 10 10 10',
    							html:''
							}
						);
					}
					else
					{
						resultObj.add(
							{
								xtype: 'panel',
								ui:'newGraphPanel',
								height: 300,
								html:'<div style="border:0px solid red;width:100%;height:100%;text-align:center;" id="distChartz"></div>'
							}
						);
					}
					 if (Ext.isEmpty(appConstants.erUtils))
						{
						appConstants.erUtils = Ext.widget("erutils");
						}
					appConstants.erUtils.updatePieChart(appConstants.chartType,distChartData.LEGENDS.LEGEND_LINKS,'COLOR','LINK','LABEL','',distChartData.XMLDATA,distChartData.SWF_PATH,distChartData,Ext.getCmp('leftChartContent'));

					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
				else
				{
					resultObj.hide();
					noMeasureDisplayed = true;
 					this.getNomeasurepanel().show();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
				}
			}

			if (!Ext.isEmpty( resultData['TOP_CHART_RESULTS'] ) )
			{
				var topChartData = resultData['TOP_CHART_RESULTS'];
				var topChartTitle = topChartData['TITLE'];
				var topChartHeight = topChartData['HEIGHT'];
				var topChartSWFPath = topChartData['SWF_PATH'];
				var topChartXMLData = topChartData['XMLDATA'];
				var hiddens = topChartData['HIDDENS'];
				appConstants.topChartArr = hiddens;
				resultObj.add(
				{
					xtype: 'panel',
					columnWidth:0.65,
					ui:'newGraphPanel',
					height:350,
					overflowY:'auto',
					margin:'0 10 10 0',
					title:topChartTitle,
					id:'rightChartContent',
					html:''
				});
				if (Ext.isEmpty(appConstants.erUtils))
				{
					appConstants.erUtils = Ext.widget("erutils");
				}
				appConstants.erUtils.updateBarChart(appConstants.chartType,'',topChartXMLData,topChartSWFPath,topChartData,topChartData.chartHeight,topChartData.chartWidth,Ext.getCmp('rightChartContent'));
 			}
			else
			{
				if(!noMeasureDisplayed)
				{
					resultObj.hide();
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
				}
			}
			resultObj.doLayout();
		}
		catch ( e )
		{
			alert('Exception @ loadCharts '+e);
		}
	},
	genQueryString: function()
	{
	},
	validateSettings: function()
	{
		var er_usertimeline = appConstants.hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = appConstants.hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		var timeFrom = Ext.getCmp('timefrom').getValue();
		var minFrom = Ext.getCmp('minfrom').getValue();
		var timeTo = Ext.getCmp('timeto').getValue();
		var minTo = Ext.getCmp('minto').getValue();
		if ( !checkTimePeriod(timeFrom, minFrom, timeTo, minTo ) )
		{
			return false;
		}
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.dateValidateError,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var limitforbg = appConstants.hiddenJSON['limitforbg'];
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		var isSettingsOk = true;
		if ( reportgenVal == 'foreground' )
		{
			if ( !Ext.isEmpty(limitforbg ) )
			{
				if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
					isSettingsOk = false;
				}
			}
			return isSettingsOk;
		}
		if ( reportgenVal == 'background' || reportgenVal == 'background-csv')
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				return false;
			}
			else
			{
				return true;
			}
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			var getButtonObj =Ext.getCmp('mainform').getComponent('submit');
			getButtonObj.setDisabled(false);
			this.formSubmit(getButtonObj );
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('bgReportName').focus(false, 1000);
			this.beforeFormSubmit();
		}
	},
	afterSettingsRender:function() {
		var hiddens = appConstants.publicJSON['hiddens'];
		var favorite_id = hiddens["favorite_id"];

		if(favorite_id!=undefined || !Ext.isEmpty(favorite_id))
		{
	 		Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var screenLabels = appConstants.publicJSON['screenLabels']
		var settingsForm = this.getVirtualmachinessettings().getForm();
		if ( !Ext.isEmpty( screenLabels['reporter.consolidated.reportGeneration'] ) )
		{
			settingsForm.findField('reportGeneration').setFieldLabel(screenLabels['reporter.consolidated.reportGeneration']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.consolidated.reportName'] ) )
		{
			settingsForm.findField('bgReportName').setFieldLabel(screenLabels['reporter.consolidated.reportName']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.thin.Show'] ) )
		{
			settingsForm.findField('er_showby').setFieldLabel(screenLabels['reporter.thin.Show']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.displayByPhysicalServer'] ) )
		{
			settingsForm.findField('er_hostdisplay').setFieldLabel(screenLabels['reporter.common.displayByPhysicalServer']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.showData'] ) )
		{
			settingsForm.findField('er_trenddata').setFieldLabel(screenLabels['reporter.common.showData']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.excludeweekends'] ) )
		{
			settingsForm.findField('er_excwe').setFieldLabel(screenLabels['reporter.common.excludeweekends']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.timePeriod'] ) )
		{
			Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.timePeriod']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.From'] ) )
		{
			Ext.getCmp('fromTimeLbl').setText(screenLabels['reporter.common.From']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.From'] ) )
		{
			Ext.getCmp('fromTimeLbl').setText(screenLabels['reporter.common.From']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.Hrs'] ) )
		{
			Ext.getCmp('fromHrsLbl').setText(screenLabels['reporter.common.Hrs']);
			Ext.getCmp('toHrsLbl').setText(screenLabels['reporter.common.Hrs']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.Mins'] ) )
		{
			Ext.getCmp('fromMinsLbl').setText(screenLabels['reporter.common.Mins']);
			Ext.getCmp('toMinsLbl').setText(screenLabels['reporter.common.Mins']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.To'] ) )
		{
			Ext.getCmp('toTimeLbl').setText(screenLabels['reporter.common.To']);
		}
		var jsonData = appConstants.publicJSON;
		var selectedData = jsonData['selectedValues'];
		var me = this;
		var er_hostdisplayObj = settingsForm.findField('er_hostdisplay');
		var er_trenddataObj = settingsForm.findField('er_trenddata');
		var er_excweObj = settingsForm.findField('er_excwe');
		var er_showbyObj = settingsForm.findField('er_showby');
		var timefromObj = settingsForm.findField('timefrom');
		var timetoObj = settingsForm.findField('timeto');
		var minfromObj = settingsForm.findField('minfrom');
		var mintoObj = settingsForm.findField('minto');
		var reportGenerationObj = settingsForm.findField('reportGeneration');
		var bgReportNameObj = settingsForm.findField('bgReportName');

		var reportGenerationComboData = jsonData['reportGenerationCombo'];
		var physicalServerComboData = jsonData['physicalServerCombo'];
		if ( !Ext.isEmpty( physicalServerComboData ) )
		{
			er_hostdisplayObj.suspendEvents(true);
			er_hostdisplayObj.getStore().loadRawData(physicalServerComboData);
			if ( !Ext.isEmpty( selectedData['physicalServerSelected'] ) )
			{
				er_hostdisplayObj.setValue(selectedData['physicalServerSelected']);
			}
			else
			{
				er_hostdisplayObj.setValue(physicalServerComboData[0]['valueField']);
			}
			er_hostdisplayObj.resumeEvents();
			me.changePhysicalServers();
		}
		var showDataComboData = jsonData['showDataCombo'];
		if ( !Ext.isEmpty( showDataComboData ) )
		{
			er_trenddataObj.suspendEvents(true);
			er_trenddataObj.getStore().loadRawData(showDataComboData);
			if ( !Ext.isEmpty( selectedData['showDataSelected'] ) )
			{
				er_trenddataObj.setValue(selectedData['showDataSelected']);
			}
			else
			{
				er_trenddataObj.setValue(showDataComboData[0]['valueField']);
			}
			er_trenddataObj.resumeEvents();
		//	me.changeDetailedTrend();
		}
		var excludeWeekEndComboData = jsonData['excludeWeekEndCombo'];
		if ( !Ext.isEmpty( excludeWeekEndComboData ) )
		{
			er_excweObj.suspendEvents(true);
			er_excweObj.getStore().loadRawData(excludeWeekEndComboData);
			if ( !Ext.isEmpty( selectedData['excludeWeekEndSelected'] ) )
			{
				er_excweObj.setValue(selectedData['excludeWeekEndSelected']);
			}
			else
			{
				er_excweObj.setValue(excludeWeekEndComboData[0]['valueField']);
			}
			er_excweObj.resumeEvents();
			//me.changeExcludeWeekEnd();
		}


		var showComboData = jsonData['showCombo'];
		if ( !Ext.isEmpty( showComboData ) )
		{
			er_showbyObj.suspendEvents(true);
			er_showbyObj.getStore().loadRawData( showComboData );
			if ( !Ext.isEmpty( selectedData['showSelected'] ) )
			{
				er_showbyObj.setValue(selectedData['showSelected']);
			}
			else
			{
				er_showbyObj.setValue(showComboData[0]['valueField']);
			}
			er_showbyObj.resumeEvents();
		}
		else
		{
			er_showbyObj.hide();
		}
		var trendablee = jsonData['trendenable'];
		if(trendablee == 'false')
		{
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}
		timefromObj.suspendEvents(true);
		if ( !Ext.isEmpty( selectedData['timeFromHrSelected'] ) )
		{
			timefromObj.setValue(selectedData['timeFromHrSelected']);
		}
		else
		{
			timefromObj.setValue(timefromObj.getStore().get(0).get('valueField'));
		}
		timefromObj.resumeEvents();

		timetoObj.suspendEvents(true);
		if ( !Ext.isEmpty( selectedData['timeToHrSelected'] ) )
		{
			timetoObj.setValue(selectedData['timeToHrSelected']);
		}
		else
		{
			timetoObj.setValue(timetoObj.getStore().get(0).get('valueField'));
		}
		timetoObj.resumeEvents();

		minfromObj.suspendEvents(true);
		if ( !Ext.isEmpty( selectedData['timeFromMinSelected'] ) )
		{
			minfromObj.setValue(selectedData['timeFromMinSelected']);
		}
		else
		{
			minfromObj.setValue(timetoObj.getStore().get(0).get('valueField'));
		}
		minfromObj.resumeEvents();

		mintoObj.suspendEvents(true);
		if ( !Ext.isEmpty( selectedData['timeToMinSelected'] ) )
		{
			mintoObj.setValue(selectedData['timeToMinSelected']);
		}
		else
		{
			mintoObj.setValue(timetoObj.getStore().get(0).get('valueField'));
		}
		mintoObj.resumeEvents();
		if ( !Ext.isEmpty( reportGenerationComboData ) )
		{
			reportGenerationObj.suspendEvents(true);
			reportGenerationObj.getStore().loadRawData(reportGenerationComboData);
			if ( !Ext.isEmpty( selectedData['reportGenerationSelected'] ) )
			{
				reportGenerationObj.setValue(selectedData['reportGenerationSelected']);
			}
			reportGenerationObj.resumeEvents();
			me.changeReportGeneration();
		}

		var reportName = selectedData['reportName'];
		if ( !Ext.isEmpty( reportName ) )
		{
			bgReportNameObj.suspendEvents(true);
			bgReportNameObj.getStore().loadRawData(reportName);
			bgReportNameObj.resumeEvents();
		}

	},
	afterMainRender: function()
	{
		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		};
 		if(!hideBackButton){
			Ext.getCmp('virtualmachinesmainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJSON['ID']
				}
			);
		}
	    var me = this;
        var jsonData = appConstants.publicJSON;
  		var resultData = jsonData['RESULTS'];
		this.getNomeasurepanel().hide();
		if ( !Ext.isEmpty( resultData ) && jsonData.hiddens.fromFavoriteModify == null)
		{
			var title = resultData['TITLE'];
			var resultObj = Ext.getCmp('resultPanel');
			Ext.getCmp('gridContainer').hide();
			resultObj.show();
			resultObj.setTitle("<span class='font_bold'>"+title+"</span>");
			resultObj.removeAll();
			if ( jsonData.selectedValues.reportTypeSelected == 'Yes' )
			{
				me.loadCharts( jsonData );
				Ext.getCmp('csvTool').setDisabled(true);
			}
			else
			{
				me.loadGrid( jsonData );
				Ext.getCmp('csvTool').setDisabled(false);
			}
			Ext.getCmp('saveTool').setDisabled(false);
			Ext.getCmp('bookletTool').setDisabled(false);
			Ext.getCmp('printTool').setDisabled(false);
			Ext.getCmp('mailTool').setDisabled(false);
		}

		if(appConstants.isForceSubmit=='true')
		{
			appConstants.isForceSubmit='false';
			this.beforeFormSubmit();
		}
		Ext.getCmp('mainform').doLayout();
		if((appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true'))
			this.beforeFormSubmit();
	},
	loadMainForm:function(){
		var me = this;
		var mainForm = this.getVirtualmachinesmainform().getForm();
		var jsonData = appConstants.publicJSON;
		var hiddens = jsonData['hiddens'];
		var screenLabels = jsonData['screenLabels'];
		var selectedData = jsonData['selectedValues'];
		me.loadHiddens( hiddens );
		me.loadScreenLabels( screenLabels );
		var from_schedule = hiddens["fromScheduleModify"];
		var fromFavoriteModify = hiddens["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}

		/***********To Get Components STARTS************/

		var er_typeObj = mainForm.findField('er_type');
		var selectionObj = mainForm.findField('selection');
		var compTypeObj = mainForm.findField('compType');
		var select_groupObj = mainForm.findField('select_group');
		var componentsObj = Ext.getCmp('components');
		var er_timelineObj = mainForm.findField('er_timeline');
		var er_stdateObj = mainForm.findField('er_stdate');
		var er_sthrObj = mainForm.findField('er_sthr');
		var er_enddateObj = mainForm.findField('er_enddate');
		var er_endhrObj = mainForm.findField('er_endhr');
		var er_modeObj = mainForm.findField('er_mode');
		var ermeasuretestObj = mainForm.findField('ermeasuretest');

		

		/***********To Get Components ENDS************/
		var measureComboData = jsonData['measureCombo'];
 		if ( !Ext.isEmpty( measureComboData ) )
		{
			ermeasuretestObj.suspendEvents(true);
			ermeasuretestObj.getStore().clearFilter(true); 
			ermeasuretestObj.getStore().loadRawData(measureComboData);
			if ( !Ext.isEmpty( selectedData['measureSelected'] ) )
			{
				ermeasuretestObj.setValue(selectedData['measureSelected']);
			}
			else
			{
				ermeasuretestObj.setValue(measureComboData[0]['valueField']);
			}
			ermeasuretestObj.resumeEvents();
			me.changeMeasureTest();
		}
		else
		{
			ermeasuretestObj.hide();
		}
		var reportTypeComboData = jsonData['reportTypeCombo'];
		if ( !Ext.isEmpty( reportTypeComboData ) )
		{
			er_typeObj.suspendEvents(true);
			er_typeObj.getStore().loadRawData(reportTypeComboData);
			if ( !Ext.isEmpty( selectedData['reportTypeSelected'] ) )
			{
				er_typeObj.setValue(selectedData['reportTypeSelected'])
			}
			er_typeObj.resumeEvents();
			me.changeReportType();
		}
		var selectionComboData = jsonData['selectionCombo'];
		if ( !Ext.isEmpty(selectionComboData) )
		{
			selectionObj.suspendEvents(true);
			selectionObj.getStore().loadRawData(selectionComboData);
			if ( !Ext.isEmpty( selectedData['selectionSelected'] ) )
			{
				selectionObj.setValue(selectedData['selectionSelected']);
			}
			else
			{
				selectionObj.setValue(selectionComboData[0]['valueField']);
			}
			selectionObj.resumeEvents();
			me.changeSelection();
		}
		var compTypeComboData = jsonData['compTypeCombo'];
		if ( !Ext.isEmpty( compTypeComboData ) )
		{
			compTypeObj.suspendEvents(true);
			compTypeObj.getStore().clearFilter(true);
			compTypeObj.getStore().loadRawData(compTypeComboData);
			if ( !Ext.isEmpty( selectedData['compTypeComboSelected'] ) )
			{
				compTypeObj.setValue(selectedData['compTypeComboSelected']);
			}
			else
			{
				compTypeObj.setValue(compTypeComboData[0]['valueField']);
			}
			compTypeObj.resumeEvents();
			me.changeComponentType();
		}
		else
		{
			this.insertNotApplicable(compTypeObj);
		}
		var analysisComboData = jsonData['analysisCombo'];
		if ( !Ext.isEmpty( analysisComboData ) )
		{
			select_groupObj.suspendEvents(true);
			select_groupObj.getStore().loadRawData(analysisComboData);
			if ( !Ext.isEmpty( selectedData['analysisSelected'] ) )
			{
				select_groupObj.setValue(selectedData['analysisSelected']);
			}
			else
			{
				select_groupObj.setValue(analysisComboData[0]['valueField']);
			}
			select_groupObj.resumeEvents();
			me.changeAnalysis();
		}
		else
		{
			this.insertNotApplicable(compTypeObj);
		}
		var groupComboData = jsonData['groupCombo'];
 		if ( !Ext.isEmpty( groupComboData ) )
		{
			var getAnalysisVal = selectedData['analysisSelected'];
			if ( getAnalysisVal == 'Component' )
			{
				componentsObj.suspendEvents(true);
				appConstants.rawDataForComponents = groupComboData;
				componentsObj.getStore().loadRawData(groupComboData);
				componentsObj.setValue(selectedData['groupSelected']);
				componentsObj.resumeEvents();
				me.selectComponents();
			}
			else if ( getAnalysisVal == 'Zone' )
			{
				var zoneObj = mainForm.findField('zone');
				var subzoneObj = mainForm.findField('subzone');
				zoneObj.suspendEvents(true);
				zoneObj.getStore().loadRawData(groupComboData);
				if ( selectedData['groupSelected'] )
				{
					zoneObj.setValue(selectedData['groupSelected']);
				}
				zoneObj.resumeEvents();
				if ( !Ext.isEmpty( selectedData['subzoneSelected'] ) )
				{
					subzoneObj.suspendEvents(true);
					subzoneObj.setValue(selectedData['subzoneSelected']);
					subzoneObj.resumeEvents();
				}
			}
			else if ( getAnalysisVal == 'Segment' )
			{
				var segmentObj = mainForm.findField('segment');
				segmentObj.suspendEvents(true);
				segmentObj.getStore().clearFilter(true); 
				segmentObj.getStore().loadRawData(groupComboData);
				if ( selectedData['groupSelected'] )
				{
					segmentObj.setValue(selectedData['groupSelected']);
				}
				segmentObj.resumeEvents();
			}
			else if ( getAnalysisVal == 'Service' )
			{
				var serviceObj = mainForm.findField('service');
				serviceObj.suspendEvents(true);
				serviceObj.getStore().clearFilter(true); 
				serviceObj.getStore().loadRawData(groupComboData);
				if ( selectedData['groupSelected'] )
				{
					serviceObj.setValue(selectedData['groupSelected']);
				}
				serviceObj.resumeEvents();
			}
		}
		else
		{
			componentsObj.getStore().removeAll();
			componentsObj.getStore().add({'valueField': '-1', 'displayField': appConstants.notApplicableText});
			componentsObj.setValue('-1');
		}
		if(selectedData['showDataSelected']=='Yes')
		{
			isTrend=true
		}
		var timelineComboData = jsonData['timelineCombo'];
		if ( !Ext.isEmpty( timelineComboData ) )
		{
			er_timelineObj.suspendEvents(true);
			er_timelineObj.getStore().loadRawData(timelineComboData);
			if ( !Ext.isEmpty( jsonData['selectedTimeline'] ) )
			{
				er_timelineObj.setValue(jsonData['selectedTimeline']);
			}
			else
			{
				er_timelineObj.setValue(timelineComboData[0]['valueField']);
			}
			er_timelineObj.resumeEvents();
			me.changeTimeline();
		}
		var startDateData = jsonData['startDateForDisplay'];
		if ( !Ext.isEmpty( startDateData ) )
		{
			//er_stdateObj.suspendEvents(true);
			er_stdateObj.setValue(startDateData);
			er_stdateObj.dataArray =jsonData['startDate'];
			er_stdateObj.resumeEvents();
		}
		var endDateData = jsonData['endDateForDisplay'];
		if ( !Ext.isEmpty( endDateData ) )
		{
			er_enddateObj.suspendEvents(true);
			er_enddateObj.setValue(endDateData);
			er_enddateObj.dataArray =jsonData['endDate'];
			er_enddateObj.resumeEvents();
		}

		var startHourData = jsonData['startHourForDisplay'];
		if ( !Ext.isEmpty( startHourData ) )
		{
			er_sthrObj.suspendEvents(true);
			er_sthrObj.setValue(startHourData);
			er_sthrObj.dataArray=jsonData['startHour'];
			er_sthrObj.resumeEvents();
		}

		var endHourData = jsonData['endHourForDisplay'];
		if ( !Ext.isEmpty( endHourData ) )
		{
			er_endhrObj.suspendEvents(true);
			er_endhrObj.setValue(endHourData);
			er_endhrObj.dataArray=jsonData['endHour'];
			er_endhrObj.resumeEvents();
		}
		stmin =jsonData['startMinForDisplay'];
        enmin =jsonData['endMinForDisplay'];
        mgr_stmin =jsonData['startmin'];
        mgr_enmin = jsonData['endmin'];
 		var selectedGraphModeData = jsonData['selectedGraphMode'];
		if ( !Ext.isEmpty( selectedGraphModeData ) )
		{
			er_modeObj.suspendEvents(true);
			er_modeObj.setValue(selectedGraphModeData);
			er_modeObj.resumeEvents();
		}
		var reportGenerationComboData = jsonData['reportGenerationCombo'];
	},
	changeReportGeneration: function( obj )
	{
		var reportGenTypeVal = Ext.getCmp('reportGeneration').getValue();
		var reportNameObj = Ext.getCmp('bgReportName');
		if ( reportGenTypeVal == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else if ( reportGenTypeVal == 'background-csv' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	changeTimeline: function( obj )
	{
		var er_timelineVal = Ext.getCmp('er_timeline').getValue();
		var startDateObj = Ext.getCmp('er_stdate');
		var endDateObj = Ext.getCmp('er_enddate');
		var startHrObj = Ext.getCmp('er_sthr');
		var endHrObj = Ext.getCmp('er_endhr');
		if ( er_timelineVal == 'Any' )
		{
			startDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			startDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			startHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.changeComponentType( obj );
		}
	},
	changeMeasureTest: function( obj )
	{
//		alert('changeMeasureTest--->obj '+obj);
	},
	/* changeExcludeWeekEnd: function( obj )
	{
		var er_excweVal = Ext.getCmp('er_excwe').getValue();
		ar excludeWeekLabelObj = Ext.getCmp('excludeWeekLabel');
		var selectionVal = Ext.getCmp('selection').getValue();;
		var getVal = '';

		if ( selectionVal == 'Yes' )
		{
			getVal = 'VIRTUAL_HOST';
		}
		else
		{
			getVal = 'VIRTUAL_GUEST';
		}
		if ( er_excweVal == 'Yes' )
		{
			var no_params = '&P0=['+getVal+']&';
			var param = 'C=jsrs1'+no_params+'U='+new Date().getTime()+'&fromajax=true&F=getExcucludeWeekend';
			excludeWeekLabelObj.show();
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
				method: 'POST',
				params: param,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						if ( !Ext.isEmpty( jsonData ))
						{
 							Ext.getCmp('excludeWeekLabel').update("Excludes	"+jsonData['values']);
						}
					}
				}
			});
		}
		else
		{
			excludeWeekLabelObj.hide();
		}
	},*/
	changeDetailedTrend: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			//this.changeComponentType( obj );
		}
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var er_trenddata=Ext.getCmp('er_trenddata').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = appConstants.publicJSON['hiddens']["inidate"];
			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}

	
	},
	changePhysicalServers: function( obj )
	{
	},
	selectComponents: function( obj )
	{
	},
	changeAnalysis: function( obj )
	{
		var getSelectGroupVal = Ext.getCmp('select_group').getValue();
		var compObj = Ext.getCmp('compContainer');
		var zoneObj = Ext.getCmp('zone');
		var subzoneObj = Ext.getCmp('subzone');
		var segmentObj = Ext.getCmp('segment');
		var serviceObj = Ext.getCmp('service');
		if ( getSelectGroupVal == 'Component' || getSelectGroupVal == '-1' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.hide();
			serviceObj.hide();
			compObj.show();
		}
		else if ( getSelectGroupVal == 'Zone' )
		{
			zoneObj.show();
			subzoneObj.show();
			segmentObj.hide();
			serviceObj.hide();
			serviceObj.hide();
			compObj.hide();
		}
		else if ( getSelectGroupVal == 'Segment' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.show();
			serviceObj.hide();
			serviceObj.hide();
			compObj.hide();
		}
		else if ( getSelectGroupVal == 'Service' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.hide();
			serviceObj.hide();
			serviceObj.show();
			compObj.hide();
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.changeComponentType( Ext.getCmp('compType') );
		}
	},
	checkComponentType: function( obj , newVal, oldVal )
	{
		if ( newVal == '-1' )
		{
			Ext.getCmp('compType').setValue(oldVal)
		}
	},
	changeComponentType: function( obj )
	{
		var getCompTypeVal = Ext.getCmp('compType').getValue();
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.formSubmit( obj );
		}
	},
	changeReportType: function( obj )
	{
		var reportTypeVal = Ext.getCmp('er_type').getValue();
		var queryString = this.genQueryString();
		if (!isSettingsEnabled)
		{
			this.showConfigDropdown();
		}
		else
		{
			Ext.Ajax.request({
			url: '/final/reporter/ErEsxReportJSON.jsp?er_type='+reportTypeVal,
			params: queryString,
			method: 'POST',
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					var reportGenerationObj = Ext.getCmp("reportGeneration");
					var reportGenerationComboData = jsonData.reportGenerationCombo;
					var setRepoGen= jsonData.selectedValues.reportGenerationSelected;
					if (!Ext.isEmpty(reportGenerationComboData))
					{
						reportGenerationObj.suspendEvents(true);
						reportGenerationObj.getStore().loadRawData(reportGenerationComboData);
						if (!Ext.isEmpty(setRepoGen))
						{
							reportGenerationObj.setValue(setRepoGen);
						}
						else
						{
							reportGenerationObj.setValue(reportGenerationComboData[0].valueField);
						}
						reportGenerationObj.resumeEvents();
						var reportNameObj = Ext.getCmp('bgReportName');
						if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
				}
			}
			});
		}
		var getReportType = Ext.getCmp('er_type').getValue();
		var measureObj = Ext.getCmp('ermeasuretest');
		var showObj = Ext.getCmp('er_showby');
		//var graphModeObj = Ext.getCmp('er_mode');
		Ext.getCmp('moreOptionCloseId').show();
		Ext.getCmp('submitViaSetting').hide();
		if (getReportType == 'Yes')
		{
			measureObj.show();
			showObj.show();
			//graphModeObj.show();
		}
		else
		{
			measureObj.hide();
			showObj.hide();
			//graphModeObj.hide();
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.formSubmit( obj );
		}
	},
	hideResultPanel: function()
	{
		this.getTablepanel().hide();
		this.getTablepanel().removeAll();
		this.disableTools();

	},
	enableTools: function()
	{
		//Ext.getCmp('upbutton').setDisabled(false);
		Ext.getCmp('saveTool').setDisabled(false);
		Ext.getCmp('bookletTool').setDisabled(false);
		Ext.getCmp('printTool').setDisabled(false);
		Ext.getCmp('mailTool').setDisabled(false);
	},
	disableTools: function()
	{
		//Ext.getCmp('upbutton').setDisabled(true);
		Ext.getCmp('saveTool').setDisabled(true);
		Ext.getCmp('bookletTool').setDisabled(true);
		Ext.getCmp('printTool').setDisabled(true);
		Ext.getCmp('mailTool').setDisabled(true);
	},
	changeSelection: function( obj )
	{
		var selectionVal = Ext.getCmp('selection').getValue();
		if ( !Ext.isEmpty ( selectionVal ) )
		{
			var er_hostdisplayObj = Ext.getCmp('er_hostdisplay');
			if ( selectionVal == 'No' )
			{
				er_hostdisplayObj.show();
			}
			else
			{
				er_hostdisplayObj.hide();
			}
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResultPanel();
			this.formSubmit( obj );
		}
	},
	loadScreenLabels: function( screenLabels )
	{
		var pageTitle = screenLabels['PAGE_TITLE'];
		var mainForm = this.getVirtualmachinesmainform().getForm();
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else{
			if ( !Ext.isEmpty( pageTitle ) )
			{
				this.getMain().setTitle(pageTitle);
			}
		}
		if ( !Ext.isEmpty( screenLabels['reporter.thin.Measure'] ) )
		{
			mainForm.findField('ermeasuretest').setFieldLabel( screenLabels['reporter.thin.Measure']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.reportType'] ) )
		{
			mainForm.findField('er_type').setFieldLabel(screenLabels['reporter.common.reportType']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.Selection'] ) )
		{
			mainForm.findField('selection').setFieldLabel(screenLabels['reporter.common.Selection']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.thin.componentType'] ) )
		{
			mainForm.findField('compType').setFieldLabel(screenLabels['reporter.thin.componentType']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.vmesx.analysisBy'] ) )
		{
			mainForm.findField('select_group').setFieldLabel(screenLabels['reporter.vmesx.analysisBy']);
		}
		if ( !Ext.isEmpty( screenLabels['groupLabel'] ) )
		{
			Ext.getCmp('componentsLbl').setText(screenLabels['groupLabel']);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.thin.includeSubzone'] ) )
		{
			mainForm.findField('subzone').setFieldLabel( screenLabels['reporter.thin.includeSubzone'] );
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.Zone'] ) )
		{
			mainForm.findField('zone').setFieldLabel( screenLabels['reporter.common.Zone'] );
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.Segment'] ) )
		{
			mainForm.findField('segment').setFieldLabel( screenLabels['reporter.common.Segment'] );
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.Service'] ) )
		{
			mainForm.findField('service').setFieldLabel( screenLabels['reporter.common.Service'] );
		}

		if ( !Ext.isEmpty( screenLabels['reporter.common.To'] ) )
		{
			//Ext.getCmp('toTimeLbl').setText(screenLabels['reporter.common.To']);
			mainForm.findField('er_enddate').setFieldLabel(screenLabels['reporter.common.To']);
		}


/*		if ( !Ext.isEmpty( screenLabels['reporter.common.submit'] ) )
		{
			Ext.getCmp('submit').setText(screenLabels['reporter.common.submit']);
		}
*/	},
	loadHiddens: function( hiddens )
	{
		try
		{
			appConstants.hiddenQStr = '';
			var mainForm = this.getMain();
			appConstants.hiddenJSON = hiddens;
			for ( var key in hiddens )
			{
				/*if ( Ext.getCmp(key) == undefined || Ext.getCmp(key) == 'undefined' )
				{
					mainForm.add(
						{
							xtype: 'hidden',
							id: key,
							name: key,
							value: hiddens[key]
						}
					);
				}
				else
				{

					if ( !Ext.isEmpty( Ext.getCmp(key) ) )
					{
						Ext.getCmp(key).setValue(hiddens[key]);
					}
				}*/
				if ( !Ext.isEmpty( hiddens[key] ) )
				{
					appConstants.hiddenQStr += '&'+key+'='+encodeURIComponent(hiddens[key]);
				}
			}
		}
		catch ( e )
		{
			alert('Exception @ loadHiddens '+e);
		}
	},
	hideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //csv
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //booklet
			);
			//Ext.getCmp('upbutton').hide();
			Ext.getCmp('favoriteTool').setDisabled(false);
			Ext.getCmp('scheduleTool').setDisabled(false);
	},
	insertNotApplicable: function( obj )
	{
		obj.suspendEvents(true);
		obj.getStore().removeAll();
		obj.getStore().add({
			'displayField': appConstants.notApplicable,
			'valueField': '-1'
		});
		obj.setValue('-1');
		obj.resumeEvents();
	}

});