 Ext.define('VirtualMachinesOverview.view.EgComponent',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.egcomponent',
	layout:'vbox',
	id: 'compContainer',
	name: 'compContainer',
 	items:[
		{
			xtype:'label',
			id : 'componentsLbl',
			name : 'componentsLbl',
			text:componentsTxt,
			margin: '0 0 3 0'
		},
		{
			xtype:'container',
			layout:'hbox',
			items:[
				{
					xtype:'container',
 					width : 220,
					margin:0,
					items:[
						{
							xype:'container',
							cls:'multisearchlist',
							items:[
								{
									xtype: 'customtrigger',
									emptyText:'Search Components',
									id: 'compSearch'
							}
							]
						},
						{
							width: 220,
							xtype: 'multiselectfield',
							autoScroll:false,
							scroll:false,
							height:90,
							labelAlign:'left',
							allowBlank: false,
							id: 'components',
							name: 'components',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local'
							}
					]
				},
				{
					xtype : 'container',
					margin : '10 0 0 5',
					//cls : 'iconBg',
					items : [{
								xtype : 'button',
								iconCls : 'iconMultiselectExpand',
								id:'expandSelector',
								name:'expandSelector',
								listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html: Ext.getCmp('componentsLbl').text
													});
												}
											},

								style : {
											background : 'none',
											border : '0px'
										}
						}]
				}
			]
		}
	],
	listeners:{
		render:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		show:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		hide:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		}
	},
	toggleSubmitSaveBtn:function(component){

			var mainform=Ext.getCmp('mainform');
			var virtualmachinesmainform=Ext.getCmp('virtualmachinesmainform');
			var hiddens=appConstants.publicJSON.hiddens;
			if (hiddens.fromScheduleModify == "Yes" || hiddens.fromFavoriteModify == "Yes")
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					mainform.getComponent('submit').hide();
					virtualmachinesmainform.getComponent('save').show();
					virtualmachinesmainform.getComponent('submit').hide();
				}
				else
				{
					mainform.getComponent('save').show();
					mainform.getComponent('submit').hide();
					virtualmachinesmainform.getComponent('save').hide();
					virtualmachinesmainform.getComponent('submit').hide();
				}
 			}
			else
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					mainform.getComponent('submit').hide();
					virtualmachinesmainform.getComponent('save').hide();
					virtualmachinesmainform.getComponent('submit').show();
				}
				else
				{
					mainform.getComponent('save').hide();
					mainform.getComponent('submit').show();
					virtualmachinesmainform.getComponent('save').hide();
					virtualmachinesmainform.getComponent('submit').hide();
				}
			}
	}
});