Ext.define('VirtualMachinesSprawlApp.controller.Main', {
    extend: 'Ext.app.Controller',
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        },
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
    ],
    init: function () {
        this.control({
            'main newUtilities': {
                'afterrender': this.loadTools
            },
            'main': {
                'afterrender': this.loadDefaults
            },
            'virtualmachinessprawlsettings': {
                'afterrender': this.afterSettingsrender
            },
            'virtualmachinessprawlmainform combo[name="er_option"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinessprawlmainform combo[name="er_type"]': {
                'select': this.reporttypeChange
            },
            'virtualmachinessprawlmainform combo[name="er_site"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinessprawlmainform combo[name="er_comptype"]': {
                'select': this.reloadWithAjax
            },
            'virtualmachinessprawlmainform combo[name="er_dataZone"]': {
                'select': this.reloadWithAjax
            },
            'mainform button[name="submit"]': {
                'click': this.showResult
            },
            'mainform button[name="save"]': {
                'click': this.goTo
            },
            'virtualmachinessprawlsettings combo[name="er_timeline"]': {
                'select': this.timeLineOnChange
            },
            'virtualmachinessprawlsettings combo[name="reportGeneration"]': {
                'select': this.reportGenChange
            },
			'virtualmachinessprawlsettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualmachinessprawlsettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'timeline combo[name="er_mode"]':
			{
				 'select': this.changeEr_mode
			 },
            'newUtilities > #printTool > button': {
                'click': this.printReport
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveReportAsPDF
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #csvTool > button': {
                'click': this.saveCsv
            },
            'newUtilities > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.saveSchedule
            },
            'egcomponent button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
        });
    },
	showConfigDropdown:function(){
		isSettingsEnabled =true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		//layout:'vbox',
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		//html:tpl.apply(),
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'virtualmachinessprawlsettings',
				itemId: 'settingsForm',
				parent:this
			}

		],
		renderTo:'virtualmachinessprawl-body'
		});
        var thisController = this;
        Ext.get('closeSettings').on('click', function () {
           	thisController.validateAndCloseSettings();
        });

	},
	validateAndCloseSettings:function()
	{
		var result = this.validateMoreSettings();
		if(result)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateMoreSettings:function()
	{
		var isSettingsOk = true;
		reportgen = Ext.getCmp('reportGeneration').getValue();
		if (reportgen != null && reportgen != 'foreground') 
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)) 
			{
				isSettingsOk = false;
			}
		}
		return isSettingsOk;
	},
	afterSettingsrender : function() {

			Ext.getCmp('moreOptionCloseId').show();
			var hiddenFields = appConstants.publicjsonData['hiddenfields'];
			var favorite_id = hiddenFields["favorite_id"];
				if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

		var jsonData = appConstants.publicjsonData;
        var screenLabels = jsonData.screenLabels;
		var rtype = jsonData.er_type;
		if( rtype == 'No'){
			Ext.getCmp('er_display').hide();
			Ext.getCmp('er_priority').hide();
		}
		//else{
		var comboRawData = jsonData.metricCombo;
		var selectedComboOption = jsonData.er_display;
		var comboObject = Ext.getCmp('er_display');
		comboObject.setFieldLabel(screenLabels['reporter.common.Metric']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}

		comboRawData = jsonData.priorityCombo;
		selectedComboOption = jsonData.er_priority;
		comboObject = Ext.getCmp('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		var repoMaking = "";
		if (appConstants.repoGene!=undefined)
		{
			repoMaking=appConstants.repoGene;
		}
		else
		{
			repoMaking=appConstants.publicjsonData;
		}
        var reportGenCombo = repoMaking.reportGenerationCombo;
        var selreportGeneration = repoMaking.er_reportgenration;
        var reportGen = Ext.getCmp('reportGeneration');
        reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
        reportGen.getStore().loadRawData(reportGenCombo);
        reportGen.setValue(selreportGeneration);

	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);

    },
		 changeEr_mode: function (combo) {
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
	},
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicjsonData.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			this.saveFavorite();
		}
    },
    reporttypeChange: function (obj) {
        Ext.getCmp('resultPanel').hide();
		this.disableTools();
        this.updateQueryString(true);
		var er_type = Ext.getCmp("er_type").getValue();
        Ext.Ajax.request({
            url: '/final/reporter/ErVmSprawlReportJson.jsp?er_type='+er_type,
            params: appConstants.queryString,
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
				appConstants.repoGene = appConstants.publicjsonData;
			
                if (obj.getValue() == 'Yes') {
					if (isSettingsEnabled)
					{
						Ext.getCmp("er_display").show();
						Ext.getCmp("er_priority").show();
						var reportGenCombo = appConstants.publicjsonData.reportGenerationCombo;
						var selreportGeneration = appConstants.publicjsonData.er_reportgenration;
						var reportGen = Ext.getCmp('reportGeneration');
						reportGen.setFieldLabel(appConstants.publicjsonData['screenLabels']['reporter.common.Report Generation']);
						reportGen.getStore().loadRawData(reportGenCombo);
						reportGen.setValue(reportGenCombo[0].valueField);
						var reportNameObj = Ext.getCmp('bgReportName');
						if(reportGenCombo[0].valueField!=undefined && reportGenCombo[0].valueField!=null && reportGenCombo[0].valueField=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
                } else {
					if (isSettingsEnabled)
					{
						Ext.getCmp("er_priority").hide();
						Ext.getCmp("er_display").hide();
						Ext.get("removeMargin").setStyle("margin", "0");
						var reportGenCombo = appConstants.publicjsonData.reportGenerationCombo;
						var selreportGeneration = appConstants.publicjsonData.er_reportgenration;
						var reportGen = Ext.getCmp('reportGeneration');
						reportGen.setFieldLabel(appConstants.publicjsonData['screenLabels']['reporter.common.Report Generation']);
						reportGen.getStore().loadRawData(reportGenCombo);
						reportGen.setValue(reportGenCombo[0].valueField);
						var reportNameObj = Ext.getCmp('bgReportName');
						if(reportGenCombo[0].valueField!=undefined && reportGenCombo[0].valueField!=null && reportGenCombo[0].valueField=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
                }
            }
        });
    },
    expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
    },
    printReport: function () {
        var s_qryString = "/final/reporter/ErVmSprawlReportPrint.jsp?" + appConstants.publicjsonData.saveQstring + "pdfPrint=yes&er_width=450&er_height=250";
        s_qryString+='&sortColumnIndex='+appConstants.gridColumnIndex+'&sortState='+appConstants.gridColumnSortState;
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    },
    saveReportAsPDF: function () {
        var saveQString = appConstants.publicjsonData.saveQstring;
        saveQString += "&pageWidthProces=700";
		saveQString+='&sortColumnIndex='+appConstants.gridColumnIndex+'&sortState='+appConstants.gridColumnSortState;
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
       if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
    },
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicjsonData.saveQstring;
        saveQString += "&pageWidthProces=700";
		saveQString+='&sortColumnIndex='+appConstants.gridColumnIndex+'&sortState='+appConstants.gridColumnSortState;
        var s_qryString = saveQString;
		return s_qryString;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
    sendMail: function () {
		drillDownParams='isNeedToModifyMailUrl=yes&sortColumnIndex='+appConstants.gridColumnIndex+'&sortState='+appConstants.gridColumnSortState;
        var windowMail = Ext.widget('sendmail');
        windowMail.show();
    },
    saveCsv: function () {
        window.location = '../servlet/egurkha.reporter.SaveInCSVFormat';
    },
    saveFavorite: function () {
        var isValid = this.validateMainForm();
        /* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Capactity Correlation',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        } */
        this.updateQueryString(true);
        var finalParams = appConstants.queryString+"&isFavorite=true";
        if (isValid) {
            var s_qryString;
			var hiddenFields = appConstants.publicjsonData['hiddenfields'];
			var favorite_id = hiddenFields["favorite_id"];
            s_qryString = "../servlet/com.eg.ErFavoriteC?" + encodeURI(finalParams) + "&er_view=GRAPH&cmd=client";//&FavoriteId="+favorite_id;
            var target = s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
        }
    },
    saveSchedule: function () {
        var isValid = this.validateMainForm();
        if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        }
        this.updateQueryString(true);
        var finalParams = appConstants.queryString;
        if (isValid) {
            var s_qryString;
            s_qryString = "/final/reporter/ErSaveSchedule.jsp?" + encodeURI(finalParams);
            var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
			{
				target+='&sortColumnIndex='+appConstants.gridColumnIndex+'&sortState='+appConstants.gridColumnSortState;
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
		}
    },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
    showResult: function () {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);

        var isValid = this.validateMainForm();
		if (isValid)
		{
			isValid = this.validateSettings();
		}
        if (isValid) this.submitReport();
        else return;
    },
    validateMainForm: function () {
        var datafrom = Ext.getCmp('er_option').getValue();
        if (datafrom != 'Component') {
            var site = Ext.getCmp('er_site');
            if (site.getValue() == '-1') {
                Ext.MessageBox.show({
                    title: 'Virtualization',
                    msg: site.getRawValue(),
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        }
        var comptype = Ext.getCmp("er_comptype");
        if (comptype.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: comptype.getRawValue(),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        var component = Ext.getCmp("er_component");
        if (component.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: component.getStore().getAt(0).get('displayField'),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        return true;
    },
    validateSettings: function () {
        var isSettingsOk = true;
        var reportgen = appConstants.publicjsonData.er_reportgenration;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
        var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
        var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);

		if (!checkDateTime(stDate, enDate)) {
            isSettingsOk = false;
        }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: 'Virtualization settings',
                    msg: userTimelineErrorMsg,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                isSettingsOk = false;
            }
        }
        if (reportgen != null && reportgen == 'foreground') {
            var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg'];
            if (!Ext.isEmpty(limitforbg)) {
                if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                    Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
                    isSettingsOk = false;
                }
            }
        } else {
            var reportName = Ext.getCmp('bgReportName').getValue();
            if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)) isSettingsOk = false;
        }
        return isSettingsOk;
    },
    showConfirmResult: function (btn) {
        if (btn == "yes") {
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(false);
            this.submitReport();
        } else {
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
            var reportGenType = Ext.getCmp('reportGeneration');
            var bgreportNameObj = Ext.getCmp('bgReportName');
            reportGenType.setValue('background');
            bgreportNameObj.setValue("");
            bgreportNameObj.show();
            bgreportNameObj.focus(false, 1000);
           this.showResult();
        }
    },
    submitReport: function () {
         appConstants.initLdgMask.show();
        var reportGeneration = appConstants.publicjsonData.er_reportgenration;
		if (isSettingsEnabled)
		{
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
         this.updateQueryString(true);
        var finalParams = appConstants.queryString;
        if (reportGeneration == 'foreground') {
            urlforAjax = '../servlet/com.eg.ErVmSprawlReportC';
            finalParams += "&isSubmit=true&responseType=json";
        } 
		else if (reportGeneration == 'background')
		{
            urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
        }
		else if (reportGeneration == 'background-csv')
		{
            urlforAjax = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
        }
        finalParams += "&isFavorite=false&isSchedule=false";
		finalParams+="&er_RmDispName="+appConstants.er_RmDispName+"&er_mode="+Ext.getCmp("er_mode").getValue();
        Ext.Ajax.request({
            url: urlforAjax,
            params: finalParams,
            method: 'POST',
            scope: this,
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
                this.loadReportData(appConstants.publicjsonData);
            }
        });
    },
    loadReportData: function (jsonData) {
		var thisController=this;
		var me=this;
        var resultPanelObj = Ext.getCmp('resultPanel');
        var reportGeneration = appConstants.publicjsonData.er_reportgenration;
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
        if (reportGeneration == 'foreground') {

            Ext.getCmp("bookletTool").setDisabled(false);
            Ext.getCmp("saveTool").setDisabled(false);
            Ext.getCmp("printTool").setDisabled(false);
            Ext.getCmp("mailTool").setDisabled(false);
            var noDataFound = true;
            var fieldContainerArray = new Array();
            var fieldstoStore = new Array();
             resultPanelObj.removeAll();
            var reportData = jsonData.REPORT_DATA;
             if (!Ext.isEmpty(reportData)) {
                noDataFound = false;
                var r_type = jsonData.er_type;
                resultPanelObj.setTitle(reportData.title);
                if (r_type == 'No') {
		            Ext.getCmp("csvTool").setDisabled(false);
                    var columnDetails = reportData.COLUMNS;
                    var dataArraytoStore = reportData.DATA;

                    var fieldstoStore = new Array();
                    var mainColumnsObjArray = new Array();

                    for (var key in columnDetails) {
                        var mainColumn = columnDetails[key];
                        var dataidx = 'COLUMN_' + key;
                        fieldstoStore.push(dataidx);
						var align='left';
						if (key==1 || key==columnDetails.length-1 || key==columnDetails.length-2)
						{
							align='center';
						}
						if(key == 0)
						{
							mainColumnsObjArray.push({
								header: mainColumn,
								sortable: true,
								locked:true,
								width:135,
								dataIndex: dataidx,
								align: align,
								renderer: function( val,metaData )
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
									return val;
								},
								doSort: function(state) {
 											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													v1 = v1.get(field);
													v2 = v2.get(field);
											
										if(field!=undefined && (field=='COLUMN_5'||field=='COLUMN_6'||field=='COLUMN_4'||field=='COLUMN_0'||field=='COLUMN_2'))
													{
														v1=v1.toLowerCase();
														v2=v2.toLowerCase();
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
													}
													if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
													{
														var tmp = v1.substring(0, v1.lastIndexOf(' '));
										
														var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
														var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
														v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
													}
													if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
													{
														var tmp = v2.substring(0, v2.lastIndexOf(' '));
														var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
														var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
														v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
													}
									
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;

													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
								//flex: 1
							});
						}
						else
						{
							mainColumnsObjArray.push({
							header: mainColumn,
							sortable: true,
							locked:false,
							dataIndex: dataidx,
							align: align,
							renderer: function( val,metaData )
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
								val = Ext.getCmp('gridId').getDecimalAlignFormat(val);
								return val;
							},
							doSort: function(state) {
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													v1 = v1.get(field);
													v2 = v2.get(field);
											
										if(field!=undefined && (field=='COLUMN_5'||field=='COLUMN_6'||field=='COLUMN_4'||field=='COLUMN_0'||field=='COLUMN_2'))
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										
									
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;

													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
								//flex: 1
							});
						}
                    }

					var isPagingEnabled;
					if (dataArraytoStore.length<gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;

                    var storeObj = Ext.create('Ext.data.ArrayStore', {
                        fields: fieldstoStore,
                        data: dataArraytoStore,
						proxy : {
							type : 'pagingmemory',
							reader : {
								type : 'json'
							}
						},
						pageSize:gridPageSize,
						remoteSort : true,
						autoLoad : true,
						sorters: { property: fieldstoStore[0], direction : 'ASC' },// vengat
                    });
					var activePage=1;
					resultPanelObj.add({
							xtype:'customgrid',
							//title :  reportData.gridTitle,
  							sortableColumns: true,
							id:'gridId',
							needtoFixColumn:true,
							//cls:'gridSkin horizontal-scroll',
							ui:'newGridPanel ',
							bodyPadding: '0 0 0 0',
							margin:'0 10 10 10',
							border:true,
							frame:false,
							autoScroll: true,
							scroll: true,
							viewConfig: {
								emptyText: 'No records'
							},
							store:storeObj,
							columns : mainColumnsObjArray,
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{   
										activePage = params.currentPage;
									}
								}
							}],
							listeners:{
								sortchange:function( ct, column, direction, eOpts)
								{

									me.setSortColumnIndexForPrint(column.text,column.sortState);
									thisController.gridColIndexParam=column.getIndex();
									thisController.gridColStateParam=column.sortState;
									 this.getStore().loadPage(activePage);
								},
								render:function(obj){
  								Ext.defer(function() {
								//obj.columns[1].setSortState("ASC",true,true);
								},100);
								}
							}
					});
                    resultPanelObj.show();
                    resultPanelObj.doLayout();
                }
				else
				{
					resultPanelObj.setTitle(reportData.title);
                    resultPanelObj.add({
                        xtype: 'panel',
                        margin: '0 0 0 0',
                        border: true,
                        frame: true,
						ui:'newGraphPanel',
						html:'<div id="fusionChart"></div>'
                     });
                    resultPanelObj.show();

					if(appConstants.chartType=='fusionchart')
					{
						if (FusionCharts("chartobject1" ))
							FusionCharts("chartobject1").dispose();
						var myChart = new FusionCharts(reportData['swfpath'], 'chartobject1', "80%", reportData.heightForapplet, "0", "1");
						myChart.setXMLData(reportData['XML_DATA']);
						myChart.setTransparent(true);
						myChart.render('fusionChart');
					}
					else if(appConstants.chartType=='highchart')
					{
						reportData.title="";
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('fusionChart',reportData.chartHeight-20,reportData.chartWidth+100), lineChart);
						lineChart.setData(reportData,'<%=currentDateFormat%>','');
						lineChart.drawChart();
					}
                    resultPanelObj.doLayout();
		            Ext.getCmp("csvTool").setDisabled(true);
                }
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
            }
            if (noDataFound) {
                this.disableTools();
				resultPanelObj.removeAll();
                resultPanelObj.hide();
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
				this.getNomeasurepanel().doLayout();
				this.getNomeasurepanel().show();
            } else resultPanelObj.doLayout();
        } 
		else if (reportGeneration == 'background' || reportGeneration == 'background-csv')
		{
			
            resultPanelObj.hide();
  			var htmlStr = '';
            var backgroundReportStatus = jsonData.backgroundReportStatus;
            if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;
                //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;
                //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else {
               htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td>Error In BackGround Generation</td></tr></table></td></tr></table>';
            }
			 this.getBackGroundPanel().update(htmlStr);
 			 this.getBackGroundPanel().show();
        }
        appConstants.initLdgMask.hide();
    },/* this method for user sorting result grid.that sorting option we provide pdf,print .
	based on ErVmSprawlComparator.java column index and sort state maintained.*/
	setSortColumnIndexForPrint: function(columnHeader,sortState)
	{
		var columnIndex=2;// default Powered On
		var sortBy=10;// default asc
		if(columnHeader!=undefined)
		{
			if(columnHeader=='Virtual Machine')
			{
				columnIndex=1;
			}
			else if(columnHeader=='Powered On (%)')
			{
				columnIndex=2;
			}
			else if(columnHeader=='Last Powered On Time')
			{
				columnIndex=3;
			}
			else if(columnHeader=='Powered On With User (%)')
			{
				columnIndex=4;
			}
			else if(columnHeader=='Last User Access Time')
			{
				columnIndex=5;
			}
			else if(columnHeader=='Memory (MB)')
			{
				columnIndex=6;
			}
			else if(columnHeader=='Disk Capacity (GB)')
			{
				columnIndex=7;
			}
			else if(columnHeader=='Server')
			{
				columnIndex=8;
			}
			else if(columnHeader=='OS')
			{
				columnIndex=9;
			}

		}
		if(sortState!=undefined)
		{
			if(sortState=='ASC')
			{
				sortBy=10;
			}
			else if(sortState=='DESC')
			{
				sortBy=11;
			}
		}
		appConstants.gridColumnIndex=columnIndex;
		appConstants.gridColumnSortState=sortBy;

	},
    reloadWithAjax: function (obj) {
		var hiddenFields = appConstants.publicjsonData.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        if (obj.getId() == 'er_comptype') {
            this.updateQueryString(false);
            appConstants.queryString += "&compTypeChange=true";
        } else {
            this.updateQueryString(false);
        }
		var me  = this;
		appConstants.queryString += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
        Ext.Ajax.request({
            url: '/final/reporter/ErVmSprawlReportJson.jsp',
            params: appConstants.queryString,
            method: 'POST',
            success: function (response) {
                appConstants.publicjsonData = Ext.decode(response.responseText);
                var s_option = appConstants.publicjsonData.er_option;
                if (obj.getId() == 'er_option') {
                    if (s_option != 'Component') {
                        comboRawData = appConstants.publicjsonData.siteCombo;
                        selectedComboOption = appConstants.publicjsonData.er_site;
                        comboObject = Ext.getCmp('er_site');
                        comboObject.setFieldLabel(appConstants.publicjsonData.screenLabels['reporter.compliance.eventlog.' + s_option]);
						comboObject.getStore().clearFilter(true); 
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboObject.show();
                        if (s_option == 'Zone') {
                            Ext.getCmp('er_dataZone').show();
                        } else {
                            Ext.getCmp('er_dataZone').hide();
                        }
                    } else {
                        Ext.getCmp('er_site').hide();
                        Ext.getCmp('er_dataZone').hide();
                    }
                }
                if (obj.getId() == 'er_option' || obj.getId() == 'er_site' || obj.getId() == 'er_includezones') {
                    comboRawData = appConstants.publicjsonData.comptypeCombo;
                    selectedComboOption = appConstants.publicjsonData.er_comptype;
                    comboObject = Ext.getCmp('er_comptype');
					comboObject.getStore().clearFilter(true);
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
                }
                comboRawData = appConstants.publicjsonData.componentCombo;
                selectedComboOption = appConstants.publicjsonData.er_component;
                comboObject = Ext.getCmp('er_component');
				appConstants.rawDataForComponents = comboRawData;
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
			if (!isSettingsEnabled)
			{
				me.showConfigDropdown();
			}
			comboRawData = appConstants.publicjsonData.metricCombo;
			selectedComboOption = appConstants.publicjsonData.er_display;
			comboObject = Ext.getCmp('er_display');
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
            }
        });
    },
    updateQueryString: function (needCompnent) {
        var FormParams;
        var hiddenfieldQString = '';
        var timelineParams;
        var timePeriodParams;
		var favorite_id;
        var datafrom = Ext.getCmp('er_option').getValue();
        var compArray = Ext.getCmp('er_component').getValue();
        FormParams = "er_option=" + datafrom + "&er_type=" + Ext.getCmp('er_type').getValue() + "&er_datafrom=" + datafrom;
        if (datafrom != 'Component') {
            FormParams += "&er_site=" + Ext.getCmp("er_site").getValue();
            if (datafrom == 'Zone') {
                FormParams += "&er_dataZone=" + Ext.getCmp("er_dataZone").getValue();
            }
        }
        if (Ext.getCmp('er_type').getValue() == 'No') {
            //FormParams += "&er_sortby=" + Ext.getCmp("er_sortby").getValue();
        } else {
			if (isSettingsEnabled)
			{
				FormParams += "&er_priority=" + Ext.getCmp("er_priority").getValue() + "&er_display=" + Ext.getCmp("er_display").getValue();
			} else {
				FormParams += "&er_priority=" + appConstants.publicjsonData.er_priority + "&er_display=" +appConstants.publicjsonData.er_display;
			}
        }
        var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		FormParams += "&er_comptype=" + Ext.getCmp("er_comptype").getValue();

        if (needCompnent) {
            for (var k = 0; compArray.length > k; k++) {
                FormParams += "&er_component=" + compArray[k];
            }
        }

        var reportGeneration = appConstants.publicjsonData.er_reportgenration;
		if (isSettingsEnabled)
		{
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
        FormParams += "&er_reportgenration=" + reportGeneration;
        if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
            var hiddenFields = appConstants.publicjsonData.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        appConstants.queryString = FormParams + timelineParams + hiddenfieldQString;
		if(favorite_id!=undefined)
			 appConstants.queryString+="&id="+favorite_id;
    },
    loadDefaults: function () {
	if(!hideBackButton){
		Ext.getCmp('virtualmachinessprawlmainform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonData['ID']
			}
		);
	}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
        this.fillFormFields(appConstants.publicjsonData);
        this.refreshReportData();
    },
    refreshReportData: function () {
        if (appConstants.isSubmit != null && appConstants.isSubmit == "true") {
            appConstants.initLdgMask.show();
            this.loadReportData(appConstants.publicjsonData);
        }
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
    },
    fillFormFields: function (jsonData) {
        var screenLabels = jsonData.screenLabels;

	var hiddenFields = appConstants.publicjsonData['hiddenfields'];
        var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}

        var comboRawData;
        var selectedComboOption;
        var comboObject;
		var s_option = jsonData.er_option;
        comboRawData = jsonData.reportTypeCombo;
        selectedComboOption = jsonData.er_type;
        comboObject = Ext.getCmp('er_type');
        comboObject.setFieldLabel(screenLabels['reporter.common.Report Type']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.analyzeCombo;
        selectedComboOption = jsonData.er_option;
        comboObject = Ext.getCmp('er_option');
        comboObject.setFieldLabel(screenLabels['reporter.common.Analyze by']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		if( s_option != 'Component' ) {
			comboRawData = appConstants.publicjsonData.siteCombo;
			if(!Ext.isEmpty(comboRawData))
			{
				selectedComboOption = appConstants.publicjsonData.er_site;
				comboObject = Ext.getCmp('er_site');
				comboObject.setFieldLabel(appConstants.publicjsonData.screenLabels['reporter.compliance.eventlog.' + s_option]);
				comboObject.getStore().clearFilter(true);
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject.show();
			}
			if( s_option == 'Zone'){
				 Ext.getCmp('er_dataZone').show();
			}
		}
        comboRawData = jsonData.subzoneCombo;
        selectedComboOption = jsonData.er_includezones;
        comboObject = Ext.getCmp('er_dataZone');
        comboObject.setFieldLabel(screenLabels['reporter.common.Include Subzone']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.comptypeCombo;
        selectedComboOption = jsonData.er_comptype;
        comboObject = Ext.getCmp('er_comptype');
        comboObject.setFieldLabel(screenLabels['reporter.common.Component Type']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.componentCombo;
        selectedComboOption = jsonData.er_component;
        comboObject = Ext.getCmp('er_component');
        Ext.getCmp('componentsLbl').setText(screenLabels['reporter.commom.Component']);
        comboObject.getStore().loadRawData(comboRawData);
		appConstants.rawDataForComponents = comboRawData;
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }

		//}
        var timelineRawData = jsonData.timelineCombo;
        var selectedTimeline = jsonData.selectedTimeline;
        var timelineObj = Ext.getCmp('er_timeline');
        timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
        timelineObj.getStore().loadRawData(timelineRawData);
        if (!Ext.isEmpty(timelineRawData)) {
            if (!Ext.isEmpty(selectedTimeline)) {
                timelineObj.setValue(selectedTimeline);
            } else {
                timelineObj.setValue(timelineRawData[0].valueField);
            }
        }

        var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = jsonData.startDate;
        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = jsonData.startHour;
        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = jsonData.endDate;
        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = jsonData.endHour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		updatingAppSettings();
    },
    reportGenChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var reportGenType = Ext.getCmp('reportGeneration').getValue();
        if (reportGenType == 'background') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
        } 
		else if (reportGenType == 'background-csv') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
        }else {
            Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
        }
    },
    timeLineOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var startDateObj = Ext.getCmp('er_stdate');
        var startHrObj = Ext.getCmp('er_sthr');
        var endDateObj = Ext.getCmp('er_enddate');
        var endHrObj = Ext.getCmp('er_endhr');
        var timelineObj = Ext.getCmp('er_timeline');
        if (timelineObj.getValue() == 'Any') {
            startDateObj.setDisabled(false);
            startHrObj.setDisabled(false);
            endDateObj.setDisabled(false);
            endHrObj.setDisabled(false);
        } else {
            timelineObj.suspendEvents(true);
            this.updateQueryString(false);
            Ext.Ajax.request({
                url: '/final/reporter/ErVmSprawlReportJson.jsp',
                params: appConstants.queryString,
                scope: this,
                success: function (response) {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
                    publicjsonData = jsonData;
                    var start_hour = jsonData.startHour;
                    var end_hour = jsonData.endHour;
                    var start_date = jsonData.startDate;
                    var end_date = jsonData.endDate;
                    startDateObj.setDisabled(true);
                    startHrObj.setDisabled(true);
                    endDateObj.setDisabled(true);
                    endHrObj.setDisabled(true);
                    startDateObj.setValue(start_date);
                    startHrObj.setValue(start_hour);
                    endDateObj.setValue(end_date);
                    endHrObj.setValue(end_hour);
                }
            });
            timelineObj.resumeEvents();
        }
    },
    loadTools: function () {
        this.getNewUtilities().loadIcon(true, //save
        true, //print
        true, //mail
        false, //data
        true, //csv
        true, // fav
        true, // schedule
        false, //daignosis
        false, //togglebutton
        false, //close
        true //booklet
        );
		//Ext.getCmp("upbutton").hide();
        Ext.getCmp("scheduleTool").setDisabled(false);
        Ext.getCmp("favoriteTool").setDisabled(false);
    },
    disableTools: function () {
        Ext.getCmp("bookletTool").setDisabled(true);
        Ext.getCmp("saveTool").setDisabled(true);
        Ext.getCmp("printTool").setDisabled(true);
        Ext.getCmp("mailTool").setDisabled(true);
        //Ext.getCmp("upbutton").setDisabled(true);
        Ext.getCmp("csvTool").setDisabled(true);
    }
});