
Ext.define('virtualizationcapacityplanningreports.controller.VirtualizationClusterReports',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'}, 
		{selector: 'resultpanel', ref: 'resultpanel'},
		{selector:'virtualizationcapacityplanningform', ref:'virtualizationcapacityplanningform'},
		{selector: 'virtualizationcapacityplanningsettings', ref: 'virtualizationcapacityplanningsettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'},
		{selector: 'ReporterSettings',ref: 'ReporterSettings'},
	],
	init:function(){
		this.control({
			'virtualizationcapacityplanningform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities':
			{
				'afterrender':this.loadTools
			},
			'virtualizationcapacityplanningsettings':
			{
				'afterrender':this.afterSettingsRender
			},
			'virtualizationcapacityplanningform':
			{
				'boxready': this.afterCapacityFormRender
			},
			'virtualizationcapacityplanningform combo[id="vmwarevcenter"]':
			{
				'select': this.changeVcenter
			},
			'virtualizationcapacityplanningform combo[name="reportype"]': {
				'select': this.typeChange
			},
			'virtualizationcapacityplanningform combo[id="cluster"]':
			{
				'select': this.changeCluster
			},
			'virtualizationcapacityplanningsettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekEnd
			},
			'virtualizationcapacityplanningsettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'virtualizationcapacityplanningsettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualizationcapacityplanningsettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'virtualizationcapacityplanningform button[id="submit"]':
			{
				'click': this.formSubmit
			},
			'virtualizationcapacityplanningform button[name="save"]':
			{
				'click': this.goTo
			},
			'timeline combo[name="er_mode"]':
			 {
				'select': this.changeEr_mode
			 },
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #dataTool > button':
			{
				'click': this.callData
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.callData
			}
		});
	},

	goTo: function (btn) {
		// by karthikeyan
if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Virtualization Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
//
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.showSchedules();
		}
    },
	 changeEr_mode: function (combo) {
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var from_schModify = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if(Ext.get('configMod')!=null){
			Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		}
		this.formSubmit(Ext.getCmp('submit'));
     },
	callData: function()
	{
		document.location='/final/servlet/egurkha.reporter.SaveInCSVFormat';
	},
	showFavorites: function( obj )
	{
		if ( this.checkValidate(false) )
		{
			this.formSubmit( obj );
			var qString = appConstants.queryString;
			var hiddenFields =  appConstants.publicJSON["hiddens"];
			var favorite_id = hiddenFields["favorite_id"];
			var target = '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client&er_view=GRAPH'+"&er_RmDispName="+appConstants.er_RmDispName;//&FavoriteId='+favorite_id;
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});

			}
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

		}
	},
	showSchedules: function( obj )
	{
		if ( this.checkValidate(false) )
		{
			this.formSubmit( obj );
			var qString = appConstants.queryString;
			var target = '/final/reporter/ErSaveSchedule.jsp?'+qString+'&er_rtype=Capacity Planning';
			if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
 				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveMe: function()
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF('/final/reporter/ErHtmlToSavePdf.jsp?'+appConstants.publicJSON['PDF_URL']);
	},
	bookletQuery: function(obj)
	{
		return appConstants.publicJSON['PDF_URL'];
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString+'&er_rtype=Capacity Planning';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	printMe: function()
	{
		parent.printWindowFn( appConstants.publicJSON['PRINT_URL']+'&fromPrint=Yes&pdfPrint=yes'); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('virtualizationcapacityplanningform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	changeReportGeneration: function( obj )
	{
		var settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var reportGenVal = settingsForm.findField('reportGeneration').getValue();
		var bgReportObj = settingsForm.findField('bgReportName');
		if ( reportGenVal == 'background' )
		{
			bgReportObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else if ( reportGenVal == 'background-csv' )
		{
			bgReportObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
			bgReportObj.hide();
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeCluster: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeTimeline: function( obj )
	{
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var getTimelineVal = mainForm.findField('er_timeline').getValue();
		var stDateObj = mainForm.findField('er_stdate');
		var endDateObj = mainForm.findField('er_enddate');
		var stHrObj = mainForm.findField('er_sthr');
		var endHrObj = mainForm.findField('er_endhr');
		if ( getTimelineVal == 'Any' )
		{
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
		}
	},
	changeExcludeWeekEnd: function ( obj )
	{
	var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
	var weenendOn=Ext.getCmp("er_excwe").getValue();
	if(weenendOn =='Yes')
		Ext.getCmp('excludeDays').update(excludeMsgs);
	else
		Ext.getCmp('excludeDays').update('');
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	typeChange: function( obj )
	{
		var er_type = Ext.getCmp("reportype").getValue();
		Ext.Ajax.request({
			url: '/final/reporter/ErVcCapacityReportJSON.jsp?er_type='+er_type,
			params: appConstants.queryString,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					appConstants.publicJSON = Ext.decode(jsonText);
					appConstants.repoGene = appConstants.publicJSON 
					console.log(appConstants.publicJSON);
					if(isSettingsEnabled)
					{
						var reportGenCombo=appConstants.publicJSON.reportGenCombo;
						var selreportGeneration=reportGenCombo[0].valueField;
						var reportGen=Ext.getCmp('reportGeneration');
						var reportNameObj = Ext.getCmp('bgReportName');
						reportGen.getStore().loadRawData(reportGenCombo);
						reportGen.setValue(selreportGeneration);
						if(selreportGeneration!=undefined && selreportGeneration!=null && selreportGeneration=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
				}
			}
		});
	},
	changeVcenter: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	afterMainRender: function()
	{
		this.hideResult();
	},
	hideResult: function()
	{
		this.getResultpanel().hide();
		this.disableTools();
	},
	disableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		if ( Ext.getCmp('reportype').getValue() == 'No' )
		{
			Ext.getCmp("csvTool").setDisabled(false);
		}
		else
		{
			Ext.getCmp("csvTool").setDisabled(true);
		}
		//Ext.getCmp("upbutton").setDisabled(false);
	},
	getHiddenQstr: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}

			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	checkValidate: function(flag)
	{
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
        	var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var getVMVal = mainForm.findField('vmwarevcenter').getValue();
		var clusterVal = mainForm.findField('cluster').getValue();
		var msg = '';
		if ( getVMVal == '-1' )
		{
			msg = mainForm.findField('vmwarevcenter').getRawValue();
		}
		else if ( clusterVal === '-1' )
		{
			msg = appConstants.chooseCluster;
		}
		if ( !Ext.isEmpty( msg ) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		var hiddenJSON = appConstants.publicJSON['hiddens'];
		var er_usertimeline = hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = mainForm.findField('er_stdate').getValue();
		tmpStartDate.setHours(mainForm.findField('er_sthr').getValue());
		var tmpEndDate = mainForm.findField('er_enddate').getValue();
		tmpEndDate.setHours(mainForm.findField('er_endhr').getValue());

		var timeFrom =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timeTo =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minFrom =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var minTo =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');


		if ( !checkTimePeriod(timeFrom, minFrom, timeTo, minTo ) )
		{
			return false;
		}
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg = hiddenJSON['limitforbg'];
		var reportgenVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var isSettingsOk = true;
		if ( reportgenVal!=null && reportgenVal == 'foreground' )
		{
			if(flag)
			{
				if ( !Ext.isEmpty(limitforbg ) )
				{
					if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else
		{
			var reportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},
	formSubmit: function( obj )
	{
	
		appConstants.fromvCenter = false;
		appConstants.fromTimeline = false;
		appConstants.fromSubmit = false;
		
		
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		this.getResultpanel().hide();
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
	        var starthr = mainForm.findField('er_sthr').getValue();
	        startdate.setHours(starthr);
	        var enddate = mainForm.findField('er_enddate').getValue();
	        var endhr = mainForm.findField('er_endhr').getValue();
	        enddate.setHours(endhr);
	        var result = checkDateTime(startdate, enddate);
		if (!result) {
            		return;
       		 }
		var me = this;
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
       		var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();

		var actionFrom = '';
		//var fromReportType = false;
		//var fromExcludeWeekEnd = false;
		//var fromTimeline = false;
		//var fromSubmit = false;
		var fromFav = false;
		var fromSch = false;
		var frmCom=false;
		var qstr = '';
		
		var reporTypeVal = mainForm.findField('reportype').getValue();
		var er_componentVal = mainForm.findField('vmwarevcenter').getValue();
		var er_clusterVal = mainForm.findField('cluster').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var startdateVal = mainForm.findField('er_stdate').dataArray;
		var enddateVal = mainForm.findField('er_enddate').dataArray;
		var starthrVal = mainForm.findField('er_sthr').dataArray;
		var er_endhrVal = mainForm.findField('er_endhr').dataArray;
		var er_modeVal = mainForm.findField('er_mode').getValue();


		var er_excweVal = this.getSettingsFieldValue(settingsForm,'er_excwe',isSettingsEnabled,'excludeWeekSelected');
		var timefromVal =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timetoVal =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minfromVal =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var mintoVal =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');

		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var bgReportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
			bgReportName=checkFileName(bgReportName);
		qstr +=  this.getHiddenQstr();

		if(er_clusterVal!=null && (er_clusterVal.indexOf("+")==-1 && er_clusterVal!='AllClusters'))
			er_clusterVal = "+"+er_clusterVal.trim();
		
		if(qstr.indexOf("er_type")==-1)
			qstr +=  '&er_type='+encodeURIComponent(reporTypeVal)
		qstr+='&er_component='+encodeURIComponent(er_componentVal)
				+'&er_cluster='+encodeURIComponent(er_clusterVal)+'&er_timeline='+encodeURIComponent(er_timelineVal)
				+'&startdate='+encodeURIComponent(startdateVal)+'&enddate='+encodeURIComponent(enddateVal)
				+'&starthr='+encodeURIComponent(starthrVal)+'&endhr='+encodeURIComponent(er_endhrVal)
				+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin
				+'&timefrom='+encodeURIComponent(timefromVal)+'&timeto='+encodeURIComponent(timetoVal)
				+'&minfrom='+encodeURIComponent(minfromVal)+'&minto='+encodeURIComponent(mintoVal)
				+'&er_mode='+encodeURIComponent(er_modeVal)+'&er_excwe='+encodeURIComponent(er_excweVal)
				+'&er_reportgenration='+encodeURIComponent(er_reportgenrationVal)+'&bg_reportname='+encodeURIComponent(bgReportName);
		var remoteURL = '/final/reporter/ErVcCapacityReportJSON.jsp';

		qstr+="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString = qstr;
		appConstants.queryString += '&isSubmit=true';
		if ( !Ext.isEmpty( obj ) )
		{
			actionFrom = obj.getId();
			if ( actionFrom == 'reporttype' )
			{
				fromReportType = true;
			}
			else if ( actionFrom == 'vmwarevcenter' )
			{
			frmCom=true;
				appConstants.fromvCenter = true;
			}
		/*	else if ( actionFrom == 'er_excwe' )
			{
				appConstants.fromExcludeWeekEnd = true;
			}*/
			else if ( actionFrom == 'er_timeline' )
			{
				appConstants.fromTimeline = true;
			}
			else if ( actionFrom == 'submit' ||  actionFrom == 'hideSubmit' )
			{
				appConstants.fromSubmit = true;
				if ( actionFrom == 'submit'){
					if ( !me.checkValidate(true) )
					{
						return;
					}
				}
			}
			else if ( actionFrom == 'favoriteTool' || actionFrom == 'favImg' )
			{
				froFav = true;
			}
			else if ( actionFrom == 'scheduleImg' || actionFrom == 'scheduleTool' )
			{
				fromSch = true;
			}
		}
		if ( fromFav )
		{
			appConstants.queryString += '&call=json';
			return;
		}
		else if ( fromSch )
		{
			return;
		}
		if(frmCom)
		this.generateResult();
		if ( appConstants.fromSubmit )
			this.generateResult();
	},
	generateResult : function()
	{
		var me = this;
		var qstr = appConstants.queryString;
       	var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');

		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var reporTypeVal = mainForm.findField('reportype').getValue();
		var remoteURL = '';
		{
			if ( er_reportgenrationVal == 'foreground' )
			{
				remoteURL = '/final/servlet/com.eg.ErVcCapacityReportC';
				qstr += '&call=json&isSubmit=true';
			}
			else if(er_reportgenrationVal == 'background-csv')
			{
				remoteURL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				qstr += '&call=json&isSubmit=true&forwardto=ErVcCapacityReportJSON';
			}
			else
			{
				remoteURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				qstr += '&call=json&isSubmit=true&forwardto=ErVcCapacityReportJSON';
			}
		}
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		this.getResultpanel().hide();
		initLdgMask.show();
		Ext.Ajax.request({
			url: remoteURL,
			params: qstr,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					appConstants.publicJSON = Ext.decode(jsonText);
					var selectedData = appConstants.publicJSON['selectedValues'];
					if ( appConstants.fromvCenter )
					{
						var clusterCombo = appConstants.publicJSON['clusterCombo'];
						var clusterSelected = selectedData['clusterSelected'];
						if ( !Ext.isEmpty( clusterCombo ) )
						{
							me.setValueWithOptionInList(mainForm, 'cluster', clusterCombo, clusterSelected);
						}
						else
						{
							me.insertNotApplicable(mainForm, 'cluster');
						}
							initLdgMask.hide();
					}
					/*else if ( appConstants.fromExcludeWeekEnd )
					{
						var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
						if ( !Ext.isEmpty( excludeMsgs ) )
						{
							Ext.getCmp('excludeDays').update(excludeMsgs);
						}
						else
						{
							Ext.getCmp('excludeDays').update('');
						}
					}*/
					else if ( appConstants.fromTimeline )
					{
						var startDate = selectedData['startDate'];
						var endDate = selectedData['endDate'];
						var startHour = selectedData['startHour'];
						var endHour = selectedData['endHour'];
						mainForm.findField('er_stdate').setValue(startDate);
						mainForm.findField('er_enddate').setValue(endDate);
						mainForm.findField('er_sthr').setValue(startHour);
						mainForm.findField('er_endhr').setValue(endHour);
					}
					else if ( appConstants.fromSubmit )
					{
						me.getResultpanel().removeAll();
						me.getResultpanel().show();
						var resultData = appConstants.publicJSON['RESULTS'];
						if ( er_reportgenrationVal == 'foreground')
						{
							if ( !Ext.isEmpty( resultData ) )
							{
								me.getResultpanel().setTitle(resultData['TITLE']);
								if ( reporTypeVal == 'Yes' )
								{
									me.loadGraph(resultData);
								}
								else
								{
									me.loadData(resultData);
								}

 							}
							else
							{
 								me.getNomeasurepanel().show();
								me.getResultpanel().hide();
							}
						}
						else
						{
							resultData = appConstants.publicJSON['backgroundResults'];
							me.loadBackground(resultData);
						}
						initLdgMask.hide();
						//Ext.getCmp('virtualizationcapacityplanningform').show();
					}
				}
			}
		});

	},
	loadBackground: function( resultData )
	{
		this.getResultpanel().hide();
		var backgroundResultsData = resultData;
		if ( !Ext.isEmpty( backgroundResultsData ) )
		{
			this.getBackGroundPanel().removeAll();
			var resultObj = this.getBackGroundPanel();
			var backgroundResultStatus = backgroundResultsData['status'];
			var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
			var backgroundResultURL = backgroundResultsData['backgroundResponseURLLink'];
			var backgroundResultURLLinkText = backgroundResultsData['backgroundResponseURLText'];
			var htmlStr = '';
			if ( backgroundResultStatus == 'success' )
			{
			//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" style="text-decoration:underline" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			else if ( backgroundResultStatus == 'duplicate' )
			{
				//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" style="text-decoration:underline" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br><a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';

			}
			resultObj.removeAll();
			resultObj.add({
				xtype: 'container',
				//cls:'measuresErrorPanelBg',
				margin:0,
				bodyPadding:0,
				//height: '100%',
				width: '100%',
				html: htmlStr
			});
			resultObj.show();
			resultObj.doLayout();
			this.disableTools();
		}
	},
	loadData: function( resultData )
	{
		var resultObj = this.getResultpanel();
		var dataResults = resultData['DATA_RESULTS'];
		var splitterHtml = '<hr style="margin:5px 0px" class="newLineBottom"/>';

		if ( !Ext.isEmpty(dataResults) )
		{
			this.enableTools();
			if ( !Ext.isEmpty(resultObj.getHeader() ) )
			{
				resultObj.getHeader().show();
			}
			for ( var i = 0; i < dataResults.length; i++ )
			{
				if ( i == dataResults.length - 1 || dataResults.length == 1 )
				{
					splitterHtml = '';
				}
				var dataResult = dataResults[i];
				var title = dataResult['TITLE'];
				var dataRes = dataResult['DATA_RESULTS'];
				var tableTitle = dataResult['TABLE_TITLE'];
				var msgs = dataResult['MESSAGES'];
				var clusterTable = dataResult['CLUSTER_TABLE_RESULTS'];



				var tableString='<div class="newTable" style="padding-top:85px;"><table cellspacing="0" cellpadding="0" border="0" width="100%"><thead>';
						tableString+='<tr>';
							tableString+='<th colspan="2">'+tableTitle;
							tableString+='</th>';
					tableString+='</tr>';
					tableString+='</thead>';
					tableString+='</tbody>';
				for ( var key in dataRes )
				{
					tableString+='<tr>';
						tableString+='<td valign="top"><div >'+key+'</div></td>';
						tableString+='<td width="80px" valign="top"><div >'+dataRes[key]+'</div></td>';
					tableString+='</tr>';
				}
				tableString+='</tbody></table></div>';
				resultObj.add(
				{
					xtype: 'header',
					cls:'newLineBottom',
					margin:'0 10 10 10',
					padding:'0 0 10 0',
					html:'<span class="newFont_bold12">'+title+'</span>'
				},
				{
					xtype:'container',
					width:'100%',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'start',
					},
					items:[{
						xtype:'container',
						flex:.6,
						layout:{
							type:'vbox',
							align:'stretch',
							pack:'start',
						},
						defaults:{
							margin:10,
						},
						items:[{
							xtype:'container',
							layout:{
								type:'hbox',
								align:'stretch',
								pack:'start',
							},
							flex:1,
							defaults:{
								margin:'0 10 0 0',
								padding:'3 5 3 5',
							},
							items:[
							{
								xtype:'container',
								cls:'boxWithRightArrowOut',
								html:'<div style="text-align:center;width:100%;padding:10px 5px 5px 5px;"><img src="/final/images/spacer.gif" class="totalVMs32"><p style="padding-top:10px" class="newFont_bold13">'+vmsLabel+'</p></div>',
								flex:.2
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+vmsOnLabel+'</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.vmsonMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.vmsonAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+vmsAllocatedLabel+'</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.allocatedVmsMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.allocatedVmsAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							}]
						},{
							xtype:'container',
							layout:{
								type:'hbox',
								align:'stretch',
								pack:'start',
							},
							flex:1,
							defaults:{
								margin:'0 10 0 0',
								padding:'3 5 3 5',
							},
							items:[
							{
								xtype:'container',
								cls:'boxWithRightArrowOut',
								html:'<div style="text-align:center;width:100%;padding:10px 5px 5px 5px;"><img src="/final/images/spacer.gif" class="cpu32"><p style="padding-top:10px" class="newFont_bold13">'+clusterCPULabel+'</p></div>',
								flex:.2
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+availableLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.availCpuMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.availCpuAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+consumedLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.usedCpuMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.usedCpuAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							}]
						},{
							xtype:'container',
							layout:{
								type:'hbox',
								align:'stretch',
								pack:'start',
							},
							flex:1,
							defaults:{
								margin:'0 10 0 0',
								padding:'3 5 3 5',
							},
							items:[
							{
								xtype:'container',
								cls:'boxWithRightArrowOut',
								html:'<div style="text-align:center;width:100%;padding:10px 5px 5px 5px;"><img src="/final/images/spacer.gif" class="memory32"><p style="padding-top:10px" class="newFont_bold13">'+clusterMemoryLabel+'</p></div>',
								flex:.2
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+availableLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.availMemoryMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.availMemoryAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top"  height="20px"><div class="newFont_normal13">'+consumedLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.usedMemoryMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.usedMemoryAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							}]
						}]
					},{
						xtype:'container',
						flex:.4,
						margin:10,
						padding:'0 10 0 10',
						cls:'newLineLeft',
						html:tableString
					}]
				},
				{
					xtype:'container',
					border:true,
					margin:'30 10 30 10',
					padding:0,
					flex:1,
					html:'<div class="notes" style="width:100%"><div class="paperPin"></div><div style="float:left;text-align:center" class="paperPinText">'+msgs+'</div></div>'
				},
				{
				/*	xtype:'customgrid',
					columns:mainColArray,
					store:store,
					needtoFixColumn:true,
					ui:'newGridPanel',
					margin:10,
					border:true,
					frame:false*/
 				}

				
				);
			}
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
		}
		else
		{
			resultObj.hide();
 			this.getNomeasurepanel().show();
 		}
	},
	loadGraph: function( resultData )
	{
		var thisController = this;
		var resultObj = this.getResultpanel();
		var graphResults = resultData['GRAPH_RESULTS'];
		var splitterHtml = '<hr style="margin:5px 0px" class="newLineBottom"/>';
		if ( !Ext.isEmpty( graphResults ) )
		{
			this.enableTools();
			if ( !Ext.isEmpty(resultObj.getHeader() ) )
			{
				resultObj.getHeader().show();
			}
			for ( var i = 0; i < graphResults.length; i++ )
			{
				if ( i == graphResults.length - 1 || graphResults.length == 1 )
				{
					splitterHtml = '';
				}
				var graphResult = graphResults[i];
				var title = graphResult['TITLE'];
				var chartResults = graphResult['CHART_RESULTS'];
				var chartTitle = chartResults['TITLE'];
				var clusterTable = graphResult['CLUSTER_TABLE_RESULTS'];
				var swfPath = chartResults['SWF_PATH'];
				var xmlData = chartResults['XML_DATA'];
				var msgs = graphResult['MESSAGES'];

				resultObj.add(
				{
					xtype: 'header',
					cls:'newLineBottom',
					margin:'0 10 10 10',
					padding:'0 0 10 0',
					html:'<span class="newFont_bold12">'+title+''+'</span>'
				},
				{
					xtype:'container',
					width:'100%',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'start',
					},
					items:[{
						xtype:'container',
						flex:.6,
						layout:{
							type:'vbox',
							align:'stretch',
							pack:'start',
						},
						defaults:{
							margin:10,
						},
						items:[{
							xtype:'container',
							layout:{
								type:'hbox',
								align:'stretch',
								pack:'start',
							},
							flex:1,
							defaults:{
								margin:'0 10 0 0',
								padding:'3 5 3 5',
							},
							items:[
							{
								xtype:'container',
								cls:'boxWithRightArrowOut',
								html:'<div style="text-align:center;width:100%;padding:10px 5px 5px 5px;"><img src="/final/images/spacer.gif" class="totalVMs32"><p style="padding-top:10px" class="newFont_bold13">'+vmsLabel+'</p></div>',
								flex:.2
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+vmsOnLabel+'</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.vmsonMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.vmsonAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+vmsAllocatedLabel+'</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.allocatedVmsMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.allocatedVmsAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							}]
						},{
							xtype:'container',
							layout:{
								type:'hbox',
								align:'stretch',
								pack:'start',
							},
							flex:1,
							defaults:{
								margin:'0 10 0 0',
								padding:'3 5 3 5',
							},
							items:[
							{
								xtype:'container',
								cls:'boxWithRightArrowOut',
								html:'<div style="text-align:center;width:100%;padding:10px 5px 5px 5px;"><img src="/final/images/spacer.gif" class="cpu32"><p style="padding-top:10px" class="newFont_bold13">'+clusterCPULabel+'</p></div>',
								flex:.2
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+availableLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.availCpuMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.availCpuAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+consumedLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.usedCpuMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.usedCpuAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							}]
						},{
							xtype:'container',
							layout:{
								type:'hbox',
								align:'stretch',
								pack:'start',
							},
							flex:1,
							defaults:{
								margin:'0 10 0 0',
								padding:'3 5 3 5',
							},
							items:[
							{
								xtype:'container',
								cls:'boxWithRightArrowOut',
								html:'<div style="text-align:center;width:100%;padding:10px 5px 5px 5px;"><img src="/final/images/spacer.gif" class="memory32"><p style="padding-top:10px" class="newFont_bold13">'+clusterMemoryLabel+'</p></div>',
								flex:.2
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top" height="20px"><div class="newFont_normal13">'+availableLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.availMemoryMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.availMemoryAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							},{
								xtype:'container',
								cls:'boxWithRightArrowIN',
								html:'<table border="0px" width="100%" height="100%"><tr><td valign="top"  height="20px"><div class="newFont_normal13">'+consumedLabel+' (mhz)</div></td></tr><tr><td align="center" valign="middle"><div style="width:50%;text-align:center;float:left" class="newLineRight"><div class="newFont_bold18">'+clusterTable.usedMemoryMax+'</div><div class="newFont_normal11">'+max+'</div></div><div style="width:50%;text-align:center;float:left"><div class="newFont_bold18">'+clusterTable.usedMemoryAvg+'</div><div class="newFont_normal11">'+avg+'</div></div></td></tr></table>',
								flex:.4
							}]
						}]
					},{
						xtype:'container',
						flex:.4,
						margin:10,
						cls:'newLineLeft',
						style:
						{
							'text-align':'center',
						},
						html:'<div style="text-align:center" class="newFont_bold13">'+chartTitle+'</div><div style="border:0px solid red;height:285px" id="fusionChart'+i+'"></div>'
					}]
				},
				{
					xtype:'container',
					border:true,
					margin:'30 10 30 10',
					padding:0,
					flex:1,
					html:'<div class="notes" style="width:100%"><div class="paperPin"></div><div style="float:left;text-align:center" class="paperPinText">'+msgs+'</div></div>'
				},
				{
				/*	xtype:'customgrid',
					columns:mainColArray,
					needtoFixColumn:true,
					ui:'newGridPanel',
					store:store,
					margin:10,
					border:true,
					frame:false*/
				}
				);
				if ( !Ext.isEmpty( xmlData ) )
				{
					if(appConstants.chartType=='fusionchart')
						{
					if (FusionCharts('barChart' + i ))
						FusionCharts('barChart' + i).dispose();
					var myChart = new FusionCharts(swfPath,"barChart"+i, "80%", "85%","0","1");
					myChart.setXMLData(xmlData);
					myChart.setTransparent(true);
					myChart.render('fusionChart'+i);
						}
						//
						else if(appConstants.chartType=='highchart')
						{
								var highChart = {};
								highChart = jQuery.extend(true, {}, getHighChartsBarInstance('fusionChart'+i,chartResults.chartHeight,chartResults.chartWidth), highChart);
								highChart.setData(chartResults,'<%=currentDateFormat%>','');
								highChart.drawChart();
						}
					Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
 				}
				else
				{
  					this.getNomeasurepanel().show();
				}
 			}
		}
		else
		{
			resultObj.hide();
  			this.getNomeasurepanel().show();
		}
	},
	loadTools: function()
	{
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //csv
			true, // fav
			true,// schedule
			false, //diagnosis
			false, //togglebutton
			false, //close
			true //booket
			);

	},
	changeReportType: function( obj )
	{
		/*var getReportVal = Ext.getCmp('reportype').getValue();
		if ( getReportVal == 'Yes' )
		{
			Ext.getCmp('er_mode').show();
		}
		else
		{
			Ext.getCmp('er_mode').hide();
		}*/
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	afterSettingsRender:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var ObjectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		ObjectArr['er_excwe'] = screenLabels['reporter.common.excludeweekends'];
		ObjectArr['timeperiodLbl'] = screenLabels['reporter.common.Timeperiod'];
		ObjectArr['fromTimeLbl'] = screenLabels['reporter.common.From'];
		ObjectArr['toTimeLbl'] = screenLabels['reporter.common.To'];
		ObjectArr['fromHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['fromMinsLbl'] = screenLabels['reporter.common.Mins'];
		ObjectArr['toHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['toMinsLbl'] = screenLabels['reporter.common.Mins'];
		//ObjectArr['er_timeline'] = screenLabels['reporter.common.Timeline'];
		//ObjectArr['er_stdate'] = screenLabels['reporter.common.From'];
		//ObjectArr['er_enddate'] = screenLabels['reporter.common.To'];
		//ObjectArr['er_sthr'] = screenLabels['reporter.common.Hr'];
		//ObjectArr['er_endhr'] = screenLabels['reporter.common.Hr'];
		//ObjectArr['er_mode'] = screenLabels['reporter.common.Graph'];
		ObjectArr['reportGeneration'] = screenLabels['reporter.consolidated.reportGeneration'];
		ObjectArr['bgReportName'] = screenLabels['reporter.consolidated.reportName'];
//		Ext.getCmp('submit').setText(screenLabels['reporter.common.SUBMIT']);

		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			/*var result = me.validateSettings();
			if ( !result )
			{
				return;
			}
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});	*/
			me.validateAndCloseSettings();
		});


		this.loadScreenLabels( settingsForm, ObjectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];
		var excludeWeekCombo = appConstants.publicJSON['excludeWeekCombo'];
		var excludeWeekSelected = selectedData['excludeWeekSelected'];
		if ( !Ext.isEmpty( excludeWeekCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'er_excwe', excludeWeekCombo, excludeWeekSelected);
		}
		var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
		if ( !Ext.isEmpty( excludeMsgs ) )
		{
			Ext.getCmp('excludeDays').update(excludeMsgs);
		}
		else
		{
			Ext.getCmp('excludeDays').update('');
		}

		settingsForm.findField('timefrom').setValue(selectedData['timePeriodFromHrSelected']);
		settingsForm.findField('minfrom').setValue(selectedData['timePeriodFromMinSelected']);

		settingsForm.findField('timeto').setValue(selectedData['timePeriodToHrSelected']);
		settingsForm.findField('minto').setValue(selectedData['timePeriodToMinSelected']);
		
		var repoMaking = "";
		if (appConstants.repoGene!=undefined)
		{
			repoMaking =appConstants.repoGene;
		}
		else
		{
			repoMaking = appConstants.publicJSON;
		}

		var reportGenCombo = repoMaking['reportGenCombo'];
		var reportGenSelected = selectedData['reportGenSelected'];
		if ( !Ext.isEmpty( reportGenCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'reportGeneration', reportGenCombo, reportGenSelected);
			this.changeReportGeneration();
		}
		updatingAppSettings();
	},	
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		if(isSettingsOk)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.formSubmit(Ext.getCmp('submit'));
		}
	},
	showConfigDropdown:function(){

		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:580,
			padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'370px'}
				},
				{
					xtype:'container',
					cls:'containerHeader',
					html:tpl.apply(),
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype : 'virtualizationcapacityplanningsettings',
					parent:this
				}
			],
			renderTo:'virtualizationcapcityplanning-body'
			});

	},
	afterCapacityFormRender: function()
	{
		this.hideResult();
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJSON['TITLE']);
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var ObjectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		ObjectArr['reportype'] = screenLabels['reporter.common.reportType'];
		ObjectArr['vmwarevcenter'] = screenLabels['componentType_LABEL'];
		ObjectArr['cluster'] = screenLabels['reporter.common.Cluster'];
		this.loadScreenLabels( mainForm, ObjectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];
		var reportTypeCombo = appConstants.publicJSON['reportTypeCombo'];
		var reportTypeSelected = selectedData['reportTypeSelected'];
		if ( !Ext.isEmpty( reportTypeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'reportype', reportTypeCombo, reportTypeSelected);
			this.changeReportType();
		}

		var vCenterCombo = appConstants.publicJSON['vCenterCombo'];
		var vCenterSelected = selectedData['vCenterSelected'];
		if ( !Ext.isEmpty( vCenterCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'vmwarevcenter', vCenterCombo, vCenterSelected);
		}

		var clusterCombo = appConstants.publicJSON['clusterCombo'];
		var clusterSelected = selectedData['clusterSelected'];
		if ( !Ext.isEmpty( clusterCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'cluster', clusterCombo, clusterSelected);
		}
		else
		{
			this.insertNotApplicable(mainForm, 'cluster');
		}
		var timelineCombo = appConstants.publicJSON['timelineCombo'];
		var selectedTimeline = selectedData['selectedTimeline'];
		if ( !Ext.isEmpty( timelineCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_timeline', timelineCombo, selectedTimeline);
			this.changeTimeline();
		}

		//settingsForm.findField('er_stdate').setValue(selectedData['startDate']);
		//settingsForm.findField('er_sthr').setValue(selectedData['startHour']);
		//settingsForm.findField('er_enddate').setValue(selectedData['endDate']);
		//settingsForm.findField('er_endhr').setValue(selectedData['endHour']);

		mainForm.findField('er_mode').setValue(selectedData['selectedGraphMode']);

		var startdateObj = mainForm.findField('er_stdate');
		var enddateObj = mainForm.findField('er_enddate');
		var startHourObj = mainForm.findField('er_sthr');
		var endHourObj = mainForm.findField('er_endhr');

		startdateObj.setValue(selectedData['startDateForDisplay']);
	        startdateObj.dataArray =selectedData['startDate'];
	        startHourObj.setValue(selectedData['startHourForDisplay']);
	        startHourObj.dataArray = selectedData['startHour'];
	        enddateObj.setValue(selectedData['endDateForDisplay']);
	        enddateObj.dataArray =selectedData['endDate'];
	        endHourObj.setValue(selectedData['endHourForDisplay']);
	        endHourObj.dataArray = selectedData['endHour'];
	        stmin =selectedData['startMinForDisplay'];
	        enmin = selectedData['endMinForDisplay'];
	        mgr_stmin =selectedData['startmin'];
	        mgr_enmin = selectedData['endmin'];

		var hiddenFields =  appConstants.publicJSON["hiddens"];
       	var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];

			if(!hideBackButton){
				//console.log('2222222222');
				Ext.getCmp('virtualizationcapacityplanningform').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicJSON['ID']
					}
				);
		}
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			this.getResultpanel().removeAll();
			this.getResultpanel().hide();
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ( appConstants.isSubmit == 'true' && from_favorite != "Yes")
		{
			this.getResultpanel().removeAll();
			this.getResultpanel().show();
			if ( selectedData['reportGenSelected'] == 'foreground')
			{
				var resultData = appConstants.publicJSON['RESULTS'];
				if ( !Ext.isEmpty( resultData ) )
				{
					this.getResultpanel().setTitle(resultData['TITLE']);
					/*if ( reportTypeSelected == 'Yes' )
					{
						this.loadGraph(resultData);
					}
					else
					{
						this.loadData(resultData);
					}*/
					this.formSubmit(Ext.getCmp('submit'));
					//Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
				}
				else
				{
					this.getResultpanel().add(
						{
							xtype: 'container',
							height: 270,
							html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
						}
					);
				}
			}
			else
			{
				var resultData = appConstants.publicJSON['backgroundResults'];
				this.loadBackground(resultData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.formSubmit(Ext.getCmp('submit'));
			}
		}
	},
	validateSettings: function()
	{
		var isSettingsOk = true;
		var settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var reportgenVal = settingsForm.findField('reportGeneration').getValue();
		var reportNameObj = Ext.getCmp('bgReportName');
		if ( reportgenVal!=null && (reportgenVal == 'background' || reportgenVal == 'background-csv'))
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				return false;
			}
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			this.generateResult();
		}
		else
		{
			if(!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler(); 
			}
			Ext.getCmp('reportGeneration').setValue('background');
			var reportNameObj = Ext.getCmp('bgReportName');
			reportNameObj.setValue("");
			reportNameObj.show();
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
	},
	insertNotApplicable: function ( form, fieldName )
	{
		var obj = form.findField(fieldName);
		obj.getStore().removeAll();
		obj.getStore().add({
			'displayField': appConstants.notApplicable,
			'valueField': '-1'
		});
		obj.setValue('-1');
	},
	loadScreenLabels: function ( form, ObjectArr )
	{
		var obj = '';
		for ( var key in ObjectArr )
		{
			obj = !Ext.isEmpty(form.findField(key))?form.findField(key):Ext.getCmp(key);
			if ( obj.getXType() != 'label' )
			{
				form.findField(key).setFieldLabel(ObjectArr[key]);
			}
			else
			{
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);

		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
 		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else
			value = appConstants.publicJSON.selectedValues[jsonParam];

 		return value;
	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});


