
	Ext.define('virtualizationclusterreports.controller.VirtualizationClusterReports',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'virtualizationclusterform', ref:'virtualizationclusterform'},
		{selector:'virtualizationclustersettings', ref:'virtualizationclustersettings'},
		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
		   'newUtilities' : {
			   'afterrender' : this.hideTools
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'virtualizationclusterform':{
				'boxready':this.loadDafaultData
			},
			'virtualizationclustersettings':{
				'afterrender':this.loadSettingsElements
			},
			'virtualizationclustersettings combo[name="er_timeline"]':{
				'select': this.timeLineOnChange
			},
			'virtualizationclustersettings combo[name="er_trenddata"]':{
				'select': this.trendOnChange
			},
			'virtualizationclustersettings combo[name="er_filter"]':{
				'select': this.filterOnChange
			},
			'virtualizationclustersettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'virtualizationclustersettings button[name="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualizationclustersettings button[name="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'virtualizationclusterform combo[name="er_type"]':{
				'select': this.reporttypeOnChange
			},
			'virtualizationclusterform combo[name="er_comptype"]':{
				'select': this.reportForChange
			},
			'virtualizationclusterform combo[name="er_component"]':{
				'select': this.virtualCenterOnChange
			},
			'virtualizationclusterform combo[name="er_cluster"]':{
				'select': this.clusterOnChange
			},
			'virtualizationclusterform combo[name="er_resource"]':{
				'select': this.hidePanel
			},
			'virtualizationclusterform combo[name="ermeasuretest"]':{
				'select': this.hidePanel
			},
			'virtualizationclusterform combo[name="er_report"]':{
				'select': this.reportbyOnChange
			},
			'virtualizationclusterform combo[name="graphtype"]':{
				'select': this.graphTypeOnChange
			},
			'mainform button[itemId="submit"]':{
				'click': this.showGraph
			},
			'mainform button[itemId="save"]':{
				'click': this.add
			},
			'egcomponent button[id="expandSelector"]': {
				'click': this.expandMe
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
				'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
				'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
				'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
				'click':this.add
			},
			'newUtilities > #scheduleTool > button':{
				'click':this.add
			},
			'virtualizationclustersettings combo[id="er_excwe"]': {
				'select': this.changeExcludeWeekEnds
					},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
					},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			 'graphwindow combo[name="timeLineDrillDown"]': {
				'select': this.drillDownTimeOnchange
			},
			'graphwindow button[name="drillDownSubmit"]': {
				'click': this.drillDownSubmit
			},
			'drilldowntool > container > button': {
				'click': this.drillDownProcess
			}
		});
	},
	drillDownProcess:function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		 var ermeasuretest = Ext.getCmp('ermeasuretest').getValue();
		 if (obj.getId()=='drillDownSave')
		 {
			var s_qryString=appConstants.drillDownTraverseUrl.replace(appConstants.drillDownTraverseUrl.substring(0,appConstants.drillDownTraverseUrl.indexOf('?')),'/final/reporter/ErHtmlToSavePdf.jsp');
			appConstants.erUtils.savePDF(s_qryString+"&ermeasuretest="+ermeasuretest+"&ervm_type=vc_cluster");
		 }
		 else if (obj.getId()=='drillDownPrint')
		 {
			var s_qryString=appConstants.drillDownTraverseUrl.replace(appConstants.drillDownTraverseUrl.substring(0,appConstants.drillDownTraverseUrl.indexOf('?')),'/final/reporter/ErVMPrintData.jsp');
			s_qryString+='&pdfPrint=Yes';

			parent.printWindowFn(s_qryString+"&ermeasuretest="+ermeasuretest+"&ervm_type=vc_cluster&er_option=graph");
		 }
		 else if (obj.getId()=='drillDownMail')
		 {
			 var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				 drillDownParams = "&showLegend="+islegendEnabled;
			}
			  drillDownParams = "&drillDown=Yes&DrillDown=Yes";
			Ext.widget('sendmail').show();
		 }
		 else
			obj.findParentByType('window').close();
	},
	drillDownSubmit:function()
	{
		var map = new Ext.util.HashMap();
		var drillDownSplit=appConstants.drillDownTraverseUrl.split('?');
		var drillDownSplitArray=drillDownSplit[1].split('&');
		for (var key in drillDownSplitArray)
		{
			var splitIntoKeyValue=drillDownSplitArray[key].split('=');
			map.add(splitIntoKeyValue[0], splitIntoKeyValue[1]);
		}
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('startdateDrillDown').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('enddateDrillDown').getValue(), mgrDateFormat);

		map.replace('er_timeline',Ext.getCmp('timeLineDrillDown').getValue());
		map.replace('startdate',startDateConverted);
		map.replace('enddate',endDateConverted);
		map.replace('starthr',Ext.getCmp('startHourDrillDown').getValue());
		map.replace('endhr',Ext.getCmp('endHourDrillDown').getValue()); 
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		 
		var timelineObj=Ext.getCmp('timeLineDrillDown');
		var stDateObj=Ext.getCmp('startdateDrillDown');
		var enDateObj=Ext.getCmp('enddateDrillDown');
		var stHourObj=Ext.getCmp('startHourDrillDown');
		var enHourObj=Ext.getCmp('endHourDrillDown');
		var diff_ms=appConstants.erUtils.getDateDiff_ms(timelineObj.getValue(),stDateObj.getValue(),enDateObj.getValue(),stHourObj.getValue(),enHourObj.getValue());

		if (diff_ms<=maxTimelineDiff_ms)
		{
			map.replace('loachartAs','highchart');
		}
		else
		{
			map.replace('er_width',1000);
			map.replace('er_height',300);
			map.removeAtKey('loachartAs');
		}
		var mapParams='';
		map.each(function(key, value, length){
			 mapParams+='&'+key+'='+value;
		});
		mapParams = mapParams.replace('&','?');

		appConstants.drillDownTraverseUrl=drillDownSplit[0]+mapParams;
			 
		if (diff_ms<=maxTimelineDiff_ms)
		{
			reportHighStockChart(appConstants.drillDownTraverseUrl,'drillDownContainer','100%','100%','');
		}
		else
		{
			var htm='<img src="'+appConstants.drillDownTraverseUrl+'" width="100%" height="300px"/>';
			Ext.getCmp('drillDownContainer').update(htm);
		}
	},
	loadUrlInDrillDown:function(dataUrl,title,chartypeString)
	{
		appConstants.drillDownTraverseUrl=dataUrl+'&loachartAs='+chartypeString;//+"&er_drillDownEnabled=yes";

		var graphwindow=Ext.create('virtualizationclusterreports.view.GraphWindow').show();
		graphwindow.down('panel').setTitle(title);
		
		var timelineObj=Ext.getCmp('timeLineDrillDown');
		var stDateObj=Ext.getCmp('startdateDrillDown');
		var enDateObj=Ext.getCmp('enddateDrillDown');
		var stHourObj=Ext.getCmp('startHourDrillDown');
		var enHourObj=Ext.getCmp('endHourDrillDown');
		var erModeObj=Ext.getCmp('graphmodeDrillDown');
		if (timelineObj.getValue() == 'Any') {
			stDateObj.setDisabled(false);
			enDateObj.setDisabled(false);
			stHourObj.setDisabled(false);
			enHourObj.setDisabled(false);
		} else {
			stDateObj.setDisabled(true);
			enDateObj.setDisabled(true);
			stHourObj.setDisabled(true);
			enHourObj.setDisabled(true);
		}
		if (chartypeString=='highchart')
		{
			reportHighStockChart(appConstants.drillDownTraverseUrl,'drillDownContainer','100%','100%','');
		}
		else
		{
			this.drillDownSubmit();// inorder to change er_width and er_height in querystring for easy chart, drillDownSubmit method is called here
		}
	},
	drillDownTimeOnchange: function () {
		var timelineObj=Ext.getCmp('timeLineDrillDown');
		var stDateObj=Ext.getCmp('startdateDrillDown');
		var enDateObj=Ext.getCmp('enddateDrillDown');
		var stHourObj=Ext.getCmp('startHourDrillDown');
		var enHourObj=Ext.getCmp('endHourDrillDown');
		var erModeObj=Ext.getCmp('graphmodeDrillDown');
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		if (timelineObj.getValue() == 'Any') {
			//appConstants.erUtils.toggleGraphCombo(timelineObj.getValue(),stDateObj.getValue(),enDateObj.getValue(),stHourObj.getValue(),enHourObj.getValue(),erModeObj);
			stDateObj.setDisabled(false);
			enDateObj.setDisabled(false);
			stHourObj.setDisabled(false);
			enHourObj.setDisabled(false);
		} else {
			stDateObj.setDisabled(true);
			enDateObj.setDisabled(true);
			stHourObj.setDisabled(true);
			enHourObj.setDisabled(true);
			var timeline = timelineObj.getValue();
			var strtdt = stDateObj.getValue();
			var enddt = enDateObj.getValue();
			var strthour =stHourObj.getValue();
			var endhr = enHourObj.getValue();

			if(timeline=="Any")
			{
				strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
				enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
			}
			else
			{
				strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
				enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
			}
			// strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			//enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
			//var gtype=this.up('fieldcontainer').gtype;
			var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
			/*if(gtype!=null && (gtype=='summary' || gtype=='trend'))
			{
				var period = Ext.getCmp("period").getValue();
				no_params += "&P6=["+period+"]&P7=[]&F=getTimeForSummary";
			}
			else
			{
				no_params +="&F=getTime";
			}*/
			no_params +="&F=getTime";
			var param = "C=id" + no_params;
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params: param,
				scope: this,
				method: 'POST',
				success: function (response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					if (!Ext.isEmpty(jsonData)) {
						var timedata = jsonData.timeline;
						stDateObj.setValue(timedata[6]);
						stDateObj.dataArray = timedata[0];
						enDateObj.setValue(timedata[7]);
						enDateObj.dataArray = timedata[1];
						stHourObj.setValue(timedata[8]);
						stHourObj.dataArray = timedata[2];
						enHourObj.setValue(timedata[9]);
						enHourObj.dataArray = timedata[3];
						stmin = timedata[10];
						enmin = timedata[11];
						mgr_stmin = timedata[4];
						mgr_enmin = timedata[5];
						//appConstants.erUtils.toggleGraphCombo(timelineObj.getValue(),stDateObj.getValue(),enDateObj.getValue(),stHourObj.getValue(),enHourObj.getValue(),erModeObj);
					}
				}
			});
		}
	},
	filterMultiselect: function (obj) {

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_host'),appConstants.rawDataForComponents);
	},
	 changeEr_mode: function (combo) {
		var hiddenFields = defaultJSON.hiddenFields;
		var from_schModify = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		this.showGraph();
	},
	hideTools : function() {
		this.getNewUtilities().loadIcon(true, true, true, false, true, true,
				true, false, false, false,true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp("upbutton").hide();
	   // Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	/*changeExcludeWeekEnds: function (obj) {
		var er_excweObj = Ext.getCmp('er_excwe');
		if (er_excweObj.getValue() == 'Yes') {
			Ext.getCmp('excludeDays').show();
			var excludeDaysObj=Ext.getCmp('excludeDays');
			excludeDaysObj.update('Excludes '+defaultJSON['excludeWeekends_value']);
		} else {
			Ext.getCmp('excludeDays').hide();
		}
	  //  if (!Ext.isEmpty(obj)) {
		   // this.formSubmit(obj);
	   // }
		Ext.getCmp('resultPanel').hide();
	}, */
	loadDafaultData : function(){
		var hiddenFields = defaultJSON.hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			//Ext.getCmp("submit").hide();
			//Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			//Ext.getCmp("submit").show();
			//Ext.getCmp("save").hide();
		} 
		appConstants.defaultJson=defaultJSON;
		this.getVirtualizationclusterform().loadFormData(defaultJSON,'default');
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(defaultJSON['screenLabels'].title);

		if(!hideBackButton){
			Ext.getCmp('virtualizationclusterform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: defaultJSON['ID']
				}
			);
		}
		if( (appConstants.isSubmit!=null && appConstants.isSubmit=="true") || appConstants.executeFavorite=="true")
		{
			this.showGraph();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showGraph();
			}
		}
		if(Ext.getCmp("er_type")!=null){
			if(Ext.getCmp("er_type").getValue()=='Yes'){
				Ext.getCmp("showLegend").show();
				if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
					Ext.getCmp('showLegend').setValue(true);
			}else
				Ext.getCmp("showLegend").hide();
		}
	},
	loadSettingsElements:function(){
			Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = defaultJSON.hiddenFields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
		//	Ext.getCmp('reportGeneration').setDisabled(true);
		}
		this.getVirtualizationclustersettings().loadSettingsData(defaultJSON['timelinepopupDetails']);
		var trendenablee = defaultJSON['hiddenFields'].trendenable;
	   if(trendenablee == 'false'){
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			var me=this;
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			ui:'settingsWindowContainer',
			//layout:'vbox',
			id:'configMod',
			//cls:'configMode_popup',
			
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'virtualizationclustersettings',
					parent:this
				}
			],
			renderTo:'virtualizationcluster-body',
			listeners:{
				render:	function(){
					Ext.EventManager.onWindowResize(function(){
						Ext.get('configMod').setStyle('left', '');
						});
					Ext.get('closeSettings').on('click',function(){
						me.validateAndCloseSettings();
					});
				}
			}
		});
	},
	validateAndCloseSettings:function()
	{
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		if ( reportgenVal == 'background' || reportgenVal == 'background-csv')
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				return ret;
			}
		}
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showGraph();
		}
	},
	timeLineOnChange:function(combo) {
		var form = Ext.getCmp('virtualizationclusterform').getForm();
		if (combo.getValue() == 'Any') {
			form.findField('er_enddate').setDisabled(false);
			form.findField('er_endhr').setDisabled(false);
			form.findField('er_sthr').setDisabled(false);
			form.findField('er_stdate').setDisabled(false);
		} else {
			form.findField('er_enddate').setDisabled(true);
			form.findField('er_endhr').setDisabled(true);
			form.findField('er_sthr').setDisabled(true);
			form.findField('er_stdate').setDisabled(true);

			var timeline = form.findField("er_timeline").getValue();
			var strtdt = form.findField("er_stdate").getValue();
			var enddt = form.findField("er_enddate").getValue();
			var strthour = form.findField("er_sthr").getValue();
			var endhr = form.findField("er_endhr").getValue();
			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);

			strtdt = Ext.Date.dateFormat(strtdt, appConstants.currdtFormat);
			enddt = Ext.Date.dateFormat(enddt, appConstants.currdtFormat);

			var hiddenFields = defaultJSON.hiddenFields;
			var msxdays = hiddenFields['getMaxDaysInMonth'];
			var inidate = hiddenFields['inidate'];
			var usertimeline = hiddenFields['er_usertimeline'];
			var er_reportgenration = form.findField('reportGeneration').getValue();
			var bgenabled = hiddenFields['bgenabled'];

			 if (bgenabled == 'Yes' || bgenabled == 'yes') {

					var limitforbg = hiddenFields['limitforbg'];

					var bgtime = getTimeValues(limitforbg, msxdays,strtdt, enddt,inidate);
					var getimeline = getTimeValues(timeline, msxdays,strtdt, enddt,inidate);
					var selectbackground = er_reportgenration;
					var bgprocess = false;

					if (getimeline >= bgtime && selectbackground == 'foreground') {

						 form.findField("bgReportName").show();
						 form.findField('reportGeneration').setValue('background');
					}
					else
					{
						form.findField("bgReportName").hide();
						 form.findField('reportGeneration').setValue('foreground');
					}
				}
		}
	},
	trendOnChange : function(combo){
		var er_trenddata;
		 var otherFiltersForm =null;
		if(isSettingsEnabled)
		  otherFiltersForm = this.getVirtualizationclustersettings().getForm();
		if (isSettingsEnabled)
		{
			er_trenddata =this.getSettingsFieldValue(otherFiltersForm,'er_trenddata',isSettingsEnabled,'showDataComboArray_value',false);
		}
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = defaultJSON.hiddenFields.inidate;
			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}
	},
	filterOnChange : function(combo){
		var val = combo.getValue();
		if(val=='Range')
		{
			Ext.getCmp('rangeLabel').show();
			Ext.getCmp('er_top').hide();
			Ext.getCmp('d_min').show();
			Ext.getCmp('d_max').show();
		}
		else if(val=='Greaterthan')
		{
			Ext.getCmp('rangeLabel').show();
			Ext.getCmp('er_top').hide();
			Ext.getCmp('d_min').show();
			Ext.getCmp('d_max').hide();
		}
		else if(val=='Lessthan')
		{
			Ext.getCmp('rangeLabel').show();
			Ext.getCmp('er_top').hide();
			Ext.getCmp('d_min').hide();
			Ext.getCmp('d_max').show();
		}
		else if(val=='Top-N')
		{
			Ext.getCmp('rangeLabel').hide();
			Ext.getCmp('er_top').show();
			Ext.getCmp('d_min').hide();
			Ext.getCmp('d_max').hide();
		}
	},
	reportGenChange:function(){

		this.hidePanel();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		Ext.getCmp('moreOptionCloseId').hide();
		Ext.getCmp('submitViaSetting').show();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(reportGenType== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	hidePanel:function()
	{
		Ext.getCmp('resultPanel').hide();
	},
	reporttypeOnChange : function(combo){
		this.hidePanel();
		var er_type = Ext.getCmp("er_type").getValue();
		if((appConstants.executeFavorite!=undefined && appConstants.executeFavorite=="true") || (appConstants.frmSchView!=undefined && appConstants.frmSchView=="Yes") || (fromFavoriteModify!=undefined && fromFavoriteModify=="Yes")||(appConstants.isSubmit!=null && appConstants.isSubmit=="true"))
		{
			appConstants.executeFavorite="false";
			appConstants.frmSchView="No";
			fromFavoriteModify="No";
			appConstants.isSubmit="false";
		}
		var mainForm = combo.up('.form').getForm();
		var val = combo.getValue();
		var er_component = mainForm.findField('er_component').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var graphtype =  mainForm.findField('graphtype').getValue();
		Ext.getCmp("graphtype").show();
		var param = 'userID='+appConstants.userID+'&erView=Hosts&sessionID='+appConstants.sessionID+'&er_type='+val;
		if(val=='Yes')
		{
			 Ext.getCmp('er_phyenable').hide();
			 Ext.getCmp('er_vmenable').hide();
			 Ext.getCmp('reportby').hide();
		}
		else
		{
			Ext.getCmp('er_phyenable').show();
			Ext.getCmp('er_vmenable').show();
			Ext.getCmp('reportby').show();
		}
		if(val=='No')
		{
			param +='&er_comptype='+er_comptype+'&er_component='+er_component;
			Ext.getCmp("showLegend").hide();
		}
	else
		Ext.getCmp("showLegend").show();
		var me = this;
		var hiddenFields = defaultJSON.hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if ((val!=undefined && val=='Yes') && (graphtype=='null'|| graphtype==null) && (er_report!=null && er_report!="Physical Servers"))
		{
			graphtype="Timeline";
		}
		if ((val!=undefined && val=='Yes') && (graphtype=='null'|| graphtype==null) && (er_report!=null && er_report=="Physical Servers"))
		{
			graphtype="Measures";
		}
		param += "&er_report="+er_report+"&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id+"&reportypeOnChange=true"+"&graphtype="+graphtype;
		Ext.Ajax.request({
		   url:'/final/servlet/com.eg.ErVirtualClusterViewResolver?er_type='+er_type,
		   params:param,
		   success:function(response)
		   {
			   var jsontext = response.responseText;
			   var jsonobject = Ext.decode(jsontext);
			   appConstants.repoGene = jsonobject;
			   defaultJSON = jsonobject;
			   appConstants.defaultJson=defaultJSON;
			   me.getVirtualizationclusterform().loadFormData(defaultJSON,'select');
			   if(val=='No')
			   {
					if(isSettingsEnabled)
					{
						Ext.getCmp('er_filter').hide();
						Ext.getCmp('er_top').hide();
						Ext.getCmp('filterbysplitterId').hide();
						Ext.getCmp('splitterId').hide();
						
					}
					var compList = jsonobject.vcentercomboarray;
			   }
			   else
			   {
					if(!isSettingsEnabled)
						me.showConfigDropdown();
					me.getVirtualizationclustersettings().loadSettingsData(defaultJSON['timelinepopupDetails']);
				}
				if(isSettingsEnabled)
				{
					var reportgenCombo = Ext.getCmp("reportGeneration");
					var repogenload = jsonobject.reportgenCombo;
					reportgenCombo.getStore().loadRawData(repogenload);
					reportgenCombo.setValue(jsonobject.reportgenCombo_value);
					me.reportGenChange();
				}
		   }
		});
	},
	reportForChange:function(thisObj)
	{
		var me=this;
		this.hidePanel();
		var value = thisObj.getValue();
		var thisValueForm = thisObj.up('.form').getForm();	 
		var er_compType = thisValueForm.findField('er_comptype').getValue();
		var er_type = thisValueForm.findField('er_type').getValue();
		var graphtype = thisValueForm.findField('graphtype').getValue();
		var er_component = thisValueForm.findField('er_component').getValue();
		var hiddenFields = defaultJSON.hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		var param = 'userID='+appConstants.userID+'&erView=Hosts&sessionID='+appConstants.sessionID+'&er_type='+er_type;

		if(er_type!=null && er_type == 'No')
		{
			er_report = thisValueForm.findField('er_report').getValue();
		}
		var comboValue = defaultJSON.viewbycombo_value;
		if(comboValue!=null && comboValue == 'Measures')
		{
			er_report = "Physical Servers";
		}
		param += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id+"&reportypeOnChange=true"+"&graphtype="+graphtype+"&er_component="+er_component+"&er_comptype="+er_compType+"&er_report="+er_report;
		if(er_type!=null && er_type == 'No')
		{
			param+="&er_report="+er_report;
		}
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.ErVirtualClusterViewResolver?er_type='+er_type,
			params:param,
			method:'POST',
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonObject = Ext.decode(jsonText);
				var defaultJson_temp = jsonObject;
				me.getVirtualizationclusterform().loadFormData(defaultJson_temp,'select');
			}
		});
	},
	virtualCenterOnChange : function(combo){
		this.hidePanel();
		var mainForm = combo.up('.form').getForm();
		var val = combo.getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_type = mainForm.findField('er_type').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_cluster = mainForm.findField('er_cluster').getValue();
		var allcomp="";
		if(er_type=='No')
		{
			if(val=="--All--")
			{
				Ext.getCmp('er_component').getStore().data.each(function(item, index, totalItems ) {
					if(item.data ['valueField']!='-1' && item.data ['valueField']!='--All--')
					{
						allcomp += item.data ['displayField'];
						allcomp +=",";
					}
				});
				allcomp = allcomp.substring(0,allcomp.length-1);
				allcomp = "&er_components="+allcomp+"&er_compname="+val;
			}
			else
			{
			   allcomp = "&er_compname="+val;
			}
		}
		else
		{
			allcomp = "&er_compname="+val;
		}
		var me=this;
		var param="er_type="+er_type+"&er_requesttype=cluster"+allcomp+"&er_comptype="+er_comptype+"&er_report="+er_report+"&reportfor=clusterreport";
		 var hiddenFields = defaultJSON.hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		param += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
		Ext.Ajax.request({
		url:'/final/servlet/com.eg.ErVirtualRemoteScriptControllerC',
		params:param,
		method:'POST',
		success:function(response)
		{
			var jsontext = response.responseText;
			var jsonobject = Ext.decode(jsontext);
			mainForm.findField('er_cluster').getStore().loadRawData(jsonobject);
			mainForm.findField('er_cluster').setValue(mainForm.findField('er_cluster').getStore().getAt(0));
		}
		});
	},
	clusterOnChange : function(combo){
		this.hidePanel();
		var mainForm = combo.up('.form').getForm();
		var val = combo.getValue();

		var er_component =  mainForm.findField('er_component').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_type = mainForm.findField('er_type').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_cluster = mainForm.findField('er_cluster').getValue();
		var er_requesttype = "";
		var allcomp="";
		if(er_type=='No')
		{
			er_requesttype = "resource";
			if(er_component=="--All--")
			{
				Ext.getCmp('er_component').getStore().data.each(function(item, index, totalItems ) {
				if(item.data ['valueField']!='-1' && item.data ['valueField']!='--All--')
				{
					allcomp += item.data ['displayField'];
					allcomp +=",";
				}
				});
				allcomp = allcomp.substring(0,allcomp.length-1);
				allcomp = "&er_components="+allcomp+"&er_compname="+er_component;
			}
			else
			{
				allcomp = "&er_compname="+er_component;
			}
		}
		else
		{
			//this.getVirtualizationclusterform().setNotApplicable(mainForm,'ermeasuretest');
			if (appConstants.s_erView=='Hosts')
			{
				er_requesttype="hostname";
			}
			else
			{
				 er_requesttype="reporttype";
			}
			allcomp = "&er_compname="+er_component;
		}

		var me=this;
		
		param="er_type="+er_type+"&er_requesttype="+er_requesttype+allcomp+"&er_comptype="+er_comptype+"&er_report="+er_report+"&reportfor=clusterreport&er_cluster="+val;
		Ext.Ajax.request({
		   url:'/final/servlet/com.eg.ErVirtualRemoteScriptControllerC',
		   params:param,
		   method:'POST',
		   success:function(response)
		   {
			   var jsontext = response.responseText;
			   var jsonobject = Ext.decode(jsontext);
			   if(er_type=='No')
				{
					mainForm.findField('er_resource').getStore().loadRawData(jsonobject);
					mainForm.findField('er_resource').setValue(mainForm.findField('er_resource').getStore().getAt(1));
				}
				else
				{
					if(appConstants.defaultJson!=undefined)
					{
						mainForm.findField('er_report').getStore().loadRawData(jsonobject);
						mainForm.findField('er_report').setValue(appConstants.defaultJson.reportbycombo_value);
					}
					if (appConstants.s_erView=='Hosts')
					{
						var er_host=Ext.getCmp('er_host');
						er_host.getStore().loadRawData(jsonobject);
						er_host.setValue(er_host.getStore().getAt(0));
						appConstants.rawDataForComponents =jsonobject;
					}
				}
		   }
		});
	},
	reportbyOnChange : function(combo){
		this.hidePanel();
		var mainForm = combo.up('.form').getForm();
		var val = combo.getValue();
		var er_component =  mainForm.findField('er_component').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_type = mainForm.findField('er_type').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_cluster = mainForm.findField('er_cluster').getValue();
		var er_requesttype="";
		if(er_type=='No')
		{
			return;
		}
		else
		{
			//this.getVirtualizationclusterform().setNotApplicable(mainForm,'ermeasuretest');
		}
		
		var me=this;
		var param="er_type="+er_type+"&er_requesttype=measure&er_compname="+er_component+"&er_comptype="+er_comptype+"&er_report="+val+"&reportfor=clusterreport&er_cluster="+er_cluster;
		Ext.Ajax.request({
		   url:'/final/servlet/com.eg.ErVirtualRemoteScriptControllerC',
		   params:param,
		   method:'POST',
		   success:function(response)
		   {
			   var jsontext = response.responseText;
			   var jsonobject = Ext.decode(jsontext);
			   mainForm.findField('ermeasuretest').getStore().loadRawData(jsonobject);
			   mainForm.findField('ermeasuretest').setValue(mainForm.findField('ermeasuretest').getStore().getAt(0));
		   }
		});
		
	},
	graphTypeOnChange : function(combo){
		this.hidePanel();
		var val = combo.getValue();		
		if(val=='Timeline' || val=='Distribution')
		{
			Ext.getCmp('physicalservers').hide();
			Ext.getCmp('ermeasuretest').hide();
			Ext.getCmp('er_report').hide();
			if(isSettingsEnabled)
			{
				Ext.getCmp('filterbysplitterId').show();
				Ext.getCmp('splitterId').show();
			}
		}
		else
		{
			Ext.getCmp('physicalservers').show();
			Ext.getCmp('ermeasuretest').hide();
			Ext.getCmp('er_report').hide();
			if(isSettingsEnabled)
			{
				Ext.getCmp('filterbysplitterId').hide();
				Ext.getCmp('splitterId').hide();
			}
		}
		if(isSettingsEnabled)
		{
			this.getVirtualizationclustersettings().loadSettingsData(defaultJSON['timelinepopupDetails']);
		}
	},
	 showGraph : function(thisObj){
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		this.hidePanel();
		var mainForm;
		if(thisObj!=undefined)
		{
			mainForm = thisObj.up('.form').getForm();
		}
		else
		{
			mainForm = Ext.getCmp('virtualizationclusterform').getForm();
		}

		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_component = mainForm.findField('er_component').getValue();
		var graphtype = mainForm.findField('graphtype').getValue();
		var er_cluster =  mainForm.findField('er_cluster').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_resource = mainForm.findField('er_resource').getValue();
		var ermeasuretest = mainForm.findField('ermeasuretest').getValue();
		var er_host =  Ext.getCmp('er_host').getValue();
		var erHostIsVisible =  Ext.getCmp('physicalservers').isVisible();

		
		var otherFiltersForm =null;
		if(isSettingsEnabled)
		  otherFiltersForm = this.getVirtualizationclustersettings().getForm();
		var time = mainForm.findField('er_timeline').getValue();
		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();
	/*
		var er_top = otherFiltersForm.findField('er_top').getValue();
		var execweekend = otherFiltersForm.findField('er_excwe').getValue();
		var er_filter = otherFiltersForm.findField('er_filter').getValue();
	*/
		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var er_top =this.getSettingsFieldValue(otherFiltersForm,'er_top',isSettingsEnabled,'filterbycombo1_value',false);
		var er_filter =this.getSettingsFieldValue(otherFiltersForm,'er_filter',isSettingsEnabled,'filterbycomb_value',false);
		if (er_cluster != null && er_cluster == '-1') {

				Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a Cluster' ,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
		}
		if (er_resource != null && er_resource == '-1') {

			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please choose a Resource Pool' ,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		if (erHostIsVisible && (er_host == null || er_host == '-1' || er_host == '')) {

			Ext.Msg.show({
						title : 'Alert',
						msg : 'Physical Server is Not Applicable' ,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_trenddata',isSettingsEnabled,'showDataComboArray_value',false);
		if(showData=='Yes')
		{
			isTrend=true;
		}

		var hiddenFields = defaultJSON.hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";
		}
		var allcomp='';
		if(er_component=="--All--")
		{
				Ext.getCmp('er_component').getStore().data.each(function(item, index, totalItems ) {
					if(item.data ['valueField']!='-1' && item.data ['valueField']!='--All--')
					{
						allcomp += item.data ['displayField'];
						allcomp +=",";
					}
				});
				allcomp = allcomp.substring(0,allcomp.length-1);
				param += '&er_components='+allcomp;
		}
		if(er_host!=null && er_host!=undefined)
		{
			for(var h in er_host)
			{
				param+='&er_host='+er_host[h];
			}
		}
		param+='&er_type='+er_type+'&er_comptype='+er_comptype;
		param+='&er_component='+er_component+'&graphtype='+graphtype+'&er_cluster='+er_cluster+'&er_report='+er_report;
		param+='&er_resource='+er_resource;
		if(er_type=='Yes')
		{
			if(appConstants.s_erView!=undefined && appConstants.s_erView!='Hosts'  && graphtype!='Measures')
			{
			   param+='&ermeasuretest='+ermeasuretest+'&er_measure='+ermeasuretest;
			}
			else if(appConstants.s_erView!=undefined && appConstants.s_erView =='Hosts' && graphtype!='Measures')
			{
				param+='&ermeasuretest='+ermeasuretest+'&er_measure='+ermeasuretest;
			}
		}
		else
		{
			param+='&ermeasuretest=null&er_measure=null';
			var er_phyenable = Ext.getCmp('er_phyenable').getValue();
			var er_vmenable = Ext.getCmp('er_vmenable').getValue();

			if(er_phyenable)
			{
				param+='&er_phyenable=Yes';
			}
			else
			{
				param+='&er_phyenable=No';
			}
			if(er_vmenable)
			{
				param+='&er_vmenable=Yes';
			}
			else
			{
				param+='&er_vmenable=No';
			}
		}
		param += "&starthr="+starthr+"&enddate="+enddate+"&endhr="+endhr+'&startdate='+startdate+'&er_timeline='+er_timeline
				+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;

		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var er_mode = mainForm.findField('er_mode').getValue();

		param +='&beanstartdate='+beanstartdate+'&beanenddate='+beanenddate+'&timelineval='+er_timeline;

		param +='&er_excwe='+execweekend+'&schedule_id=';

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Hourto',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Minfrom',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);

		param += '&timefrom=' + timefrom
				+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='
				+ minto+'&er_trenddata='+showData
		if(er_type=='Yes')
		{
			param+='&er_mode='+er_mode;
			if(er_filter=='Range'){
				var d_min =this.getSettingsFieldValue(otherFiltersForm,'d_min',true,'showDataComboArray_value',false);
				var d_max =this.getSettingsFieldValue(otherFiltersForm,'d_max',true,'showDataComboArray_value',false);
				param+='&d_min='+d_min+'&d_max='+d_max;
			}
			else if(er_filter=='Lessthan'){
				var d_max =this.getSettingsFieldValue(otherFiltersForm,'d_max',true,'showDataComboArray_value',false);
				param+='&d_min=0'+'&d_max='+d_max;
			}
			else if(er_filter=='Greaterthan'){
				var d_min =this.getSettingsFieldValue(otherFiltersForm,'d_min',true,'showDataComboArray_value',false);
				param+='&d_min='+d_min+'&d_max=0';
			}
			if(appConstants.s_erView!=undefined && appConstants.s_erView!='Hosts' )
			{
				param+='&er_top='+er_top+'&er_filter='+er_filter;
			}
			else if(appConstants.s_erView!=undefined && appConstants.s_erView =='Hosts' && graphtype!='Measures')
			{
				param+='&er_top='+er_top+'&er_filter='+er_filter;
			}
		}
		param+='&erView='+appConstants.s_erView+'&selectedCompType='+er_comptype+'&reqcluster=Yes';
		param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID+"&isSubmit=true";
		param+="&showLegend="+ mainForm.findField('showLegend').getValue();
		if (starthr=='undefined' || starthr==null || endhr=='undefined'|| endhr==null) {
			starthr=appConstants.dstartdate;
			endhr=appConstants.denddate;
			starttime=appConstants.dstartdate;
			endtime=appConstants.denddate;
		}
		var stDateTime = Ext.getCmp('er_stdate').getValue();
		var tmpStartHour = Ext.getCmp('er_sthr').getValue();
		stDateTime.setHours(tmpStartHour);
		var enDateTime = Ext.getCmp('er_enddate').getValue();
		var tmpEndHour = Ext.getCmp('er_endhr').getValue();
		enDateTime.setHours(tmpEndHour);
		var bool = checkDateTime(stDateTime, enDateTime);
		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var er_reportgenration =this.getSettingsFieldValue(otherFiltersForm,'reportGeneration',isSettingsEnabled,'reportgenCombo_value',false);
		var bgenabled = hiddenFields['bgenabled'];
		if (bool) {
			if (bgenabled == 'Yes' || bgenabled == 'yes') {

				var limitforbg = hiddenFields['limitforbg'];
				var bgtime = getTimeValues(limitforbg, msxdays,startdate, enddate,inidate);
				var getimeline = getTimeValues(er_timeline, msxdays,startdate, enddate,inidate);
				var selectbackground = er_reportgenration;
				var bgprocess = false;
				if (getimeline >bgtime && selectbackground == 'foreground') {
					if (appConstants.confirmationValidation != null && (appConstants.confirmationValidation == "True" || appConstants.confirmationValidation == "Yes")) {
					 Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn)
					{
						 if(btn=='no'){
						if(!isSettingsEnabled)
							this.showConfigDropdown();
						if(isSettingsEnabled)
							otherFiltersForm = this.getVirtualizationclustersettings().getForm();
							 otherFiltersForm.findField("bgReportName").show();
							 otherFiltersForm.findField('reportGeneration').setValue('background');
							 bgprocess=false;
						} else{
						var timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
							param += '&er_reportgenration='+selectbackground;
								var url=  "../servlet/com.eg.ErVirtualClusterReportC?isSubmit=true";
								this.submitReport(url,param,er_type,er_reportgenration);
							}
						}
					},this);
					}
				}
			else if (selectbackground == 'background' && bgprocess==false) {

					var bg_reportname = otherFiltersForm.findField('bgReportName').getValue();
						bg_reportname=checkFileName(bg_reportname);
					param += '&bg_reportname=' + bg_reportname+'&er_reportgenration='+selectbackground;
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(mainForm,mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
								var url= '/final/servlet/com.eg.ErStartBackGroundReportC';
								this.submitReport(url,param,er_type,er_reportgenration);
						} else
							return;
					}
				}
				else if (selectbackground == 'background-csv' && bgprocess==false) {

					var bg_reportname = otherFiltersForm.findField('bgReportName').getValue();
						bg_reportname=checkFileName(bg_reportname);
					param += '&bg_reportname=' + bg_reportname+'&er_reportgenration='+selectbackground;
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(mainForm,mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
								var url= "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
								this.submitReport(url,param,er_type,er_reportgenration);
						} else
							return;
					}
				} 
				else if(!bgprocess){
						var old_width = 0;
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
							param += '&er_reportgenration='+selectbackground;
							var url= "../servlet/com.eg.ErVirtualClusterReportC?isSubmit=true";
							this.submitReport(url,param,er_type,er_reportgenration);
						} else
							return;
				}else {
						var old_width = 0;
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
							param += '&er_reportgenration='+selectbackground;
							var url= "../servlet/com.eg.ErVirtualClusterReportC?isSubmit=true";
							this.submitReport(url,param,er_type,er_reportgenration);
						} else
							return;
				}
			} else {
					var val = false;
					var timeVal = true;
					timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
					if (timeVal) {
						param += '&er_reportgenration='+selectbackground;
							var url=  "../servlet/com.eg.ErVirtualClusterReportC?isSubmit=true";
							this.submitReport(url,param,er_type,er_reportgenration);
					} else
						return;
			}
		} else {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
	},
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_host'),Ext.getCmp('physicalserverlbl').text,btn);
	},
	submitReport:function(url,param,er_type,er_reportgenration){
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var myMask=null;
		myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		//by karthikeyan
	param+= '&er_RmDispName='+appConstants.er_RmDispName;
			var me = this;
			Ext.Ajax.request(
			{
				url : url,
				params : param,
				success: function(response){
					var jsonText = response.responseText;
					var htmlStr = '';
					 var jsonData=Ext.decode(jsonText);
					 //grpahQueryString.queryString
					if(er_reportgenration=='background'||er_reportgenration=='background-csv')
					{
							var grpahQueryString = jsonData.grpahQueryString;
							var queryMessage = grpahQueryString.bgstr2;
							var status = grpahQueryString.status;

								if(status!=undefined && status =='success'){
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>' + grpahQueryString.bgstr1+ '</b>.</br>' + '<a  class="backgroundMsgLink" href='+ grpahQueryString.queryString + '>' + grpahQueryString.queryString+ '</a> </div></div></center>';
						
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ queryMessage + '</a></div></td></tr></table></td></tr></table>';
						}
								else{
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>' + grpahQueryString.bgstr1+ '</b>.</br>' + '<a class="backgroundMsgLink" href='+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2+ '</a> </div></div></center>';
						
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
								}
						me.getBackGroundPanel().update(htmlStr);
						me.getBackGroundPanel().show();
						Ext.getCmp('graphpanel').hide();
						Ext.getCmp('datapanel').hide();
						Ext.getCmp('resultPanel').hide();
						myMask.hide();
						return;
					}
					else  if(er_type=='Yes')
					{
						 Ext.getCmp('graphpanel').show();
						 Ext.getCmp('datapanel').hide();
						 Ext.getCmp('backGroundPanel').hide();
						// me.getBackGroundPanel().show();
						 //me.getBackGroundPanel().hide();
						 Ext.getCmp('gridpanel').hide();
						 var graphtype = jsonData['graphtype']; 
						 var url = '../servlet/com.eg.ErVirtualClusterReportC?isSubmit=true&'+param;
						 url+='&pdfPrint=Yes';

						 if(graphtype=='Timeline')
						 {
							chartypeString = jsonData['chartType'];
							url+='&vcGraph=Yes';
							Ext.getCmp('graphpanel').loadGraphPanel(url,graphtype,jsonData);
						 }
						 else if(graphtype=='Measures')
						 {
							chartypeString = jsonData['chartType'];
							Ext.getCmp('graphpanel').loadGraphPanel(url,graphtype,jsonData);
						 }
						 else
						 {
							Ext.getCmp('graphpanel').loadGraphPanel(url,graphtype,jsonData);
						 }

						 if(graphtype=='Timeline' || graphtype=='Measures')
						 {
							 Ext.getCmp('resultPanel').show();
						 }
						 else
						 {
							Ext.getCmp('resultPanel').hide();                    	
						 }
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
						Ext.getCmp('virtualizationcluster').doLayout();
						Ext.getCmp("csvTool").setDisabled(true);
					}
					else{
						me.getBackGroundPanel().hide();
						Ext.getCmp('graphpanel').hide();
						Ext.getCmp('datapanel').show();
						Ext.getCmp('resultPanel').show();
						Ext.getCmp('datapanel').loadDataPanel(jsonData['griddata']);
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					}
					myMask.hide();
				}
			});
	},
	saveReportAsPDF:function(){

		var mainForm = Ext.getCmp('virtualizationclusterform').getForm();
		var otherFiltersForm =null;
		if(isSettingsEnabled)
		otherFiltersForm = this.getVirtualizationclustersettings().getForm();
		
		var starttime = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var endtime = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();
		 //starttime = Ext.Date.dateFormat(starttime, mgrDateFormat);
		// endtime = Ext.Date.dateFormat(endtime, mgrDateFormat);

		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var er_top =this.getSettingsFieldValue(otherFiltersForm,'er_top',isSettingsEnabled,'filterbycombo1_value',false);
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_trenddata',isSettingsEnabled,'showDataComboArray_value',false);

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Hourto',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Minfrom',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);


		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_component = mainForm.findField('er_component').getValue();
		var graphtype = mainForm.findField('graphtype').getValue();
		var er_cluster =  mainForm.findField('er_cluster').getValue();
		var er_report = mainForm.findField('er_report').getValue();

		var er_resource = mainForm.findField('er_resource').getValue();
		var ermeasuretest = mainForm.findField('ermeasuretest').getValue();
		var er_host =  Ext.getCmp('er_host').getValue();
		if(er_host==undefined)
		er_host = null;
		var er_vmenable=null;

		if(er_report=='Virtual Machines')
		{
			er_vmenable='Yes';
		}
		var er_phyenable=null;
		if(er_report=='Physical Servers')
		{
			er_phyenable='Yes';
		}
		
	   /* startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
		enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);
		var starttime = formatDate(new Date(getDateFromFormat(starttime,appConstants.currdtFormat)),"dd-MM-yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(endtime,appConstants.currdtFormat)),"dd-MM-yyyy");
	*/

		var hiddenFields = defaultJSON.hiddenFields;
		var  s_qryString = "../reporter/ErHtmlToSavePdf.jsp?selectedCompType="+er_comptype+"&select_groupName="+er_component+"&selectedGroup=Component&startdate="+starttime+"&endate="+endtime+"&Hourfrom="+timefrom+"&Minfrom="+minfrom+"&Hourto="+timeto+"&Minto="+minto+"&starthr="+starthr+"&endhr="+endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&ervm_type=vc_cluster&ermeasuretest="+ermeasuretest+"&er_timeline="+er_timeline+"&er_cluster="+er_cluster+"&er_phyenable="+er_phyenable+"&er_vmenable="+er_vmenable+"&er_type="+er_type+"&graphtype="+graphtype+"&er_component="+er_component+"&er_resource="+er_resource+"&er_host="+er_host+"&pageWidthProces="+appConstants.pageWidth+"&"+"&er_trenddata="+showData;
		
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var mainForm = Ext.getCmp('virtualizationclusterform').getForm();
		var otherFiltersForm =null;
		if(isSettingsEnabled)
		otherFiltersForm = this.getVirtualizationclustersettings().getForm();
		var starttime = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var endtime = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();
		 //starttime = Ext.Date.dateFormat(starttime, mgrDateFormat);
		// endtime = Ext.Date.dateFormat(endtime, mgrDateFormat);
		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var er_top =this.getSettingsFieldValue(otherFiltersForm,'er_top',isSettingsEnabled,'filterbycombo1_value',false);
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_trenddata',isSettingsEnabled,'showDataComboArray_value',false);
		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Hourto',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Minfrom',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);
		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_component = mainForm.findField('er_component').getValue();
		var graphtype = mainForm.findField('graphtype').getValue();
		var er_cluster =  mainForm.findField('er_cluster').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_resource = mainForm.findField('er_resource').getValue();
		var ermeasuretest = mainForm.findField('ermeasuretest').getValue();
		var er_host =  Ext.getCmp('er_host').getValue();
		if(er_host==undefined)
		er_host = null;
		var er_vmenable=null;
		if(er_report=='Virtual Machines')
		{
			er_vmenable='Yes';
		}
		var er_phyenable=null;
		if(er_report=='Physical Servers')
		{
			er_phyenable='Yes';
		}
		var hiddenFields = defaultJSON.hiddenFields;
		var  s_qryString = "selectedCompType="+er_comptype+"&select_groupName="+er_component+"&selectedGroup=Component&startdate="+starttime+"&endate="+endtime+"&Hourfrom="+timefrom+"&Minfrom="+minfrom+"&Hourto="+timeto+"&Minto="+minto+"&starthr="+starthr+"&endhr="+endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&ervm_type=vc_cluster&ermeasuretest="+ermeasuretest+"&er_timeline="+er_timeline+"&er_cluster="+er_cluster+"&er_phyenable="+er_phyenable+"&er_vmenable="+er_vmenable+"&er_type="+er_type+"&graphtype="+graphtype+"&er_component="+er_component+"&er_resource="+er_resource+"&er_host="+er_host+"&pageWidthProces="+appConstants.pageWidth+"&"+"&er_trenddata="+showData;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var mainForm = Ext.getCmp('virtualizationclusterform').getForm();
		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_component = mainForm.findField('er_component').getValue();
		var graphtype = mainForm.findField('graphtype').getValue();
		var er_cluster =  mainForm.findField('er_cluster').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_resource = mainForm.findField('er_resource').getValue();
		var ermeasuretest = mainForm.findField('ermeasuretest').getValue();
		var er_host = Ext.getCmp('er_host').getValue();
		var otherFiltersForm =null;

		if(isSettingsEnabled)
			otherFiltersForm = this.getVirtualizationclustersettings().getForm();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_mode = mainForm.findField('er_mode').getValue();
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var er_top =this.getSettingsFieldValue(otherFiltersForm,'er_top',isSettingsEnabled,'filterbycombo1_value',false);

		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_trenddata',isSettingsEnabled,'showDataComboArray_value',false);

		var hiddenFields = defaultJSON.hiddenFields;
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			bookletquery += hiddenField + "=" + val;
			bookletquery += "&";
		}
		var allcomp='';
		if(er_component=="--All--")
		{
				Ext.getCmp('er_component').getStore().data.each(function(item, index, totalItems ) {
					if(item.data ['valueField']!='-1' && item.data ['valueField']!='--All--')
					{
						allcomp += item.data ['displayField'];
						allcomp +=",";
					}
				});
				allcomp = allcomp.substring(0,allcomp.length-1);
				bookletquery += '&er_components='+allcomp;
		}
		if(er_host!=null && er_host!=undefined)
		{
			for(var h in er_host)
			{
				bookletquery+='&er_host='+er_host[h];
			}
		}
		bookletquery+='&er_type='+er_type+'&er_comptype='+er_comptype;
		bookletquery+='&er_component='+er_component+'&graphtype='+graphtype+'&er_cluster='+encodeURIComponent(er_cluster)+'&er_report='+er_report;
		bookletquery+='&er_resource='+encodeURIComponent(er_resource)+'&ermeasuretest='+ermeasuretest+'&er_measure='+ermeasuretest;

		bookletquery += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="
				+ endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var er_mode = mainForm.findField('er_mode').getValue();

		bookletquery +='&beanstartdate='+beanstartdate+'&beanenddate='+beanenddate;

		bookletquery +='&er_excwe='+execweekend+'&schedule_id=';

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Hourto',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Minfrom',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);

		bookletquery += '&timefrom=' + timefrom+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='+ minto+'&er_trenddata='+showData
			+'&er_mode='+er_mode;

		bookletquery+='&er_top='+er_top;

		bookletquery+='&erView='+appConstants.s_erView+'&selectedCompType='+er_comptype+'&reqcluster=Yes';

		bookletquery+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID;

	  var er_reportgenration =this.getSettingsFieldValue(otherFiltersForm,'reportGeneration',isSettingsEnabled,'reportgenCombo_value',false);
	   bookletquery+='&er_reportgenration='+er_reportgenration;
			var er_phyenable = Ext.getCmp('er_phyenable').getValue();
			var er_vmenable = Ext.getCmp('er_vmenable').getValue();
			if(er_phyenable)
			{
				bookletquery+='&er_phyenable=Yes';
			}
			else
			{
				bookletquery+='&er_phyenable=No';
			}
			if(er_vmenable)
			{
				bookletquery+='&er_vmenable=Yes';
			}
			else
			{
				bookletquery+='&er_vmenable=No';
			}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){

	var mainForm = Ext.getCmp('virtualizationclusterform').getForm();
		var otherFiltersForm =null;
	if(isSettingsEnabled)
			otherFiltersForm = this.getVirtualizationclustersettings().getForm();


		var starttime = mainForm.findField('er_stdate').dataArray;
	
		var starthr = mainForm.findField('er_sthr').dataArray;
		var endtime = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();
		//starttime = Ext.Date.dateFormat(starttime, mgrDateFormat);
		//endtime = Ext.Date.dateFormat(endtime, mgrDateFormat);

		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var er_top =this.getSettingsFieldValue(otherFiltersForm,'er_top',isSettingsEnabled,'filterbycombo1_value',false);
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_trenddata',isSettingsEnabled,'showDataComboArray_value',false);

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Hourto',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Minfrom',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);

		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_component = mainForm.findField('er_component').getValue();
		var graphtype = mainForm.findField('graphtype').getValue();
		var er_cluster =  mainForm.findField('er_cluster').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_resource = mainForm.findField('er_resource').getValue();
		var ermeasuretest = mainForm.findField('ermeasuretest').getValue();
		var er_host =  Ext.getCmp('er_host').getValue();
		if(er_host==undefined)
		er_host = null;
		var er_vmenable=null;
		
		if(er_report=='Virtual Machines')
		{
			er_vmenable='Yes';
		}
		var er_vmenable=null;
		if(er_report=='Resource Pools')
		{
			er_vmenable='Yes';
		}
		var er_phyenable=null;
		if(er_report=='Physical Servers')
		{
			er_phyenable='Yes';
		}
		else
		{
			er_vmenable='Yes';
		}

		var hiddenFields = defaultJSON.hiddenFields;
		var host,selectedGroup;
		if(er_type=="Yes")
		{
			host=+"&er_host="+er_host;
		}
		else
		{
			host="&er_host=null";
			graphtype = null;
			ermeasuretest = null;
			selectedGroup="Component";
		}
		var  s_qryString = "/final/reporter/ErVMPrintData.jsp?selectedCompType="+er_comptype+"&select_groupName="+er_component+"&selectedGroup=Component"+"&startdate="+starttime+"&endate="+endtime+"&Hourfrom="+timefrom+"&Minfrom="+minfrom+"&Hourto="+timeto+"&Minto="+minto+"&starthr="+starthr+"&endhr="+endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&ervm_type=vc_cluster&ermeasuretest="+ermeasuretest+"&er_timeline="+er_timeline+"&er_cluster="+er_cluster+"&er_phyenable="+er_phyenable+"&er_vmenable="+er_vmenable+"&er_type="+er_type+"&graphtype="+graphtype+"&er_component="+er_component+"&er_resource="+er_resource+host+"&pdfPrint=yes"+"&er_trenddata="+showData;

			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(s_qryString.indexOf(setLegendVal)==-1){
					if(s_qryString.indexOf("&showLegend=")>-1){
						if(islegendEnabled =='true'){
							s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
						}else{
							s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
						}
					}else
						s_qryString+=setLegendVal;
				}
			}
			parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	add : function(button){
				// by karthikeyan
		/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
			title : 'Virtualization Reports',
			msg : 'Choosen timeline not allowed',
			buttons : Ext.Msg.OK,
			icon: Ext.MessageBox.WARNING
			});
			return;
		} */
		var mainForm;
		mainForm = Ext.getCmp('virtualizationclusterform').getForm();
		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_component = mainForm.findField('er_component').getValue();
		var graphtype = mainForm.findField('graphtype').getValue();
		var er_cluster =  mainForm.findField('er_cluster').getValue();
		var er_report = mainForm.findField('er_report').getValue();
		var er_resource = mainForm.findField('er_resource').getValue();
		var ermeasuretest = mainForm.findField('ermeasuretest').getValue();
		var er_host = Ext.getCmp('er_host').getValue();
		var otherFiltersForm =null;

		if(isSettingsEnabled)
			otherFiltersForm = this.getVirtualizationclustersettings().getForm();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_mode = mainForm.findField('er_mode').getValue();
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var er_top =this.getSettingsFieldValue(otherFiltersForm,'er_top',isSettingsEnabled,'filterbycombo1_value',false);

		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_trenddata',isSettingsEnabled,'showDataComboArray_value',false);

		var hiddenFields = defaultJSON.hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";
		}
		var allcomp='';
		if(er_component=="--All--")
		{
				Ext.getCmp('er_component').getStore().data.each(function(item, index, totalItems ) {
					if(item.data ['valueField']!='-1' && item.data ['valueField']!='--All--')
					{
						allcomp += item.data ['displayField'];
						allcomp +=",";
					}
				});
				allcomp = allcomp.substring(0,allcomp.length-1);
				param += '&er_components='+allcomp;
		}
		if(er_host!=null && er_host!=undefined)
		{
			for(var h in er_host)
			{
				param+='&er_host='+er_host[h];
			}
		}
		param+='&er_type='+er_type+'&er_comptype='+er_comptype;
		param+='&er_component='+er_component+'&graphtype='+graphtype+'&er_cluster='+encodeURIComponent(er_cluster)+'&er_report='+er_report;
		param+='&er_resource='+encodeURIComponent(er_resource)+'&ermeasuretest='+ermeasuretest+'&er_measure='+ermeasuretest;

		param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="
				+ endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var er_mode = mainForm.findField('er_mode').getValue();

		param +='&beanstartdate='+beanstartdate+'&beanenddate='+beanenddate;

		param +='&er_excwe='+execweekend+'&schedule_id=';

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Hourto',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Minfrom',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);

		param += '&timefrom=' + timefrom+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='+ minto+'&er_trenddata='+showData
			+'&er_mode='+er_mode;

		param+='&er_top='+er_top;

		param+='&erView='+appConstants.s_erView+'&selectedCompType='+er_comptype+'&reqcluster=Yes';

		param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID;

	  var er_reportgenration =this.getSettingsFieldValue(otherFiltersForm,'reportGeneration',isSettingsEnabled,'reportgenCombo_value',false);
	   param+='&er_reportgenration='+er_reportgenration;
	   //
			var er_phyenable = Ext.getCmp('er_phyenable').getValue();
			var er_vmenable = Ext.getCmp('er_vmenable').getValue();
			if(er_phyenable)
			{
				param+='&er_phyenable=Yes';
			}
			else
			{
				param+='&er_phyenable=No';
			}
			if(er_vmenable)
			{
				param+='&er_vmenable=Yes';
			}
			else
			{
				param+='&er_vmenable=No';
			}
	   //

	var from_schedule = hiddenFields['fromScheduleModify'];
		var target = "";
		var windowClass;
		var frameId;
		if (button.getId() == "scheduleImg" || button.getItemId() == "save" && (from_schedule != null && from_schedule == "Yes"))
		{
			target = "/final/reporter/ErSaveSchedule.jsp?" + param + "&com.eg.CSRF_NONCE="+csrfToken;
			//windowClass='scheduleWindow';
			//frameId='#schWin';
			if (button.getItemId() == "save")
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			} else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else {
				hiddenFields =  defaultJSON.hiddenFields;
				var favorite_id = hiddenFields["favorite_id"];
				target = "../servlet/com.eg.ErFavoriteC?cmd=client&er_view=GRAPH&" + param+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+"&FavoriteId="+favorite_id;
				// windowClass='favouriteWindow';
				//frameId='#favWin';
				if (button.getItemId() == "save")
				{
					//document.location=url+'&showSchWindow=no'+'&FavoriteId='+favorite_id;
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				} else
					parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	navigate : function(href){
		href = href+'&fromgrid=true';
		var myMask=null;
		myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		var me =this;
		Ext.Ajax.request(
		 {
				url : '../servlet/com.eg.ErVirtualClusterReportC',
				params : decodeURI(href),
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					
					Ext.getCmp('gridpanel').loadDataPanel(jsonData['griddata']);
					appConstants.defaultJson=jsonData['deaultJSON'];
					me.getVirtualizationclusterform().loadFormData(jsonData['deaultJSON'],'select');
					Ext.getCmp('datapanel').hide();
					myMask.hide();
		  }
	  });
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam,isTimePeriod)
	{
		var value='';
		var settingsJson =defaultJSON.timelinepopupDetails;
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(isTimePeriod)
				value = settingsJson.timePeriod[jsonParam];
			else{
				if(jsonParam.indexOf('filterby')==0){
					if(settingsJson.FilterByComboObject!=undefined)
						value = settingsJson.FilterByComboObject[jsonParam];
				}else
					value = settingsJson[jsonParam];
			}
		}
		return value;
	}
	});