// JavaScript Document

Ext.define('virtualizationclusterreports.view.VirtualizationClusterForm',{
	extend:'Ext.form.Panel',
	alias:'widget.virtualizationclusterform',
	id:'virtualizationclusterform',
	screenLabels:null,
	layout: 'column',
	defaults:{
		labelAlign:'top',
		margin: '0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 90,
				editable : false,
				fieldLabel:'Report type',
				name: 'er_type',
				id: 'er_type',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : [
					{
						'displayField':'zone1',
						'valueField':'zone1'
					}]
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local'
			},{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 100,
				editable : false,
				id: 'graphtype',
				name: 'graphtype',
				fieldLabel:'View by',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 150,
				editable : false,
				id: 'er_comptype',
				name: 'er_comptype',
				fieldLabel:'Report for',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 200,
				editable : false,
				id: 'er_component',
				name: 'er_component',
				fieldLabel:'vCenter Server',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 200,
				editable : false,
				id: 'er_cluster',
				name: 'er_cluster',
				fieldLabel:'Cluster',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 200,
				editable : false,
				id: 'er_report',
				name: 'er_report',
				fieldLabel:'Reported By',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'container',
				id:'reportby',
				name:'reportby',
				margin: '0 20 10 0',
				hidden:true,
  				items:[
						{
							xtype: 'checkboxgroup',
							labelSeparator:'',
							fieldLabel: 'Reported By',
							labelAlign:'top',
 							columns: 2,
							defaults:{
								cls: 'checkbt',
								width:130,
								margin:0
							},
							items: [{
								boxLabel: physicalServersLabel,
								name: 'er_phyenable',
								id:'er_phyenable',
								inputValue: '1'
							}, {
								boxLabel: virtualMachineLabel,
								name: 'er_vmenable',
								id:'er_vmenable',
								inputValue: '2'
							}]
						}
				]
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 200,
				editable : false,
				id: 'er_resource',
				name: 'er_resource',
				fieldLabel:resrcPoolLabel,
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 200,
				editable : true,
				id: 'ermeasuretest',
				name: 'ermeasuretest',
				fieldLabel:'Measure',
				listConfig:{
							emptyText:noMeasureMatch
						},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{xtype:'timeline',margin:'0 10 10 0'},
			{
				xtype:'checkbox',
				cls: 'checkbt',
				margin:'22 20 15 0',
				boxLabel: showLegends,
				inputValue: 'true',
				id: 'showLegend'
			 },
			{
				xtype:'button',
				text: submitValue,
				ui: 'newButtonSmall',
				itemId: 'submit',
				name: 'submit',
				margin:'20 0 0 0'
			},
			{
				xtype:'button',
				text: "Save",
				ui: "newButtonSmall",
				itemId: "save",
				name: "save",
				margin: "20 0 0 0"
			},
		],
	loadFormData : function(jsonObject,from) {

            var thisForm = this.getForm();
            var er_type = jsonObject.reporttype_value;
            if(er_type!=undefined && er_type!='No')
            {
                this.screenLabels = jsonObject['screenLabels'];
                this.loadScreenLabels(this.screenLabels);
            }
			var from_schedule = jsonObject['hiddenFields']['fromScheduleModify'];
			var fromFavoriteModify = jsonObject['hiddenFields']["fromFavoriteModify"];
			var reportypeOnChange = jsonObject['hiddenFields']["reportypeOnChange"];
			/*if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
				Ext.getCmp("submit").hide();
				Ext.getCmp("save").show();
			}else{
				Ext.getCmp("submit").show();
				Ext.getCmp("save").hide();
			}*/
			
            if( (appConstants.isSubmit!=null && appConstants.isSubmit=="true" && from!='select') || appConstants.executeFavorite=="true" || (appConstants.frmSchView!=null && appConstants.frmSchView=="Yes") || (fromFavoriteModify=="Yes" && reportypeOnChange != "true"))
			{
				er_type = appConstants.er_type1;
				this.setComboOptionsInList(thisForm, 'er_type', jsonObject.reporttypecombo, er_type);
			}
			else
			{
				this.setComboOptionsInList(thisForm, 'er_type', jsonObject.reporttypecombo, jsonObject.reporttype_value);
			}
            if(er_type!=undefined && er_type!='No')
            {
            	if( (appConstants.isSubmit!=null && appConstants.isSubmit=="true" && from!='select') || appConstants.executeFavorite=="true" || (appConstants.frmSchView!=null && appConstants.frmSchView=="Yes") || (fromFavoriteModify=="Yes" && reportypeOnChange != "true"))
				{
					this.setComboOptionsInList(thisForm, 'graphtype', jsonObject.viewbycomboarray, appConstants.graphtype1);
					this.setComboOptionsInList(thisForm, 'ermeasuretest', jsonObject.viewbycomboarray, jsonObject.viewbycombo_value);
				}
				else
				{
					this.setComboOptionsInList(thisForm, 'graphtype', jsonObject.viewbycomboarray, jsonObject.viewbycombo_value);
					this.setComboOptionsInList(thisForm, 'ermeasuretest', jsonObject.viewbycomboarray, jsonObject.viewbycombo_value);
				}
			}
			else
			{
				thisForm.findField('graphtype').hide();
			}

		   if( (appConstants.isSubmit!=null && appConstants.isSubmit=="true" && from!='select') || appConstants.executeFavorite=="true" || (appConstants.frmSchView!=null && appConstants.frmSchView=="Yes") || (fromFavoriteModify=="Yes" && reportypeOnChange != "true"))
		   {
               this.setComboOptionsInList(thisForm, 'er_comptype', jsonObject.reportforcomboarray, appConstants.er_comptype1);
               this.setComboOptionsInList(thisForm, 'er_component', jsonObject.vcentercomboarray, appConstants.er_component1);	
			   if(appConstants.er_cluster1 == '--All--' || appConstants.er_cluster1 =='')
			   {
					appConstants.er_cluster1 = (jsonObject.clustercomboarray[jsonObject.clustercomboarray.length-1]).valueField;
			   }
			   this.setComboOptionsInList(thisForm, 'er_cluster', jsonObject.clustercomboarray, appConstants.er_cluster1);
			}
			else
			{
			   this.setComboOptionsInList(thisForm, 'er_comptype', jsonObject.reportforcomboarray, jsonObject.reportformcobo_value);
               this.setComboOptionsInList(thisForm, 'er_component', jsonObject.vcentercomboarray, jsonObject.vcentercombo_value);
               this.setComboOptionsInList(thisForm, 'er_cluster', jsonObject.clustercomboarray, jsonObject.clustercombo_value);
			}

			Ext.getCmp('physicalservers').hide();
            if(appConstants.s_erView!=undefined && appConstants.s_erView=='Hosts' && er_type!=undefined && er_type!='No')
            {
            	Ext.getCmp('physicalservers').show();
            	Ext.getCmp('showLegend').show();
            	thisForm.findField('ermeasuretest').hide();
            	thisForm.findField('er_report').hide();
            	thisForm.findField('er_resource').hide();
            	Ext.getCmp('er_host').getStore().loadRawData(jsonObject.physicalserverscomboarray);
				appConstants.rawDataForComponents = jsonObject.physicalserverscomboarray;

				if( (appConstants.isSubmit!=null && appConstants.isSubmit=="true" && from!='select')|| appConstants.executeFavorite=="true" || (appConstants.frmSchView!=null && appConstants.frmSchView=="Yes") || (fromFavoriteModify=="Yes" && reportypeOnChange != "true"))
				{
					this.setComboOptionsInList(thisForm, 'er_report', jsonObject.reportbycomboarray, appConstants.er_report1);
            		this.setComboOptionsInList(thisForm, 'ermeasuretest', jsonObject.measurecomboarray, appConstants.ermeasuretest1);
				}
				else
				{
					this.setComboOptionsInList(thisForm, 'er_report', jsonObject.reportbycomboarray, jsonObject.reportbycombo_value);
            		this.setComboOptionsInList(thisForm, 'ermeasuretest', jsonObject.measurecomboarray, jsonObject.measurecombo_value);
				}
				
				if (jsonObject.hasOwnProperty("physicalserverscombo_value"))
				{
					Ext.getCmp('er_host').setValue(jsonObject.physicalserverscombo_value);
				}
				else
				{
					var values = []; 
					Ext.getCmp('er_host').getStore().each( function( re ) {
						values.push ( re.get('valueField') );
					}, this);
						Ext.getCmp('er_host').setValue(values);
					
				}
            }
            else if(er_type!=undefined && er_type!='No')
            {
            	Ext.getCmp('physicalservers').hide();
            	thisForm.findField('er_report').hide();
            	thisForm.findField('ermeasuretest').show();
            	thisForm.findField('er_resource').hide();
				Ext.getCmp('reportby').hide();
				if(( appConstants.isSubmit!=null && appConstants.isSubmit=="true"  && from!='select') || appConstants.executeFavorite=="true" || (appConstants.frmSchView!=null && appConstants.frmSchView=="Yes") || (fromFavoriteModify=="Yes" && reportypeOnChange != "true"))
				{
					this.setComboOptionsInList(thisForm, 'er_report', jsonObject.reportbycomboarray, appConstants.er_report1);
            		this.setComboOptionsInList(thisForm, 'ermeasuretest', jsonObject.measurecomboarray, appConstants.ermeasuretest1);
				}
				else
				{
					this.setComboOptionsInList(thisForm, 'er_report', jsonObject.reportbycomboarray, jsonObject.reportbycombo_value);
            		this.setComboOptionsInList(thisForm, 'ermeasuretest', jsonObject.measurecomboarray, jsonObject.measurecombo_value);
				}
				var er_phyenable  = Ext.getCmp('er_phyenable').getValue();
				var er_vmenable = Ext.getCmp('er_vmenable').getValue();

				if( appConstants.isSubmit!=null && appConstants.isSubmit!="true")
				{
					if(er_phyenable!=undefined && er_phyenable)
					{
						if(this.checkValueinComboArray(jsonObject.reportbycomboarray,'Physical Servers'))
							thisForm.findField('er_report').setValue('Physical Servers');
					}
					else if(er_vmenable!=undefined && er_vmenable)
					{
						if(this.checkValueinComboArray(jsonObject.reportbycomboarray,'Virtual Machines'))
							thisForm.findField('er_report').setValue('Virtual Machines');
					}
					else
					{
						if(this.checkValueinComboArray(jsonObject.reportbycomboarray,'Resources Pools'))
							thisForm.findField('er_report').setValue('Resources Pools');
					}
				}
            }
            else
            {
            	thisForm.findField('ermeasuretest').hide();
            	thisForm.findField('er_resource').show();
				Ext.getCmp('reportby').show();
				thisForm.findField('er_report').hide();
            	if(appConstants.s_erView!=undefined && appConstants.s_erView=='Hosts')
            	{
            	   Ext.getCmp('physicalservers').hide();
            	   thisForm.findField('er_report').hide();
            	}
			var er_report =  thisForm.findField('er_report').getValue();
			var er_phyenable; 
			
			var er_vmenable;
			if( (appConstants.isSubmit!=null && appConstants.isSubmit=="true" && from!='select')|| appConstants.executeFavorite=="true" || (appConstants.frmSchView!=null && appConstants.frmSchView=="Yes") || (fromFavoriteModify=="Yes" && reportypeOnChange != "true"))
			{
				er_phyenable = appConstants.er_phyenable;
				er_vmenable = appConstants.er_vmenable;
			}
			else
			{
				er_phyenable = Ext.getCmp('er_phyenable').getValue();
				er_vmenable = Ext.getCmp('er_vmenable').getValue();
			}
					if(er_phyenable=='Yes')
					{
						Ext.getCmp('er_phyenable').setValue(true);
					}
					else
					{
						Ext.getCmp('er_phyenable').setValue(false);
					}
					if(er_vmenable=='Yes')
					{
						Ext.getCmp('er_vmenable').setValue(true);
					}
					else
					{
						Ext.getCmp('er_vmenable').setValue(false);
					}
				if((appConstants.isSubmit!=null && appConstants.isSubmit=="true" && from!='select') || appConstants.executeFavorite=="true" || (appConstants.frmSchView!=null && appConstants.frmSchView=="Yes") || (fromFavoriteModify=="Yes" && reportypeOnChange != "true"))
				{
            		this.setComboOptionsInList(thisForm, 'er_report', jsonObject.reportbycomboarray, appConstants.er_report1);
            		this.setComboOptionsInList(thisForm, 'er_resource', jsonObject.resourcepoolscomboarray, appConstants.er_resource1);
				}
				else if( appConstants.isSubmit!=null && appConstants.isSubmit=="true")
				{
					this.setComboOptionsInList(thisForm, 'er_report', jsonObject.reportbycomboarray, jsonObject.reportbycombo_value);
            		this.setComboOptionsInList(thisForm, 'er_resource', jsonObject.resourcepoolscomboarray, jsonObject.resourcepoolscombo_value);
				}
				else
				{
					this.setComboOptionsInList(thisForm, 'er_report', jsonObject.reportbycomboarray, jsonObject.reportbycombo_value);
            		this.setComboOptionsInList(thisForm, 'er_resource', jsonObject.resourcepoolscomboarray, jsonObject.resourcepoolscombo_value);
				}
            }
		var timeline=jsonObject.timelinepopupDetails;
		var screenLabels=jsonObject.timelinepopupDetails.screenLabels;

		this.setComboOptionsInList(thisForm, 'er_timeline', timeline.timelineCombo, timeline.timeline_value);

//		this.setComboOptionsInList(thisForm,'er_mode',timeline.graphModeCombo,timeline.graphMode_value);
		this.setComboValue(thisForm,'er_mode',timeline.graphMode_value);
		//this.setComboValue(thisForm,'er_sthr',timeline.startHourForDisplay);
		//this.setComboValue(thisForm,'er_endhr',timeline.endHourForDisplay);

		Ext.getCmp("er_stdate").setValue(timeline.startDateDisplayValue);
		Ext.getCmp("er_stdate").dataArray=timeline.startDateValue;
		Ext.getCmp("er_enddate").setValue(timeline.endDateDisplayValue); 
	
		Ext.getCmp("er_enddate").dataArray=timeline.endDateValue;
 		Ext.getCmp("er_sthr").setValue(timeline.startHourForDisplay);
		Ext.getCmp("er_endhr").setValue(timeline.endHourForDisplay);
		Ext.getCmp("er_sthr").dataArray=timeline.starthour_value;
		Ext.getCmp("er_endhr").dataArray=timeline.endhour_value;
		mgr_stmin= timeline.startmin;
		mgr_enmin= timeline.endmin;

		updatingAppSettings();
        },
        loadScreenLabels : function(screenLabel) {

        var filterconfigForm = this.getForm();

        filterconfigForm.findField('er_type').setFieldLabel(screenLabel['reporter.common.Report Type']);
        filterconfigForm.findField('graphtype').setFieldLabel(screenLabel['reporter.common.View by']);
        filterconfigForm.findField('er_comptype').setFieldLabel(screenLabel['reporter.common.Report for']);
        filterconfigForm.findField('er_component').setFieldLabel(screenLabel['reporter.common.Virtual Center']);
        filterconfigForm.findField('er_cluster').setFieldLabel(screenLabel['reporter.common.Cluster']);
        filterconfigForm.findField('er_report').setFieldLabel(screenLabel['reporter.common.Report by']);
        filterconfigForm.findField('ermeasuretest').setFieldLabel(screenLabel['reporter.common.Measure']);
    },
    setNotApplicable : function(form, fieldname) {
        form.findField(fieldname).getStore().removeAll();
        form.findField(fieldname).getStore().loadRawData([{
            "displayField" : this.screenLabels['reporter.common.Not Applicable'],
            "valueField" : "-1"
        }]);
        form.findField(fieldname).setValue("-1");
    },
    setComboOptionsInList : function(form, fieldName, list, value){
    	    form.findField(fieldName).getStore().removeAll();
            form.findField(fieldName).getStore().loadRawData(list);
            form.findField(fieldName).suspendEvents(false);
            form.findField(fieldName).setValue(value);
            form.findField(fieldName).resumeEvents();
    },
     setComboValue : function(form,fieldName,value){
         form.findField(fieldName).suspendEvents(false);
         form.findField(fieldName).setValue(value);
         form.findField(fieldName).resumeEvents();
    },
	checkValueinComboArray:function(combo,value)
	{
		var flag=false;
		if(!Ext.isEmpty(combo) || !Ext.isEmpty(value))
		{
			for(var i=0;i<combo.length;i++)
			{
				var jsonVal=combo[i].valueField;
				if(jsonVal==value)
					flag=true;
			}
		}
	}
});
