
Ext.define('virtualizationclusterreports.view.VirtualizationClusterSettings',{
	extend:'Ext.form.Panel',
	alias:'widget.virtualizationclustersettings',
	//layout:'anchor',
	//cls:'configMode_popup_inner',
	defaults:{
			labelSeparator : '',
			labelAlign: 'top',
			margin: '8 5 8 10'
	},
	layout:'column',
	screenLabels:null,
	items:[		{xtype:'reporttypes', margin: '8 5 8 0'},
				{
					xtype: 'splitter',
					height: 2,
					margin: '2px 0px 2px 0px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				},
				{xtype:'timeperiod', margin: '8 5 8 10'},
				{
					xtype: 'splitter',
					height: 2,
					margin: '2px 0px 2px 0px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				},

				{xtype:'filterby', margin: '8 10 8 0',id:'filterbysplitterId'},
				{
					xtype: 'splitter',
 					height: 2,
					margin: '2px 0px 0px 2px',
					draggable:false,
					id:'splitterId',
					style: {
						'cursor': 'default'
					}
				},
				{xtype:'reportgeneration', margin: '8 5 8 0'},
					{
					xtype: 'splitter',
					id:'RTMSplitter',
					height: 2,
					margin: '2px 0px 0px 2px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				},
				{xtype:'timelinesave', margin: '8 15 0 10'}
	],
	loadSettingsData : function(timeline){
		this.screenLabels = timeline['screenLabels'];
		this.loadScreenLabels(this.screenLabels);

		var thisForm = this.getForm();
		if(appConstants.repoGene!=undefined && appConstants.repoGene!=null)
		{
			this.setComboOptionsInList(thisForm, 'reportGeneration', appConstants.repoGene.reportgenCombo, appConstants.repoGene.reportgenCombo_value);
		}
		else
		{
			this.setComboOptionsInList(thisForm, 'reportGeneration', timeline.reportgenCombo, timeline.reportgenCombo_value);
		}
        this.setComboOptionsInList(thisForm, 'er_excwe', timeline.excludeWeekends,timeline.excludeWeekends_value);
        this.setComboOptionsInList(thisForm, 'er_trenddata',timeline.showDataComboArray,timeline.showDataComboArray_value);
        var er_type = Ext.getCmp('er_type').getValue();
		var graphType= Ext.getCmp('graphtype').getValue();
        if((graphType!=null &&  graphType=='Measures')|| (er_type!=null && er_type=='No'))
        {
			thisForm.findField('er_filter').hide();
			thisForm.findField('er_top').hide();
			Ext.getCmp('filterbysplitterId').hide();
			Ext.getCmp('splitterId').hide();
        }
        else
        {
			if (timeline.FilterByComboObject != undefined)
			{
				thisForm.findField('er_filter').show();
				thisForm.findField('er_top').show();
				Ext.getCmp('filterbysplitterId').show();
        		Ext.getCmp('splitterId').show();
				this.setComboOptionsInList(thisForm, 'er_filter', timeline.FilterByComboObject['filterbycomboarray'],timeline.FilterByComboObject['filterbycomb_value']);
				this.setComboOptionsInList(thisForm, 'er_top', timeline.FilterByComboObject['filterbycomboarray1'],timeline.FilterByComboObject['filterbycombo1_value']);
			}
        }
		this.setComboValue(thisForm, 'timefrom',timeline.timePeriod.Hourfrom);
		this.setComboValue(thisForm, 'minfrom', timeline.timePeriod.Minfrom);
		this.setComboValue(thisForm, 'timeto', timeline.timePeriod.Hourto);
		this.setComboValue(thisForm, 'minto', timeline.timePeriod.Minto);

	},
	loadScreenLabels : function(screenLabels){
        var thisForm = this.getForm();

        thisForm.findField('er_excwe').labelEl.dom.innerHTML = screenLabels['reporter.common.Exclude weekends'];
        thisForm.findField('er_trenddata').labelEl.dom.innerHTML = screenLabels['reporter.common.Show Data'];
        thisForm.findField('reportGeneration').labelEl.dom.innerHTML = screenLabels['reporter.consolidated.Report Generation'];
        thisForm.findField('er_filter').labelEl.dom.innerHTML = screenLabels['reporter.common.Filter by'];

        Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
        Ext.getCmp('fromTimeLbl').setText(screenLabels['reporter.common.From']);
        Ext.getCmp('toTimeLbl').setText(screenLabels['reporter.common.To']);
        Ext.getCmp('fromHrsLbl').setText(screenLabels['reporter.common.Hrs']);
        Ext.getCmp('fromMinsLbl').setText(screenLabels['reporter.common.Mins']);
        Ext.getCmp('toHrsLbl').setText(screenLabels['reporter.common.Hrs']);
        Ext.getCmp('toMinsLbl').setText(screenLabels['reporter.common.Mins']);
        Ext.getCmp('rangeLabel').labelEl.dom.innerHTML =screenLabels['reporter.common.Range'];
        Ext.getCmp('d_min').labelEl.dom.innerHTML =screenLabels['reporter.common.From'];
        Ext.getCmp('d_max').labelEl.dom.innerHTML =screenLabels['reporter.common.To'];
    },
	setNotApplicable : function(form, fieldname) {
        form.findField(fieldname).getStore().removeAll();
        form.findField(fieldname).getStore().loadRawData([{
            "displayField" : this.screenLabel['reporter.common.Not Applicable'],
            "valueField" : "-1"
        }]);
        form.findField(fieldname).setValue("-1");
    },
    setComboOptionsInList : function(form, fieldName, list, value){
            form.findField(fieldName).getStore().loadRawData(list);
            form.findField(fieldName).suspendEvents(false);
            form.findField(fieldName).setValue(value);
            form.findField(fieldName).resumeEvents();
    },
     setComboValue : function(form,fieldName,value){
         form.findField(fieldName).suspendEvents(false);
         form.findField(fieldName).setValue(value);
         form.findField(fieldName).resumeEvents();
    }
});


