	Ext.define('VDataCenter.controller.Main', {
	extend: 'Ext.app.Controller',
	requires: ['VDataCenter.view.Main'],
	refs: [{
			ref: 'main',
			selector: 'main'
		}, {
			selector: 'newUtilities',
			ref: 'newUtilities'
		},
		{selector:'vdatacentermainform', ref:'vdatacentermainform'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}

	],
	init: function () {
		this.control({
			'main newUtilities': {
				afterrender: this.hideTools
			},
			'main': {
				afterrender: this.loadDefaults
			},
			'vdatacentersettings': {
				afterrender: this.afterSettingsrender
			},
			'vdatacentermainform combo[name="er_type"]': {
				'select': this.formSubmit
			},
			'vdatacentermainform combo[name="er_comptype"]': {
				'select': this.formSubmit
			},
			'vdatacentermainform combo[name="er_comptype"]': {
				'select': this.formSubmit
			},
			'vdatacentermainform combo[name="er_component"]': {
				'select': this.formSubmit
			},
			'vdatacentermainform combo[name="er_datacenter"]': {
				'select': this.formSubmit
			},
			'vdatacentermainform combo[name="er_report"]': {
				'select': this.formSubmit
			},
			'vdatacentersettings combo[name="er_filter"]': {
				'select': this.filterChange
			},
			'vdatacentersettings combo[id="er_trenddata"]':
			{
				'select': this.changeTrend
			},
			'vdatacentersettings combo[name="er_timeline"]': {
				//'select': this.timeLineOnChange
			},
			'vdatacentersettings combo[name="reportGeneration"]': {
				'select': this.reportGenChange
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			/* 'vdatacentersettings combo[name="er_excwe"]': {
				'select': this.weekendOnChange
			},*/
			'vdatacentermainform button[name="submit"]': {
				'click': this.runReportFn
			},
			'vdatacentermainform button[name="save"]': {
				'click': this.goTo
			},
		   'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'newUtilities > #printTool > button': {
				'click': this.printReport
			},
			'newUtilities > #saveTool > button': {
				'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button': {
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button': {
				'click': this.saveCsv
			},
			'newUtilities > #favoriteTool > button': {
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button': {
				'click': this.saveSchedule
			},
			'vdatacentermainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	changeTrend: function( combo )
	{
		var jsonData = appConstants.publicjsonData;
		var er_trenddata;
		if (isSettingsEnabled)
		{
			er_trenddata = Ext.getCmp("er_trenddata").getValue();
		}
		else
		{
			er_trenddata = jsonData.er_trenddata;
		}
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal =appConstants.publicjsonData['hiddenfields']['inidate'];
			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}
	},
	showConfigDropdown: function () {
		isSettingsEnabled = true;
	  var tpl = new Ext.XTemplate(
		 '<div style="float:left;margin:0px 0px 0px 0px" >'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
	  //config dropdown mode
	  Ext.create(
		 'Ext.container.Container', {
		 width : 579,
		// padding: 5,
		 id: 'configMod',
		 //cls: 'configMode_popup',
		 ui:'settingsWindowContainer',
		 //html: tpl.apply(),
		 items: [
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'369px'}
					},
					{
						xtype:'container',
						cls:'containerHeader',
						html:tpl.apply(),
						style:{'top':'0px','margin':'0px'}
					},
					{
						xtype:'vdatacentersettings',
						parent: this
					}
		 ],
		 renderTo: 'vdatacenter-body'
	  });
	   var thisController = this;
	  Ext.get('closeSettings').on('click', function () {
			thisController.validateAndCloseSettings();
		});

	},goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicjsonData['hiddenfields'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite();
		}
	},
	 changeEr_mode: function (combo) {
		if(Ext.get('configMod')!=null){
			Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		}
		this.showResult(true);
	},
	runReportFn: function()
	{
		this.showResult(true);
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('datacentermainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	printReport: function () {
		var s_qryString = "/final/reporter/ErVMPrintData.jsp?" + appConstants.publicjsonData.saveQString +"&ervm_type=vc_datacenter&pdfPrint=yes";
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		parent.printWindowFn(s_qryString);	 //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	saveReportAsPDF: function () {
		var saveQString = appConstants.publicjsonData.saveQString;
		saveQString += "&ervm_type=vc_datacenter&pageWidthProces="+appConstants.publicjsonData.pageWidth;
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicjsonData.saveQString;
		saveQString += "&ervm_type=vc_datacenter&pageWidthProces="+appConstants.publicjsonData.pageWidth;
		var s_qryString = saveQString;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var finalParams = appConstants.queryString + "&er_rtype=Virtualization";
		if(finalParams != null)
			bookletquery+= encodeURI(finalParams);
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	sendMail: function () {
	var islegendEnabled = Ext.getCmp('showLegend').getValue();
	if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
		 drillDownParams = "&showLegend="+islegendEnabled;
	}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv: function () {
		window.location = '../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveFavorite: function () {
		var isValid = this.showResult(false);
		/* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'Capactity Correlation',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		} */
		this.updateQueryString();
		var finalParams = appConstants.queryString+"&er_rtype=Virtualization";
		if (isValid) {
			var target;
			var favorite_id =appConstants.publicjsonData['hiddenfields']['favorite_id']; 
		
			target = "../servlet/com.eg.ErFavoriteC?" + encodeURI(finalParams) + "&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+favorite_id;
			if (appConstants.formButtonId=='save')
			{
				//document.location=s_qryString+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});

			}
			else
				parent.favouriteWindowFn(target);	//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		} else return;
	},
	saveSchedule: function () {
		var isValid = this.showResult(false);
		if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'Virtualization',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		}
		this.updateQueryString();
		var finalParams = appConstants.queryString + "&er_rtype=Virtualization";;
		if (isValid) {
			var target;
			target = "/final/reporter/ErSaveSchedule.jsp?" + encodeURI(finalParams)+"&com.eg.CSRF_NONCE="+csrfToken;
			
			
			
			if (appConstants.formButtonId=='save')
			{
				//document.location=s_qryString+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		} else return;
	},
	showResult: function (flag) {
		Ext.getCmp('panelinsidetoggle').setDisabled(false);

		var reportType = Ext.getCmp('er_type').getValue();
		var comptype = Ext.getCmp("er_comptype");
		if (comptype.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Virtualization',
				msg: comptype.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}

		var component = Ext.getCmp("er_component");
		if (component.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Virtualization',
				msg: component.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		var datacenter = Ext.getCmp("er_datacenter");

		if (datacenter.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Virtualization',
				msg: datacenter.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		if (reportType == 'Yes') {
			var report = Ext.getCmp("er_report");
			if (report.getValue() == '-1') {
				Ext.MessageBox.show({
					title: 'Virtualization',
					msg: report.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		var reportgen = appConstants.publicjsonData.reportGeneration;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').dataArray;
		
		var endHour = Ext.getCmp('er_endhr').dataArray;
		stDate.setHours(startHour);
		enDate.setHours(endHour);

	   if (!checkDateTime(stDate, enDate)) {
		   return false;
	  }
		if (er_usertimeline != null && er_usertimeline != '-1') {
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
			if (!usertimelineValid) {
				Ext.MessageBox.show({
					title: 'Virtualization settings',
					msg: userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if (reportgen != null && reportgen == 'foreground') {
		if(flag)
			{
				var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg'];
				if (!Ext.isEmpty(limitforbg)) {
					if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
					} else
						this.submitReport();
				} else
					this.submitReport();
			}
		} else {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
			else
				this.submitReport();
		}
		return true;
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
			//isSettingsOk = true;
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(true);
			if (isSettingsOk) {
				getButtonObj.setDisabled(false);
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			}
		return true;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.runReportFn();
		}
	},
	validateSettings: function () {
		var isSettingsOk = true;
		var reportType = Ext.getCmp('er_type').getValue();
		if (reportType == 'Yes') {
			var filterval = Ext.getCmp("er_filter").getValue();
			if (filterval == 'Lessthan' || filterval == 'Greaterthan') {
				var val = Ext.getCmp('valueToFilter').getValue();
				if (isNaN(val)) {
					Ext.MessageBox.show({
						title: 'Settings',
						msg: ' Value must be a numeric value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					isSettingsOk = false;
				}
			} else if (filterval == 'Range') {
				var minrange = Ext.getCmp('minRange').getValue();
				var maxrange = Ext.getCmp('maxRange').getValue();
				if (isNaN(minrange) || isNaN(maxrange)) {
					Ext.MessageBox.show({
						title: 'Settings',
						msg: 'Range must be a numeric value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					isSettingsOk = false;
				} else if (parseFloat(minrange) > parseFloat(maxrange)) {
					Ext.MessageBox.show({
						title: 'Settings',
						msg: 'Wrong Input Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					isSettingsOk = false;
				}
			}
		}
		var reportgen = Ext.getCmp('reportGeneration').getValue();

		if (reportgen != null && (reportgen == 'background' || reportgen == 'background-csv')) {

			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
			return isSettingsOk;
		}
		return isSettingsOk;
	},
	showConfirmResult: function (btn) {
		if (btn == "yes") {
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			this.submitReport();
		} else {
			if (!isSettingsEnabled)
			{
				this.getSettings().down('button').fireHandler();
			}
			var reportGenType = Ext.getCmp('reportGeneration');
			var bgreportNameObj = Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)) return false;
		}
	},
	submitReport: function () {
		appConstants.initLdgMask.show();
		var reportGeneration = appConstants.publicjsonData.reportGeneration;
		if (isSettingsEnabled)
		{
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
		 this.updateQueryString(true);
		var finalParams = appConstants.queryString + "&ermeasuretest=" + Ext.getCmp("ermeasuretest").getValue() + "&er_measure=" + Ext.getCmp("ermeasuretest").getValue();

		//var reportGeneration = Ext.getCmp('reportGeneration').getValue();
		if (reportGeneration == 'foreground') {
			urlforAjax = '../servlet/com.eg.ErVirtualClusterReportC';
			finalParams += "&isSubmit=true&responseType=json";
		} 
		else if (reportGeneration == 'background') 
		{
			urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
			var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
		}
		else if (reportGeneration == 'background-csv') 
		{
			urlforAjax = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
		}
		Ext.Ajax.request({
			url: urlforAjax,
			params: finalParams,
			method: 'POST',
			scope: this,
			async: true,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadReportData(appConstants.publicjsonData);
			}
		});
	},
	loadReportData: function (jsonData) {
		var resultPanelObj = Ext.getCmp('resultPanel');
		var gridContainer = Ext.getCmp('gridContainer');
		resultPanelObj.hide();
		gridContainer.hide();
		var me= this;
		me.getNomeasurepanel().hide();
		me.getBackGroundPanel().hide();
		var reportGeneration = appConstants.publicjsonData.reportGeneration;
		if (reportGeneration == 'foreground') {
			var noDataFound = true;
			var reportData = jsonData.REPORT_DATA;
			 var fieldContainerArray = new Array();
			if (!Ext.isEmpty(reportData)) {
				var reportType = jsonData.er_type;
				if (reportType == 'Yes') {
					//resultPanelObj.addCls('containerShadow');
					//resultPanelObj.removeCls('datapanel');
					if(gridContainer!=undefined && gridContainer!=null)
						gridContainer.hide();
					resultPanelObj.removeAll();
					var s_graphtype = jsonData.graphtype;
					if (resultPanelObj.getHeader()) {
						resultPanelObj.getHeader().show();
					}
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					//Ext.getCmp("upbutton").setDisabled(false);
					resultPanelObj.setTitle(reportData.chartTitle);
					if (s_graphtype == 'Timeline') {
						var chartType = jsonData['chartType'];
						noDataFound = false;
						resultPanelObj.show();
						if(chartType == 'highchart'){
							resultPanelObj.add({
								xtype: 'container',
								//padding: '30',
							//	padding:'20',
								columnWidth:1.0,
								height: 405,
								//margin:'0 10 10 10',
								margin:'0 0 10 0',
								style: {
									'text-align': 'center'
								},
								items: [
									{
										xtype: 'container',
										id:'highChart_GraphPanel',
										html:'<div id="highChart" style="width:100%;height:100%;"></div>',
										height: 350
									},
									{
										xtype: 'container',
										id:"highChart_legendPanel",
										height: 55,
										style: {
											'overflow': 'hidden',
											'padding-right':'10px',
											'padding-bottom':'5px',
										}
									}]
							});
						}
						else
						{
						resultPanelObj.add({
							xtype: 'container',
							//padding: '15',
							columnWidth:1.0,
							margin:'0 10 10 10',
							style: {
								'text-align': 'center'
							},
							items: [{
									xtype: 'image',
									src: reportData.chartUrl,
									width: 700,
									height: 400
								}
							]
						});
							resultPanelObj.show();
						}
						if(chartType == "highchart"){
								reportHighStockChart(reportData.chartUrl+"&chartType="+chartType,'highChart',300,900);
						}
					} else if (s_graphtype == 'Distribution') {
						var chartArray = reportData.chartArray;
						if (!Ext.isEmpty(chartArray)) {
							resultPanelObj.show();
							noDataFound = false;
							var noOfChart = chartArray.length;
							for(var k=0;k<noOfChart;k++) {
								var itemsArray = new Array();
								 var chartObj = chartArray[k];
								 var chartid = 'fusionChart' + chartObj.chartType;
								var chartheight = chartObj.height;
								if (chartObj.chartType == 'pie') {
									chartheight = 350;
									var legendObj=chartObj.legend;
									itemsArray.push(
										{
											xtype: 'panel',
											ui: 'newGraphPanel',
											id:'leftChartContent',
											height:330,
											//flex:0.65,
											columnWidth:.35,
											margin:10,
											html:''
										}
									);
										
							
								}else if( chartObj.chartType == 'bar'){
									var content='<table width="100%" height="100%">';
									content+='<tr><td class="font_normal12" style="text-align:center;height:30px;">'+chartObj.title+'</td></tr>';
									content+='<tr><td><div id="'+chartid+'"></div></td></tr>';
									content+='</table>';
									itemsArray.push(
									{
										xtype: 'panel',
										//flex:1,
										height:330,
										id:'rightChartContent',
										margin:'10 10 10 0',
										columnWidth:.65,
										ui: 'newGraphPanel',
										html:''
									});
									
								}
								if(Ext.getCmp('basePanelId')==undefined || Ext.isEmpty('basePanelId'))
								{
									var baseItemsAry = new Array();
									resultPanelObj.getHeader().hide();
									baseItemsAry.push({
										xtype:'panel',
										id:'basePanelId',
										columnWidth:1.0,
										layout:'column',
										title:reportData.chartTitle,
										ui:'multiGraphPanel',
										items:itemsArray
									});

									resultPanelObj.add(baseItemsAry);
								}
								else
								{
									Ext.getCmp('basePanelId').add(itemsArray);
								}
								if (Ext.isEmpty(appConstants.erUtils))
								{
								appConstants.erUtils = Ext.widget("erutils");
								}
								if(chartObj.chartType!=null && chartObj.chartType=='pie')
								{
									appConstants.erUtils.updatePieChart(appConstants.chartType,legendObj,'COLOR','LINK','LABEL',chartObj.title,chartObj.XMLData,chartObj.swfpath,chartObj,Ext.getCmp('leftChartContent'));
								}
								else if(chartObj.chartType == 'bar')
								{
									appConstants.erUtils.updateBarChart(appConstants.chartType,chartObj.title,chartObj.XMLData,chartObj.swfpath,chartObj,chartObj.chartHeight,chartObj.chartWidth,Ext.getCmp('rightChartContent'))
								}
							}
						}
					}
				} else if (reportType == 'No') {
					resultPanelObj.removeCls('containerShadow');
					//resultPanelObj.addCls('datapanel');

					if(gridContainer!=undefined && gridContainer!=null){
						gridContainer.show();
						gridContainer.removeAll();
					}
					 var itemsArray = new Array();
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					//Ext.getCmp("upbutton").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);
					var dataCenterGrid = reportData.dataCenterGrid;
					var gridArray = reportData.GridArray; //remaining grid
					if (!Ext.isEmpty(dataCenterGrid)) {
						noDataFound = false;
						var columnDetails = dataCenterGrid.COLUMNS;
						var dataArraytoStore = dataCenterGrid.DATA;
						var fieldstoStore = new Array();
						var mainColumnsObjArray = new Array();
						for (var n in columnDetails) {
							var isLocked = false;
							var align='center';
							var fieldIndex = "COLUMN_" + n;
							fieldstoStore.push(fieldIndex);
							if (n==0)
							{
								align='left';
								mainColumnsObjArray.push({
									header: columnDetails[n],
									//locked:true,
									sortable: true,
									width:115,
									dataIndex: fieldIndex,
									align: align,
									renderer: function( val,metaData )
									{
										//metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
										return val;
									}  
								});
							}
							else
							{
								mainColumnsObjArray.push({
									header: columnDetails[n],
									//locked:false,
									sortable: true,
									dataIndex: fieldIndex,
									align: align,
									renderer: function( val,metaData )
									{
									//	metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
										val = Ext.getCmp('gridId').getDecimalAlignFormat(val);
										return val;
									}
								});
							}
					}
						var storeObj = Ext.create('Ext.data.Store', {
							fields: fieldstoStore,
							data: dataArraytoStore,
							autoLoad : true,
							sorters: { property: fieldstoStore[0], direction : 'ASC' },// vengat
							});
						var gridpanel = Ext.widget('customgrid', {
							store: storeObj,
							sortableColumns: true,
							needtoFixColumn:true,
							id:'gridId',
							border:true,
							//cls:'gridSkin horizontal-scroll',
							ui:'newGridPanel withHeader withShade',
							columns: mainColumnsObjArray,
							title: dataCenterGrid.gridTitle,
							//margin:'10 10 10 10',
							padding:'10 10 10 10',
							popUpData:jsonData.popUpData,
							popUpData1:jsonData.popUpData1,
							listeners:{
									render:function(obj){
										Ext.defer(function() {
											//obj.columns[0].setSortState("ASC",true,true);
										},100);
									},
									beforedestroy:function(grid){
										grid.tip.destroy();
									},									
									viewready:function(grid){
										
										var view = grid.view;
										// record the current cellIndex
										grid.mon(view, {
											uievent: function (type, view, cell, recordIndex, cellIndex, e) {
												grid.cellIndex = cellIndex;
												grid.recordIndex = recordIndex;
											}
										});
										
										grid.tip = Ext.create('Ext.tip.ToolTip', {
											target: view.el,
											flex : 1,
											anchor:'left',
											anchorToTarget:true,
											anchorOffset:10,
											layout: 'fit',
											autoHide:true,
											delegate: '.x-grid-cell',
											trackMouse: true,
											// autoHide:false,
											border:false,
											margin:10,
											id:'GenericWindowId',
											closeAction: 'hide',
											closable:true,
											ui:'newTooltipPopup',
											//title:'List of DataCenters',
											hideDelay : 10000,
											layout : {
												type : 'vbox',
												align : 'stretch',
												pack : 'center'
											},
											width:200,
											renderTo: Ext.getBody(),
											listeners: {
												beforeshow: function updateTipBody(tip) {  
													if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex !== -1) {
														header = grid.headerCt.getGridColumns()[grid.cellIndex];
														var dataIndex=header.dataIndex;
														var cellValue,cellTipText;
														//this.setTitle('<div style="color:#ffffff">12233434</div>');
														cellValue=grid.popUpData1[grid.recordIndex][dataIndex]; 
														//cellValue=grid.popUpData[dataIndex]; 
														if(dataIndex == 'COLUMN_0')
															this.setTitle('');
														else
															this.setTitle('List of DataCenters');
														if (Ext.isEmpty(cellValue))
														{
															this.setHeight(30+50);
															this.setWidth(180);
															cellTipText='<div><table width="100%"><tr><td style="color:#2a292a;padding:4px 0px 4px 0px">No data found</td></tr><table></div>';
														//	cellTipText='No data found';
														}
														else
														{
															var cellValueArray=cellValue.split(',');
															var len=cellValueArray.length*30+50;
															var scrollType='hidden';
															if (len>150)
															{
																scrollType='scroll';
																len=200;
															}
															this.setHeight(len);
															cellTipText='<div style="height:150px;overflow-y:'+scrollType+';"><table width="100%"><tbody>';
															for (var key in cellValueArray)
															{
																cellTipText+='<tr><td style="color: #2a292a;padding:4px 0px 4px 0px" class="newLineBottom2">'+cellValueArray[key]+'</td></tr>';
															}
															cellTipText+='</tbody></table></div>';
														}
														tip.update(cellTipText);
													}
												}
											}
										});
									}
								}
						});
						itemsArray.push(gridpanel);
					}

					if (!Ext.isEmpty(gridArray)) {
						for (var v in gridArray) {
							var gridObj = gridArray[v];
							var columnDetails = gridObj.COLUMN_DETAILS;
							var dataArraytoStore = gridObj.DATA;
							var units = gridObj.UNITS;
							var subcolumns = gridObj.SUB_COLUMN_DETAILS
							var fieldstoStore = new Array();
							var columnObjToGrid = new Array();
							var columnCount = 0;
							var s_width=150;

							for (var kk = 0; kk < columnDetails.length; kk++) {
								var subColumnArray = new Array();
								var colObj = columnDetails[kk];
								var subColumnCount = colObj['SUB_COLUMNS'];
								var widthdivided =s_width/subColumnCount;
								if (subColumnCount > 0) {
									for (var j = 0; j < subColumnCount; j++) {
										fieldstoStore.push('COLUMN_' + columnCount);
										subColumnArray.push({
											header: subcolumns['COLUMN_' + columnCount],
											sortable: true,
											align: 'center',
											dataIndex: 'COLUMN_' + columnCount,
											renderer: function( val,metaData )
											{
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
												val = Ext.getCmp('gridId_temp'+v).getDecimalAlignFormat(val);
												return val;
											}
											//minWidth:widthdivided,
										 });
										columnCount++;
									}
									var measureCol = new Array();
									measureCol.push({
										header: units[kk],
										align: 'center',
										columns: subColumnArray,
									 });

									//if (subColumnCount > 0) {
									columnObjToGrid.push({
										header: colObj['HEADER'],
										//columns: measureCol,
										locked:false,
									   columns: subColumnArray,
										align: 'center'
										//minWidth:s_width,
									 });
									//}
								} else {
									if(kk == 0)
									{
										fieldstoStore.push('COLUMN_' + columnCount);
										columnObjToGrid.push({
											header: colObj['HEADER'],
											align: 'left',
											locked:true,
											width:115,
											dataIndex: 'COLUMN_' + columnCount,
											renderer: function( val,metaData )
											{
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
												return val;
											}
										 });
										columnCount++;
									}
									else
									{
										fieldstoStore.push('COLUMN_' + columnCount);
										columnObjToGrid.push({
											header: colObj['HEADER'],
											locked:false,
											align: 'left',
											dataIndex: 'COLUMN_' + columnCount,
											renderer: function( val,metaData )
											{
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
												val = Ext.getCmp('gridId_temp'+v).getDecimalAlignFormat(val);
												return val;
											}
										 });
										columnCount++;
									}
								}
							}
							var storeObj = Ext.create('Ext.data.Store', {
								fields: fieldstoStore,
								data: dataArraytoStore
							});
							var gridpanel = Ext.widget('customgrid', {
								store: storeObj,
								sortableColumns: true,
								needtoFixColumn:true,
								id:'gridId_temp'+v,
								border:true,
								//cls:'gridSkin horizontal-scroll',
								columns: columnObjToGrid,
								margin:'10 0 0 0',
								padding:'10 10 10 10',
								ui:'newGridPanel withHeader withShade',
								title: gridObj.gridTitle,                          
								listeners:{
									render:function(obj){
										Ext.defer(function() {
											//obj.columns[0].setSortState("ASC",true,true);
										},100);
									}
								}
							   // bodyPadding: '0 0 20 0'
							});
							itemsArray.push(gridpanel);
						}
					}

					if(gridContainer!=undefined && gridContainer!=null)
					gridContainer.add(itemsArray);
					 //resultPanelObj.doLayout();
				   /* getHeightPanel = gridContainer.getHeight();
					conditionalHeight = Ext.getBody().getViewSize().height / 2;
					if (getHeightPanel > conditionalHeight) {
						Ext.select('.gridSkin').setStyle('margin', '0px 0px 10px 0px');
					} else {
						Ext.select('.gridSkin').setStyle('margin', '10px');
					}*/
				}
				if (!noDataFound) {
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
				appConstants.initLdgMask.hide();
			}
			if (noDataFound) {
				this.disableTools();
				resultPanelObj.hide();
				gridContainer.hide();
				me.getNomeasurepanel().doLayout();
				me.getNomeasurepanel().show();
				appConstants.initLdgMask.hide();
			}
		} else if (reportGeneration == 'background' || reportGeneration == 'background-csv') {
			var htmlStr = '';
			var backgroundReportStatus = jsonData.backgroundReportStatus;
			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else {
				htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>';
			}
			this.getBackGroundPanel().update(htmlStr);
			this.getBackGroundPanel().show();
		}
		appConstants.initLdgMask.hide();
	},
		mouseOverData:function(iRecord,dataObj,columnDetails,iColIdx){
		var dat=dataObj[iRecord];
		var tit=columnDetails[iRecord];
		if(dat!='' && dat!=null && dat !='undefined'){
		dat=dat.substring(dat.lastIndexOf("|")+1);
		dat=dat.replace(/\,/g,'<br>');
		}
	/*	var popUpWindow =Ext.create('Ext.window.Window',{
							title:tit,
							height: 200,
							width: 200,
								id:'popup',
							items: {
								xtype: 'container',
								border: false,
								html:dat,
								trackMouse: true
						  //store: Ext.create('Ext.data.ArrayStore', {})
						}
					}).show();
	*/
					   var popUpWindow = [{
					target: iColIdx,
					title: tit,
					id:'popup',
					height: 200,
					width: 200,
					html:dat,
					trackMouse: true
		}];
					  Ext.each(popUpWindow, function(config) {
		Ext.create('Ext.tip.ToolTip', config);
	});
	},
	mouseOverHide:function(){
		//Ext.getCmp('popup').hide();
	},
	filterChange: function (obj) {
		var val = obj.getValue();
		if (val == 'Range') {
			Ext.getCmp('er_top').hide();
			Ext.getCmp('valueToFilter').hide();
			Ext.getCmp('er_range').show();
		} else if (val == 'Lessthan') {
			Ext.getCmp('er_top').hide();
			Ext.getCmp('valueToFilter').show();
			Ext.getCmp('er_range').hide();

		} else if (val == 'Greaterthan') {
			Ext.getCmp('er_top').hide();
			Ext.getCmp('valueToFilter').show();
			Ext.getCmp('er_range').hide();
		} else {
			Ext.getCmp('er_top').show();
			Ext.getCmp('valueToFilter').hide();
			Ext.getCmp('er_range').hide();
		}

	},
	formSubmit: function (obj) {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('gridContainer').hide();
		this.disableTools();
		this.updateQueryString();
		var id = obj.getId();
		var er_type = Ext.getCmp("er_type").getValue();
		Ext.Ajax.request({
			url: '/final/reporter/ErVirtualDataCenterJson.jsp?er_type='+er_type,
			params: appConstants.queryString,
			method: 'POST',
			success: function (response) {
				appConstants.publicJsonData = Ext.decode(response.responseText);
				appConstants.repoGene = appConstants.publicJsonData
				if (isSettingsEnabled)
				{
					var reportGenCombo = appConstants.publicJsonData.reportGenerationCombo;
					var selreportGeneration = appConstants.publicJsonData.reportGeneration
					var reportGen = Ext.getCmp('reportGeneration');
					reportGen.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Report Generation']);
					reportGen.getStore().loadRawData(reportGenCombo);
					reportGen.setValue(selreportGeneration);
					var reportNameObj = Ext.getCmp('bgReportName');
					if(selreportGeneration!=undefined && selreportGeneration!=null && selreportGeneration=='foreground')
					{
						reportNameObj.hide();
					}
					else
					{
						reportNameObj.show();
					}
				}
				if (id == 'er_type') {
					if (appConstants.publicJsonData.er_type == 'Yes')
					{
						Ext.getCmp('graphtype').show();
						Ext.getCmp('er_report').show();
						Ext.getCmp('ermeasuretest').show();
						Ext.getCmp("showLegend").show();
					}
					else
					{
						Ext.getCmp('graphtype').hide();
						Ext.getCmp('er_report').hide();
						Ext.getCmp('ermeasuretest').hide();
						Ext.getCmp("showLegend").hide();
					}
				} 
				if (id == 'er_comptype' || id == 'er_type') {
					comboRawData = appConstants.publicJsonData.componentCombo;
					selectedComboOption =  appConstants.publicJsonData.er_component;
					comboObject = Ext.getCmp('er_component');
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboRawData =  appConstants.publicJsonData.dataCenterCombo;
					selectedComboOption =  appConstants.publicJsonData.er_datacenter;
					comboObject = Ext.getCmp('er_datacenter');
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}

				} else if (id == 'er_comptype' || id == 'er_component' || id == 'er_type') {
					comboRawData =  appConstants.publicJsonData.dataCenterCombo;
					selectedComboOption =  appConstants.publicJsonData.er_datacenter;
					comboObject = Ext.getCmp('er_datacenter');
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				} else if ((id == 'er_comptype' || id == 'er_component' || id == 'er_datacenter') && appConstants.publicjsonData.er_type == 'Yes') {
					comboRawData =  appConstants.publicJsonData.reportByCombo;
					if(comboRawData!=undefined && comboRawData!='undefined'){
					selectedComboOption =  appConstants.publicJsonData.er_report;
					comboObject = Ext.getCmp('er_report');
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
		}
				}
				if ( appConstants.publicJsonData.er_type == 'Yes') {
					comboRawData =  appConstants.publicJsonData.measureCombo;
					selectedComboOption =  appConstants.publicJsonData.ermeasuretest;
					comboObject = Ext.getCmp('ermeasuretest');
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
			}
		});
	},
	updateQueryString: function () {
		var FormParams;
		var hiddenfieldQString = '';
		var timelineParams;
		var timePeriodParams;
		var jsonData = appConstants.publicjsonData;
		var reportType = Ext.getCmp('er_type').getValue();
		var er_timeline = Ext.getCmp('er_timeline').getValue();

		var er_trenddata = jsonData.er_trenddata;
		var er_excwe = jsonData.er_excwe;
		var reportGeneration = jsonData.reportGeneration;
		var showLegend = jsonData.showLegend;
		var filterval = jsonData.er_filter;
		var timefrom =jsonData['selectedTimeFrom'];//jsonData.timefrom;//jsonData['selectedValues']['fromHrSelected'];//['fromHrSelected'];// jsonData.timefrom;

		var minfrom = jsonData['selectedMinsFrom'];
		var timeto = jsonData['selectedTimeTo'];
		var minto =jsonData['selectedMinsTo'];
		if (isSettingsEnabled)
		{
			er_trenddata = Ext.getCmp("er_trenddata").getValue();
			er_excwe = Ext.getCmp("er_excwe").getValue();
			reportGeneration = Ext.getCmp("reportGeneration").getValue();
			filterval = Ext.getCmp("er_filter").getValue();
			timefrom = Ext.getCmp("timefrom").getValue();
			minfrom = Ext.getCmp("minfrom").getValue();
			timeto = Ext.getCmp("timeto").getValue();
			minto = Ext.getCmp("minto").getValue();
		}
		var timperiodParams = "&timefrom=" + timefrom + "&minfrom=" + minfrom + "&timeto=" + timeto + "&minto=" + minto;

		FormParams = "&er_type=" + reportType + "&er_comptype=" + Ext.getCmp("er_comptype").getValue() + "&er_component=" + Ext.getCmp("er_component").getValue() + "&er_datacenter=" + Ext.getCmp("er_datacenter").getValue() + "&er_trenddata=" + er_trenddata + "&optval=" + er_trenddata + "&er_excwe=" + er_excwe + "&er_excweekend=" + er_excwe + "&er_mode=" + Ext.getCmp("er_mode").getValue() + "&er_reportgenration=" + reportGeneration +"&showLegend="+ Ext.getCmp("showLegend").getValue();
		if (reportType == 'Yes') {
			FormParams += "&graphtype=" + Ext.getCmp("graphtype").getValue() + "&er_report=" + Ext.getCmp("er_report").getValue()
			+"&ermeasuretest="+Ext.getCmp("ermeasuretest").getValue()
			+ "&er_filter=" + filterval;
			if (filterval == 'Range') {
				FormParams += "&d_max=" + Ext.getCmp("maxRange").getValue() + "&d_min=" + Ext.getCmp("minRange").getValue();
			} else if (filterval == 'Lessthan') {
				FormParams += "&d_max=" + Ext.getCmp("valueToFilter").getValue() + "&d_min=" + appConstants.publicjsonData.strd_min;
			} else if (filterval == 'Greaterthan') {
				FormParams += "&d_min=" + Ext.getCmp("valueToFilter").getValue() + "&d_max=" + appConstants.publicjsonData.strd_max;
			} else {
				if (isSettingsEnabled)
					FormParams += "&er_top=" + Ext.getCmp("er_top").getValue();
				else
					FormParams += "&er_top=All";
			}
		}
		var stdateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, mgrDateFormat));
		var endateobj=new Date(Ext.Date.parse(Ext.getCmp('er_stdate').dataArray, mgrDateFormat));
		var beanst_date = Ext.Date.dateFormat(stdateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var beanen_date = Ext.Date.dateFormat(endateobj, getExtjsDateFormat('dd-MM-yyyy'));
		var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&timelineval=" + Ext.getCmp("er_timeline").getValue() +"&vensar_dot="+ "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+ "&beanstartdate=" + beanst_date + "&beanenddate=" + beanen_date;;
		if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
			var hiddenFields = appConstants.publicjsonData.hiddenfields;
			for (var hiddenField in hiddenFields) {
				hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		appConstants.queryString = FormParams + timelineParams + hiddenfieldQString + timperiodParams;
	appConstants.queryString +="&er_RmDispName="+appConstants.er_RmDispName;

	},
	hideTools: function () {
		this.getNewUtilities().loadIcon(true, // save
		true, // print
		true, // mail
		false, // data
		true, // cvs
		true, // fav
		true, // schedule
		false, // daignosis
		false, // togglebutton
		false, // close
		true // booklet
		);
		// Ext.getCmp("upbutton").hide();
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		//Ext.getCmp("saveTool").setDisabled(true);
		//Ext.getCmp("printTool").setDisabled(true);
		//Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("dataTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	loadDefaults: function () {
		appConstants.publicjsonDataCopy=appConstants.publicjsonData;
		var thisController = this;
		this.favSaveButton();
	if(!hideBackButton){
		Ext.getCmp('datacentermainform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonData['ID']
			}
		);
	}

	if(appConstants.publicjsonData.er_trenddata!=undefined && appConstants.publicjsonData.er_trenddata=='Yes')
		{
		isTrend=true;
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
		//this.getSettings().down('button').fireHandler();
		this.fillFormFields(appConstants.publicjsonData);
		this.refreshReportData();
	},
	refreshReportData: function () 
	{
		if (appConstants.isSubmit != null && appConstants.isSubmit == "true") {
			appConstants.initLdgMask.show();
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	afterSettingsrender:function() {
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields =  appConstants.publicjsonDataCopy['hiddenfields'];
		var favorite_id =appConstants.publicjsonDataCopy['hiddenfields']['favorite_id']; 
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		jsonData = appConstants.publicjsonDataCopy;
		var comboRawData = jsonData.showdataCombo;
		selectedComboOption = jsonData.er_trenddata;
		var screenLabels = jsonData.screenLabels;
		var comboObject = Ext.getCmp('er_trenddata');
		comboObject.setFieldLabel(screenLabels['reporter.common.Show Data']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		var trendenablee = appConstants.publicjsonData.hiddenfields['trendenable'];
		if(trendenablee == 'false'){
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}
		comboRawData = jsonData.filterCombo;
		selectedComboOption = jsonData.er_filter;
		comboObject = Ext.getCmp('er_filter');
		Ext.getCmp('Filterlable').setFieldLabel(screenLabels['reporter.common.Filter by']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.topCombo;
		selectedComboOption = jsonData.er_top;
		comboObject = Ext.getCmp('er_top');
		//comboObject.setFieldLabel(screenLabels['reporter.common.Top']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.excludeWeekCombo;
		selectedComboOption = jsonData.er_excwe;
		comboObject = Ext.getCmp('er_excwe');
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		/*var excludeDaysObj = Ext.getCmp('excludeDays');
		if (selectedComboOption == 'Yes') {
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataCopy.screenLabels['MappedExcludeDays']);
		}*/
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		Ext.getCmp('timefrom').setValue(jsonData.selectedTimeFrom);
		Ext.getCmp('minfrom').setValue(jsonData.selectedMinsFrom);
		Ext.getCmp('timeto').setValue(jsonData.selectedTimeTo);
		Ext.getCmp('minto').setValue(jsonData.selectedMinsTo);
		var repoMaking = "";
		if (appConstants.repoGene!=undefined)
		{
			repoMaking = appConstants.repoGene
		}
		else
		{
			repoMaking = jsonData;
		}
		var reportGenCombo = repoMaking.reportGenerationCombo;
		var selreportGeneration = repoMaking.reportGeneration;
		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
		appConstants.publicjsonDataCopy=null;
		jsonData=null;
		delete jsonData;
	},
	fillFormFields: function (jsonData) {
		var thisController = this;
		this.favSaveButton();
		var screenLabels = jsonData.screenLabels;
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		comboRawData = jsonData.reportTypeCombo;
		selectedComboOption = jsonData.er_type;
		comboObject = Ext.getCmp('er_type');
		comboObject.setFieldLabel(screenLabels['reporter.common.Report Type']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		if(selectedComboOption!=null && selectedComboOption=='Yes') {
			comboRawData = jsonData.viewCombo;
			selectedComboOption = jsonData.graphtype;
			comboObject = Ext.getCmp('graphtype');
			comboObject.setFieldLabel(screenLabels['reporter.common.View by']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.reportByCombo;
			selectedComboOption = jsonData.er_report;
			comboObject = Ext.getCmp('er_report');
			comboObject.setFieldLabel(screenLabels['reporter.common.Report by']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.measureCombo;
			selectedComboOption = jsonData.ermeasuretest;
			comboObject = Ext.getCmp('ermeasuretest');
			comboObject.setFieldLabel(screenLabels['reporter.common.Measure']);
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}

			Ext.getCmp('graphtype').show();
			Ext.getCmp('er_report').show();
			//Ext.getCmp('er_mode').show();
			Ext.getCmp('ermeasuretest').show();
			//Ext.getCmp('Filterlable').show();
		} else {
			Ext.getCmp('graphtype').hide();
			Ext.getCmp('er_report').hide();
			Ext.getCmp('er_mode').hide();
			Ext.getCmp('ermeasuretest').hide();
			//Ext.getCmp('Filterlable').hide();
		}
		comboRawData = jsonData.compTypeCombo;
		selectedComboOption = jsonData.er_comptype;
		comboObject = Ext.getCmp('er_comptype');
		comboObject.setFieldLabel(screenLabels['reporter.common.Report for']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.componentCombo;
		selectedComboOption = jsonData.er_component;
		comboObject = Ext.getCmp('er_component');
		comboObject.setFieldLabel(screenLabels['reporter.common.component']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.dataCenterCombo;
		selectedComboOption = jsonData.er_datacenter;
		comboObject = Ext.getCmp('er_datacenter');
		comboObject.setFieldLabel(screenLabels['reporter.common.Datacenters']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		var timelineRawData = jsonData.timelineCombo;
		var selectedTimeline = jsonData.selectedTimeline;
		var timelineObj = Ext.getCmp('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if (!Ext.isEmpty(timelineRawData)) {
			if (!Ext.isEmpty(selectedTimeline)) {
				timelineObj.setValue(selectedTimeline);
			} else {
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = jsonData.startDate;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = jsonData.startHour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = jsonData.endDate;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = jsonData.endHour;
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		 updatingAppSettings();
		if( Ext.getCmp('showLegend') != undefined){
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
				Ext.getCmp('showLegend').setValue(true);
		}
	},
	reportGenChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType = Ext.getCmp('reportGeneration').getValue();
		if (reportGenType == 'background') {
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if (reportGenType == 'background-csv') {
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}else {
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	timeLineOnChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var startDateObj = Ext.getCmp('er_stdate');
		var startHrObj = Ext.getCmp('er_sthr');
		var endDateObj = Ext.getCmp('er_enddate');
		var endHrObj = Ext.getCmp('er_endhr');
		var timelineObj = Ext.getCmp('er_timeline');
		if (timelineObj.getValue() == 'Any') {
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		} else {
			timelineObj.suspendEvents(true);
			this.updateQueryString();
			var QString = appConstants.queryString + firstMeasureDetails + secondMeasureDetails;
			Ext.Ajax.request({
				url: '/final/reporter/ErVirtualDataCenterJson.jsp',
				params: QString,
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.publicjsonData = jsonData;
					var start_hour = jsonData.startHour;
					var end_hour = jsonData.endHour;
					var start_date = jsonData.startDate;
					var end_date = jsonData.endDate;
					startDateObj.setDisabled(true);
					startHrObj.setDisabled(true);
					endDateObj.setDisabled(true);
					endHrObj.setDisabled(true);
					startDateObj.setValue(start_date);
					startHrObj.setValue(start_hour);
					endDateObj.setValue(end_date);
					endHrObj.setValue(end_hour);
				}
			});
			timelineObj.resumeEvents();
		}
	},
	/* weekendOnChange: function () {
		var weekendvalue = Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj = Ext.getCmp('excludeDays');
		if (weekendvalue == 'Yes') {
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonData.screenLabels['MappedExcludeDays']);
		} else {
			excludeDaysObj.hide();
		}
	}, */
		favSaveButton :function(){
		 var from_schedule = appConstants.publicjsonData['hiddenfields']['fromScheduleModify'];
		var fromFavoriteModify = appConstants.publicjsonData['hiddenfields']["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
	},
	disableTools: function () {
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	getDecimalAlignFormat:function(value)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
	});
