Ext.define('VDataCenter.view.Miscellaneous', {
	extend: 'Ext.form.FieldContainer',
	alias: 'widget.miscellaneous',
	layout: {
		type: 'column'
	},
	defaults: {
		labelSeparator: '',
		labelAlign: 'top',
		cls: 'dropdown',
		margin: 10,
		editable: false
	},
	items: [
		{
			xtype: 'scrollcombo',
			width: 90,
 			labelStyle: 'white-space: nowrap',
			fieldLabel: 'Show Data',
			id: 'er_trenddata',
			name: 'er_trenddata',
			store: Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			defaultListConfig: {
				loadingHeight: 70,
				minWidth: 100,
				maxHeight: 300,
				shadow: 'sides'
			},
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		}, 
		{
			xtype: 'fieldcontainer',
 			fieldLabel: 'Filter by',
			id: 'Filterlable',
			labelAlign: 'top',
			layout: 'column',
			defaults: {
				width: 90
			},
			items: [
				{
					xtype: 'scrollcombo',
					id: 'er_filter',
					name: 'er_filter',
					margin: '0 20 0 0',
					store: Ext.data.Store({
						fields: ['displayField', 'valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local'
				}, 
				{
					xtype: 'scrollcombo',
					id: 'er_top',
					margin: '0 20 0 0',
					name: 'er_top',
					store: Ext.data.Store({
						fields: ['displayField', 'valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					hidden:false
				},
				{
					xtype:'textfield',
					cls: 'textbox',
					id:'valueToFilter',
 					hidden:true,
					margin: '0 20 0 0'
				},
				{
					xtype:'container',
					layout:'hbox',
					id:'er_range',
					width:150,
					margin: '0 10 0 0',
					hidden:true,
					items:[
						{
							xtype:'label',
							margin: '3 5 0 0',
							text:'From'
						},
						{
							xtype:'textfield',
							cls: 'textbox',
							id:'minRange',
							width:40,
							margin: '0 10 0 0'
 						},
						{
							xtype:'label',
							margin: '3 5 0 0',
							text:'to'
						},
						{
							xtype:'textfield',
							cls: 'textbox',
							id:'maxRange',
							width:40,
							margin: '0 0 0 0'
						}
					]
				}
			]
		}
	]
});