Ext.define('VDataStorage.controller.Main',{
	extend:'Ext.app.Controller',
	requires:[
		'VDataStorage.view.Main'
	],
	refs:[
		{ref:'main',selector:'main'},
		{selector : 'newUtilities',ref : 'newUtilities'},
		{selector:'vdatastoragemainform', ref:'vdatastoragemainform'},
		{selector: 'vdatastoragesettings', ref: 'vdatastoragesettings'},
		{selector: 'graphdata', ref: 'graphdata'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'main newUtilities' :
			{
				'afterrender': this.hideTools
			},
			'main ':
			{
				'boxready': this.loadDefaults
			},
			'vdatastoragesettings':
			{
				'afterrender': this.loadSettings
			},
			'vdatastoragesettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'vdatastoragemainform combo[id="er_type_proc"]':
			{
				'select': this.changeReportType
			},
			'vdatastoragemainform combo[id="er_comptype"]':
			{
				'select': this.changeComponentType
 			},
			'vdatastoragemainform combo[id="select_group"]':
			{
				'select': this.changeAnalysis
			},
			'egcomponent button[id="expandSelector"]':{
				'click': this.expandMe
			},
			'egcomponent boundlist[id="componentsSelector"]':
			{
				'itemclick': this.changeComponent
			},
			/*'vdatastoragesettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekend
			},*/
			'vdatastoragemainform combo[id="er_trenddata"]':
			{
				'select': this.changeShowData
			},
			'vdatastoragemainform combo[id="ermeasuretest"]':
			{
				'select': this.changeMeasure
			},
			'vdatastoragesettings combo[id="ervaluetest"]':
			{
				'select': this.changeShow
			},
			'vdatastoragesettings combo[id="er_showby"]':
			{
				'select': this.changeLimit
			},
			'mainform button[itemId="submit"]':
			{
				'click': this.formSubmit
			},
			'mainform button[itemId="save"]':
			{
				'click': this.goTo
			},
			'timeline combo[name="er_mode"]':
            {
              'select': this.changeEr_mode
            },
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.callData
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});

	},
   showConfigDropdown: function () {
		isSettingsEnabled = true;

      var tpl = new Ext.XTemplate(
         '<div style="float:left;margin:0px 0px 0px 0px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
      //config dropdown mode
      Ext.create('Ext.container.Container', {
			width:565,
			id: 'configMod',
			//cls: 'configMode_popup',
			ui:'settingsWindowContainer',
			//padding:5,
			items: [
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'355px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						cls:'containerHeader',
						style:{'top':'0px','margin':'0px'}
					},
					{
						xtype : 'vdatastoragesettings',
						parent:this
					}
         ],
         renderTo: 'vdatastorage'
      });
	  Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			me.validateAndCloseSettings();
		});

   },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('select_groupName'),appConstants.rawDataForComponents);
    },
    changeEr_mode: function (combo) {
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.formSubmit(Ext.getCmp('mainform').getComponent('submit'));
		//this.formSubmit(Ext.getCmp('submit'));
     },
	goTo: function (btn) {
if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Virtualization Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}	
		var hiddenFields =  appConstants.publicJSON['hiddens'];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites(btn);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.showSchedules(btn);
		}
    },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showFavorites: function( obj )
	{
		this.formSubmit( obj );
		var hiddenFields =  appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
		var target = '/final/servlet/com.eg.ErFavoriteC?'+appConstants.queryString+'&isSubmit=true&cmd=client&er_view=GRAPH&er_rtype=Virtualization'+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId='+favorite_id;
 		//Ext.widget('favouriteWindow').show();
		//Ext.select('#favWin').set({src :target});
		if (obj.getItemId()=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	showSchedules: function( obj )
	{
		this.formSubmit( obj );
		var target= '/final/reporter/ErSaveSchedule.jsp?'+appConstants.queryString+'&er_rtype=Virtualization&com.eg.CSRF_NONCE='+csrfToken;
		if (obj.getItemId()=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	callData: function()
	{
		document.location='/final/servlet/egurkha.reporter.SaveInCSVFormat';
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	printMe: function()
	{

		parent.printWindowFn( appConstants.publicJSON['PRINT_URL']+'&pdfPrint=yes'); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		/*Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  appConstants.publicJSON['PRINT_URL']
		});

		 printWindow.on('show',function(){
       // var s_qryString = "YOUR QUERY"  //query string to load the popup
        var printContentDiv = parent.Ext.select('#printContentDiv1');  // id of the popup window
                    printContentDiv.set({
                        src: s_qryString
                    });
           });
         printWindow.show();*/

	},
	saveMe: function()
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF('/final/reporter/ErHtmlToSavePdf.jsp?pageWidthProces='+appConstants.publicJSON['pageWidthProces']+'&'+appConstants.publicJSON['PDF_URL']);
	},
	bookletQuery: function(obj)
	{
		return appConstants.publicJSON['PDF_URL'];
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString+'&er_rtype=Virtualization'
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	hideTools : function() {
		this.getNewUtilities().loadIcon(true, // save
				true, // print
				true, // mail
				false, // data
				true, // csv
				true, // fav
				true,// schedule
				false, // daignosis
				false, // togglebutton
				false, // close
				true // booklet
				);
				//Ext.getCmp("upbutton").hide();
		this.disableTools();
	},
	disableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		if ( Ext.getCmp('er_type_proc').getValue() == 'No' )
		{
			Ext.getCmp("csvTool").setDisabled(false);
		}
		else
		{
			Ext.getCmp("csvTool").setDisabled(true);
		}
		//Ext.getCmp("upbutton").setDisabled(false);
	},
	loadSettings: function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
 		var settingsForm = this.getVdatastoragesettings().getForm();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		settingsForm.findField('reportGeneration').setFieldLabel(screenLabels['reporter.consolidated.reportGeneration']);
		settingsForm.findField('bgReportName').setFieldLabel(screenLabels['reportName']);

		Ext.getCmp('timeperiodLbl').setText(screenLabels['timePeriod']);
		Ext.getCmp('fromTimeLbl').setText(screenLabels['timeperiodfrom']);
		Ext.getCmp('toTimeLbl').setText(screenLabels['timeperiodto']);
		Ext.getCmp('fromHrsLbl').setText(screenLabels['timeperiodfromhours']);
		Ext.getCmp('toHrsLbl').setText(screenLabels['timeperiodfromhours']);
		Ext.getCmp('fromMinsLbl').setText(screenLabels['timeperiodfrommins']);
		Ext.getCmp('toMinsLbl').setText(screenLabels['timeperiodfrommins']);
		var selectedData = appConstants.publicJSON['selectedValues'];

		settingsForm.findField('er_excwe').setFieldLabel(screenLabels['excludeWeekend']);
		settingsForm.findField('ervaluetest').setFieldLabel(screenLabels['show']);
		settingsForm.findField('er_showby').setFieldLabel(screenLabels['limit']);

		var excludeWeekendComboData = appConstants.publicJSON['excludeWeekendCombo'];
		var excludeWeekendSelected = selectedData['excludeWeekendSelected'];
		if ( !Ext.isEmpty( excludeWeekendComboData ) && !Ext.isEmpty( excludeWeekendSelected ) )
		{
			this.setValueWithOptionInList(settingsForm, 'er_excwe', excludeWeekendComboData, excludeWeekendSelected);
			//this.changeExcludeWeekend();
		}

		var showComboData = appConstants.publicJSON['showCombo'];
		var showSelected = selectedData['showSelected'];
		if ( !Ext.isEmpty( showComboData ) )
		{
			this.setValueWithOptionInList(settingsForm, 'ervaluetest', showComboData, showSelected);
			this.changeShow();
		}
		var limitComboData = appConstants.publicJSON['limitCombo'];
		var limitSelected = selectedData['limitSelected'];
		if ( !Ext.isEmpty( limitComboData ) )
		{
			this.setValueWithOptionInList(settingsForm, 'er_showby', limitComboData, limitSelected);
			this.changeLimit();
		}




		settingsForm.findField('timefrom').setValue(selectedData['fromHrSelected']);
		settingsForm.findField('minfrom').setValue(selectedData['fromMinSelected']);
		settingsForm.findField('timeto').setValue(selectedData['toHrSelected']);
		settingsForm.findField('minto').setValue(selectedData['toMinSelected']);
		var repoMaking ="";
		if (appConstants.repoGene!=undefined)
		{
			repoMaking=appConstants.repoGene;
		}
		else
		{
			repoMaking=appConstants.publicJSON;
		}

		var reportGenerationData = repoMaking['reportGenCombo'];
		var reportGenSelected = selectedData['reportGenSelected'];
		if ( !Ext.isEmpty( reportGenerationData ) )
		{
			this.setValueWithOptionInList( settingsForm, 'reportGeneration', reportGenerationData, reportGenSelected);
			this.changeReportGeneration();
		}
		var reportName = appConstants.publicJSON['reportName'];
		if ( !Ext.isEmpty( reportName ) )
		{
			Ext.getCmp('bgReportName').setValue(reportName);
		}

	},
	changeReportGeneration: function( obj )
	{
		var reportGenVal = Ext.getCmp('reportGeneration').getValue();
		var bgReportObj = Ext.getCmp('bgReportName');
		if ( reportGenVal == 'background' )
		{
			bgReportObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if ( reportGenVal == 'background-csv' )
		{
			bgReportObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			bgReportObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeTimeline: function( obj )
	{
		var getTimelineVal = Ext.getCmp('er_timeline').getValue();
		var stDateObj = Ext.getCmp('er_stdate');
		var endDateObj = Ext.getCmp('er_enddate');
		var stHrObj = Ext.getCmp('er_sthr');
		var endHrObj = Ext.getCmp('er_endhr');
		if ( getTimelineVal == 'Any' )
		{
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
		}
	},
	validateAndCloseSettings:function()
	{
	   
			var result = true;
			var reportGenVal = Ext.getCmp('reportGeneration').getValue();
			if ( reportGenVal == 'background'||reportGenVal == 'background-csv')
			{
				var reportName = Ext.getCmp('bgReportName').getValue();
				var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
				if ( !ret )
				{
					Ext.getCmp('bgRepo rtName').focus();
					result = false;
				}
				else
				{
					result = true;
				}
				var timeFrom = Ext.getCmp('timefrom').getValue();
				var minFrom = Ext.getCmp('minfrom').getValue();
				var timeTo = Ext.getCmp('timeto').getValue();
				var minTo = Ext.getCmp('minto').getValue();
				if ( !checkTimePeriod(timeFrom, minFrom, timeTo, minTo ) )
				{
					result = false;
				}
			}
			if ( !result )
			{
				return;
			}
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return result;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.formSubmit(Ext.getCmp('mainform').getComponent('submit'));
		}
	},
	validateSettings: function(flag)
	{
		var hiddenJSON = appConstants.publicJSON['hiddens'];
		var er_usertimeline = hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg = hiddenJSON['limitforbg'];
		var reportgenVal = appConstants.publicJSON.selectedValues['reportGenSelected'];
		if (isSettingsEnabled)
		{
			reportgenVal = Ext.getCmp('reportGeneration').getValue();
		}
		if ( reportgenVal == 'foreground' )
		{
			if(flag)
			{
				if ( !Ext.isEmpty(limitforbg ) )
				{
					if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
					} else
						this.generateResult();
				}else
					this.generateResult();
			}
			else
				this.generateResult();
		} else {
				var reportName = Ext.getCmp('bgReportName').getValue();
				var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
				if ( !ret )
				{
					Ext.getCmp('bgReportName').focus();
					return;
				} else
					this.generateResult();
			}

	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			//var getButtonObj = Ext.getCmp('submit');
			//getButtonObj.setDisabled(false);
			this.generateResult();
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('bgReportName').focus(false, 1000);
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			return false;
		}
	},
	loadDefaults:function()
	{
		if(!hideBackButton){
			Ext.getCmp('vdatastoragemainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJSON['ID']
				}
			);
		}
		//this.loadPage();
		this.hideResult();
		var mainForm = this.getVdatastoragemainform().getForm();
		//var settingsForm = this.getVdatastoragesettings().getForm();

		var title = appConstants.publicJSON['TITLE'];
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(title);

		var screenLabels = appConstants.publicJSON['screenLabels'];
		this.loadScreenLabels(screenLabels);

		var hiddenFields = appConstants.publicJSON['hiddens'];
	        var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			//Ext.getCmp("submit").hide();
			//Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			//Ext.getCmp("submit").show();
			//Ext.getCmp("save").hide();
		}
		var selectedData = appConstants.publicJSON['selectedValues'];

		var reportTypeComboData = appConstants.publicJSON['reportTypeCombo'];
		var reportTypeComboSelected = selectedData['reportTypeSelected'];
		if ( !Ext.isEmpty( reportTypeComboData ) )
		{
			this.setValueWithOptionInList( mainForm, 'er_type_proc', reportTypeComboData, reportTypeComboSelected);
			this.changeReportType();
		}

		var compTypeComboData = appConstants.publicJSON['compTypeCombo'];
		var compTypeComboSelected = selectedData['compTypeSelected'];
		if ( !Ext.isEmpty( compTypeComboData ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_comptype', compTypeComboData, compTypeComboSelected);
			this.changeComponentType();
		}

		var analysisComboData = appConstants.publicJSON['analysisCombo'];
		var analysisComboSelected = selectedData['analysisComboSelected'];
		if ( !Ext.isEmpty( analysisComboData ) )
		{
			this.setValueWithOptionInList(mainForm, 'select_group', analysisComboData, analysisComboSelected);
			this.changeAnalysis();
		}

		var selectGrpComboData = appConstants.publicJSON['selectGrpCombo'];
		appConstants.rawDataForComponents = selectGrpComboData;
		var selectGrpSelected = selectedData['selectGrpSelected'];
		if ( !Ext.isEmpty( selectGrpComboData ) )
		{
			var toLoadField = 'select_groupName';
			if ( analysisComboSelected != 'Component' )
			{
				toLoadField = analysisComboSelected.toLowerCase();
				if ( analysisComboSelected == 'Zone' )
				{
					var includeSubZoneData = appConstants.publicJSON['subzoneCombo'];
					var subzoneSelected = selectedData['subzoneSelected'];
					this.setValueWithOptionInList(mainForm, 'subzone', includeSubZoneData, subzoneSelected);
				}
			}
			this.setValueWithOptionInList(mainForm, toLoadField, selectGrpComboData, selectGrpSelected);
			this.changeComponent();
		}
		else
		{
			Ext.getCmp('select_groupName').getStore().insert(0,{'valueField':'-1','displayField': appConstants.notApplicable});
			Ext.getCmp('select_groupName').setValue('-1');

		}


		var showDataComboData = appConstants.publicJSON['showDataCombo'];
		var showDataSelected = selectedData['showDataSelected'];
		if ( !Ext.isEmpty( showDataComboData ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_trenddata', showDataComboData, showDataSelected);
			this.changeShowData();
		}
		var measureComboData = appConstants.publicJSON['measureCombo'];
		var measureSelected = selectedData['measureSelected'];
		if ( !Ext.isEmpty( measureComboData ) )
		{
			this.setValueWithOptionInList(mainForm, 'ermeasuretest', measureComboData, measureSelected);
			this.changeMeasure();
		}
		var timelineComboData = appConstants.publicJSON['timelineCombo'];
		var selectedTimeline = selectedData['selectedTimeline'];
		if ( !Ext.isEmpty( timelineComboData ) )
		{
			this.setValueWithOptionInList( mainForm, 'er_timeline', timelineComboData, selectedTimeline);
			this.changeTimeline();
		}
		var startDateData = selectedData['startDate'];
		var endDateData = selectedData['endDate'];
		mainForm.findField('er_stdate').setValue(startDateData);
		mainForm.findField('er_enddate').setValue(endDateData);

		var timelineHourComboData = appConstants.publicJSON['timelineHourCombo'];
		var startDateData = selectedData['startDate'];
		var endDateData = selectedData['endDate'];
		mainForm.findField('er_stdate').setValue(appConstants.publicJSON.startDateForDisplay);
		mainForm.findField('er_stdate').dataArray = startDateData;
		mainForm.findField('er_enddate').setValue(appConstants.publicJSON.endDateForDisplay);
		mainForm.findField('er_enddate').dataArray = endDateData;

		var timelineHourComboData = appConstants.publicJSON['timelineHourCombo'];
		var startHourSelected = selectedData['startHour'];
		var endHourSelected = selectedData['endHour'];
		mainForm.findField('er_sthr').setValue(appConstants.publicJSON.startHourForDisplay);
		mainForm.findField('er_sthr').dataArray = startHourSelected;
		mainForm.findField('er_endhr').setValue(appConstants.publicJSON.endHourForDisplay);
		mainForm.findField('er_endhr').dataArray = endHourSelected;
		mgr_stmin = selectedData['startmin'];
		mgr_enmin = selectedData['endmin'];
		var selectedGraphMode = selectedData['selectedGraphMode'];
		mainForm.findField('er_mode').setValue(selectedGraphMode);
		 updatingAppSettings();


		var resultData = appConstants.publicJSON['RESULTS'];
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		var trendenablee=hiddenFields['trendenable'];
		if(trendenablee == 'false')
		{
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}
		if ( !Ext.isEmpty( resultData ) && from_favorite == null)
		{
			this.getGraphdata().show();
			var reportgenVal = appConstants.publicJSON.selectedValues['reportGenSelected'];
			if (isSettingsEnabled)
			{
				reportgenVal = Ext.getCmp('reportGeneration').getValue();
			}
			if ( reportgenVal == 'foreground' )
			{
				if ( reportTypeComboSelected == 'Yes' )
				{
					this.loadCharts( resultData );
				}
				else
				{
					this.loadGrid( resultData );
				}
				Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
				this.enableTools();
			}
			else
			{
				resultData = appConstants.publicJSON['backgroundResults'];
				this.loadBackground(resultData);
			}
		}
		if(appConstants.isForceSubmit=='true')
		{
			appConstants.isForceSubmit='false';
			this.formSubmit(Ext.getCmp('mainform').getComponent('submit'));
		}
	},
	changeLimit: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeShow: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	loadScreenLabels: function( screenLabels )
	{
		var mainForm = this.getVdatastoragemainform().getForm();
		//var settingsForm = this.getVdatastoragesettings().getForm();
		mainForm.findField('er_type_proc').setFieldLabel(screenLabels['reportType']);
		mainForm.findField('er_comptype').setFieldLabel(screenLabels['componentType']);
		mainForm.findField('select_group').setFieldLabel(screenLabels['analysisBy']);
		mainForm.findField('er_trenddata').setFieldLabel( screenLabels['showData']);
		Ext.getCmp('compLbl').setText( screenLabels['Component']);
		mainForm.findField('zone').setFieldLabel(appConstants.zoneLbl);
		mainForm.findField('segment').setFieldLabel(appConstants.segmentLbl);
		mainForm.findField('service').setFieldLabel(appConstants.serviceLbl);
		mainForm.findField('subzone').setFieldLabel(appConstants.subzoneLbl);
		mainForm.findField('ermeasuretest').setFieldLabel(screenLabels['measure']);
	},
	changeMeasure: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeShowData: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
		}
	},
	/*changeExcludeWeekend: function( obj )
	{
		if ( Ext.getCmp('er_excwe').getValue() == 'Yes' )
		{
			var param = 'F=getExcucludeWeekend&C=jsrs1&P0=[VIRTUAL_DATASTORE]&U='+new Date().getTime()+'&fromajax=true';
			Ext.Ajax.request({
				url: '/final/servlet/ErRemoteScriptingServlet',
				params: param,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText )
						var values = jsonData['values'];
						Ext.getCmp('er_excwe_result').update('Excludes	'+values);
					}
				}
			});
		}
		else
		{
		//	Ext.getCmp('er_excwe_result').update('');
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},*/
	changeComponent: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeAnalysis: function( obj )
	{
		var getAnalysisVal = Ext.getCmp('select_group').getValue();
		var zoneObj = Ext.getCmp('zone');
		var subzoneObj = Ext.getCmp('subzone');
		var segmentObj = Ext.getCmp('segment');
		var serviceObj = Ext.getCmp('service');
		var componentObj = Ext.getCmp('component');
		if ( getAnalysisVal == 'Zone' )
		{
			zoneObj.show();
			subzoneObj.show();
			segmentObj.hide();
			serviceObj.hide();
			componentObj.hide();
		}
		else if ( getAnalysisVal == 'Segment' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.show();
			serviceObj.hide();
			componentObj.hide();
		}
		else if ( getAnalysisVal == 'Service' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.hide();
			serviceObj.show();
			componentObj.hide();
		}
		else
		{
			zoneObj.hide();
			subzoneObj.hide();
			segmentObj.hide();
			serviceObj.hide();
			componentObj.show();
		}
		if ( !Ext.isEmpty( obj ) )
		{
			var getVal = (obj.getValue()).toLowerCase();
			if ( getVal != 'component' )
			{
				Ext.getCmp(getVal).setValue('Loading...');
			}
			this.formSubmit( obj );
			this.hideResult();
		}
	},
	checkComponentType: function( obj , newVal, oldVal )
	{
		if ( newVal == '-1' )
		{
			Ext.getCmp('er_comptype').setValue(oldVal)
		}
	},
	changeComponentType: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
			this.formSubmit( obj );
		}
	},
	changeReportType: function( obj )
	{
		var getReportVal = Ext.getCmp('er_type_proc').getValue();
		if (!isSettingsEnabled)
		{
			this.showConfigDropdown();
		}
		else
		{
			Ext.Ajax.request({
			url:'/final/reporter/ErEsxStoreReportJSON.jsp?er_type_proc='+getReportVal+'&ervm_type_proc='+appConstants.ervm_type_proc,
			params: appConstants.queryString,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					appConstants.repoGene = jsonData;
					console.log(jsonData);
					var repogenerationObj = Ext.getCmp("reportGeneration");
					var repoComboload = jsonData.reportGenCombo;
					var setrepogen = repoComboload[0].valueField;
					repogenerationObj.getStore().loadRawData(repoComboload);
					repogenerationObj.setValue(setrepogen);
					var compTypeObj = Ext.getCmp("er_comptype");
					var compTypeComboLoad = jsonData.compTypeCombo;
					var strCompType = compTypeComboLoad[0].valueField;
					compTypeObj.getStore().loadRawData(compTypeComboLoad);
					compTypeObj.setValue(strCompType);
					var bgreportnameObj = Ext.getCmp("bgReportName");
					if (setrepogen!=undefined && setrepogen=='foreground')
					{
						bgreportnameObj.hide();
					}
					else
					{
						bgreportnameObj.show();
					}
				}
			}
			});
		}
		var showObj = Ext.getCmp('er_showby');
		if ( getReportVal == 'Yes' )
		{
			Ext.getCmp('ervaluetest').show();
			showObj.show();
			Ext.getCmp('ermeasuretest').setFieldLabel('Measure');
			//Ext.getCmp("er_mode").show();
		}
		else
		{
			Ext.getCmp('ervaluetest').hide();
			showObj.hide();
			Ext.getCmp('ermeasuretest').setFieldLabel('Sort By');
			// Ext.getCmp("er_mode").hide();
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	hideResult: function()
	{
		this.getGraphdata().hide();
		this.disableTools();
	},
	getHiddenQstr: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}

			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	checkValidate: function()
	{
		var selGp = Ext.getCmp('select_group').getValue();
		var getAnalysisVal = '';
		if(selGp!=null)
		{
			getAnalysisVal = selGp.toLowerCase();
		}
		var msg = '';
		if ( getAnalysisVal != 'component' )
		{
			if (getAnalysisVal == '-1' )
			{
				if ( getAnalysisVal == 'zone' )
				{
					msg = appConstants.chooseZone;
				}
				else if ( getAnalysisVal == 'segment' )
				{
					msg = appConstants.chooseSegment;
				}
				else if ( getAnalysisVal == 'service' )
				{
					msg = appConstants.chooseService;
				}
				else
				{
					msg = 'No selection to choose';
				}
			}
		}
		else
		{
			
			
			if ( Ext.getCmp('select_groupName').getStore().getAt(0).get('displayField').indexOf('Not')!= -1 )
			{
				msg = appConstants.chooseComp;
			}
		}
		if ( !Ext.isEmpty( msg ) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			return true;
		}
	},
	formSubmit: function( obj )
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);

		var startdate = Ext.getCmp('er_stdate').getValue();
		var starthr = Ext.getCmp('er_sthr').getValue();
		startdate.setHours(starthr);
		var enddate = Ext.getCmp('er_enddate').getValue();
		var endhr = Ext.getCmp('er_endhr').getValue();
		enddate.setHours(endhr);
		var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }if ( !Ext.isEmpty( obj ) )
		{
			if (obj.getItemId()=='submit')
			{
				appConstants.actionFrom = obj.getItemId();
			}
			else
			appConstants.actionFrom = obj.getId();
		}
		var objVal=obj.getItemId();
		if(objVal=="favImg" || objVal=="scheduleImg" )
			this.validateSettings(false);
		else
			this.validateSettings(true);
	},
	generateResult :function() {
		var me = this;
		var mainForm = this.getVdatastoragemainform().getForm();

		var fromReportType = false;
		var fromCompType = false;
		var fromAnalysis = false;
		var fromTimeline = false;
		var fromShowData = false;
		var isSubmit = false;
		var isFav = false;
		var isSch= false;
		var qstr = '';

		if ( appConstants.actionFrom == 'er_comptype' )
		{
			fromCompType = true;
		}
		else if ( appConstants.actionFrom == 'select_group' )
		{
			fromAnalysis = true;
		}
		else if ( appConstants.actionFrom == 'er_type_proc' )
		{
			fromReportType = true;
		}
		else if ( appConstants.actionFrom == 'er_timeline' )
		{
			fromTimeline = true;
		}
		else if ( appConstants.actionFrom == 'er_trenddata' )
		{
			fromShowData = true;
		}
		else if ( appConstants.actionFrom == 'submit' )
		{
			if ( !this.checkValidate() )
			{
				return;
			}
			appConstants.initLdgMask.show();
			isSubmit = true;
		}
		if ( appConstants.actionFrom == 'favoriteTool' || appConstants.actionFrom == 'favImg' )
		{
			isFav = true;
		}
		else if ( appConstants.actionFrom == 'scheduleImg' || appConstants.actionFrom == 'scheduleTool' )
		{
			isSch = true;
		}
		qstr +=  this.getHiddenQstr();

		var er_type_procVal = mainForm.findField('er_type_proc').getValue();
		var er_comptypeVal = mainForm.findField('er_comptype').getValue();
		var er_modeVal = mainForm.findField('er_mode').getValue();

		var selectedData = appConstants.publicJSON['selectedValues'];
		var er_reportgenrationVal = appConstants.publicJSON.selectedValues['reportGenSelected'];
		var minfromVal = selectedData['fromMinSelected'];
		var mintoVal = selectedData['toMinSelected'];
		var timefromVal = selectedData['fromHrSelected'];
		var timetoVal = selectedData['toHrSelected'];
		var bgReportName = '';
		var er_excweVal=selectedData['excludeWeekendSelected'];
		var er_showbyVal=selectedData['limitSelected'];
 		var ervaluetestVal=selectedData['showSelected'];
		if (isSettingsEnabled)
		{
			var settingsForm = this.getVdatastoragesettings().getForm();
			er_reportgenrationVal = Ext.getCmp('reportGeneration').getValue();
			minfromVal = settingsForm.findField('minfrom').getValue();
			mintoVal = settingsForm.findField('minto').getValue();
			timefromVal = settingsForm.findField('timefrom').getValue();
			timetoVal = settingsForm.findField('timeto').getValue();
			bgReportName = settingsForm.findField('bgReportName').getValue();
			er_excweVal = settingsForm.findField('er_excwe').getValue();
			er_showbyVal = settingsForm.findField('er_showby').getValue();
			
			ervaluetestVal = settingsForm.findField('ervaluetest').getValue();
			bgReportName=checkFileName(bgReportName);
 		}
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var er_trenddataVal = mainForm.findField('er_trenddata').getValue();
		var ermeasuretestVal = mainForm.findField('ermeasuretest').getValue();
		var inszoneVal = mainForm.findField('subzone').getValue();
		var select_groupVal = mainForm.findField('select_group').getValue();
		var select_groupNameVal = '';
		if (select_groupVal!=null && select_groupVal != 'Component')
		{
			select_groupNameVal = Ext.getCmp(select_groupVal.toLowerCase()).getValue();
		}
		else
		{
			var compArray = Ext.getCmp('select_groupName').getValue()
			select_groupNameVal = "";
			for(var k=0;compArray.length>k;k++)
			{
				if(k==0)
					select_groupNameVal=compArray[k];
				else
					select_groupNameVal+="&select_groupName="+compArray[k];
			}
		}

		qstr += '&er_type_proc='+encodeURI(er_type_procVal)+'&er_comptype='+encodeURI(er_comptypeVal)+'&er_excwe='+encodeURI(er_excweVal)+'&er_mode='+encodeURI(er_modeVal)
				+'&er_reportgenration='+encodeURI(er_reportgenrationVal)+'&bg_reportname='+encodeURI(bgReportName)+'&er_showby='+encodeURIComponent(er_showbyVal)
				+'&er_timeline='+encodeURI(er_timelineVal)+'&er_trenddata='+encodeURI(er_trenddataVal)+'&ermeasuretest='+encodeURI(ermeasuretestVal)
				+'&ervaluetest='+encodeURI(ervaluetestVal)+'&inszone='+encodeURI(inszoneVal)+'&minfrom='+encodeURI(minfromVal)
				+'&minto='+encodeURI(mintoVal)+'&select_group='+encodeURI(select_groupVal)+'&select_groupName='+encodeURI(select_groupNameVal)
				+'&timefrom='+encodeURI(timefromVal)+'&timeto='+encodeURI(timetoVal)+'&ersortby=-1'+ "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&stmin="+mgr_stmin+"&enmin="+mgr_enmin+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;

		var URL = '/final/reporter/ErEsxStoreReportJSON.jsp';
		if ( isSubmit )
		{
			URL = '/final/servlet/com.eg.ErEsxStoreServerReportC';
			if ( er_reportgenrationVal == 'background' )
			{
				URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				qstr += '&forwardto=ErEsxStoreReportJSON';
			}
			else if ( er_reportgenrationVal == 'background-csv' )
			{
				URL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				qstr += '&forwardto=ErEsxStoreReportJSON';
			}
			qstr += '&isSubmit=true';
		}
		qstr+="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString = qstr;
		if ( isFav  )
		{
			appConstants.queryString += '&call=json';
		}

		if ( isFav || isSch )
		{
			return;
		}
		if ( !Ext.isEmpty(appConstants.fromSchedule) && appConstants.fromSchedule == 'Yes' && isSubmit )
		{
			document.location = '/final/reporter/ErSaveSchedule.jsp?'+qstr+'&er_rtype=Virtualization';
		}

		var hiddenFields = appConstants.publicJSON['hiddens'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		qstr += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
		qstr += '&call=json';

		Ext.Ajax.request({
			url: URL,
			params: qstr,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					appConstants.publicJSON = jsonData;
					var selectedData = jsonData['selectedValues'];
					if ( fromCompType )
					{
						var selectGrpComboData = jsonData['selectGrpCombo'];
						appConstants.rawDataForComponents = selectGrpComboData;
						var selectGrpSelected = selectedData['selectGrpSelected'];

						if ( !Ext.isEmpty( selectGrpComboData ) )
						{
							me.setValueWithOptionInList( mainForm, 'select_groupName', selectGrpComboData, selectGrpSelected);
						}
						var measureComboData = jsonData['measureCombo'];
						var measureSelected = selectedData['measureSelected'];
						if ( !Ext.isEmpty( measureComboData ) )
						{
							me.setValueWithOptionInList( mainForm, 'ermeasuretest', measureComboData, measureSelected);
						}
					}
					else if ( fromAnalysis )
					{
						var selectGrpComboData = jsonData['selectGrpCombo'];
						var selectGrpSelected = selectedData['selectGrpSelected'];

						var fieldToLoad = '';
						if ( select_groupVal == 'Zone' )
						{
							fieldToLoad = 'zone';
							var subzoneComboData = jsonData['subzoneCombo'];
							var subzoneSelected = selectedData['subzoneSelected'];
							me.setValueWithOptionInList( mainForm, 'subzone', subzoneComboData, subzoneSelected);
						}
						else if ( select_groupVal == 'Segment' )
						{
							fieldToLoad = 'segment';
						}
						else if ( select_groupVal == 'Service' )
						{
							fieldToLoad = 'service';
						}
						else
						{
							fieldToLoad = 'select_groupName';
						}
						if ( !Ext.isEmpty( selectGrpComboData ) )
						{
							me.setValueWithOptionInList( mainForm, fieldToLoad, selectGrpComboData, selectGrpSelected);
							if ( fieldToLoad == 'select_groupName' )
							{
								var selArr = new Array();
								for ( var i = 0;i < selectGrpComboData.length;i++ )
								{
									selArr[selArr.length] = selectGrpComboData[i]['valueField'];
								}
								Ext.getCmp('select_groupName').setValue(selArr);
							}
						}
					}
					else if ( fromReportType )
					{
						var measureComboData = jsonData['measureCombo'];
						var measureSelected = selectedData['measureSelected'];
						if ( !Ext.isEmpty( measureComboData ) )
						{
							me.setValueWithOptionInList( mainForm, 'ermeasuretest', measureComboData, measureSelected);
						}
					}
					else if ( fromTimeline || fromShowData )
					{
						var startDate = selectedData['startDate'];
						var endDate = selectedData['endDate'];
						var startHour = selectedData['startHour'];
						var endHour = selectedData['endHour'];
						mainForm.findField('er_stdate').setValue(startDate);
						mainForm.findField('er_enddate').setValue(endDate);
						mainForm.findField('er_sthr').setValue(startHour);
						mainForm.findField('er_endhr').setValue(endHour);
					}
					else if ( isSubmit )
					{
						var resultData = jsonData['RESULTS'];
						me.getGraphdata().removeAll();
						me.getGraphdata().show();
						me.getNomeasurepanel().hide();
						me.getBackGroundPanel().hide();
						if ( er_reportgenrationVal == 'foreground' )
						{
							if ( er_type_procVal == 'Yes' )
							{
								me.loadCharts( resultData );
							}
							else
							{
								me.loadGrid( resultData );
							}



						}
						else
						{
							resultData = jsonData['backgroundResults'];
							me.loadBackground(resultData);
						}
						appConstants.initLdgMask.hide();
					}

				}
			}
		});
	},
	loadBackground: function( resultData )
	{
		var backgroundResultsData = resultData;
		 this.getGraphdata().hide();
 		if ( !Ext.isEmpty( backgroundResultsData ) )
		{
 			var backgroundResultStatus = backgroundResultsData['status'];
			var backgroundResponseText = backgroundResultsData['bgroundResponseTxt'];
			var backgroundResultURL = backgroundResultsData['bgroundReportsURL'];
			var backgroundResultURLLinkText = backgroundResultsData['backgroundLinkText'];
			var htmlStr = '';
			if ( backgroundResultStatus == 'success' )
			{
				//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			else if ( backgroundResultStatus == 'duplicate' )
			{
				//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			this.getBackGroundPanel().update(htmlStr);
 			this.getBackGroundPanel().show();
			this.disableTools();
		}
	},
	loadGrid: function( resultData )
	{
		var gridData = '';
		if ( !Ext.isEmpty( resultData ) )
		{
			gridData = resultData['GRID_DATA'];
		}
		var resultObj = this.getGraphdata();
		resultObj.removeAll();
		if ( !Ext.isEmpty( gridData ) )
		{
			var getTitle = gridData['TITLE'];
			//resultObj.setTitle(getTitle);
			//resultObj.getHeader().hide();
			var storeFields = gridData['SUB_COLUMNS'];
			var fieldNames = new Array();
			var gridResults = gridData['GRID_VALUES'];
			for ( var key in storeFields )
			{
				fieldNames[fieldNames.length] = key;
			}
			var outerColumns = gridData['TEST_COLUMNS'];
			var subColumns = gridData['SUB_COLUMNS'];
			var outerColArray = new Array();
			var idx = 0;
			var colIdx = 0;
			for ( var i = 0; i < outerColumns.length; i++ )
			{
				var measures = gridData['MEASURE_COLUMNS'];
				var measureArr = new Array();
				var subColArr = new Array();
				var subColumnsCount = outerColumns[i]['SUB_COLUMNS'];
				subColumnsCount = ( subColumnsCount == 'NONE' )?1:subColumnsCount;
				for( var j = 0; j < subColumnsCount; j++ )
				{
					var subColName = subColumns['COLUMN_'+colIdx];
					subColArr.push(
							{
								header: subColName,
								dataIndex: 'COLUMN_'+colIdx,
								align: 'center',
								sortable: true,
								renderer :function(val, metaData, record, row, col, store, gridView)
								{	
									if(val.indexOf('span')==-1)
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
									//return this.getDecimalAlignFormat(val);
									val = Ext.getCmp('gridId').getDecimalAlignFormat(val,false);
									return val;
								}
							}
						);
					colIdx++;
				}
				if ( i < 2  )
				{
					outerColArray.push(
						{
							header: outerColumns[i]['COLUMN_NAME'],
							dataIndex: 'COLUMN_'+i,
							align: 'left',
							sortable: true,
							width:115,
							locked:true,
							renderer :function(val, metaData, record, row, col, store, gridView)
							{
								if ( !Ext.isEmpty( val['LINK'] ) && !Ext.isEmpty(val['TEXT'] ) )
								{
									var link = val['LINK'];
									var text = val['TEXT'];
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+text+'"';
									return '<a class="anchorLinkDefault" href="javascript:void(0);" onclick="javascript:window.location.href=\''+link+'\'">'+text+'</a>';
									
								}
								else
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
									val = Ext.getCmp('gridId').getDecimalAlignFormat(val,false);
									return val;
								}
							}
						}
					);
				}
				else
				{
					outerColArray.push(
					{
						header: outerColumns[i]['COLUMN_NAME'],
						dataIndex: fieldNames[idx++],
						columns: subColArr,
						locked:false,
					}
					);
				}

			}
			resultObj.add(
			{
				xtype:'panel',
				title:getTitle,
				ui:'newGraphPanel',
				margin:'10 10 10 10',
				items:[{
					xtype: 'customgrid',
				//cls:'gridSkin horizontal-scroll',
					ui:'newGridPanel',
					margin:'0 10 10 10',
					id:'gridId',
					frame:false,
					border:true,
					scroll:true,
					autoScroll:true,
					needtoFixColumn:true,
					store: Ext.data.Store(
							{
								fields: fieldNames,
								data: gridResults
							}),
					columns: outerColArray,
						listeners:{
						render:function(obj){
							Ext.defer(function() {
								//obj.columns[0].setSortState("ASC",true,true);
							},100);
						}
					}
				}]
			});
			this.enableTools();
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);


		resultObj.doLayout();
		}
		else
		{
			resultObj.hide();
			this.getNomeasurepanel().doLayout();
			this.getNomeasurepanel().show();
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
		}
	},
	loadCharts: function( resultData )
	{
		var noChart = true;
		var resultObj = this.getGraphdata();
 		resultObj.removeAll();
		var title = resultData['TITLE'];
		var pieChartResults = resultData['PIE_CHART_RESULTS'];
		var resultArr = new Array();
		var piexmlData = '';
		if ( !Ext.isEmpty( pieChartResults ) )
		{
			var pieChartTitle = pieChartResults['TITLE'];
			var pieSWFPath = pieChartResults['SWF_PATH'];
			piexmlData = pieChartResults['XML_DATA'];
			resultObj.setTitle(title);
			var legendData = pieChartResults['LEGENDS'];
			appConstants.pieHiddens = legendData['PIE_URLS'];
			var pieLabels = legendData['PIE_LABELS'];
			resultArr.push(
				{
					xtype: 'panel',
					//cls:'containerShadow',
					ui:'newGraphPanel',
					id:'leftChartContent',
					title:pieChartTitle,
					columnWidth:0.35,
					height:400,
					header:{
						style:{
							'padding':'10px 10px 0px 10px'
						}
					},
					margin:'0 0 10 10',
					html:''
				}
			);
		}else{
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var barChartData = resultData['BAR_CHART_RESULTS'];
		if ( !Ext.isEmpty( barChartData ) )
		{
			var barTitle = barChartData['TITLE'];
			var barSWFPath = barChartData['SWF_PATH'];
			var barHeight = barChartData['HEIGHT'];
			var barXMLData = barChartData['XML_DATA'];
			if ( !Ext.isEmpty( barChartData ) )
			{
				resultArr.push(
				{
					xtype: 'panel',
					columnWidth:0.65,
					id:'rightChartContent',
					title:barTitle,
					margin:'0 10 10 10',
					height:400,
					header:{
						style:{
							'padding':'10px 10px 0px 10px'
						}
					},
					//cls:'containerShadow',
					ui:'newGraphPanel',
					html:''
				});
			}

			if ( !Ext.isEmpty( barXMLData ) )
			{
				resultObj.getHeader().hide();
 				resultObj.add(
					{
						xtype: 'panel',
						layout:{type:'column',align:'stretch'},
						ui:'multiGraphPanel',
						margin:'10 10 10 10',
						title:title,
						items:resultArr
					}
				);
				appConstants.erUtils.updateBarChart(appConstants.chartType,'',barXMLData,barSWFPath,barChartData,barChartData.chartHeight,barChartData.chartWidth,Ext.getCmp('rightChartContent'))
				if ( !Ext.isEmpty( piexmlData ) )
				{
					appConstants.erUtils.updatePieChart(appConstants.chartType,pieLabels,'COLOR','LINK','LABEL','',piexmlData,pieSWFPath,pieChartResults,Ext.getCmp('leftChartContent'));
					noChart = false;
					this.enableTools();
				}
			}
			else
			{
				resultObj.hide();
				this.getNomeasurepanel().show();
 				Ext.getCmp('panelinsidetoggle').setDisabled(true);
			}
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);

		}
		else
		{
			resultObj.hide();
			this.getNomeasurepanel().show();
 			Ext.getCmp('panelinsidetoggle').setDisabled(true);
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
		}
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{

		var cmp;
		if (fieldName!='select_groupName')
			cmp=form.findField(fieldName);
		else
			cmp=Ext.getCmp(fieldName);


		if ( !Ext.isEmpty( list) )
		{
			cmp.getStore().clearFilter(true); 
			cmp.getStore().loadRawData(list);
		}
 		if( !Ext.isEmpty(value) )
		{
			cmp.setValue(value);

		}
		else
		{
			cmp.setValue(list[0].valueField);
		}
 	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('select_groupName'),Ext.getCmp('compLbl').text,btn);
	},
	getDecimalAlignFormat:function(value)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});