 Ext.define('VDataStorage.view.EgComponent',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.egcomponent',
	layout:'vbox',
	id: 'component',
	name: 'component',
 	items:[
		{
			xtype:'label',
			id: 'compLbl',
			name: 'compLbl',
			text:'Components',
			margin: '0 0 3 0'
		},
		{
			xtype:'container',
			layout:'hbox',
			items:[
						{
							xtype:'container',
							width : 220,
							margin:0,
							items:[
								{
									xype:'container',
									cls:'multisearchlist',
									items:[
										{
											xtype: 'customtrigger',
											emptyText:'Search Components',
											id: 'compSearch'

										}
									]
								},
								{
									xtype: 'multiselectfield',
									hideLabel: true,
									msgTarget: 'side',
									autoScroll: false,
									scroll: false,
									labelAlign: 'left',
									width: 220,
									 height:90,
									id: 'select_groupName',
									name: 'select_groupName',
									allowBlank: false,
									store: Ext.data.Store({
										fields: ['displayField', 'valueField'],
										data: []
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local'
								}
							]
						},
						{
						xtype : 'container',
						margin : '10 0 0 5',
						items : [
							{
								xtype : 'button',
								iconCls : 'iconMultiselectExpand',
								id:'expandSelector',
								listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: 'Components'
										});
									}
								},
								style : {
									background : 'none',
									border : '0px'
								}
							}
						]
				}
			]
		}
	],
	listeners:{
		render:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		show:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		hide:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		}
	},
	toggleSubmitSaveBtn:function(component){

			var mainform=Ext.getCmp('mainform');
			var virtualizationmanagerform=Ext.getCmp('vdatastoragemainform');
			if ( appConstants.publicJSON['hiddens'].fromScheduleModify == "Yes" ||  appConstants.publicJSON['hiddens'].fromFavoriteModify == "Yes")
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					mainform.getComponent('submit').hide();
					virtualizationmanagerform.getComponent('save').show();
					virtualizationmanagerform.getComponent('submit').hide();
				}
				else
				{
					mainform.getComponent('save').show();
					mainform.getComponent('submit').hide();
					virtualizationmanagerform.getComponent('save').hide();
					virtualizationmanagerform.getComponent('submit').hide();
				}
 			}
			else
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					mainform.getComponent('submit').hide();
					virtualizationmanagerform.getComponent('save').hide();
					virtualizationmanagerform.getComponent('submit').show();
				}
				else
				{
					mainform.getComponent('save').hide();
					mainform.getComponent('submit').show();
					virtualizationmanagerform.getComponent('save').hide();
					virtualizationmanagerform.getComponent('submit').hide();
				}
			}
	}
});