Ext.define('VDataStoreReport.controller.Main',{
	extend:'Ext.app.Controller',
	requires:[
		'VDataStoreReport.view.Main'
	],
	refs:[
		{ref:'main',selector:'main'},
		{selector : 'newUtilities',ref : 'newUtilities'},
		{selector: 'vdatastorereportmainform', ref: 'vdatastorereportmainform'},
		{selector: 'vdatastorereportsettings', ref: 'vdatastorereportsettings'},
		{selector: 'datapanel', ref: 'datapanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'main newUtilities' :
			{
				'afterrender': this.hideTools
			},
			'main':
			{
				'boxready': this.loadDefaults
			},
			'vdatastorereportmainform':
			{
				'afterrender': this.afterStoreReportMainFormRender
			},
			'vdatastorereportsettings':
			{
				'afterrender': this.afterSettingsFormRender
			},
			'vdatastorereportsettings combo[id="er_trenddata"]':
			{
				'select': this.changeDetailedTrend
			},
			'vdatastorereportsettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'vdatastorereportmainform combo[id="er_comptype"]':
			{
				'select': this.changeCompType
			},

			'vdatastorereportsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'vdatastorereportsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'vdatastorereportmainform combo[id="er_component"]':
			{
				'select': this.changeVCenter
			},
			'vdatastorereportmainform combo[id="er_cluster"]':
			{
				'select': this.changeCluster
			},
			'vdatastorereportmainform combo[id="er_host"]':
			{
				'select': this.changeHost
			},
			/*'vdatastorereportsettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekEnd
			},*/
			'vdatastorereportmainform button[id="submit"]':
			{
				'click': this.validateSettings
			},
			'vdatastorereportmainform button[id="save"]':
			{
				'click': this.goTo
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.callData
			},
			'vdatastorereportmainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
   showConfigDropdown: function () {
      var tpl = new Ext.XTemplate(
         '<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
      //config dropdown mode
      Ext.create('Ext.container.Container', {
		width:565,
		id: 'configMod',
		//padding:5,
		//cls: 'configMode_popup',
		ui:'settingsWindowContainer',
        items: [
						{
							xtype:'container',
							cls:'configMode_popupArrow',
							style:{'top':'-14px','left':'355px'}
						},
						{
							xtype:'container',
							cls:'containerHeader',
							html:tpl.apply(),
							style:{'top':'0px','margin':'0px'}
						},
						{
							xtype : 'vdatastorereportsettings',
							parent:this
						}

         ],
         renderTo: 'vdatastorereport-body'
      });
	  var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			me.validateAndCloseSettings();
		});

   },
   validateAndCloseSettings: function()
   {
	   var result = true;
			var reportgenVal = Ext.getCmp('reportGeneration').getValue();
			if (reportgenVal == 'background' || reportgenVal == 'background-csv')
			{
				var reportName = Ext.getCmp('bgReportName').getValue();
				var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
				if ( !ret )
				{
					Ext.getCmp('bgReportName').focus();
					result =  false;
				}
				else
				{
					result =  true;
				}
			}
			var timeFrom = Ext.getCmp('timefrom').getValue();
			var minFrom = Ext.getCmp('minfrom').getValue();
			var timeTo = Ext.getCmp('timeto').getValue();
			var minTo = Ext.getCmp('minto').getValue();
			if ( !checkTimePeriod(timeFrom, minFrom, timeTo, minTo ) )
			{
				result =  false;
			}
			if ( !result )
			{
				return false;
			}
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return result;
   },
	goTo: function (btn) {
	   				// by karthikeyan
	if (Ext.getCmp('er_timeline').getValue() == 'Any')
	{
			Ext.MessageBox.show({
					title : 'Virtualization Reports',
					msg : 'Chosen timeline not allowed',
					buttons : Ext.Msg.OK,
					icon: Ext.MessageBox.WARNING
				});
			return;
		}
//
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicJSON['hiddens'];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + appConstants.queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.showSchedules();
		}
    },
	showFavorites: function()
	{
		if ( Ext.getCmp('er_cluster').getValue() == '-1' || Ext.getCmp('er_cluster').getValue().toLowerCase() == 'not applicable' )
		{
		 Ext.MessageBox.show({
				title: 'Alert',
				msg: "Favorites not allowed without cluster selection  ",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		}
		else if ( Ext.getCmp('er_host').getValue() == '-1' || Ext.getCmp('er_host').getValue().toLowerCase() == 'not applicable' )
			{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: "Favorites not allowed  without Physical server selection ",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			}
		else if ( Ext.getCmp('er_vms').getValue() == '-1' || Ext.getCmp('er_vms').getValue().toLowerCase() == 'not applicable' )
				{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: "Favorites not allowed   without Virtual Machine selection",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			}
	else{
		this.getQueryString();
		var qString = appConstants.queryString;
		qString += '&isSubmit=true';

		var hiddenFields =  appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
		var target = '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client&er_view=GRAPH&isSubmit=true&&er_rtype=Virtualization'+"&er_RmDispName="+appConstants.er_RmDispName+'&com.eg.CSRF_NONCE='+csrfToken;//&FavoriteId='+favorite_id;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	}
	},
	showSchedules: function()
	{
		this.getQueryString();
		var qString = appConstants.queryString;
		var selectedData = appConstants.publicJSON['selectedValues'];
		var pageWidthProces = selectedData['pageWidthProces'];
		qString+="&pageWidthProces="+pageWidthProces;
		if(qString!= undefined )
		{
			if(qString.indexOf("er_rtype")==-1)
			{
				qString+="&er_rtype=Virtualization";
			}
		}
		var target= '/final/reporter/ErSaveSchedule.jsp?'+qString+'&com.eg.CSRF_NONCE='+csrfToken;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	callData: function()
	{
		document.location='/final/servlet/egurkha.reporter.SaveInCSVFormat';
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveMe: function()
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF('/final/reporter/ErHtmlToSavePdf.jsp?'+appConstants.publicJSON['PDF_URL']);
	},
	bookletQuery: function(obj)
	{
		return appConstants.publicJSON['PDF_URL'];
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString;
		var selectedData = appConstants.publicJSON['selectedValues'];
		var pageWidthProces = selectedData['pageWidthProces'];
		bookletquery+="&pageWidthProces="+pageWidthProces;
		if(bookletquery.indexOf("er_rtype")==-1)
		{
			bookletquery+="&er_rtype=Virtualization";
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	printMe: function()
	{
		parent.printWindowFn(appConstants.publicJSON['PRINT_URL']+'&pdfPrint=yes'); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	changeDetailedTrend: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
		var er_trenddata;
		if (isSettingsEnabled)
		{
			er_trenddata = Ext.getCmp("er_trenddata").getValue();
		}
		else
		{
			er_trenddata = appConstants.publicJSON['selectedValues']['showDataSelected'];
		}
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param1,
				scope : this,
				async : true,
				success : function(response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					var comboVal=jsonData.combo;
					var timelineRawData = jsonData.combo;
					var timelineCombo = Ext.getCmp('er_timeline');
					timelineCombo.getStore().removeAll();
					timelineCombo.getStore().loadRawData(jsonData.combo);
					var flag=false;
					for(var i = 0; i < comboVal.length; i++)
					{
					  if(comboVal[i].valueField == er_timeline)
					  {
						flag=true;
					  }
					}
					if(flag)
						timelineCombo.setValue(er_timeline);
					else
						timelineCombo.setValue("1 day");
				}
			});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = appConstants.publicJSON['hiddens']['inidate'];
			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}
	},
	getHiddenQstr: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}

			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	beforeFormSubmit: function()
	{
		var msg = '';
		if ( Ext.getCmp('er_component').getValue() == '-1' )
		{
			msg = appConstants.chooseComp;
		}
		else if ( Ext.getCmp('er_cluster').getValue() == '-1' || Ext.getCmp('er_cluster').getValue().toLowerCase() == 'not applicable' )
		{
			msg = appConstants.chooseCluster;
		}
		else if ( Ext.getCmp('er_host').getValue() == '-1' || Ext.getCmp('er_host').getValue().toLowerCase() == 'not applicable' )
		{
			msg = appConstants.choosePhyServer;
		}
		else if ( Ext.getCmp('er_vms').getValue() == '-1' || Ext.getCmp('er_vms').getValue().toLowerCase() == 'not applicable' )
		{
			msg = appConstants.chooseVMs;
		}
		if ( !Ext.isEmpty( msg ) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
				return false;
		}
		return true;
	},
	getQueryString:function()
	{
		var me = this;
		var mainForm = this.getVdatastorereportmainform().getForm();
		var qstr = '';
		qstr +=  this.getHiddenQstr();

		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		var startdateVal = Ext.Date.dateFormat(mainForm.findField('er_stdate').getValue(), mgrDateFormat);
		var enddateVal = Ext.Date.dateFormat(mainForm.findField('er_enddate').getValue(), mgrDateFormat);
		var starthrVal = mainForm.findField('er_sthr').getValue();
		var er_endhrVal = mainForm.findField('er_endhr').getValue();

		var selectedData = appConstants.publicJSON['selectedValues'];
		var timefrom = selectedData['timePeriodFromHrSelected'];
		var minfrom = selectedData['timePeriodFromMinSelected'];
		var timeto = selectedData['timePeriodToHrSelected'];
		var minto = selectedData['timePeriodToMinSelected'];
		var br_reportName = '';
		var er_excwe = selectedData['excludeWeekEndSelected'];
		var er_trenddata = selectedData['showDataSelected'];
		var er_reportgenration = selectedData['reportGenerationSelected'];
		if (isSettingsEnabled)
		{
			var settingsForm = this.getVdatastorereportsettings().getForm();

			er_reportgenration = settingsForm.findField('reportGeneration').getValue();
			timefrom = settingsForm.findField('timefrom').getValue();
			minfrom = settingsForm.findField('minfrom').getValue();
			timeto = settingsForm.findField('timeto').getValue();
			minto = settingsForm.findField('minto').getValue();
			br_reportName = settingsForm.findField('bgReportName').getValue();
			er_excwe = settingsForm.findField('er_excwe').getValue();
			er_trenddata = settingsForm.findField('er_trenddata').getValue();
			br_reportName=checkFileName(br_reportName);
		}

		var er_component = mainForm.findField('er_component').getValue();
		var er_vms = mainForm.findField('er_vms').getValue();
		var er_host = mainForm.findField('er_host').getValue();
		var er_cluster = mainForm.findField('er_cluster').getValue();
		qstr +='&er_trenddata='+er_trenddata+'&er_comptype='+encodeURI(er_comptype)+'&er_excwe='+encodeURI(er_excwe)
			  +'&er_timeline='+encodeURI(er_timeline)+'&timefrom='+encodeURI(timefrom)+'&minfrom='+encodeURI(minfrom)
			  +'&timeto='+encodeURI(timeto)+'&minto='+encodeURI(minto)+'&er_reportgenration='+encodeURI(er_reportgenration)
			  +'&er_component='+encodeURI(er_component)+'&er_vms='+encodeURI(er_vms)+'&er_host='+encodeURI(er_host)
			  +'&er_cluster='+encodeURI(er_cluster)+'&bg_reportname='+encodeURI(br_reportName)
			  +"&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;

		
		qstr+="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString = qstr;
	
	},
	formSubmit: function( obj )
	{
		var me = this;
		var selectedData = appConstants.publicJSON['selectedValues'];
		var er_reportgenration = selectedData['reportGenerationSelected'];
		if (isSettingsEnabled)
		{
			var settingsForm = this.getVdatastorereportsettings().getForm();
			er_reportgenration = settingsForm.findField('reportGeneration').getValue();
		}
		var mainForm = this.getVdatastorereportmainform().getForm();
		var fromTimeline = false;
		var fromShowData = false;
		var isSubmit = false;
		//
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
 		stDate.setHours(startHour);
 		enDate.setHours(endHour);
		var result = checkDateTime(stDate, enDate);
		if (!result) {
            return;
		}
		//
		if ( !Ext.isEmpty( obj ) )
		{
			appConstants.actionFrom = obj.getId();
		}
			if ( appConstants.actionFrom == 'er_timeline' )
			{
				fromTimeline = true;
			}
			else if ( appConstants.actionFrom == 'er_trenddata' )
			{
				fromShowData = true;
			}
			else if ( appConstants.actionFrom == 'submit' )
			{
				if ( !this.beforeFormSubmit() )
				{
					return;
				}
				isSubmit = true;
				appConstants.initLdgMask.show();
			}
		
		me.getQueryString();
		var qstr=appConstants.queryString;

		var remoteURL = '/final/reporter/ErVMdatastoreReportJSON.jsp';
		if ( !Ext.isEmpty(appConstants.reqFromSchedule) && appConstants.reqFromSchedule == 'Yes' && isSubmit )
		{
			document.location = '/final/reporter/ErSaveSchedule.jsp?'+qstr+'&er_rtype=Virtualization';
		}
		if (isSubmit)
		{
			remoteURL = '/final/servlet/com.eg.ErEsxVMstoreReportC';
			if ( er_reportgenration == 'background' )
			{
				remoteURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				qstr += '&forwardto=ErVMdatastoreReportJSON';
			}
			else if ( er_reportgenration == 'background-csv' )
			{
				remoteURL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				qstr += '&forwardto=ErVMdatastoreReportJSON';
			}
			qstr += '&call=json&isSubmit=true';
		}
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		Ext.Ajax.request({
			url: remoteURL,
			params: qstr,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					appConstants.publicJSON = Ext.decode(jsonText);
					var selectedData = appConstants.publicJSON['selectedValues'];
					if ( fromTimeline || fromShowData )
					{
						var timelineCombo = appConstants.publicJSON['timelineCombo'];
						if ( !Ext.isEmpty( timelineCombo ) )
						{
							var selectedTimeline = selectedData['selectedTimeline'];
							me.setValueWithOptionInList( mainForm, 'er_timeline', timelineCombo, selectedTimeline);
							me.changeTimeline();
						}
						var startDate = selectedData['startDateForDisplay'];
						var endDate = selectedData['endDateForDisplay'];
						var startHour = selectedData['startHourForDisplay'];
						
						var endHour = selectedData['endHourForDisplay'];
						mainForm.findField('er_stdate').setValue(startDate);
						mainForm.findField('er_enddate').setValue(endDate);
						mainForm.findField('er_sthr').setValue(startHour);
						mainForm.findField('er_endhr').setValue(endHour);
					}
					else if ( isSubmit )
					{
						if ( er_reportgenration == 'foreground' )
						{
							me.getDatapanel().show();
							var gridResults = '';
							if ( !Ext.isEmpty(appConstants.publicJSON['RESULTS'] ) )
							{
								gridResults = appConstants.publicJSON['RESULTS']['GRID_RESULTS'];
							}
							me.loadGrid( gridResults );

							me.enableTools();
						}
						else
						{
							me.loadBackgroundResults(appConstants.publicJSON['backgroundResults']);
						}
						appConstants.initLdgMask.hide();
					}
				}
			}
		});
	},
	loadBackgroundResults: function( backgroundResults )
	{
		var backgroundResultsData = backgroundResults;
		if ( !Ext.isEmpty( backgroundResultsData ) )
		{
 			var backgroundResultStatus = backgroundResultsData['status'];
			var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
			var backgroundResultURL = backgroundResultsData['backgroundResponseURLLink'];
			var backgroundResultURLLinkText = backgroundResultsData['backgroundResponseURLText'];
			var htmlStr = '';
			if ( backgroundResultStatus == 'success' )
			{
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			else if ( backgroundResultStatus == 'duplicate' )
			{
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			
			}
			this.getBackGroundPanel().update(htmlStr);
 			this.getBackGroundPanel().show();
			this.disableTools();
		}
	},
	loadGrid: function( gridResults )
	{
		var resultObj = this.getDatapanel();
		resultObj.removeAll();
		if ( !Ext.isEmpty( gridResults ) )
		{
			for ( var key in gridResults )
			{
				var getTitle = gridResults[key]['TITLE'];
				var gridData = gridResults[key];
				var cnt = 0;
				var fileArr = new Array();
				var gridResult = gridData['GRID_RESULTS'];
				for ( var ii in gridResult[0] )
				{
					fileArr[fileArr.length]=ii;
				}
				var outerColumnArr = new Array();
				var outerColumns = gridData['OUTER_COLUMNS'];
				var measureColumns = gridData['MEASURE_COLUMNS'];
				var unitColumns = gridData['UNIT_COLUMNS'];
				var aggColumns = gridData['AGG_COLUMNS'];
				for ( var i = 0; i < outerColumns .length ; i++ )
				{
					var outerColName = outerColumns[i]['COLUMN_NAME'];

					var measureColArr = new Array();
					var aggIdx = 0;
					if ( i == 3 )
					{
						var unitStartIdx = 3;
						for ( var j = 0; j < 6; j++ )
						{
							var unitArray = new Array();
							unitArray.push(
								{
									header: unitColumns[unitStartIdx]['UNIT_NAME'],
									columns: [
									{
										header: aggColumns[aggIdx++]['COLUMNS_NAME'],
										dataIndex : 'COLUMN_'+(cnt++),
										align: 'center',
										sortable: true,
										renderer: function( val )
										{
											if ( val['LINK_TEXT'] != undefined && val['LINK_URL'] != undefined )
											{
												var text = val['LINK_TEXT'];
												var url = val['LINK_URL'];
												return '<a href="javascript:void(0);" onClick="javascript:openInNewWin(\''+url+'\');">'+text+'</a>';
											}
											else
											{
												return val;
											}
										}
									}
									]
								}
							);
							measureColArr.push(
							{
								header: measureColumns[j]['TEST_NAME'],
								columns: unitArray
							});
							unitStartIdx++;
						}
					}
					else if ( i == 4 )
					{
						var unitStartIdx = ( unitColumns.length - 4 );
						for ( var j = 6; j < measureColumns.length; j++ )
						{
							var unitArray = new Array();
							if(unitStartIdx==unitColumns.length)
								continue;
							unitArray.push(
								{
									header: unitColumns[unitStartIdx]['UNIT_NAME'],
									columns: [
									{
										header: aggColumns[aggIdx++]['COLUMNS_NAME'],
										dataIndex : 'COLUMN_'+(cnt++),
										align: 'center',
										sortable: true,
										renderer: function( val )
										{
											if ( val['LINK_TEXT'] != undefined && val['LINK_URL'] != undefined )
											{
												var text = val['LINK_TEXT'];
												var url = val['LINK_URL'];
												return '<a href="javascript:void(0);" onClick="javascript:openInNewWin(\''+url+'\');">'+text+'</a>';
											}
											else
											{
												return val;
											}
										}

									}
									]
								}
							);
							measureColArr.push(
							{
								header: measureColumns[j]['TEST_NAME'],
								columns: unitArray
							});
							unitStartIdx++;
						}
					}

					if ( i >=3 )
					{
						outerColumnArr.push(
						{
							header : outerColName,
							columns: measureColArr
						});
					}
					else
					{
						outerColumnArr.push(
						{
							header : outerColName,
							sortable: true,
							width:180,
							align:'left',
							dataIndex : 'COLUMN_'+(cnt++)
						});
					}
				}
				fileArr[fileArr.length] = 'LINK_URL';
				fileArr[fileArr.length] = 'LINK_TEXT';
 

				var store=Ext.create('Ext.data.Store', {
						fields: fileArr,
						data: gridResult,
						proxy : {
							type : 'pagingmemory',
							reader : {
								type : 'json'
							}
						},
						pageSize:gridPageSize,
						autoLoad : true
 					});
				var isPagingHidden;
				if (gridResult.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				var activePage=1;
				resultObj.setTitle(getTitle);
				resultObj.add({
 					xtype: 'customgrid',
					//title: '<span class="font_bold">'+getTitle+'</span>',
					margin:'0 10 10 10',
					store:store,
					needtoFixColumn:true, 
					scroll:true,
					autoScroll:true,
					//cls:'gridSkin horizontal-scroll',
					ui:'newGridPanel',
					border:true,
					columns: outerColumnArr,
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
						 this.getStore().loadPage(activePage);
					
						},
						render:function(obj){
  						Ext.defer(function() {
							obj.columns[0].setSortState("ASC",true,true);
						},100);
 						}
					},
					dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: store,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{   
										activePage = params.currentPage;
									}
								}
							}]
				});
			}
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON['selectionDetails']);
 		}
		else
		{
			resultObj.hide();
 			this.getNomeasurepanel().show();
 		}
	},
	/*changeExcludeWeekEnd: function ( obj )
	{
		var geExVal = Ext.getCmp('er_excwe').getValue();
		if ( geExVal == 'Yes' )
		{
			var param = 'F=getExcucludeWeekend&C=jsrs1&P0=[VIRTUAL_STOREDETAIL]&U='+new Date().getTime()+'&fromajax=true';
				Ext.Ajax.request({
					url: '/final/servlet/ErRemoteScriptingServlet',
					params: param,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText )
							var values = jsonData['values'];
							Ext.getCmp('er_excweLbl').update("Excludes	"+values);
						}
					}
				});
		}
		else
		{
			Ext.getCmp('er_excweLbl').update('');
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},*/
	changeHost: function(obj)
	{
		var mainForm = this.getVdatastorereportmainform().getForm();
		var er_type = appConstants.publicJSON['hiddens']['er_type'];
		var er_compnameVal = Ext.getCmp('er_component').getValue();
		var er_comptype = Ext.getCmp('er_comptype').getValue();
		var er_cluster = Ext.getCmp('er_cluster').getValue();
		var er_host = Ext.getCmp('er_host').getValue();
		var userID = appConstants.publicJSON['hiddens']['eruserid'];
		var params = '&er_type='+encodeURIComponent(er_type)+'&er_requesttype=vrtualmachines&er_compname='+encodeURIComponent(er_compnameVal)
					+'&er_comptype='+encodeURIComponent(er_comptype)+'&er_report=&reportfor=vrtualmachines&er_host='+encodeURIComponent(er_host)+'&er_cluster='+encodeURIComponent(er_cluster)+'&eruserid='+encodeURIComponent(userID)
					+'&calljson=true';
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		params += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
		this.callRemoteScript(mainForm, 'er_vms', params);
		if ( mainForm.findField('er_vms').getStore().getAt(0).get('valueField') != 'Not Applicable' && mainForm.findField('er_vms').getStore().getAt(0).get('valueField') != '-1' )
		{
			mainForm.findField('er_vms').getStore().insert(0,
			{
				'displayField': '--All--',
				'valueField': '--All--'
			});
			if(appConstants.fromFavSch!="null" && appConstants.fromFavSch=="true" && appConstants.er_vms!="null")
			{
				mainForm.findField('er_vms').setValue(appConstants.er_vms);
			}
			else
				mainForm.findField('er_vms').setValue('--All--');
		}
		if ( Ext.getCmp('er_host').getValue() == 'Not Applicable' )
		{
			this.insertNotApplicable(mainForm, 'er_vms');
		}
		if ( Ext.getCmp('er_host').getValue() == '-1' )
		{
			this.insertNotApplicable(mainForm, 'er_vms');
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}

	},
	changeCluster: function(obj)
	{
		var mainForm = this.getVdatastorereportmainform().getForm();
		var er_type = appConstants.publicJSON['hiddens']['er_type'];
		var er_compnameVal = Ext.getCmp('er_component').getValue();
		var er_comptype = Ext.getCmp('er_comptype').getValue();
		var er_cluster = Ext.getCmp('er_cluster').getValue();
		var userID = appConstants.publicJSON['hiddens']['eruserid'];
		var params = '&er_type='+encodeURIComponent(er_type)+'&er_requesttype=hostlist&er_compname='+encodeURIComponent(er_compnameVal)
					+'&er_comptype='+encodeURIComponent(er_comptype)+'&er_report=&reportfor=clusterreport&er_host=-1&er_cluster='+encodeURIComponent(er_cluster)+'&eruserid='+encodeURIComponent(userID)+'&calljson=true';
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		params += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
		this.callRemoteScript(mainForm, 'er_host', params);
		if ( mainForm.findField('er_host').getStore().getAt(0).get('valueField') != '-1' )
		{
			if ( mainForm.findField('er_host').getStore().getCount() > 1 )
			{
				mainForm.findField('er_host').getStore().insert(0,
				{
					'displayField': '--All--',
					'valueField': '--All--'
				});
				if(appConstants.fromFavSch!="null" && appConstants.fromFavSch=="true" && appConstants.er_host!="null")
				{
					mainForm.findField('er_host').setValue(appConstants.er_host);
				}else
				mainForm.findField('er_host').setValue('--All--');
			}
			else
			{
				mainForm.findField('er_host').setValue(mainForm.findField('er_host').getStore().getAt(0).get('valueField'));
			}
			this.changeHost(Ext.getCmp('er_host'));
		}
		else
		{
			this.insertNotApplicable(mainForm, 'er_vms');
		}

		if ( Ext.getCmp('er_cluster').getValue() == '-1' )
		{
			this.insertNotApplicable(mainForm, 'er_host');
			this.insertNotApplicable(mainForm, 'er_vms');
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}

	},
	changeVCenter: function( obj )
	{
		var mainForm = this.getVdatastorereportmainform().getForm();
		var er_type = appConstants.publicJSON['hiddens']['er_type'];
		var er_compnameVal = Ext.getCmp('er_component').getValue();
		var er_comptype = Ext.getCmp('er_comptype').getValue();
		var params = '&er_type='+encodeURIComponent(er_type)+'&er_requesttype=cluster&er_compname='+encodeURIComponent(er_compnameVal)+'&er_components='+encodeURIComponent(er_compnameVal)+'&er_comptype='+encodeURIComponent(er_comptype)+'&er_report=&reportfor=clusterreport&er_host=-1&calljson=true';
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		params += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
		this.callRemoteScript(mainForm, 'er_cluster', params);
		if ( Ext.getCmp('er_component').getValue() == '-1' )
		{
			this.insertNotApplicable(mainForm, 'er_cluster');
			this.insertNotApplicable(mainForm, 'er_host');
			this.insertNotApplicable(mainForm, 'er_vms');
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeCompType: function( obj )
	{
		var er_comptype = Ext.getCmp('er_comptype').getValue();
		var me = this;
		var URL = '/final/reporter/ErVMdatastoreReportJSON.jsp';
		Ext.Ajax.request({
			url: URL,
			params: appConstants.defaultParams+'&er_comptype='+encodeURIComponent(er_comptype),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 || !Ext.isEmpty( response.responseText ) )
				{
					var jsonData = Ext.decode( response.responseText );
					me.hideResult();
					var mainForm = me.getVdatastorereportmainform().getForm();
					var selectedData = jsonData['selectedValues'];
					var vCenterCombo = jsonData['vcenterCombo']
					if ( !Ext.isEmpty( vCenterCombo ) )
					{
						var vCenterSelected = selectedData['vcenterSelected'];
						me.setValueWithOptionInList(mainForm, 'er_component', vCenterCombo, vCenterSelected);
						me.changeVCenter(Ext.getCmp('er_cluster'));
					}
					else
					{
						me.insertNotApplicable( mainForm, 'er_component');
					}

					var clusterCombo = jsonData['clusterCombo']
					if ( !Ext.isEmpty( clusterCombo ) )
					{
						var clusterSelected = selectedData['clusterSelected'];
						me.setValueWithOptionInList(mainForm, 'er_cluster', clusterCombo, clusterSelected);
					}
					else
					{
						me.insertNotApplicable( mainForm, 'er_cluster');		
					}
					var physicalServerCombo = jsonData['physicalServerCombo'];
					if ( !Ext.isEmpty( physicalServerCombo ) )
					{
						var physicalServerSelected = selectedData['physicalServerSelected'];
						me.setValueWithOptionInList(mainForm, 'er_host', physicalServerCombo, physicalServerSelected);
					}
					else
					{
						me.insertNotApplicable( mainForm, 'er_host');
					}

					var virtualMachineCombo = jsonData['virtualMachineCombo']
					if ( !Ext.isEmpty( virtualMachineCombo ) )
					{
						var virtualMachineSelected = selectedData['virtualMachineSelected'];
						me.setValueWithOptionInList(mainForm, 'er_vms', virtualMachineCombo, virtualMachineSelected);
					}
					else
					{
						me.insertNotApplicable( mainForm, 'er_vms');
					}

					mainForm.findField('er_mode').hide();
					
				}
			}
		});
	},
	callRemoteScript: function( mainForm, fieldName, params )
	{
		var me = this;

		Ext.Ajax.request({
			url: '/final/servlet/com.eg.ErVirtualRemoteScriptControllerC',
			params: params,
			method: 'POST',
			async: false,
			success: function ( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					//var selectedValue="";
					if(fieldName=='er_cluster')
					{
						var selectedValue=appConstants.er_cluster;
					}
					if(fieldName=='er_vms')
					{
						var selectedValue=appConstants.er_vms;
					}
					if((appConstants.fromFavSch!="null" && appConstants.fromFavSch=="true"))
					{
						for(var i=0;i<jsonData.length;i++)
						{
							var selctd = jsonData[i].valueField;
							if(selctd!= selectedValue)
							{
								selectedValue=jsonData[0].valueField;
							}
							else
							{
						if(fieldName=='er_cluster'&& appConstants.er_cluster!="null")
								{
							selectedValue=appConstants.er_cluster;
								}
								if(fieldName=='er_vms'&& appConstants.er_vms!="null")
								{
									selectedValue = appConstants.er_vms;
								}
							}
						}
					}
						if(selectedValue=='null')
							selectedValue='';
					me.setValueWithOptionInList(mainForm, fieldName, jsonData, selectedValue);
				}
				else
				{
					me.insertNotApplicable( mainForm, fieldName );
					if ( fieldName == 'er_cluster' )
					{
						me.insertNotApplicable( mainForm, 'er_host' );
						me.insertNotApplicable( mainForm, 'er_vms' );
					}
				}
			},
			failure: function()
			{
				me.insertNotApplicable( mainForm, fieldName );
			}
		});

	},
	afterSettingsFormRender: function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields =  appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
				if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var settingsForm = this.getVdatastorereportsettings().getForm();
		var objectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];


		objectArr['er_excwe'] = screenLabels['reporter.common.excludeWeekends'];
		objectArr['er_trenddata'] = screenLabels['reporter.common.showData'];
		objectArr['timeperiodLbl'] = screenLabels['reporter.common.timePeriod'];
		objectArr['fromTimeLbl'] = screenLabels['reporter.common.From'];
		objectArr['toTimeLbl'] = screenLabels['reporter.common.To'];
		objectArr['fromHrsLbl'] = screenLabels['reporter.common.Hrs'];
		objectArr['fromMinsLbl'] = screenLabels['reporter.common.Mins'];
		objectArr['toHrsLbl'] = screenLabels['reporter.common.Hrs'];
		objectArr['toMinsLbl'] = screenLabels['reporter.common.Mins'];
		objectArr['reportGeneration'] = screenLabels['reporter.common.reportGeneration'];
		objectArr['bgReportName'] = screenLabels['reporter.consolidated.reportName'];

		this.loadScreenLabels( settingsForm, objectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];

		var showDataCombo = appConstants.publicJSON['showDataCombo'];
		if ( !Ext.isEmpty( showDataCombo ) )
		{
			var showDataSelected = selectedData['showDataSelected'];
			this.setValueWithOptionInList( settingsForm, 'er_trenddata', showDataCombo, showDataSelected);
		}
		else
		{
			this.insertNotApplicable( settingsForm, 'er_trenddata');
		}
		var trendenablee = appConstants.publicJSON.hiddens['trendenable'];
		if(trendenablee == 'false'){
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}

		var excludeWeekEndCombo = appConstants.publicJSON['excludeWeekEndCombo'];
		if ( !Ext.isEmpty( excludeWeekEndCombo ) )
		{
			var excludeWeekendSelected = selectedData['excludeWeekEndSelected'];
			this.setValueWithOptionInList( settingsForm, 'er_excwe', excludeWeekEndCombo, excludeWeekendSelected);
		//	this.changeExcludeWeekEnd();
		}
		else
		{
			this.insertNotApplicable( settingsForm, 'er_excwe');
		}




		settingsForm.findField('timefrom').setValue(selectedData['timePeriodFromHrSelected']);
		settingsForm.findField('minfrom').setValue(selectedData['timePeriodFromMinSelected']);

		settingsForm.findField('timeto').setValue(selectedData['timePeriodToHrSelected']);
		settingsForm.findField('minto').setValue(selectedData['timePeriodToMinSelected']);


		var reportGenCombo = appConstants.publicJSON['reportGenCombo'];
		var reportGenSelected = selectedData['reportGenerationSelected'];
		if ( !Ext.isEmpty( reportGenCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'reportGeneration', reportGenCombo, reportGenSelected);
			this.changeReportGeneration();
		}


	},
	changeReportGeneration: function( obj )
	{
		var reportGenVal = Ext.getCmp('reportGeneration').getValue();
		var bgReportObj = Ext.getCmp('bgReportName');
		if ( reportGenVal == 'background' )
		{
			bgReportObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if ( reportGenVal == 'background-csv' )
		{
			bgReportObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			bgReportObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeTimeline: function( obj )
	{
		var getTimelineVal = Ext.getCmp('er_timeline').getValue();
		var stDateObj = Ext.getCmp('er_stdate');
		var endDateObj = Ext.getCmp('er_enddate');
		var stHrObj = Ext.getCmp('er_sthr');
		var endHrObj = Ext.getCmp('er_endhr');
		if ( getTimelineVal == 'Any' )
		{
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
		}
	},
	hideResult: function()
	{
		this.getDatapanel().hide();
		this.disableTools();
	},

	afterStoreReportMainFormRender: function()
	{
		this.hideResult();
		var mainForm = this.getVdatastorereportmainform().getForm();
		var objectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		objectArr['er_comptype'] = screenLabels['reporter.common.reportFor'];
		objectArr['er_component'] = screenLabels['reporter.common.virtualCenter'];
		objectArr['er_cluster'] = screenLabels['reporter.common.cluster'];
		objectArr['er_host'] = screenLabels['reporter.common.physicalServers'];
		objectArr['er_vms'] = screenLabels['reporter.common.virtualMachine'];

		objectArr['er_timeline'] = screenLabels['reporter.common.Timeline'];
		objectArr['er_stdate'] = screenLabels['reporter.common.From'];
		objectArr['er_sthr'] = screenLabels['reporter.common.Hr'];
		objectArr['er_enddate'] = screenLabels['reporter.common.To'];
		objectArr['er_endhr'] = screenLabels['reporter.common.Hr'];
		//Ext.getCmp('submit').setText(screenLabels['reporter.common.SUBMIT']);
		this.loadScreenLabels( mainForm, objectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];


		var reportTypeCombo = appConstants.publicJSON['reportTypeCombo'];
		if ( !Ext.isEmpty( reportTypeCombo ) )
		{
			var reportTypeSelected = selectedData['reportTypeSelected'];
			this.setValueWithOptionInList(mainForm, 'er_comptype', reportTypeCombo, reportTypeSelected);
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_comptype');
		}

		var vCenterCombo = appConstants.publicJSON['vcenterCombo']
		if ( !Ext.isEmpty( vCenterCombo ) )
		{
			var vCenterSelected = selectedData['vcenterSelected'];
			this.setValueWithOptionInList(mainForm, 'er_component', vCenterCombo, vCenterSelected);
			this.changeVCenter(Ext.getCmp('er_cluster'));
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_component');
		}

		var clusterCombo = appConstants.publicJSON['clusterCombo']
		if ( !Ext.isEmpty( clusterCombo ) )
		{
			var clusterSelected = selectedData['clusterSelected'];
			this.setValueWithOptionInList(mainForm, 'er_cluster', clusterCombo, clusterSelected);
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_cluster');
			this.changeVCenter(Ext.getCmp('er_cluster'));				
		}
		var physicalServerCombo = appConstants.publicJSON['physicalServerCombo'];
		if ( !Ext.isEmpty( physicalServerCombo ) )
		{
			var physicalServerSelected = selectedData['physicalServerSelected'];
			this.setValueWithOptionInList(mainForm, 'er_host', physicalServerCombo, physicalServerSelected);
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_host');
			this.changeCluster(Ext.getCmp('er_host'));
		}

		var virtualMachineCombo = appConstants.publicJSON['virtualMachineCombo']
		if ( !Ext.isEmpty( virtualMachineCombo ) )
		{
			var virtualMachineSelected = selectedData['virtualMachineSelected'];
			this.setValueWithOptionInList(mainForm, 'er_vms', virtualMachineCombo, virtualMachineSelected);
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_vms');
			this.changeHost(Ext.getCmp('er_host'));
		}

		mainForm.findField('er_mode').hide();
		var timelineCombo = appConstants.publicJSON['timelineCombo'];
		if ( !Ext.isEmpty( timelineCombo ) )
		{
			var selectedTimeline = selectedData['selectedTimeline'];
			this.setValueWithOptionInList( mainForm, 'er_timeline', timelineCombo, selectedTimeline);
			this.changeTimeline();
		}
		else
		{
			this.insertNotApplicable( mainForm, 'er_timeline');
		}

		var startDateData = selectedData['startDate'];
		var endDateData = selectedData['endDate'];
		mainForm.findField('er_stdate').setValue(selectedData.startDateForDisplay);
		mainForm.findField('er_stdate').dataArray = startDateData;
		mainForm.findField('er_enddate').setValue(selectedData.endDateForDisplay);
		mainForm.findField('er_enddate').dataArray = endDateData;

		var startHourSelected = selectedData['startHour'];
		var endHourSelected = selectedData['endHour'];
		mainForm.findField('er_sthr').setValue(selectedData.startHourForDisplay);
		mainForm.findField('er_sthr').dataArray = startHourSelected;
		mainForm.findField('er_endhr').setValue(selectedData.endHourForDisplay);
		mainForm.findField('er_endhr').dataArray = endHourSelected;
		
		mgr_stmin = selectedData['startmin'];
		mgr_enmin = selectedData['endmin'];
		stmin = selectedData['startMinForDisplay'];
        enmin = selectedData['endMinForDisplay'];
	
		updatingAppSettings();
		appConstants.er_vms='null';

	},
	validateSaveSettings :function(){
		var isSettingsOk = true;
 		var MaxDaysInMonth =hiddenJSON['getMaxDaysInMonth'];
		var er_usertimeline =hiddenJSON['er_usertimeline'];

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
 		stDate.setHours(startHour);
 		enDate.setHours(endHour);
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		return isSettingsOk;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.validateSettings(Ext.getCmp('submit'));
		}
	},
	validateSettings: function(obj)
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		if ( !Ext.isEmpty( obj ) )
		{
			appConstants.actionFrom = obj.getId();
		}
		var hiddenJSON = appConstants.publicJSON['hiddens'];
		var er_usertimeline = hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());

		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg = hiddenJSON['limitforbg'];
		var reportgenVal = appConstants.publicJSON.selectedValues['reportGenerationSelected'];
		if (isSettingsEnabled)
		{
			var settingsForm = this.getVdatastorereportsettings().getForm();

			reportgenVal = settingsForm.findField('reportGeneration').getValue();
		}
		var isSettingsOk = true;
		if ( reportgenVal == 'foreground' )
		{
			if ( !Ext.isEmpty(limitforbg ) )
			{
				if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
					isSettingsOk = false;
				} else
					this.formSubmit();
			} else
				this.formSubmit();
			return isSettingsOk;
		} else {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
						var bgReportObj = Ext.getCmp('bgReportName');
						bgReportObj.focus();
						return ;

			}
			this.formSubmit();
		}

	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('bgReportName').focus(false, 1000);
			var reportName = Ext.getCmp('bgReportName').getValue();
			validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			return false;
		}
	},
	insertNotApplicable: function ( form, fieldName )
	{
		var obj = form.findField(fieldName);
		obj.getStore().removeAll();
		obj.getStore().add({
			'displayField': appConstants.notApplicable,
			'valueField': '-1'
		});
		obj.setValue('-1');
	},
	loadScreenLabels: function ( form, ObjectArr )
	{
		var obj = '';
		for ( var key in ObjectArr )
		{
			obj = !Ext.isEmpty(form.findField(key))?form.findField(key):Ext.getCmp(key);
			if ( obj.getXType() != 'label' )
			{
				if(key !='er_timeline' && key != 'er_stdate' && key != 'er_enddate' && key != 'er_sthr' && key != 'er_endhr' && key != 'er_mode')
				form.findField(key).setFieldLabel(ObjectArr[key]);
			}
			else
			{
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().clearFilter(true); 
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);

		}
		else
		{
			if ( !Ext.isEmpty( list ) )
			{
				form.findField(fieldName).setValue(list[0].valueField);
			}
		}
		form.findField(fieldName).resumeEvents();
	},
	hideTools : function()
	{
		this.getNewUtilities().loadIcon(true, // save
				true, // print
				true, // mail
				false, // data
				true, // cvs
				true, // fav
				true,// schedule
				false, // daignosis
				false, // togglebutton
				false, // close
				true// booklet
				);
		//Ext.getCmp("upbutton").hide();
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	loadDefaults:function()
	{
		if(!hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJSON['ID']
				}
			);
		}
		var hiddenFields = appConstants.publicJSON['hiddens'];
	    var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		if ( appConstants.publicJSON['selectedValues']['vcenterSelected'] != '-1' )
		{
			//this.changeVCenter();
		}
		if(appConstants.publicJSON['selectedValues']['showDataSelected']=='Yes')
		{
			isTrend=true;
		}
		if ( !Ext.isEmpty( appConstants.publicJSON['RESULTS'] ) )
		{
			var gridResults = appConstants.publicJSON['RESULTS']['GRID_RESULTS'];
			this.getDatapanel().removeAll();
			this.getDatapanel().show();
			this.loadGrid( gridResults );
			var selectionDetailsData = appConstants.publicJSON['selectionDetails'];
			var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
			if ( !Ext.isEmpty( selectionDetailsData ) && fromFavoriteModify == null)
			{ 				
				Ext.getCmp('selectionDetails').setSelectionDetailsData(selectionDetailsData);
			}
			this.enableTools();
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJSON['TITLE']);
 		if(appConstants.isForceSubmit=='true')
		{
			appConstants.isForceSubmit='false';
			this.formSubmit(Ext.getCmp('submit'));
		}
	},
	disableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		Ext.getCmp("csvTool").setDisabled(false);
		//Ext.getCmp("upbutton").setDisabled(false);
	}
});