
Ext.define('virtualizationmanagerreports.view.VirtualizationManagerSettings',{
	extend:'Ext.form.Panel',
	alias:'widget.virtualizationmanagersettings',
     id:'settings',
    isLoaded:false,
	//cls:'configMode_popup_inner',
	layout:'column',
	defaults:{
			labelAlign: 'top',
			margin:'0 20 0 0',
			labelSeparator:''
		},
	items:[		{xtype:'reporttypes', margin: '8 0 0 0'},
				{xtype: 'splitter',height: 2, margin: '10 0 10 0',draggable:false,style: {'cursor': 'default'}},
				{xtype:'timeperiod', margin: 0},
				{xtype: 'splitter',height: 2, margin: '10 0 10 0', draggable:false,style: {'cursor': 'default'}},			
				{xtype:'reportgeneration', margin: '0 0 0 0'},
				{xtype: 'splitter',height: 2,  margin: '10 0 10 0', id:'RTMSplitter',draggable:false,style: {'cursor': 'default'}},
				{xtype:'timelinesave',margin: '0 20 0 0'}
	],
	
	loadScreenLabels : function(screenLabels){
		var thisForm = this.getForm();
		
        thisForm.findField('er_excwe').labelEl.dom.innerHTML = screenLabels['reporter.common.Exclude Weekend'];
        thisForm.findField('er_sortby').labelEl.dom.innerHTML = screenLabels['reporter.common.Show Data'];
        thisForm.findField('reportGeneration').labelEl.dom.innerHTML = screenLabels['reporter.consolidated.Report Generation'];
        
        Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
        Ext.getCmp('fromTimeLbl').setText(screenLabels['reporter.common.From']);
        Ext.getCmp('toTimeLbl').setText(screenLabels['reporter.common.To']);
        Ext.getCmp('fromHrsLbl').setText(screenLabels['reporter.common.Hrs']);
        Ext.getCmp('fromMinsLbl').setText(screenLabels['reporter.common.Mins']);
        Ext.getCmp('toHrsLbl').setText(screenLabels['reporter.common.Hrs']);
        Ext.getCmp('toMinsLbl').setText(screenLabels['reporter.common.Mins']);
	},
	loadDefaultData : function(timeline){
		var me = this;
		var thisForm = me.getForm();

		if(appConstants.repoGene!=undefined && appConstants.repoGene!=null)
		{
			me.setComboOptionsInList(thisForm, 'reportGeneration', appConstants.repoGene.reportgenCombo, appConstants.repoGene.reportgenCombo_value);
		}
		else
		{
			me.setComboOptionsInList(thisForm, 'reportGeneration', timeline.reportgenCombo, timeline.reportgenCombo_value);
		}
        me.setComboOptionsInList(thisForm, 'er_excwe', timeline.excludeWeekends,timeline.excludeWeekends_value);
        me.setComboOptionsInList(thisForm, 'er_sortby', timeline.showDataComboArray,timeline.showDataComboArray_value);
       
        me.setComboValue(thisForm, 'timefrom',timeline.timePeriod.Hourfrom);
        me.setComboValue(thisForm, 'minfrom', timeline.timePeriod.Minfrom);
        me.setComboValue(thisForm, 'timeto', timeline.timePeriod.Hourto);
        me.setComboValue(thisForm, 'minto', timeline.timePeriod.Minto);

        this.isLoaded = true;
	},
	setComboOptionsInList : function(form, fieldName, list, value){
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);
        
        form.findField(fieldName).setValue(value);
        form.findField(fieldName).resumeEvents();
    },
     setComboValue : function(form,fieldName,value){
         form.findField(fieldName).suspendEvents(false);
         form.findField(fieldName).setValue(value);
         form.findField(fieldName).resumeEvents();
    }
});
