Ext.define('VirtualizationResourcesApp.controller.Main', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	refs : [{
				selector : 'main',
				ref : 'main'
			}, {
				selector : 'newUtilities',
				ref : 'newUtilities'
			}, {
				selector : 'virtualizationresourcesmainform',
				ref : 'virtualizationresourcesmainform'
			},
			{
				selector : 'mainform',
				ref : 'mainform'
			},
			{
				selector : 'backGroundPanel',
				ref : 'backGroundPanel'
			},
			{selector:'nomeasurepanel', ref:'nomeasurepanel'}],
	init : function() {
		this.control({

					'main newUtilities' : {
						'afterrender' : this.hideTools
					},
					'mainform' : {
						'afterrender' : this.loadDefaultData
					},
					'virtualizationresourcesmainform combo[name="analysis"]' : {
						'select' : this.filterAnalysisBy
					},
					'virtualizationresourcesmainform combo[name="Service"]' : {
						'select' : this.doCommonFilter
					},
					'egcomponent button[id="expandSelector"]' : {
						'click' : this.expandMe
					},
					'mainform button[id="expandSelector2"]' : {
						'click' : this.expandMe2
					},
					'virtualizationresourcesmainform combo[name="Segment"]' : {
						'select' : this.doCommonFilter
					},
					'virtualizationresourcesmainform combo[name="Zone"]' : {
						'select' : this.doCommonFilter
					},
					'virtualizationresourcesmainform combo[name="compType"]' : {
						'select' : this.doCommonFilter
					},
					'mainform button[id="submit"]' : {
						'click' : this.showGraph
					},
					'mainform button[name="save"]': {
						'click' : this.add
					},
					'virtualizationresourcesmainform combo[id="reportGeneration"]':{
						'select':this.showHideReportTextbox
					},
					'newUtilities > #favoriteTool > button' : {
                        'click' : this.add
                    },
                    'newUtilities > #scheduleTool > button' : {
                        'click' : this.add
                    },
                    'newUtilities > #saveTool > button' : {
                        'click' : this.saveFileTool
                    },
                    'newUtilities > #printTool > button' : {
                        'click' : this.printFile
                    },
                    'newUtilities > #mailTool > button' : {
                        'click' : this.sendMail
                    },
					'timeline combo[name="er_mode"]':
					{
							'select': this.changeEr_mode
					},
					'egcomponent trigger[id="compSearch"]':
					{
						'change': this.filterMultiselect
					},
					'criteria trigger[id="criteriaSearch"]':
					{
						'change': this.filterMultiselect
					},
					'mainform button[id="panelinsidetoggle"]': {
						'click': this.toggleForm
					}
				});
	},
	filterMultiselect: function (obj) {
        var findVal = obj.getValue();
        var compId = obj.getId();

		if(compId=='compSearch')
		{
			compStore = appConstants.rawDataForComponents;
			 compName='components';

		}else 	if(compId=='criteriaSearch')
		{
			compStore = appConstants.rawDataForCriteria;
			 compName='Criteria';
		}

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
    },
    toggleForm:function(obj){
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
    changeEr_mode: function (combo) {
		var favorite_id = appConstants.defaultJSON['hiddenFields']["favorite_id"];
		var from_schModify = appConstants.defaultJSON['hiddenFields']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null')) {
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showGraph();
     },
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),'Components',btn);

    },
	expandMe2: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('Criteria'),'Criteria',btn);
	},
	hideTools : function() {

		this.getNewUtilities().loadIcon(true, //save
				true, //print
				true, //mail
				false, //data
				false, //cvs
				true, // fav
				true,// schedule
				false, //daignosis
				false, //togglebutton
				false, //close
				true //booklet
				);

		 //Ext.getCmp("upbutton").hide();
         Ext.getCmp("scheduleTool").setDisabled(false);
        Ext.getCmp("favoriteTool").setDisabled(false);

	},
	loadDefaultData : function() {

		///Ext.getCmp('panelinsidetoggle').setDisabled(false);
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		this.getMainform().loadDefaultData(appConstants.defaultJSON);
		var from_schedule = appConstants.defaultJSON['hiddenFields']["fromScheduleModify"];
		var fromFavoriteModify = appConstants.defaultJSON['hiddenFields']["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			appConstants.issubmit = "false";
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}
	if(!appConstants.hideBackButton){
		Ext.getCmp('virtualization_resources').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.defaultJSON['ID']
			}
		);
	}
		if(appConstants.issubmit!=null && appConstants.issubmit=="true")
		{
			this.showGraph();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showGraph();
			}
		}

	},
	filterAnalysisBy : function(thisObj) {

		var virtualformObj = this.getVirtualizationresourcesmainform();
		var form = thisObj.up('.form').getForm();
		var screenLabels = appConstants.defaultJSON.screenlabels;
		this.setNotApplicable(form, 'compType', screenLabels);
		this.setNotApplicable(form,'components', screenLabels);
		this.setNotApplicable(form,'Criteria', screenLabels);

		var val = thisObj.getValue();

		if (val == 'Zone') {
			form.findField('subzone').show();
			form.findField('Zone').show();
			form.findField('Segment').hide();
			form.findField('Service').hide();
		} else if (val == 'Service') {
			form.findField('subzone').hide();
			form.findField('Zone').hide();
			form.findField('Segment').hide();
			form.findField('Service').show();
		} else if (val == 'Component') {
			form.findField('subzone').hide();
			form.findField('Zone').hide();
			form.findField('Service').hide();
			form.findField('Segment').hide();
		} else {
			form.findField('subzone').hide();
			form.findField('Zone').hide();
			form.findField('Service').hide();
			form.findField('Segment').show();
		}
		var param = 'userID=' + appConstants.userID + '&sessionId=' + appConstants.sessionId
				+ '&filterComponent=true' + '&er_option=' + thisObj.getValue();
		Ext.getCmp('dtpanel').hide();
		this.filtercombobox(
				'/final/servlet/com.eg.ErPhysicalServersResourcesReportC', val,
				param, form);
	},
	setNotApplicable : function(form, fieldname, screenLabel) {


		if (fieldname!='components' && fieldname!='Criteria')
		{
			form.findField(fieldname).getStore().removeAll();
			form.findField(fieldname).getStore().loadRawData([{
						"displayField" : screenLabel['reporter.common.Not Applicable'],
						"valueField" : "-1"
					}]);
			form.findField(fieldname).setValue("-1");
		}
		else
		{

			Ext.getCmp(fieldname).getStore().removeAll();
			Ext.getCmp(fieldname).getStore().loadRawData([{
					"displayField" : screenLabel['reporter.common.Not Applicable'],
					"valueField" : "-1"
				}]);
			Ext.getCmp(fieldname).setValue("-1");
		}

	},
	filtercombobox : function(url, type, param, form) {
		var loadMask = new Ext.LoadMask(Ext.getBody(), {
                    msg : "Loading ..."
                });
        loadMask.show();
		Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						loadMask.hide();
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);

						if (type == 'Component') {
							var comptype = form.findField('compType');
							comptype.getStore().clearFilter(true); 
							comptype.getStore().loadRawData(jsonObject['comptypeCombodata']);
							comptype.setValue(jsonObject['comptypeCombovalue']);

							var component = Ext.getCmp('components');
							component.getStore().loadRawData(jsonObject['compCombodata']);
							appConstants.rawDataForComponents = jsonObject['compCombodata'];
							component.setValue(component.getStore().getAt(0));
							var values = [];

							component.getStore().each(function(re) {
										values.push(re.get('valueField'));
									}, this);
							component.setValue(values);

							var criteria = Ext.getCmp('Criteria');
							criteria.getStore().loadRawData(jsonObject['criteriaCombodata']);
							appConstants.rawDataForCriteria=jsonObject['criteriaCombodata'];

							values = [];
							criteria.getStore().each(function(re) {
										values.push(re.get('valueField'));
									}, this);
							criteria.setValue(values);
						} else {

							var combo = form.findField(type);
							combo.getStore().loadRawData(jsonObject);
							combo.setValue(combo.getStore().getAt(0));
						}

					}
				});
	},
	doCommonFilter : function(thisObj) {

		var virtualformObj = this.getVirtualizationresourcesmainform();
		var screenLabels = virtualformObj.screenLabels;
		var form = thisObj.up('.form').getForm();
		var er_option = form.findField('analysis').getValue();
		var val = thisObj.getValue();
		var param = 'userID=' + appConstants.userID + '&sessionId=' + appConstants.sessionId
				+ '&filterComponent=true' + '&er_option=' + er_option;
		if (thisObj.getName() != 'compType') {

			param += '&er_site=' + encodeURI(val);
			virtualformObj.er_site = val;
		} else {
			param += '&er_comptype=' + val + '&er_site='
					+ virtualformObj.er_site;
		}
        var loadMask = new Ext.LoadMask(Ext.getBody(), {
                    msg : "Loading ..."
                });
		Ext.getCmp('dtpanel').hide();
        loadMask.show();
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErPhysicalServersResourcesReportC',
					params : param,
					scope : this,
					success : function(response) {
						loadMask.hide();
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);

						if (thisObj.getName() != 'compType') {
							var comptype = form.findField('compType');
							comptype.getStore().clearFilter(true);
							comptype.getStore().loadRawData(jsonObject['comptypeCombodata']);
							comptype.setValue(jsonObject['comptypeCombovalue']);
						}
						Ext.getCmp('dtpanel').hide();
						var component = Ext.getCmp('components');
						component.getStore().loadRawData(jsonObject['compCombodata']);
						appConstants.rawDataForComponents = jsonObject['compCombodata'];
						component.setValue(component.getStore().getAt(0));
						var values = [];

						component.getStore().each(function(re) {
									values.push(re.get('valueField'));
								}, this);
						component.setValue(values);

						var criteria = Ext.getCmp('Criteria');
						criteria.getStore().loadRawData(jsonObject['criteriaCombodata']);
						appConstants.rawDataForCriteria=jsonObject['criteriaCombodata'];

						values = [];
						criteria.getStore().each(function(re) {
									values.push(re.get('valueField'));
								}, this);
						criteria.setValue(values);

					}
				});
	},
	showGraph : function(thisObj) {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var virtualformObj = this.getVirtualizationresourcesmainform();
		var form = Ext.getCmp('virtualization_resources').getForm();
		var er_option = form.findField('analysis').getValue();
		var param = 'er_option=' + er_option;
		if (er_option != null) {
			var er_site = '';
			if (er_option == 'Service') {
				er_site = form.findField('Service').getValue();
				param+='&servicelist_value='+er_site;
			} else if (er_option == 'Segment') {
				er_site = form.findField('Segment').getValue();
				param+='&segmentlist_value='+er_site;
			} else if (er_option == 'Zone') {
				er_site = form.findField('Zone').getValue();
				param+='&zonlist_value='+er_site;
			}

			if (er_site != null && er_site == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : 'Please select a ' + er_option,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}

			param += '&er_site=' + er_site;
		}
		var er_comptype = form.findField('compType').getValue();
		var compType = form.findField('compType').getRawValue();
		param += '&er_comptype=' + er_comptype;
		if (er_comptype == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component type',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		var er_component = Ext.getCmp('components').getValue();

		if (er_component == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		var er_criteria = Ext.getCmp('Criteria').getValue();

		if (er_criteria == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Criteria',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		var compParam = "";

		for (var tr in er_component) {
			compParam += "&er_component=" + er_component[tr];
		}

		var criteriaParams = "";
		for (var cr in er_criteria) {
			criteriaParams += "&er_criteria=" + er_criteria[cr];
		}

		var hiddenFields = appConstants.defaultJSON['hiddenFields'];

		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == 'NONE')
				val = '';

			param += '&' + hiddenField + '=' + val;
		}

		param += '&timefrom=00&timeto=24&minfrom=00&minto=00&isSubmit=true&userID='
				+ appConstants.userID
				+ '&sessionId='
				+ appConstants.sessionId
				+ compParam
				+ criteriaParams;//+'&er_rtype=Virtualization';
		var url = ''
		var bgenabled = hiddenFields['bgenabled'];

		if (bgenabled == 'Yes' || bgenabled == 'yes') {
			var selectbackground = form.findField('reportGeneration')
					.getValue();
			param += '&er_reportgenration=' + selectbackground;
			if (selectbackground == 'background') {
				var bg_reportname = form.findField('bgReportName').getValue();
				var rform =  Ext.widget('reportgeneration');
				var vtext=validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true);
				bg_reportname=checkFileName(bg_reportname);
				param += '&bg_reportname=' + bg_reportname;
				if (vtext==true) {
					url = '../servlet/com.eg.ErStartBackGroundReportC?';
				} else {
					return;
				}
			} else
				url = '../servlet/com.eg.ErPhysicalServersResourcesReportC?';

		} else
			url = '../servlet/com.eg.ErPhysicalServersResourcesReportC?';


//by karthikeyan
	param+= '&er_RmDispName='+appConstants.er_RmDispName
		//
		var loadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Loading ..."
				});
        var me = this;
		var resultObj = this.getBackGroundPanel();
		loadMask.show();
		Ext.Ajax.request({
			url : url,
			params : param,
			scope : this,
			success : function(response) {
				loadMask.hide();
				var jsonText = response.responseText;

				var jsonObject = Ext.decode(jsonText);

				var graphtype = jsonObject['graphtype'];

				if (!Ext.isEmpty(graphtype) || graphtype != undefined) {
					Ext.getCmp('dtpanel').hide();
					var itemsArray = new Array();
                    var grpahQueryString = jsonObject.grpahQueryString;
                    var status = grpahQueryString.status;

                    var htmlStr='';
				   if ( status == 'success' )
					{
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>'+grpahQueryString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+grpahQueryString.queryString+'">'+grpahQueryString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					else if ( status == 'duplicate' )
					{
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>'+grpahQueryString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+grpahQueryString.queryString+'">'+grpahQueryString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					resultObj.update(htmlStr);

 					resultObj.show();


				} else {

					var jsonArray = jsonObject['resultmap'];
					var itemsArray = new Array();
					Ext.getCmp('dtpanel').show();
					for (var i in jsonArray) {
						var obj = jsonArray[i];

						var chartArray = obj['chartArray'];
						var innerArray = new Array();
						for (var j in chartArray) {

							var subObj = chartArray[j];
							var dailychartObj = subObj['dailychartObj'];
							var dailyObjXML;
							var dailytitle="";
							var s_qryString = "";
							if(dailychartObj!=undefined)
							{
								dailyObjXML = dailychartObj['chartXML'];
								dailytitle = dailychartObj['dailysubtitle'];
								s_qryString = dailychartObj['s_qryString'];
							}



							var legendArr = subObj['legendsarr'];
							var height = 270;
							var legendshtml = '';
							if (legendArr != null && legendArr != undefined
									&& !Ext.isEmpty(legendArr)) {

								height = 350;
								legendshtml = '<div class="x-table">';
								legendshtml += '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">';
								legendshtml +='<tbody>';
								legendshtml += '<tr class="x-grid-row">';
								for (var l in legendArr) {
									var legObj = legendArr[l];
									//legendshtml += '<td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" ></div></td>';
										legendshtml += '<td class=" x-grid-cell" style="padding:4px;border-top-width:1px"><div class="x-grid-cell-inner" style="position:relative"><span style="position:absolute;left:0px;top:5px;width:5px;float:left;height:5px;background-color:'
											+ legObj['tempColor']
											+ ';"></span><div style="float:left;padding-left:8px;">'
											+ legObj['tempLabel'] + '</div><div style="clear:both"></div></div></td>';
								}
								legendshtml += '</tr>';
								legendshtml +='</tbody>';
								legendshtml += '</table>';
								legendshtml += '</div>';
							}
							var applyObj;
							var htm;
							var disable = false;


							if (dailyObjXML != undefined) {

								if (dailyObjXML == 'nomeasures') {
									htm = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';
									disable = true;
								} else {
									htm = '<div style="border:0px solid red;text-align:center""><div id="dailyChart'
											+ i + j + '"></div></div>';

								}
							}

							var innerpaneldaily = {
								xtype : 'panel',
								title : dailytitle,
								//cls:'containerShadow',
								ui:'newGraphPanel graphHeaderBottomBorder',
								margin:'0 10 10 10',
								height : height,
								padding:0,
								html : htm,
								tools : [{
									xtype : 'container',
									margin : '0 1px 0 1px',
									cls : 'iconBg',
									disabled : disable,
									items : [{
										xtype : 'button',
										iconCls : 'iconData',
										name : 'data' + j,
										data : s_qryString,

										//tooltip : '<b>Data</b>',
										style : {
											background : 'none',
											border : '0px'
										},
										listeners : {
											afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Data'
																});
															},
											'click' : function(thisObj, e,eopts) {
												parent.maximizeDataWindowLightBox(thisObj.data,'REPORTER DATA');//this method is defined in ErReporterMenuDashBoard.jsp for loading drilldown app
											}
										}
									}]

								},{
									xtype : 'container',
									margin : '0 1px 0 1px',
									cls : 'iconBg',
									disabled : disable,
									items : [{
										xtype : 'button',
										iconCls : 'iconCsv',
										name : 'csv' + j,
										data : s_qryString,


										style : {
											background : 'none',
											border : '0px'
										},
										listeners : {
											afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'CSV'
																});
															},
											'click' : function(thisObj, e,
													eopts) {
												var param = thisObj.data;
												param = param.substring(param
														.indexOf("?")
														+ 1);
												document.location.href = "../servlet/com.eg.ErPhysicalServersResourcesReportC?isCsvRequest=true&"
														+ param;
											}
										}
									}]
								}],
								dockedItems : [{
											xtype : 'container',
											dock : 'bottom',
											//margin:10,
											html : legendshtml
										}]
							};
							innerArray.push(innerpaneldaily);

							var monthlychartObj = subObj['monthlyChartObj'];
							var monthlyObjXML;
							var monthlytitle;
							if(monthlychartObj!=undefined)
							{
								 monthlyObjXML = monthlychartObj['chartXML'];
								 monthlytitle = monthlychartObj['monthlysubtitle'];
								 s_qryString = monthlychartObj['s_qryString'];

							}
							disable = false;
							if (monthlyObjXML != undefined) {

								if (monthlyObjXML == 'nomeasures') {
									htm = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';
									disable = true;
								} else {
									htm = '<div style="border:0px solid red;text-align:center""><div id="monthlyChart'
											+ i + j + '"></div></div>';
								}
							}

							var innerpanelmonthly = {
								xtype : 'panel',
								title : monthlytitle,
								height : height,
								//cls:'containerShadow',
								ui:'newGraphPanel graphHeaderBottomBorder',
								margin:'0 10 10 0',
								padding:0,
								html : htm,
								tools : [
									{
									xtype : 'container',
									margin : '0 1px 0 1px',
									cls : 'iconBg',
									disabled : disable,
									items : [{
										xtype : 'button',
										iconCls : 'iconData',
										name : 'data',
										data : s_qryString,
										tooltip : '<b>Data</b>',
										style : {
											background : 'none',
											border : '0px'
										},
										listeners : {
											'click' : function(thisObj, e,
													eopts) {

												window
														.open(
																thisObj.data,
																"PHYSICALSERVERSRESOURCES",
																"width=970,height=600,left=30,top=50,scrollbars=1,scrollbars=yes,resizable");
											}
										}
									}]

								},{
									xtype : 'container',
									margin : '0 1px 0 1px',
									cls : 'iconBg',
									disabled : disable,
									items : [{
										xtype : 'button',
										iconCls : 'iconCsv',
										name : 'csv',
										data : s_qryString,
										tooltip : '<b>CSV</b>',
										style : {
											background : 'none',
											border : '0px'
										},
										listeners : {
											'click' : function(thisObj, e,
													eopts) {
												var param = thisObj.data;
												param = param.substring(param
														.indexOf("?")
														+ 1);
												document.location.href = "../servlet/com.eg.ErPhysicalServersResourcesReportC?isCsvRequest=true&"
														+ param;
											}
										}
									}]
								}]
							};
							innerArray.push(innerpanelmonthly);
						}

						var pan = {
							xtype : 'panel',
							margin:'10 10 10 10',
							//header:{cls:'networkheader'},
							//bodyCls:'networkborder',
							ui:'multiGraphPanel',
							border:true,
							frame:false,
							id:'pan_'+i,
							//bodyPadding :5,
							//frameHeader : false,
							layout : 'column',
							title : obj['title'],
							defaults : {
								columnWidth : '0.5',
								height : 250,
							},
							items : innerArray
						};
						itemsArray.push(pan);
					}

					var dtpanel = Ext.getCmp('dtpanel');
					//dtpanel.setTitle(compType+'-'+'Resources Report');
					dtpanel.removeAll();
					dtpanel.add(itemsArray);
					dtpanel.doLayout();

					for (var k in jsonArray) {
						var obj = jsonArray[k];
						var chartArray = obj['chartArray'];
						if (chartArray.length>0)
						{
							for (var j in chartArray) {
								var subObj = chartArray[j];
								var dailychartObj = subObj['dailychartObj'];
								var dailyObjXML;
								if(dailychartObj!=undefined)
								{
									dailyObjXML = dailychartObj['chartXML'];
								}

								var monthlychartObj = subObj['monthlyChartObj'];

								var monthlyObjXML;
								if(monthlychartObj!=undefined)
								{
									monthlyObjXML = monthlychartObj['chartXML'];
								}
								if (dailyObjXML != undefined) {
										if (dailyObjXML != 'nomeasures') {
										if(appConstants.chartType=='fusionchart')
											{

											if (FusionCharts("dailyChartID" + k+j ))
												FusionCharts("dailyChartID" +k+j).dispose();
											var chart1 = new FusionCharts(
													"/final/FusionCharts/swf/MSColumnLine3D.swf",
													"dailyChartID" + k+j, "100%", "250", "0",
													"1");
											chart1.setDataXML(dailyObjXML);
											chart1.render('dailyChart' + k + j);
										}

										else if(appConstants.chartType=='highchart')
										{
											var highchart = {};
											//highchart = jQuery.extend(true, {}, getHighChartsBarInstance('dailyChart' + k + j,dailychartObj.chartHeight,dailychartObj.chartWidth), highchart);
											highchart = jQuery.extend(true, {}, getHighChartsBarInstance('dailyChart' + k + j,dailychartObj.chartHeight,500), highchart);
											highchart.setData(dailychartObj,'<%=currentDateFormat%>','');
											highchart.drawChart();
										}
									 }
									else
									{
									//	Ext.get('dailyChart' + k + j).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');
									 
									}
								}
								if (monthlyObjXML != undefined) {
									if (monthlyObjXML != 'nomeasures') {
										if(appConstants.chartType=='fusionchart')
										{
											if (FusionCharts("monthlyChartID" +k+ j))
												FusionCharts("monthlyChartID" + k+j).dispose();
											var chart1 = new FusionCharts(
													"/final/FusionCharts/swf/MSColumnLine3D.swf",
													"monthlyChartID" + k+j, "100%", "250", "0",
													"1");
											chart1.setDataXML(monthlyObjXML);
											chart1.render('monthlyChart' + k + j);
										}
										else if(appConstants.chartType=='highchart')
										{
											var highchart = {};
											highchart = jQuery.extend(true, {}, getHighChartsBarInstance('monthlyChart' + k + j,monthlychartObj.chartHeight,monthlychartObj.chartWidth), highchart);
											highchart.setData(monthlychartObj,'<%=currentDateFormat%>','');
											highchart.drawChart();
										}

									}
									else
									{
										//Ext.get('dailyChart' + k + j).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');
									 
									}
								}
							}							
						}
						else
						{							
							dtpanel.remove('pan_'+k,true);
						}
					}					
					
					if (dtpanel.items.length==0)
					{
						dtpanel.hide();
						this.getNomeasurepanel().show();
					}
					else
					{
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonObject.selectionDetails);
					}
				}

				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("bookletTool").setDisabled(false);
                Ext.getCmp("printTool").setDisabled(false);
                Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("upbutton").setDisabled(false);
			}

		});

	},
	openinNewWin : function(paramVal) {

		var form = this.getVirtualizationresourcesmainform().getForm();
		var virtualformObj = this.getMainform();
		var hiddenFields = virtualformObj.hiddenFields;
		var stDate = hiddenFields['s_start_time_days'];
		var edDate = hiddenFields['s_enddate_fordays'];

		if (paramVal.indexOf("Daily") < 0) {
			stDate = hiddenFields['s_start_time_months'];
			edDate = hiddenFields['s_end_date_forMonth'];

		}

		var strthr = hiddenFields['starthr'];
		var endhr = hiddenFields['endhr'];
		var strtmin =hiddenFields['startmin'];
		var endmin = hiddenFields['endmin'];

		var s_url = "/final/reporter/ErPhysicalServersResourcesBigWindow.jsp?"
				+ paramVal + "&startdate=" + stDate + "&enddate=" + edDate
				+ "&starthr=" + strthr + "&endhr=" + endhr + "&startmin="
				+ strtmin + "&endmin=" + endmin;
s_url+="&er_RmDispName="+appConstants.er_RmDispName;

parent.generalpopup(s_url);

	},
	showHideReportTextbox : function(combo, records, eOpts){

		var form = combo.up('.form').getForm();
		var reporttextbox = form.findField('bgReportName');
		if(combo.getValue()=='background')
		  reporttextbox.show();
		else
		  reporttextbox.hide();

	},
	add : function(button) {

        var virtualformObj = this.getVirtualizationresourcesmainform();
        var form = virtualformObj.getForm();

        var er_option = form.findField('analysis').getValue();
        var param = 'er_option=' + er_option;
        if (er_option != null) {
            var er_site = '';
            if (er_option == 'Service') {
                er_site = form.findField('Service').getValue();
            } else if (er_option == 'Segment') {
                er_site = form.findField('Segment').getValue();
            } else if (er_option == 'Zone') {
                er_site = form.findField('Zone').getValue();
            }

            if (er_site != null && er_site == '-1') {
                Ext.Msg.show({
                            title : 'Alert',
                            msg : 'Please select a ' + er_option,
                            buttons : Ext.Msg.OK,
                            icon : Ext.Msg.WARNING
                        });
                return;
            }

            param += '&er_site=' + er_site;
        }
        var er_comptype = form.findField('compType').getValue();
        param += '&er_comptype=' + er_comptype;
        if (er_comptype == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component type',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }

        var er_component = Ext.getCmp('components').getValue();

        if (er_component == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }
        var er_criteria = Ext.getCmp('Criteria').getValue();

        if (er_criteria == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Criteria',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }

        var compParam = "";

        for (var tr in er_component) {
            compParam += "&er_component=" + er_component[tr];
        }

        var criteriaParams = "";
        for (var cr in er_criteria) {
            criteriaParams += "&er_criteria=" + er_criteria[cr];
        }

        var hiddenFields = appConstants.defaultJSON['hiddenFields'];

        for (var hiddenField in hiddenFields) {
            var val = hiddenFields[hiddenField];
            if (val == 'NONE')
                val = '';

            param += '&' + hiddenField + '=' + val;
        }

        param += '&timefrom=00&timeto=24&minfrom=00&minto=00&isSubmit=true&userID='
                + appConstants.userID
                + '&sessionId='
                + appConstants.sessionId
                + compParam
                + criteriaParams;



        var target = "";
		var windowClass;
		var frameId;
		var fromFavoriteModify = appConstants.defaultJSON['hiddenFields']["fromFavoriteModify"];
        if ((button.getId() == "scheduleImg" || button.getId() == "save") && (fromFavoriteModify == null))
		{
			//windowClass='scheduleWindow';
			//frameId='#schWin';
			target = "/final/reporter/ErSaveSchedule.jsp?" + param+'&com.eg.CSRF_NONCE='+csrfToken;//+'&er_rtype=Virtualization';
			if ( button.getId() == "save")
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			} else {
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}

		}
		else{ //if (button.getId() == "favImg")
			//var hiddenFields =  virtualformObj.hiddenFields;
			var favorite_id = appConstants.defaultJSON['hiddenFields']["favorite_id"];
			if ( button.getId() == "save")
			{
				 target = "../servlet/com.eg.ErFavoriteC?cmd=client&"+ param+'&com.eg.CSRF_NONCE='+csrfToken;//+'&er_rtype=Virtualization';
				//document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			} else {
					target = "../servlet/com.eg.ErFavoriteC?cmd=client&"+ param+"&er_RmDispName="+appConstants.er_RmDispName+'&com.eg.CSRF_NONCE='+csrfToken;//+'&er_rtype=Virtualization';
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}



		}
       // var target = url;
		//Ext.widget(windowClass).show();
		//Ext.select(frameId).set({src :target});
    },
    saveFileTool : function(){

    	 var virtualformObj = this.getVirtualizationresourcesmainform();
        var form = virtualformObj.getForm();

        var er_option = form.findField('analysis').getValue();
        var param = 'er_option=' + er_option;
        if (er_option != null) {
            var er_site = '';
            if (er_option == 'Service') {
                er_site = form.findField('Service').getValue();
            } else if (er_option == 'Segment') {
                er_site = form.findField('Segment').getValue();
            } else if (er_option == 'Zone') {
                er_site = form.findField('Zone').getValue();
            }

            if (er_site != null && er_site == '-1') {
                Ext.Msg.show({
                            title : 'Alert',
                            msg : 'Please select a ' + er_option,
                            buttons : Ext.Msg.OK,
                            icon : Ext.Msg.WARNING
                        });
                return;
            }

            param += '&er_site=' + er_site;
        }
        var er_comptype = form.findField('compType').getValue();
        param += '&er_comptype=' + er_comptype;
        if (er_comptype == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component type',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }

        var er_component = Ext.getCmp('components').getValue();

        if (er_component == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }
        var er_criteria = Ext.getCmp('Criteria').getValue();

        if (er_criteria == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Criteria',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }

        var compParam = "";

        for (var tr in er_component) {
            compParam += "&er_component=" + er_component[tr];
        }

        var criteriaParams = "";
        for (var cr in er_criteria) {
            criteriaParams += "&er_criteria=" + er_criteria[cr];
        }

      var hiddenFields = appConstants.defaultJSON['hiddenFields'];

        for (var hiddenField in hiddenFields) {
            var val = hiddenFields[hiddenField];
            if (val == 'NONE')
                val = '';

            param += '&' + hiddenField + '=' + val;
        }

        param += '&timefrom=00&timeto=24&minfrom=00&minto=00&isSubmit=true&userID='
                + appConstants.userID
                + '&sessionId='
                + appConstants.sessionId
                + compParam
                + criteriaParams;
        param+='&pdfprint=yes&er_width=450&er_height=250';

        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + param
                + "&er_view=PRINT";
		 if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
    },
    printFile : function(){

    	var virtualformObj = this.getVirtualizationresourcesmainform();
        var form = virtualformObj.getForm();

        var er_option = form.findField('analysis').getValue();
        var param = 'er_option=' + er_option;
        if (er_option != null) {
            var er_site = '';
            if (er_option == 'Service') {
                er_site = form.findField('Service').getValue();
            } else if (er_option == 'Segment') {
                er_site = form.findField('Segment').getValue();
            } else if (er_option == 'Zone') {
                er_site = form.findField('Zone').getValue();
            }

            if (er_site != null && er_site == '-1') {
                Ext.Msg.show({
                            title : 'Alert',
                            msg : 'Please select a ' + er_option,
                            buttons : Ext.Msg.OK,
                            icon : Ext.Msg.WARNING
                        });
                return;
            }

            param += '&er_site=' + er_site;
        }
        var er_comptype = form.findField('compType').getValue();
        param += '&er_comptype=' + er_comptype;
        if (er_comptype == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component type',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }

        var er_component = Ext.getCmp('components').getValue();

        if (er_component == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }
        var er_criteria = Ext.getCmp('Criteria').getValue();

        if (er_criteria == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Criteria',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }

        var compParam = "";

        for (var tr in er_component) {
            compParam += "&er_component=" + er_component[tr];
        }

        var criteriaParams = "";
        for (var cr in er_criteria) {
            criteriaParams += "&er_criteria=" + er_criteria[cr];
        }

      var hiddenFields = appConstants.defaultJSON['hiddenFields'];

        for (var hiddenField in hiddenFields) {
            var val = hiddenFields[hiddenField];
            if (val == 'NONE')
                val = '';

            param += '&' + hiddenField + '=' + val;
        }

        param += '&timefrom=00&timeto=24&minfrom=00&minto=00&isSubmit=true&userID='
                + appConstants.userID
                + '&sessionId='
                + appConstants.sessionId
                + compParam
                + criteriaParams;
        var s_qryString='/final/reporter/ErPhysicalServersResourcesReportPrint.jsp?'+param;

            s_qryString+="&er_RmDispName="+appConstants.er_RmDispName+"&pageWidthProces=700&pdfPrint=yes&";

		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


			/* printWindow.on('show',function(){
       // var s_qryString = "YOUR QUERY"  //query string to load the popup
        var printContentDiv = parent.Ext.select('#printContentDiv1');  // id of the popup window
                    printContentDiv.set({
                        src: s_qryString
                    });
           });
         printWindow.show();*/

    },
	bookletQuery: function(obj)
	{
		var virtualformObj = this.getVirtualizationresourcesmainform();
        var form = virtualformObj.getForm();
        var er_option = form.findField('analysis').getValue();
        var param = 'er_option=' + er_option;
        if (er_option != null) {
            var er_site = '';
            if (er_option == 'Service') {
                er_site = form.findField('Service').getValue();
            } else if (er_option == 'Segment') {
                er_site = form.findField('Segment').getValue();
            } else if (er_option == 'Zone') {
                er_site = form.findField('Zone').getValue();
            }
            if (er_site != null && er_site == '-1') {
                Ext.Msg.show({
                            title : 'Alert',
                            msg : 'Please select a ' + er_option,
                            buttons : Ext.Msg.OK,
                            icon : Ext.Msg.WARNING
                        });
                return;
            }
            param += '&er_site=' + er_site;
        }
        var er_comptype = form.findField('compType').getValue();
        param += '&er_comptype=' + er_comptype;
        if (er_comptype == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component type',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }
        var er_component = Ext.getCmp('components').getValue();
        if (er_component == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }
        var er_criteria = Ext.getCmp('Criteria').getValue();
        if (er_criteria == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Criteria',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }
        var compParam = "";
        for (var tr in er_component) {
            compParam += "&er_component=" + er_component[tr];
        }
        var criteriaParams = "";
        for (var cr in er_criteria) {
            criteriaParams += "&er_criteria=" + er_criteria[cr];
        }
      var hiddenFields = appConstants.defaultJSON['hiddenFields'];
        for (var hiddenField in hiddenFields) {
            var val = hiddenFields[hiddenField];
            if (val == 'NONE')
                val = '';
            param += '&' + hiddenField + '=' + val;
        }
        param += '&timefrom=00&timeto=24&minfrom=00&minto=00&isSubmit=true&userID='
                + appConstants.userID
                + '&sessionId='
                + appConstants.sessionId
                + compParam
                + criteriaParams;
        var s_qryString=param;
        s_qryString+="&er_RmDispName="+appConstants.er_RmDispName+"&pageWidthProces=700&pdfPrint=yes&";
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var virtualformObj = this.getVirtualizationresourcesmainform();
        var form = virtualformObj.getForm();
        var er_option = form.findField('analysis').getValue();
        bookletquery += 'er_option=' + er_option;
        if (er_option != null) {
            var er_site = '';
            if (er_option == 'Service') {
                er_site = form.findField('Service').getValue();
            } else if (er_option == 'Segment') {
                er_site = form.findField('Segment').getValue();
            } else if (er_option == 'Zone') {
                er_site = form.findField('Zone').getValue();
            }

            if (er_site != null && er_site == '-1') {
                Ext.Msg.show({
                            title : 'Alert',
                            msg : 'Please select a ' + er_option,
                            buttons : Ext.Msg.OK,
                            icon : Ext.Msg.WARNING
                        });
                return;
            }

            bookletquery += '&er_site=' + er_site;
        }
        var er_comptype = form.findField('compType').getValue();
        bookletquery += '&er_comptype=' + er_comptype;
        if (er_comptype == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component type',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }

        var er_component = Ext.getCmp('components').getValue();

        if (er_component == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Component',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }
        var er_criteria = Ext.getCmp('Criteria').getValue();

        if (er_criteria == '-1') {
            Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select a Criteria',
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });
            return;
        }


        for (var tr in er_component) {
            bookletquery += "&er_component=" + er_component[tr];
        }

        for (var cr in er_criteria) {
            bookletquery += "&er_criteria=" + er_criteria[cr];
        }

        var hiddenFields = appConstants.defaultJSON['hiddenFields'];

        for (var hiddenField in hiddenFields) {
            var val = hiddenFields[hiddenField];
            if (val == 'NONE')
                val = '';

            bookletquery += '&' + hiddenField + '=' + val;
        }

        bookletquery += '&timefrom=00&timeto=24&minfrom=00&minto=00&isSubmit=true&userID='+ appConstants.userID+ '&sessionId='+ appConstants.sessionId;
        bookletquery+="&er_RmDispName="+appConstants.er_RmDispName+"&pageWidthProces=700&pdfPrint=yes&";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
    sendMail : function(){
    	var windowMail = Ext.widget('sendmail');
        windowMail.show();
    }
});