// JavaScript Document

Ext.define('VirtualizationResourcesApp.view.MainForm',{
	extend:'Ext.form.Panel',
	requires:[
		'VirtualizationResourcesApp.view.VirtualizationResourcesMainForm',
		'VirtualizationResourcesApp.view.EgComponent',
		'VirtualizationResourcesApp.view.Criteria'
	],
	alias:'widget.mainform',
	collapseMode:'mini',
	id:'mainform',
	ui:'newFormPanel',
	margin:'10 10 0 10',
	layout: 'hbox',
	initComponent: function(){
		this.bodyPadding ='10 10 10 10';
		this.buttonAlign = 'center';
		this.callParent();
	},
	items:[
		{xtype: 'virtualizationresourcesmainform',flex:1},
		{xtype: 'egcomponent',margin:'0 10 0 0'},
		{xtype: 'criteria'},
		{
			xtype:'button',
			text: submitValue,
			ui:'newButtonSmall',
			id: 'submit',
			name: 'submit',
			margin:'116 0 0 0'
		},
		{
			xtype:'button',
			text: "Save",
			ui:'newButtonSmall',
			id: "save",
			name: "save",
			margin:'116 0 0 0'
		},
		{
			xtype:'button',
			cls:'iconPanelUpArrow',
			id:'panelinsidetoggle',
			border:false,
			bodyStyle:{'background':'none'},
			hidden:true
		}
			],
	loadDefaultData : function(jsonObject){

						this.screenLabels = jsonObject['screenlabels'];

						var thisForm = this.getForm();

						var hiddenFields = jsonObject['hiddenFields'];
						var from_schedule = hiddenFields["fromScheduleModify"];
						var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
						if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
							Ext.getCmp("submit").hide();
							Ext.getCmp("save").show();
						}else{
							Ext.getCmp("submit").show();
							Ext.getCmp("save").hide();
						}
						var analysisby = thisForm.findField('analysis');
						analysisby.getStore().loadRawData(jsonObject['analysisCombodata']);
						analysisby.setValue(jsonObject['analysisby_value']);
						var analysisby_value = jsonObject['analysisby_value'];
						if(analysisby_value!=undefined)
						{
							if(analysisby_value=='Zone')
							{
								thisForm.findField('Zone').show();
								thisForm.findField('subzone').show();
								thisForm.findField('Zone').getStore().loadRawData(jsonObject['zonelistcombo']);
								thisForm.findField('Zone').setValue(jsonObject['zonelistcombo_value']);
							}
							else if(analysisby_value=='Service')
							{
								thisForm.findField('Service').show();
								thisForm.findField('Service').getStore().loadRawData(jsonObject['ServiceListCombo']);
								thisForm.findField('Service').setValue(jsonObject['ServiceListCombo_value']);
							}
							else if(analysisby_value=='Segment')
							{
								thisForm.findField('Segment').show();
								thisForm.findField('Segment').getStore().loadRawData(jsonObject['segmentListCombo']);
								thisForm.findField('Segment').setValue(jsonObject['segmentListCombo_value']);
							}
						}

						var comptype = thisForm.findField('compType');
						comptype.getStore().loadRawData(jsonObject['comptypeCombodata']);
                        comptype.setValue(jsonObject['comptypeCombovalue']);

						var component = Ext.getCmp('components');
						component.getStore().loadRawData(jsonObject['compCombodata']);
						appConstants.rawDataForComponents = jsonObject['compCombodata'];
						if (jsonObject.hasOwnProperty("compCombovalue"))
						{
							  component.setValue(jsonObject.compCombovalue);
						}
						else
						{
							 var values = [];
							component.getStore().each( function( re ) {
								values.push ( re.get('valueField') );
							}, this);
							component.setValue(values);
						}  

                        var criteria = thisForm.findField('Criteria');
                        criteria.getStore().loadRawData(jsonObject['criteriaCombodata']);
                        appConstants.rawDataForCriteria=jsonObject['criteriaCombodata'];
                        var values = [];
						var selectedCriteria=jsonObject['selectedcriteriacombodata'];

						if ( !Ext.isEmpty(selectedCriteria) )
						{
							for(i=0; i<selectedCriteria.length; i++)
							{
                        				criteria.getStore().each( function( re ) {
												values.push ( selectedCriteria[i].valueField );
											}, this);
							  criteria.setValue(values);
							}
						}
						else
						{
							//criteria.setValue(compRawData[0].valueField);
							 criteria.getStore().each( function( re ) {
									values.push ( re.get('valueField') );
							  }, this);
							 criteria.setValue(values);
						}


                        var reportGeneration = thisForm.findField('reportGeneration');
                        reportGeneration.getStore().loadRawData(jsonObject['reportgenCombodata']);
                        reportGeneration.setValue(jsonObject['reportgenCombovalue']);


                       this.hiddenFields = jsonObject['hiddenFields'];
					   updatingComponentandTypes();
					}
	});



