
Ext.define('virtualizationsprawlreports.controller.VirtualizationSprawlController',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
 		{selector:'virtualizationsprawlform', ref:'virtualizationsprawlform'},
		{selector:'mainform', ref:'Mainform'},
		{selector:'Component', ref:'component'},
		{selector:'virtualizationsprawlsettings', ref:'virtualizationsprawlsettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.loadDefaults
			},
			'virtualizationsprawlsettings':{
				'afterrender':this.loadSettingsElements
			},
			'mainform button[id="panelinsidetoggle"]': {
                'click': this.toggleForm
            },
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'virtualizationsprawlform combo[name="report_type"]':{
				'select': this.grpComboChange
			},
			'virtualizationsprawlform combo[name="analysisBy"]':{
				'select': this.grpComboChange
			},
			'virtualizationsprawlform combo[name="infraType"]':
			{
				'select': this.grpComboChange
			},
			'virtualizationsprawlform combo[name="comp_type"]':
			{
				'select': this.grpComboChange
			},
			'virtualizationsprawlform combo[name="component"]':
			{
				'select': this.grpComboChange
			},
			'virtualizationsprawlform combo[name="cluster"]':
			{
				'select': this.grpComboChange
			},
			'virtualizationsprawlform combo[name="serv_type"]':
			{
				'select': this.grpComboChange
			},
			'mainform button[name="submit"]' :
			{
				'click' : this.beforeReportSubmit
			},
			'mainform button[name="save"]' :
			{
				'click' : this.goTo
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'reportgeneration combo[name="reportGeneration"]':
			{
				'select': this.showBackgroundReport
			},
			'mainform button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'virtualizationsprawlsettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualizationsprawlsettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			}
		});
	},filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp('serverList'),appConstants.rawDataForComponents);
    },
    changeEr_mode: function (combo) {
		var hiddenFields =  appConstants.publicJsonData['hiddenParams'];
		var from_schModify = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.beforeReportSubmit();
     },
		goTo: function (obj) {
		var hiddenFields =  appConstants.publicJsonData['hiddenParams'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		appConstants.formButtonId = obj.getId();
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite();
		}
    },
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('serverList'),'Servers',btn);
	},
	timeLineOnChange : function(combo)
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var meController = this;
		var mainForm = this.getVirtualizationsprawlform().getForm();
		var startdateObj = mainForm.findField('er_stdate');
		var enddateObj = mainForm.findField('er_enddate');
		var startHourObj = mainForm.findField('er_sthr');
		var endHourObj = mainForm.findField('er_endhr');

		var changeTimeline =false;
		if ( combo.getValue() == 'Any' )
		{
			startdateObj.setDisabled(false);
			enddateObj.setDisabled(false);
			startHourObj.setDisabled(false);
			endHourObj.setDisabled(false);
		}
		else
		{
			startdateObj.setDisabled(true);
			enddateObj.setDisabled(true);
			startHourObj.setDisabled(true);
			endHourObj.setDisabled(true);
			changeTimeline = true;
		}

		if(changeTimeline==true)
		{
			var er_timeline = mainForm.findField('er_timeline').getValue();
			var stDate = startdateObj.getValue();
			var enDate = enddateObj.getValue();
			var startdate = Ext.Date.dateFormat(stDate, mgrDateFormat);
			var enddate = Ext.Date.dateFormat(enDate, mgrDateFormat);
			var startHour = mainForm.findField('er_sthr').getValue();
			var endHour = mainForm.findField('er_endhr').getValue();

			stDate.setHours(startHour);
			enDate.setHours(endHour);

			if(er_timeline!=null && er_timeline=="Any")
			{
				if(!checkDateTime(stDate,enDate))
				{
					return;
				}
			}
			var no_params= '&P0=['+er_timeline+']&P1=['+startdate+']&P2=['+enddate+']&P3=['+startHour+']&P4=['+endHour+']&P5=['+appConstants.iniDateFormat+']';
			var me = this;
			var param = 'F=getTime&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
			Ext.Ajax.request({
				url: remoteURL,
				method: 'POST',
				async: false,
				params: param,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var timelineValues = jsonData['timeline'];
						var startdateObj = mainForm.findField('er_stdate');
						var enddateObj = mainForm.findField('er_enddate');
						var startHourObj = mainForm.findField('er_sthr');
						var endHourObj = mainForm.findField('er_endhr');

						var stDate = timelineValues[0];
						var endDate = timelineValues[1];
						var startHr = timelineValues[2];
						var endHr = timelineValues[3];

						startdateObj.setValue(stDate);
						enddateObj.setValue(endDate);
						startHourObj.setValue(startHr);
						endHourObj.setValue(endHr);

						meController.callPopulate();
					}
				}
			});
		}
	},
	callRemoteScript: function( form, fieldName, remoteURL, no_params, funcName )
	{
		var me = this;
		var param = 'F='+funcName+'&C=jsrs1'+no_params+'&debug=true&U='+new Date().getTime()+'&fromajax=true';
		if(fieldName=='statustCombo')
			param = param+'&statusCombo=true';
		Ext.Ajax.request({
			url: remoteURL,
			method: 'POST',
			async: false,
			params: param,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var comboVal = jsonData['combo'];
					if ( !Ext.isEmpty( comboVal ) )
					{
						var thisStore = form.findField(fieldName).getStore();
						thisStore.loadRawData(comboVal);

						if(thisStore.getCount()>1)
						{
							thisStore.insert(0,{
							'displayField':allOptionMsg,
							'valueField':'-1'
							});
							form.findField(fieldName).setValue("-1");
						}
						else
						{
							form.findField(fieldName).setValue(comboVal[0]['valueField']);
						}
					}
					else
					{
						form.findField(fieldName).setValue(appConstants.notApplicableLbl);
					}
				}
			}
		});
	},
	updateQueryString : function(from)
	{
		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();
        	var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getVirtualizationsprawlsettings().getForm();
		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();
		var er_comptype = mainForm.findField('comp_type').getValue();
		var er_cluster = mainForm.findField('cluster').getValue();
		var er_server_type = mainForm.findField('serv_type').getValue();
		var er_component = mainForm.findField('component').getValue();

		appConstants.publicJsonData['hiddenParams']['er_datafrom'] = analysisBy;

		var paramsForChange = '&er_type='+report_type+'&er_option='+analysisBy;

		if(from!=null && from=='infraType')
		{
			var selectedGpName = mainForm.findField('infraType').getValue();

			if(analysisBy!=null && analysisBy=='Zone')
			{
				var incSubZone = mainForm.findField('subzone').getValue();

				paramsForChange = paramsForChange+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
			}
			else if(analysisBy!=null && analysisBy=='Segment')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			else if(analysisBy!=null && analysisBy=='Service')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
		}
		else if(from!=null && from=='comp_type')
		{
			var selectedGpName = mainForm.findField('infraType').getValue();

			if(analysisBy!=null && analysisBy=='Zone')
			{
				var incSubZone = mainForm.findField('subzone').getValue();

				paramsForChange = paramsForChange+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
			}
			else if(analysisBy!=null && analysisBy=='Segment')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			else if(analysisBy!=null && analysisBy=='Service')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			paramsForChange = paramsForChange+'&er_comptype='+er_comptype;

			paramsForChange = paramsForChange+'&isComponentTypeChange=true';
		}
		else if(from!=null && from=='component')
		{
			var selectedGpName = mainForm.findField('infraType').getValue();

			if(analysisBy!=null && analysisBy=='Zone')
			{
				var incSubZone = mainForm.findField('subzone').getValue();

				paramsForChange = paramsForChange+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
			}
			else if(analysisBy!=null && analysisBy=='Segment')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			else if(analysisBy!=null && analysisBy=='Service')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			paramsForChange = paramsForChange+'&er_comptype='+er_comptype+'&er_component='+er_component;

			paramsForChange = paramsForChange+'&isComponentChange=true';
		}
		else if(from!=null && from=='cluster')
		{
			var selectedGpName = mainForm.findField('infraType').getValue();

			if(analysisBy!=null && analysisBy=='Zone')
			{
				var incSubZone = mainForm.findField('subzone').getValue();
				paramsForChange = paramsForChange+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
			}
			else if(analysisBy!=null && analysisBy=='Segment')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			else if(analysisBy!=null && analysisBy=='Service')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			paramsForChange = paramsForChange+'&er_comptype='+er_comptype+'&er_component='+er_component;

			paramsForChange = paramsForChange+'&er_cluster='+encodeURIComponent(er_cluster);
		}
		else if(from!=null && from=='serv_type')
		{
			var selectedGpName = mainForm.findField('infraType').getValue();

			if(analysisBy!=null && analysisBy=='Zone')
			{
				var incSubZone = mainForm.findField('subzone').getValue();

				paramsForChange = paramsForChange+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
			}
			else if(analysisBy!=null && analysisBy=='Segment')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			else if(analysisBy!=null && analysisBy=='Service')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			paramsForChange = paramsForChange+'&er_comptype='+er_comptype+'&er_component='+er_component;
			paramsForChange = paramsForChange+'&er_cluster='+encodeURIComponent(er_cluster)+'&er_server_type='+er_server_type;
		}
		else if(from==null || (from!=null && (from=='report_type' || from=='submit')))
		{

			var selectedGpName = mainForm.findField('infraType').getValue();
			if(analysisBy!=null && analysisBy=='Zone')
			{
				var incSubZone = mainForm.findField('subzone').getValue();

				paramsForChange = paramsForChange+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
			}
			else if(analysisBy!=null && analysisBy=='Segment')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}
			else if(analysisBy!=null && analysisBy=='Service')
			{
				paramsForChange = paramsForChange+'&er_site='+selectedGpName;
			}


			paramsForChange = paramsForChange+'&er_comptype='+er_comptype+'&er_component='+er_component;

			paramsForChange = paramsForChange+'&er_cluster='+encodeURIComponent(er_cluster)+'&er_server_type='+er_server_type;

			var er_server = "";
			var serverArr = new Array();
			serverArr = componentmainForm.findField('serverList').getValue();

			if(serverArr!=null && (serverArr!="" && serverArr!="null"))
			{
				for ( var i = 0; i < serverArr.length; i++ )
				{
					er_server += "&er_server="+serverArr[i];
				}
			}

			if(er_server!=null && er_server!='')
			{
				paramsForChange += er_server;
			}
		}
		var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var startdate = mainForm.findField('er_stdate').dataArray;
		var enddate =mainForm.findField('er_enddate').dataArray;
		var startHour = mainForm.findField('er_sthr').dataArray;
		var endHour = mainForm.findField('er_endhr').dataArray;
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		paramsForChange = paramsForChange+"&er_stdate="+startdate+"&er_enddate="+enddate+"&er_sthr="+startHour+"&er_endhr="+endHour+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&er_reportgenration="+reportgen+"&er_timeline="+er_timeline;

		if(report_type!=null && report_type=='Yes')
		{
			var metricVal = this.getSettingsFieldValue(settingsForm,'metricCombo',isSettingsEnabled,'er_display');
			var priority = this.getSettingsFieldValue(settingsForm,'priorityCombo',isSettingsEnabled,'selectedPriorityValue');
			paramsForChange = paramsForChange+'&er_display='+metricVal+'&er_priority='+priority;
		}

		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+hiddenData[hid];
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			paramsForChange = hiddenQstr+paramsForChange;
		}

		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			reportName=checkFileName(reportName);
			paramsForChange = paramsForChange+'&forwardto=ErVcVmSprawlReportJson&bg_reportname='+reportName;
			appConstants.urlForSubmit = '../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true';
		}
		else if ( reportgen!=null && reportgen == 'background-csv')
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			reportName=checkFileName(reportName);
			paramsForChange = paramsForChange+'&forwardto=ErVcVmSprawlReportJson&bg_reportname='+reportName;
			appConstants.urlForSubmit = urlforAjax ="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
		}
		else
		{
			paramsForChange = paramsForChange+'&forwardto=ErVcVmSprawlReport';
			appConstants.urlForSubmit = "../servlet/com.eg.ErVmSprawlReportC?isSubmit=true";
		}
		paramsForChange+="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString = paramsForChange;

	},
	grpComboChange : function(combo)
	{
		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var meSettingsForm = this.getVirtualizationsprawlsettings().getForm();

		var comboId = combo.getId();
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		this.updateQueryString(comboId);
		Ext.Ajax.request({
				url : '/final/reporter/ErVcVmSprawlReportJson.jsp',
				params: appConstants.queryString+"&action=defaultLoad",
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicJsonData = jsonData;
					//
					appConstants.reporGene= jsonData;
					appConstants.publicJsonData = jsonData;
					if (isSettingsEnabled)
					{
						var reportGen = Ext.getCmp('reportGeneration');
						var reportGenCombo = jsonData.repGenOpts;
						var selreportGeneration = jsonData.repGenOpts[0].valueField;
						reportGen.setFieldLabel(jsonData['screenLabels']['reporter.common.Report Generation']);
						reportGen.getStore().loadRawData(reportGenCombo);
						reportGen.setValue(selreportGeneration);
						var reportNameObj = Ext.getCmp('bgReportName');
						if(selreportGeneration!=undefined && selreportGeneration!=null && selreportGeneration=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
					//
					var selectedGroup = jsonData['pageParams']['selectedAnalysisOption'];

					if(comboId!=null && comboId=='analysisBy')
					{
						if(selectedGroup!=null && selectedGroup=='Zone')
						{
							var zoneCombo =mainForm.findField('infraType');
							zoneCombo.getStore().removeAll();
							zoneCombo.getStore().clearFilter(true); 
							zoneCombo.getStore().loadRawData(jsonData['grpOptsJson']);
							zoneCombo.setValue(jsonData['pageParams']['selectedGrpValue']);
							zoneCombo.setFieldLabel(jsonData['screenLabels']['grpLbl']);
							zoneCombo.show();

							var subzoneCombo =mainForm.findField('subzone');
							subzoneCombo.getStore().loadRawData(jsonData['yesNoOpts']);
							subzoneCombo.setValue(jsonData['pageParams']['includezone']);
							subzoneCombo.show();
						}
						else if(selectedGroup!=null && selectedGroup=='Segment')
						{
							var segmentCombo =mainForm.findField('infraType');
							segmentCombo.getStore().removeAll();
							segmentCombo.getStore().clearFilter(true);
							segmentCombo.getStore().loadRawData(jsonData['grpOptsJson']);
							segmentCombo.setValue(jsonData['pageParams']['selectedGrpValue']);
							segmentCombo.setFieldLabel(jsonData['screenLabels']['grpLbl']);
							segmentCombo.show();
							mainForm.findField('subzone').hide();
						}
						else if(selectedGroup!=null && selectedGroup=='Service')
						{
							var serviceCombo =mainForm.findField('infraType');
							serviceCombo.getStore().removeAll();
							serviceCombo.getStore().clearFilter(true);
							serviceCombo.getStore().loadRawData(jsonData['grpOptsJson']);
							serviceCombo.setValue(jsonData['pageParams']['selectedGrpValue']);
							serviceCombo.setFieldLabel(jsonData['screenLabels']['grpLbl']);
							serviceCombo.show();
							mainForm.findField('subzone').hide();
						}
						else
						{
							mainForm.findField('infraType').hide();
							mainForm.findField('subzone').hide();
							mainForm.findField('subzone').hide();
						}
					}

					if(comboId=='report_type')
					{
						var er_type = jsonData['pageParams']['er_type'];
						if(er_type!=null && er_type=="Yes")
						{
							meSettingsForm.findField('metricCombo').show();
							Ext.getCmp('rsplitter').show();
							meSettingsForm.findField('priorityCombo').show();
		                    Ext.getCmp("er_mode").show();
						}
						else
						{
							meSettingsForm.findField('metricCombo').hide();
							Ext.getCmp('rsplitter').hide();
							meSettingsForm.findField('priorityCombo').hide();
						    Ext.getCmp("er_mode").hide();
						}
					}

					var compTypeCombo = mainForm.findField('comp_type');
					compTypeCombo.getStore().clearFilter(true); 
					compTypeCombo.getStore().loadRawData(jsonData['compTypeOptsJson']);
					compTypeCombo.setValue(jsonData['pageParams']['selectedCompTypeValue']);

					var componentCombo = mainForm.findField('component');
					componentCombo.getStore().loadRawData(jsonData['componentOptsJson']);
					componentCombo.setValue(jsonData['pageParams']['selectedCompOption']);

					var serverTypeCombo = mainForm.findField('serv_type');
					serverTypeCombo.getStore().loadRawData(jsonData['serverTypeOptsJson']);
					serverTypeCombo.setValue(jsonData['pageParams']['selectedServerTypeOption']);

					var clusterCombo = mainForm.findField('cluster');
					clusterCombo.getStore().loadRawData(jsonData['clusterOptsJson']);
					clusterCombo.setValue(jsonData['pageParams']['selectedClusterOption']);

					var serverListCombo = componentmainForm.findField('serverList');
					serverListCombo.getStore().loadRawData(jsonData['serverOptsJson']);
					appConstants.rawDataForComponents = jsonData['serverOptsJson'];
					serverListCombo.setValue(jsonData['pageParams']['selectedServerOption']);
				}
		});
	},
	loadDefaults:function(){
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJsonData['screenLabels']['pageTitle']);
		this.getVirtualizationsprawlform().loadData();
		var meController = this;
		if(!hideBackButton){
		Ext.getCmp('virtualizationsprawlform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicJsonData['ID']
			}
		);
	}


		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true')
		{
			var er_reportgenration1 = appConstants.publicJsonData['pageParams']['er_reportgenration'];
			if(er_reportgenration1!=null &&( er_reportgenration1!="background" || er_reportgenration1!="background-csv"))
			{
				meController.loadVmSprawlReportData(appConstants.publicJsonData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.beforeReportSubmit();
			}
		}
			appConstants.rawDataForComponents = appConstants.publicJsonData['serverOptsJson'];


	},
	loadSettingsElements:function(){
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicJsonData['hiddenParams'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		this.getVirtualizationsprawlsettings().loadSettingsData();
		var meController = this;
	  Ext.get('closeSettings').on('click', function () {
				//var isSettingsOk= meController.validateSettings();
				
				meController.validateAndCloseSettings();
				
	   });
	},
	validateAndCloseSettings:function()
	{
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		var isSettingsds= this.validateSettings();
		if(isSettingsds)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		 if(this.validateAndCloseSettings())
		{
			this.beforeReportSubmit();
		}
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			//layout:'vbox',
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					cls:'containerHeader',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'virtualizationsprawlsettings',
					parent:this
				}
			],
			renderTo:'virtualizationsprawl-body',
			listeners:{
				render:	function(){
				Ext.EventManager.onWindowResize(function(){
					Ext.get('configMod').setStyle('left', '');
					});


					}
			}
			});

	},
	validateForm : function(flag)
	{
		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();
		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();
		var er_comptype = mainForm.findField('comp_type').getValue();
		var er_cluster = mainForm.findField('cluster').getValue();
		var er_server_type = mainForm.findField('serv_type').getValue();
		var er_component = mainForm.findField('component').getValue();

		if(report_type!=null && report_type=='Not Applicable')
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.chooseReqdParamsMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			return false;
		}

		if(analysisBy!=null && analysisBy=='Not Applicable')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.chooseReqdParamsMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		var selectedGroup = appConstants.publicJsonData['pageParams']['selectedAnalysisOption'];
		if(selectedGroup!=null && selectedGroup=='Zone')
		{
			var zoneCombo =mainForm.findField('infraType').getValue();
			if(zoneCombo!=null && (zoneCombo=="Not Applicable" || zoneCombo=="-1"))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.chooseReqdParamsMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		else if(selectedGroup!=null && selectedGroup=='Segment')
		{
			var segmentCombo =mainForm.findField('infraType').getValue();
			if(segmentCombo!=null && (segmentCombo=="Not Applicable" || segmentCombo=="-1"))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.chooseReqdParamsMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		else if(selectedGroup!=null && selectedGroup=='Service')
		{
			var serviceCombo =mainForm.findField('infraType').getValue();
			if(serviceCombo!=null && (serviceCombo=="Not Applicable" || serviceCombo=="-1"))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.chooseReqdParamsMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		if(er_comptype!=null && er_comptype=='Not Applicable')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.chooseReqdParamsMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		if(er_cluster!=null && er_cluster=='Not Applicable')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.chooseReqdParamsMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		if(er_component!=null && er_component=='Not Applicable')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.chooseReqdParamsMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		if(er_server_type!=null && er_server_type=='Not Applicable')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.chooseReqdParamsMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		var er_server = "";
		var serverArr = new Array();
		serverArr = componentmainForm.findField('serverList').getValue();


		if(serverArr!=null && (serverArr!="" && serverArr!="null"))
		{
			for ( var i = 0; i < serverArr.length; i++ )
			{
				er_server += "&er_server="+serverArr[i];
			}
		}


		if(serverArr!=null && (serverArr=="-1" || serverArr==""))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.chooseReqdParamsMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var isSettingsOk = true;
		var mainForm = this.getVirtualizationsprawlform().getForm();

		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		stDate.setHours(mainForm.findField('er_sthr').getValue());
		enDate.setHours(mainForm.findField('er_endhr').getValue());
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		if(er_timeline!=null && er_timeline=="Any")
		{
			if(!checkDateTime(stDate,enDate))
			{
				return;
			}
		}
        	var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getVirtualizationsprawlsettings().getForm();
		var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = appConstants.publicJsonData['hiddenParams']['er_usertimeline'];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}
		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				return false;
			}
		}

		if ( reportgen!=null && reportgen == 'foreground' )
		{
			if(flag)
			{
				var limitforbg = appConstants.publicJsonData['hiddenParams']['limitforbg'];
				if(!Ext.isEmpty(limitforbg))
				{
					if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,stDate,enDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else
		{
			var reportNameObj = settingsForm.findField('bgReportName');
			var reportName = reportNameObj.getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
//console.log(isSettingsOk);
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}

	},
	beforeReportSubmit: function()
	{
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('panelinsidetoggle').setDisabled(true);

		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();
		var report_type = mainForm.findField('report_type').getValue();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var isValidForm = this.validateForm(true);
		//console.log(isValidForm);
		if(isValidForm)
			this.submitReport();		 
	},
	submitReport : function(combo)
	{
        	var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getVirtualizationsprawlsettings().getForm();
		var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var meController = this;
		this.updateQueryString('submit');
		if(reportgen!=null && reportgen == "foreground")
		{
			appConstants.queryString = appConstants.queryString+'&responseType=json';
		}
		initLdgMask.show();
		Ext.Ajax.request({
			url : appConstants.urlForSubmit,
			params: appConstants.queryString,
			timeout : 180000,
			scope:this,
			success: function(response)
			{
				var jsonText  = response.responseText;
				//console.log(jsonText);
				if(!Ext.isEmpty(jsonText))
				{
					initLdgMask.hide();
					var jsonData=Ext.decode(jsonText);
					meController.loadVmSprawlReportData(jsonData);
				}
			}
		});
	},
	loadVmSprawlReportData : function(jsonData)
	{
		var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getVirtualizationsprawlsettings().getForm();

		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		if(!Ext.isEmpty(jsonData))
		{
			var resultPanel = Ext.getCmp('resultPanel');
			resultPanel.removeAll();
			resultPanel.show();
			
 			var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
			if(reportgen=='background' || reportgen=='background-csv')
			{
				Ext.getCmp('resultPanel').hide();
				Ext.getCmp("upbutton").setDisabled(false);

 				var bgGroundMsg = jsonData.pageParams['bggroundStr'];
				var status = jsonData.pageParams['status'];
				var langSupportString = jsonData.pageParams['bgLangSupportStr'];
				var bgReportUrl = jsonData.pageParams['bgLinkUrl'];
				var bgreportlinkMsg = jsonData.pageParams['bgLinkMsg'];
				var tableTitle='';
				//var htmlStr = "<div style='text-align:center;margin-top:50px'>";
				//var statusCssClass='iconSuccess';
				var htmlStr ='';
				var statusCssClass='iconSuccess';
				if((status != null && status == "duplicate") || (bgGroundMsg!=null && bgGroundMsg == "User background report generationlimit is finished"))
				{
					//statusCssClass = 'iconExists';
					statusCssClass='iconExclamation';
				}
					//htmlStr += "<center><div class='block1' style='font-size:13px;padding:8px;text-align:left;display:block;width:480px;height:90' class='panelwithoutheader'><div style='margin:20px;display:block;width:38px;height:34px;float:left;' class='"+statusCssClass+"'></div><div style='margin-top:20px'><b>'"+langSupportString+"</b>.<br/><a class='backgroundMsgLink' href=\""+bgReportUrl+"\"/>"+bgreportlinkMsg+"</a></div></div></center>";

						//+ "</div>";

					htmlStr += '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+bgreportlinkMsg+'</a></div></td></tr></table></td></tr></table>';
				this.getBackGroundPanel().update(htmlStr);
 				this.getBackGroundPanel().show();
			}
			else if(reportgen=='foreground')
			{
				var dataAvailable =  jsonData['dataAvailable'];
				if(dataAvailable!=null && dataAvailable=='true')
				{
					var showUtilitiesOptions = jsonData['pageParams']['showUtilitiesOptions'];
					var er_type = jsonData['pageParams']['er_type'];
					if(showUtilitiesOptions!=null && showUtilitiesOptions=='true')
					{
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);

						if(er_type!=null && er_type=='No')
						{
							Ext.getCmp("csvTool").setDisabled(false);
						}
					}
					if(er_type!=null && er_type=='Yes')
					{
 						var graphObj = jsonData['graphObj'];
						var graphHei = graphObj['height'];
						var graphPanel = Ext.widget('panel',
						{
							title : graphObj['graphTitle'],
							//cls:'datapanel',
							ui:'newGraphPanel',
							margin: '10 10 10 10',
							id : 'vmSprawlGraph',
							name : 'vmSprawlGraph',
							padding:'0 10 0 0',
							frame : false,
							border:false,
							height : graphHei,
							html : '<div id="vmSprawlGraphDiv" style:"width:800;height:'+graphHei+'"></div>'
						});
					resultPanel.add(graphPanel);
					var swfPath= graphObj['swfPath'];
					var xmlData= graphObj['xmlData'];
					if(appConstants.chartType=='fusionchart')
					{
						if (FusionCharts("vmSparwlG2323" ))
							FusionCharts("vmSparwlG2323").dispose();
						var chart2 = new FusionCharts(swfPath, "vmSparwlG2323", "98%", graphHei, "0", "1");
						chart2.setDataXML(xmlData);
						chart2.setTransparent(true);
						chart2.render("vmSprawlGraphDiv");
					}
 					else if(appConstants.chartType=='highchart')
					{

						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('vmSprawlGraphDiv',graphObj.chartHeight,graphObj.chartWidth+100), lineChart);
						lineChart.setData(graphObj,'<%=currentDateFormat%>','');
						lineChart.drawChart();
					}

						resultPanel.doLayout();
					}
					else if(er_type!=null && er_type=='No')
					{
						//resultPanel.removeCls('containerShadow');
						var gridDataObj = jsonData['gridDataObj'];
						if(!Ext.isEmpty(gridDataObj))
						{
							var title = gridDataObj['gridTitle'];
							var columns = gridDataObj['columns'];
							var genColumns = new Array();
							var gridIndexVals = gridDataObj['gridData'];
							var gridFields = new Array();
							for ( var colVal in columns )
							{
								var colName = columns[colVal];
								gridFields.push({ name : colVal  , type : 'string' });

								var minWidthVal = 125;
								if(colVal=='COLUMN_0')
								{
									minWidthVal = 220;
								}
								else if(colVal=='COLUMN_1')
								{
									minWidthVal = 75;
								}
									var al='center';
								if(colVal == 'COLUMN_0' || colVal == 'COLUMN_5' )
									al='left';
								genColumns.push(
								{
									header: colName,
									sortable: true,
									//flex: 1,
									minWidth : minWidthVal,
									align: al,
									dataIndex: colVal,
	//								menuDisabled : true,
								//	disabled :true,
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qclass="yellowTip" data-qtip="' + value + '"';
										value = Ext.getCmp('gridId').getDecimalAlignFormat(value);
										return value;
									}
								});

							}
							resultPanel.add(
							{
								xtype:'customgrid',
								title:title,
								store: Ext.data.Store(
									{
										fields: gridFields,
										data:gridIndexVals
									}),
								border:true,
  								scroll:true,
								frame: false,
								ui:'newGridPanel withShade withHeader',
								margin: '10 10 10 10',
								padding:'5 10 10 10',
								autoScroll:true,
								id:'gridId',
								stripeRows: false,
								//cls:'gridSkin',
								columns:genColumns,
								listeners:{
									render:function(obj){
  										Ext.defer(function() {
											obj.columns[0].setSortState("ASC",true,true);
											},100);
 										}
								}
							});
							resultPanel.doLayout();
						}
					}
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selDetailsJson);
				}
				else
				{
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
					resultPanel.hide();
 					this.getNomeasurepanel().show();
				}
			}
		}
	},
	validateSettings : function()
	{
		var isSettingsOk = true;
		var settingsForm = this.getVirtualizationsprawlsettings().getForm();
		var reportgen = settingsForm.findField('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv') )
		{
			var reportNameObj = settingsForm.findField('bgReportName');
			var reportName = reportNameObj.getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				return false;
			}
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if(btn=="yes")
		{
			this.submitReport();
		}
		else
		{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var settingsForm = this.getVirtualizationsprawlsettings().getForm();
			settingsForm.findField('reportGeneration').setValue('background');
			var reportNameObj = settingsForm.findField('bgReportName');
			reportNameObj.setValue("");
			reportNameObj.show();
			reportNameObj.focus();
			this.beforeReportSubmit();
		}
	},
	saveReportAsPDF:function(){
		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();
        	var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getVirtualizationsprawlsettings().getForm();

		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();
		var er_comptype = mainForm.findField('comp_type').getValue();
		var er_cluster = mainForm.findField('cluster').getValue();
		var er_server_type = mainForm.findField('serv_type').getValue();
		var er_component = mainForm.findField('component').getValue();

		var saveQString = '&er_type='+report_type+'&er_option='+analysisBy;

		var selectedGpName = mainForm.findField('infraType').getValue();
		if(analysisBy!=null && analysisBy=='Zone')
		{
			var incSubZone = mainForm.findField('subzone').getValue();

			saveQString = saveQString+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
		}
		else if(analysisBy!=null && analysisBy=='Segment')
		{
			saveQString = saveQString+'&er_site='+selectedGpName;
		}
		else if(analysisBy!=null && analysisBy=='Service')
		{
			saveQString = saveQString+'&er_site='+selectedGpName;
		}

		saveQString = saveQString+'&er_comptype='+er_comptype+'&er_component='+er_component+'&er_datafrom='+analysisBy;
		saveQString = saveQString+'&er_cluster='+encodeURIComponent(er_cluster)+'&er_server_type='+er_server_type;

		var er_server = "";
		var serverArr = new Array();
		serverArr = componentmainForm.findField('serverList').getValue();

		if(serverArr!=null && (serverArr!="" && serverArr!="null"))
		{
			for ( var i = 0; i < serverArr.length; i++ )
			{
				er_server += '&er_server='+serverArr[i];
			}
		}

		if(er_server!=null && er_server!='')
		{
			saveQString += er_server;
		}

		var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var startdate = Ext.Date.dateFormat(mainForm.findField('er_stdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(mainForm.findField('er_enddate').getValue(), mgrDateFormat);
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		saveQString = saveQString+'&startdate='+startdate+'&enddate='+enddate+'&starthr='+startHour+'&endhr='+endHour+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin
								+'&er_timeline='+er_timeline;

		if(report_type!=null && report_type=='Yes')
		{
			var metricVal = this.getSettingsFieldValue(settingsForm,'metricCombo',isSettingsEnabled,'er_display');
			var priority = this.getSettingsFieldValue(settingsForm,'priorityCombo',isSettingsEnabled,'selectedPriorityValue');
			saveQString = saveQString+'&er_display='+metricVal+'&er_priority='+priority+'&inidate='+mgrDateFormat;
		}

		var s_qryString = '../reporter/ErHtmlToSavePdf.jsp?'+saveQString+'&pageWidthProces=700';
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();
        	var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getVirtualizationsprawlsettings().getForm();
		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();
		var er_comptype = mainForm.findField('comp_type').getValue();
		var er_cluster = mainForm.findField('cluster').getValue();
		var er_server_type = mainForm.findField('serv_type').getValue();
		var er_component = mainForm.findField('component').getValue();
		var saveQString = '&er_type='+report_type+'&er_option='+analysisBy;
		var selectedGpName = mainForm.findField('infraType').getValue();
		if(analysisBy!=null && analysisBy=='Zone')
		{
			var incSubZone = mainForm.findField('subzone').getValue();
			saveQString = saveQString+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
		}
		else if(analysisBy!=null && analysisBy=='Segment')
		{
			saveQString = saveQString+'&er_site='+selectedGpName;
		}
		else if(analysisBy!=null && analysisBy=='Service')
		{
			saveQString = saveQString+'&er_site='+selectedGpName;
		}
		saveQString = saveQString+'&er_comptype='+er_comptype+'&er_component='+er_component+'&er_datafrom='+analysisBy;
		saveQString = saveQString+'&er_cluster='+encodeURIComponent(er_cluster)+'&er_server_type='+er_server_type;
		var er_server = "";
		var serverArr = new Array();
		serverArr = componentmainForm.findField('serverList').getValue();
		if(serverArr!=null && (serverArr!="" && serverArr!="null"))
		{
			for ( var i = 0; i < serverArr.length; i++ )
			{
				er_server += '&er_server='+serverArr[i];
			}
		}
		if(er_server!=null && er_server!='')
		{
			saveQString += er_server;
		}
		var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var startdate = Ext.Date.dateFormat(mainForm.findField('er_stdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(mainForm.findField('er_enddate').getValue(), mgrDateFormat);
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		saveQString = saveQString+'&startdate='+startdate+'&enddate='+enddate+'&starthr='+startHour+'&endhr='+endHour+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin
								+'&er_timeline='+er_timeline;
		if(report_type!=null && report_type=='Yes')
		{
			var metricVal = this.getSettingsFieldValue(settingsForm,'metricCombo',isSettingsEnabled,'er_display');
			var priority = this.getSettingsFieldValue(settingsForm,'priorityCombo',isSettingsEnabled,'selectedPriorityValue');
			saveQString = saveQString+'&er_display='+metricVal+'&er_priority='+priority+'&inidate='+mgrDateFormat;
		}
		var s_qryString = saveQString+'&pageWidthProces=700';
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var finalParams = appConstants.queryString;
		if(finalParams != null)
			bookletquery=encodeURI(finalParams);
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){


		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();
        	var settingsForm =null;
		if(isSettingsEnabled)
			settingsForm = this.getVirtualizationsprawlsettings().getForm();

		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();
		var er_comptype = mainForm.findField('comp_type').getValue();
		var er_cluster = mainForm.findField('cluster').getValue();
		var er_server_type = mainForm.findField('serv_type').getValue();
		var er_component = mainForm.findField('component').getValue();

		var saveQString = '&er_type='+report_type+'&er_option='+analysisBy;

		var selectedGpName = mainForm.findField('infraType').getValue();
		if(analysisBy!=null && analysisBy=='Zone')
		{
			var incSubZone = mainForm.findField('subzone').getValue();

			saveQString = saveQString+'&er_site='+selectedGpName+'&includeSubZone='+incSubZone;
		}
		else if(analysisBy!=null && analysisBy=='Segment')
		{
			saveQString = saveQString+'&er_site='+selectedGpName;
		}
		else if(analysisBy!=null && analysisBy=='Service')
		{
			saveQString = saveQString+'&er_site='+selectedGpName;
		}

		saveQString = saveQString+'&er_comptype='+er_comptype+'&er_component='+er_component+'&er_datafrom='+analysisBy;
		saveQString = saveQString+'&er_cluster='+encodeURIComponent(er_cluster)+'&er_server_type='+er_server_type;

		var er_server = "";
		var serverArr = new Array();
		serverArr = componentmainForm.findField('serverList').getValue();

		if(serverArr!=null && (serverArr!="" && serverArr!="null"))
		{
			for ( var i = 0; i < serverArr.length; i++ )
			{
				er_server += '&er_server='+serverArr[i];
			}
		}

		if(er_server!=null && er_server!='')
		{
			saveQString += er_server;
		}

		var reportgen = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var startdate = Ext.Date.dateFormat(mainForm.findField('er_stdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(mainForm.findField('er_enddate').getValue(), mgrDateFormat);
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		saveQString = saveQString+'&startdate='+startdate+'&enddate='+enddate+'&starthr='+startHour+'&endhr='+endHour+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin
								+'&er_timeline='+er_timeline;

		if(report_type!=null && report_type=='Yes')
		{
			var metricVal = this.getSettingsFieldValue(settingsForm,'metricCombo',isSettingsEnabled,'er_display');
			var priority = this.getSettingsFieldValue(settingsForm,'priorityCombo',isSettingsEnabled,'selectedPriorityValue');
			saveQString = saveQString+'&er_display='+metricVal+'&er_priority='+priority+'&inidate='+mgrDateFormat;
		}

		var s_qryString = '/final/reporter/ErVmSprawlReportPrint.jsp?'+saveQString+'&pageWidthProces=700&pdfPrint=yes&';

parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp



			/* printWindow.on('show',function(){
       // var s_qryString = "YOUR QUERY"  //query string to load the popup
        var printContentDiv = parent.Ext.select('#printContentDiv1');  // id of the popup window
                    printContentDiv.set({
                        src: s_qryString
                    });
           });
         printWindow.show();*/
	},
	showBackgroundReport: function(combo)
	{
		var settingsForm = this.getVirtualizationsprawlsettings().getForm();
		var val = combo.getValue();
		var reportNameObj = settingsForm.findField('bgReportName');
		if ( val == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else if ( val == 'background-csv' )
		{
			reportNameObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var isValid = this.validateForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Virtual Machine Activity Report - Cluster',
				msg: appConstants.invalidTimelineMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		var target='';
		if(isValid){
		this.updateQueryString(null);

		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();

		var	er_component_combination ="";
		var serverArr = new Array();
		serverArr = componentmainForm.findField('serverList').getValue();

		if(serverArr!=null && (serverArr!="" && serverArr!="null"))
		{
			for ( var i = 0; i < serverArr.length; i++ )
			{
				er_component_combination += serverArr[i]+"##";
			}
		}

		if(er_component_combination!=null && er_component_combination!='')
		{
			appConstants.queryString += '&er_combination='+encodeURIComponent(er_component_combination);
		}

		target="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryString+"&isSchedule=true&com.eg.CSRF_NONCE="+csrfToken;
 		parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
		{
			target+='&com.eg.CSRF_NONCE='+csrfToken+'&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
			return
		}
	},
	saveFavorite:function(){
		var isValid = this.validateForm(false);
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Virtual Machine Activity Report - Cluster',
				msg: appConstants.invalidTimelineMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		var target='';
		if(isValid){
		this.updateQueryString(null);
		var mainForm = this.getVirtualizationsprawlform().getForm();
		var componentmainForm = Ext.getCmp('mainform').getForm();

		var	er_component_combination ="";
		var serverArr = new Array();
		serverArr = componentmainForm.findField('serverList').getValue();

		if(serverArr!=null && (serverArr!="" && serverArr!="null"))
		{
			for ( var i = 0; i < serverArr.length; i++ )
			{
				er_component_combination += serverArr[i]+"##";
			}
		}

		if(er_component_combination!=null && er_component_combination!='')
		{
			appConstants.queryString += '&er_combination='+encodeURIComponent(er_component_combination);
		}
		var hiddenFields = appConstants.publicJsonData['hiddenParams'];
		var favorite_id = hiddenFields["favorite_id"];
		target="../servlet/com.eg.ErFavoriteC?"+appConstants.queryString+"&er_view=GRAPH&cmd=client&isFavorite=true"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+favorite_id;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 		parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

		}
		else
			return;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);

	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	afterMainRender:function(){
		var thisController = this;
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});

	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
//		console.log(formObj);
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else
			value = appConstants.publicJsonData.pageParams[jsonParam];

//				console.log(jsonParam+" < ---------   > "+value);
		return value;
	}
});

