// JavaScript Document
Ext.define('virtualizationsprawlreports.view.VirtualizationSprawlForm',{
	extend:'Ext.form.Panel',
	alias:'widget.virtualizationsprawlform',
	id:'virtualizationsprawlform',
 	layout: 'column',
	defaults:{
		labelAlign:'top',
		 margin:'0 20 10 0',
		labelSeparator:''
	},
	items:[
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 90,
			editable : false,
			fieldLabel:'Report type',
			name: 'report_type',
			id: 'report_type',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : [
				{
					'displayField':'zone1',
					'valueField':'zone1'
				}]
			}),
			displayField : 'displayField',
			valueField : 'valueField',
			queryMode : 'local'
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 100,
			editable : false,
			id: 'analysisBy',
			name: 'analysisBy',
			fieldLabel:'Analyze by',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : ['Activity','Activity']
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: false
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 150,
			editable : true,
			id: 'infraType',
			name: 'infraType',
			fieldLabel:'',
			listConfig:{
							emptyText:noMatch
						},
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: true
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 220,
			editable : true,
			id: 'comp_type',
			name: 'comp_type',
			fieldLabel:'Component Type',
			listConfig:{
							emptyText:noComponentTypeMatch
						},
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: false
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 110,
			editable : false,
			id: 'subzone',
			name: 'subzone',
			fieldLabel:'Include Subzone',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: true
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 200,
			editable : false,
			id: 'component',
			name: 'component',
			fieldLabel:'Component',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: false
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 200,
			editable : false,
			id: 'cluster',
			name: 'cluster',
			fieldLabel:'Cluster',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: false
		},
		{
			xtype:'scrollcombo',
			cls: 'dropdown',
			width: 180,
			editable : false,
			id: 'serv_type',
			name: 'serv_type',
			fieldLabel:'Server Type',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: false
		},		
		{xtype:'timeline', margin: 0}
	],
	loadData : function()
	{
		var mainForm = this.getForm();
		var from_schedule = appConstants.publicJsonData['hiddenParams']['fromScheduleModify'];
		var fromFavoriteModify = appConstants.publicJsonData['hiddenParams']["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}

		var report_type = mainForm.findField('report_type');
		report_type.getStore().loadRawData(appConstants.publicJsonData['repOptsJson']);
		report_type.setValue(appConstants.publicJsonData['pageParams']['er_type']);
		report_type.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Report Type']);

		var analysisBy = mainForm.findField('analysisBy');
		var selectedGroup = appConstants.publicJsonData['pageParams']['selectedAnalysisOption'];
		analysisBy.getStore().loadRawData(appConstants.publicJsonData['analyzeOptsJson']);
		analysisBy.setValue(selectedGroup);
		analysisBy.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.vsprawl.Analyze by']);
		if(selectedGroup!=null && (selectedGroup=='Zone' || selectedGroup=='Segment' || selectedGroup=='Service'))
		{
			var infraTypeCombo =mainForm.findField('infraType');
			infraTypeCombo.getStore().loadRawData(appConstants.publicJsonData['grpOptsJson']);
			infraTypeCombo.setValue(appConstants.publicJsonData['pageParams']['selectedGrpValue']);
			infraTypeCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['grpLbl']);
			infraTypeCombo.show();

			if(selectedGroup=='Zone')
			{
				var subzoneCombo =mainForm.findField('subzone');
				subzoneCombo.getStore().loadRawData(appConstants.publicJsonData['yesNoOpts']);
				subzoneCombo.setValue(appConstants.publicJsonData['pageParams']['includezone']);
				subzoneCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.comparison.Include Subzone']);
				subzoneCombo.show();
			}
		}

		var compTypeCombo = mainForm.findField('comp_type');
		compTypeCombo.getStore().loadRawData(appConstants.publicJsonData['compTypeOptsJson']);
		compTypeCombo.setValue(appConstants.publicJsonData['pageParams']['selectedCompTypeValue']);
		compTypeCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.consolidated.Component Type']);

		var componentCombo = mainForm.findField('component');
		componentCombo.getStore().loadRawData(appConstants.publicJsonData['componentOptsJson']);
		componentCombo.setValue(appConstants.publicJsonData['pageParams']['selectedCompOption']);
		componentCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Component']);

		var serverTypeCombo = mainForm.findField('serv_type');
		serverTypeCombo.getStore().loadRawData(appConstants.publicJsonData['serverTypeOptsJson']);
		serverTypeCombo.setValue(appConstants.publicJsonData['pageParams']['selectedServerTypeOption']);
		serverTypeCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Server Type']);

		var clusterCombo = mainForm.findField('cluster');
		clusterCombo.getStore().loadRawData(appConstants.publicJsonData['clusterOptsJson']);
		clusterCombo.setValue(appConstants.publicJsonData['pageParams']['selectedClusterOption']);
		clusterCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Cluster']);

		var componentForm = Ext.getCmp('mainform').getForm();
		var serverListCombo = componentForm.findField('serverList');
		serverListCombo.getStore().loadRawData(appConstants.publicJsonData['serverOptsJson']);
		rawDataForComponents = appConstants.publicJsonData['serverOptsJson'];
		serverListCombo.setValue(appConstants.publicJsonData['pageParams']['selectedServerOption']);
//		clusterCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Cluster']);

		var serverLbl = Ext.getCmp('serverLbl');
		serverLbl.setText(appConstants.publicJsonData['screenLabels']['reporter.common.Server']);

	
		var hrsLbl=appConstants.publicJsonData.screenLabels['reporter.common.Hrs'];
		var fromLbl=appConstants.publicJsonData.screenLabels['reporter.common.From'];
		var toLbl=appConstants.publicJsonData.screenLabels['reporter.common.To'];
		var timelineLbl=appConstants.publicJsonData.screenLabels['reporter.common.Timeline'];

		var timelineJSONArray = appConstants.publicJsonData['timelineComboArray'];
		var timeLineComboObj = componentForm.findField('er_timeline');
		timeLineComboObj.getStore().loadRawData(timelineJSONArray);
		timeLineComboObj.setValue(appConstants.publicJsonData.pageParams.selectedTimeline);
		timeLineComboObj.setFieldLabel(timelineLbl);

		var startdateObj = componentForm.findField('er_stdate');
		var enddateObj = componentForm.findField('er_enddate');
		var startHourObj = componentForm.findField('er_sthr');
		var endHourObj = componentForm.findField('er_endhr');

		var stDate = appConstants.publicJsonData.pageParams['startDateJSON'];
		var endDate = appConstants.publicJsonData.pageParams['endDateJSON'];
		var startHr = appConstants.publicJsonData.pageParams['startHourJSON'];
		var endHr = appConstants.publicJsonData.pageParams['endHourJSON'];	

		startdateObj.setValue(appConstants.publicJsonData.pageParams['startDateForDisplay']);
        startdateObj.dataArray =stDate;
        startHourObj.setValue(appConstants.publicJsonData.pageParams['startHourForDisplay']);
        startHourObj.dataArray = startHr;
        enddateObj.setValue(appConstants.publicJsonData.pageParams['endDateForDisplay']);
        enddateObj.dataArray = endDate;
        endHourObj.setValue(appConstants.publicJsonData.pageParams['endHourForDisplay']);
        endHourObj.dataArray = endHr;
        stmin =appConstants.publicJsonData.pageParams['startMinForDisplay'];
        enmin = appConstants.publicJsonData.pageParams['endMinForDisplay'];
        mgr_stmin =appConstants.publicJsonData.pageParams['startmin'];
        mgr_enmin = appConstants.publicJsonData.pageParams['endmin'];

		startdateObj.setFieldLabel(fromLbl);
		enddateObj.setFieldLabel(toLbl);
		startHourObj.setFieldLabel(hrsLbl);
		endHourObj.setFieldLabel(hrsLbl);

	}
	
	
	
	})



