Ext.define('VirtualizationUptime.controller.Main', {
        extend: 'Ext.app.Controller',
        requires: [
            'VirtualizationUptime.view.Main','Ext.ux.data.PagingMemoryProxy'
        ],
        refs: [{
                ref: 'main',
                selector: 'main'
            }, {
                selector: 'newUtilities',
                ref: 'newUtilities'
            },{
				selector: 'ReporterSettings',
				ref: 'ReporterSettings'
			},{
                selector: 'resultpanel',
                ref: 'resultpanel'
            },
			{selector:'nomeasurepanel', ref:'nomeasurepanel'},
			{selector: 'backGroundPanel',ref: 'backGroundPanel'}
        ],
        init: function () {
            this.control({
                    'main newUtilities': {
                        afterrender: this.hideTools
                    },
                    'main': {
                        afterrender: this.loadDefaults
                    },
                    'vuptimesettings': {
                        afterrender: this.afterSettingsrender
                    },
                    'vuptimemainform combo[name="er_uptimetest"]': {
                        'select': this.uptimeForChange
                    },
                    'vuptimemainform combo[name="er_option"]': {
                        'select': this.optionOnChange
                    },
                    'vuptimemainform combo[name="er_site"]': {
                        'select': this.groupOnChange
                    },
                    'vuptimemainform combo[name="er_site"]': {
                        'select': this.groupOnChange
                    },
                    'vuptimemainform combo[name="er_dataZone"]': {
                        'select': this.groupOnChange
                    },
                    'vuptimemainform combo[name="er_comptype"]': {
                        'select': this.compTypeOnChange
                    },
                    'vuptimesettings combo[name="er_type"]': {
                        'select': this.reportTypeOnChange
                    },
                    'vuptimesettings combo[name="er_timeline"]': {
                        //'select': this.timeLineOnChange
                    },
                    'vuptimesettings combo[name="reportGeneration"]': {
                        'select': this.reportGenChange
                    },
					'vuptimesettings button[id="moreOptionCloseId"]': {
						'click': this.validateAndCloseSettings
					},
					'vuptimesettings button[id="submitViaSetting"]': {
						'click': this.closeSettingAndSubmit
					},
                  /*  'vuptimesettings combo[name="er_excwe"]': {
                        'select': this.weekendOnChange
                    }, */
                    'mainform button[name="submit"]': {
                        'click': this.showResult
                    },
                    'mainform button[name="save"]': {
                        'click': this.goTo
                    },
                    'egcomponent button[id="expandSelector"]': {
                        'click': this.expandMe
                    },
                    'newUtilities > #printTool > button': {
                        'click': this.printReport
                    },
                    'newUtilities > #saveTool > button': {
                        'click': this.saveReportAsPDF
                    },
                    'newUtilities > #mailTool > button': {
                        'click': this.sendMail
                    },
                    'newUtilities > #csvTool > button': {
                        'click': this.saveCsv
                    },
                    'newUtilities > #favoriteTool > button': {
                        'click': this.saveFavorite
                    },
                    'newUtilities > #scheduleTool > button': {
                        'click': this.saveSchedule
                    },
					'timeline combo[name="er_mode"]':
					{
						 'change': this.changeEr_mode
					 },
					'egcomponent trigger[id="compSearch"]':
					{
						'change': this.filterMultiselect
					},
					'mainform button[id="panelinsidetoggle"]': {
						'click': this.toggleForm
					}
                });

        },
	showConfigDropdown: function () {
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate(
		'<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		var me=this;
		Ext.create('Ext.container.Container', {
 		id: 'configMod',
		//cls: 'configMode_popup',
		ui:'settingsWindowContainer',
		width:565,
		//padding:5,
 		items: [
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					cls:'containerHeader',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'vuptimesettings',
					parent:this
				}
		],
		renderTo: 'vuptime-body'
		});
		Ext.get('closeSettings').on('click', function () {
			me.validateAndCloseSettings();
		});

   },filterMultiselect: function (obj) {
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			obj.toggleTriggger();
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);

    },
	changeEr_mode: function (combo) {
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
              });
		}
		this.showResult();
    },
		goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
			var hiddenFields =  appConstants.publicjsonData['hiddenfields'];
			var from_favorite = hiddenFields["fromFavoriteModify"];
			if ((from_favorite != null && from_favorite == "Yes")) {
				this.saveFavorite();
			}else{
				//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
				this.saveSchedule();
			}
		},
        expandMe: function (btn) {
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),Ext.getCmp('systemLabel').text,btn);

	},
        hideTools: function () {
            this.getNewUtilities().loadIcon(true, // save
                true, // print
                true, // mail
                false, // data
                true, // cvs
                true, // fav
                true, // schedule
                false, // daignosis
                false, // togglebutton
                false, // close
                true // booklet
            );
			 //Ext.getCmp("upbutton").hide();
            Ext.getCmp("scheduleTool").setDisabled(false);
            Ext.getCmp("favoriteTool").setDisabled(false);
        },
        disableTools: function () {
            Ext.getCmp("bookletTool").setDisabled(true);
            Ext.getCmp("saveTool").setDisabled(true);
            Ext.getCmp("printTool").setDisabled(true);
            Ext.getCmp("mailTool").setDisabled(true);
            //Ext.getCmp("upbutton").setDisabled(true);
            Ext.getCmp("csvTool").setDisabled(true);
        },
        printReport: function () {

            var s_qryString = "/final/reporter/ErUptimePrintData.jsp?pdfPrint=yes&pgTittle=VIRTUALIZATION&" + appConstants.publicjsonData.saveQString;


				parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

        },
        saveReportAsPDF: function () {
            var saveQString = appConstants.publicjsonData.saveQString;
            var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?pgTittle=VIRTUALIZATION&" + saveQString;
            if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			appConstants.erUtils.savePDF(s_qryString);
        },
		bookletQuery: function(obj)
		{
			var saveQString = appConstants.publicjsonData.saveQString;
            var s_qryString = "pgTittle=VIRTUALIZATION&" + saveQString;
			return s_qryString;
		},
		bookletScheduleQuery: function(obj)
		{
			var bookletquery="";
            var  s_qryString =appConstants.queryString;
			if(s_qryString != null)
				bookletquery=encodeURI(s_qryString);
			return bookletquery;
		},
		bookletPreview:function()
		{
			this.printReport();
        },
        sendMail: function () {
            var windowMail = Ext.widget('sendmail');
            windowMail.show();
        },
        saveCsv: function () {
            window.location = "../servlet/egurkha.reporter.SaveInCSVFormat?"+"&reporttype=esx_uptime";
        },
        saveFavorite: function () {
            var isValid = this.validateMainForm();
            /* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
                Ext.MessageBox.show({
                        title: 'Virtualization',
                        msg: 'Chosen timeline not allowed',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                isValid = false;
            } */
            this.updateQueryString(true);
            if (isValid) {
				var hiddenFields = appConstants.publicjsonData['hiddenfields'];
				var favorite_id = hiddenFields["favorite_id"];
                var s_qryString;
                s_qryString = "../servlet/com.eg.ErFavoriteC?" + encodeURI(appConstants.queryString) + "&er_view=GRAPH&cmd=client";//&FavoriteId="+favorite_id;
                var target= s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
				if (appConstants.formButtonId=='save')
				{
					if(favorite_id=="undefined" || Ext.isEmpty(favorite_id) || favorite_id=="null" || favorite_id=="")
						favorite_id=appConstants.favId;
					//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
					target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
 						parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
            } else
                return;
        },
        saveSchedule: function () {
            var isValid = this.validateMainForm();
            if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
                Ext.MessageBox.show({
                        title: 'Virtualization',
                        msg: 'Chosen timeline not allowed',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                isValid = false;
            }
            this.updateQueryString(true);
            if (isValid) {
                var s_qryString;
                s_qryString = "/final/reporter/ErSaveSchedule.jsp?" + encodeURI(appConstants.queryString)+"&fromSchedule=true&throughSchedule=true";
				if(appConstants.queryString.indexOf("fromSchedule")<0)
					s_qryString+="&fromSchedule=true";
                var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
				if (appConstants.formButtonId=='save')
				{
					//document.location=target+'&showSchWindow=no';
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
 				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


            } else
                return;
        },
		validateAndCloseSettings:function()
		{
			var isSettingsOk = true;
			var reportgen = Ext.getCmp('reportGeneration').getValue();
			var timefrom = Ext.getCmp('timefrom').getValue();
			var minfrom = Ext.getCmp('minfrom').getValue();
			var timeto = Ext.getCmp('timeto').getValue();
			var minto = Ext.getCmp('minto').getValue();
			if (!checkTimePeriod(timefrom, minfrom, timeto, minto)) {
			isSettingsOk = false;
			}
			if (reportgen != null && reportgen == 'background') {

			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
			}
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(true);
			if (isSettingsOk) {
				getButtonObj.setDisabled(false);
				Ext.get('configMod').animate({
				duration: 500,
				to: {
					y: -500
				}
				});
			}
			return isSettingsOk;
		},
		closeSettingAndSubmit : function()
		{
			if(this.validateAndCloseSettings())
			{
				this.showResult();
			}
		},
        validateSettings: function () {
            var isSettingsOk = true;
			var reportgen = appConstants.publicjsonData.reportGeneration;
			if (isSettingsEnabled)
			{
				reportgen = Ext.getCmp("reportGeneration").getValue();
			}
            var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
            var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];


            var er_timeline = Ext.getCmp('er_timeline').getValue();
            var stDate = Ext.getCmp('er_stdate').getValue();
            var enDate = Ext.getCmp('er_enddate').getValue();
            var startHour = Ext.getCmp('er_sthr').getValue();
            var endHour = Ext.getCmp('er_endhr').getValue();
            stDate.setHours(startHour);
            enDate.setHours(endHour);

            if (!checkDateTime(stDate, enDate)) {
                isSettingsOk = false;
            }
            if (er_usertimeline != null && er_usertimeline != '-1') {
                var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
                if (!usertimelineValid) {
                    Ext.MessageBox.show({
                            title: 'Virtualization Uptime settings',
                            msg: userTimelineErrorMsg,
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    isSettingsOk = false;
                }
            }
            if (reportgen != null && reportgen == 'background') {

                var reportName = Ext.getCmp('bgReportName').getValue();
                if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{  
					isSettingsOk = false;
					return isSettingsOk;
				}	
				else
					isSettingsOk = true;
            }
            return isSettingsOk;
        },
        showConfirmResult: function (btn) {
            if (btn == "yes") {
                var getButtonObj = Ext.getCmp('submit');
                getButtonObj.setDisabled(false);
				var isValid = this.validateMainForm();
				if (isValid)
					this.submitReport();
				if (isSettingsEnabled)
				{
					Ext.get('configMod').animate({
                        duration: 500,
                        to: {
                            y: -500
                        }
                    });
				}
            } else {
				if (!isSettingsEnabled)
				{
					this.getReporterSettings().down('button').fireHandler();
				}
                var reportGenType = Ext.getCmp('reportGeneration');
                var bgreportNameObj = Ext.getCmp('bgReportName');
                reportGenType.setValue('background');
                bgreportNameObj.setValue("");
				validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
                bgreportNameObj.show();
                bgreportNameObj.focus(false, 1000);
                return false;
            }
        },
        validateMainForm: function () {
            var datafrom = Ext.getCmp('er_option');
            var compType = Ext.getCmp('er_comptype');
            var component = Ext.getCmp("er_component");
            //alert('component--->'+component.getValue());
            if (datafrom.getValue() != 'Component') {
                var s_group = Ext.getCmp("er_site");
                if (s_group.getValue() == '-1') {
                    Ext.MessageBox.show({
                            title: 'Virtualization',
                            msg: s_group.getStore().getAt(0).get('displayField'),
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    return false;
                }
            }
            /*if(compType.getValue() == 'NotApplicable')
		{
				Ext.MessageBox.show({
				title: 'Virtualization',
				msg: compType.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
		}*/
            if (Ext.isEmpty(component.getValue())) {
                Ext.MessageBox.show({
                        title: 'Virtualization',
                        msg: 'Please Choose Component',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                return;
            }
            if (component.getValue() == '-1') {
                Ext.MessageBox.show({
                        title: 'Virtualization',
                        msg: component.getStore().getAt(0).get('displayField'),
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                return;
            }
            return true;
        },
        showResult: function () {

			Ext.getCmp('panelinsidetoggle').setDisabled(false);

			var isValid = true;
			var stDate = Ext.getCmp('er_stdate').getValue();
			var enDate = Ext.getCmp('er_enddate').getValue();
			var startHour = Ext.getCmp('er_sthr').getValue();
			var endHour = Ext.getCmp('er_endhr').getValue();
			stDate.setHours(startHour);
			enDate.setHours(endHour);
			if (!checkDateTime(stDate, enDate)) {
				return false;
			}
			var reportgen = appConstants.publicjsonData.reportGeneration;
			if (isSettingsEnabled)
			{
				reportgen = Ext.getCmp("reportGeneration").getValue();
			}
            var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
            var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
            if (er_usertimeline != null && er_usertimeline != '-1') {
                var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
                if (!usertimelineValid) {
                    Ext.MessageBox.show({
                            title: 'Virtualization Uptime settings',
                            msg: userTimelineErrorMsg,
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    isSettingsOk = false;
                }
            }
			isValid = this.validateMainForm();
            if (reportgen != null && reportgen == 'foreground') {
                var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg'];

                if (!Ext.isEmpty(limitforbg)) {
                    if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                        Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
                    }
					else if (isValid)
							this.submitReport();
                }
				else if (isValid)
					this.submitReport();
            } else {
                var reportName = Ext.getCmp('bgReportName').getValue();
                if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
                    return;
				else if (isValid)
					this.submitReport();
            }
        },
		toggleForm:function(obj)
		{
			Ext.getCmp('panelinsidetoggle').show();
			var ornt = Ext.getCmp('mainform');
			if (ornt.isHidden())
			{
				ornt.show();
				Ext.getCmp('selectionDetails').hide();
			}
			else
			{
				ornt.hide();
				Ext.getCmp('selectionDetails').show();
			}
		},
        uptimeForChange: function () {
            Ext.getCmp('resultPanel').hide();
            this.disableTools();
            this.updateQueryString(false);
            Ext.Ajax.request({
                    url: '/final/reporter/ErEsxUptimeReportDataJson.jsp',
                    params: encodeURI(appConstants.queryString),
                    scope: this,
                    async: false,
                    method: 'POST',
                    success: function (response) {
                        var jsonText = response.responseText;
                        var jsonData = Ext.decode(jsonText);
                        appConstants.publicjsonData = jsonData;
                        comboRawData = jsonData.componentCombo;
                        selectedComboOption = jsonData.selectedComp;
                        comboObject = Ext.getCmp('er_component');
                        Ext.getCmp('systemLabel').setText(jsonData.screenLabels['reporter.uptime.Physical Server']);
                        comboObject.getStore().loadRawData(comboRawData);
						appConstants.rawDataForComponents = comboRawData;
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                    }
                });
        },
        optionOnChange: function () {
            Ext.getCmp('resultPanel').hide();
            this.disableTools();
            this.updateQueryString(false);
            Ext.Ajax.request({
                    url: '/final/reporter/ErEsxUptimeReportDataJson.jsp',
                    params: encodeURI(appConstants.queryString),
                    scope: this,
                    async: false,
                    method: 'POST',
                    success: function (response) {
                        var jsonText = response.responseText;
                        var jsonData = Ext.decode(jsonText);
                        appConstants.publicjsonData = jsonData;
                        var datafrom = jsonData.selectedOption;
                        if (datafrom != 'Component') {
                            comboRawData = jsonData.groupCombo;
                            selectedComboOption = jsonData.selectedGroup;
                            comboObject = Ext.getCmp('er_site');
                            //Ext.getCmp('systemLabel').setText(jsonData.screenLabels['reporter.common.group']);
                            comboObject.setFieldLabel(jsonData.screenLabels['reporter.common.group']);
                            comboObject.getStore().loadRawData(comboRawData);
                            //if ( !Ext.isEmpty(selectedComboOption) ){
                            //comboObject.setValue(selectedComboOption);
                            //}
                            //else{
                            comboObject.setValue(comboRawData[0].valueField);
                            //}
                            comboObject.show();

                            if (datafrom == 'Zone') {
                                Ext.getCmp("er_dataZone").show();
                            } else {
                                Ext.getCmp("er_dataZone").hide();
                            }
                        } else {
                            Ext.getCmp("er_site").hide();
                            Ext.getCmp("er_dataZone").hide();
                        }
                        comboRawData = jsonData.compTypeCombo;
                        selectedComboOption = jsonData.selectedCompType;
                        comboObject = Ext.getCmp('er_comptype');
						comboObject.getStore().clearFilter(true); 
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboRawData = jsonData.componentCombo;
                        selectedComboOption = jsonData.selectedComp;
                        comboObject = Ext.getCmp('er_component');
                        Ext.getCmp('systemLabel').setText(jsonData.screenLabels['reporter.uptime.Physical Server']);
                        comboObject.getStore().loadRawData(comboRawData);
						appConstants.rawDataForComponents = comboRawData;
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                    }
                });
        },
        groupOnChange: function () {
            Ext.getCmp('resultPanel').hide();
            this.disableTools();
            this.updateQueryString(false);
            Ext.Ajax.request({
                    url: '/final/reporter/ErEsxUptimeReportDataJson.jsp',
                    params: encodeURI(appConstants.queryString),
                    scope: this,
                    async: false,
                    method: 'POST',
                    success: function (response) {
                        var jsonText = response.responseText;
                        var jsonData = Ext.decode(jsonText);
                        appConstants.publicjsonData = jsonData;
                        comboRawData = jsonData.compTypeCombo;

                        selectedComboOption = jsonData.selectedCompType;
                        comboObject = Ext.getCmp('er_comptype');
						comboObject.getStore().clearFilter(true); 
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboRawData = jsonData.componentCombo;
                        selectedComboOption = jsonData.selectedComp;
                        comboObject = Ext.getCmp('er_component');
                        comboObject.getStore().loadRawData(comboRawData);
						appConstants.rawDataForComponents = comboRawData;
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                    }
                });
        },
        compTypeOnChange: function () {
            Ext.getCmp('resultPanel').hide();
            this.disableTools();
            this.updateQueryString(false);
            Ext.Ajax.request({
                    url: '/final/reporter/ErEsxUptimeReportDataJson.jsp',
                    params: encodeURI(appConstants.queryString),
                    scope: this,
                    async: false,
                    method: 'POST',
                    success: function (response) {
                        var jsonText = response.responseText;
                        var jsonData = Ext.decode(jsonText);
                        appConstants.publicjsonData = jsonData;

                        comboRawData = jsonData.componentCombo;
                        selectedComboOption = jsonData.selectedComp;
                        comboObject = Ext.getCmp('er_component');
                        comboObject.getStore().loadRawData(comboRawData);
						appConstants.rawDataForComponents = comboRawData;
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                    }
                });
        },
        reportTypeOnChange: function (obj) {
            Ext.getCmp('resultPanel').hide();
            this.disableTools();
            var val = obj.value;
            if (val == 'Yes') {
                Ext.getCmp("er_show").show();
                Ext.getCmp("er_mode").show();
                Ext.getCmp("er_sortby").show();
                Ext.getCmp("er_show_details").hide();
            } else {
                Ext.getCmp("er_show").hide();
                Ext.getCmp("er_mode").hide();
                Ext.getCmp("er_sortby").hide();
                Ext.getCmp("er_show_details").show();
            }
        },
        reportGenChange: function () {
            Ext.getCmp('resultPanel').hide();
            this.disableTools();
            var reportGenType = Ext.getCmp('reportGeneration').getValue();
            if (reportGenType == 'background') {
                Ext.getCmp('bgReportName').setValue("");
                Ext.getCmp('bgReportName').show();
				Ext.getCmp('submitViaSetting').show();
				Ext.getCmp('moreOptionCloseId').hide();
            } else {
                Ext.getCmp('bgReportName').hide();
				Ext.getCmp('submitViaSetting').hide();
				Ext.getCmp('moreOptionCloseId').show();
            }
        },
        timeLineOnChange: function () {
            Ext.getCmp('resultPanel').hide();
            this.disableTools();
            var startDateObj = Ext.getCmp('er_stdate');
            var startHrObj = Ext.getCmp('er_sthr');
            var endDateObj = Ext.getCmp('er_enddate');
            var endHrObj = Ext.getCmp('er_endhr');
            var timelineObj = Ext.getCmp('er_timeline');
            if (timelineObj.getValue() == 'Any') {
                startDateObj.setDisabled(false);
                startHrObj.setDisabled(false);
                endDateObj.setDisabled(false);
                endHrObj.setDisabled(false);
            } else {
                timelineObj.suspendEvents(true);
                this.updateQueryString(false);
                Ext.Ajax.request({
                        url: '/final/reporter/ErEsxUptimeReportDataJson.jsp',
                        params: encodeURI(appConstants.queryString),
                        scope: this,
                        success: function (response) {
                            var jsonText = response.responseText;
                            var jsonData = Ext.decode(jsonText);
                            appConstants.publicjsonData = jsonData;
                            var start_hour = jsonData.startHour;
                            var end_hour = jsonData.endHour;
                            var start_date = jsonData.startDate;
                            var end_date = jsonData.endDate;
                            startDateObj.setDisabled(true);
                            startHrObj.setDisabled(true);
                            endDateObj.setDisabled(true);
                            endHrObj.setDisabled(true);
                            startDateObj.setValue(start_date);
                            startHrObj.setValue(start_hour);
                            endDateObj.setValue(end_date);
                            endHrObj.setValue(end_hour);
                        }
                    });
                timelineObj.resumeEvents();
            }
        },
      /*  weekendOnChange: function () {
            var weekendvalue = Ext.getCmp('er_excwe').getValue();;
            var excludeDaysObj = Ext.getCmp('excludeDays');
            if (weekendvalue == 'Yes') {
                excludeDaysObj.show();
                excludeDaysObj.update(appConstants.publicjsonData.screenLabels['MappedExcludeDays']);
            } else {
                excludeDaysObj.hide();
            }
        },*/
        submitReport: function () {
            appConstants.initLdgMask.show();
			var reportGeneration = appConstants.publicjsonData.reportGeneration;
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				reportGeneration = Ext.getCmp("reportGeneration").getValue();
			}
             this.updateQueryString(true);
            if (reportGeneration == 'foreground') {
                urlforAjax = '../servlet/com.eg.ErUptimeServletC';
                finalParams = appConstants.queryString + "&isSubmit=true&responseType=json";
            } else if (reportGeneration == 'background') {
                urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
                var bg_reportname = Ext.getCmp('bgReportName').getValue();
					bg_reportname=checkFileName(bg_reportname);
                finalParams = appConstants.queryString + "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
            }
			finalParams+="&er_RmDispName="+appConstants.er_RmDispName;

            appConstants.initLdgMask.show();
			//Ext.getCmp("upbutton").pressed=true;
			//Ext.getCmp("upbutton").fireHandler();
            Ext.Ajax.request({
                    url: urlforAjax,
                    params: finalParams,
                    method: 'POST',
                    scope: this,
                    async: true,
                    success: function (response) {
                        var jsonText = response.responseText;
                        var jsonData = Ext.decode(jsonText);
                        appConstants.publicjsonData = jsonData;
                        this.loadReportData(appConstants.publicjsonData);
                    }
                });
        },
        loadReportData: function (jsonData) {
			this.getNomeasurepanel().hide();
			this.getBackGroundPanel().hide();
            var resultPanelObj = Ext.getCmp('resultPanel');
			//Ext.select('.datapanel').setStyle('border-width','1px');
            var reportGeneration = appConstants.publicjsonData.reportGeneration;
            var reportType = '';
            if (reportGeneration == 'foreground') {
                resultPanelObj.removeAll();
                itemsArray = new Array();
                var reportData = jsonData.reportData;
                if (jsonData.hasOwnProperty('reportData')) {

                    reportType = jsonData.selectedreportType;
                    if (reportType == 'Yes') {
                        Ext.getCmp("saveTool").setDisabled(false);
                        Ext.getCmp("bookletTool").setDisabled(false);
                        Ext.getCmp("printTool").setDisabled(false);
                        Ext.getCmp("mailTool").setDisabled(false);
						resultPanelObj.setTitle(reportData.chartTitle);
                        resultPanelObj.add({
                                xtype: 'panel',
							    margin: 0,
								ui:'newGraphPanel',
								//title:"<span class='font_bold'>"+reportData.chartTitle+"</span>",
                                border: true,
                                frame: false,
                                style: {
                                    'text-align': 'center'
                                },
								html: '<table style="width:100%;height:100%;"><tr><td align="center" valign="middle"><div style="text-align:center;" id="fusionChart"></div></td</tr></table>'
                            });

                        resultPanelObj.show();
						if(appConstants.chartType=='fusionchart')
						{
							if (FusionCharts("chartobject2" ))
								FusionCharts("chartobject2").dispose();
							var myChart = new FusionCharts(reportData['swfpath'], 'chartobject2', "80%", reportData.chartHeight, "0", "1");
							myChart.setXMLData(reportData['XML']);
							myChart.setTransparent(true);
							myChart.render('fusionChart');
						}
 						else if(appConstants.chartType=='highchart')
						{
								var lineChart = {};
								lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('fusionChart',reportData.chartHeight-20,reportData.chartWidth+100), lineChart);
								lineChart.setData(reportData,'<%=currentDateFormat%>','');
								lineChart.drawChart();
						}
							appConstants.BarDrillDownURLs = jsonData.charUrlMap;                       
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
							appConstants.initLdgMask.hide();
						}
					else if (reportType == 'No')
						{
                        Ext.getCmp("saveTool").setDisabled(false);
                        Ext.getCmp("bookletTool").setDisabled(false);
                        Ext.getCmp("printTool").setDisabled(false);
                        Ext.getCmp("mailTool").setDisabled(false);
                        Ext.getCmp("csvTool").setDisabled(false);
                        this.loadGrid(jsonData);
						}
                    } 
					else
						{
						this.disableTools();
 						resultPanelObj.removeAll();
						resultPanelObj.hide();
						this.getNomeasurepanel().doLayout();
						this.getNomeasurepanel().show();
						appConstants.initLdgMask.hide();
						}
            } else if (reportGeneration == 'background') {
                resultPanelObj.hide();
 				var htmlStr = '';
                var backgroundReportStatus = jsonData.backgroundReportStatus;
                if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
                    var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                    var bgroundReportsURL = jsonData.bgroundReportsURL;
                    var backgroundAnchor = jsonData.backgroundAnchor;
                   //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href=' + bgroundReportsURL + '>' + backgroundAnchor + '</a></div></div></center>';
				   htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
                 } else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
                    var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                    var bgroundReportsURL = jsonData.bgroundReportsURL;
                    var backgroundAnchor = jsonData.backgroundAnchor;
                    //htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href=' + bgroundReportsURL + '>' + backgroundAnchor + '</a></div></div></center>';
					htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';

                } else {
                    htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>';
				}
				this.getBackGroundPanel().update(htmlStr);
 				this.getBackGroundPanel().show();
                appConstants.initLdgMask.hide();
            }
        },
        loadGrid: function (jsonData) {

            var resultPanelObj = Ext.getCmp('resultPanel');
            var itemsArray = new Array();
            if (!Ext.isEmpty(jsonData)) {
                var gridDataObj = jsonData.reportData;
                var columnDetails = gridDataObj.columns;
                var columnsToDisp = gridDataObj.mappedColumns;
                var dataArraytoStore = gridDataObj.dataArray;

                var fieldstoStore = new Array();
                var mainColumnsObjArray = new Array();

                for (var key in columnDetails) {
					//prakash
					var align = 'center';
					if(key == 0)
						align='left';
					//
                    var mainColumn = columnDetails[key];
                    fieldstoStore.push(mainColumn);
                    mainColumnsObjArray.push({
                            header: columnsToDisp[mainColumn],
                            sortable: true,
                            dataIndex: mainColumn,
                            align: align,
						    flex: .9,
                            renderer: function (value, metaData, record, row, col, store, gridView) {
                                if (value.indexOf('~') > -1) {
                                    var text = value.substring(0, value.indexOf('~'));
                                    var url = value.substring(value.indexOf('~') + 1);
                                    if (text != null && text == "details.gif") {
                                        text = '<img src="/final/reporter/images/details.gif">';
                                        url = "/final/reporter/ErRebootDetails.jsp?"+appConstants.rebootQString + "&component=" + url;
                                    }
                                    value = '<a href="javascript:void(0);" onClick="javascript:openInNewWin(\'' + url + '\');" >' + text + '</a>';
                                }
                                return value;
                            },
							doSort: function(state)
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
                            }
								});
							}
                        });
                }

				var isPagingHidden;
				 if (dataArraytoStore!=undefined && dataArraytoStore.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
                var storeObj = Ext.create('Ext.data.ArrayStore', {
                        fields: fieldstoStore,
                        data: dataArraytoStore,
						remoteSort : true,
						proxy : {
							type : 'pagingmemory',
							reader : {
								type : 'array'
							}
						},
						pageSize:gridPageSize						
                    });
				resultPanelObj.setTitle(gridDataObj.title);
                var gridpanel = Ext.widget('customgrid', {
                        store: storeObj,
                        sortableColumns: true,
                        columns: mainColumnsObjArray,
						autoScroll:false,
						scroll:false,
						frame:false,
						bodyPadding:0,
						padding:0,
						//cls:'gridSkin',
						ui:'newGridPanel',
						margin:'0 10 10 10',
                        //title: gridDataObj.title,
						border:true,
                        bbar: [{
                                xtype: 'label',
								margin:4,
                                html: '<span class="font_normal10">* y - year, M - month, D - day, h - hour, m - min</span>'
                            }
                        ],
                        viewConfig: {
                            forceFit: true,
                        },
						listeners:{
							render:function(obj){
								Ext.defer(function() {
									obj.columns[2].setSortState("ASC",true,true);
								},100);
							}
						},
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'pagingtoolbar',
							store:storeObj,
							dock: 'bottom',
							hidden:isPagingHidden,
							displayInfo: true
						}]
                    });
                itemsArray.push(gridpanel);

                var rebootTableData = jsonData['rebootTable'];
                if (!Ext.isEmpty(rebootTableData)) {
                    var columnDetails = rebootTableData['columnDetails'];
                    var dataArray = rebootTableData['dataArray'];
                    var tabledata = '<div class="x-table" >' + '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">' + '<thead>' + '<tr class="x-grid-row">';
                    for (var k in columnDetails) {
                        tabledata += '<th class=" x-grid-cell">' + '<div class="x-grid-cell-inner">' + columnDetails[k] + '</div>' + '</th>';
                    }
                    tabledata += '</tr>' + '</thead>' + '<tbody>' + '<tpl for=".">';
                    for (var j in dataArray) {
                        var realdata = dataArray[j];
                        tabledata += '<tr class="x-grid-row">';
                        for (var l in realdata) {
                            tabledata += '<td class=" x-grid-cell x-grid-cell-first">' + '<div class="x-grid-cell-inner" >' + realdata[l] + '</div>' + '</td>'
                        }
                        tabledata += '</tr>';
                    }
                    tabledata += '</tpl>' + '</tbody>' + '</table>' + '</div>';
                    //itemsArray.push({xtype:'panel',cls:'dataPanel',margin:'0 0 10 0',layout:{type:'vbox',columns:2,align:'center'},items:[{xtype:'panel',cls:'block1',bodyPadding:'10 0 0 0',title:rebootTableData.title,width:'80%',html:tabledata}]});
                    itemsArray.push({
                            xtype: 'panel',
                            cls: 'block1',
                            margin: '15 70 0 70',
                            title: rebootTableData.title,
                            html: tabledata
                        });
                }

                Ext.getCmp("csvTool").setDisabled(false);
                resultPanelObj.removeAll();
                resultPanelObj.add(itemsArray);
                resultPanelObj.show();
                /*this.getResultpanel().doLayout();
                getHeightPanel = resultPanelObj.getHeight();
                conditionalHeight = Ext.getBody().getViewSize().height / 2;
                if (getHeightPanel > conditionalHeight) {

                    Ext.select('.gridSkin').setStyle('margin', '0px 10px 0px 0px');
                } else {
                    Ext.select('.gridSkin').setStyle('margin', '0px');
                }*/
            }
            appConstants.initLdgMask.hide();
        },
        updateQueryString: function (needCompnent) {
			var jsonData = appConstants.publicjsonData;
            var FormParams;
            var hiddenfieldQString = '';
            var timelineParams;
            var timePeriodParams;
            var reportType = jsonData.selectedreportType;
			var er_show_details = jsonData.showDetails;
			var er_maintenance = jsonData.maintanance;
			var er_excwe = jsonData.excludeWeek;
			var er_priority = jsonData.priority;
			var er_show = jsonData.selectedChart;
			var er_sortby = jsonData.sortby;
			var reportGeneration = jsonData.reportGeneration;
			var timefrom = jsonData.selectedTimeFrom;
			var minfrom = jsonData.selectedMinsFrom;
			var timeto = jsonData.selectedTimeTo;
			var minto = jsonData.selectedMinsTo;
			if (isSettingsEnabled)
			{
				reportType = Ext.getCmp('er_type').getValue();
				er_show_details = Ext.getCmp("er_show_details").getValue();
				er_maintenance = Ext.getCmp("er_maintenance").getValue();
				er_priority = Ext.getCmp("er_priority").getValue();
				er_show = Ext.getCmp("er_show").getValue();
				er_sortby = Ext.getCmp("er_sortby").getValue();
				reportGeneration = Ext.getCmp("reportGeneration").getValue();
				timefrom = Ext.getCmp("timefrom").getValue();
				minfrom = Ext.getCmp("minfrom").getValue();
				timeto = Ext.getCmp("timeto").getValue();
				minto = Ext.getCmp("minto").getValue();
			}
			if(reportType == 'Yes')
			{
				er_show = er_show.replace(new RegExp("%", 'g'), "|pct|");
			}
            var datafrom = Ext.getCmp('er_option').getValue();
            var compArray = Ext.getCmp('er_component').getValue();
            var er_combination = '';
            var comp_combination = '';
            if (appConstants.publicjsonData.hasOwnProperty('combination')) {
                comp_combination = appConstants.publicjsonData.combination;
            }
            FormParams = "er_datafrom=" + datafrom + "&er_option=" + Ext.getCmp("er_option").getValue() + "&er_uptimetest=" + Ext.getCmp("er_uptimetest").getValue();


            if (datafrom != 'Component') {
                FormParams += "&er_site=" + Ext.getCmp("er_site").getValue();
                if (datafrom == 'Zone') {
                    FormParams += "&er_dataZone=" + Ext.getCmp("er_dataZone").getValue();
                }
            }
            FormParams += "&er_comptype=" + Ext.getCmp("er_comptype").getValue() + "&er_type=" + reportType + "&er_excwe=" + er_excwe + "&er_maintenance=" + er_maintenance + "&er_priority=" + er_priority + "&er_reportgenration=" + reportGeneration;

            if (reportType == 'Yes') {
                FormParams += "&er_show=" + er_show;
                FormParams += "&er_mode=" + Ext.getCmp("er_mode").getValue();
                FormParams += "&er_sortby=" + er_sortby;

            } else {
                FormParams += "&er_show_details=" + er_show_details;
            }

			var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
			var timperiodParams = "&timefrom=" + timefrom + "&minfrom=" + minfrom + "&timeto=" + timeto + "&minto=" + minto;

            if (needCompnent) {
                for (var k = 0; compArray.length > k; k++) {
                    FormParams += "&er_component=" + compArray[k];
                    er_combination += comp_combination[compArray[k]] + "##";
                }
                er_combination = encodeURIComponent(er_combination);
                FormParams += "&er_combination=" + er_combination;
                appConstants.rebootQString = timperiodParams + timelineParams + "&stmin=" + mgr_stmin+ "&enmin=" + mgr_enmin + "&option=data&er_rtype=Uptime";
                if (Ext.getCmp("er_uptimetest").getValue() == 'Virtual Machines')
                    appConstants.rebootQString += "&uptimeType=EsxGuest";
                else
                    appConstants.rebootQString += "&uptimeType=Esx";

            }

            if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
                var hiddenFields = appConstants.publicjsonData.hiddenfields;
                for (var hiddenField in hiddenFields) {

                    hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
                }
            }
            appConstants.queryString = FormParams + timelineParams + hiddenfieldQString + timperiodParams;
        },
        loadDefaults: function () {
            var thisController = this;
			if (isSettingsEnabled)
			{
				Ext.EventManager.onWindowResize(function () {
                    Ext.get('configMod').setStyle('left', '');
                });
			}
			var hiddenFields = appConstants.publicjsonData['hiddenfields'];
	        var from_schedule = hiddenFields["fromScheduleModify"];
			var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
			if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
				Ext.getCmp("submit").hide();
				Ext.getCmp("save").show();
				Ext.getCmp("favoriteTool").setDisabled(true);
		      		Ext.getCmp("scheduleTool").setDisabled(true);
			}else{
				Ext.getCmp("submit").show();
				Ext.getCmp("save").hide();
			}


			if(!hideBackButton){
				Ext.getCmp('vuptimemainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonData['ID']
				});
			}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
            this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
            this.fillFormFields(appConstants.publicjsonData);
            this.refreshReportData();
        },
        refreshReportData: function () {
            if (isSubmit != null && isSubmit == "true") {
                appConstants.initLdgMask.show();
                this.loadReportData(appConstants.publicjsonData);
            }
			else
			{
				if(appConstants.isForceSubmit=='true')
				{
					appConstants.isForceSubmit='false';
					this.showResult();
				}
			}
        },
		afterSettingsrender:function() {
				Ext.getCmp('moreOptionCloseId').show();
				var hiddenFields = appConstants.publicjsonData['hiddenfields'];
				var favorite_id = hiddenFields["favorite_id"];
				if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

			var jsonData = appConstants.publicjsonData;
			var comboRawData = jsonData.reportTypeCombo;
			var selectedComboOption = jsonData.selectedreportType;
            var screenLabels = jsonData.screenLabels;
			comboObject = Ext.getCmp('er_type');
			comboObject.setFieldLabel(screenLabels['reporter.common.Report Type']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}

			if(selectedComboOption == 'No'){
				Ext.getCmp('er_show_details').show();
				Ext.getCmp('er_show').hide();
				Ext.getCmp('er_sortby').hide();

			}
			comboRawData = jsonData.showDetailsCombo;
			selectedComboOption = jsonData.showDetails;
			comboObject = Ext.getCmp('er_show_details');
			comboObject.setFieldLabel(screenLabels['reporter.common.Show Details']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.maintananceCombo;
			selectedComboOption = jsonData.maintanance;
			comboObject = Ext.getCmp('er_maintenance');
			comboObject.setFieldLabel(screenLabels['reporter.common.Include Maintenance']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.excludeWeekCombo;
			selectedComboOption = jsonData.excludeWeek;
			comboObject = Ext.getCmp('er_excwe');
			comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.chartCombo;
			selectedComboOption = jsonData.selectedChart;
			comboObject = Ext.getCmp('er_show');
			comboObject.setFieldLabel(screenLabels['reporter.uptime.Chart']);
			comboObject.suspendEvents(true);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.sortCombo;
			selectedComboOption = jsonData.sortby;
			comboObject = Ext.getCmp('er_sortby');
			comboObject.setFieldLabel(screenLabels['reporter.comparison.Sort by']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.priorityCombo;
			selectedComboOption = jsonData.priority;
			comboObject = Ext.getCmp('er_priority');
			comboObject.setFieldLabel(screenLabels['reporter.comparison.Show']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
			Ext.getCmp('timefrom').setValue(jsonData.selectedTimeFrom);
			Ext.getCmp('minfrom').setValue(jsonData.selectedMinsFrom);
			Ext.getCmp('timeto').setValue(jsonData.selectedTimeTo);
			Ext.getCmp('minto').setValue(jsonData.selectedMinsTo);
			var reportGenCombo = jsonData.reportGenerationCombo;
			var selreportGeneration = jsonData.reportGeneration;
			var reportGen = Ext.getCmp('reportGeneration');
			reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
			reportGen.getStore().loadRawData(reportGenCombo);
			reportGen.setValue(selreportGeneration);
		},
        fillFormFields: function (jsonData) {
            var comboRawData;
            var selectedComboOption;
            var comboObject;
            //select_farm,
            var screenLabels = jsonData.screenLabels;
		var optionSelected;
            comboRawData = jsonData.uptimeForCombo;
            selectedComboOption = jsonData.selectedUptimeFor;
            comboObject = Ext.getCmp('er_uptimetest');
            comboObject.setFieldLabel(screenLabels['reporter.uptime.Uptime for']);
            comboObject.getStore().loadRawData(comboRawData);

            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }

            comboRawData = jsonData.optionCombo;
            selectedComboOption = jsonData.selectedOption;
        optionSelected = jsonData.selectedOption;
            comboObject = Ext.getCmp('er_option');
            comboObject.setFieldLabel(screenLabels['reporter.uptime.Analyze by']);
            comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.subzoneCombo;
        selectedComboOption = jsonData.subzone;
        comboObject = Ext.getCmp('er_dataZone');
        comboObject.setFieldLabel(screenLabels['reporter.comparison.Include Subzone']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        if (optionSelected != 'Component') {

            comboRawData = jsonData.groupCombo;
            selectedComboOption = jsonData.selectedGroup;
            comboObject = Ext.getCmp('er_site');
            comboObject.setFieldLabel(screenLabels['reporter.common.group']);
            comboObject.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }
            comboObject.show();
            if (optionSelected == 'Zone') {
                Ext.getCmp("er_dataZone").show();
            }
        }
        comboRawData = jsonData.compTypeCombo;
        selectedComboOption = jsonData.selectedCompType;
        comboObject = Ext.getCmp('er_comptype');
        comboObject.setFieldLabel(screenLabels['reporter.consolidated.Component Type']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.componentCombo;
        selectedComboOption = jsonData.selectedComp;
        comboObject = Ext.getCmp('er_component');
        Ext.getCmp('systemLabel').setText(screenLabels['reporter.uptime.Physical Server']);
        comboObject.getStore().loadRawData(comboRawData);
		appConstants.rawDataForComponents = comboRawData;
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }

        var timelineRawData = jsonData.timelineCombo;
        var selectedTimeline = jsonData.selectedTimeline;
        var timelineObj = Ext.getCmp('er_timeline');
        timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
        timelineObj.getStore().loadRawData(timelineRawData);
        if (!Ext.isEmpty(timelineRawData)) {
            if (!Ext.isEmpty(selectedTimeline)) {
                timelineObj.setValue(selectedTimeline);
            } else {
                timelineObj.setValue(timelineRawData[0].valueField);
            }
        }

        var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;


		updatingAppSettings();
       appConstants.initLdgMask.hide();
    }
});