
Ext.define('VMotion.controller.Main',{
	extend:'Ext.app.Controller',
	requires:[
		'VMotion.view.Main'
	],
	refs:[
		{
			ref:'main',
			selector:'main'
		},
		{
			selector : 'newUtilities',
			ref : 'newUtilities'
		},
		{
			selector : 'vmotionmainform',
			ref : 'vmotionmainform'
		},{
			selector : 'ReporterSettings',
			ref : 'ReporterSettings'
		},{
			selector : 'vmotionsettings',
			ref : 'vmotionsettings'
		},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'main newUtilities' : {
				afterrender: this.hideTools
			},
			'main':{
				boxready: this.loadDefaults
			},
			'vmotionsettings':{
				afterrender: this.afterSettingsrender
			},
			'vmotionmainform combo[name="report_type"]' : {
				'select': this.groupOptionChange
			},
			'vmotionmainform combo[name="analysisBy"]' : {
				'select': this.groupOptionChange
			},
			'vmotionmainform combo[name="infraType"]':
			{
				'select': this.groupOptionChange
			},
			'vmotionmainform combo[name="subzone"]':
			{
				'select': this.groupOptionChange
			},
			/*'vmotionsettings combo[name="er_excwe"]':
			{
				'select': this.excludeWeekEnd
			},*/
			'reportgeneration combo[name="reportGeneration"]':
			{
				'select': this.showBackgroundReport
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'egcomponent button[id="expandSelectorComp"]':
			{
				'click': this.expandMe
			},
			'egcomponent boundlist[id="vmWareVCenterSelector"]' :
			{
				'itemclick' : this.filterOnChange
			},
			'vmotionsettings combo[id="timefrom"]' :
			{
				'select' : this.filterOnChange
			},
			'egcomponent button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'vmotionsettings combo[id="minfrom"]' :
			{
				'select' : this.filterOnChange
			},
			'vmotionsettings combo[id="timeto"]' :
			{
				'select' : this.filterOnChange
			},
			'vmotionsettings combo[id="minto"]' :
			{
				'select' : this.filterOnChange
			},
			'vmotionsettings button[id="goBtn"]' :
			{
				'click' : this.filterOnChange
			},
			'mainform button[name="submit"]' :
			{
				'click' : this.beforeReportSubmit
			},
			'mainform button[name="save"]' :
			{
				'click' : this.addTo
			},
			'newUtilities > #saveTool > button':
			{
				'click':this.savePdf
			},
			'newUtilities > #mailTool > button':
			{
				'click':this.sendMail
			},
			'newUtilities > #printTool > button':
			{
				'click':this.print
			},
			'newUtilities > #favoriteTool > button' : {
				'click' : this.addTo
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.addTo
			},
			'newUtilities > #csvTool > button':{
				'click': this.saveAsCSV
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
			,
			'timeline combo[id="er_timeline"]':{
				'select': this.loadInfos
			}
		});
	},
	loadInfos: function (obj) {
		this.sleep(2000);
		this.groupOptionChange(obj)
	},
	showConfigDropdown: function () {
		isSettingsEnabled = true;
      var tpl = new Ext.XTemplate(
         '<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
      //config dropdown mode
      Ext.create(
         'Ext.container.Container', {
         //padding: 5,
		 width:722,
         id: 'configMod',
         //cls: 'configMode_popup',
		 ui:'settingsWindowContainer',
         //html: tpl.apply(),
         items: [
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'512px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						cls:'containerHeader',
						style:{'top':'0px','margin':'0px'}
					},
					{
						xtype : 'vmotionsettings',
						parent:this
					}

         ],
         renderTo: 'vmotion-body'
      });
		var meController = this;
		Ext.get('closeSettings')
			  .on('click', function () {
					meController.validateSettings();
		   });

   },filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('VMware'),appConstants.rawDataForComponents);
    },
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('VMware'),'VMware vCenter',btn);
	},
	linkURL : function (q1)
	{
		this.updateQueryString();
		var Qstr=appConstants.graphUrlLinksJsonData[q1];
		Qstr = Qstr+'&'+appConstants.queryString;
		document.location = Qstr+"&isSubmit=true";
	},
	filterOnChange : function()
	{
		Ext.getCmp('vMotionDataPanel').hide();
		this.disableTools();
		this.callPopulate();
	},
	saveAsCSV : function()
	{
		var s_qryString = '../servlet/egurkha.reporter.SaveInCSVFormat?reporttype=null';
		Ext.widget('erutils').savePDF(s_qryString);
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	savePdf : function()
	{
		var mainForm = this.getVmotionmainform().getForm();
		var settingsForm ;
		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();

		var s_qryString = 'er_type='+report_type+'&select_group='+analysisBy;
		var selectedGpName = mainForm.findField('infraType').getValue();

		if(analysisBy!=null && analysisBy=='Zone')
		{
			var incSubZone = mainForm.findField('subzone').getValue();

			s_qryString = s_qryString+'&select_groupName='+encodeURIComponent(selectedGpName)+'&includeSubZone='+incSubZone;
		}
		else if(analysisBy!=null && analysisBy=='Segment')
		{
			s_qryString = s_qryString+'&select_groupName='+encodeURIComponent(selectedGpName);
		}
		else if(analysisBy!=null && analysisBy=='Service')
		{
			s_qryString = s_qryString+'&select_groupName='+encodeURIComponent(selectedGpName);
		}
		else
		{
			s_qryString = s_qryString+'&select_groupName=null';
		}

		var vcs = "";
		var compArr = new Array();
		compArr = Ext.getCmp('VMware').getValue();

		var compQStr = '';
		if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				vcs += '&er_component='+encodeURIComponent(compArr[i]);
			}
		}

		if(vcs!=null && vcs!='')
		{
			s_qryString = s_qryString + vcs;
		}
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		var excludeWeekEnd = appConstants.publicJsonData.hiddenParams.er_excweekend;
		if (isSettingsEnabled)
		{
			settingsForm = this.getVmotionsettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		var startdate = Ext.Date.dateFormat(mainForm.findField('er_stdate').getValue(), "d-m-Y");
		var enddate = Ext.Date.dateFormat(mainForm.findField('er_enddate').getValue(), "d-m-Y");
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		s_qryString = s_qryString+"&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_timeline="+encodeURIComponent(er_timeline)+"&startmin=00&endmin=00";

		if(appConstants.showFilters)
		{

			/*var selectedVMUser = appConstants.publicJsonData['hiddenParams'] ['reqVcUser'];
			var selectedEsxSrcHost = appConstants.publicJsonData['hiddenParams'] ['reqVcUser'];
			var selectedVM = appConstants.publicJsonData['hiddenParams'] ['reqVcVm'];
			var reqVcVmSource = appConstants.publicJsonData['hiddenParams'] ['reqVcVmSource'];
			var selectedEsxSrcTarget = appConstants.publicJsonData['hiddenParams'] ['reqVcVmDestination'];
			var selectedClusterSrc = appConstants.publicJsonData['hiddenParams'] ['reqvmclusersource'];
			var reqcluserdestination = appConstants.publicJsonData['hiddenParams'] ['reqcluserdestination'];
			var selectedClusterTarget = appConstants.publicJsonData['hiddenParams'] ['reqVmMigStatus'];
			var selectedMigrationType = appConstants.publicJsonData['hiddenParams'] ['reqVmMigType'];  */
			var selectedVM =  appConstants.publicJsonData['hiddenParams'] ['reqVcVm'];
			var selectedVMUser =  appConstants.publicJsonData['hiddenParams'] ['reqVcVm'];
			var selectedEsxSrcHost =  appConstants.publicJsonData['hiddenParams'] ['reqVcVmSource'];
			var selectedEsxSrcTarget =  appConstants.publicJsonData['hiddenParams'] ['reqVcVmDestination'];
			var selectedClusterSrc =  appConstants.publicJsonData['hiddenParams'] ['reqvmclusersource'];
			var selectedClusterTarget =  appConstants.publicJsonData['hiddenParams'] ['reqcluserdestination'];
			var selectedStatus =  appConstants.publicJsonData['hiddenParams'] ['reqVmMigStatus'];
			var selectedMigrationType =  appConstants.publicJsonData['hiddenParams'] ['reqVmMigType'];
			var summary = appConstants.publicJsonData.pageParams.er_summary;

			if (isSettingsEnabled)
			{
				selectedVM = settingsForm.findField('vmCombo').getValue();
				selectedVMUser = settingsForm.findField('vmUserCombo').getValue();
				selectedEsxSrcHost = settingsForm.findField('esxSrcCombo').getValue();
				selectedEsxSrcTarget = settingsForm.findField('esxTrgtCombo').getValue();
				selectedClusterSrc = settingsForm.findField('clusterSrcCombo').getValue();
				selectedClusterTarget = settingsForm.findField('clusterTrgtCombo').getValue();
				selectedStatus = settingsForm.findField('statusCombo').getValue();
				selectedMigrationType = settingsForm.findField('migrationTypeCombo').getValue();
				summary = settingsForm.findField('summaryCombo').getValue();
			}


			s_qryString = s_qryString+'&er_vm='+encodeURIComponent(selectedVM)+'&er_user='+encodeURIComponent(selectedVMUser)+'&er_vmsource='+encodeURIComponent(selectedEsxSrcHost)
								+'&er_vmdestination='+encodeURIComponent(selectedEsxSrcTarget)+'&er_vmclusersource='+encodeURIComponent(selectedClusterSrc)+'&er_vmcluserdestination='+encodeURIComponent(selectedClusterTarget)+'&er_vmmigstatus='+encodeURIComponent(selectedStatus)+'&er_vmmigtype='+encodeURIComponent(selectedMigrationType)+'&er_summary='+encodeURIComponent(summary);

			if(report_type!=null && (report_type=='Yes' || report_type=='Top'))
			{
				var showDetails = appConstants.publicJsonData.pageParams['showDetails'];
				if (isSettingsEnabled)
				{
					showDetails = settingsForm.findField('showDetailsCombo').getValue();
				}
				s_qryString = s_qryString+'&er_show_details='+showDetails;
			}
			else
			{
				var sortBy = appConstants.publicJsonData.pageParams['showDetails'];
				var recordsPerPage = appConstants.publicJsonData['pageParams']['er_recperpage'];
				var pageWidth = appConstants.publicJsonData['pageParams']['pageWidthProces'];
				if (isSettingsEnabled)
				{
					sortBy = settingsForm.findField('sortByCombo').getValue();
					recordsPerPage = settingsForm.findField('recordsPerPageCombo').getValue();
				}
				s_qryString = s_qryString+'&er_recperpage='+recordsPerPage+'&er_sortby='+encodeURIComponent(sortBy)+'&pageWidthProces='+pageWidth;
			}
		}

		var priority = appConstants.publicJsonData.pageParams['priority']
		if (isSettingsEnabled)
		{
			priority = settingsForm.findField('priorityCombo').getValue();
		}
		s_qryString = s_qryString+'&er_priority='+priority;

		s_qryString="../reporter/ErHtmlToSavePdf.jsp?"+s_qryString+"&inidate=dd-MM-yyyy";
		Ext.widget('erutils').savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var mainForm = this.getVmotionmainform().getForm();
		var settingsForm ;
		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();
		var s_qryString = 'er_type='+report_type+'&select_group='+analysisBy;
		var selectedGpName = mainForm.findField('infraType').getValue();
		if(analysisBy!=null && analysisBy=='Zone')
		{
			var incSubZone = mainForm.findField('subzone').getValue();
			s_qryString = s_qryString+'&select_groupName='+encodeURIComponent(selectedGpName)+'&includeSubZone='+incSubZone;
		}
		else if(analysisBy!=null && analysisBy=='Segment')
		{
			s_qryString = s_qryString+'&select_groupName='+encodeURIComponent(selectedGpName);
		}
		else if(analysisBy!=null && analysisBy=='Service')
		{
			s_qryString = s_qryString+'&select_groupName='+encodeURIComponent(selectedGpName);
		}
		else
		{
			s_qryString = s_qryString+'&select_groupName=null';
		}
		var vcs = "";
		var compArr = new Array();
		compArr = Ext.getCmp('VMware').getValue();
		var compQStr = '';
		if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				vcs += '&er_component='+encodeURIComponent(compArr[i]);
			}
		}
		if(vcs!=null && vcs!='')
		{
			s_qryString = s_qryString + vcs;
		}
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		var excludeWeekEnd = appConstants.publicJsonData.hiddenParams.er_excweekend;
		if (isSettingsEnabled)
		{
			settingsForm = this.getVmotionsettings().getForm();;
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		var startdate = Ext.Date.dateFormat(mainForm.findField('er_stdate').getValue(), "d-m-Y");
		var enddate = Ext.Date.dateFormat(mainForm.findField('er_enddate').getValue(), "d-m-Y");
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		s_qryString = s_qryString+"&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_timeline="+encodeURIComponent(er_timeline)+"&startmin=00&endmin=00";
		if(appConstants.showFilters)
		{
			var selectedVMUser = appConstants.publicJsonData['hiddenParams'] ['reqVcUser'];
			var selectedEsxSrcHost = appConstants.publicJsonData['hiddenParams'] ['reqVcUser'];
			var selectedVM = appConstants.publicJsonData['hiddenParams'] ['reqVcVm'];
			var reqVcVmSource = appConstants.publicJsonData['hiddenParams'] ['reqVcVmSource'];
			var selectedEsxSrcTarget = appConstants.publicJsonData['hiddenParams'] ['reqVcVmDestination'];
			var selectedClusterSrc = appConstants.publicJsonData['hiddenParams'] ['reqvmclusersource'];
			var reqcluserdestination = appConstants.publicJsonData['hiddenParams'] ['reqcluserdestination'];
			var selectedClusterTarget = appConstants.publicJsonData['hiddenParams'] ['reqVmMigStatus'];
			var selectedMigrationType = appConstants.publicJsonData['hiddenParams'] ['reqVmMigType'];
			var summary = appConstants.publicJsonData.pageParams.er_summary;
			if (isSettingsEnabled)
			{
				selectedVM = settingsForm.findField('vmCombo').getValue();
				selectedVMUser = settingsForm.findField('vmUserCombo').getValue();
				selectedEsxSrcHost = settingsForm.findField('esxSrcCombo').getValue();
				selectedEsxSrcTarget = settingsForm.findField('esxTrgtCombo').getValue();
				selectedClusterSrc = settingsForm.findField('clusterSrcCombo').getValue();
				selectedClusterTarget = settingsForm.findField('clusterTrgtCombo').getValue();
				selectedStatus = settingsForm.findField('statusCombo').getValue();
				selectedMigrationType = settingsForm.findField('migrationTypeCombo').getValue();
				summary = settingsForm.findField('summaryCombo').getValue();
			}
			s_qryString = s_qryString+'&er_vm='+encodeURIComponent(selectedVM)+'&er_user='+encodeURIComponent(selectedVMUser)+'&er_vmsource='+encodeURIComponent(selectedEsxSrcHost)
								+'&er_vmdestination='+encodeURIComponent(selectedEsxSrcTarget)+'&er_vmclusersource='+encodeURIComponent(selectedClusterSrc)+'&er_vmcluserdestination='+encodeURIComponent(selectedClusterTarget)+'&er_vmmigstatus='+encodeURIComponent(selectedStatus)+'&er_vmmigtype='+encodeURIComponent(selectedMigrationType)+'&er_summary='+encodeURIComponent(summary);
			if(report_type!=null && (report_type=='Yes' || report_type=='Top'))
			{
				var showDetails = appConstants.publicJsonData.pageParams['showDetails'];
				if (isSettingsEnabled)
				{
					showDetails = settingsForm.findField('showDetailsCombo').getValue();
				}
				s_qryString = s_qryString+'&er_show_details='+showDetails;
			}
			else
			{
				var sortBy = appConstants.publicJsonData.pageParams['showDetails'];
				var recordsPerPage = appConstants.publicJsonData['pageParams']['er_recperpage'];
				if (isSettingsEnabled)
				{
					sortBy = settingsForm.findField('sortByCombo').getValue();
					recordsPerPage = settingsForm.findField('recordsPerPageCombo').getValue();
				}
				s_qryString = s_qryString+'&er_recperpage='+recordsPerPage+'&er_sortby='+encodeURIComponent(sortBy);
			}
		}
		var priority = appConstants.publicJsonData.pageParams['priority']
		if (isSettingsEnabled)
		{
			priority = settingsForm.findField('priorityCombo').getValue();
		}
		s_qryString = s_qryString+'&er_priority='+priority;
		s_qryString=s_qryString+"&inidate=dd-MM-yyyy";
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.print();
	},
	print : function()
	{
		this.updateQueryString('printReport');
		var s_qryString="/final/reporter/ErVcVMotionPrint.jsp?"+appConstants.queryString+'&pdfPrint=yes&';
			parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


	},
	addTo : function(btn)
	{
		var validateForm = this.validateForm(false);
		if(validateForm)
		{
 			var er_timeline = Ext.getCmp('er_timeline').getValue();
			/* if(er_timeline != null && er_timeline == "Any")
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidTimelineMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				 return;
			} */
			this.updateQueryString(null);
			var target= '';

			var btnID = btn.getId();
			var formButtonId = btnID;
			var from_schedule = appConstants.publicJsonData['hiddenParams']['fromScheduleModify'];
			if (from_schedule != null && from_schedule == "Yes") {
				btnID = 'scheduleImg';
			}else{
				schedule_id = null;
				fromSchedule = null;
			}
			var windowClass;
			var frameId;
			if (btnID != null && btnID == 'scheduleImg') {
					//windowClass='scheduleWindow';
					//frameId='#schWin';
					target = "/final/reporter/ErSaveSchedule.jsp?isSchedule=true&"+appConstants.queryString+"&com.eg.CSRF_NONCE="+csrfToken;
				if (formButtonId=='save')
				{
					//document.location=s_qryString+'&showWindow=no';
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

			}
			else {
				var hiddenFields = appConstants.publicJsonData['hiddenParams'];
				var favorite_id = hiddenFields["favorite_id"];
				target = "../servlet/com.eg.ErFavoriteC?er_view=GRAPH&cmd=client&"+appConstants.queryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+'&FavoriteId='+favorite_id;
				if (formButtonId=='save')
				{
					//document.location=s_qryString+'&showSchWindow=no'+'&FavoriteId='+favorite_id;
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


			}

			//var target = s_qryString;
			//Ext.widget(windowClass).show();
			//Ext.select(frameId).set({src :target});
		}
	},
	validateForm : function(flag)
	{
		var me = this;
		var mainForm = this.getVmotionmainform().getForm();
		var settingsForm;
		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();

		var er_timeline =mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		stDate.setHours(mainForm.findField('er_sthr').getValue());
		enDate.setHours(mainForm.findField('er_endhr').getValue());
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		if(er_timeline!=null && er_timeline=="Any")
		{
			if(!checkDateTime(stDate,enDate))
			{
				return;
			}
		}
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		if (isSettingsEnabled)
		{
			settingsForm = this.getVmotionsettings().getForm();
			reportgen = settingsForm.findField('reportGeneration').getValue();
		}
		var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = appConstants.publicJsonData['hiddenParams']['er_usertimeline'];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}
		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				return false;
			}
		}

		if(report_type!=null && report_type=='Not Applicable')
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidReportTypeMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			return false;
		}

		if(analysisBy!=null && analysisBy=='Not Applicable')
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.invalidAnalysisOptionMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		var selectedGroup = appConstants.publicJsonData['pageParams']['selectedGroup'];
		if(selectedGroup!=null && selectedGroup=='Zone')
		{
			var zoneCombo =mainForm.findField('infraType').getValue();
			if(zoneCombo!=null && (zoneCombo=="Not Applicable" || zoneCombo=="-1"))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidZoneMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		var vcs = "";
		var compArr = new Array();
		compArr = Ext.getCmp('VMware').getValue();
		var compQStr = '';
		if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				vcs += compArr[i];
				vcs += "*";
			}
		}

		vcs = vcs.substring(0,vcs.length-1);
		if(vcs!=null && (vcs=="-1" || vcs==""))
		{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidVCenterMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			return false;
		}
		if(appConstants.showFilters)
		{
			var selectedVM = appConstants.publicJsonData['hiddenParams']['reqVcVm'];
			var selectedVMUser = appConstants.publicJsonData['hiddenParams']['reqVcUser']; 
			var selectedEsxSrcHost = appConstants.publicJsonData['hiddenParams']['reqVcVmSource'];
			var selectedEsxSrcTarget = appConstants.publicJsonData['hiddenParams']['reqVcVmDestination']; 
			var selectedClusterSrc = appConstants.publicJsonData['hiddenParams']['reqvmclusersource'];
			var selectedClusterTarget = appConstants.publicJsonData['hiddenParams']['reqcluserdestination'];
			var selectedStatus = appConstants.publicJsonData['hiddenParams']['reqVmMigStatus'];
			var selectedMigrationType = appConstants.publicJsonData['hiddenParams']['reqVmMigType'];

			if(isSettingsEnabled)
			{
				selectedVM = settingsForm.findField('vmCombo').getValue();
				selectedVMUser = settingsForm.findField('vmUserCombo').getValue();
				selectedEsxSrcHost = settingsForm.findField('esxSrcCombo').getValue();
				selectedEsxSrcTarget = settingsForm.findField('esxTrgtCombo').getValue();
				selectedClusterSrc = settingsForm.findField('clusterSrcCombo').getValue();
				selectedClusterTarget = settingsForm.findField('clusterTrgtCombo').getValue();
				selectedStatus = settingsForm.findField('statusCombo').getValue();
				selectedMigrationType = settingsForm.findField('migrationTypeCombo').getValue();
				summary = settingsForm.findField('summaryCombo').getValue();
			}
			
			if(selectedVM=='Not Applicable' || selectedVM=='undefined' || selectedVM == undefined)
			{  
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidVMOptionMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{
						if(buttonId == 'ok'){
							me.getReporterSettings().down('button').fireHandler();
						}	
					}
					
				});
				return false;
			}
			if(selectedVMUser=='Not Applicable' ||  selectedVMUser==undefined || selectedVMUser=='undefined')
			{
				alert(123)
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidVMUserOptionMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{
						if(buttonId == 'ok')
						{
							//me.getEventHandlers();
							me.getReporterSettings().down('button').fireHandler();
						}
					}
					
				});
				return false;
			}
			if(selectedEsxSrcHost=='Not Applicable' || selectedEsxSrcHost=='undefined' || selectedEsxSrcHost == undefined)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidEsxSrcMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{
						if(buttonId == 'ok')
						{
							//this.getEventHandlers();
							me.getReporterSettings().down('button').fireHandler();
						}
					}
				});
				return false;
			}
			if(selectedEsxSrcTarget=='Not Applicable' || selectedEsxSrcTarget=='undefined' || selectedEsxSrcTarget == undefined)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidEsxTrgtMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{
						if(buttonId = 'ok')
						{
							me.getReporterSettings().down('button').fireHandler();
						}
					}
				});
				return false;
			}
			if(selectedClusterSrc=='Not Applicable' || selectedClusterSrc=='undefined' || selectedClusterSrc == undefined)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidClusterSrcMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{
						if(buttonId = 'ok'){
							me.getReporterSettings().down('button').fireHandler();
						}
					}
				});
				return false;
			}
			if(selectedClusterTarget=='Not Applicable' || selectedClusterTarget=='undefined' || selectedClusterTarget == undefined)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidClusterTrgtMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{
						if(buttonId == 'ok')
						{
							me.getReporterSettings().down('button').fireHandler();
						}
					}
				});
				return false;
			}
			if(selectedStatus=='Not Applicable' || selectedStatus=='undefined' || selectedStatus == undefined)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidMigrationStatusMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{	
						if(buttonId == 'ok')
						{
							me.getReporterSettings().down('button').fireHandler();
						}
					}
				});
				return false;
			}
			if(selectedMigrationType=='Not Applicable' || selectedMigrationType =='undefined' || selectedMigrationType == undefined)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.invalidMigrationTypeMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
					fn:function(buttonId)
					{
						if(buttonId == 'ok')
						{
							this.getReporterSettings().down('button').fireHandler();
						}
					}
				});
				return false;
			}
		}
		var fromSchedule =  appConstants.publicJsonData['hiddenParams']['fromSchedule'];
		if ( reportgen!=null && reportgen == 'foreground' && fromSchedule !='yes')
		{
			if(flag)
			{
				var limitforbg = appConstants.publicJsonData['hiddenParams']['limitforbg'];

				if(!Ext.isEmpty(limitforbg))
				{
					if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,stDate,enDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						return false
					} else
						return true;
				} else
						return true;
			}
		}
		else if (reportgen!=null && reportgen == 'background')
		{
				var reportNameObj = settingsForm.findField('bgReportName');
				var reportName = reportNameObj.getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					reportNameObj.focus();
					return false;
				}
		}

		return true;

	},
	beforeReportSubmit: function()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var isValidForm = this.validateForm(true);
		if(isValidForm)
		{
			var fromSchedule =  appConstants.publicJsonData['hiddenParams']['fromSchedule'];
			if(fromSchedule!=null && fromSchedule=="Yes")
			{
				this.addTo(Ext.getCmp('scheduleImg'),null,null);
			}
			else
			{
				this.submitReport();
			}
		}
	},
	loadVMotionReportData : function(jsonData)
	{
		var settingsForm;
		var mainForm = this.getVmotionmainform().getForm();
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			settingsForm = this.getVmotionsettings().getForm();
			reportgen = settingsForm.findField('reportGeneration').getValue();
		}
		var vMotionDataPanel = Ext.getCmp('vMotionDataPanel');
		vMotionDataPanel.removeAll();
		vMotionDataPanel.show();
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		if(reportgen!=null && reportgen=='background')
		{
 			Ext.getCmp("saveTool").setDisabled(true);
 			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
			Ext.getCmp("csvTool").setDisabled(true);
			//Ext.getCmp("upbutton").setDisabled(false);

			var bgGroundMsg = jsonData.pageParams['bggroundStr'];
			var status = jsonData.pageParams['status'];
			var langSupportString = jsonData.pageParams['bgLangSupportStr'];
			var bgReportUrl = jsonData.pageParams['bgLinkUrl'];		
			var bgreportlinkMsg = jsonData.pageParams['bgLinkMsg'];
			var tableTitle='';
			//var htmlStr = "<div style='text-align:center;margin-top:50px'>";
			var htmlStr='';
			var statusCssClass='iconSuccess';
			if((status != null && status == "duplicate") || (bgGroundMsg!=null && bgGroundMsg == "User background report generationlimit is finished"))
			{
				statusCssClass = 'iconExclamation';
			}
				//htmlStr += "<center><div class='block1' style='font-size:13px;padding:8px;text-align:left;display:block;width:480px;height:90' class='panelwithoutheader'><div style='margin:20px;display:block;width:38px;height:34px;float:left;' class='"+statusCssClass+"'></div><div style='margin-top:20px'><b>"+langSupportString+".</b><br/><a class='backgroundMsgLink' style='text-decoration:underline' href=\""+bgReportUrl+"\"/>"+bgreportlinkMsg+"</a></div></div></center>";
					
					//+ "</div>";
				htmlStr += '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+bgReportUrl+'>'+ bgreportlinkMsg + '</a></div></td></tr></table></td></tr></table>';

			this.getBackGroundPanel().update(htmlStr);
 			this.getBackGroundPanel().show();
		}
		else
		{
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			//Ext.getCmp("upbutton").setDisabled(false);
			Ext.getCmp("scheduleTool").setDisabled(false);

			var showCsv = jsonData['pageParams']['showCsv'];

			if(showCsv!=null && showCsv=="true")
			{
				Ext.getCmp("csvTool").setDisabled(false);
			}

			var dataAvailable = jsonData['dataAvailable'];
			var report_type = jsonData['pageParams']['er_type'];
			var isDataAvailable = false;
			if(dataAvailable=="true" || dataAvailable==true)
			{
				isDataAvailable=true;

				var summaryGridData = jsonData['summaryGridData'];
				var summaryTitle = jsonData['summaryTableTitle'];
				//console.log(summaryGridData);
				var summaryPanel = Ext.widget('panel',
						{
						ui:'newGraphPanel',
						layout:{
							type:'vbox',
							align: 'stretch'
						},
						flex:1,
						//title:'Virtual Machines Migration Summary ',
						title:summaryTitle,
						width:400,
						style:{margin:'10px auto'},
					 items: [
						{
						xtype:'dataview',
						flex:1,
						store: new Ext.data.Store({
							fields:['migrationType','NoOfMigrations','migrationsPerDay','url'],
							data:summaryGridData
						}),
						tpl:new Ext.XTemplate('<div class="newTable">',
								'<table cellspacing="0" cellpadding="0" border="0" width="90%" style="margin:0px 10px 10px 15px">',
									'<thead>',
									'</thead>',
								'<tbody>',
								 '<tpl for=".">',
									'<tr>',
										'<td>',
											'<div>{migrationType}</div>',
										'</td>',
										'<td>',
											'<div>{NoOfMigrations}</div>',
										'</td>',
										'<td>',
											'<div style="text-align:center">',
												'{migrationsPerDay}',
												//'</div>',
											'</div>',
										'</td>',
									'</tr>',
									'</tpl>',
								'</tbody>',
								'</table>',
								'</div>'),
						itemSelector: 'div.x-table'
					 }]
						});
				 vMotionDataPanel.add(summaryPanel);
				 vMotionDataPanel.doLayout();

				if(report_type!=null && report_type=='Yes')
				{
					var graphDatas = jsonData['graphDatas'];
					var graphsArr = graphDatas['graphsArr'];
					appConstants.graphUrlLinksJsonData = graphDatas['graphURLLinks']
					var graphPanelArr = new Array();
					for(var g in graphsArr)
					{

						var graphDataObj = graphsArr[g];
						var graphPanel = Ext.widget('panel',
						{
							title : graphDataObj['chartTitle'],
							ui:'newGraphPanel',
							id : 'vMotionGraph'+g,
							name : 'vMotionGraph'+g,
							frame : false,
							//height : 450,
							html : '<div id="chartdiv'+g+'"></div>',
							margin : '0 10 10 10',
						});
						graphPanelArr.push(graphPanel);
					}
					vMotionDataPanel.add(graphPanelArr);
					vMotionDataPanel.doLayout();

				for(var gr in graphsArr)
					{
						if(appConstants.chartType=='fusionchart')
						{
							
							if (FusionCharts( "vMotionGraph_332"+gr)) 
							FusionCharts( "vMotionGraph_332"+gr).dispose();
							var chart2 = new FusionCharts(graphsArr[gr].swfPath, "vMotionGraph_332"+gr, "100%", "350", "0", "1");
							chart2.setDataXML(graphsArr[gr].xmlData);
							chart2.setTransparent(true);
							chart2.render("chartdiv"+gr);
						}
						else if(appConstants.chartType=='highchart')
						{
								var highChart = {};
								highChart = jQuery.extend(true, {}, getHighChartsBarInstance("chartdiv"+gr,graphsArr[gr].chartHeight,graphsArr[gr].chartWidth), highChart);
								highChart.setData(graphsArr[gr],'<%=currentDateFormat%>','');
								highChart.drawChart();
						}
					}
					isDataAvailable = true;
				}
				else if(report_type!=null && report_type=='Top')
				{
					var gridObjs = jsonData['gridObjs'];
					appConstants.gridVMURLLinks = jsonData['gridVMURLLinks'];
					if(!Ext.isEmpty(gridObjs))
					{
						for(var gridObj in gridObjs)
						{
							var gridDataObj = gridObjs[gridObj];
							var title = gridDataObj['gridTitle'];
							var columns = gridDataObj['columns'];

							var genColumns = new Array();
							var gridIndexVals = gridDataObj['gridData'];
							//var gridStore = gridIndexVals;
							var gridFields = new Array();
							for ( var colVal in columns )
							{
								var colName = columns[colVal];

								gridFields.push({ name : colVal  , type : 'string' });

								if(colVal!=null && colVal=='COLUMN_0')
								{
									gridFields.push({ name : colVal+'_URL'  , type : 'string' });

									genColumns.push(
									{
										header: colName,
										sortable: true,
										flex: 1,
										align: 'left',
										dataIndex: colVal,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var hrefUrl=record.get('COLUMN_'+col+'_URL');
											if(hrefUrl!=null && hrefUrl!='undefined' && hrefUrl!='-')
											{ 
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
												value = '<a class="anchorLinkDefault" href="'+hrefUrl+'">'+value+'</a>';
											}
											return value;
										}
									});

								}
								else
								{
									genColumns.push(
									{
										header: colName,
										sortable: true,
										flex: 1,
										align: 'center',
										dataIndex: colVal,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
											value = Ext.getCmp('gridId'+gridObj).getDecimalAlignFormat(value);
											return value;
										}
									});
								}

							}
							vMotionDataPanel.add(
							{
								xtype:'panel',
								ui:'newGraphPanel',
								margin:'10 10 10 10',
								title:title,
								items:[{
									xtype:'customgrid',
									ui:'newGridPanel',
									store: Ext.data.Store(
										{
											fields: gridFields,
											data:gridIndexVals
										}),
									border:true,
									layout: 'auto',
									id:'gridId'+gridObj,
									scroll:true,
									frame: false,
									margin:'5 10 10 10',
									autoScroll:true,
									stripeRows: false,
									columns:genColumns
								}]
							});

						}
						vMotionDataPanel.doLayout();
						isDataAvailable = true;
					}
				}
				else if(report_type!=null && report_type=='No')
				{
					var migrationDetailsJson = jsonData['migrationDetailsJson'];
					if(!Ext.isEmpty(migrationDetailsJson))
					{
						var title = migrationDetailsJson['gridTitle'];
						var columns = migrationDetailsJson['columns'];
						var genColumns = new Array();
						var gridIndexVals = migrationDetailsJson['gridData'];
						var showVirtualCenterColumn = jsonData['pageParams']['showVirtualCenterColumn'];
						var isShowVirtualCenterColumn =false;
						if(showVirtualCenterColumn!=null && showVirtualCenterColumn=="true")
						{
							isShowVirtualCenterColumn = "true";
						}
						var gridFields = new Array();
						var minWidthVal = 150;
						console.log(columns);
						for ( var colVal in columns )
						{
 							gridFields.push({ name : colVal  , type : 'string' });
							if(colVal=='COLUMN_11')
							{
								minWidthVal = 250;
							}
							//prakash
							var align='left';
							if(columns[colVal] == 'Success' || columns[colVal] == 'Migration Type *')
							{
								align='center';
							}
							//
							genColumns.push(
							{
								header:  columns[colVal],
								sortable: true,
 								width : minWidthVal,
								align: align,
								dataIndex: colVal,
								renderer:function(value, metaData, record, row, col, store, gridView)
								{
								   metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								   return value;
								}
							});

						}
					/*	var addSubmittedReports = vMotionDataPanel.add({
								xtype:'panel',
								id:'legendPanel',
								width: '100%',
			//										height : '200',
								items:[
								{
									xtype:'panel',
									width:'100%',
									html : '<div style="text-align:center"">'+migrationDetailsJson['legendString']+'</div>'
								}
								]

							});*/
					//	initLdgMask.hide();
						var recordsPerPage = jsonData['pageParams']['recordsPerPage'];
						vMotionDataPanel.add(
						{
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'10 10 10 10',
							title: '<span class="font_bold">'+title+'</span>',
							items:[{
								xtype:'vmmigrationgrid',
								grid_Fields : gridFields,
								grid_columns:genColumns,
								dataArray : gridIndexVals,
								pageLimit : recordsPerPage
							}]
						});

						//vMotionDataPanel.add(addSubmittedReports);
						isDataAvailable = true;
					}
				}
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selDetailsJson);
			}
			if(isDataAvailable==false)
			{

				vMotionDataPanel.hide();
 				this.getNomeasurepanel().show();
				Ext.getCmp("bookletTool").setDisabled(true);
				Ext.getCmp("saveTool").setDisabled(true);
				Ext.getCmp("printTool").setDisabled(true);
				Ext.getCmp("mailTool").setDisabled(true);
			}
		}
	},
	submitReport : function(combo)
	{
		var settingsForm;
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		if (isSettingsEnabled)
		{
			settingsForm = this.getVmotionsettings().getForm();
			reportgen = settingsForm.findField('reportGeneration').getValue();
		}
		var meController = this;
		this.updateQueryString(null);
		if(reportgen!=null && reportgen == "foreground")
		{
			appConstants.queryString = appConstants.queryString+'&responseType=json';
		}
		appConstants.queryString +="&er_RmDispName="+appConstants.er_RmDispName;
		appConstants.initLdgMask.show();
		Ext.Ajax.request({
			url : appConstants.urlForSubmit,
			params: appConstants.queryString,
			timeout : 180000,
			scope:this,
			success: function(response)
			{
				var jsonText  = response.responseText;
				//console.log(jsonText);
				if(!Ext.isEmpty(jsonText))
				{
					appConstants.initLdgMask.hide();
					var jsonData=Ext.decode(jsonText);
					meController.loadVMotionReportData(jsonData);
				}
			}
		});
	},

	showBackgroundReport: function(combo)
	{
		Ext.getCmp('vMotionDataPanel').hide();
		this.disableTools();
		var settingsForm = this.getVmotionsettings().getForm();
		var val = combo.getValue();
		var reportNameObj = settingsForm.findField('bgReportName');
		if ( val == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	/*excludeWeekEnd : function(combo)
	{
		Ext.getCmp('vMotionDataPanel').hide();
		this.disableTools();
		if(combo!=null && combo.getValue()=='Yes')
		{
 			var mainform = this.getVmotionmainform().getForm();
			var er_timeline = mainform.findField('er_timeline').getValue();
			var startdate = Ext.Date.dateFormat(mainform.findField('er_stdate').getValue(), mgrDateFormat);
			var enddate = Ext.Date.dateFormat(mainform.findField('er_enddate').getValue(), mgrDateFormat);
			var startHour = mainform.findField('er_sthr').getValue();
			var endHour = mainform.findField('er_endhr').getValue();

			var no_params= '&P0=[VIRTUAL_CENTER]';

			var me = this;
			var param = 'F=getExcucludeWeekend&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
			Ext.Ajax.request({
				url: remoteURL,
				method: 'POST',
				async: false,
				params: param,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
//						console.log('remote scription timeline json---->'+jsonText);

						var jsonData=Ext.decode(jsonText);

						var excludeLbl = Ext.getCmp('excludesLbl');
						excludeLbl.setText("Excludes	"+jsonData['values']);
						excludeLbl.show();
						me.callPopulate();
					}
				}
			});
		}
		else
		{
			Ext.getCmp('excludesLbl').hide();
			this.callPopulate();
		}
	},*/
	timeLineOnChange : function(combo)
	{
		Ext.getCmp('vMotionDataPanel').hide();
		var mainform = this.getVmotionmainform().getForm();
		this.disableTools();
		var meController = this;
		//var settingsForm = this.getVmotionsettings().getForm();
		var startdateObj = mainform.findField('er_stdate');
		var enddateObj = mainform.findField('er_enddate');
		var startHourObj = mainform.findField('er_sthr');
		var endHourObj = mainform.findField('er_endhr');

		var changeTimeline =false;
		if ( combo.getValue() == 'Any' )
		{
			startdateObj.setDisabled(false);
			enddateObj.setDisabled(false);
			startHourObj.setDisabled(false);
			endHourObj.setDisabled(false);
		}
		else
		{
			startdateObj.setDisabled(true);
			enddateObj.setDisabled(true);
			startHourObj.setDisabled(true);
			endHourObj.setDisabled(true);
			changeTimeline = true;
		}

		if(changeTimeline==true)
		{
			var er_timeline = mainform.findField('er_timeline').getValue();
			var stDate = startdateObj.getValue();
			var enDate = enddateObj.getValue();
			var startdate = Ext.Date.dateFormat(stDate, mgrDateFormat);
			var enddate = Ext.Date.dateFormat(enDate, mgrDateFormat);
			var startHour = mainform.findField('er_sthr').getValue();
			var endHour = mainform.findField('er_endhr').getValue();

			stDate.setHours(startHour);
			enDate.setHours(endHour);

			if(er_timeline!=null && er_timeline=="Any")
			{
				if(!checkDateTime(stDate,enDate))
				{
					return;
				}
			}
			var no_params= '&P0=['+er_timeline+']&P1=['+startdate+']&P2=['+enddate+']&P3=['+startHour+']&P4=['+endHour+']&P5=['+iniDateFormat+']';
			var me = this;
			var param = 'F=getTime&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
			Ext.Ajax.request({
				url: remoteURL,
				method: 'POST',
				async: false,
				params: param,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
//						console.log('remote scription timeline json---->'+jsonText);
						var jsonData = Ext.decode(jsonText);
						var timelineValues = jsonData['timeline'];
						var startdateObj = mainform.findField('er_stdate');
						var enddateObj = mainform.findField('er_enddate');
						var startHourObj = mainform.findField('er_sthr');
						var endHourObj = mainform.findField('er_endhr');

						var stDate = timelineValues[0];
						var endDate = timelineValues[1];
						var startHr = timelineValues[2];
						var endHr = timelineValues[3];

						startdateObj.setValue(stDate);
						enddateObj.setValue(endDate);
						startHourObj.setValue(startHr);
						endHourObj.setValue(endHr);

						meController.callPopulate();
					}
				}
			});
		}
	},
	callRemoteScript: function( form, fieldName, remoteURL, no_params, funcName )
	{
		var me = this;
		var param = 'F='+funcName+'&C=jsrs1'+no_params+'&debug=true&U='+new Date().getTime()+'&fromajax=true';
		if(fieldName=='statustCombo')
			param = param+'&statusCombo=true';
		Ext.Ajax.request({
			url: remoteURL,
			method: 'POST',
			async: false,
			params: param,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
//					console.log('remote scription json---->'+jsonText);
					var jsonData = Ext.decode(jsonText);
					var comboVal = jsonData['combo'];
					if ( !Ext.isEmpty( comboVal ) )
					{
						var thisStore = form.findField(fieldName).getStore();
						thisStore.loadRawData(comboVal);

						if(thisStore.getCount()>1)
						{
							thisStore.insert(0,{
							'displayField':appConstants.allOptionMsg,
							'valueField':'-1'
							});
							form.findField(fieldName).setValue("-1");
						}
						else
						{
							form.findField(fieldName).setValue(comboVal[0]['valueField']);
						}
					}
					else
					{
						form.findField(fieldName).setValue(appConstants.notApplicableLbl);
					}
				}
			}
		});
	},
	callPopulate : function() {
		//if (isSettingsEnabled)
		//{
			//this.getSettings().down('button').fireHandler();
		//}
		if(appConstants.showFilters && isSettingsEnabled)
		{
			var thisForm = this.getVmotionmainform().getForm();
			var settingsForm = this.getVmotionsettings().getForm();
			var vcs = "";
			var compArr = new Array();
			compArr = Ext.getCmp('VMware').getValue();
			var compQStr = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					vcs += compArr[i];
					vcs += "*";
				}
			}

			vcs = vcs.substring(0,vcs.length-1);
			if(vcs == "" || vcs == "-1" ) {
				settingsForm.findField("vmCombo").setValue(appConstants.notApplicableLbl);
				settingsForm.findField("vmUserCombo").setValue(appConstants.notApplicableLbl);
				settingsForm.findField("esxSrcCombo").setValue(appConstants.notApplicableLbl);
				settingsForm.findField("esxTrgtCombo").setValue(appConstants.notApplicableLbl);
				settingsForm.findField("clusterSrcCombo").setValue(appConstants.notApplicableLbl);
				settingsForm.findField("clusterTrgtCombo").setValue(appConstants.notApplicableLbl);
				settingsForm.findField("statustCombo").setValue(appConstants.notApplicableLbl);
				settingsForm.findField("migrationTypeCombo").setValue(appConstants.notApplicableLbl);
				return;
			}
			
		}	  
		
		/*if(appConstants.showFilters)
		{
			var thisForm = this.getVmotionmainform().getForm();
			var settingsForm;
			var vcs = "";
			var compArr = new Array();
			compArr = Ext.getCmp('VMware').getValue();
			var compQStr = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					vcs += compArr[i];
					vcs += "*";
				}
			}

			vcs = vcs.substring(0,vcs.length-1);
			var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
			var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
			var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
			var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
			var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
			var excludeWeekEnd = appConstants.publicJsonData.hiddenParams.er_excweekend;
			if (isSettingsEnabled)
			{
				settingsForm = this.getVmotionsettings().getForm();
				if(vcs == "" || vcs == "-1" ) {
					settingsForm.findField("vmCombo").setValue(appConstants.notApplicableLbl);
					settingsForm.findField("vmUserCombo").setValue(appConstants.notApplicableLbl);
					settingsForm.findField("esxSrcCombo").setValue(appConstants.notApplicableLbl);
					settingsForm.findField("esxTrgtCombo").setValue(appConstants.notApplicableLbl);
					settingsForm.findField("clusterSrcCombo").setValue(appConstants.notApplicableLbl);
					settingsForm.findField("clusterTrgtCombo").setValue(appConstants.notApplicableLbl);
					settingsForm.findField("statustCombo").setValue(appConstants.notApplicableLbl);
					settingsForm.findField("migrationTypeCombo").setValue(appConstants.notApplicableLbl);
					return;
				}
				timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
				timePeriodFromMins = settingsForm.findField('minfrom').getValue();
				timePeriodToHrs = settingsForm.findField('timeto').getValue();
				timePeriodToMins = settingsForm.findField('minto').getValue();
				reportgen = settingsForm.findField('reportGeneration').getValue();
				excludeWeekEnd = settingsForm.findField('er_excwe').getValue();

				this.callRemoteScript(settingsForm,"vmCombo", remoteURL, no_params, 'getDataForVcVmotions');

				var no_params= '&P1=[USERNAME]'+commonParams;

				this.callRemoteScript(settingsForm,"vmUserCombo", remoteURL, no_params, 'getDataForVcVmotions');

				no_params= '&P1=[SOURCEHOST]'+commonParams;

				this.callRemoteScript(settingsForm,"esxSrcCombo", remoteURL, no_params, 'getDataForVcVmotions');

				no_params= '&P1=[DESTINATIONHOST]'+commonParams;

				this.callRemoteScript(settingsForm,"esxTrgtCombo", remoteURL, no_params, 'getDataForVcVmotions');

				no_params= '&P1=[SOURCECLUSTER]'+commonParams;

				this.callRemoteScript(settingsForm,"clusterSrcCombo", remoteURL, no_params, 'getDataForVcVmotions');

				no_params= '&P1=[TARGETCLUSTER]'+commonParams;

				this.callRemoteScript(settingsForm,"clusterTrgtCombo", remoteURL, no_params, 'getDataForVcVmotions');

				no_params= '&P1=[MEASURE]'+commonParams;

				this.callRemoteScript(settingsForm,"statustCombo", remoteURL, no_params, 'getDataForVcVmotions');

				no_params= '&P1=[MEASURE]'+commonParams;

				this.callRemoteScript(settingsForm,"migrationTypeCombo", remoteURL, no_params, 'getDataForVcVmotions');

			}
			var startdate = Ext.Date.dateFormat(thisForm.findField('er_stdate').getValue(), mgrDateFormat);
			var enddate = Ext.Date.dateFormat(thisForm.findField('er_enddate').getValue(), mgrDateFormat);
			var startHour = thisForm.findField('er_sthr').getValue();
			var endHour = thisForm.findField('er_endhr').getValue();

			var commonParams = '&P0=['+vcs+']&P2=['+excludeWeekEnd+']&P3=['+startdate+']&P4=['+enddate+']&P5=['+startHour+']&P6=['+endHour+']&P7=['+timePeriodFromHrs+']&P8=['+timePeriodFromMins+']&P9=['+timePeriodToHrs+']&P10=['+timePeriodToMins+']&P11=['+iniDateFormat+']';

			no_params= '&P1=[VMNAME]'+commonParams;
		}*/
	},
	updateQueryString : function(from)
	{
		var mainForm = this.getVmotionmainform().getForm();
		var settingsForm;
		var report_type = mainForm.findField('report_type').getValue();
		var analysisBy = mainForm.findField('analysisBy').getValue();

		var paramsForChange = 'er_type='+report_type+'&select_group='+analysisBy;
		var selectedGpName = mainForm.findField('infraType').getValue();

		if(analysisBy!=null && analysisBy=='Zone')
		{

			var incSubZone = mainForm.findField('subzone').getValue();

			paramsForChange = paramsForChange+'&select_groupName='+encodeURIComponent(selectedGpName)+'&includeSubZone='+incSubZone;
		}
		else if(analysisBy!=null && analysisBy=='Segment')
		{
			paramsForChange = paramsForChange+'&select_groupName='+encodeURIComponent(selectedGpName);
		}
		else if(analysisBy!=null && analysisBy=='Service')
		{
			paramsForChange = paramsForChange+'&select_groupName='+encodeURIComponent(selectedGpName);
		}

		var vcs = "";
		var compArr = new Array();
		compArr = Ext.getCmp('VMware').getValue();

		/*if(from!=null && (from=='printReport' || from == 'submit'))
		{*/
			var compQStr = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					vcs += "&er_component="+encodeURIComponent(compArr[i]);
				}
			}

			if(vcs!=null && vcs!='')
			{
				paramsForChange += vcs;
			}
		//}
		/*else
		{
			var compQStr = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					vcs += compArr[i];
					vcs += "*";
				}
			}
			vcs = vcs.substring(0,vcs.length-1);
			paramsForChange += '&er_component='+encodeURIComponent(vcs);
		} */
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.Hourfrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.Minfrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.Hourto;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.Minto;
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		var excludeWeekEnd = appConstants.publicJsonData.hiddenParams.er_excweekend;
		if (isSettingsEnabled)
		{
			settingsForm = this.getVmotionsettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		//when clicking submit report time period changed from 00 to 0. so after clicking bar graph, the value is not set in timeperiod.
		//So commented this line. 
		/*if(from!=null && from!='printReport')
		{
			if(timePeriodFromHrs=='00')
				timePeriodFromHrs='0';
			if(timePeriodToHrs=='00')
				timePeriodToHrs='0';
			if(timePeriodFromMins=='00')
				timePeriodFromMins='0';
			if(timePeriodToMins=='00')
				timePeriodToMins='0';
		}*/
		paramsForChange = paramsForChange+"&startdate=" + startdate + "&enddate=" + enddate + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&er_timeline="+encodeURIComponent(er_timeline)+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins;


		if(appConstants.showFilters)
		{
			var selectedVMUser = appConstants.publicJsonData['hiddenParams'] ['reqVcUser'];
			var selectedEsxSrcHost = appConstants.publicJsonData['hiddenParams'] ['reqVcUser'];
			var selectedVM = appConstants.publicJsonData['hiddenParams'] ['reqVcVm'];
			var reqVcVmSource = appConstants.publicJsonData['hiddenParams'] ['reqVcVmSource'];
			var selectedEsxSrcTarget = appConstants.publicJsonData['hiddenParams'] ['reqVcVmDestination'];
			var selectedClusterSrc = appConstants.publicJsonData['hiddenParams'] ['reqvmclusersource'];
			var reqcluserdestination = appConstants.publicJsonData['hiddenParams'] ['reqcluserdestination'];
			var selectedClusterTarget = appConstants.publicJsonData['hiddenParams'] ['reqVmMigStatus'];
			var selectedMigrationType = appConstants.publicJsonData['hiddenParams'] ['reqVmMigType'];
			var summary = appConstants.publicJsonData.pageParams.er_summary;
			var selectedStatus = appConstants.publicJsonData['hiddenParams']['reqVmMigStatus'];

			if (isSettingsEnabled)
			{
				selectedVM = settingsForm.findField('vmCombo').getValue();
				selectedVMUser = settingsForm.findField('vmUserCombo').getValue();
				selectedEsxSrcHost = settingsForm.findField('esxSrcCombo').getValue();
				selectedEsxSrcTarget = settingsForm.findField('esxTrgtCombo').getValue();
				selectedClusterSrc = settingsForm.findField('clusterSrcCombo').getValue();
				selectedClusterTarget = settingsForm.findField('clusterTrgtCombo').getValue();
				selectedStatus = settingsForm.findField('statusCombo').getValue();
				selectedMigrationType = settingsForm.findField('migrationTypeCombo').getValue();
				summary = settingsForm.findField('summaryCombo').getValue();

				appConstants.publicJsonData['hiddenParams']['reqVcVm'] = selectedVM;
				appConstants.publicJsonData['hiddenParams']['reqVcUser'] = selectedVMUser;
				appConstants.publicJsonData['hiddenParams']['reqVcVmSource'] = selectedEsxSrcHost;
				appConstants.publicJsonData['hiddenParams']['reqVcVmDestination'] = selectedEsxSrcTarget;
				appConstants.publicJsonData['hiddenParams']['reqvmclusersource'] = selectedClusterSrc;
				appConstants.publicJsonData['hiddenParams']['reqcluserdestination'] = selectedClusterTarget;
				appConstants.publicJsonData['hiddenParams']['reqVmMigStatus'] = selectedStatus;
				appConstants.publicJsonData['hiddenParams']['reqVmMigType'] = selectedMigrationType;
			}

			if(Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			paramsForChange = paramsForChange+'&er_vm='+appConstants.erUtils.specialCharEncode(selectedVM)+'&er_user='+appConstants.erUtils.specialCharEncode(selectedVMUser)+'&er_vmsource='+encodeURIComponent(selectedEsxSrcHost)+'&er_vmdestination='+encodeURIComponent(selectedEsxSrcTarget)+'&er_vmclusersource='+encodeURIComponent(selectedClusterSrc)+'&er_vmcluserdestination='+encodeURIComponent(selectedClusterTarget)+'&er_vmmigstatus='+encodeURIComponent(selectedStatus)+'&er_vmmigtype='+encodeURIComponent(selectedMigrationType)+'&er_summary='+encodeURIComponent(summary); 

			if(report_type!=null && (report_type=='Yes' || report_type=='Top'))
			{
				var showDetails = appConstants.publicJsonData.pageParams['showDetails'];
				if (isSettingsEnabled)
				{
					showDetails = settingsForm.findField('showDetailsCombo').getValue();
				}
				paramsForChange = paramsForChange+'&er_show_details='+showDetails;
			}
			else
			{
				var sortBy = appConstants.publicJsonData.pageParams['showDetails'];
				var recordsPerPage = appConstants.publicJsonData['pageParams']['er_recperpage'];
				var pageWidth = appConstants.publicJsonData['pageParams']['pageWidthProces'];
				if (isSettingsEnabled)
				{
					sortBy = settingsForm.findField('sortByCombo').getValue();
					recordsPerPage = settingsForm.findField('recordsPerPageCombo').getValue();
				}
				paramsForChange = paramsForChange+'&er_recperpage='+recordsPerPage+'&er_sortby='+sortBy+'&pageWidthProces='+pageWidth;
			}
		}
		var priority = appConstants.publicJsonData.pageParams['priority']
		if (isSettingsEnabled)
		{
			priority = settingsForm.findField('priorityCombo').getValue();
		}
		paramsForChange = paramsForChange+'&er_priority='+priority;

		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		for( var hid in hiddenData)
		{
			if(hid!=null && (hid=='reqVcVm' || hid=='reqVcUser'))
			{
				hiddenQstr +='&'+hid+'='+appConstants.erUtils.specialCharEncode(hiddenData[hid]);
			}
			else
			{ 
				hiddenQstr +='&'+hid+'='+encodeURIComponent(hiddenData[hid]);
			}
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			paramsForChange = paramsForChange+hiddenQstr;
		}

		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
				reportName=checkFileName(reportName);
			paramsForChange = paramsForChange+'&forwardto=ErVcVMotionReportJson&bg_reportname='+encodeURIComponent(reportName);
			appConstants.urlForSubmit = '../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true';
		}
		else
		{
			paramsForChange = paramsForChange+'&forwardto=ErVcVMotionReport';
			appConstants.urlForSubmit = "../servlet/com.eg.ErVcVMotionC?isSubmit=true";
		} 
			

		appConstants.queryString = paramsForChange;
		var hiddenFields = appConstants.publicJsonData['hiddenParams'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		appConstants.queryString += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;

	},
	closeSettingAndSubmit:function()
	{
		if(this.validateSettings())
		{
			this.beforeReportSubmit();
		}
	},
	validateSettings :  function()
	{
		var settingsForm = this.getVmotionsettings().getForm();
		var reportgen = settingsForm.findField('reportGeneration').getValue();
		var timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
		var timePeriodFromMins = settingsForm.findField('minfrom').getValue();
		var timePeriodToHrs = settingsForm.findField('timeto').getValue();
		var timePeriodToMins = settingsForm.findField('minto').getValue();
		if(!checkTimePeriod(timePeriodFromHrs,timePeriodFromMins,timePeriodToHrs,timePeriodToMins))
		{
			return false;
		}
		if ( reportgen!=null && reportgen == 'background' )
		{
				var reportNameObj = settingsForm.findField('bgReportName');
				var reportName = reportNameObj.getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					reportNameObj.focus();
					return false;
				}
		}
	//	}
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	showResult : function(btn)
	{
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
			var fromSchedule =  appConstants.publicJsonData['hiddenParams']['fromSchedule'];
			if(fromSchedule!=null && fromSchedule=="Yes")
			{
				this.addTo(Ext.getCmp('scheduleImg'),null,null);
			}
			else
			{
				this.submitReport();
			}
//			this.formSubmit(getButtonObj);
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var settingsForm = this.getVmotionsettings().getForm();
			settingsForm.findField('reportGeneration').setValue('background');
			var reportNameObj = settingsForm.findField('bgReportName');
			reportNameObj.show();
			reportNameObj.focus();
			validateTextBoxWithSpecialChars(reportNameObj.getValue(),'Attachment',true);
			return falsGe;
		}
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	groupOptionChange : function(combo)
	{
		if(!isSettingsEnabled)
		{
			this.showConfigDropdown();
		}
		/*if (!isSettingsEnabled)
		{
				this.getReporterSettings().down('button').fireHandler();
		}*/ 
		var mainForm = this.getVmotionmainform().getForm();
		var meSettingsForm = this.getVmotionsettings().getForm();

		var comboId = combo.getId();
		Ext.getCmp('vMotionDataPanel').hide();
		this.disableTools();
		this.updateQueryString(null);
//		console.log(queryString);
		Ext.Ajax.request({
				url : '/final/reporter/ErVcVMotionReportJson.jsp',
				params: appConstants.queryString+"&vMotionAction=loadFormControls",
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicJsonData = jsonData;
					var selectedGroup = jsonData['pageParams']['selectedGroup'];

					if(comboId!=null && (comboId=='analysisBy' || comboId=='report_type'))
					{
						if(selectedGroup!=null && selectedGroup=='Zone')
						{
							var zoneCombo =mainForm.findField('infraType');
							zoneCombo.getStore().removeAll();
							zoneCombo.getStore().clearFilter(true); 
							zoneCombo.getStore().loadRawData(jsonData['grpOpts']);
							zoneCombo.setValue(jsonData['pageParams']['select_groupName']);
							zoneCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['selectedGrpLbl']);
							zoneCombo.show();

							var subzoneCombo =mainForm.findField('subzone');
							subzoneCombo.getStore().loadRawData(jsonData['yesNoOpts']);
							subzoneCombo.setValue(jsonData['pageParams']['subZone']);
							subzoneCombo.setFieldLabel(jsonData['screenLabels']['reporter.thin.Include subzone']);
							subzoneCombo.show();
						}
						else if(selectedGroup!=null && selectedGroup=='Segment')
						{
							var segmentCombo =mainForm.findField('infraType');
							segmentCombo.getStore().removeAll();
							segmentCombo.getStore().clearFilter(true);
							segmentCombo.getStore().loadRawData(jsonData['grpOpts']);
							segmentCombo.setValue(jsonData['pageParams']['select_groupName']);
							segmentCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['selectedGrpLbl']);
							segmentCombo.show();
						}
						else if(selectedGroup!=null && selectedGroup=='Service')
						{
							var serviceCombo =mainForm.findField('infraType');
							serviceCombo.getStore().removeAll();
							serviceCombo.getStore().clearFilter(true);
							serviceCombo.getStore().loadRawData(jsonData['grpOpts']);
							serviceCombo.setValue(jsonData['pageParams']['select_groupName']);
							serviceCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['selectedGrpLbl']);
							serviceCombo.show();
						}
						else
						{
							mainForm.findField('infraType').hide();
							mainForm.findField('subzone').hide();
						}

						if(comboId=='report_type')
						{
							var er_type = appConstants.publicJsonData['pageParams']['er_type'];
							if(er_type!=null && er_type!="No")
							{
								var showDetailsCombo = meSettingsForm.findField('showDetailsCombo');
								showDetailsCombo.getStore().loadRawData(appConstants.publicJsonData['yesNoOpts']);
								if(comboId=='report_type' && combo.getValue()=='Top')
								{
									showDetailsCombo.setValue('Yes');
								}
								else
								{
									showDetailsCombo.setValue(appConstants.publicJsonData.pageParams['showDetails']);
								}
								showDetailsCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Show Details']);
								showDetailsCombo.show();

								var summaryCombo = meSettingsForm.findField('summaryCombo');
								summaryCombo.getStore().loadRawData(appConstants.publicJsonData['summaryOpts']);
								summaryCombo.setValue(appConstants.publicJsonData.pageParams.er_summary);
								summaryCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.vmotion.Summary']);
								summaryCombo.show();

								var priorityCombo = meSettingsForm.findField('priorityCombo');
								priorityCombo.getStore().loadRawData(appConstants.publicJsonData['priorityOpts']);
								priorityCombo.setValue(appConstants.publicJsonData.pageParams['priority']);
								priorityCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.comparison.Show']);

								meSettingsForm.findField('sortByCombo').hide();
								meSettingsForm.findField('recordsPerPageCombo').hide();
							}
							else
							{
								meSettingsForm.findField('summaryCombo').hide();
								meSettingsForm.findField('showDetailsCombo').hide();
								meSettingsForm.findField('recordsPerPageCombo').setValue(appConstants.publicJsonData['pageParams']['er_recperpage']);
								meSettingsForm.findField('recordsPerPageCombo').show();


								var sortByCombo = meSettingsForm.findField('sortByCombo');
								sortByCombo.getStore().loadRawData(appConstants.publicJsonData['sortArr']);
								sortByCombo.setValue(appConstants.publicJsonData.pageParams['sortby']);
								sortByCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.comparison.Sort by']);
								sortByCombo.show();
							}
						}
					}


					var VMware = Ext.getCmp('VMware');
					VMware.getStore().loadRawData(jsonData['compOpts']);
					appConstants.rawDataForComponents = jsonData['compOpts'];
					VMware.setValue(jsonData['pageParams']['selectedGrpValue']);
					this.callPopulate();
				}
		});
	},
	hideTools : function() {
		this.getNewUtilities().loadIcon(true, // save
				true, // print
				true, // mail
				false, // data
				true, // cvs
				true, // fav
				true,// schedule
				false, // daignosis
				false, // togglebutton
				false, // close
				true // booklet
				);

		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		/*Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true); */
		//Ext.getCmp("upbutton").setDisabled(true);
		//Ext.getCmp("upbutton").hide();

	},
	afterSettingsrender:function() {
				Ext.getCmp('moreOptionCloseId').show();
				var hiddenFields = appConstants.publicJsonData['hiddenParams'];
				var favorite_id = hiddenFields["favorite_id"];
				if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

		this.getVmotionsettings().loadSettingsData();
		this.callPopulate();

		/*if(appConstants.showFilters)
		{
			var settingsForm = this.getVmotionsettings().getForm();
			var reqVcUser = appConstants.publicJsonData['hiddenParams'] ['reqVcUser'];
			var reqVcVm = appConstants.publicJsonData['hiddenParams'] ['reqVcVm'];
				console.log('reqVcVm __________ ',reqVcVm)
			var reqVcVmSource = appConstants.publicJsonData['hiddenParams'] ['reqVcVmSource'];
			var reqVcVmDestination = appConstants.publicJsonData['hiddenParams'] ['reqVcVmDestination'];
			var reqvmclusersource = appConstants.publicJsonData['hiddenParams'] ['reqvmclusersource'];
			var reqcluserdestination = appConstants.publicJsonData['hiddenParams'] ['reqcluserdestination'];
			var reqVmMigStatus = appConstants.publicJsonData['hiddenParams'] ['reqVmMigStatus'];
			var reqVmMigType = appConstants.publicJsonData['hiddenParams'] ['reqVmMigType'];

			if(reqVcVm!=null && (reqVcVm!="null" && reqVcVm!=""))
			{
				settingsForm.findField('vmCombo').setValue(reqVcVm);
			}

			if(reqVcUser!=null && (reqVcUser!="null" && reqVcUser!=""))
			{
				settingsForm.findField('vmUserCombo').setValue(reqVcUser);
			}

			if(reqVcVmSource!=null && (reqVcVmSource!="null" && reqVcVmSource!=""))
			{
				settingsForm.findField('esxSrcCombo').setValue(reqVcUser);
			}

			if(reqVcVmDestination!=null && (reqVcVmDestination!="null" && reqVcVmDestination!=""))
			{
				settingsForm.findField('esxTrgtCombo').setValue(reqVcVmDestination);
			}

			if(reqvmclusersource!=null && (reqvmclusersource!="null" && reqvmclusersource!=""))
			{
				settingsForm.findField('clusterSrcCombo').setValue(reqvmclusersource);
			}

			if(reqcluserdestination!=null && (reqcluserdestination!="null" && reqcluserdestination!=""))
			{
				settingsForm.findField('clusterTrgtCombo').setValue(reqcluserdestination);
			}

			if(reqVmMigStatus!=null && (reqVmMigStatus!="null" && reqVmMigStatus!=""))
			{
				settingsForm.findField('statusCombo').setValue(reqVmMigStatus);
			}

			if(reqVmMigType!=null && (reqVmMigType!="null" && reqVmMigType!=""))
			{
				settingsForm.findField('migrationTypeCombo').setValue(reqVmMigType);
			}
		}*/
	},
	loadDefaults:function(){
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);

		this.getVmotionmainform().loadData();
		this.callPopulate();
		var hiddenFields = appConstants.publicJsonData['hiddenParams'];
	    var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		//prakash for back button
		if(!hidebackButton)
		{
			Ext.getCmp('mainform').add({
				xtype:'hidden',
				name : 'ID',
				id   : 'ID',
				value:appConstants.publicJsonData['ID']
			});
		}
		//

		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true')
		{
			var er_reportgenration1 = appConstants.publicJsonData['pageParams']['er_reportgenration'];
			if(er_reportgenration1!=null && er_reportgenration1!="background")
			{
				this.loadVMotionReportData(appConstants.publicJsonData);
			}
		}
		else
		{
			 if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.beforeReportSubmit();
			}
		}
	},
		 sleep:function(delay) {
        var start = new Date().getTime();
        while (new Date().getTime() < start + delay);
	}
});