Ext.define('VMotion.view.VMotionMainForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.vmotionmainform',
	id : 'vmotionmainForm',
	layout: 'column',
	defaults: {
                labelSeparator: '',
               margin:'0 20 10 0',
                labelAlign: 'top',
                cls: 'dropdown'
            },
    items: [
		{
			xtype: 'scrollcombo',
			width: 220,
			id : 'report_type',
			name : 'report_type',
			fieldLabel: 'Report Type',
			editable: false,
			store: Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		}, 
		{
			xtype: 'scrollcombo',
			width: 130,
			fieldLabel: 'Analyze by',
			id : 'analysisBy',
			name : 'analysisBy',
			editable: false,
			store: Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		}, 
		{
			xtype: 'scrollcombo',
			width: 220,
			cls: 'dropdown',
			 fieldLabel: '',
			id: 'infraType',
			name: 'infraType',
			editable: true,
			listConfig:{
							emptyText:noMatch
						},
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			hidden: true
		}, 
		{
			xtype: 'scrollcombo',
			width: 110,
			cls: 'dropdown',
			labelStyle: 'white-space: nowrap',
			fieldLabel: 'Include Subzones',
			id: 'subzone',
			name: 'subzone',
			value: 'Yes',
			defaultListConfig: {
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: [{
						displayField: 'Yes',
						valueField: 'Yes'
					}, {
						displayField: 'No',
						valueField: 'No'
					}
				]
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
		   hidden: true
		},
		{xtype:'timeline',margin:0},
		{
			xtype:'button',
			text:'Go',
			id : 'goBtn',
			name : 'goBtn',
			action:'getData',
			ui:'newButtonSmall',
			margin:'20 0 0 0',
			hidden:true
		}
	],
	loadData : function()
	{
		var mainForm = this.getForm();

		var report_type = mainForm.findField('report_type');
		report_type.getStore().loadRawData(appConstants.publicJsonData['reportOpts']);
		report_type.setValue(appConstants.publicJsonData['pageParams']['er_type']);
		report_type.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Report Type']);

        var from_schedule = appConstants.publicJsonData['hiddenParams']['fromScheduleModify'];
        if (from_schedule != null && from_schedule == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}

		var analysisBy = mainForm.findField('analysisBy');
		var selectedGroup = appConstants.publicJsonData['pageParams']['selectedGroup'];
		analysisBy.getStore().loadRawData(appConstants.publicJsonData['analysisOpts']);
		analysisBy.setValue(selectedGroup);
		analysisBy.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.common.Analysis By']);

		if(selectedGroup!=null && selectedGroup=='Zone')
		{
			var zoneCombo =mainForm.findField('infraType');
			zoneCombo.getStore().loadRawData(appConstants.publicJsonData['grpOpts']);
			zoneCombo.setValue(appConstants.publicJsonData['pageParams']['select_groupName']);
			zoneCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['selectedGrpLbl']);
			zoneCombo.show();

			var subzoneCombo =mainForm.findField('subzone');
			subzoneCombo.getStore().loadRawData(appConstants.publicJsonData['yesNoOpts']);
			subzoneCombo.setValue(appConstants.publicJsonData['pageParams']['subZone']);
			subzoneCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['reporter.thin.Include subzone']);
			subzoneCombo.show();

		}
		else if(selectedGroup!=null && selectedGroup=='Segment')
		{
			var segmentCombo =mainForm.findField('infraType');
			segmentCombo.getStore().loadRawData(appConstants.publicJsonData['grpOpts']);
			segmentCombo.setValue(appConstants.publicJsonData['pageParams']['select_groupName']);
			segmentCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['selectedGrpLbl']);
			segmentCombo.show();
		}
		else if(selectedGroup!=null && selectedGroup=='Service')
		{
			var serviceCombo =mainForm.findField('infraType');
			serviceCombo.getStore().loadRawData(appConstants.publicJsonData['grpOpts']);
			serviceCombo.setValue(appConstants.publicJsonData['pageParams']['select_groupName']);
			serviceCombo.setFieldLabel(appConstants.publicJsonData['screenLabels']['selectedGrpLbl']);
			serviceCombo.show();
		}

		appConstants.showFilters = appConstants.publicJsonData['pageParams']['showFilters'];

		var VMware = Ext.getCmp('VMware');
		VMware.getStore().loadRawData(appConstants.publicJsonData['compOpts']);
		appConstants.rawDataForComponents = appConstants.publicJsonData['compOpts'];
		VMware.setValue(appConstants.publicJsonData['pageParams']['selectedGrpValue']);

		var VMwareLabel = Ext.getCmp('VMwareLabel');
		VMwareLabel.setText(appConstants.publicJsonData['screenLabels']['reporter.comparison.VMware vCenter']);



		var hrsLbl=appConstants.publicJsonData.screenLabels['reporter.common.Hrs'];
		var fromLbl=appConstants.publicJsonData.screenLabels['reporter.common.From'];
		var toLbl=appConstants.publicJsonData.screenLabels['reporter.common.To'];
		var timelineLbl=appConstants.publicJsonData.screenLabels['reporter.common.Timeline'];

		var timelineJSONArray = appConstants.publicJsonData['timelineComboArray'];
		var timeLineComboObj = mainForm.findField('er_timeline');
		timeLineComboObj.getStore().loadRawData(timelineJSONArray);
		timeLineComboObj.setValue(appConstants.publicJsonData.pageParams.selectedTimeline);
		var timeLine = appConstants.publicJsonData.pageParams.selectedTimeline;
		
		var startdateObj = mainForm.findField('er_stdate');
		var enddateObj = mainForm.findField('er_enddate');
		var startHourObj = mainForm.findField('er_sthr');
		var endHourObj = mainForm.findField('er_endhr');

		if(timeLine=='Any')
		{
			startdateObj.setDisabled(false);
			enddateObj.setDisabled(false);
			startHourObj.setDisabled(false);
			endHourObj.setDisabled(false);
		}

		var stDate = appConstants.publicJsonData.pageParams['startDateJSON'];
		var endDate = appConstants.publicJsonData.pageParams['endDateJSON'];
		var startHr = appConstants.publicJsonData.pageParams['startHourJSON'];
		var endHr = appConstants.publicJsonData.pageParams['endHourJSON'];

	
		startdateObj.setValue(appConstants.publicJsonData.pageParams['startDateForDisplay']);
		startdateObj.dataArray = stDate;
		enddateObj.setValue(appConstants.publicJsonData.pageParams['endDateForDisplay']);
		enddateObj.dataArray = endDate;
		startHourObj.setValue(appConstants.publicJsonData.pageParams['startHourForDisplay']);
		startHourObj.dataArray = startHr;
		endHourObj.setValue(appConstants.publicJsonData.pageParams['endHourForDisplay']);
		endHourObj.dataArray = endHr;

		stmin =appConstants.publicJsonData.pageParams['startMinForDisplay'];
		enmin =appConstants.publicJsonData.pageParams['endMinForDisplay'];
		mgr_stmin = appConstants.publicJsonData.pageParams['startmin'];
		mgr_enmin = appConstants.publicJsonData.pageParams['endmin'];

		updatingAppSettings();
		mainForm.findField('er_mode').hide();


	}

});