Ext.define('vmcapacityandcpu.controller.Main',{
extend:'Ext.app.Controller',
views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'resultpanel', ref: 'resultpanel'},
		{selector:'virtualizationcapacityplanningform', ref:'virtualizationcapacityplanningform'},
		{selector: 'virtualizationcapacityplanningsettings', ref: 'virtualizationcapacityplanningsettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'},
		{selector: 'ReporterSettings',ref: 'ReporterSettings'},
	],
	init:function(){
		this.control({
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities':
			{
				'afterrender':this.loadTools
			},
			'virtualizationcapacityplanningsettings':
			{
				'afterrender':this.afterSettingsRender
			},
			'virtualizationcapacityplanningform':
			{
				'boxready': this.afterCapacityFormRender
			},
			'virtualizationcapacityplanningform combo[id="er_comptype"]':
			{
				'select': this.changeCompType
			},
			'virtualizationcapacityplanningform combo[id="er_option"]':
			{
				'select': this.changeAnalysBy
			},
			'virtualizationcapacityplanningform combo[id="er_site"]':
			{
				'select': this.changeBySite
			},
			'virtualizationcapacityplanningform combo[id="er_includezones"]':
			{
				'select': this.changeBySubZone
			},

			/*'virtualizationcapacityplanningsettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekEnd
			},*/
			'virtualizationcapacityplanningsettings combo[id="er_timeline"]':
			{
				//'select': this.changeTimeline
			},
			'virtualizationcapacityplanningsettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'mainform button[id="submit"]':
			{
				'click': this.formSubmit
			},
			'mainform button[name="save"]':
			{
				'click': this.goTo
			},
			'timeline combo[name="er_mode"]':
			 {
				'select': this.changeEr_mode
			 },
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #dataTool > button':
			{
				'click': this.callData
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.callData
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'egcomponent button[id="expandSelector"]': {
                'click': this.expandMe
            }
		});
	},

	goTo: function (btn) {
if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Virtualization Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites();
		}else{
			this.showSchedules();
		}
    },
	 changeEr_mode: function (combo) {
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var from_schModify = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if(Ext.get('configMod')!=null){
			Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		}
		this.formSubmit(Ext.getCmp('submit'));
     },
	callData: function()
	{
		document.location='/final/servlet/egurkha.reporter.SaveInCSVFormat';
	},
	showFavorites: function( obj )
	{
		if (true)
		{
			this.formSubmit( obj );
			var qString = appConstants.queryString;
			var hiddenFields =  appConstants.publicJSON["hiddens"];
			var favorite_id = hiddenFields["favorite_id"];
			var target = '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client&er_view=GRAPH'+"&er_RmDispName="+appConstants.er_RmDispName+'&com.eg.CSRF_NONCE='+csrfToken;//&FavoriteId='+favorite_id;
				if(target!=undefined&&target.indexOf('er_rtype')==-1)
					target += '&er_rtype=Virtual Machine';

			if (appConstants.formButtonId=='save')
			{
				if((favorite_id=="null" ||  favorite_id=="undefined" || favorite_id==undefined) && appConstants.favorite_id!="null")
					favorite_id=appConstants.favorite_id;

				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});

			}
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

		}
	},
	showSchedules: function( obj )
	{
		if ( this.checkValidate(false) )
		{
			this.formSubmit( obj );
			var qString = appConstants.queryString;
			var target = '/final/reporter/ErSaveSchedule.jsp?'+qString+'&er_rtype=Virtual Machine&com.eg.CSRF_NONCE='+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
 				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveMe: function()
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF('/final/reporter/ErHtmlToSavePdf.jsp?'+appConstants.publicJSON['PDF_URL']);
	},
	bookletQuery: function(obj)
	{
		return appConstants.publicJSON['PDF_URL'];
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString+'&er_rtype=Virtual Machine';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	printMe: function()
	{
		parent.printWindowFn( appConstants.publicJSON['PRINT_URL']+'&pdfPrint=yes'); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	changeReportGeneration: function( obj )
	{
		var settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var reportGenVal = settingsForm.findField('reportGeneration').getValue();
		var bgReportObj = settingsForm.findField('bgReportName');
		if ( reportGenVal == 'background' )
		{
			bgReportObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if ( reportGenVal == 'background-csv')
		{
			bgReportObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			bgReportObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeTimeline: function( obj )
	{
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var getTimelineVal = mainForm.findField('er_timeline').getValue();
		var stDateObj = mainForm.findField('er_stdate');
		var endDateObj = mainForm.findField('er_enddate');
		var stHrObj = mainForm.findField('er_sthr');
		var endHrObj = mainForm.findField('er_endhr');
		if ( getTimelineVal == 'Any' )
		{
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
		}
	},
	/*changeExcludeWeekEnd: function ( obj )
	{
	var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
	var weenendOn=Ext.getCmp("er_excwe").getValue();
	if(weenendOn =='Yes')
		Ext.getCmp('excludeDays').update(excludeMsgs);
	else
		Ext.getCmp('excludeDays').update('');
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},*/
	changeVcenter: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	changeCompType: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	changeAnalysBy: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	changeBySite: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	changeBySubZone: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	afterMainRender: function()
	{
		this.hideResult();
	},
	hideResult: function()
	{
		this.getResultpanel().hide();
		this.disableTools();
	},
	disableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		if ( Ext.getCmp('reportype').getValue() == 'No' )
		{
			Ext.getCmp("csvTool").setDisabled(false);
		}
		else
		{
			Ext.getCmp("csvTool").setDisabled(true);
		}
		//Ext.getCmp("upbutton").setDisabled(false);
	},
	getHiddenQstr: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}

			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	checkValidate: function(flag)
	{
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
        	var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var compVal = mainForm.findField('er_comptype').getValue();
		 var componentVal = Ext.getCmp('er_component').getValue();
		var msg = '';
		if ( compVal == '-1' )
		{
			msg = mainForm.findField('er_comptype').getRawValue();
		}
		else if ( componentVal == '-1' )
		{
			msg = appConstants.chooseComponent;
		}
		if ( !Ext.isEmpty( msg ) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		var hiddenJSON = appConstants.publicJSON['hiddens'];
		var er_usertimeline = hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = mainForm.findField('er_stdate').getValue();
		tmpStartDate.setHours(mainForm.findField('er_sthr').getValue());
		var tmpEndDate = mainForm.findField('er_enddate').getValue();
		tmpEndDate.setHours(mainForm.findField('er_endhr').getValue());

		var timeFrom =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timeTo =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minFrom =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var minTo =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');


		if ( !checkTimePeriod(timeFrom, minFrom, timeTo, minTo ) )
		{
			return false;
		}
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg = hiddenJSON['limitforbg'];
		var reportgenVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var isSettingsOk = true;
		if ( reportgenVal!=null && reportgenVal == 'foreground' )
		{
			if(flag)
			{
				if ( !Ext.isEmpty(limitforbg ) )
				{
					if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else
		{
			var reportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},
	formSubmit: function( obj )
	{
		appConstants.fromvCenter = false;
		appConstants.fromTimeline = false;
		appConstants.fromSubmit = false;


		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		//this.getResultpanel().hide();//ezhil
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
	        var starthr = mainForm.findField('er_sthr').getValue();
	        startdate.setHours(starthr);
	        var enddate = mainForm.findField('er_enddate').getValue();
	        var endhr = mainForm.findField('er_endhr').getValue();
	        enddate.setHours(endhr);
	        var result = checkDateTime(startdate, enddate);
		if (!result) {
            		return;
       		 }
		var me = this;

		var mainForm = this.getVirtualizationcapacityplanningform().getForm();


		var actionFrom = '';
		appConstants.fromFav = false;
		appConstants.fromSch = false;
		var frmCom=false;
	

		appConstants.er_comptype = false;
		appConstants.er_option = false;
		appConstants.er_site = false;
		appConstants.subZone= false;

		if ( !Ext.isEmpty( obj ) )
		{
			actionFrom = obj.getId();

			if ( actionFrom == 'reporttype' )
			{
				fromReportType = true;
			}

			else if ( actionFrom == 'er_comptype' )
			{
			frmCom=true;
			appConstants.er_comptype = true;
			}
			else if ( actionFrom == 'er_option' )
			{
			frmCom=true;
			appConstants.er_option = true;
			}
			else if ( actionFrom == 'er_site' )
			{
			frmCom=true;
			appConstants.er_site = true;
			}
			else if ( actionFrom == 'er_includezones' )
			{
			frmCom=true;
			appConstants.subZone = true;
			}

			else if ( actionFrom == 'er_timeline' )
			{
				appConstants.fromTimeline = true;
			}
			else if ( actionFrom == 'submit' ||  actionFrom == 'hideSubmit' )
			{
				appConstants.fromSubmit = true;
				if ( actionFrom == 'submit'){
					if ( !me.checkValidate(true) )
					{
						return;
					}
				}
			}
			else if ( actionFrom == 'favoriteTool' || actionFrom == 'favImg' )
			{
				//appConstants.fromFav = true;
			}
			else if ( actionFrom == 'scheduleImg' || actionFrom == 'scheduleTool' )
			{
				appConstants.fromSch = true;
			}
		}
		this.updateQueryString();

		if ( appConstants.fromFav )
		{
			appConstants.queryString += '&call=json';
			return;
		}
		else if ( appConstants.fromSch )
		{
			return;
		}


		if(frmCom)
		this.generateResult();
		if ( appConstants.fromSubmit )
		{
			appConstants.queryString += '&isSubmit=true';
			this.generateResult();
		}

	},
	generateResult : function()
	{
		
		this.updateQueryString();
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		
		if ( appConstants.fromSubmit )
		{
			appConstants.queryString += '&isSubmit=true';
		}
		var me = this;
		var qstr = appConstants.queryString;
       	var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');

		var reporTypeVal = mainForm.findField('reportype').getValue();
		var er_optionVal = mainForm.findField('er_option').getValue();
		var remoteURL = '';
		{
			if ( er_reportgenrationVal == 'foreground' )
			{
				if(appConstants.fromSubmit)
				{
					remoteURL = '/final/servlet/com.eg.ErVmCapacityAndCpuReportC';
				}
				else
				{
				remoteURL = '/final/reporter/ErVmCapacityAndCpuReportJson.jsp';
				}

				qstr += '&call=json';
			}
			else if(er_reportgenrationVal =='background-csv')
			{
				remoteURL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				qstr += '&call=json&isSubmit=true&forwardto=ErVmCapacityAndCpuReportJson';
			}
			else
			{
				remoteURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				qstr += '&call=json&isSubmit=true&forwardto=ErVmCapacityAndCpuReportJson';
			}
		}
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		initLdgMask.show();
		Ext.Ajax.request({
			url: remoteURL,
			params: qstr,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					appConstants.publicJSON = Ext.decode(jsonText);
					var selectedData = appConstants.publicJSON['selectedValues'];
					appConstants.rawDataForComponents = appConstants.publicJSON['componentCombo'];
						if ( appConstants.er_comptype )
					{
						var componentCombo = appConstants.publicJSON['componentCombo'];
						//var compSelected = selectedData['er_component'];
						var er_componentSelected = appConstants.publicJSON['selectedComponentArr'];
						if ( !Ext.isEmpty( componentCombo ) )
						{
							//me.setValueWithOptionInList(mainForm, 'er_component', componentCombo, compSelected);

									var  comboObject = Ext.getCmp('er_component');
									comboObject.getStore().loadRawData(componentCombo);
									if (!Ext.isEmpty(er_componentSelected)) {
											comboObject.setValue(er_componentSelected);
									} else {
											comboObject.setValue(componentCombo[0].valueField);
									}
						}
						else
						{

							//me.insertNotApplicable(mainForm, 'er_component');
							var  obj = Ext.getCmp('er_component');
								obj.getStore().removeAll();
								obj.getStore().add({
										'displayField': appConstants.notApplicable,
										'valueField': '-1'
									});
								obj.setValue('-1');
						}
							initLdgMask.hide();
					}

					else if ( appConstants.er_option )
					{
						var screenLabels = appConstants.publicJSON['screenLabels'];
					if(er_optionVal!=undefined && er_optionVal!='Component')
						{

							var comboObject = Ext.getCmp('er_site');
							comboObject.setFieldLabel(screenLabels['reporter.common.' + er_optionVal]);

						var siteCombo = appConstants.publicJSON['siteCombo'];
						var er_siteSelected = selectedData['er_site'];
						if ( !Ext.isEmpty( siteCombo ) )
						{
							me.setValueWithOptionInList(mainForm, 'er_site', siteCombo, er_siteSelected);
						}
						else
						{
							me.insertNotApplicable(mainForm, 'er_site');
						}
						//
							me.insertNotApplicable(mainForm, 'er_comptype');
							var  obj = Ext.getCmp('er_component');
								obj.getStore().removeAll();
								obj.getStore().add({
										'displayField': appConstants.notApplicable,
										'valueField': '-1'
									});
								obj.setValue('-1');
						//
						Ext.getCmp('er_site').show();
						initLdgMask.hide();
						}
						else
						{
							Ext.getCmp('er_site').hide();

													var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
						var er_comptypeSelected = selectedData['er_comptype'];
						if ( !Ext.isEmpty( compTypeCombo ) )
						{
							me.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
						}
						else
						{
							me.insertNotApplicable(mainForm, 'er_comptype');
						}
//
						var componentCombo = appConstants.publicJSON['componentCombo'];
						//var compSelected = selectedData['er_component'];
						var er_componentSelected = appConstants.publicJSON['selectedComponentArr'];
						if ( !Ext.isEmpty( componentCombo ) )
						{
							//me.setValueWithOptionInList(mainForm, 'er_component', componentCombo, compSelected);

								var  comboObject = Ext.getCmp('er_component');
								comboObject.getStore().loadRawData(componentCombo);
								if (!Ext.isEmpty(er_componentSelected)) {
									comboObject.setValue(er_componentSelected);
								} else {
									comboObject.setValue(componentCombo[0].valueField);
								}

						}
						else
						{
						//	me.insertNotApplicable(mainForm, 'er_component');
								var  obj = Ext.getCmp('er_component');
								obj.getStore().removeAll();
								obj.getStore().add({
										'displayField': appConstants.notApplicable,
										'valueField': '-1'
									});
								obj.setValue('-1');
						}

								initLdgMask.hide();
						}

						//
		if(er_optionVal!=undefined && er_optionVal=='Zone')
		{

		var subzoneCombo = appConstants.publicJSON['subzoneCombo'];


		var er_includeZones = appConstants.publicJSON['er_includeZones'];
		if ( !Ext.isEmpty( subzoneCombo ) )
		{
			me.setValueWithOptionInList(mainForm, 'er_includezones',subzoneCombo, er_includeZones);
		}
		Ext.getCmp('er_includezones').show();
		}
		else
		{
		Ext.getCmp('er_includezones').hide();
		}

						//
					}
							else if ( appConstants.er_site ||appConstants.subZone)
					{
						var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
						var er_comptypeSelected = selectedData['er_comptype'];
						if ( !Ext.isEmpty( compTypeCombo ) )
						{
							me.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
						}
						else
						{
							me.insertNotApplicable(mainForm, 'er_comptype');
						}
//
						var componentCombo = appConstants.publicJSON['componentCombo'];
						//var compSelected = selectedData['er_component'];
						var er_componentSelected = appConstants.publicJSON['selectedComponentArr'];
						if ( !Ext.isEmpty( componentCombo ) )
						{
							//me.setValueWithOptionInList(mainForm, 'er_component', componentCombo, compSelected);
								var  comboObject = Ext.getCmp('er_component');
								comboObject.getStore().loadRawData(componentCombo);
								if (!Ext.isEmpty(er_componentSelected)) {
									comboObject.setValue(er_componentSelected);
								} else {
									comboObject.setValue(componentCombo[0].valueField);
								}

						}
						else
						{
							//me.insertNotApplicable(mainForm, 'er_component');
								var  obj = Ext.getCmp('er_component');
								obj.getStore().removeAll();
								obj.getStore().add({
										'displayField': appConstants.notApplicable,
										'valueField': '-1'
									});
								obj.setValue('-1');
						}
//

							initLdgMask.hide();

					}

					else if ( appConstants.fromTimeline )
					{
						var startDate = selectedData['startDate'];
						var endDate = selectedData['endDate'];
						var startHour = selectedData['startHour'];
						var endHour = selectedData['endHour'];
						mainForm.findField('er_stdate').setValue(startDate);
						mainForm.findField('er_enddate').setValue(endDate);
						mainForm.findField('er_sthr').setValue(startHour);
						mainForm.findField('er_endhr').setValue(endHour);
					}
					else if ( appConstants.fromSubmit )
					{
						me.getResultpanel().removeAll();
						me.getResultpanel().show();
						var resultData = appConstants.publicJSON['RESULTS'];
						if ( er_reportgenrationVal == 'foreground')
						{
							if ( !Ext.isEmpty( resultData ) )
							{
								me.getResultpanel().setTitle(resultData['TITLE']);
								me.loadData(resultData);
 							}
							else
							{
 								me.getNomeasurepanel().show();
								me.getResultpanel().hide();
							}
						}
						else
						{
							resultData = appConstants.publicJSON['backgroundResults'];
							me.loadBackground(resultData);
						}
						initLdgMask.hide();
						//Ext.getCmp('virtualizationcapacityplanningform').show();
					}
				}
			}
		});

	},
		updateQueryString: function()
	{
		var qstr = '';
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();

		var reporTypeVal = mainForm.findField('reportype').getValue();
		var compArray = Ext.getCmp('er_component').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_option = mainForm.findField('er_option').getValue();
		var er_siteVal = mainForm.findField('er_site').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var startdateVal = mainForm.findField('er_stdate').dataArray;
		var enddateVal = mainForm.findField('er_enddate').dataArray;
		var starthrVal = mainForm.findField('er_sthr').dataArray;
		var er_endhrVal = mainForm.findField('er_endhr').dataArray;
		var er_modeVal = mainForm.findField('er_mode').getValue();
		var er_optionVal = mainForm.findField('er_option').getValue();
		var er_includezones = mainForm.findField('er_includezones').getValue();
		var er_excweVal = this.getSettingsFieldValue(settingsForm,'er_excwe',isSettingsEnabled,'excludeWeekSelected');
		var timefromVal =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timetoVal =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minfromVal =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var mintoVal =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');
		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var bgReportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
		var er_resourceLimit = this.getSettingsFieldValue(settingsForm,'er_resourceLimit',isSettingsEnabled,'selectedresourceLimit');
		if(isSettingsEnabled && er_resourceLimit)
		{
			er_resourceLimit = 'yes';
		}
		else if (isSettingsEnabled)
		{
			er_resourceLimit = 'no';
		}
		bgReportName=checkFileName(bgReportName);
		qstr +=  this.getHiddenQstr();

		qstr +=  '&er_type='+encodeURIComponent(reporTypeVal)
				+'&er_timeline='+encodeURIComponent(er_timelineVal)
				+'&startdate='+encodeURIComponent(startdateVal)+'&enddate='+encodeURIComponent(enddateVal)
				+'&starthr='+encodeURIComponent(starthrVal)+'&endhr='+encodeURIComponent(er_endhrVal)
				+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin
				+'&timefrom='+encodeURIComponent(timefromVal)+'&timeto='+encodeURIComponent(timetoVal)
				+'&minfrom='+encodeURIComponent(minfromVal)+'&minto='+encodeURIComponent(mintoVal)
				+'&er_mode='+encodeURIComponent(er_modeVal)+'&er_excwe='+encodeURIComponent(er_excweVal)
				+'&er_reportgenration='+encodeURIComponent(er_reportgenrationVal)+'&bg_reportname='+encodeURIComponent(bgReportName)

if ( !appConstants.er_site && !appConstants.subZone )
		{
				for (var k = 0; compArray.length > k; k++) {
                qstr += "&er_component=" +encodeURIComponent(compArray[k]);
					}

				qstr +='&er_comptype='+encodeURIComponent(er_comptype);
		}
				qstr +='&er_option='+encodeURIComponent(er_option);
				qstr +='&er_site='+encodeURIComponent(er_siteVal);

				if(er_optionVal!=undefined && er_optionVal=='Zone')
				{

				qstr +='&er_includezones='+encodeURIComponent(er_includezones);
				}
//

		qstr+="&er_RmDispName="+appConstants.er_RmDispName;
		qstr+="&er_resourceLimit="+er_resourceLimit;

		appConstants.queryString = qstr;
		if(qstr!=undefined&&qstr.indexOf('er_rtype')==-1)
		{
			appConstants.queryString += '&er_rtype=Virtual Machine';
		}
	},
	loadBackground: function( resultData )
	{
		var me = this;
		me.getResultpanel().hide();
		var backgroundResultsData = resultData;
		if ( !Ext.isEmpty( backgroundResultsData ) )
		{
			var resultObj = this.getBackGroundPanel();
			resultObj.removeAll();
			var backgroundResultStatus = backgroundResultsData['status'];
			var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
			var backgroundResultURL = backgroundResultsData['backgroundResponseURLLink'];
			var backgroundResultURLLinkText = backgroundResultsData['backgroundResponseURLText'];
			var htmlStr = '';
			if ( backgroundResultStatus == 'success' )
			{
				//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" style="text-decoration:underline" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			else if ( backgroundResultStatus == 'duplicate' )
			{
				//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+backgroundResponseText+'</b><br /><a class="backgroundMsgLink" style="text-decoration:underline" href="'+backgroundResultURL+'">'+backgroundResultURLLinkText+'</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+ backgroundResultURLLinkText + '</a></div></td></tr></table></td></tr></table>';
			}
			/*resultObj.add({
				xtype: 'container',
				cls:'measuresErrorPanelBg',
				margin:0,
				bodyPadding:0,
				width: '100%',
				html: htmlStr
			});*/
			resultObj.update(htmlStr)
			resultObj.show();
			resultObj.doLayout();
			this.disableTools();
		}
	},
	loadData: function( resultData )
	{
		var resultObj = this.getResultpanel();
		var tableHeading = resultData['TABLE_HEADINGS'];
		var dataResults = resultData['DATA_RESULTS'];
		var splitterHtml = '<hr style="border-bottom:1px solid #ccc"/>';
		var er_resourceLimit = resultData['resourceLimit'];
		if(er_resourceLimit==null || er_resourceLimit=='null')
		{
			er_resourceLimit = 'yes'
		}
		if ( !Ext.isEmpty(dataResults) )
		{
			this.enableTools();
			if ( !Ext.isEmpty(resultObj.getHeader() ) )
			{
				resultObj.getHeader().show();
			}
			for ( var i = 0; i < dataResults.length; i++ )
			{
				if ( i == dataResults.length - 1 || dataResults.length == 1 )
				{
					splitterHtml = '';
				}
				var dataResult = dataResults[i];
				var title = dataResult['TITLE'];
				var dataRes = dataResult['DATA_RESULTS'];
				var tableTitle = dataResult['TABLE_TITLE'];
				var msgs = dataResult['MESSAGES'];
				var tableResults = dataResult['TABLE_RESULTS'];
				var summaryResults = dataResult['SUMMARY_RESULTS'];


				var summaryTable='<div class="vmCapacityPlanningSummaryTable" style="margin:0px 10px 3px 0px">'
					+'<table width="100%" height="100%"><tr><td width="33%"><div class="font_normal13" style="padding:3px 10px 12px 10px">'+summaryResults.c1+'</div><div class="font_bold20" style="padding:10px 10px 2px 10px">'+summaryResults.total_vm_powered_on+'</div></td>'
					+'<td width="33%" class="highlight"><div class="font_normal13" style="padding:3px 10px 12px 10px">'+summaryResults.c2+'</div><div class="font_bold20" style="padding:10px 10px 2px 10px">'+summaryResults.additional_vm_posssible+'</div></td>'
					+'<td width="33%"><div class="font_normal13" style="padding:3px 10px 12px 10px">'+summaryResults.c3+'</div><div class="font_bold20" style="padding:10px 10px 2px 10px">'+summaryResults.capacity_limited_by+'</div></td></tr> </table>'
					+'</div><div style="float:left;padding:4px 0px 2px 0px;text-align:left">'+summaryResults.summary_sentance+'</div>'

				//
					var htmlseq = '<div >'
								+'<table width="100%"cellspacing="0" cellpadding="0" border="0" class="vmCapacityPlanningSummaryDataTable">'
								+'<thead>'
								+'<tr>';
						for(var c=0;c<tableHeading.length;c++)
						{
							if(c==0)
								htmlseq+='<th colspan="2" style="text-align:left" rowspan="2">'+'<div>'+tableHeading[c]+'</div>'+'</th>';
							else if(c!=7 && c!=8 && c!=9)
								htmlseq+='<th rowspan="2">'+'<div>'+tableHeading[c]+'</div>'+'</th>';
							else if(c!=8 && c!=9)
							{
								var str=summaryResults.c2;
								htmlseq+='<th colspan="3" style="padding:16px 10px 4px 10px">'+'<div >'+str+'</div>'+'</th>';
							}
						}
						htmlseq+='</tr>'+'<tr>';
						if(er_resourceLimit=='yes')
						{
							for(var c=0;c<tableHeading.length;c++)
							{
								if(c==7 || c==8 ||c==9)
									htmlseq+='<th style="padding:5px 10px 3px 10px !important" class="subHead">'+'<div>'+tableHeading[c]+'</div>'+'</th>';
							}
						}

						htmlseq+='</tr>'+'</thead>'+'<tbody>' ;
						var  cnt=0;
						var found=false;
							for(var ctr =0;ctr<tableResults.length;ctr++)
							{
								if(cnt==2)
								{
								if(!found)
									found=true;
								else if(found)
									found=false;

								cnt=0
								}
								cnt++;

								var reObj=tableResults[ctr];
								var bottleNeckColorMark=reObj.bottleNeckColorMark;

								if (found)
								{

									htmlseq+='<tr class="threeFour">';
								}
								else
								{
									htmlseq+='<tr class="oneTwo">';
								}


									for ( var key in reObj )
									{
									if(key=='bottleNeckColorMark')
										{
										continue;
										}

									else if(key=='COLUMN_0')
										{
												htmlseq += '<td style="text-align:left" rowspan="2"  height="100%" >'
												+'<div >'+reObj[key]+'</div>'
												+'</td>';
										}


									else if(key=='COLUMN_9')
										{
											if(bottleNeckColorMark!=undefined && key==bottleNeckColorMark)
											{
											htmlseq += '<td rowspan="2"   >'
												+'<div style="color:#fb9848" class="font_bold12">'+this.getDecimalAlignFormat(reObj[key])+'</div>'
												+'</td>';
											}
											else if(bottleNeckColorMark!=undefined && bottleNeckColorMark=='both')
											{
											htmlseq += '<td rowspan="2"   >'
												+'<div style="color:#fb9848" class="font_bold12">'+this.getDecimalAlignFormat(reObj[key])+'</div>'
												+'</td>';
											}
											else
											{
												htmlseq += '<td rowspan="2">'
												+'<div >'+this.getDecimalAlignFormat(reObj[key])+'</div>'
												+'</td>';
											}

										}
									else if(key=='COLUMN_8')
										{
											if(bottleNeckColorMark!=undefined && key==bottleNeckColorMark)
											{
											htmlseq += '<td rowspan="2" >'
												+'<div style="color:#fb9848" class="font_bold12">'+this.getDecimalAlignFormat(reObj[key])+'</div>'
												+'</td>';
											}
											else if(bottleNeckColorMark!=undefined && bottleNeckColorMark=='both')
											{
											htmlseq += '<td rowspan="2" >'
												+'<div style="color:#fb9848" class="font_bold12">'+reObj[key]+'</div>'
												+'</td>';
											}
											else
											{
												htmlseq += '<td rowspan="2">'
												+'<div >'+this.getDecimalAlignFormat(reObj[key])+'</div>'
												+'</td>';
											}
										}
										else if(key=='COLUMN_10')
										{
										htmlseq += '<td rowspan="2" >'
												+'<div >'+reObj[key]+'</div>'
												+'</td>';
										}
										else
										{
											htmlseq += '<td >'
												+'<div >'+this.getDecimalAlignFormat(reObj[key])+'</div>'
												+'</td>';
										}

									}
									htmlseq+='</tr>'

							}
				if(er_resourceLimit=='yes')
				{
					htmlseq += '</tbody>'
							+'</table>'
							+'</div> <div style="float:right;padding:10px 0px 5px 0px"><div style="float:left;width:7px;height:7px;background-color:#fb9848;font-size:1px;line-height:1px;margin:4px 10px">&nbsp;</div><div style="float:left;">Limiting Resource</div></div>';
				}

				//


				resultObj.add(
				{
					xtype: 'panel',
					margin:'5 0 10 10',
					html:summaryTable
				},

				{
					xtype:'container',
					//cls:'datapanel',
					border:false,
					//padding:6,
					margin:'0 10 0 10',
					//margin:'7 200 10 200',
					html:htmlseq

				},
				{
					xtype: 'panel',
					html: splitterHtml
				}
				);
			}
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
		}
		else
		{
			resultObj.hide();
 			this.getNomeasurepanel().show();
 		}
	},
	loadTools: function()
	{
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //csv
			true, // fav
			true,// schedule
			false, //diagnosis
			false, //togglebutton
			false, //close
			true //booklet
			);

	},
	changeReportType: function( obj )
	{
		/*var getReportVal = Ext.getCmp('reportype').getValue();
		if ( getReportVal == 'Yes' )
		{
			Ext.getCmp('er_mode').show();
		}
		else
		{
			Ext.getCmp('er_mode').hide();
		}*/
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	afterSettingsRender:function()
	{
	Ext.getCmp('moreOptionCloseId').show();
	var hiddenFields = appConstants.publicJSON['hiddens'];
	var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();
		var ObjectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		ObjectArr['er_excwe'] = screenLabels['reporter.common.excludeweekends'];
		ObjectArr['timeperiodLbl'] = screenLabels['reporter.common.Timeperiod'];
		ObjectArr['fromTimeLbl'] = screenLabels['reporter.common.From'];
		ObjectArr['toTimeLbl'] = screenLabels['reporter.common.To'];
		ObjectArr['fromHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['fromMinsLbl'] = screenLabels['reporter.common.Mins'];
		ObjectArr['toHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['toMinsLbl'] = screenLabels['reporter.common.Mins'];
		//ObjectArr['er_timeline'] = screenLabels['reporter.common.Timeline'];
		//ObjectArr['er_stdate'] = screenLabels['reporter.common.From'];
		//ObjectArr['er_enddate'] = screenLabels['reporter.common.To'];
		//ObjectArr['er_sthr'] = screenLabels['reporter.common.Hr'];
		//ObjectArr['er_endhr'] = screenLabels['reporter.common.Hr'];
		//ObjectArr['er_mode'] = screenLabels['reporter.common.Graph'];
		ObjectArr['reportGeneration'] = screenLabels['reporter.consolidated.reportGeneration'];
		ObjectArr['bgReportName'] = screenLabels['reporter.consolidated.reportName'];
//		Ext.getCmp('submit').setText(screenLabels['reporter.common.SUBMIT']);

		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
				me.validateAndCloseSettings();
		});


		this.loadScreenLabels( settingsForm, ObjectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];
		var excludeWeekCombo = appConstants.publicJSON['excludeWeekCombo'];
		var excludeWeekSelected = selectedData['excludeWeekSelected'];
		if ( !Ext.isEmpty( excludeWeekCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'er_excwe', excludeWeekCombo, excludeWeekSelected);
		}
		var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
		/*if ( !Ext.isEmpty( excludeMsgs ) )
		{
			Ext.getCmp('excludeDays').update(excludeMsgs);
		}
		else
		{
			Ext.getCmp('excludeDays').update('');
		}*/

		settingsForm.findField('timefrom').setValue(selectedData['timePeriodFromHrSelected']);
		settingsForm.findField('minfrom').setValue(selectedData['timePeriodFromMinSelected']);

		settingsForm.findField('timeto').setValue(selectedData['timePeriodToHrSelected']);
		settingsForm.findField('minto').setValue(selectedData['timePeriodToMinSelected']);
		var resourceLimit = selectedData['selectedresourceLimit'];
		if(resourceLimit!=undefined && resourceLimit.toUpperCase()=='YES')
		{
			Ext.getCmp('er_resourceLimit').setValue(true);
		}
		else
		{
			Ext.getCmp('er_resourceLimit').setValue(false);
		}

		var reportGenCombo = appConstants.publicJSON['reportGenCombo'];
		var reportGenSelected = selectedData['reportGenSelected'];
		if ( !Ext.isEmpty( reportGenCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'reportGeneration', reportGenCombo, reportGenSelected);
			this.changeReportGeneration();
		}
		updatingAppSettings();
	},
	showConfigDropdown:function(){

		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			//layout:'vbox',
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'virtualizationcapacityplanningsettings',
					parent:this
				}
			],
			renderTo:'vmcapacityandcpuForm-body'
			});

	},
	afterCapacityFormRender: function()
	{
		this.hideResult();
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJSON['TITLE']);
		var mainForm = this.getVirtualizationcapacityplanningform().getForm();


		var selectedData = appConstants.publicJSON['selectedValues'];
		var reportTypeCombo = appConstants.publicJSON['reportTypeCombo'];
		var reportTypeSelected = selectedData['reportTypeSelected'];
		if ( !Ext.isEmpty( reportTypeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'reportype', reportTypeCombo, reportTypeSelected);
			this.changeReportType();
		}


		//





		var anlyzeCombo = appConstants.publicJSON['anlyzeCombo'];
		var er_optionSelected = selectedData['er_option'];

		if ( !Ext.isEmpty( anlyzeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_option',anlyzeCombo, er_optionSelected);
		}

					var screenLabels = appConstants.publicJSON['screenLabels'];
		if(er_optionSelected!=undefined && er_optionSelected!='Component')
						{
							var comboObject = Ext.getCmp('er_site');
							comboObject.setFieldLabel(screenLabels['reporter.common.' + er_optionSelected]);

						var siteCombo = appConstants.publicJSON['siteCombo'];
						var er_siteSelected = selectedData['er_site'];

							if ( !Ext.isEmpty( siteCombo ) )
								{
									this.setValueWithOptionInList(mainForm, 'er_site', siteCombo, er_siteSelected);
								}
								else
								{
									this.insertNotApplicable(mainForm, 'er_site');
								}
							Ext.getCmp('er_site').show();

						}
						else
						{
						Ext.getCmp('er_site').hide();
						}

			if(er_optionSelected!=null && er_optionSelected=='Zone')
		{

		var subzoneCombo = appConstants.publicJSON['subzoneCombo'];

		var er_includeZones = appConstants.publicJSON['er_includeZones'];
		if ( !Ext.isEmpty( subzoneCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_includezones',subzoneCombo, er_includeZones);
		}
		Ext.getCmp('er_includezones').show();
		}
		else
		{
		Ext.getCmp('er_includezones').hide();
		}



		var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
		var er_comptypeSelected = selectedData['er_comptype'];

		if ( !Ext.isEmpty( compTypeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
		}
		appConstants.rawDataForComponents = appConstants.publicJSON['componentCombo'];
		var componentCombo = appConstants.publicJSON['componentCombo'];
		var er_componentSelected = appConstants.publicJSON['selectedComponentArr'];
		if ( !Ext.isEmpty( componentCombo ) )
		{
			    var  comboObject = Ext.getCmp('er_component');
                comboObject.getStore().loadRawData(componentCombo);
                if (!Ext.isEmpty(er_componentSelected)) {
                    comboObject.setValue(er_componentSelected);
                } else {
                    comboObject.setValue(componentCombo[0].valueField);
                }
		}

		/*var siteCombo = appConstants.publicJSON['siteCombo'];
		//var er_optionSelected = selectedData['er_option'];
		if ( !Ext.isEmpty( siteCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_site',siteCombo, "");
		}*/

		//


		var timelineCombo = appConstants.publicJSON['timelineCombo'];
		var selectedTimeline = selectedData['selectedTimeline'];
		if ( !Ext.isEmpty( timelineCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_timeline', timelineCombo, selectedTimeline);
			this.changeTimeline();
		}

		//settingsForm.findField('er_stdate').setValue(selectedData['startDate']);
		//settingsForm.findField('er_sthr').setValue(selectedData['startHour']);
		//settingsForm.findField('er_enddate').setValue(selectedData['endDate']);
		//settingsForm.findField('er_endhr').setValue(selectedData['endHour']);

		mainForm.findField('er_mode').setValue(selectedData['selectedGraphMode']);

		var startdateObj = mainForm.findField('er_stdate');
		var enddateObj = mainForm.findField('er_enddate');
		var startHourObj = mainForm.findField('er_sthr');
		var endHourObj = mainForm.findField('er_endhr');

		startdateObj.setValue(selectedData['startDateForDisplay']);
	        startdateObj.dataArray =selectedData['startDate'];
	        startHourObj.setValue(selectedData['startHourForDisplay']);
	        startHourObj.dataArray = selectedData['startHour'];
	        enddateObj.setValue(selectedData['endDateForDisplay']);
	        enddateObj.dataArray =selectedData['endDate'];
	        endHourObj.setValue(selectedData['endHourForDisplay']);
	        endHourObj.dataArray = selectedData['endHour'];
	        stmin =selectedData['startMinForDisplay'];
	        enmin = selectedData['endMinForDisplay'];
	        mgr_stmin =selectedData['startmin'];
	        mgr_enmin = selectedData['endmin'];

		var hiddenFields =  appConstants.publicJSON["hiddens"];
       	var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];

			if(!hideBackButton){
				Ext.getCmp('virtualizationcapacityplanningform').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicJSON['ID']
					}
				);
		}
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			this.getResultpanel().removeAll();
			this.getResultpanel().hide();
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ( appConstants.isSubmit == 'true' && from_favorite != "Yes")
		{
			this.getResultpanel().removeAll();
			this.getResultpanel().show();
			if ( selectedData['reportGenSelected'] == 'foreground')
			{
				var resultData = appConstants.publicJSON['RESULTS'];
				if ( !Ext.isEmpty( resultData ) )
				{
					this.getResultpanel().setTitle("<span class='font_bold'>"+resultData['TITLE']+"</span>");
					this.formSubmit(Ext.getCmp('submit'));
					//Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
				}
				else
				{
					this.getResultpanel().add(
						{
							xtype: 'container',
							height: 270,
							html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
						}
					);
				}
			}
			else
			{
				var resultData = appConstants.publicJSON['backgroundResults'];
				this.loadBackground(resultData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.formSubmit(Ext.getCmp('submit'));
			}
		}
	},
	validateAndCloseSettings:function()
	{
		var result = this.validateSettings();
		if ( !result )
		{
			return;
		}
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return result;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.formSubmit(Ext.getCmp('submit'));
		}
	},
	validateSettings: function()
	{
		var isSettingsOk = true;
		var settingsForm = this.getVirtualizationcapacityplanningsettings().getForm();
		var reportgenVal = settingsForm.findField('reportGeneration').getValue();
		if ( reportgenVal!=null && (reportgenVal == 'background' || reportgenVal == 'background-csv'))
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				return false;
			}
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			//var getButtonObj = Ext.getCmp('submit');
			//getButtonObj.setDisabled(false);
			this.generateResult();
		}
		else
		{
			if(!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			var reportNameObj = Ext.getCmp('bgReportName');
			reportNameObj.setValue("");
			reportNameObj.show();
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
	},
	insertNotApplicable: function ( form, fieldName )
	{
		var obj = form.findField(fieldName);
		obj.getStore().removeAll();
		obj.getStore().add({
			'displayField': appConstants.notApplicable,
			'valueField': '-1'
		});
		obj.setValue('-1');
	},
	loadScreenLabels: function ( form, ObjectArr )
	{
		var obj = '';
		for ( var key in ObjectArr )
		{
			obj = !Ext.isEmpty(form.findField(key))?form.findField(key):Ext.getCmp(key);
				if ( obj.getXType() != 'label' )
				{
					form.findField(key).setFieldLabel(ObjectArr[key]);
				}
				else
				{
					Ext.getCmp(key).setText(ObjectArr[key]);
				}

		}
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);

		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
 		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else
			value = appConstants.publicJSON.selectedValues[jsonParam];

 		return value;
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);
    },
    expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
    },
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}

});
