Ext.define('VmToolsReportApp.controller.Main', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	refs : [{
				selector : 'main',
				ref : 'main'
			}, {
				selector : 'newUtilities',
				ref : 'newUtilities'
			}, {
				selector : 'virtualizationresourcesmainform',
				ref : 'virtualizationresourcesmainform'
			},
			{
				selector : 'mainform',
				ref : 'mainform'
			},
			{
				selector : 'backGroundPanel',
				ref : 'backGroundPanel'
			},
			{selector:'nomeasurepanel', ref:'nomeasurepanel'}],
	init : function() {
		this.control({

					'main newUtilities' : {
						'afterrender' : this.hideTools
					},
					'mainform' : {
						'afterrender' : this.loadDefaultData
					},
					'virtualizationresourcesmainform combo[name="analysis"]' : {
						'select' : this.filterAnalysisBy
					},
					'virtualizationresourcesmainform combo[name="Service"]' : {
						'select' : this.doCommonFilter
					},
					'egcomponent button[id="expandSelector"]' : {
						'click' : this.expandMe
					},
					'mainform button[id="expandSelector2"]' : {
						'click' : this.expandMe2
					},
					'virtualizationresourcesmainform combo[name="Segment"]' : {
						'select' : this.doCommonFilter
					},
					'virtualizationresourcesmainform combo[name="Zone"]' : {
						'select' : this.doCommonFilter
					},
					'virtualizationresourcesmainform combo[name="compType"]' : {
						'select' : this.doCommonFilter
					},
					'mainform button[id="submit"]' : {
						'click' : this.showGraph
					},
					'mainform button[name="save"]': {
						'click' : this.add
					},
					'virtualizationresourcesmainform combo[id="reportGeneration"]':{
						'select':this.showHideReportTextbox
					},
					'newUtilities > #favoriteTool > button' : {
						'click' : this.add
					},
					'newUtilities > #scheduleTool > button' : {
						'click' : this.add
					},
					'newUtilities > #saveTool > button' : {
						'click' : this.saveFileTool
					},
					'newUtilities > #printTool > button' : {
						'click' : this.printFile
					},
					'newUtilities > #mailTool > button' : {
						'click' : this.sendMail
					},
					"newUtilities > #csvTool > button": {
						"click": this.saveCsv
					},
					'timeline combo[name="er_mode"]':
					{
							'select': this.changeEr_mode
					},
					'egcomponent trigger[id="compSearch"]':
					{
						'change': this.filterMultiselect
					},
					'criteria trigger[id="criteriaSearch"]':
					{
						'change': this.filterMultiselect
					},
					'mainform button[id="panelinsidetoggle"]': {
						'click': this.toggleForm
					},
					'main button[id="excelToolBtn"]':{
					'click':this.saveExcel
					}
				});
	},
	filterMultiselect: function (obj) {
		var findVal = obj.getValue();
		var compId = obj.getId();

		if(compId=='compSearch')
		{
			compStore = appConstants.rawDataForComponents;
			 compName='components';

		}else 	if(compId=='criteriaSearch')
		{
			compStore = appConstants.rawDataForCriteria;
			 compName='Criteria';
		}

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
	},
	toggleForm:function(obj){
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	changeEr_mode: function (combo) {
		var favorite_id = 'undefined';
		var from_schModify = appConstants.defaultJSON['hiddenFields']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null')) {		return;
		}
		Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		this.showGraph();
	 },
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),'Components',btn);

	},
	expandMe2: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('Criteria'),'Criteria',btn);
	},
	hideTools : function() {

		this.getNewUtilities().loadIcon(true, //save
				true, //print
				true, //mail
				false, //data
				true, //cvs
				true, // fav
				true,// schedule
				false, //daignosis
				false, //togglebutton
				false, //close
				true //booklet
				);
		 Ext.getCmp("scheduleTool").setDisabled(false);
		 Ext.getCmp("favoriteTool").setDisabled(false);

	},
	loadDefaultData : function() {
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		this.getMainform().loadDefaultData(appConstants.defaultJSON);
	if(!appConstants.hideBackButton){
		Ext.getCmp('virtualization_resources').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.defaultJSON['ID']
			}
		);
	}
		if(appConstants.issubmit!=null && appConstants.issubmit=="true")
		{
			this.showGraph();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showGraph();
			}
		}
	},
	filterAnalysisBy : function(thisObj) {

		var virtualformObj = this.getVirtualizationresourcesmainform();
		var form = thisObj.up('.form').getForm();
		var screenLabels = appConstants.defaultJSON.screenlabels;
		this.setNotApplicable(form, 'compType', screenLabels);
		this.setNotApplicable(form,'components', screenLabels);

		var val = thisObj.getValue();

		if (val == 'Zone') {
			form.findField('subzone').show();
			form.findField('Zone').show();
			form.findField('Segment').hide();
			form.findField('Service').hide();
		} else if (val == 'Service') {
			form.findField('subzone').hide();
			form.findField('Zone').hide();
			form.findField('Segment').hide();
			form.findField('Service').show();
		} else if (val == 'Component') {
			form.findField('subzone').hide();
			form.findField('Zone').hide();
			form.findField('Service').hide();
			form.findField('Segment').hide();
		} else {
			form.findField('subzone').hide();
			form.findField('Zone').hide();
			form.findField('Service').hide();
			form.findField('Segment').show();
		}
		var param = 'userID=' + appConstants.userID + '&sessionId=' + appConstants.sessionId+ '&filterComponent=true' + '&er_option=' + thisObj.getValue();
		Ext.getCmp('dtpanel').hide();
		this.filtercombobox('/final/servlet/com.eg.ErVMToolsReportC', val,param, form);
	},
	setNotApplicable : function(form, fieldname, screenLabel) {
		if (fieldname!='components')
		{
			form.findField(fieldname).getStore().removeAll();
			form.findField(fieldname).getStore().loadRawData([{
						"displayField" : screenLabel['reporter.common.Not Applicable'],
						"valueField" : "-1"
					}]);
			form.findField(fieldname).setValue("-1");
		}
		else
		{
			Ext.getCmp(fieldname).getStore().loadRawData([{
					"displayField" : screenLabel['reporter.common.Not Applicable'],
					"valueField" : "-1"
				}]);
			Ext.getCmp(fieldname).setValue("-1");
		}
	},
	filtercombobox : function(url, type, param, form) {
		var loadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Loading ..."
				});
		loadMask.show();
		Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						loadMask.hide();
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);

						if (type == 'Component') {
							var comptype = form.findField('compType');
							comptype.getStore().loadRawData(jsonObject['comptypeCombodata']);
							comptype.setValue(jsonObject['comptypeCombovalue']);

							var component = Ext.getCmp('components');
							component.getStore().loadRawData(jsonObject['compCombodata']);
							appConstants.rawDataForComponents = jsonObject['compCombodata'];
							component.setValue(component.getStore().getAt(0));
							var values = [];

							component.getStore().each(function(re) {
										values.push(re.get('valueField'));
									}, this);
							component.setValue(values);
						} else {
							var combo = form.findField(type);
							combo.getStore().loadRawData(jsonObject);
							combo.setValue(combo.getStore().getAt(0));
						}
					}
				});
	},
	doCommonFilter : function(thisObj) {

		var virtualformObj = this.getVirtualizationresourcesmainform();
		var screenLabels = virtualformObj.screenLabels;
		var form = thisObj.up('.form').getForm();
		var er_option = form.findField('analysis').getValue();
		var val = thisObj.getValue();
		var param = 'userID=' + appConstants.userID + '&sessionId=' + appConstants.sessionId+ '&filterComponent=true' + '&er_option=' + er_option;
		if (thisObj.getName() != 'compType') {

			param += '&er_site=' + encodeURI(val);
			virtualformObj.er_site = val;
		} else {
			param += '&er_comptype=' + val + '&er_site='+ virtualformObj.er_site;
		}
		var loadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Loading ..."
				});
		Ext.getCmp('dtpanel').hide();
		loadMask.show();
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErVMToolsReportC',
					params : param,
					scope : this,
					success : function(response) {
						loadMask.hide();
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						if (thisObj.getName() != 'compType') 
						{
							var comptype = form.findField('compType');
							comptype.getStore().loadRawData(jsonObject['comptypeCombodata']);
							comptype.setValue(jsonObject['comptypeCombovalue']);
						}
						Ext.getCmp('dtpanel').hide();
						var component = Ext.getCmp('components');
						component.getStore().loadRawData(jsonObject['compCombodata']);
						appConstants.rawDataForComponents = jsonObject['compCombodata'];
						component.setValue(component.getStore().getAt(0));
						var values = [];

						component.getStore().each(function(re) {
									values.push(re.get('valueField'));
								}, this);
						component.setValue(values);
					}
				});
	},
	showGraph : function(thisObj) {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var virtualformObj = this.getVirtualizationresourcesmainform();
		var form = Ext.getCmp('virtualization_resources').getForm();
		var er_option = form.findField('analysis').getValue();
		var param = 'er_option=' + er_option;
		if (er_option != null) {
			var er_site = '';
			var includeSubzone;
			if (er_option == 'Service')
			{
				er_site = form.findField('Service').getValue();
			}
			else if (er_option == 'Segment') {
				er_site = form.findField('Segment').getValue();

			} else if (er_option == 'Zone') {
				er_site        = form.findField('Zone').getValue();
				includeSubzone = form.findField('subzone').getValue();
				param+='&includeSubzone='+includeSubzone;
			}

			if (er_site != null && er_site == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : 'Please select a ' + er_option,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}

			param += '&er_site=' + er_site;
		}
		var er_comptype = form.findField('compType').getValue();
		var compType = form.findField('compType').getRawValue();
		param += '&er_comptype=' + er_comptype;
		if (er_comptype == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component type',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		var er_component = Ext.getCmp('components').getValue();
		if (er_component == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		var compParam = "isDafaultSubmit=true&";

		for (var tr in er_component) {
			param += "&er_component=" + er_component[tr];
		}
		var hiddenFields = appConstants.defaultJSON['hiddenFields'];

		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == 'NONE')
				val = '';

			param += '&' + hiddenField + '=' + val;
		}
			var url = ''
			var selectbackground = form.findField('reportGeneration').getValue();

			param += '&er_reportgenration=' + selectbackground;
			if (selectbackground == 'background')
			{
				var bg_reportname = form.findField('bgReportName').getValue();
				var rform =  Ext.widget('reportgeneration');
				var vtext=validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true);

				bg_reportname=checkFileName(bg_reportname);
				param += '&bg_reportname=' + bg_reportname;
				if (vtext==true) {
				 url= '/final/servlet/com.eg.ErStartBackGroundReportC';
				} else {
					return;
				}
			}
			else if (selectbackground == 'background-csv')
			{
				var bg_reportname = form.findField('bgReportName').getValue();
				var rform =  Ext.widget('reportgeneration');
				var vtext=validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true);

				bg_reportname=checkFileName(bg_reportname);
				param += '&bg_reportname=' + bg_reportname;
				if (vtext==true) {
				 url= "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				} else {
					return;
				}
			}
			else
				url = '../servlet/com.eg.ErVMToolsReportC';

		param+= '&er_RmDispName='+appConstants.er_RmDispName
		if(appConstants.issubmit!=null && appConstants.issubmit=="true" && !((selectbackground == 'background')&&(selectbackground == 'background-csv')) && thisObj== 'undefined')
		{
			param = appConstants.qryString;
		}
		var loadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Loading ..."
				});
		var me = this;
		var resultObj = this.getBackGroundPanel();
		loadMask.show();
		Ext.Ajax.request({
					url : url,
					method: 'POST',
					scope : this,
					params: param,
					success : function(response) {
						loadMask.hide();
						var jsonText   =  response.responseText;
						var jsonObject =  Ext.decode(jsonText);
						var reportType =  jsonObject['reportType'];
				if (!Ext.isEmpty(reportType) || reportType != undefined)
				{
					var resultContainerObj = Ext.getCmp('resultContainer');
					resultContainerObj.removeAll();
					resultContainerObj.hide();
					Ext.getCmp('dtpanel').hide();
					var reportValString = jsonObject.reportVal;
					var status = reportValString.status;
					var htmlStr='';
				   if ( status == 'success' )
					{
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>'+reportValString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					else if ( status == 'duplicate' )
					{
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>'+reportValString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					resultObj.update(htmlStr);
					resultObj.show();
				}else{

						var header ='<div id="xenTool" class="newTable" style="margin:10px 0px 0px 0px">';
						var topTable  ="";
						var jsonObject = Ext.decode(response.responseText);
						var resultContainerObj = Ext.getCmp('resultContainer');
						resultContainerObj.removeAll();
						var toolType = jsonObject.toolType;
						if(Ext.isEmpty(jsonObject.toolInstallsVM) && jsonObject.toolInstallsVM!=undefined)
						{
							
							resultContainerObj.hide();
							this.getNomeasurepanel().show();
							Ext.getCmp("bookletTool").setDisabled(true);
							Ext.getCmp("saveTool").setDisabled(true);
							Ext.getCmp("printTool").setDisabled(true);
							Ext.getCmp("mailTool").setDisabled(true);
							Ext.getCmp("excelTool").setDisabled(true);
							Ext.getCmp("csvTool").setDisabled(true);
						}
						else if(er_comptype!=null &&(er_comptype == "Xen_virtual_server"|| er_comptype== "Xen_desktop_server"|| er_comptype=="Citrix XenServer - VDI" || er_comptype=="Citrix XenServer"))
						{
							topTable  = ' <table width="100%"><thead> <tr height="24px"> <th style="padding:4px 5px 4px 5px"></th><th>'+vmsLabel+' '+toolType+' '+toolsByVersionLabel+'</th> <th style="text-align:center;width:120px">'+vmsNumberLabel+'</th> </tr></thead>';

							var tableHtml='<div class="newTable" style="margin:10px"><table align="center" valign="middle"><col width="80%"><col width="20%">';
							tableHtml+='<thead><tr>';
							tableHtml+='<th>';
							tableHtml+=summaryLabel;
							tableHtml+='</th>';
							tableHtml+='<th>';
							tableHtml+=vmsNumberLabel;
							tableHtml+='</th>';
							tableHtml+='</tr></thead>';
							tableHtml+='<tbody>';

							tableHtml+='<tr>';
							tableHtml+='<td>'+vmsTotalNumberLabel+'</td>';
							tableHtml+='<td style="text-align:center">'+this.getDecimalAlignFormat(jsonObject.totalNoOfVMs)+'</td>';
							tableHtml+='</tr>';

							tableHtml+='<tr>';
							tableHtml+='<td>'+vmsWithLabel+' '+toolType+' '+toolsInstalledLabel+'</td>';
							tableHtml+='<td style="text-align:center">'+this.getDecimalAlignFormat(jsonObject.toolInstallsVM)+'</td>';
							tableHtml+='</tr>';

							tableHtml+='<tr>';
							tableHtml+='<td>'+vmsWithLabel+' '+toolType+' '+toolsNotInstalledLabel+'</td>';
							tableHtml+='<td style="text-align:center">'+this.getDecimalAlignFormat(jsonObject.notToolInstalledCnt)+'</td>';
							tableHtml+='</tr>';
							tableHtml+='</tbody>';
							tableHtml+='</table>';

							tableHtml+='</div>';

						var versionInfo          = jsonObject.hmToolVersion;
						var versionDetails       = jsonObject.hmToolVersionDetails;
						var uptoDateToolList     = jsonObject.uptoDateToolList;
						var notUptoDateToolList  = jsonObject.notUptoDateToolList;
						var notInstalledToolList = jsonObject.notToolInstalledList;

						var rowID = 0;
						for (var toolVersion in versionInfo)
						{
							if (versionInfo.hasOwnProperty(toolVersion))
							{
								var toolCnt = versionInfo[toolVersion];
								var toolVersionCnt = '<tr> <td nowrap style="width:35px;padding:4px 5px 4px 5px;text-align:center;"> <div style="cursor:pointer;display:inline-block;"> <div class="iconTreeExpand" id="data_'+rowID+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px"></div></div></td><td><div style="float:left;">'+toolVersion+'</div></div></td><td style="text-align:center;"> <div>'+this.getDecimalAlignFormat(toolCnt)+'</div></td></tr><tr id="child_tr'+rowID+'_undefined" style="display:none;"> <td colspan="3"> <div class="newTable" style="margin:10px;"> <table width="100%"> <col width="80%"> <col width="20%"><thead> <tr> <th nowrap > <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th> <th nowrap> <div>'+isUpToDateLabel+'</div></th> </tr></thead> <tbody>';
								var details= versionDetails[toolVersion];
								var toolDetail      = '';
									for(var i=0;i<details.length;i++){
										var tmpToolDetail = details[i].split('@#');
										toolDetail+='<tr nowrap> <td> <div nowrap style="float:left;width:400px;" >'+tmpToolDetail[0]+' </div></td><td> <div>'+tmpToolDetail[1]+'</div></td><td> <div>'+tmpToolDetail[3]+'</div></td></tr>'
									}
									topTable += (toolVersionCnt+toolDetail)+'</tbody></table>';
							}
							rowID++;
						}
						var uptoDateExpandIncon = 'class="iconTreeExpand"';
						 if(uptoDateToolList==undefined || uptoDateToolList.length==0)
							 uptoDateExpandIncon='';


						var uptodateTool= '<tr> <td nowrap style="width:35px;padding:4px 5px 4px 5px;text-align:center;"> <div style="cursor:pointer;display:inline-block"> <div '+uptoDateExpandIncon+' id="data_'+rowID+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px;"></div></div></td><td>  <div style="float:left;">'+toolType+' '+toolsUpToDateLabel+'</div></td><td> <div>'+this.getDecimalAlignFormat(jsonObject.updateToolCnt)+'</div></td></tr><tr id="child_tr'+rowID+'_undefined" style="display:none;"> <td colspan="3"> <div class="newTable" style="margin:10px;"> <table width="100%"> <col width="60%"> <col width="20%"><col width="20%"> <thead> <tr> <th> <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th> <th> <div>'+versionLabel+'</div></th> </tr></thead> <tbody>';

						  var toolUptodateDetail='';
						   if(uptoDateToolList!=undefined )
							{
								for (var j=0;j<uptoDateToolList.length;j++) {
								 var element =uptoDateToolList[j].split("@#");
								toolUptodateDetail +='<tr> <td nowrap> <div nowrap style="float:left;width:400px;" >'+element[0]+'</div></td><td> <div>'+element[1]+'</div></td><td> <div>'+element[2]+'</div></td></tr>';
							  }
						   }
						  
						var totalUptoDateSum = uptodateTool+toolUptodateDetail+'</tbody></table>';

						  rowID++;

					   var notUptodateToolExpandIncon = 'class="iconTreeExpand"';
					   if(notUptoDateToolList==undefined||notUptoDateToolList.length==0)
						   notUptodateToolExpandIncon='';

					   var notUptodateTool	= '<tr> <td nowrap style="width:35px;padding:4px 5px 4px 5px;text-align:center;"><div style="cursor:pointer;display:inline-block"> <div '+notUptodateToolExpandIncon+' id="data_h" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px;"></div></div></td><td><div style="float:left;">'+toolType+' '+toolsNotUpToDateLabel+'</div></td><td> <div>'+this.getDecimalAlignFormat(jsonObject.notUptoDateToolCnt)+'</div></td></tr><tr id="child_trh_undefined" style="display:none;"> <td colspan="3"> <div class="newTable" style="margin:10px;"> <table width="100%"><col width="60%"> <col width="20%"><col width="20%"> <thead> <tr> <th> <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th> <th> <div>'+versionLabel+'</div></th> </tr></thead> <tbody>';

						  var notUptoDateDetail='';
						  if(notUptoDateToolList!=undefined)
							{
							  for (var k=0;k<notUptoDateToolList.length;k++) {
									 var element =notUptoDateToolList[k].split("@#");
									notUptoDateDetail +='<tr> <td nowrap> <div style="float:left;">'+element[0]+'</div></td><td> <div>'+element[1]+'</div></td><td> <div>'+element[2]+'</div></td></tr>';
								 }
							  }
						var totalNotUptoDateSum = notUptodateTool+notUptoDateDetail+'</tbody></table>';

					var notInstalledExpandIncon = 'class="iconTreeExpand"';
					if(notInstalledToolList==undefined||notInstalledToolList.length==0)
						notInstalledExpandIncon='';

						 var notInstalled= '<tr> <td nowrap style="width:35px;padding:4px 5px 4px 5px;text-align:center;"> <div style="cursor:pointer;display:inline-block"> <div '+notInstalledExpandIncon+' id="data_j" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px;"></div></div></td><td><div style="float:left;">'+toolType+' '+toolsNotInstalledLabel+'</div></td><td> <div>'+this.getDecimalAlignFormat(jsonObject.notToolInstalledCnt)+'</div></td></tr><tr id="child_trj_undefined" style="display:none;"> <td colspan="3"> <div class="newTable" style="margin:10px;"> <table width="100%"> <col width="80%"> <col width="20%"> <thead> <tr> <th> <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th>  </tr></thead> <tbody>';

						var notInstalledDetail='';
						if(notInstalledToolList!=undefined)
						{
							for (var k=0;k<notInstalledToolList.length;k++) 
							{
								var element =notInstalledToolList[k].split("@#");
								notInstalledDetail +='<tr> <td nowrap> <div style="float:left;">'+element[0]+'</div></td><td> <div>'+element[1]+'</div></td></tr>';
							 }
						}
						var totalNotInstalledSum = notInstalled+notInstalledDetail+'</tbody></table>';
						topTable = header+topTable+'</table></div>';

						var secondTable =tableHtml+'<br/><div class="newTable" id="xenTool"><table style="width:100%"><thead> <tr height="24px"> <th style="padding:4px 5px 4px 5px"></th> <th>'+vmsLabel+' '+toolType+' '+toolsByStatusLabel+'</th> <th style="text-align:center;width:120px">'+vmsNumberLabel+'</th> </tr></thead>'+totalUptoDateSum+totalNotUptoDateSum+totalNotInstalledSum+'</table></div>'
						var ii=secondTable+topTable;
						resultContainerObj.show();
						resultContainerObj.setTitle(toolType+' '+toolsDetailsLabel);
						resultContainerObj.add({xtype:'panel',margin:'0 10 10 10',html:ii});

					loadMask.hide();

					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("excelTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);
				}
				else 
				{
					var tableHtml='<div class="newTable" style="margin:10px"><table align="center" valign="middle" ><col width="80%"><col width="20%">';
					tableHtml+='<thead><tr>';
					tableHtml+='<th>';
					tableHtml+=summaryLabel;
					tableHtml+='</th>';
					tableHtml+='<th>';
					tableHtml+=vmsNumberLabel;
					tableHtml+='</th>';
					tableHtml+='</tr></thead>';
					tableHtml+='<tbody>';

					tableHtml+='<tr>';
					tableHtml+='<td>'+vmsTotalNumberLabel+'</td>';
					tableHtml+='<td>'+jsonObject.totalNoOfVM+'</td>';
					tableHtml+='</tr>';

					tableHtml+='<tr>';
					tableHtml+='<td>'+vmsWithLabel+' '+toolType+' '+toolsInstalledLabel+'</td>';
					tableHtml+='<td>'+jsonObject.totalInstalled+'</td>';
					tableHtml+='</tr>';

					tableHtml+='<tr>';
					tableHtml+='<td>'+vmsWithLabel+' '+toolType+' '+toolsNotInstalledLabel+'</td>';
					tableHtml+='<td>'+jsonObject.NotInstalleds+'</td>';
					tableHtml+='</tr>';
					tableHtml+='</tbody>';

					tableHtml+='</table>';
					tableHtml+='</div>';

				//	tableHtml+='<br>';

					var NotRunning = jsonObject.NotRunning; 
					var Running = jsonObject.Running; 
					//var Starting = jsonObject.Starting; 
					var NotInstalled = jsonObject.NotInstalled; 
					var OutofDate = jsonObject.OutofDate;
					var rowID = 0;
					var hypName="";
					if (er_component!=null)
					{
						hypName = er_component.toString().substring(0,er_component.toString().indexOf(":"));
					}
						var RunExpandIcon = 'class="iconTreeExpand"';
						if(Running.length==0)
							RunExpandIcon='';

						var RunTool= '<tr> <td> <div> <div style="cursor:pointer;"> <div '+RunExpandIcon+' id="data_'+rowID+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px"></div></div><div style="float:left;">'+toolType+' '+toolsRunningLabel+'</div></div></td><td> <div>'+jsonObject.Runnings+'</div></td></tr><tr id="child_tr'+rowID+'_undefined" style="display:none;"> <td colspan="2"> <div class="newTable" style="margin:10px;"> <table width="100%"> <col width="80%"> <col width="20%"> <thead> <tr> <th> <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th>  </tr></thead> <tbody>';

						var RuntoolDetails='';
						for (var j=0;j<Running.length;j++)
						{
							var element =Running[j];
							for(var key in element)
							{
								RuntoolDetails +='<tr> <td nowrap> <div nowrap style="float:left;width:400px;" >'+key+'</div></td><td> <div>'+element[key]+'</div></td></tr>';
							}
						}
						var RunTable = RunTool+RuntoolDetails+'</tbody></table>';
						var NotRunExpandIcon = 'class="iconTreeExpand"';
						if(NotRunning.length==0)
							NotRunExpandIcon='';

						var NotRunTool= '<tr> <td> <div> <div style="cursor:pointer;"> <div '+NotRunExpandIcon+' id="data_n'+rowID+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px"></div></div><div style="float:left;">'+toolType+' '+toolsNotRunningLabel+'</div></div></td><td> <div>'+jsonObject.NotRunnings+'</div></td></tr><tr id="child_trn'+rowID+'_undefined" style="display:none;"> <td colspan="2"> <div class="newTable" style="margin:10px;"> <table width="100%"> <col width="80%"> <col width="20%"> <thead> <tr> <th> <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th>  </tr></thead> <tbody>';

						var NotRuntoolDetails='';
						for (var j=0;j<NotRunning.length;j++)
						{
							var element =NotRunning[j];
							for(var key in element)
							{
								NotRuntoolDetails +='<tr> <td nowrap> <div nowrap style="float:left;width:400px;" >'+key+'</div></td><td> <div>'+element[key]+'</div></td></tr>';
							}
						}
						  var NotRunTable = NotRunTool+NotRuntoolDetails+'</tbody></table>';
								/*var startingExpandIcon = 'class="iconTreeExpand"';
						if(Starting.length==0)
							startingExpandIcon='';

						var StartingTool= '<tr> <td> <div> <div style="cursor:pointer;"> <div '+startingExpandIcon+' id="data_b'+rowID+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px"></div></div><div style="float:left;">'+toolType+' Tools Starting</div></div></td><td> <div>'+jsonObject.Startings+'</div></td></tr><tr id="child_trb'+rowID+'_undefined" style="display:none;"> <td colspan="2"> <div class="x-table-tree" style="margin:10px;"> <table> <col width="80%"> <col width="20%"> <thead> <tr> <th> <div>VM Name</div></th> <th> <div>Hypervisor Name</div></th>  </tr></thead> <tbody>';
						var StartingtoolDetails='';
						for (var j=0;j<Starting.length;j++)
						{
							var element =Starting[j];
							for(var key in element)
							{
								StartingtoolDetails +='<tr> <td nowrap> <div nowrap style="float:left;width:400px;" >'+key+'</div></td><td> <div>'+element[key]+'</div></td></tr>';
							}
						}
								var startingTable = StartingTool+StartingtoolDetails+'</tbody></table>';*/
						var NotInstalledExpandIcon = 'class="iconTreeExpand"';
						if(NotInstalled.length==0)
							NotInstalledExpandIcon='';

						var NotInstalledTool= '<tr> <td> <div> <div style="cursor:pointer;"> <div '+NotInstalledExpandIcon+' id="data_v'+rowID+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px"></div></div><div style="float:left;">'+toolType+' '+toolsNotInstalledLabel+'</div></div></td><td> <div>'+jsonObject.NotInstalleds+'</div></td></tr><tr id="child_trv'+rowID+'_undefined" style="display:none;"> <td colspan="2"> <div class="newTable" style="margin:10px;"> <table width="100%"> <col width="80%"> <col width="20%"> <thead> <tr> <th> <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th>  </tr></thead> <tbody>';

						  var NotIstalledtoolDetails='';
						for (var j=0;j<NotInstalled.length;j++)
						{
							var element =NotInstalled[j];
							for(var key in element)
							{
								NotIstalledtoolDetails +='<tr> <td nowrap> <div nowrap style="float:left;width:400px;" >'+key+'</div></td><td> <div>'+element[key]+'</div></td></tr>';
							}
						}
						var NotInstalledTable = NotInstalledTool+NotIstalledtoolDetails+'</tbody></table>';
						var OutofDateExpandIcon = 'class="iconTreeExpand"';
						if(OutofDate.length==0)
							OutofDateExpandIcon='';

						var OutofDateTool= '<tr> <td> <div> <div style="cursor:pointer;"> <div '+OutofDateExpandIcon+' id="data_c'+rowID+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-top:0px;margin-right:2px"></div></div><div style="float:left;">'+toolType+' '+toolsOutOfDateLabel+'</div></div></td><td> <div>'+jsonObject.OutofDates+'</div></td></tr><tr id="child_trc'+rowID+'_undefined" style="display:none;"> <td colspan="2"> <div class="newTable" style="margin:10px;"> <table width="100%"> <col width="80%"> <col width="20%"> <thead> <tr> <th> <div>'+vmNameLabel+'</div></th> <th> <div>'+hypervisorNameLabel+'</div></th>  </tr></thead> <tbody>';

						  var OutOfDatetoolDetails='';
						for (var j=0;j<OutofDate.length;j++)
						{
							var element =OutofDate[j];
							for(var key in element)
							{
								OutOfDatetoolDetails +='<tr> <td nowrap> <div nowrap style="float:left;width:400px;" >'+key+'</div></td><td> <div>'+element[key]+'</div></td></tr>';
							}
						}
						  var OutofDateTable = OutofDateTool+OutOfDatetoolDetails+'</tbody></table>';

					var secondTable =tableHtml+'<br/><div class="newTable" id="xenTool"><table width="100%"> <col width="80%"> <col width="20%"><thead> <tr height="24px" > <th>'+vmsLabel+' '+toolType+' '+toolsByStatusLabel+'</th> <th>'+vmsNumberLabel+'</th> </tr></thead>'+RunTable+NotRunTable+OutofDateTable+NotInstalledTable+/*startingTable+*/'</table></div>';
					var vensarTable=secondTable;
					resultContainerObj.show();
					resultContainerObj.setTitle(toolType+' '+toolsDetailsLabel);
					resultContainerObj.add({xtype:'panel',margin:'0 10 10 10',html:vensarTable});
					loadMask.hide();

					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("excelTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);
				}
			}
		}
	});
},
showHideReportTextbox : function(combo, records, eOpts){

		var form = combo.up('.form').getForm();
		var reporttextbox = form.findField('bgReportName');
		if(combo.getValue()=='background')
		  reporttextbox.show();
		else if (combo.getValue()=='background-csv')
		  reporttextbox.show();
		else
		  reporttextbox.hide();

	},
add : function(button) {
		var virtualformObj = this.getVirtualizationresourcesmainform();
		var form = virtualformObj.getForm();

		var er_option = form.findField('analysis').getValue();
		var param = 'er_option=' + er_option;
		if (er_option != null) {
			var er_site = '';
			var subzone = '';
			if (er_option == 'Service') {
				er_site = form.findField('Service').getValue();
			} else if (er_option == 'Segment') {
				er_site = form.findField('Segment').getValue();
			} else if (er_option == 'Zone') {
				er_site = form.findField('Zone').getValue();
				subzone = form.findField('subzone').getValue();
			}

			if (er_site != null && er_site == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : 'Please select a ' + er_option,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			param += '&er_site=' + er_site+'&subzone='+subzone;
		}
		var er_comptype = form.findField('compType').getValue();
		param += '&er_comptype=' + er_comptype;
		if (er_comptype == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component type',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		var er_component = Ext.getCmp('components').getValue();

		if (er_component == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		var compParam = "";

		for (var tr in er_component) {
			compParam += "&er_component=" + er_component[tr];
		}
		var hiddenFields = appConstants.defaultJSON['hiddenFields'];
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == 'NONE')
				val = '';

			param += '&' + hiddenField + '=' + val;
		}

		param += '&enableBack=true&userID='
				+ appConstants.userID
				+ '&sessionId='
				+ appConstants.sessionId
				+ compParam;

		var url = "";
		var windowClass;
		var frameId;
		var fromFavoriteModify = appConstants.defaultJSON['hiddenFields']["fromFavoriteModify"];
		if ((button.getId() == "scheduleImg" || button.getId() == "save") && (fromFavoriteModify == null))
		{
			url = "/final/reporter/ErSaveSchedule.jsp?" + param +"&com.eg.CSRF_NONCE="+csrfToken;
			if ( button.getId() == "save")
			{
				document.location=url+'&showSchWindow=no';
			} else {
				parent.scheduleWindowFn(url);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}

		}
		else{ 
			var favorite_id = appConstants.defaultJSON['hiddenFields']["favorite_id"];
			if ( button.getId() == "save")
			{
				 url = "../servlet/com.eg.ErFavoriteC?cmd=client&"+ param +"&com.eg.CSRF_NONCE="+csrfToken;
				document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
			} else {
					url = "../servlet/com.eg.ErFavoriteC?cmd=client&"+ param+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
				parent.favouriteWindowFn(url);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
		}
		var target = url;
	},
	saveFileTool : function(){

		var er_site   = '';
		var subzone = '';
	   var er_option =Ext.getCmp("analysis").getValue();

			if (er_option == 'Service') {
				er_site = Ext.getCmp("Service").getValue();

			} else if (er_option == 'Segment') {
				er_site = Ext.getCmp("Segment").getValue();

			} else if (er_option == 'Zone') {
				er_site        = Ext.getCmp("Zone").getValue();
				subzone        = Ext.getCmp('subzone').getValue();
			}
		var param='&pdfprint=yes&er_width=450&er_height=250';

		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + param
				+ "&er_view=PRINT ";
		 if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var er_site   = '';
		var subzone = '';
		var er_option =Ext.getCmp("analysis").getValue();
		if (er_option == 'Service') {
			er_site = Ext.getCmp("Service").getValue();
		} else if (er_option == 'Segment') {
			er_site = Ext.getCmp("Segment").getValue();
		} else if (er_option == 'Zone') {
			er_site        = Ext.getCmp("Zone").getValue();
			subzone        = Ext.getCmp('subzone').getValue();
		}
		var param='&pdfprint=yes&er_width=450&er_height=250';
		var s_qryString = param + "&er_view=PRINT ";
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var virtualformObj = this.getVirtualizationresourcesmainform();
		var form = virtualformObj.getForm();

		var er_option = form.findField('analysis').getValue();
		bookletquery+= 'er_option=' + er_option;
		if (er_option != null) {
			var er_site = '';
			var subzone = '';
			if (er_option == 'Service') {
				er_site = form.findField('Service').getValue();
			} else if (er_option == 'Segment') {
				er_site = form.findField('Segment').getValue();
			} else if (er_option == 'Zone') {
				er_site = form.findField('Zone').getValue();
				subzone = form.findField('subzone').getValue();
			}

			if (er_site != null && er_site == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : 'Please select a ' + er_option,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			bookletquery += '&er_site=' + er_site+'&subzone='+subzone;
		}
		var er_comptype = form.findField('compType').getValue();
		bookletquery += '&er_comptype=' + er_comptype;
		if (er_comptype == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component type',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		var er_component = Ext.getCmp('components').getValue();

		if (er_component == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please select a Component',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		for (var tr in er_component) {
			bookletquery += "&er_component=" + er_component[tr];
		}
		var hiddenFields = appConstants.defaultJSON['hiddenFields'];
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == 'NONE')
				val = '';

			bookletquery += '&' + hiddenField + '=' + val;
		}

		bookletquery += '&enableBack=true&userID='+ appConstants.userID+ '&sessionId='+ appConstants.sessionId;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile : function(){
	   var er_site   = '';
	   var subzone   = ''
	   var er_option =Ext.getCmp("analysis").getValue();

			if (er_option == 'Service') {
				er_site = Ext.getCmp("Service").getValue();

			} else if (er_option == 'Segment') {
				er_site = Ext.getCmp("Segment").getValue();

			} else if (er_option == 'Zone') {
				er_site        = Ext.getCmp("Zone").getValue();
				subzone        = Ext.getCmp('subzone').getValue();
			}
			var s_qryString='/final/reporter/ErXenToolstReportPrint.jsp?'
			s_qryString+="er_comptype="+Ext.getCmp('compType').getRawValue()+"+&er_RmDispName="+appConstants.er_RmDispName+"&pageWidthProces=700&pdfPrint=yes&";
			s_qryString+="&er_option="+Ext.getCmp("analysis").getValue()+"&er_site="+er_site+"&subzone="+subzone;
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
  },
	sendMail : function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveExcel:function(){
		window.location="../servlet/com.eg.ErVMToolsReportC?er_view=Excel&er_comptype="+Ext.getCmp('compType').getValue();
	},saveCsv:function(){
		window.location='../servlet/com.eg.ErVMToolsReportC?er_view=CSV';
	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});
