//------------------------------------------------------------------
// er_ajaxRequest.js is common JS for Ajax Data Process
//------------------------------------------------------------------

/**
 * Returns a new XMLHttpRequest object, or false if this browser
 * doesn't support it
 */
function newXMLHttpRequest()
{
	var xmlreq = false;
	if (window.XMLHttpRequest)
	{
		// Create XMLHttpRequest object in non-Microsoft browsers
		xmlreq = new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		// Create XMLHttpRequest via MS ActiveX
		try
		{
			// Try to create XMLHttpRequest in later versions
			// of Internet Explorer
			xmlreq = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e1)
		{
			// Failed to create required ActiveXObject
			try {
				// Try version supported by older versions
				// of Internet Explorer
				xmlreq = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e2) {
				// Unable to create an XMLHttpRequest with ActiveX
			}
		}
	}
	if (!xmlreq) {
		alert('Giving up : Cannot create an XMLHTTP instance');
	}
	return xmlreq;
}

/**
 * Process request data.
 * url         - server location and file name
 * params      - request parameters
 * elementName - data load object name.
 * callback method - callbackFunction(responseText,responseXML, elementName);
 */
function process(url, params, elementName, callbackFunction)
{
	// Obtain an XMLHttpRequest instance
	var xmlHttp = newXMLHttpRequest();

	// Open an HTTP POST connection to the shopping cart servlet.
	// Third parameter specifies request is asynchronous.
	xmlHttp.open('POST', url, true);

	// Specify that the body of the request contains form data
	xmlHttp.setRequestHeader('Content-type','application/x-www-form-urlencoded;charset=UTF-8;');
	xmlHttp.setRequestHeader('Accept', 'text/xml, application/xml, text/plain');
	xmlHttp.setRequestHeader('Content-length',params.length);
	xmlHttp.setRequestHeader('Connection','close');
	
	// Set the handler function to receive callback notifications
	// from the request object
	xmlHttp.onreadystatechange = getReadyStateHandler(xmlHttp, elementName, callbackFunction);

	// Send form encoded data
	xmlHttp.send(params);
}


/*
 * Returns a function that waits for the specified XMLHttpRequest
 * to complete, then passes its XML response
 * to the given handler function.
 * xmlHttp - The XMLHttpRequest whose state is changing
 * responseXmlHandler - Function to pass the XML response to
 */
function getReadyStateHandler(xmlHttp, elementName, callbackFunction)
{
	// wait for request to be complete and then process returned data
	return function()
	{
		// If the request's status is "complete"
		if (xmlHttp.readyState == 4)
		{
			// when readyState is 4 (done), we also read the server response
			// continue only if HTTP status is "OK"
			if (xmlHttp.status == 200)
			{
				try
				{
					//read the message from the server
					//alert(xmlHttp.responseText+"\n"+xmlHttp.responseXML+"\n"+xmlHttp.responseXML.xml);
					// call the function to deal with the server response
					var functionToCall = callbackFunction
						+ '(xmlHttp.responseText, xmlHttp.responseXML, elementName)';
					eval(functionToCall);
				}
				catch(err)
				{
					// display error message
					alert("Error reading the response : " + err.toString()
						+ "\nError is "  + err.description
						+ " \nError number is " + err.number);
				}
			}
			else
			{
 				// display status message
				var functionToCall = callbackFunction
						+ '(xmlHttp.responseText, xmlHttp.responseXML, elementName)';
				//alert("HTTP status : "+xmlHttp.statusText +"\n HTTP Error  : "+xmlHttp.status);
			}
		}
	}

}

/**
 * Returns the results of XMLHttpRequest.getAllResponseHeaders().
 * Only available after a response has been returned
 */
function getAllResponseHeaders(xmlHttp)
{
	if (xmlHttp.xmlHttpRequest!=null) {
		if (xmlHttp.responseReceived) {
			return xmlHttp.xmlHttpRequest.getAllResponseHeaders();
		} else {
			alert("Cannot getAllResponseHeaders because a response has not yet been received");
		}
	}
}

/**
 * Returns the the value of a response header as returned by 
 * XMLHttpRequest,getResponseHeader().
 * Only available after a response has been returned
 */
function getResponseHeader(headerName)
{
	if (xmlHttp.xmlHttpRequest!=null) {
		if (xmlHttp.responseReceived) {
			return xmlHttp.xmlHttpRequest.getResponseHeader(headerName);
		} else {
			alert("Cannot getResponseHeader because a response has not yet been received");
		}
	}
}
