var drillDownParams='';
Ext.apply(Ext.form.VTypes, {
	mail_id_validation: function(value, field)
	{
		var flag = true;
		if(checkmail(value)!=true)
		{
			field.vtypeText=_checkmail;
			flag = false;
		}
		return flag;		
	}
});
Ext.define('utilities.SendMail', {
    extend: 'Ext.window.Window',
    alias: 'widget.sendmail',
    title: 'SEND MAIL',
	width:600,
	modal:true,
	ghost:true,
	resizable:false,
	closeAction:'destroy',
	id:'mailtosend',
    items: [{
			xtype: 'form',
			id : 'mailForm',
			layout: 'vbox',
			padding: 10,
			bodyStyle: {
				'background': 'none'
        },
        defaults: {
            cls: 'textbox',
            labelAlign: 'left',
            xtype: 'textfield',
            width: 540
        },
        items: [{
            fieldLabel: '<b>To</b>',
			vtype:'mail_id_validation',
            allowBlank: false,
			labelSeparator:'',
		name : 'to',
			id : 'to',
			msgTarget:'side'
        }, {
            fieldLabel: '<b>CC</b>',
			name : 'cc',
			id : 'cc',
			labelSeparator:'',
			vtype:'mail_id_validation',
			msgTarget:'side'
        }, {
            fieldLabel: '<b>BCC</b>',
			name : 'bcc',
			id: 'bcc',
			labelSeparator:'',
			vtype:'mail_id_validation',
			msgTarget:'side'
        }, {
            fieldLabel: '<b>Subject</b>',
            allowBlank: false,
			name : 'subject',
			id : 'subject',
			labelSeparator:'',
			msgTarget:'side'
        }],
        buttons: [{
            text: 'Submit',
            ui:'newButtonSmall',
            handler: function () {
                var form = this.up('form').getForm();
                if (form.isValid()) {
				this.disable();
				   var params = form.getValues(true);
				   Ext.Ajax.on('beforerequest', function(connection,options){
					Ext.getBody().mask('Sending Mail...');
					});
					Ext.Ajax.on('requestcomplete', function(connection,options){
					Ext.getBody().unmask();
					});
					Ext.Ajax.on('requestexception', function(connection,options){
					Ext.getBody().unmask();
					});
				   Ext.Ajax.request(
					{
						url : '/final/servlet/com.eg.ErSendMail?responseType=json&'+params,
						scope:this,
						timeout: 180000,
						success: function(response){
							
							var jsonText = response.responseText;
						
							var jsonData=Ext.decode(jsonText);
							if(!Ext.isEmpty(jsonData))
							{
								this.hide();
								var errorMsg = jsonData.v_error.mailErrorMsg;
								if(errorMsg == "success")
								{									
									Ext.Msg.show({
									title:'Mail Status',
									 msg: 'Mail sent successfully',
									buttons: Ext.Msg.OK,
									icon: Ext.Msg.INFO
									});
									this.show();
									this.up('#mailtosend').close();
								}
								else
								{
									//Ext.Msg.alert("Mail Status",errorMsg);
									Ext.Msg.show({
									title:'Mail Status',
									 msg: errorMsg,
									buttons: Ext.Msg.CANCEL,
									icon: Ext.Msg.ERROR
									});
									this.show();
									this.setDisabled(false);
									
								}
							};
							
						},
						failure: function(response)
						{
							this.hide();
							//	alert(response);
							var jsonText = response.responseText;
							if(jsonText != null && jsonText !="undefined")
							{
							//	alert(jsonText);	
								if(Ext.isEmpty())
								{
									var jsonData=Ext.decode(jsonText);
									var errorMsg = jsonData.v_error.mailErrorMsg;
									//Ext.Msg.alert("Mail Status",errorMsg);
									Ext.Msg.show({
									title:'Mail Status',
									 msg: errorMsg,
									buttons: Ext.Msg.CANCEL,
									icon: Ext.Msg.ERROR
								 });
								this.show();
								this.enable();
								}
							}
							else
							{
								Ext.Msg.show({
									title:'Mail Status',
									 msg: 'Unable to connect Mail Server',
									buttons: Ext.Msg.CANCEL,
									icon: Ext.Msg.ERROR
									
								 });
								 this.show();
								 this.enable();
							}

						},
						callback: function(options, success, response){
							//alert('The Callback function was called.');
                            //alert('Successful Request? ' + success);
							//Ext.getCmp('mailtosend').destory();
						}
					});
			   }
			   else
				{		
				   var subject = Ext.getCmp("subject").getValue();
				   var to = Ext.getCmp("to").getValue();
				   var cc = Ext.getCmp("cc").getValue();
				   var bcc = Ext.getCmp("bcc").getValue();
				   if(checkmail(to)!=true || checkmail(cc)!=true || checkmail(bcc)!=true)
					{
						Ext.Msg.show({
						title:'Alert',
						 msg: _checkmail,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					 });
						return false;
					}
					if(!checkblank(subject))
					{
						Ext.Msg.show({
						title:'Alert',
						 msg: _checkempty,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					 });
						return false;
					}
					
				}
            }
        }]
    }],
    initComponent : function()
    {
    	var params = drillDownParams;
    	if ( Ext.isEmpty( params ) )
    	{
    		params = '';
    	}
    	Ext.Ajax.request(
		{
			url : '/final/reporter/ErSendMailJson.jsp',
			params: params,
			scope:this,
			success: function(response){
				
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				
				this.loadFldLabels(jsonData);
				drillDownParams = '';
			}
		});
    	this.callParent();
    },
	loadFldLabels :  function(jsonData)
	{
		var toField=Ext.getCmp("to");
		var ccField=Ext.getCmp("cc");
		var bccField=Ext.getCmp("bcc");
		var subjectField=Ext.getCmp("subject");

		toField.setFieldLabel(jsonData.screenLabels['reporter.common.To']);
		ccField.setFieldLabel(jsonData.screenLabels['reporter.common.CC']);
		bccField.setFieldLabel(jsonData.screenLabels['reporter.common.BCC']);
		subjectField.setFieldLabel(jsonData.screenLabels['reporter.common.Subject']);

		this.setTitle(jsonData.screenLabels['reporter.common.SEND MAIL']);

		if(jsonData.hasOwnProperty('hiddenParams'))
		{
			var me = Ext.getCmp('mailForm');
			var frmObj = Ext.getCmp('mailForm').getForm();
			var hiddenFields = jsonData.hiddenParams;
			for (var hiddenField in hiddenFields) {
				if (!frmObj.findField("'" + hiddenField + "'")) {
					me.add({
							xtype : 'hidden',
							name : hiddenField,
							value : hiddenFields[hiddenField]
							});
				}
				else
				{
					frmObj.findField("'" + hiddenField + "'").setValue(hiddenFields[hiddenField]);
				}
			}
		}
	}

});